
#include <sys/types.h>
#include <sys/uio.h>

int writev(int fd, const struct iovec *vector, size_t count)
{
	int	i, rc, total;

	for (total = 0, i = 0; (i < count); i++) {
		rc = write(fd, vector[i].iov_base, vector[i].iov_len);
		if (rc != vector[i].iov_len) {
			total = -1;
			break;
		}
		total += rc;
	}
	return(total);
}

