/*  $Header: /proj/software/pub/CVSROOT/uClinux/uC-src/intersil-tools/setoid.c,v 1.3 2003/03/21 23:19:41 mrustad Exp $
 *  
 *  Copyright (C) 2002 Intersil Americas Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <errno.h>
#include <unistd.h>
#include <netinet/in.h>

#include "prismoids.h"

#define TI_MAC           1
#define TI_LONG          2
#define TI_STRING        3
#define TI_SSID          4
#define TI_VDCF          5
#define TI_ALOFT         6
#define TI_KEY           7
#define TI_STAKEY        8
#define TI_MLME          9
#define TI_FREQUENCIES  10
#define TI_RSSIVECTOR   11
#define TI_POWERTABLE   12
#define TI_MT           13
#define TI_STA			14
#define TI_ATTACHMENT	15

struct data_types {
    char string[17];
    unsigned int id;
} mvc_data_types[] = {
    { "mac", TI_MAC },
    { "long", TI_LONG },
    { "string", TI_STRING },
    { "ssid", TI_SSID },
    { "vdcf", TI_VDCF },
    { "aloft", TI_ALOFT },
    { "key", TI_KEY },
    { "stakey", TI_STAKEY },
    { "mlme", TI_MLME },
    { "frequencies", TI_FREQUENCIES },
    { "rssivector", TI_RSSIVECTOR },
    { "powertable", TI_POWERTABLE },
    { "mt", TI_MT },
	{ "sta", TI_STA },
	{ "attachment", TI_ATTACHMENT }
};
        
struct wds_link {
    unsigned char mac[6];
    char name[32];
} __attribute__ ((packed));

struct my_attachment {
    char type;
    char reserved;
    short id;
    short size;
    char data[256];
};

int hexdigit( char digit )
{
    if( (digit >= '0') && (digit <= '9') )
	return (int)( digit - 48 );
    else if( (digit >= 'A') && (digit <= 'F') )
	return (int)( digit - 55 );
    else if( (digit >= 'a') && (digit <= 'f') )
	return (int)( digit - 87 );
    else
        return 0;
}

int main(int argc, char *argv[])
{
    int i, j;
    int tid;
	char *rptr;
    char ifname[17];
    unsigned int oid = 0;
    unsigned char type[17];
    unsigned char hexstring[64];
    int scanval[6];
    char cmd[16];
    struct data_types *dtp;
    unsigned int size;

    unsigned char mac[6];
    long longval;
    char string[64];
    struct obj_ssid ssid;
    struct obj_vdcf vdcf;
    struct obj_aloft aloft;
    struct obj_key key;
    struct obj_stakey stakey;
    struct obj_mlme mlme;
    struct obj_frequencies frequencies;
    struct obj_rssivector rssivector;
//    struct obj_powertable powertable;
	struct obj_mt mt;
    struct obj_sta sta;
    struct wds_link wlm;
    struct my_attachment attachment;
    /* struct bridge *brp; */
    
    int ret = 0;

    if (argc < 4)   
    {
    	printf("Usage: setoid <device> <oid> <data type> [<parameters>]\n");
        return -1;
    }

    if ( sscanf ( argv[1], "%s", ifname ) != 1 ) {
    	printf("Usage: setoid <DEVICE> <oid> <data type> [<parameters>]\n");
        return -1;
    }

    if ( sscanf ( argv[2], "%x", &oid ) != 1 ) {
        printf("Usage: setoid <device> <OID> <data type> [<parameters>]\n");
        return -1;
    }
    
    if ( sscanf ( argv[3], "%s", type ) != 1 ) {
        printf("Usage: setoid <device> <oid> <DATA TYPE> [<parameters>]\n");
        return -1;
    }

    tid = -1;
    for ( i=0, dtp=mvc_data_types; i < ((sizeof mvc_data_types) / sizeof(struct data_types)); i++, dtp++ ) {
        if ( strcmp( dtp->string, type ) == 0 ) {
            tid = dtp->id;
            break;
        }
    }
    if ( tid == -1 ) {
        printf("[%s] not supported\n", type );
        return -1;
    }

    prismoid_open();

    switch ( tid ) {
            
    case TI_MAC :

        if (argc < 5)   
        {
            printf("Usage: setoid <device> <oid> mac <MAC_ADDRESS>\n");
            break;
        }
        
        if ( sscanf ( argv[4], "%x:%x:%x:%x:%x:%x", 
                      &(scanval[0]), &(scanval[1]), &(scanval[2]), 
                      &(scanval[3]), &(scanval[4]), &(scanval[5]) ) != 6 ) {
            printf("Usage: setoid <device> <oid> mac <MAC_ADDRESS>\n");
            break;
        }

        switch ( oid ) {
            case DOT11_OID_WDSLINKADD :
                
                for ( i=0; i<6; i++ ) {
                    wlm.mac[i] = scanval[i];
                }
                wlm.name[0] = 0;

                set_prismoid(ifname, oid, (void*)&wlm, sizeof (struct wds_link) );
                
                printf("add wds link: %x:%x:%x:%x:%x:%x, %s\n", 
                       wlm.mac[0], wlm.mac[1], wlm.mac[2], wlm.mac[3], 
                       wlm.mac[4], wlm.mac[5], wlm.name );
                
                snprintf( cmd, 64, "brctl addif br0 %s", wlm.name );
                system( cmd );
                /*
                br_init();
                
                if ( (brp = br_find_bridge("br0")) == 0 ) {
                    printf("Bridge br0 not found!\n");
                    break;
                }
                if ( (i = if_nametoindex(wlm.name)) == 0 ) {
                    printf("Interface %s not found!\n", wlm.name );
                    break;
                }

                if ( br_add_interface( brp, i ) == 0 ) {
                    printf("%s added to bridge\n", wlm.name );
                }
                */
                break;

            case DOT11_OID_WDSLINKREMOVE :
                
                for ( i=0; i<6; i++ ) {
                    wlm.mac[i] = scanval[i];
                }
                wlm.name[0] = 0;

                ret = set_prismoid(ifname, oid, (void*)&wlm, sizeof (struct wds_link) );
                
                printf("del wds link: %x:%x:%x:%x:%x:%x, %s\n", 
                       wlm.mac[0], wlm.mac[1], wlm.mac[2], wlm.mac[3], 
                       wlm.mac[4], wlm.mac[5], wlm.name );

                snprintf( cmd, 64, "brctl delif br0 %s", wlm.name );
                system( cmd );
/*                
                br_init();

                if ( (brp = br_find_bridge("br0")) == 0 ) {
                   printf("Bridge br0 not found\n!");
                   break;
                }
                if ( (i = if_nametoindex(wlm.name)) == 0 ) {
                    printf("Interface %s not found!\n", wlm.name );
                    break;
                }

                if ( br_del_interface( brp, i ) == 0 ) {
                    printf("%s added to bridge\n", wlm.name );
                }
*/                
                break;

            default:

                for ( i=0; i<6; i++ ) {
                    mac[i] = scanval[i];
                }

                ret = set_prismoid(ifname, oid, (void*)mac, 6 );
                break;
        }
        
        break;
        
    case TI_LONG :
        
        if (argc < 5)   
        {
            printf("Usage: setoid <device> <oid> long <long>\n");
            break;
        }
        
        if ( sscanf ( argv[4], "%lx", &longval ) != 1 ) {
            printf("Usage: setoid <device> <oid> long <LONG>\n");
            break;
        }
        
        ret = set_prismoid(ifname, oid, (void*)&longval, sizeof(long) );
        
        break;
    
    case TI_SSID :

        if (argc < 5)   
        {
            printf("Usage: setoid <device> <oid> ssid <string>\n");
            break;
        }
        
        memcpy( hexstring, argv[4], 64 );
		for( i=0, j=0, rptr=hexstring; i < strlen( hexstring ); i++, j++, rptr++ )
		{
			if( strncmp( rptr, "/0", 2 ) == 0 )
			{
				ssid.octets[j] = '\0';
//				printf( "%i [%02x] %c\n", j, ssid.octets[j], ssid.octets[j] );
				i++;
				rptr++;
			}
			else
			{
				ssid.octets[j] = *rptr;
//				printf( "%i [%02x] %c\n", j, ssid.octets[j], ssid.octets[j] );
			}
		}
		
        ssid.length = j;

        ret = set_prismoid(ifname, oid, (void*)&ssid, sizeof(struct obj_ssid) );

        break;
            
    case TI_STRING :

        if (argc < 6)   
        {
            printf("Usage: setoid <device> <oid> string <size> <string>\n");
            break;
        }
        
        if ( sscanf ( argv[4], "%u", &size ) != 1 ) {
            size = 64;
        }

        if ( size > 64 ) {
            size = 64;
        }

        strncpy( string, argv[5], size );

        ret = set_prismoid(ifname, oid, (void*)string, size );

        break;
            
    case TI_VDCF :

        if (argc < 8)   
        {
            printf("Usage: setoid <device> <oid> vdcf <cwmin> <cwmax> <pfact> <aifs>\n");
            break;
        }
        
        if ( ( sscanf ( argv[4], "%hx", &vdcf.cwmin ) != 1 ) && 
             ( sscanf ( argv[5], "%hx", &vdcf.cwmax ) != 1 ) &&
             ( sscanf ( argv[6], "%hx", &vdcf.pfact ) != 1 ) &&
             ( sscanf ( argv[7], "%hx", &vdcf.aifs  ) != 1 ) ) {
            printf("Usage: setoid <device> <oid> vdcf <cwmin> <cwmax> <pfact> <aifs>\n");
            break;
        }
        
        ret = set_prismoid(ifname, oid, (void*)&vdcf, sizeof(struct obj_vdcf));

        break;

    case TI_ALOFT :

        /* ToDo: scan array */

        if (argc < 7)   
        {
            printf("Usage: setoid <device> <oid> aloft <nr> <initial> [<value>]\n");
            break;
        }
        
        if ( ( sscanf ( argv[4], "%hx", &aloft.nr )          != 1 ) && 
             ( sscanf ( argv[5], "%hx", &aloft.initial )     != 1 ) &&
             ( sscanf ( argv[6], "%hx", &(aloft.array[0])  ) != 1 ) ) {
            printf("Usage: setoid <device> <oid> aloft <nr> <initial> [<value>]\n");
            break;
        }
        
        ret = set_prismoid(ifname, oid, (void*)&aloft, sizeof(struct obj_aloft));

        break;

    case TI_KEY :

        if (argc < 6)   
        {
            printf("Usage: setoid <device> <oid> key <type> <string> | 0x<hexstring>\n");
            break;
        }
        
        if ( sscanf ( argv[4], "%x", &(scanval[0]) ) != 1 ) {
            printf("Usage: setoid <device> <oid> key <type> <string> | 0x<hexstring>\n");
            break;
        }
        key.type = scanval[0];
        strncpy( hexstring, argv[5], sizeof(hexstring) );
		
		if( strncmp( hexstring, "0x", 2 ) == 0 )
		{	
	    	if( strlen( hexstring ) < 28 )
	    	{
	        	if( strlen( hexstring ) < 12 )
				{
	            	printf("Error: Key too short, minimal length 5 bytes\n");
                	break;
				}
		
				if( strlen( hexstring ) > 12 )
		            printf("Warning: Using only the first 5 bytes of the key\n");
				for( i=0; i<10; i+=2 )
		    		key.key[i/2] = (char)( hexdigit( hexstring[2+i] )*16 + 
		    		   hexdigit( hexstring[2+i+1] ));
	        	key.length = 5;
	    	}
	    	else
	    	{
	    		if( strlen( hexstring ) > 28 )
	            	printf("Warning: Using only the first 13 bytes of the key\n");
				for( i=0; i<26; i+=2 )
		    		key.key[i/2] = (char)( hexdigit( hexstring[2+i] )*16 + 
		    		   hexdigit( hexstring[2+i+1] ));
                key.length = 13;
	    	}
		    
		}
		else
		{
		    if( strlen( hexstring ) < 13 )
		    {
	        	if( strlen( hexstring ) < 5 )
				{
	            	printf("Error: Key too short, minimal length 5 characters\n");
                	break;
				}

		    	if( strlen( hexstring ) > 5 )
		            printf("Warning: Using only the first 5 characters of the key\n");
		        strncpy( key.key, hexstring, 5 );
		        key.length = 5;
		    }
		    else
		    {
		    	if( strlen( hexstring ) > 13 )
		            printf("Warning: Using only the first 13 characters of the key\n");
		        strncpy( key.key, hexstring, 13 );
    	            key.length = 13;
		    }
		}        

/*
        printf("Key length %i string %s\n", key.length, key.key );
        printf("Key bytes: \n");
		for( i=0; i< key.length; i++ )
			printf("[%02x]", key.key[i] & 0xff );
		printf( "\n" );		
*/
        ret = set_prismoid(ifname, oid, (void*)&key, sizeof(struct obj_key));

        break;

    case TI_STAKEY :

        if (argc < 9)   
        {
            printf("Usage: setoid <device> <oid> stakey <mac_address> <keyid> <options> <type> <key_string>\n");
            break;
        }
        
        if ( sscanf ( argv[4], "%x:%x:%x:%x:%x:%x", 
                      &(scanval[0]), &(scanval[1]), &(scanval[2]), 
                      &(scanval[3]), &(scanval[4]), &(scanval[5]) ) != 6 ) {
            printf("Usage: setoid <device> <oid> stakey <MAC_ADDRESS> <keyid> <options> <type> <key_string>\n");
            break;
        }

        for ( i=0; i<6; i++ ) {
            stakey.address[i] = scanval[i];
        }
        
        if ( sscanf ( argv[5], "%x", &(scanval[0]) ) != 1 ) {
            printf("Usage: setoid <device> <oid> stakey <mac_address> <KEYID> <options> <type> <key_string>\n");
            break;
        }
        stakey.keyid = scanval[0];
        
        if ( sscanf ( argv[6], "%hx", &stakey.options ) != 1 ) {
            printf("Usage: setoid <device> <oid> stakey <mac_address> <keyid> <OPTIONS> <type> <key_string>\n");
            break;
        }

        if ( sscanf ( argv[7], "%x", &(scanval[0]) ) != 1 ) {
            printf("Usage: setoid <device> <oid> stakey <mac_address> <keyid> <options> <TYPE> <key_string>\n");
            break;
        }
        stakey.type = scanval[0];

        strncpy( stakey.key, argv[8], 16 );
        stakey.length = strlen(stakey.key);
        
        ret = set_prismoid(ifname, oid, (void*)&stakey, sizeof(struct obj_stakey));

        break;

    case TI_MLME :

        if (argc < 8)   
        {
            printf("Usage: setoid <device> <oid> mlme <mac_address> <id> <state> <code>\n");
            break;
        }
        
        if ( sscanf ( argv[4], "%x:%x:%x:%x:%x:%x", 
                      &(scanval[0]), &(scanval[1]), &(scanval[2]), 
                      &(scanval[3]), &(scanval[4]), &(scanval[5]) ) != 6 ) {
            printf("Usage: setoid <device> <oid> mlme <MAC_ADDRESS> <id> <state> <code>\n");
            break;
        }

        for ( i=0; i<6; i++ ) {
            mlme.address[i] = scanval[i];
        }
        
        if ( sscanf ( argv[5], "%hx", &mlme.id ) != 1 ) {
            printf("Usage: setoid <device> <oid> mlme <mac_address> <ID> <state> <code>\n");
            break;
        }

        if ( sscanf ( argv[6], "%hx", &mlme.state ) != 1 ) {
            printf("Usage: setoid <device> <oid> mlme <mac_address> <id> <STATE> <code>\n");
            break;
        }

        if ( sscanf ( argv[7], "%hx", &mlme.code ) != 1 ) {
            printf("Usage: setoid <device> <oid> mlme <mac_address> <id> <state> <CODE>\n");
            break;
        }

        ret = set_prismoid(ifname, oid, (void*)&mlme, sizeof(struct obj_mlme)); 

        break;

    case TI_FREQUENCIES :

        if (argc < 6)   
        {
            printf("Usage: setoid <device> <oid> frequencies <nr> [<mhz>]\n");
            break;
        }

        if ( sscanf ( argv[4], "%hx", &frequencies.nr ) != 1 ) {
            printf("Usage: setoid <device> <oid> frequencies <NR> [<mhz>]\n");
            break;
        }

        /* ToDo: implement array */
        if ( sscanf ( argv[5], "%hx", &(frequencies.mhz[0]) ) != 1 ) {
            printf("Usage: setoid <device> <oid> frequencies <nr> [<MHZ>]\n");
            break;
        }

        ret = set_prismoid(ifname, oid, (void*)&frequencies, sizeof(struct obj_frequencies)); 

        break;

    case TI_RSSIVECTOR :

        if (argc < 6)   
        {
            printf("Usage: setoid <device> <oid> rssivector <a> <b>\n");
            break;
        }

        if ( sscanf ( argv[4], "%lx", &rssivector.a ) != 1 ) {
            printf("Usage: setoid <device> <oid> rssivector <A> <b>\n");
            break;
        }

        if ( sscanf ( argv[5], "%lx", &rssivector.b ) != 1 ) {
            printf("Usage: setoid <device> <oid> rssivector <a> <B>\n");
            break;
        }

        ret = set_prismoid(ifname, oid, (void*)&rssivector, sizeof(struct obj_rssivector)); 

        break;

    case TI_POWERTABLE :

        printf("Powertable not supported yet!\n");
/*
        unsigned short frequency;
        struct obj_power cck;
        struct obj_power bpsk;
        struct obj_power qpsk;
        struct obj_power qam16;
        struct obj_power qam64;

        ret = set_prismoid(ifname, oid, (void*)&powertable, sizeof(struct obj_powertable)); 
*/
        break;

    case TI_MT :

	    if (argc < 20)   
    	{
    		printf("Usage: setoid <device> %x mt <16 parameters>\n", oid );
        	printf("       parameters: mode channel rate preamble length modulation scrambling\n" );
        	printf("                   filter antenna_rx antenna_tx power_loop key_type key_length\n" );
        	printf("                   key ccamode autorespond\n" );
            break;
    	}
        
	    sscanf ( argv[4], "%li", &mt.mode );
    	sscanf ( argv[5], "%li", &mt.channel );
    	sscanf ( argv[6], "%li", &mt.rate );
    	sscanf ( argv[7], "%li", &mt.preamble );
    	sscanf ( argv[8], "%li", &mt.length );
    	sscanf ( argv[9], "%li", &mt.modulation );
   		sscanf ( argv[10], "%li", &mt.scrambling );
    	sscanf ( argv[11], "%li", &mt.filter );
    	sscanf ( argv[12], "%li", &mt.antenna_rx );
    	sscanf ( argv[13], "%li", &mt.antenna_tx );
    	sscanf ( argv[14], "%li", &mt.power_loop );
    	sscanf ( argv[15], "%i", (int *) &mt.key.type );
    	sscanf ( argv[16], "%i", (int *) &mt.key.length );
    	sscanf ( argv[17], "%s", &mt.key.key[0] );
    	sscanf ( argv[18], "%li", &mt.ccamode );
    	sscanf ( argv[19], "%li", &mt.autorespond );
		mt.mpdu = NULL;

        printf( "set_prismoid(%s, %x, parameters )\n", ifname, oid );
        printf( "parameters: mode = %li, channel = %li\n", mt.mode, mt.channel );
        printf( "            rate = %li, preamble = %li\n", mt.rate, mt.preamble );
        printf( "            length = %li, modulation = %li\n", mt.length, mt.modulation );
        printf( "            scrambling = %li, filter = %li\n", mt.scrambling, mt.filter );
        printf( "            antenna_rx = %li, antenna_tx = %li\n", mt.antenna_rx, mt.antenna_tx );
        printf( "            power_loop = %li\n", mt.power_loop );
        printf( "            key type, length, key = %i %i %s\n", mt.key.type, mt.key.length, mt.key.key );
        printf( "            ccamode = %li, autorespond = %li\n", mt.ccamode, mt.autorespond );
        
        ret = set_prismoid(ifname, oid, (void*)&mt, sizeof(struct obj_mt));

        break;

	case TI_STA:

        if (argc < 5)   
		{
    		printf("Usage: setoid <device> %x sta <MAC_ADDRESS>\n", oid );
		}
		else
        {
			// read the supplied MAC address for searching a client       
	        if ( sscanf ( argv[4], "%x:%x:%x:%x:%x:%x", 
        		(unsigned int *) &(sta.address[0]), (unsigned int *) &(sta.address[1]), 
				(unsigned int *) &(sta.address[2]), (unsigned int *) &(sta.address[3]), 
				(unsigned int *) &(sta.address[4]), (unsigned int *) &(sta.address[5]) ) != 6 ) {
	            printf("Usage: setoid <device> <oid> sta <MAC_ADDRESS>\n");
    	        break;
			}

	        ret = set_prismoid(ifname, oid, (void*)&sta, sizeof(struct obj_sta));
        }
		
		break;

	case TI_ATTACHMENT:

        if (argc < 8)   
        {
            printf("Usage: setoid <device> <oid> attachment <type> <id> <size> <data>\n");
            break;
        }

	{
		unsigned short	tmp_type;

		sscanf ( argv[4], "%hx", &tmp_type );
		attachment.type = tmp_type; 
	}
        sscanf ( argv[5], "%hx", &attachment.id );
        sscanf ( argv[6], "%hx", &attachment.size );
        sscanf ( argv[7], "%s", &attachment.data[0] );
	attachment.reserved = 0;
	
	printf( "attachment.type %x\n", (int) attachment.type & 0xff );
	printf( "attachment.id   %x\n", (int) attachment.id & 0xffff );
	printf( "attachment.size %i\n", attachment.size );
	printf( "attachment.data %s\n", attachment.data );
	
        ret = set_prismoid(ifname, oid, (void*)&attachment, 
		sizeof(struct my_attachment)-256+attachment.size );

		break;
		                
    default:

        printf("[%s] not supported\n", type );
        break;
    }

    prismoid_close();

    return ret;
}

