/*  $Header: /proj/software/pub/CVSROOT/uClinux/uC-src/intersil-tools/prismoids.h,v 1.1 2003/02/23 23:31:23 mrustad Exp $
 *
 *  Copyright (C) 2002 Intersil Americas Inc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 * 
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 * 
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _PRISMOIDS_H
#define _PRISMOIDS_H

/* Uncomment this to use the netlink/PIMFOR interface */
//#define NEW_NETLINK_IFC

/* Use netlink/PIMFOR interface when testing DB driver on Poldhu platform. */
#include <linux/autoconf.h> /* For CONFIG_POLDHU_TEST_DB_DRIVER define... */

#define NEW_NETLINK_IFC

#ifndef NEW_NETLINK_IFC

#include <blobarch.h>
#include <bloboidv1.h>

extern int get_prismoid(char *if_name, unsigned int oid, void *data, int length);
extern int set_prismoid(char *if_name, unsigned int oid, void *data, int length);
extern int set_trap(char *if_name, unsigned int oid, void *data);
extern int del_trap(char *if_name, unsigned int oid, void *data);

#else /* NEW_NETLINK_IFC */

/* Enable this on 3893 */
#define BLOB_V2 

#include <bloboid.h>
#include <blobarch.h>
#include <linux/types.h>
#include <linux/netlink.h>
#include <linux/isil_netlink.h>

struct islnetlink_handle
{
	int			fd;
	struct sockaddr_nl	local;
	__u32			seq;
};

/* Getting/Setting OIDs */
extern int prismoid_open(void);
extern int prismoid_close(void);
extern int get_prismoid(char *ifname, unsigned int oid, void *data, int data_len);
extern int set_prismoid(char *ifname, unsigned int oid, void *data, int data_len);

/*
 * Prism Traps.
 * When a prismtraps link is opened, a bitmask of trapgroups as defined in the file
 * include/linux/isil_netlink.h should be passed for all traps that an application
 * wants to receive.
 */
extern int prismtraps_open(struct islnetlink_handle *islnetlink_h, __u32 trapgroup);
extern int prismtraps_close(struct islnetlink_handle *islnetlink_h);
extern int prismtraps_decode(struct islnetlink_handle *islnetlink_h, __u32 *trapoid,
			__u32 *devid, char **trapdata, __u32 *data_len);

#endif /* NEW_NETLINK_IFC */

#endif /* _PRISMOIDS_H */
