/*  $Header: /proj/software/pub/CVSROOT/uClinux/uC-src/intersil-tools/getoid.c,v 1.2 2003/03/21 23:19:41 mrustad Exp $
 *  
 *  Copyright (C) 2002 Intersil Americas Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <errno.h>
#include <unistd.h>
#include <netinet/in.h>

#include "prismoids.h"

#define DATA_SZ        256

#define TI_MAC           1
#define TI_LONG          2
#define TI_STRING        3
#define TI_SSID          4
#define TI_VDCF          5
#define TI_ALOFT         6
#define TI_KEY           7
#define TI_STAKEY        8
#define TI_MLME          9
#define TI_FREQUENCIES  10
#define TI_RSSIVECTOR   11
#define TI_POWERTABLE   12
#define TI_MT           13
#define TI_STA			14

struct data_types {
    char string[17];
    unsigned int id;
} mvc_data_types[] = {
    { "mac", TI_MAC },
    { "long", TI_LONG },
    { "string", TI_STRING },
    { "ssid", TI_SSID },
    { "vdcf", TI_VDCF },
    { "aloft", TI_ALOFT },
    { "key", TI_KEY },
    { "stakey", TI_STAKEY },
    { "mlme", TI_MLME },
    { "frequencies", TI_FREQUENCIES },
    { "rssivector", TI_RSSIVECTOR },
    { "powertable", TI_POWERTABLE },
	{ "sta", TI_STA }
};

int main(int argc, char *argv[])
{
    int i;
    int tid = -1;
    char ifname[17];
	unsigned int oid = 0;
	unsigned int size = 64;
    unsigned char type[17];
    struct data_types *dtp;

    unsigned char mac[6];
    long longval;
    char string[64];
    struct obj_ssid ssid;
    struct obj_vdcf vdcf;
    struct obj_aloft  aloft;
    struct obj_key key;
    struct obj_stakey stakey;
    struct obj_mlme mlme;
    struct obj_frequencies frequencies;
    struct obj_rssivector rssivector;
//    struct obj_powertable powertable;
//    struct obj_mt mt;
	struct obj_sta sta;
    unsigned char data[DATA_SZ];
    
    int ret = 0;

    if (argc < 3)   
    {
    	printf("Usage: getoid <device> <oid> [<type>|<size>]\n");
        return -1;
    }

    if ( sscanf ( argv[1], "%s", ifname ) != 1 ) {
    	printf("Usage: getoid <DEVICE> <oid> [<type>|<size>]\n");
        return -1;
    }

    if ( sscanf ( argv[2], "%x", &oid ) != 1 ) {
    	printf("Usage: getoid <device> <OID> [<type>|<size>]\n");
        return -1;
    }
    
    if (argc > 3) {
        if ( sscanf ( argv[3], "%u", &size ) != 1 ) {
            if ( sscanf ( argv[3], "%s", type ) == 1 ) {
                for ( i=0, dtp=mvc_data_types; i < ((sizeof mvc_data_types) / sizeof(struct data_types)); i++, dtp++ ) {
                    if ( strcmp( dtp->string, type ) == 0 ) {
                        tid = dtp->id;
                        break;
                    }
                }
                if ( tid == -1 ) {
                    printf("[%s] not supported\n", type );
                    return -1;
                }
            }
        }
    }
    
    if ( size > DATA_SZ ) {
        size = DATA_SZ;
    }

    prismoid_open();

    switch ( tid ) {
            
    case TI_MAC :

        ret = get_prismoid(ifname, oid, (void*)mac, 6 );
        if ( ret == 0 ) {
            for ( i = 0; i < 5; i++ ) {
                printf( "%2.2X:", mac[i] );
            }
            printf( "%2.2X\n", mac[5] );
        }
        
        break;
        
    case TI_LONG :
        
        ret = get_prismoid(ifname, oid, (void*)&longval, sizeof(long) );
        printf( "%lx\n", longval );
        
        break;
    
    case TI_SSID :

        ret = get_prismoid(ifname, oid, (void*)&ssid, sizeof(struct obj_ssid) );
        if ( ret == 0 ) {
            printf( "%d ", ssid.length );
            for ( i = 0; i < ssid.length; i++ ) {
                printf( "%c", ssid.octets[i] );
            }
            printf( "\n" );
        }
        
        break;
            
    case TI_STRING :

        size = 64;

        if (argc > 4) {
            if ( sscanf ( argv[4], "%u", &size ) != 1 ) {
                size = 64;
            }
            if ( size > 64 ) {
                size = 64;
            }
        }
        
        ret = get_prismoid(ifname, oid, (void*)string, size );
        if ( ret == 0 ) {
            printf( "%s\n", string );
        }
        
        break;
            
    case TI_VDCF :

        ret = get_prismoid(ifname, oid, (void*)&vdcf, sizeof(struct obj_vdcf));
        if ( ret == 0 ) {
            printf( "cwmin   %hd\n", vdcf.cwmin );
            printf( "cwmax   %hd\n", vdcf.cwmax );
            printf( "pfact   %hx\n", vdcf.pfact );
            printf( "aifs    %hx\n", vdcf.aifs  );
        }

        break;

    case TI_ALOFT :

        /* ToDo: scan array */

        ret = get_prismoid(ifname, oid, (void*)&aloft, sizeof(struct obj_aloft));
        if ( ret == 0 ) {
            printf( "nr      %hd\n", aloft.nr );
            printf( "initial %hx\n", aloft.initial );
            printf( "array[0]%hx\n", aloft.array[0] );
        }

        break;

    case TI_KEY :

        ret = get_prismoid(ifname, oid, (void*)&key, sizeof(struct obj_key));
        if ( ret == 0 ) {
            printf( "type     %x\n", key.type );
            printf( "length  %hd\n", key.length );
			key.key[(int)key.length] = '\0';
            printf( "key      %s\n", key.key );
			printf( "         " );
			for( i=0; i<key.length; i++ )
				printf("[%02x]", key.key[i] & 0xff );
			printf( "\n" );		
        }

        break;

    case TI_STAKEY :
        
        ret = get_prismoid(ifname, oid, (void*)&stakey, sizeof(struct obj_stakey));
        if ( ret == 0 ) {
            printf( "address  " );
            for ( i = 0; i < 5; i++ ) {
                printf( "%2.2X:", (unsigned char)stakey.address[i] );
            }
            printf( "%2.2X\n", (unsigned char)stakey.address[5] );
            printf( "keyid    %x\n", stakey.keyid );
            printf( "options  %x\n", stakey.options );
            printf( "type     %x\n", stakey.type );
            printf( "length   %hd\n", stakey.length );
            printf( "key      %s\n", stakey.key );
        }

        break;

    case TI_MLME :

        ret = get_prismoid(ifname, oid, (void*)&mlme, sizeof(struct obj_mlme)); 
        if ( ret == 0 ) {
            printf( "address  " );
            for ( i = 0; i < 5; i++ ) {
                printf( "%2.2X:", (unsigned char)mlme.address[i] );
            }
            printf( "%2.2X\n", (unsigned char)mlme.address[5] );
            printf( "id       %x\n", mlme.id );
            printf( "state    %x\n", mlme.state );
            printf( "code     %x\n", mlme.code );
        }

        break;

    case TI_FREQUENCIES :

        /* ToDo: scan array */
        
        ret = get_prismoid(ifname, oid, (void*)&frequencies, sizeof(struct obj_frequencies)); 
        if ( ret == 0 ) {
            printf( "nr      %hd\n", frequencies.nr );
            printf( "mhz[0]  %hd\n", frequencies.mhz[0] );
        }

        break;

    case TI_RSSIVECTOR :

        ret = get_prismoid(ifname, oid, (void*)&rssivector, sizeof(struct obj_rssivector)); 
        if ( ret == 0 ) {
            printf( "a       %ld\n", rssivector.a );
            printf( "b       %ld\n", rssivector.b );
        }

        break;

    case TI_POWERTABLE :

        printf("Powertable not supported yet!\n");
/*
        unsigned short frequency;
        struct obj_power cck;
        struct obj_power bpsk;
        struct obj_power qpsk;
        struct obj_power qam16;
        struct obj_power qam64;

        ret = get_prismoid(ifname, oid, (void*)&powertable, sizeof(struct obj_powertable)); 
*/
        break;

	case TI_STA:

        if (argc > 4)   
        {
			// read the supplied MAC address for searching a client       
	        if ( sscanf ( argv[4], "%x:%x:%x:%x:%x:%x", 
        		(unsigned int *) &(sta.address[0]), (unsigned int *) &(sta.address[1]), 
				(unsigned int *) &(sta.address[2]), (unsigned int *) &(sta.address[3]), 
				(unsigned int *) &(sta.address[4]), (unsigned int *) &(sta.address[5]) ) != 6 ) {
	            printf("Usage: setoid <device> <oid> sta <MAC_ADDRESS>\n");
    	        break;
			}
        }

        ret = get_prismoid(ifname, oid, (void*)&sta, sizeof(struct obj_sta));

        if ( ret == 0 ) {
            printf( "address " );
            for ( i = 0; i < 5; i++ ) {
                printf( "%02X:", (unsigned char)sta.address[i] );
            }
            printf( "%02X\n", (unsigned char)sta.address[5] );
            printf( "pad     %02X %02X\t", (unsigned char)sta.pad[0], (unsigned char)sta.pad[1] );
            printf( "state   %x\n", sta.state );
            printf( "age     %x\t", sta.age );
            printf( "quality %x\n", sta.quality );
            printf( "rssi    %x\n", sta.rssi );
        }

		break;
		
    default:

        ret = get_prismoid(ifname, oid, (void*)data, size );
        if ( ret == 0 ) {
            for ( i = 0; i < size; i++ ) {
                printf( "%2.2X", data[i] );
                if ( ((i+1) % 4) == 0 ) printf(" ");
                if ( ((i+1) % 32) == 0 ) printf("\n");
            }
            printf("\n");
        }

        break;
    }

    prismoid_close();

    return ret;
}

