/*  $Header: /proj/software/pub/CVSROOT/uClinux/uC-src/intersil-tools/catchoids.c,v 1.1 2003/02/23 23:31:23 mrustad Exp $
 *  
 *  Copyright (C) 2002 Intersil Americas Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <errno.h>
#include <unistd.h>
#include <netinet/in.h>

#include "prismoids.h"

#define max(v1, v2) (v1 > v2) ? v1 : v2
 
int main(int argc, char *argv[])
{
	fd_set fdset;
    __u32 trapgroup = TRAPGRP_ETH_TRAPS | TRAPGRP_WLAN_TRAPS | TRAPGRP_BLOBDEV_TRAPS;
	struct timeval tv;
	int trapfd, maxfd;
    int retval = 0;
	struct islnetlink_handle islnetlink_h;

	if ( ( trapfd = prismtraps_open(&islnetlink_h, trapgroup ) ) < 0 ) {
        printf("prismtraps_open failed\n");
        return -1;
    }

	while(1) {
		maxfd = 0;
		FD_ZERO(&fdset);

		/* Timeout 1 second */
		tv.tv_sec = 1;
		tv.tv_usec = 0;

		/* monitor the trapfd descriptor */
		FD_SET(trapfd, &fdset);
		maxfd = max(maxfd, trapfd);

		retval = select(maxfd+1, &fdset, NULL, NULL, &tv);

		if(retval < 0) {
			printf("select failed\n");
			goto out;
		}
		
		if(FD_ISSET(trapfd, &fdset)) {
            unsigned int oid;
            unsigned int len;
            unsigned int devid;
			char        *data;
            char         string[33];
            time_t       tp;
            struct tm   *tmp;
            
            retval = prismtraps_decode(&islnetlink_h, &oid, &devid, &data, &len);
			if(retval < 0) {
				printf("prismtraps_decode failed\n");
				goto out;
			}
			tp = time(NULL);
            tmp = localtime ( &tp );
            if (len > 32 ) 
                len = 32;
            memset( string, 0 , 33);
            memcpy( string, data, len );
            printf( "%2d:%2d:%2d dev: %d, OID: %x, len: %d, hex: %x.%x.%x.%x.%x.%x string: %s\n", tmp->tm_hour, tmp->tm_min, tmp->tm_sec, 
                    devid, oid, len, string[0], string[1], string[2], string[3], string[4], string[5], string );

			free(data);
		}
	}

out:
	prismtraps_close(&islnetlink_h);
	return retval;
}

