#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>
#include <signal.h>
#include <errno.h>
#ifndef __USE_TEXT_PASSWORDS__
#include <sys/param.h>
#include <pwd.h>
#include <crypt.h>
#include <paths.h>
#endif /* ! __USE_TEXT_PASSWORDS__ */

#define LOGIN " login: "		/* login prompt */

extern char    *getpass(const char *);

static char *username = NULL;;
static char usernamebuf[32];

/* ------------------------------------------------------------------------ */
void timedout(int signo)
{
  (void)fprintf(stderr, "Login timed out after %d seconds\n", 180);
  exit(0);
}

/* ------------------------------------------------------------------------ */
int             main(int argc, char *argv[])
{
  char           *buf;
  char            name[64];
  int             fflag,
                  hflag,
                  pflag;
  uid_t           uid;
  int	ask;
  int ch;
  int cnt = 0;
#ifndef __USE_TEXT_PASSWORDS__
  struct  passwd *pwd;
  char *salt;
  char *p;
  char tbuf[MAXPATHLEN + 2];
#endif /* ! __USE_TEXT_PASSWORDS__ */

  fflag = hflag = pflag = 0;
  uid = getuid();
  while ((ch = getopt(argc, argv, "fh:p")) != -1) {
    switch (ch) {
	case 'f':
	  fflag = 1;
	  break;
	case 'h':
	  if (uid) {
	    fprintf(stderr, "-h option: %s\n", strerror(EPERM));
	    exit(1);
	  }
	  hflag = 1;
/* 	  hostname = optarg; */
	  break;
	case 'p':
	  pflag = 1;
	  break;
	case '?':
	default:
	  (void) fprintf(stderr, "usage: login [-fp] [-h hostname] [username]\n");
	  exit(1);
    }
  }
  argc -= optind;
  argv += optind;
  if (*argv) {
    username = *argv;
    ask = 0;
  } else {
    ask = 1;
  }

/*   if (!strcmp(argv[argc - 1], "-t")) { */
  (void)signal(SIGALRM, timedout);
  alarm(180);
  while (cnt < 10) {
    if (ask == 1) {
      fflag = 0;
      gethostname(name, sizeof(name));
      printf("%s%s", name, LOGIN);
      fflush(stdout);
      fgets(usernamebuf, sizeof(usernamebuf), stdin);
      ch = strlen(usernamebuf);
      if (ch > 0 && usernamebuf[ch-1] == '\n') {
	usernamebuf[ch-1] = '\0';
      }
      username = usernamebuf;
    }
#ifndef __USE_TEXT_PASSWORDS__
    if ((pwd = getpwnam(username))) {
      salt = pwd->pw_passwd;
    } else {
      salt = "xx";				/* will fail */
    }
#endif /* ! __USE_TEXT_PASSWORDS__ */
    buf = getpass("Password: ");
    (void)alarm((u_int)0);			/* turn off alarm */
    printf("\n");

#ifdef __USE_TEXT_PASSWORDS__
    if (strcmp(username, "root") == 0) {	/* check username first */
      if (strcmp(buf, "brecis") == 0) {		/* check password second */
	setenv("HOME", "/root", 0);		/* legal to override */
	chdir("/var");				/* go some place reasonable */
	execl("/bin/sh", "-/bin/sh", 0);	/* give us a shell */
      }
    }
#else /* __USE_TEXT_PASSWORDS__ */
    p = crypt(buf, salt);

    if (pwd && strcmp(p, pwd->pw_passwd) == 0) {
      setgid(pwd->pw_gid);
      if (*pwd->pw_shell == '\0') {
	pwd->pw_shell = _PATH_BSHELL;
      }
      setenv("HOME", pwd->pw_dir, 0);		/* legal to override */
      setenv("PATH", _PATH_STDPATH, 1);
      setenv("SHELL", pwd->pw_shell, 1);
      setenv("LOGNAME", pwd->pw_name, 1);
      setuid(pwd->pw_uid);			/* assume works */
      if (chdir(pwd->pw_dir) < 0) {
	printf("No directory %s!\n", pwd->pw_dir);
	if (chdir("/")) {
	  exit(0);
	}
	pwd->pw_dir = "/";
	printf("Logging in with home = \"/\".\n");
      }
      tbuf[0] = '-';
      strncpy(tbuf+1, pwd->pw_shell, sizeof(tbuf)-1);

      execl("/bin/sh", tbuf, 0);	/* give us a shell */
    }
#endif /* __USE_TEXT_PASSWORDS__ */

    puts("Login incorrect");
    cnt++;
    ask = 1;
    if (cnt > 3) {
      sleep((u_int)((cnt-3)*5));
    }
  }
  exit(1);
}
