/* pptp.c ... client shell to launch call managers, data handlers, and
 *            the pppd from the command line.
 *            C. Scott Ananian <cananian@alumni.princeton.edu>
 *
 * $Id: pptp.c,v 1.8 2001/03/05 23:54:52 davidm Exp $
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/un.h>
#include <netdb.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <setjmp.h>
#include <errno.h>
#include <sys/wait.h>
#ifdef EMBED
#include <syslog.h>
#endif
#include "pptp_callmgr.h"
#include "pptp_msg.h"
#include "pptp_gre.h"
#include "version.h"
#include "inststr.h"
#include "pty.h"
#include "amit.h"

#ifdef _WAN_PPTP
extern int dialondemand(char *interface);
#endif

#ifdef SUCC
  #define PPTPDEBUG
  /* 20030521 marked by succ for pptp client reliability problem */
  //#define HAVE_FORK
#endif

#ifdef EMBED
#define	pptp_error(a...) syslog(LOG_INFO, ##a)
#else
#define	pptp_error(a...) ({ fprintf(stderr, ##a); fprintf(stderr, "\n"); })
#endif

#ifdef PPTPDEBUG
#define pptp_debug(a...) pptp_error(##a)
#else
#define pptp_debug(a...)
#endif

/*
 * because we can be run from init,  it seems unwise to just
 * exit quickly for errors that probably won't have resolved
 * themselves immediately,  wait a bit on exit just to slow
 * it all down a little
 */
#define RESPAWN_DELAY	2

#ifndef PPPD_BINARY
  #define PPPD_BINARY "/var/pppd"
#endif

struct in_addr get_ip_address(char *name);
int open_callmgr(struct in_addr inetaddr, int argc,char **argv,char **envp);
void launch_callmgr(struct in_addr inetaddr, int argc,char **argv,char **envp);
void get_call_id(int sock, pid_t gre, pid_t pppd, 
		 u_int16_t *call_id, u_int16_t *peer_call_id);
void launch_pppd(char *ttydev, int argc, char **argv);
void reset_pppserver_gateway(void);
extern unsigned long getWANroute(char *p_wanname);



void usage(char *progname) {
  fprintf(stderr,
	  "%s\n"
	 "Usage:\n"
	 " %s hostname[,hostname[,...]] [pppd options]\n", version, progname);
  exit(1);
}

static int signaled = 0;

unsigned char *pptp_idle_time;

void do_nothing(int sig) { 
    /* do nothing signal handler. Better than SIG_IGN. */
    signaled = 1;
}

void do_alarm(int sig) {
    /* the SIGALRM handler */
}

sigjmp_buf env;
void sighandler(int sig) {
  siglongjmp(env, 1);
}

#ifdef SUCC
static int ui_num;
//static char peerip[20];
int callmgr_sock_copy;
int pty_fd_copy;

/* signal handler for SIGCHLD (occur when pppd(child of pptp) close */
void child_handler (int mysignal)
{  
    pid_t pid;
    int mystatus; 
    FILE *fd;
    char ppp_command[100];
    char pppno_file[23];
    char pppno[23];
    FILE *ppp_fd;
    int index;
    char command[30];
    char cmpid[10];

    pid = waitpid (-1, &mystatus, WNOHANG);

    /* ******************************************* */
    /* succ : connectection failed or disconnected */
    /*        change status to 0                   */
    /* ******************************************* */
    sprintf(command,"/var/run/pptpc/pptpc%d",ui_num);
    fd = fopen(command,"w");
    fprintf(fd,"%d",0);
    fclose(fd);
    
    /* ******************************************* */
    /*  joe : connectection failed or disconnected */
    /*        clean iptables !                     */
    /* ******************************************* */
    /* added by joe */
	bzero(pppno_file,23);
	sprintf(pppno_file,"/var/config/ppp/pppd.%d",ui_num);
	if( (ppp_fd=fopen(pppno_file,"r"))!=NULL )
	{
		bzero(pppno,23);
		fgets(pppno,sizeof(pppno),ppp_fd);
		bzero(pppno,23);
		fgets(pppno,sizeof(pppno),ppp_fd);
		for( index=0; pppno[index]!='\n'; index++ )
		{}
		*(pppno+index)=0;
		fclose(ppp_fd);
		bzero(ppp_command,100);
		sprintf(ppp_command,"iptables -t nat -D POSTROUTING -o %s -j MASQUERADE",pppno);
		#ifdef FOR_DEBUG
			pptp_debug("pptpd: modify_ui_no: pppno: command:%s\r\n",command);
		#endif
		system(ppp_command);
    }
  /* end of add */
    /* ************************************************* */
    /* remove pptp_pppd(UI).pid (content is pid of pppd) */
    /* ps. create before launch_pppd                     */ 
    /* ************************************************* */
    sprintf(command,"/var/run/pptpc/pptp_pppd%d.pid",ui_num);
    remove(command);

    /* ***************** */
    /* kill pptp_callmgr */
    /* ***************** */
    sprintf(command,"/var/run/pptpc/cm%d",ui_num);
    fd = fopen(command,"r");
    fgets(cmpid,10,fd);
    remove(command);
    fclose(fd);
    sprintf(command, "kill %d",atoi(cmpid));
    system(command);

    /* ***************************** */
    /* remove pptp_callmgr link file */
    /* ***************************** */
    //sprintf(command,"/var/run/pptpc/%s",peerip);
    //remove(command);

    /* ************************************************** */
    /* on close, kill all (everyone in our process group) */
    /* ************************************************** */
    if (pty_fd_copy != -1)
      close(pty_fd_copy);
    if (callmgr_sock_copy != -1)
      close(callmgr_sock_copy);

    pptp_debug("PPTP client disconnect ok!\n");

    exit(0);
}

/* signal handler for SIGUSR2 (occur when pppd ipcp up) */
void tunnel_success(int mysignal)
{
    FILE *fd;
    char command[30];

    /* **************************** */
    /* succ : connectection success */
    /*        change status to 1    */
    /* **************************** */   
    sprintf(command,"/var/run/pptpc/pptpc%d",ui_num);
    fd = fopen(command,"w");
    fprintf(fd,"%d",1);
    fclose(fd);
}
#endif

int main(int argc, char **argv, char **envp) {
  struct in_addr inetaddr;
  int callmgr_sock = -1;
  char ptydev[PTYMAX], ttydev[TTYMAX];
  int pty_fd = -1;

    unsigned char	filename[100];
    unsigned char	wtype[23];
    unsigned char	user[23];
    unsigned char	ip_type[23];
    unsigned char	max_idle[23];
    unsigned char	auto_reconnect[23];
    unsigned char	force_connect[23];
    unsigned char	dhcp_state[23];
    unsigned char	ip_str[23];

  pid_t parent_pid, child_pid;
  u_int16_t call_id, peer_call_id;
  
  #ifdef SUCC
    int i, cid, pid2;
    char ch;
    FILE * fd;
    char command[50];
    char *new_argv[argc+2];

    if(!strcmp(argv[argc-1],"-D"))
      goto daemon;

    #ifndef HAVE_FORK 
      switch(cid = vfork())
    #else
      switch(cid = fork())
    #endif
    {
      case -1: /* error */
        #if 0
        signal(SIGUSR1, SIG_DFL);
        pptp_debug("fork failed %s", strerror(errno));
        sleep(RESPAWN_DELAY);
        goto shutdown;   
        break;
        #endif
        pptp_debug("fork failed %s", strerror(errno));
        exit(-1);

      case 0: /* child */
        for(i=0;i<argc;i++)
          new_argv[i] = argv[i];
        new_argv[argc] = "-D";
        new_argv[argc+1] = NULL;
        execv(new_argv[0],new_argv);
        break;
    
      default: /* parent */
        exit(0);
    }
  #endif

daemon:

  #ifdef SUCC
    (void) signal (SIGCHLD, child_handler); 
    (void) signal (SIGUSR2, tunnel_success); 

    /* ************************** */
    /* succ : conectting          */
    /*        change status to 99 */
    /* ************************** */
    ui_num = atoi(argv[argc-2]);
    sprintf(command,"/var/run/pptpc/pptpc%d",ui_num);
    fd = fopen(command,"w");
    fprintf(fd,"%d",99);
    fclose(fd);
  #endif

  #ifdef _WAN_PPTP
  	bzero(command,30);
    sprintf(command,"/var/run/pptpc/pptp_pppd%d.pid",ui_num);
    fd = fopen(command,"w");
    fprintf(fd,"%d",getpid());
    fclose(fd);
  if(ui_num==(MAX_PPTP_CLIENT_NUM-1+MAX_L2TP_CLIENT_NUM+MAX_L2TP_CLIENT_NUM+MAX_NO_ACCOUNT_POOL))
  {
	sprintf(filename,"/var/run/pptpc/pptp_wantype_info");
	if( (fd=fopen(filename,"r"))!=NULL )
	{
		memset(wtype,0x00,23);
		memset(user,0x00,23);
		memset(ip_str,0x00,23);
		memset(max_idle,0x00,23);
		memset(ip_type,0x00,23);
		memset(auto_reconnect,0x00,23);
		memset(force_connect,0x00,23);
		fscanf(fd,"%s\n%s\n%s\n%s\n%s\n%s\n%s\n"
				,wtype,user,ip_str,max_idle,ip_type,auto_reconnect,force_connect);
		fclose(fd);
		pptp_idle_time = max_idle;   //eric set max_idle_time to pptp_idle_time -20040427
	}
	
	if( atoi(wtype)==WT_PPTP )
	{
		if( atoi(auto_reconnect)==0 )
		{
			if( atoi(force_connect)==0 )
			{
				    sprintf(command,"/var/run/pptpc/pptpc%d",(MAX_PPTP_CLIENT_NUM-1+MAX_L2TP_CLIENT_NUM+MAX_L2TP_CLIENT_NUM+MAX_NO_ACCOUNT_POOL));
    				fd = fopen(command,"w");
    				fprintf(fd,"%d",2);
    				fclose(fd);
    				#ifdef FOR_DEBUG
					 pptp_error("PPTPC: pptp.c: Listing to eth0\r\n");
					#endif
					dialondemand(WANPORTNAME);
			}
		}
	}
  }
  #endif


  #ifdef EMBED
    openlog(argv[0],LOG_PID,LOG_USER);
  #endif

  if (argc < 2)
    usage(argv[0]);

  #ifdef SUCC
    pid2 = setsid();
    chdir("/");
    close(0);
    close(1);
    close(2);

    /* 20030521 marked by succ, not necessary anymore */
    /* record pptp pid */
    /* 
    sprintf(command,"/var/run/pptp/pptp%d.pid",ui_num);
    fd = fopen(command,"w");
    fprintf(fd,"%d/n%d",pid2,getpid());
    fclose(fd);
    */
  #endif

  /* ************************************************** */
  /* Step 1: Get IP address for the hostname in argv[1] */
  /* ************************************************** */
#ifdef FOR_DEBUG
  pptp_debug("Step 1: Get IP address for the hostname in argv[1]");
#endif  
  inetaddr = get_ip_address(argv[1]);
  if(inetaddr.s_addr == 0) {
      pptp_error("get_ip_address failed, exiting");
	  sleep(RESPAWN_DELAY);
 //eric add change connect status unconnect change status to 0 -20040427 
	  sprintf(command,"/var/run/pptpc/pptpc%d",ui_num);
	  fd = fopen(command,"w");
      fprintf(fd,"%d",0);
	  fclose(fd);			
  
      exit(-1);
  
  }

  /* ******************************************* */
  /* Step 2: Open connection to call manager     */
  /*         (Launch call manager if necessary.) */
  /* ******************************************* */
#ifdef FOR_DEBUG
  pptp_debug("Step 2: Open connection to call manager");
#endif
  callmgr_sock = open_callmgr(inetaddr, argc,argv,envp);
  if(callmgr_sock < 0){
    pptp_error("Could not open connection to call manager - terminating");
	sleep(RESPAWN_DELAY);
 //eric add change connect status unconnect change status to 0 -20040427
    sprintf(command,"/var/run/pptpc/pptpc%d",ui_num);
    fd = fopen(command,"w");
	fprintf(fd,"%d",0);
 	fclose(fd);
  
	exit(1);
  }
  pptp_debug("callmgr opened - fd = %x", callmgr_sock);

  #ifdef SUCC
    /* record peerip for remove link file of pptp_callmgr */
    //strcpy(peerip,inet_ntoa(inetaddr));
  #endif

  /* ********************************** */
  /* Step 3: Find an open pty/tty pair. */
  /* ********************************** */
#ifdef FOR_DEBUG
  pptp_debug("Step 3: Find an open pty/tty pair.");
#endif
  pty_fd = getpseudotty(ttydev, ptydev);
  if (pty_fd < 0) {
    close(callmgr_sock);
    pptp_error("Could not find free pty.");
    sleep(RESPAWN_DELAY);
 //eric add change connect status unconnect change status to 0 -20040427
 	sprintf(command,"/var/run/pptpc/pptpc%d",ui_num);
 	fd = fopen(command,"w");
 	fprintf(fd,"%d",0);
 	fclose(fd);
	exit(1);
  }
  pptp_debug("got a free ttydev");

  /* ********************** */  
  /* Step 4: fork and wait. */
  /* ********************** */
#ifdef FOR_DEBUG
  pptp_debug("Step 4: fork and wait.");
#endif
  signal(SIGUSR1, do_nothing); /* don't die */

  #ifndef HAVE_FORK
    switch (child_pid = vfork()) {
  #else
    switch (child_pid = fork()) {     //##### succ_for_brecis
  #endif
  case -1:
    signal(SIGUSR1, SIG_DFL);
    pptp_debug("vfork failed %s", strerror(errno));
    sleep(RESPAWN_DELAY);
    goto shutdown;

  case 0: /* I'm the child! */
    //signal(SIGUSR1, SIG_DFL);

    #ifdef SUCC
      /* record pid of pppd for closing connection */
      sprintf(command,"/var/run/pptpc/pptp_pppd%d.pid",ui_num);
      fd = fopen(command,"w");
      fprintf(fd,"%d",getpid());
      fclose(fd);
    #endif


    pptp_debug("entered child");
    pptp_debug("callids established..");
    close(callmgr_sock);     


	reset_pppserver_gateway();		//set route rule to ppp server
    #ifdef SUCC
                                //1 for -D
      launch_pppd(ttydev, argc-2-1, argv+2); /* launch pppd */
    #else
      launch_pppd(ttydev, argc-2, argv+2); /* launch pppd */
    #endif

    sleep(RESPAWN_DELAY);

    exit(1); /* in case launch_pppd returns */
    break;

  default: /* parent */
    /*
     * There is still a very small race condition here.  If a signal
     * occurs after signaled is checked but before pause is called,
     * things will hang.
     */
    #if 0
      if (!signaled) {
        pause(); /* wait for the signal */
      }
      pptp_error("Error %s", strerror(errno));
    #endif /*0*/
    break;
  }
 
  get_call_id(callmgr_sock, parent_pid, child_pid, &call_id, &peer_call_id);

  /* ********************************** */
  /* Step 5: Exchange PIDs, get call ID */
  /* ********************************** */
#ifdef FOR_DEBUG
  pptp_debug("Step 5: Exchange PIDs, get call ID");
#endif
  #if 0
    /* Step 5b: Send signal to wake up pppd task */
    kill(parent_pid, SIGUSR1);
    sleep(2);
  #endif /*0*/

  if (sigsetjmp(env, 1)!=0) goto shutdown;
  signal(SIGINT,  sighandler);
  signal(SIGTERM, sighandler);
  signal(SIGKILL, sighandler);

  {
    char buf[128];
    snprintf(buf, sizeof(buf), "pptp: GRE-to-PPP gateway on %s", ptydev);
    inststr(argc,argv,envp, buf);
  }

  #ifdef SUCC
    callmgr_sock_copy = callmgr_sock;
    pty_fd_copy = pty_fd;
  #endif

  /* ****************************************************************** */
  /* Step 6: Do GRE copy until close. (reliability  problem is here ??) */
  /* ****************************************************************** */ 
#ifdef FOR_DEBUG
  pptp_debug("Step 6: Do GRE copy until close.");
#endif
  pptp_gre_copy(peer_call_id, call_id, pty_fd, inetaddr, /*pid2*/getpid());

shutdown:
  /* on close, kill all (everyone in our process group). */
  kill(0, SIGTERM);
  if (pty_fd != -1)
    close(pty_fd);
  if (callmgr_sock != -1)
    close(callmgr_sock);

  pptp_debug("PPTP client disconnect ok!!\n");

  exit(0);
}

/*
 * search through a possible list of ',' seperated ip addresses, try
 * each one,  if it works then use that one
 */
struct in_addr get_ip_address(char *name) {
  struct in_addr retval;
  struct sockaddr_in dest;
  int s;
  char *cp, *np;

  retval.s_addr = 0;
  for (cp = name; cp && *cp; cp = np) {

    if (np = strchr(cp, ','))
    	*np++ = '\0';
    pptp_error("Trying host %s ...", cp);
    if (inet_aton(cp, &retval) == 0) {
      struct hostent *host = gethostbyname(cp);
      if (host==NULL) {
	    if (h_errno == HOST_NOT_FOUND)
	      pptp_error("gethostbyname: HOST NOT FOUND");
	    else if (h_errno == NO_ADDRESS)
	      pptp_error("gethostbyname: NO IP ADDRESS");
	    else
	      pptp_error("gethostbyname: name server error");
	    continue;
      }
      if (host->h_addrtype != AF_INET) {
	    pptp_error("Host has non-internet address");
	    continue;
	  }
      memcpy(&retval.s_addr, host->h_addr, sizeof(retval.s_addr));
    }

    if (np)
    	*(np - 1) = ','; /* put string back how we found it */

    bzero(&dest, sizeof(dest));
    dest.sin_family = AF_INET;
    dest.sin_port   = htons(PPTP_PORT);
    dest.sin_addr   = retval;
    pptp_debug("socket");
    if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
      pptp_error("Cannot get socket: %s", strerror(errno));
      continue;
    }
    pptp_debug("Connect");
    signal(SIGALRM, do_alarm);
    alarm(15);
    if (connect(s, (struct sockaddr *) &dest, sizeof(dest)) != -1) {
      alarm(0);
      pptp_error("Connect succeeded");
      close(s);
      return(retval);
    }
    alarm(0);
	close(s);
    pptp_error("Connect failed: %s",strerror(errno));
  }
  retval.s_addr = 0;
  return retval;
}

int open_callmgr(struct in_addr inetaddr, int argc, char **argv, char **envp) {
  /* Try to open unix domain socket to call manager. */
  struct sockaddr_un where;
  const int NUM_TRIES = 3;
  int i, fd;

  /* Open socket */
  if ((fd = socket(AF_UNIX, SOCK_STREAM, 0)) < 0) {
    pptp_error("Could not create unix domain socket: %s", strerror(errno));
    return(-1);
  }

  /* Make address */
  where.sun_family = AF_UNIX;
  //#define PPTP_SOCKET_PREFIX "/var/run/pptpc/"
  snprintf(where.sun_path, sizeof(where.sun_path), 
	   PPTP_SOCKET_PREFIX "%s", inet_ntoa(inetaddr));

  for (i=0; i<NUM_TRIES; i++) {
    if (connect(fd, (struct sockaddr *) &where, sizeof(where)) < 0) {
      /* couldn't connect.  We'll have to launch this guy. */
      launch_callmgr(inetaddr, argc,argv,envp);
      sleep(3);
    }
    else return fd;
  }
  close(fd);
  pptp_error("Could not launch call manager after %d tries.", i);
  return -1;   /* make gcc happy */
}

void launch_callmgr(struct in_addr inetaddr, int argc,char**argv,char**envp) {

  pid_t pid;
  int status;
  //pptp_callmgr.h:#define PPTP_CALLMGR_BINARY "/bin/pptp_callmgr"
  const char *callmgr = PPTP_CALLMGR_BINARY;

  #ifdef SUCC
    char command[30];
    FILE *fd;
  #endif

  /* fork and launch call manager process */
  #ifndef HAVE_FORK
    switch (pid=vfork()) {
  #else
    switch (pid=fork()) {
  #endif
  case -1: /* baaad */
    pptp_error("callmgr vfork failed: %s", strerror(errno));
    break;

  case 0: /* child */
    { 
      #if 0
        int callmgr_main(int argc, char**argv, char**envp);
        char *my_argv[2] = { argv[0], inet_ntoa(inetaddr) };
        char buf[128];
        snprintf(buf, sizeof(buf), "pptp: call manager for %s", my_argv[1]);
        inststr(argc,argv,envp,buf);
        exit(callmgr_main(2, my_argv, envp));
      #endif

      #ifdef SUCC
        /* record pid of pptp_callmgr for kill pptp_callmgr */
        sprintf(command,"/var/run/pptpc/cm%d",ui_num);
        fd = fopen(command,"w");
        fprintf(fd,"%d",getpid());
        fclose(fd);
      #endif

      execlp(callmgr, callmgr, inet_ntoa(inetaddr), NULL);
      pptp_error("execlp() of call manager [%s] failed: %s", 
	      callmgr, strerror(errno));
      exit(1); /* or we trash our parents stack */
    }
  default: /* parent */
    #if 0 /* we don't care about status */
      waitpid(pid, &status, 0);
      if (status!=0)
        pptp_error("Call manager exited with error %d", status);
    #endif
    break;
  }
}

/* XXX need better error checking XXX */
void get_call_id(int sock, pid_t gre, pid_t pppd, 
		 u_int16_t *call_id, u_int16_t *peer_call_id) {
  u_int16_t m_call_id, m_peer_call_id;
  /* write pid's to socket */
  /* don't bother with network byte order, because pid's are meaningless
   * outside the local host.
   */
  write(sock, (char *)&gre, sizeof(gre));
  write(sock, (char *)&pppd, sizeof(pppd));
  pptp_debug("wrote socket information, waiting for read...");
  read(sock,  (char *)&m_call_id, sizeof(m_call_id));
  read(sock,  (char *)&m_peer_call_id, sizeof(m_peer_call_id));
  pptp_debug("Read socket information !!");
  /* XXX FIX ME ... DO ERROR CHECKING & TIME-OUTS XXX */
  *call_id = m_call_id;
  *peer_call_id = m_peer_call_id;
}

void launch_pppd(char *ttydev, int argc, char **argv) {
  
  #ifdef _WAN_PPTP
  char *new_argv[argc+9]; /* XXX if not using GCC, hard code a limit here. */
  #else
  char *new_argv[argc+6];
  #endif
  
  int i;

  //eric add
  FILE *wanfd;	
  char wantype[5];
  bzero(wantype,sizeof(wantype));
  wanfd = fopen("/var/run/pptpc/pptp_wantype_info","r");
  if(wanfd!=NULL){
	fgets(wantype,5,wanfd);
	fclose(wanfd);
  }
  //add end
  
  //pptp.c:#define PPPD_BINARY "pppd"
  new_argv[0] = PPPD_BINARY;
  new_argv[1] = ttydev;
  new_argv[2] = "38400";

  for (i=0; i<argc; i++)
    new_argv[i+3] = argv[i];

  new_argv[i+5]=argv[i];
  new_argv[i+3]="-S";
  new_argv[i+4]=new_argv[i+2];
  #ifdef _WAN_PPTP
  if( atoi(wantype)==WT_PPTP )
  {	 
	new_argv[i+5]="defaultroute";
  	new_argv[i+6]="noauth";        //add by eric  #pptp_client doesn't need peer's authentication. -20040323

  	if( atoi(pptp_idle_time) ){ 	// set PPTP_client idle time add by eric -20040427
		new_argv[i+7]="idle";
  		new_argv[i+8]=pptp_idle_time;  
  		new_argv[i+9]=NULL;
  	}
  	else{
		new_argv[i+7]=NULL;
  	}
	
  }
  else{
	new_argv[i+5]="noauth";      //add by eric  #pptp_client doesn't need peer's authentication -20040323
	new_argv[i+6]=NULL;
  }
  #else
  if( atoi(wantype)!=WT_PPTP )
  {	   
  	new_argv[i+5]="noauth";      //add by eric  #pptp_client doesn't need peer's authentication -20040323
  	new_argv[i+6]=NULL;
  }
  #endif

 #ifdef FOR_DEBUG 
  for(i=0;new_argv[i]!=NULL;i++){
	syslog(LOG_INFO,"new_argv[%d]=%s",i,new_argv[i]);
  }
 #endif 
  
  execvp(new_argv[0], new_argv);
}

#if 0
/*************** COMPILE call manager into same binary *********/
#define main       callmgr_main
#define sighandler callmgr_sighandler
#define do_nothing callmgr_do_nothing
#include "pptp_callmgr.c"
#endif


void reset_pppserver_gateway(void)
{
	FILE *fp;
	unsigned long gateway;
	short gw_ip[4]; 
	char server_ip[20],temp[20];
	char command[120];
	int i;
	bzero(server_ip,sizeof(server_ip));
	fp = fopen("/var/run/pptpc/pptp_wantype_info","r");	
	if ( fp != NULL ){ 					//check wantype and get server ip
		for(i=0;i<3;i++){
			fgets(temp,sizeof(temp) ,fp );
		}
		strncpy(server_ip,temp,(strlen(temp)-1) );			//delete string end '\n' char
		fclose(fp);

		gateway = getWANroute(WANPORTNAME);
		for(i=0;gateway>0;i++){         //paser gateway ip
			gw_ip[i]=gateway%256;
			gateway /= 256;
		}
		sprintf(command,"route add -host %s gw %d.%d.%d.%d dev %s ",server_ip
				                                                   ,gw_ip[3],gw_ip[2],gw_ip[1],gw_ip[0]
																   ,WANPORTNAME);
		system(command);        //add pptp server routing to routing table
		syslog(LOG_INFO,"pptp_wantype:%s",command);
	}
	else{ return;	}		//if not pptp wantype do nothing
}
