#define FOR_DEBUG



#include "spap_host.h"

#define NIPQUAD(addr) \
        ((unsigned char *)&addr)[0], \
        ((unsigned char *)&addr)[1], \
        ((unsigned char *)&addr)[2], \
        ((unsigned char *)&addr)[3]

#ifdef DEBUG_ALL
	#define DEBUG_LEVEL3	// unimportant
#endif

// DEBUG_LEVEL1 - only important messages
// DEBUG_LEVEL2 - important and general messages
// DEBUG_LEVEL3 - all messages
#ifdef DEBUG_LEVEL3
	#define DEBUG_LEVEL2
	#define DEBUG_LEVEL1
#endif

#ifdef DEBUG_LEVEL2
	#define DEBUG_LEVEL1
#endif

#ifdef FOR_DEBUG
  #undef DEBUG_LEVEL1
  #undef DEBUG_LEVEL2
  #undef DEBUG_LEVEL3
#endif

static int inbound_num = 0;

int atoh(char *src, char *dst, int dst_len)
{
        char temp[] = "0000000000";
        int len;

        // the required length is longer than the length of temp,
        // so we can't create this string.
        if(dst_len >= strlen(temp))
                return 0;

        sprintf(dst, "%x", atoi(src));
        len = dst_len - strlen(dst);
        if(len != 0)
        {
                memcpy(temp + len, dst, strlen(dst));
                temp[dst_len] = 0;
                memcpy(dst, temp, dst_len + 1);
#ifdef DEBUG_LEVEL3
                fprintf(stderr, "dst = %s\n", dst);
#endif
                return 1;
        }
        else
        {
#ifdef DEBUG_LEVEL3
                fprintf(stderr, "dst = %s\n", dst);
#endif
                return 1;
        }
}

int htoi(char *src, int len)
{
	int i;
	int result;
	char temp;
	
#ifdef DEBUG_LEVEL3
	fprintf(stderr, "#htoi: src = ");
	for(i = 0; i < len; i++)
		fprintf(stderr, "%c", *(src + i));
	fprintf(stderr, "\n");
#endif	
	for(i = len - 1, result = 0; i >=0; i--)
	{
		temp = *(src + i);
		if(temp >= '0' && temp <= '9')
			result += (temp - '0') << (4 * (len - i - 1));
		else if(temp >= 'a' && temp <= 'f')
			result += (temp - 'a' + 10) << (4 * (len - i - 1));
		else
			return -1;
#ifdef DEBUG_LEVEL3
		fprintf(stderr, "#htoi: i = %d, result = %d\n", i, result);
#endif
	}
#ifdef DEBUG_LEVEL2
	fprintf(stderr, "#htoi: result = %d\n", result);
#endif
	return result;
}

/* ==================================== */
/* sspap.hostAref_ptrҫV@	*/
/* 檺timeoutȡC			*/
/* ==================================== */
int refresh_timeout(FILE *ref_ptr)
{
	char temp[21];
	char new_timeout[9];
#ifdef DEBUG_LEVEL3
	char host_format[25];
	fgets(host_format, 26, ref_ptr);
	fprintf(stderr, "#refresh_timeout: fd = %s\n", host_format);
	fseek(ref_ptr, -25L, SEEK_CUR);
#endif
	sprintf(temp, "%ld", time(NULL) + TIMEOUT);
	atoh(temp, new_timeout, 8);
#ifdef DEBUG_LEVEL2
	fprintf(stderr, "#refresh_timeout: new_timeout = %s\n", new_timeout);
#endif
	fprintf(ref_ptr, "%s", new_timeout);
	return 1;
}

/* ==================================== */
/* bspap.hostA[JsconnectionA	*/
/* ثeǦ^ȥu1AҥHǦ^ȨS	*/
/* NqC				*/
/* ==================================== */
int new_spap_connection(int type, char *host_info)
{
	FILE *host;
	FILE *host_temp;
	int line_counter;
	char temp;
	char time_str[21];
	char new_timeout[9];
	#ifdef DEBUG_LEVEL3
	  fprintf(stderr, "#new_spap_connection: host_info = %s\n", host_info);
	#endif
	
	if ((host = fopen(SPAP_HOST, "r")) == NULL) {
		#ifdef FOR_DEBUG
			printf("ipqueue: new_spap_connection: Open spap.host read file fail\r\n");
		#endif
		return 0;
	}
	if ((host_temp = fopen("/var/config/spap/spap.host.tmp", "w")) == NULL) {
		#ifdef FOR_DEBUG
			printf("ipqueue: new_spap_connection: Open spap.host.tmp write file fail\r\n");
		#endif
		return 0;
	}
	
	line_counter = 1;
	while(line_counter < type)
	{
		temp = fgetc(host);
		while(temp != '\n')
		{
			fprintf(host_temp, "%c", temp);
			temp = fgetc(host);
		}
		fprintf(host_temp, "%c", temp);
		line_counter++;
	}
	#ifdef FOR_DEBUG
		printf("ipqueue: new_spap_connection: To update %dth line in spap.host\r\n",line_counter);
	#endif
	
	// Prepare a line of data
	sprintf(time_str, "%ld", time(NULL) + TIMEOUT);
	atoh(time_str, new_timeout, 8);
	fprintf(host_temp, "%s%s\n", new_timeout, host_info);
	#ifdef DEBUG_LEVEL2
		fprintf(stderr, "#new_spap_connection: %s%s\n", new_timeout, host_info);
	#endif
	#ifdef FOR_DEBUG
		printf("ipqueue: new_spap_connection: Prepare the data for the line in spap.host\r\n");
	#endif
	
	// Skip the original line
	temp = fgetc(host);
	while(temp != '\n' && temp != EOF)
	{
		temp = fgetc(host);
	}
	#ifdef FOR_DEBUG
		printf("ipqueue: new_spap_connection: Skip the original line\r\n");
	#endif
	
	// Copy others
	temp = fgetc(host);
	while(temp != EOF)
	{
		fprintf(host_temp, "%c", temp);
		temp = fgetc(host);
	}
	fprintf(host_temp, "%c", temp);
	#ifdef FOR_DEBUG
		printf("ipqueue: new_spap_connection: Copy others\r\n");
	#endif
	
	fclose(host_temp); fclose(host);
	
	remove(SPAP_HOST);
	rename("/var/config/spap/spap.host.tmp", SPAP_HOST);
	#ifdef FOR_DEBUG
		printf("ipqueue: new_spap_connection: Rename temp file to spap.host\r\n");
		printf("ipqueue: new_spap_connection: The new spap.conf:\r\n");
		system("cat /var/config/spap/spap.conf");
	#endif
	
	return 1;
}

int add_iptables_rule(int type, int trig_port, char *host_info, int len)
{
	FILE *dmz;
	char dmz_host[16];
	char command[112];
	char src_ip[16];
	char port_range[12];
	int i = 0, j = 0;

	if ((dmz = fopen("/var/config/spap/dmz", "r")) == NULL) {
		dmz_host[0] = 0x00;
	} else {
		fgets(dmz_host, 16, dmz);
		fclose(dmz);
	}
	
	// iptables -t mangle -D spap_out -p tcp --dport %d -j MARK --set-mark %d
	sprintf(command, "iptables -t mangle -D spap_out -p tcp --dport %d -j MARK --set-mark %d",
		trig_port, type + 99);
	#ifdef DEBUG_LEVEL3
		fprintf(stderr, "#add_iptables_rule: %s\n", command);
	#endif
	system(command);
	#ifdef FOR_DEBUG
		printf("ipqueue: add_iptables_rule: %s\r\n",command);
	#endif
	
	// iptables -t mangle -D spap_out -p udp --dport %d -j MARK --set-mark %d
	memcpy(&command[34], (void *)"udp", 3);
	#ifdef DEBUG_LEVEL3
		fprintf(stderr, "#add_iptables_rule: %s\n", command);
	#endif
	system(command);
	#ifdef FOR_DEBUG
		printf("ipqueue: add_iptables_rule: %s\r\n",command);
	#endif
	
	// iptables -t filter -D spap_out -p tcp --dport %d -j QUEUE
	sprintf(command, "iptables -t filter -D spap_out -p tcp --dport %d -j QUEUE", trig_port);
	#ifdef DEBUG_LEVEL3
		fprintf(stderr, "#add_iptables_rule: %s\n", command);
	#endif
	system(command);
	#ifdef FOR_DEBUG
		printf("ipqueue: add_iptables_rule: %s\r\n",command);
	#endif

	// iptables -t filter -D spap_out -p udp --dport %d -j QUEUE
	memcpy(&command[34], (void *)"udp", 3);
	#ifdef DEBUG_LEVEL3
		fprintf(stderr, "#add_iptables_rule: %s\n", command);
	#endif
	system(command);
	#ifdef FOR_DEBUG
		printf("ipqueue: add_iptables_rule: %s\r\n",command);
	#endif
	
	//j = (len - 8)/8;
	j = (len)/8;
	printf("len=%d, j=%d\n",len,j);
	#ifdef DEBUG_LEVEL3
		fprintf(stdout, "#add_iptables_rule: len = %d, there are %d port range in this rule\n", len, j);
	#endif
	sprintf(src_ip, "%d.%d.%d.%d", htoi(host_info + (i * 16), 2), htoi(host_info + (i * 16) + 2, 2), htoi(host_info + (i * 16) + 4, 2), htoi(host_info + (i * 16) + 6, 2));
	for(i = 0; i < j; i++)
	{
		printf("hi\n");
		sprintf(port_range, "%d:%d", htoi(host_info + ((i + 1) * 8), 4), htoi(host_info + ((i + 1) * 8) + 4, 4));
		// iptables -t nat -I spap_in -p tcp --dport [lport:uport] -j DNAT --to [src_ip]
		sprintf(command, "iptables -t nat -I spap_in -p tcp --dport %s -j DNAT --to %s", port_range, src_ip);
		#ifdef DEBUG_LEVEL3
			fprintf(stderr, "#add_iptables_rule: %s\n", command);
		#endif
		system(command);
		#ifdef FOR_DEBUG
			printf("ipqueue: add_iptables_rule: %s\r\n",command);
		#endif

		// iptables -t nat -I spap_in -p udp --dport [lport:uport] -j DNAT --to [src_ip]	
		memcpy(&command[30], (void *)"udp", 3);
		#ifdef DEBUG_LEVEL3
			fprintf(stderr, "#add_iptables_rule: %s\n", command);
		#endif
		system(command);
		#ifdef FOR_DEBUG
			printf("ipqueue: add_iptables_rule: %s\r\n",command);
		#endif

		// iptables -t mangle -I spap_in -p tcp --dport [lport:uport] -j MARK --set-mark %d
		sprintf(command, "iptables -t mangle -I spap_in -p tcp --dport %s -j MARK --set-mark %d", port_range, type + 199);
		#ifdef DEBUG_LEVEL3
			fprintf(stderr, "#add_iptables_rule: %s\n", command);
		#endif
		system(command);
		#ifdef FOR_DEBUG
			printf("ipqueue: add_iptables_rule: %s\r\n",command);
		#endif

		// iptables -t mangle -I spap_in -p udp --dport [lport:uport] -j MARK --set-mark %d
		memcpy(&command[33], (void *)"udp", 3);
		#ifdef DEBUG_LEVEL3
			fprintf(stderr, "#add_iptables_rule: %s\n", command);
		#endif
		system(command);
		#ifdef FOR_DEBUG
			printf("ipqueue: add_iptables_rule: %s\r\n",command);
		#endif
	
		// iptables -t filter -I spap_in -p tcp --dport [lport:uport] -j QUEUE
		sprintf(command, "iptables -t filter -I spap_in -p tcp --dport %s -j QUEUE", port_range);
		#ifdef DEBUG_LEVEL3
			fprintf(stderr, "#add_iptables_rule: %s\n", command);
		#endif
		system(command);
		#ifdef FOR_DEBUG
			printf("ipqueue: add_iptables_rule: %s\r\n",command);
		#endif
	
		// iptables -t filter -I spap_in -p tcp --dport [lport:uport] -j QUEUE
		memcpy(&command[33], (void *)"udp", 3);
		#ifdef DEBUG_LEVEL3
			fprintf(stderr, "#add_iptables_rule: %s\n", command);
		#endif
		system(command);
		#ifdef FOR_DEBUG
			printf("ipqueue: add_iptables_rule: %s\r\n",command);
		#endif
	}
	
	inbound_num++;
	
	return 1;
}

/* ==================================== */
/* sإ߳oipʥ]host_format, 	*/
/* ]Atimeout]host format`@32 	*/
/* byte^ApGإߡAǦ^1ApG	*/
/* AǦ^0C				*/
/* host format:				*/
/* 8byte       8byte       8byte        */
/* +-----------+-----------+----------+ */
/* | src. ip   | dst. ip   | allowed  | */
/* |           |           | port     | */
/* +-----------+-----------+----------+ */
/*					*/
/* NoteG				*/
/* ]host formatsrc. ipdst. ip*/
/* OHѤV~ʥ]ǡ]]NOsrc.ip */
/* @wOLAN ipAdst.ip@wOWAN ip^A */
/* ҥHrebuild host formatinM	*/
/* outءC				*/
/* out - from LAN to WAN		*/
/* ==================================== */
int rebuild_spap_out(int type, int *trig_port, struct iphdr *iph, char **target)
{
	FILE 			*conf;
	// 2002/08/24 PJ
	//char 			conf_format[14];
	char 			*conf_format;
	char 			word;
	int 			line_counter;
	int 			word_counter;
	//
	struct tcphdr 	*tcph;
	struct udphdr 	*udph;
	unsigned char 	*temp;
	__u32 			temp_ip;
	char 			hip1[4];
	char 			hip2[4];
	char 			hip3[4];
	char 			hip4[4];
	char 			dport[6];
	#ifdef DEBUG_LEVEL3
	  char 			*iph_temp = (char *)iph;
	#endif
	char 			str80[80];

	if(iph->protocol == 6)	// TCP
	{
		
		#ifdef DEBUG_LEVEL3
		  fprintf(stderr, "#rebuild_spap_out: TCP\n");
		  fprintf(stderr, "#rebuild_spap_out: IP header\n%2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x\n%2x %2x %2x %2x\n",
		  	*iph_temp, *(iph_temp + 1), *(iph_temp + 2), *(iph_temp + 3), *(iph_temp + 4), *(iph_temp + 5),
		  	*(iph_temp + 6), *(iph_temp + 7), *(iph_temp + 8), *(iph_temp + 9), *(iph_temp + 10), *(iph_temp + 11),
		   	*(iph_temp + 12), *(iph_temp + 13), *(iph_temp + 14), *(iph_temp + 15), *(iph_temp + 16), *(iph_temp + 17),
		  	*(iph_temp + 18), *(iph_temp + 19));
		#endif
		#ifdef FOR_DEBUG
		  printf("ipqueue: rebuild_spap_out: TCP packet\r\n");
		#endif
		
		// we copy src.ip and dst.ip to the first 16 bytes of dst
		temp_ip = iph->saddr;
		#ifdef DEBUG_LEVEL3
		  	fprintf(stderr, "#rebuild_spap_out: temp_ip = %d.%d.%d.%d\n", NIPQUAD(temp_ip));
		#endif
		#ifdef FOR_DEBUG
		  	printf("ipqueue: rebuild_spap_out: temp_ip = %d.%d.%d.%d\r\n", NIPQUAD(temp_ip));
		#endif
		
		temp = ((unsigned char *)(&temp_ip)); sprintf(hip1, "%02x", *temp);
		temp = ((unsigned char *)(&temp_ip)) + 1; sprintf(hip2, "%02x", *temp);
		temp = ((unsigned char *)(&temp_ip)) + 2; sprintf(hip3, "%02x", *temp);
		temp = ((unsigned char *)(&temp_ip)) + 3; sprintf(hip4, "%02x", *temp);
		#ifdef FOR_DEBUG
		  	printf("ipqueue: rebuild_spap_out: temp_ip = %s.%s.%s.%s\r\n", 
		  			hip1, hip2, hip3, hip4);
		#endif
                
		tcph = (struct tcphdr *)((char *)iph + (iph->ihl << 2));
		*trig_port = ntohs(tcph->dest);
		sprintf(dport, "%d", *trig_port);
		atoh(dport, dport, 4);
		#ifdef FOR_DEBUG
		  printf("ipqueue: rebuild_spap_out: dport = %s\r\n", dport);
		#endif
	}
	else if(iph->protocol == 17)	// UDP
	{
		#ifdef DEBUG_LEVEL3
                  fprintf(stderr, "#rebuild_spap_out: UDP\n");
		  fprintf(stderr, "#rebuild_spap_out: IP header\n%2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x\n%2x %2x %2x %2x\n",
                        *iph_temp, *(iph_temp + 1), *(iph_temp + 2), *(iph_temp + 3), *(iph_temp + 4), *(iph_temp + 5),
                        *(iph_temp + 6), *(iph_temp + 7), *(iph_temp + 8), *(iph_temp + 9), *(iph_temp + 10), *(iph_temp + 11),
                        *(iph_temp + 12), *(iph_temp + 13), *(iph_temp + 14), *(iph_temp + 15), *(iph_temp + 16), *(iph_temp + 17),
                        *(iph_temp + 18), *(iph_temp + 19));
		#endif
		// we copy src.ip and dst.ip to the first 16 bytes of dst
		temp_ip = iph->saddr;
		#ifdef DEBUG_LEVEL3
                  fprintf(stderr, "#rebuild_spap_out: temp_ip = %d.%d.%d.%d\n", NIPQUAD(temp_ip));
		#endif
                temp = ((unsigned char *)(&temp_ip)); sprintf(hip1, "%02x", *temp);
		temp = ((unsigned char *)(&temp_ip)) + 1; sprintf(hip2, "%02x", *temp);
		temp = ((unsigned char *)(&temp_ip)) + 2; sprintf(hip3, "%02x", *temp);
		temp = ((unsigned char *)(&temp_ip)) + 3; sprintf(hip4, "%02x", *temp);
		#ifdef FOR_DEBUG
		  printf("ipqueue: rebuild_spap_out[udp]: temp_ip = %s.%s.%s.%s\r\n", 
		  	hip1, hip2, hip3, hip4);
		#endif

		udph = (struct udphdr *)((char *)iph + (iph->ihl << 2));
		*trig_port = ntohs(udph->dest);
		sprintf(dport, "%d", *trig_port);
		atoh(dport, dport, 4);
	}
	else	// This packet is neither TCP nor UDP packet, we dont care about it
	{
		#ifdef DEBUG_LEVEL3
                	fprintf(stderr, "#rebuild_spap_out: this is neither TCP nor UDP packet, we can't rebuild host_format.\n");
		#endif
		#ifdef FOR_DEBUG
			printf("ipqueue: rebuild_spap_out: This packet is not TCP nor UDP\r\n");
		#endif
		*target = NULL;
		return 0;
	}

	#ifdef DEBUG_LEVEL3
		fprintf(stderr, "#rebuild_spap_out: opening config file - %s.\n", SPAP_CONF);
	#endif
	if ((conf = fopen(SPAP_CONF, "r")) == NULL) {
		#ifdef FOR_DEBUG
			printf("ipqueue: rebuild_spap_out: Open the configure file fail\r\n");
		#endif
	} else {
		#ifdef FOR_DEBUG
			printf("ipqueue: rebuild_spap_out: Open the configure file OK\r\n");
		#endif
	}
	
	line_counter = 1;
	if (type > 1) {
		fgets(str80,80,conf);
		while ((line_counter < type) && (str80 != NULL))
		{
			//word = fgetc(conf);
			//while(word != '\n' && word != EOF) word = fgetc(conf);
			if (++line_counter == type) break;
			fgets(str80,80,conf);
			
		}
	}
	if (line_counter == type) {
		#ifdef FOR_DEBUG
			printf("ipqueue: rebuild_spap_out: Line counter=%d\r\n",line_counter);
		#endif
	} else {
		#ifdef FOR_DEBUG
			printf("ipqueue: rebuild_spap_out: Lines not enough\r\n");
		#endif
		*target = NULL;
		return 0;
	}
	
	word_counter = 1;
	word = fgetc(conf);
	#ifdef FOR_DEBUG
		printf("ipqueue: rebuild_spap_out: The first byte in the line is 0x%02x\r\n",word);
	#endif
	while(word != '\n' && word != EOF)
	{
		word = fgetc(conf); word_counter++;
	}
	#ifdef FOR_DEBUG
		printf("ipqueue: rebuild_spap_out: Word counter=%d\r\n",word_counter);
	#endif
	
	*target = (char *)malloc(sizeof(char) * (word_counter + 8));
	sprintf(*target, "%s%s%s%s", hip1, hip2, hip3, hip4);
	#ifdef DEBUG_LEVEL3
        fprintf(stderr, " target = %s, dport = %s\n", *target, dport);
	#endif
	#ifdef FOR_DEBUG
		printf("ipqueue: rebuild_spap_out: target = %s, dport = %s\r\n", *target, dport);
	#endif
	
	conf_format = (char *)malloc(sizeof(char) * (word_counter + 1));
	fseek(conf,  -word_counter, SEEK_CUR);
	if((fgets(conf_format, word_counter + 1, conf)) != NULL)
	{
		#ifdef DEBUG_LEVEL3
			fprintf(stderr, "#rebuild_spap_out: conf = %s\n", conf_format);
		#endif
		#ifdef FOR_DEBUG
			printf("ipqueue: rebuild_spap_out: found rule: %s\r", conf_format);
		#endif
		
		// if enable
		if(conf_format[0] == '1')
		{
			// if dport == trigger port
			if(!strncmp(&conf_format[1], dport, 4))
			{
				// we copy allowed port to the last 8 byte of dst
				memcpy(*target + 8, &conf_format[5], (word_counter - 6));
				#ifdef DEBUG_LEVEL1
					fprintf(stderr, "#rebuild_spap_out: can rebuild host format, and host format = %s\n", *target);
				#endif
				fclose(conf);
				#ifdef FOR_DEBUG
					printf("ipqueue: rebuild_spap_out: match trigger rule\r\n");
				#endif
				return 1;
			}
		}
	}
	// packet passed to this function means this packet is a special ap,
	// but we can't find what kind of special ap it is, so it may have 
	// something wrong in special ap setting.
	#ifdef DEBUG_LEVEL3
		fprintf(stderr, "#rebuild_spap_out: cannot find rule.\n");
	#endif
	fclose(conf);
	*target = NULL;
	return 0;
}

/* ==================================== */
/* sإ߳oipʥ]host_format, 	*/
/* ]Atimeout]host format`@32 	*/
/* byte^ApGإߡAǦ^1ApG	*/
/* AǦ^0C				*/
/* host format:				*/
/* 8byte       8byte       8byte        */
/* +-----------+-----------+----------+ */
/* | src. ip   | dst. ip   | allowed  | */
/* |           |           | port     | */
/* +-----------+-----------+----------+ */
/*					*/
/* NoteG				*/
/* ]host formatsrc. ipdst. ip*/
/* OHѤV~ʥ]ǡ]]NOsrc.ip */
/* @wOLAN ipAdst.ip@wOWAN ip^A */
/* ҥHrebuild host formatinM	*/
/* outءC				*/
/* in - from WAN to LAN			*/
/* ==================================== */
int rebuild_spap_in(int type, int *trig_port, struct iphdr *iph, char **target)
{
	FILE *conf;
	// 2002/08/24 PJ
	//char conf_format[14];
	char *conf_format;
	char word;
	int line_counter;
	int word_counter;
	int i = 0, j = 0;
	//
	struct tcphdr *tcph = NULL;
	struct udphdr *udph = NULL;
	unsigned char *temp;
	__u32 temp_ip;
	char hip1[4];
	char hip2[4];
	char hip3[4];
	char hip4[4];
        char dport[6];
	int lport, uport;
#ifdef DEBUG_LEVEL3
        char *iph_temp = (char *)iph;
#endif
	
	if(iph->protocol == 6)	// TCP
	{
#ifdef DEBUG_LEVEL3
                fprintf(stderr, "#rebuild_spap_in: TCP\n");
		fprintf(stderr, "#rebuild_spap_in: IP header\n%2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x\n%2x %2x %2x %2x\n",
                        *iph_temp, *(iph_temp + 1), *(iph_temp + 2), *(iph_temp + 3), *(iph_temp + 4), *(iph_temp + 5),
                        *(iph_temp + 6), *(iph_temp + 7), *(iph_temp + 8), *(iph_temp + 9), *(iph_temp + 10), *(iph_temp + 11),
                        *(iph_temp + 12), *(iph_temp + 13), *(iph_temp + 14), *(iph_temp + 15), *(iph_temp + 16), *(iph_temp + 17),
                        *(iph_temp + 18), *(iph_temp + 19));
#endif
		// we copy src.ip and dst.ip to the first 16 bytes of dst
		temp_ip = iph->daddr;
#ifdef DEBUG_LEVEL3
                fprintf(stderr, "#rebuild_spap_in: temp_ip = %d.%d.%d.%d\n", NIPQUAD(temp_ip));
#endif
                temp = ((unsigned char *)(&temp_ip));
                if(*temp < 16)
                        sprintf(hip1, "0%x", *temp);
                else
                        sprintf(hip1, "%x", *temp);
                temp = ((unsigned char *)(&temp_ip)) + 1;
                if(*temp < 16)
                        sprintf(hip2, "0%x", *temp);
                else
                        sprintf(hip2, "%x", *temp);
                temp = ((unsigned char *)(&temp_ip)) + 2;
                if(*temp < 16)
                        sprintf(hip3, "0%x", *temp);
                else 
                        sprintf(hip3, "%x", *temp);
                temp = ((unsigned char *)(&temp_ip)) + 3;
                if(*temp < 16)
                        sprintf(hip4, "0%x", *temp);
                else
                        sprintf(hip4, "%x", *temp);

                tcph = (struct tcphdr *)((char *)iph + (iph->ihl << 2));
                *trig_port = ntohs(tcph->dest);
                sprintf(dport, "%d", *trig_port);
                atoh(dport, dport, 4);
	}
	else if(iph->protocol == 17)	// UDP
	{
#ifdef DEBUG_LEVEL3
                fprintf(stderr, "#rebuild_spap_in: UDP\n");
		fprintf(stderr, "#rebuild_spap_in: IP header\n%2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x %2x\n%2x %2x %2x %2x\n",
                        *iph_temp, *(iph_temp + 1), *(iph_temp + 2), *(iph_temp + 3), *(iph_temp + 4), *(iph_temp + 5),
                        *(iph_temp + 6), *(iph_temp + 7), *(iph_temp + 8), *(iph_temp + 9), *(iph_temp + 10), *(iph_temp + 11),
                        *(iph_temp + 12), *(iph_temp + 13), *(iph_temp + 14), *(iph_temp + 15), *(iph_temp + 16), *(iph_temp + 17),
                        *(iph_temp + 18), *(iph_temp + 19));
#endif
		// we copy src.ip and dst.ip to the first 16 bytes of dst
		temp_ip = iph->daddr;
#ifdef DEBUG_LEVEL3
                fprintf(stderr, "#rebuild_spap_in: temp_ip = %d.%d.%d.%d\n", NIPQUAD(temp_ip));
#endif
                temp = ((unsigned char *)(&temp_ip));
                if(*temp < 16)
                        sprintf(hip1, "0%x", *temp);
                else
                        sprintf(hip1, "%x", *temp);
                temp = ((unsigned char *)(&temp_ip)) + 1;
                if(*temp < 16)
                        sprintf(hip2, "0%x", *temp);
                else
                        sprintf(hip2, "%x", *temp);
                temp = ((unsigned char *)(&temp_ip)) + 2;
                if(*temp < 16)
                        sprintf(hip3, "0%x", *temp);
                else 
                        sprintf(hip3, "%x", *temp);
                temp = ((unsigned char *)(&temp_ip)) + 3;
                if(*temp < 16)
                        sprintf(hip4, "0%x", *temp);
                else
                        sprintf(hip4, "%x", *temp);

                udph = (struct udphdr *)((char *)iph + (iph->ihl << 2));
		*trig_port = ntohs(udph->dest);
                sprintf(dport, "%d", *trig_port);
                atoh(dport, dport, 4);
	}
	else	// This packet is neither TCP nor UDP packet, we dont care about it
	{
#ifdef DEBUG_LEVEL3
                fprintf(stderr, "#rebuild_spap_in: this is neither TCP nor UDP packet, we can't rebuild host_format.\n");
#endif
		*target = NULL;
		return 0;
	}

	conf = fopen(SPAP_CONF, "r");
	line_counter = 1;
	while(line_counter < type)
	{
		word = fgetc(conf);
		while(word != '\n' && word != EOF)
			word = fgetc(conf);
		line_counter++;
	}
	word_counter = 1;
	word = fgetc(conf);
	while(word != '\n' && word != EOF)
	{
		word = fgetc(conf);
		word_counter++;
	}
	*target = (char *)malloc(sizeof(char) * (word_counter + 8));
	sprintf(*target, "%s%s%s%s", hip1, hip2, hip3, hip4);
#ifdef DEBUG_LEVEL3
                fprintf(stderr, " target = %s, dport = %s\n", *target, dport);
#endif
	conf_format = (char *)malloc(sizeof(char) * (word_counter + 1));
	fseek(conf, -word_counter, SEEK_CUR);
	if((fgets(conf_format, (word_counter + 1), conf)) != NULL)
	{
		// if enable
		if(conf_format[0] == '1')
		{
			j = (word_counter - 6)/8;
			for(i = 0; i < j; i++)
			{
				lport = htoi(conf_format + 5 + (i * 8), 4);
				uport = htoi(conf_format + 9 + (i * 8), 4);
				if(*trig_port >= lport && *trig_port <= uport)
				{
					// we copy allowed port to the last 8 byte of dst
					memcpy(*target + 8, &conf_format[5], word_counter - 6);
#ifdef DEBUG_LEVEL1
					fprintf(stderr, "#rebuild_spap_in: can rebuild host format, and host format = %s\n", *target);
#endif
					fclose(conf);
					return 1;
				}
			}
		}
	}
	// packet passed to this function means this packet is a special ap,
	// but we can't find what kind of special ap it is, so it may have 
	// something wrong in special ap setting.
#ifdef DEBUG_LEVEL3
	fprintf(stderr, "#rebuild_spap_in: cannot find rule.\n");
#endif
	fclose(conf);
	*target = NULL;
	return 0;
}

/* ==================================== */
/* P_host_infoO_bspap.hostAp	*/
/* TG				*/
/* 1. YT椺eAhstime-	*/
/* outAreturn 1C			*/
/* 2. YT椣Ah\o*/
/* suAreturn 0C			*/
/* 3. YOWzpAhO@ӷssuA*/
/* Nnݨtypespecial apO_٦	*/
/* ŶieǳoӳsuAYAhsWsu	*/
/* Areturn 1AYLAhreturn 0C	*/
/* GAreturn 1ܬOspecial apAreturn */
/* 0ܤOspecial apC		*/
/* ==================================== */
int spap_out_confirm(int type, int dport, char *host_info)
{
	FILE 	*host;
	char 	host_format[522];
	char 	all_zero[] = "00000000";
	int 	line_counter;
	int 	word_counter;
	char 	temp;
	#ifdef DEBUG_LEVEL1
	  int 	i;
	#endif
	int 	can_use;
	
	if ((host = fopen(SPAP_HOST, "r+")) == NULL) {
		#ifdef FOR_DEBUG
			printf("ipqueue: spap_out_confirm: Open host file fail\r\n");
		#endif
		return 0;
	} 

	//@,  >= type
	line_counter = 1;
	while(line_counter < type)
	{
		temp = fgetc(host);
		while(temp != '\n' && temp != EOF)
			temp = fgetc(host);
		line_counter++;
	}
	#ifdef FOR_DEBUG
		printf("ipqueue: spap_out_confirm: Line counter=%d\r\n",line_counter);
	#endif
	
	//p⥻檺r
	word_counter = 1;
	temp = fgetc(host);
	while(temp != '\n' && temp != EOF)
	{
		temp = fgetc(host);
		word_counter++;
	}
	#ifdef FOR_DEBUG
		printf("ipqueue: spap_out_confirm: Word counter=%d\r\n",word_counter);
	#endif
	
	can_use = 0;
	fseek(host, -word_counter, SEEK_CUR);
	if(((fgets(host_format, sizeof(host_format), host)) != NULL))
	{
		//rꬰ'000000000'ɪܬOŪ
		if(!strncmp(host_format, all_zero, strlen(all_zero)))
		{
			#ifdef DEBUG_LEVEL2
				fprintf(stderr, "#spap_out_confirm: found empty connection.\n");
			#endif
			// iHJsconnection
			can_use = 1;
			#ifdef FOR_DEBUG
				printf("ipqueue: spap_out_confirm: Put in a new host entry\r\n");
			#endif
		}
		else if(!strncmp(host_info, host_format + 8, word_counter - (strlen(all_zero))))
		{
			// p]timeoutAusrc.ipallowed port^
			// ŦXAhstimeoutC
			#ifdef DEBUG_LEVEL1
				fprintf(stderr, "#spap_out_confirm: this is a used connection, so we just refresh it's timeout\n");
			#endif
			fseek(host, -word_counter, SEEK_CUR); 
			refresh_timeout(host);
			#ifdef FOR_DEBUG
				printf("ipqueue: spap_out_confirm: Update timeout\r\n");
			#endif
			fclose(host); return 1;
		}
		else if(!strncmp(host_info + 8, host_format + 16, word_counter - 17))
		{
			// p줣ŦXA̫@ŦXA
			// ]̫@Oallowed port^
			// ܬOnPDnάۦPspecial apA]@
			// u঳@xΡAҥH\C
			#ifdef DEBUG_LEVEL1
				fprintf(stderr, "#spap_out_confirm: cannot allow this connection, because already had ");
				for(i = 8; i < 16; i++)
					fprintf(stderr, "%c", *(host_format + i));
				fprintf(stderr, "use it.\n");
			#endif
			#ifdef FOR_DEBUG
				printf("ipqueue: spap_out_confirm: Discard another use of the ap\r\n");
			#endif
			fclose(host); return 0;
		}
	}
	
	// Sbspap.hostA]O\suA
	// ɭnݬݦSŦiH[JosuAY
	// h[JASNsorryo :-(C
	if(can_use)
	{	// ŦA[J :-)
		#ifdef DEBUG_LEVEL1
			fprintf(stderr, "#spap_out_confirm: this is a new connection, we add it\n");
		#endif
		//fseek(host, -word_counter, SEEK_CUR);
		//new_spap_connection(host, host_info);
		//add_iptables_rule(type, dport, host_info, word_counter - 9);
		//fclose(host);
		fclose(host);
		new_spap_connection(type, host_info);
		printf("host_info='%s' word_counter=%d\n",host_info,word_counter);
		//add_iptables_rule(type, dport, host_info, word_counter - 9);
		add_iptables_rule(type, dport, host_info, strlen(host_info) - 8);
		return 1;
	}
	else
	{	// SŦAuOi :-(
		#ifdef DEBUG_LEVEL1
			fprintf(stderr, "#spap_out_confirm: although this is an allowed new connection, but we don't have enough memory space\n");
		#endif
		fclose(host);
		#ifdef FOR_DEBUG
			printf("ipqueue: spap_out_confirm: No empty host entry in spap.host\r\n");
		#endif
		return 0;
	}
}

/* ==================================== */
/* P_host_infoO_bspap.hostA]	*/
/* Oѥ~VA@wOnT泣ۦP	*/
/* ~stimeoutC			*/
/* Y椺eAhstime-	*/
/* outAreturn 1C			*/
/* return 0ܨSAGSFiH	*/
/* stimeoutC			*/
/* ==================================== */
int spap_in_confirm(int type, int dport, char *host_info)
{
	FILE *host;
	char *host_format;
	int line_counter;
	int word_counter;
	char temp;
	
	host = fopen(SPAP_HOST, "r+");
	if(host == NULL)
		return 0;
	line_counter = 1;
	while(line_counter < type)
	{
		temp = fgetc(host);
		while(temp != '\n' && temp != EOF)
			temp = fgetc(host);
		line_counter++;
	}
	word_counter = 1;
	temp = fgetc(host);
	while(temp != '\n' && temp != EOF)
	{
		temp = fgetc(host);
		word_counter++;
	}
	host_format = (char *)malloc(((sizeof(char)) * (word_counter + 1)));
	fseek(host, -word_counter, SEEK_CUR);
	if(((fgets(host_format, (word_counter + 1), host)) != NULL))
	{
		if(!strncmp(host_info, (host_format + 8), (word_counter - 9)))
		{
			// p]timeout^ŦXAhstimeout
#ifdef DEBUG_LEVEL1
			fprintf(stderr, "#spap_in_confirm: we found this connection, so we refresh it's timeout\n");
#endif
			fseek(host, -word_counter, SEEK_CUR); 
			refresh_timeout(host);
			fclose(host);
			return 1;
		}
	}
	// Sbspap.hostA|queueLөOH
	// uOW䧮C
#ifdef DEBUG_LEVEL1
	fprintf(stderr, "#spap_in_confirm: this packet doesn't belong to a exist connection, why this packet be queued?\n");
#endif
	fclose(host);
	return 0;
}




