#include "match.h"

/*
******* ե *******
#include <time.h>

int main()
{
	char test1[100];
	char test2[100];
	int shift;
	clock_t start, end;
	
	fgets(test1, 100, stdin);
	fgets(test2, 100, stdin);
	
	test1[strlen(test1) - 1] = 0;
	test2[strlen(test2) - 1] = 0;

	start = clock();
	if(KMPmatch(test1, strlen(test1), test2, &shift))
	{
		printf("Shift = %d\n", shift);
	}
	else
	{
		printf("Not Match\n");
	}
	end = clock();
	printf("KMP match use %ld microsecond, start = %ld, end = %ld\n", end - start, start , end);
	

	start = clock();
	if(ptmatch(test1, strlen(test1), test2, &shift))
	{
		printf("Shift = %d\n", shift);
	}
	else
	{
		printf("Not Match\n");
	}
	end = clock();
	printf("ptmatch use %ld microsecond, start = %ld, end = %ld\n", end - start, start , end);
	
	//printf("OVER!\n");

	return 0;
}

*/



// -----------------------------------------------
// ptmatchGr
// char *dataGr
// u_int16_t data_lenGϤ
// char *urlGr
// int *positionGrYbϤm
//		  Ĥ@ӴNAhposition = 0
//		  ĤGӤAposition = 1
//		  ...
//		  ĢܭӤAposition = -1
//		  YSAh]-1
// ҦpG
//	- abcdefghijklmno
//	- fgh
//	position = 5
// Ǧ^ȡGϤЫhǦ^1
//         ϤLЫhǦ^0
// -----------------------------------------------
int ptmatch(char *data, u_int16_t data_len, char *url, int *position)
{
	int url_len;
	char temp;
	int i;
	int j, k;
	
	url_len = strlen(url);
	
	/*
	// ]fgets|NrsJA
	// ҥHnP_˼ƲĤGӦrO_'\n']̫@Ӥ@wO'\0'^
	// YOAhN'\n''\0'A
	// ñNurl_len - 1
	if(url[url_len-1] == '\n')
	{
		url_len--;
		url[url_len] = '\0';
	}
	//printf("url_len = %d\n", url_len);
	*/
	if(url_len > data_len)
	{
		if(position != NULL)
		{
			*position = -1;
		}
		return 0;
	}
	i = 0;
	while(i < data_len)
	{
		temp = *url;
		for(; i < data_len; i++)
		{
			if(temp == data[i])
				break;
		}
		if(i == data_len)
		{
			if(position != NULL)
			{
				*position = -1;
			}
			return 0;
		}
		//printf("match in data %d\n", i+1);
		i++;
		j = i;
		k = 1;
		while(1)
		{
			//printf("k = %d\n", k);
			if(j == data_len)
			{
				if(k == url_len)
				{
#ifdef DEBUG_PMATCH
					printf("Pattern Match!\n");
#endif
					if(position != NULL)
					{
						*position = i - 1;
					}
					return 1;
				}
				else
				{
					if(position != NULL)
					{
						*position = -1;
					}
					return 0;
				}
			}
			if(k == url_len)
			{
#ifdef DEBUG_PMATCH
				printf("Pattern Match!\n");
#endif
				if(position != NULL)
				{
					*position = i - 1;
				}
				return 1;
			}
			if(url[k] == data[j])
			{
				j++;
				k++;
			}
			else
				break;
		}
	}
	if(position != NULL)
	{
		*position = -1;
	}
	return 0;
}






void Compute_Prefix(char *pattern, int plen, int *Pi)
{
	int k = -1;
	int q;

#ifdef DEBUG_PREFIX
	int i;
#endif
	Pi[0] = 0;
	
	for(q = 1; q < plen; q++)
	{
		while(k > -1 && pattern[k + 1] != pattern[q])
		{
			k = Pi[k] - 1;
		}
		if(pattern[k + 1] == pattern[q])
		{
			k++;
		}
		Pi[q] = k + 1;
	}
	
#ifdef DEBUG_PREFIX	
	for(i = 0; i < plen; i++)
	{
		printf("%2d", Pi[i]);
	}
	printf("\n");
#endif
}



// ===============================================
// W١GKMPmatch
// \Gpattern matchAQKnuth-Morris-Pratt algorithm
// ǤJѼơG
// 	char *text - ؼЦr
//	u_int16_t text_len - ؼЦrꪺ
// 	char *pattern - 蠟˦
// 	int *shift - textsbpatternAhpatternbtext첾
//		     bѤnpattern[0] == text[shift]
// Ǧ^ȡG
// 	0 - SABshift-1
//	1 - AshiftNq
// ===============================================
int KMPmatch(char *text, u_int16_t text_len, char *pattern, int *shift)
{
	int plen = strlen(pattern);
	int Pi[plen];
	int q = -1;
	int i;
	int find = 0;

	Compute_Prefix(pattern, plen, Pi);
	
	for(i = 0; i < text_len; i++)
	{
		while(q > -1 && pattern[q + 1] != text[i])
		{
			q = Pi[q] - 1;
		}
		if(pattern[q + 1] == text[i])
		{
			q++;
		}
		if(q == plen - 1)
		{
#ifdef DEBUT_KMP
			printf("Pattern occurs with shift %d\n", i + 1 - plen);
#endif
			if(shift != NULL && find == 0)
			{
				*shift = i + 1 - plen;
				find = 1;
			}
#ifdef SEE_AND_BACK
			return 1;
#endif
			q = Pi[q] - 1;
		}
	}
	
	if(find == 0 && shift != NULL)
	{
		*shift = -1;
	}
	
	if(find)
	{
		return 1;
	}
	else
	{
		return 0;
	}
}






