#include "MainAPP.h"
#include <string.h>
#include "amit.h"

#define NUM_OF_ESP      16
#define FOR_DEBUG

extern IKE_MASQTAB ike_tab[NUM_OF_ESP];
ipq_packet_msg_t *qpkt;
/* This is from gen_ip.c */
static u_int16_t csum_partial(void *buffer,
                              unsigned int len, u_int16_t prevsum)
{
u_int32_t sum = 0;
u_int16_t *ptr = buffer;

while (len > 1)  {
sum += *ptr++;
len -= 2;
}
if (len) {
union {
u_int8_t byte;
u_int16_t wyde;
} odd;

odd.wyde = 0;
odd.byte = *((u_int8_t *)ptr);
sum += odd.wyde;
}
sum = (sum >> 16) + (sum & 0xFFFF);
sum += prevsum;
return (sum + (sum >> 16));
}
static void die(struct ipq_handle *qh)
{
	ipq_perror("passer");
	ipq_destroy_handle(qh);
	exit(1);
}
/***********************IKE Ƶ{ start***************************/
int check_tab(unsigned int *ike_icookie0,unsigned int *ike_icookie1)
{
	int tmp;
	for (tmp=0;tmp< NUM_OF_ESP ;tmp++)
	{
		if((ike_tab[tmp].icookie[0] == *ike_icookie0)&&(ike_tab[tmp].icookie[1] == *ike_icookie1))
		{
#ifdef FOR_DEBUG
			printf("table %d has record this icookie\n",tmp);
#endif
			return tmp;
		}
	}
	for (tmp=0;tmp< NUM_OF_ESP ;tmp++)/*Ūtable*/
	{
		if(ike_tab[tmp].icookie[0] == 0)
		{
#ifdef FOR_DEBUG
			printf("tab[%d]== 0\n",tmp);
#endif
			return tmp;
		}
	}
	return -1;
}	
void build_ike_tab(unsigned int *ike_icookie0,unsigned int *ike_cookie1,struct iphdr *iph,unsigned int nu)
{

		ike_tab[nu].icookie[0]=*ike_icookie0;
		ike_tab[nu].icookie[1]=*ike_cookie1;
		ike_tab[nu].source=iph->saddr;
		ike_tab[nu].destination=iph->daddr;
#ifdef FOR_DEBUG
		printf("record ike_icookie\n");
		printf("come from: %d\n",ike_tab[nu].source&0x000000ff);
#endif
		return;
}
int track_ike(unsigned int *ike_icookie0,unsigned int *ike_icookie1,struct iphdr *iph)
{
	int tmp;
	u_int16_t data_offset;	
#ifdef FOR_DEBUG
	printf("track_ike\n");
#endif
	struct udphdr *udph;
	data_offset = (iph->ihl << 2);
	udph = (struct udphdr *)((char *)iph + data_offset);

	for (tmp=0;tmp< NUM_OF_ESP ;tmp++)
	{
		if((*ike_icookie0==ike_tab[tmp].icookie[0])&&(*ike_icookie1==ike_tab[tmp].icookie[1]))
		{
			if(ike_tab[tmp].source!=iph->daddr)
			{
				/*pipchecksum*/
#ifdef FOR_DEBUG
				printf("do checksum\n");
				printf("destination is %x\n",iph->daddr);
#endif

				iph->daddr=ike_tab[tmp].source;
				iph->check=0;
				iph->check= ~csum_partial((unsigned char *)iph,sizeof(struct iphdr),0);
#ifdef FOR_DEBUG
				printf("change to %x\n",iph->daddr);
#endif
				/*pudpchecksum(b]0,udpˬdchecksum)*/
#ifdef FOR_DEBUG
				printf("%x\n",udph->check);
#endif
				udph->check=0;
#ifdef FOR_DEBUG
				printf("%x\n",udph->check);
#endif
				return 1;
			}
			else
			{
#ifdef FOR_DEBUG
				printf("match and before pass!!\n");
#endif
				return 0;
			}
		}		
	}
#ifdef FOR_DEBUG
	printf("no match\n");
#endif
	return 0;
	
}
/*********************IKE Ƶ{ end********************/

/*********************ESP Ƶ{ start******************/

int esp_tab_check(u_int32_t *esp_spi,struct iphdr *iph, ipq_packet_msg_t *qpkt,unsigned int ra)
{
	unsigned int tmp;
	char command[128];
	int i;
	switch (ra)
	{
		case 1:
			for (tmp=0;tmp< NUM_OF_ESP;tmp++)
			{
				if(ike_tab[tmp].newspi==-1)
				{
					if((ike_tab[tmp].source == iph->saddr)&&(ike_tab[tmp].destination == iph->daddr))
					{
						if(ike_tab[tmp].spi_local == *esp_spi)
						{
							ike_tab[tmp].seq_esp = *(esp_spi+1);
							return 0;
						}
						else
						{
							ike_tab[tmp].spi_local = *esp_spi;
							ike_tab[tmp].seq_esp = *(esp_spi+1);
							ike_tab[tmp].spi_remote = 0x0000;
							ike_tab[tmp].newspi = 1;
							system(ike_tab[tmp].rule_del);
						}
					}
				}
				if(ike_tab[tmp].newspi==1)
				{
					if(ike_tab[tmp].spi_local == *esp_spi)
						return 0;
				}	
			}
#ifdef FOR_DEBUG			
			printf("return builded_reply=-1\n");
#endif
			return -1;
		case 2:
			for (tmp=0;tmp< NUM_OF_ESP;tmp++)
			{
				if(ike_tab[tmp].newspi==0)
				{
					return tmp;
				}
				
			}
			return -1;
		case 3:
			for (tmp=0;tmp<NUM_OF_ESP;tmp++)
			{
				if((ike_tab[tmp].newspi==-1)&&(ike_tab[tmp].spi_remote == *esp_spi))
				{
					return tmp;
				}
			}
			return -1;
		default:
			for (tmp=0;tmp< NUM_OF_ESP;tmp++)
			{
				if(ike_tab[tmp].newspi==1)
				{
#ifdef FOR_DEBUG
					printf("for esp_tab match the packet\n");
#endif	
					if ((iph->saddr == ike_tab[tmp].destination)&&(iph->daddr == ike_tab[tmp].source))
					{
						
#ifdef FOR_DEBUG
						printf("record remote spi!!\n");
#endif	
						ike_tab[tmp].spi_remote=*esp_spi;
#ifdef FOR_DEBUG
						printf("remote spi= %x\n",ike_tab[tmp].spi_remote);
#endif
						sprintf(command,"iptables -t nat -I espnat -i %s -p esp -m esp --espspi %d -j DNAT --to %d.%d.%d.%d",
				qpkt->indev_name,
				ike_tab[tmp].spi_remote,
				ike_tab[tmp].source>>24,
				(ike_tab[tmp].source&0x00FF0000)>>16,
				(ike_tab[tmp].source&0x0000FF00)>>8,
				(ike_tab[tmp].source&0x000000FF));
						system(command);
						sprintf(command,"iptables -t nat -D espnat -i %s -p esp -m esp --espspi %d -j DNAT --to %d.%d.%d.%d",
				qpkt->indev_name,
				ike_tab[tmp].spi_remote,
				ike_tab[tmp].source>>24,
				(ike_tab[tmp].source&0x00FF0000)>>16,
				(ike_tab[tmp].source&0x0000FF00)>>8,
				(ike_tab[tmp].source&0x000000FF));
						for(i=0;i<128;i++)
						{
							ike_tab[tmp].rule_del[i]=command[i]; 
						}
							
						ike_tab[tmp].newspi=-1;
						
						return tmp;
					}					
				}
			}
			return -1;
	}
}
void build_esp_tab(u_int32_t *esp_spi,struct iphdr *iph,struct ipq_packet_msg_t *qpkt,unsigned int nu)
{
	ike_tab[nu].spi_local=*esp_spi;
	ike_tab[nu].seq_esp=*(esp_spi+1);
	ike_tab[nu].source=iph->saddr;
	ike_tab[nu].destination=iph->daddr;
	ike_tab[nu].newspi=1;
#ifdef FOR_DEBUG
	printf("1st esp packet record in tab[%d]\n",nu);
	printf("spi=%0x seq=%0x\n",ike_tab[nu].spi_local,ike_tab[nu].seq_esp);
#endif
	return;	 
}
/*********************ESP Ƶ{ end**************************/	


