#include "Reset.h"



void reset_connection(struct iphdr *target)
{
	struct tcphdr *tcp_target;
	struct sockaddr_in sin;
	int sock;
	char buffer[40];
	struct iphdr *ipheader = (struct iphdr *)buffer;
	struct tcphdr *tcpheader = (struct tcphdr *)(buffer + sizeof(struct iphdr));
	struct pseudohdr pseudoheader;
	int hincl = 1;   /* 1 = on, 0 = off */
	//int i;
	
	tcp_target = (struct tcphdr *)((char *)target + 20);
	
	bzero(&sin, sizeof(struct sockaddr_in));
	sin.sin_family=AF_INET;
	sin.sin_addr.s_addr = target->saddr;
	sin.sin_port = tcp_target->source;

	if((sock = socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) == -1)		// IPPROTO_RAW = 255, IPPROTO_TCP = 6
	{
		printf("couldn't allocate raw socket\n");
		return;
	}
	
	bzero(&buffer, 40);
	//printf("buffer size = %d\n", sizeof(struct iphdr) + sizeof(struct tcphdr));

	ipheader->version = 4;
	ipheader->ihl = 5;
	ipheader->tos = 0;
	ipheader->tot_len = 40;
	ipheader->id = 0;
	ipheader->frag_off = 0;
	ipheader->ttl = 255;
	ipheader->protocol = 6;		// IPPROTO_TCP = 6
	ipheader->saddr = target->daddr;
	ipheader->daddr = target->saddr;
  
	tcpheader->source = tcp_target->dest;
	tcpheader->dest = tcp_target->source;
	//printf(":%d -> :%d\n", ntohs(tcp_target->dest), ntohs(tcp_target->source));
	tcpheader->seq = tcp_target->ack_seq;
	tcpheader->ack_seq = 0;
	tcpheader->doff = 5;
	tcpheader->rst = 1;
	tcpheader->window = 0;
	tcpheader->check = 0;
	tcpheader->urg_ptr = 0;
  

	bzero(&pseudoheader, 12 + sizeof(struct tcphdr));
	pseudoheader.saddr.s_addr = target->daddr;
	pseudoheader.daddr.s_addr = target->saddr;
	pseudoheader.protocol = 6;
	pseudoheader.length = htons(sizeof(struct tcphdr));
	bcopy((char *)tcpheader, (char *)&pseudoheader.tcpheader, sizeof(struct tcphdr));
	tcpheader->check = checksum((u_short *)&pseudoheader, 12 + sizeof(struct tcphdr));

	if(setsockopt(sock, IPPROTO_IP, IP_HDRINCL, &hincl, sizeof(hincl)))	// IP_HDRINCL = 3
	{
		fprintf(stderr, "Unable to set IP_HDRINCL to 1: %s", strerror(errno));
		return;
	}
	/*
	printf("Packet ready. Dump: \n");
    	for(i = 0; i < 40; i++)
    	{
       		printf("%02X%c", *(buffer + i), ((i + 1) % 16) ? ' ' : '\n');
       	}
    	printf("\n");
    	*/
	if(sendto(sock, buffer, sizeof(struct iphdr) + sizeof(struct tcphdr), 0, (struct sockaddr *)&sin, sizeof(struct sockaddr_in)) == -1)
	//if(sendto(sock, buffer, sizeof(struct iphdr) + sizeof(struct tcphdr), MSG_DONTWAIT, (struct sockaddr *)&sin, sizeof(struct sockaddr_in)) == -1)
	{
		fprintf(stderr, "couldn't send packet: %s\n", strerror(errno));
		return;
	}
}


u_short checksum(u_short * data,u_short length)
{
  register long value=0;
  u_short i;
  
  for(i=0;i<(length>>1);i++)
    value+=data[i];
    
  if((length&1)==1)
    value+=(data[i]<<8);
   
  value=(value & 0xffff)+(value>>16);
  
  value += (value >> 16);
      
  return(~value);
}
