#include "Script.h"

#define FILE_PATH "/etc/script.conf"
//#define FILE_PATH "/var/config/ipq/script.conf"

// ----------------------------------
// W١GDLscriptfile
// \GP_O_download script file
// ǤJѼơG
// 	data - packet data
// 	data_len - packet data
// Ǧ^ȡG
//	0 - Odownload script file
// 	1 - Odownload script file
// ----------------------------------
int DLscriptfile(char *data, int data_len)
{
	if(KMPmatch(data, data_len, "Content-Type: application/x-javascript", NULL) || KMPmatch(data, data_len, "Content-Type: www/unknown", NULL))
	{
		return 1;
	}
	else
	{
		return 0;
	}
}


int Script_StartINhtml(char *data, int data_len, int *start)
{
	if(KMPmatch(data, data_len, "<SCRIPT ", start) || KMPmatch(data, data_len, "<script ", start))
	{
		return 1;
	}
	else
	{
		return 0;
	}
}

int Script_EndINhtml(char *data, int data_len, int *end)
{
	if(KMPmatch(data, data_len, "</SCRIPT>", end) || KMPmatch(data, data_len, "</script>", end))
	{
		return 1;
	}
	else
	{
		return 0;
	}
}

/* -------------------------------------------- */
/*	T{entryO_bscript table		*/
/* Qsource ipBsource portBack_seqP_O_	*/
/* P@su					*/
/* Ǧ^: Ǧ^줧entry(script_entry *)	*/
/*	   SǦ^NULL			*/
/* -------------------------------------------- */
script_entry *Check_Script_table(script_entry *head, struct iphdr *iph)
{
	script_entry *temp;
	struct tcphdr *tcph;
	__u32 sip;
	__u16 sport;
	__u32 ack_seq;

	//printf("Checking script table\n");
	temp = head;

	sip = iph->saddr;
	tcph = (struct tcphdr*)((__u32 *)iph + iph->ihl);
	sport = tcph->source;
	ack_seq = tcph->ack_seq;
	//printf("sip = %d, sport = %d, ack = %d\n", sip, ntohs(sport), ntohl(ack_seq));

	while(temp != NULL)
	{
		//printf("entry: sip = %d, sport = %d, ack = %d\n", temp->sip, ntohs(temp->sport), ntohl(temp->ack_seq));
		if(temp->sip == sip &&
		   temp->sport == sport &&
		   temp->ack_seq == ack_seq)
		{
			//printf("Script table entry match!!\n");
			return temp;
		}
		temp = temp->next;
	}
	//printf("Not match in this table\n");
	return NULL;
}

void Add_DLfile_Script_table1(script_entry **head, script_entry **tail, struct iphdr *iph)
{
	script_entry *new_entry;
	struct tcphdr *tcph;
	int data_len;
	
	new_entry = (script_entry *)malloc(sizeof(script_entry));
	
	new_entry->sip = iph->daddr;
	tcph = (struct tcphdr*)((__u32 *)iph + iph->ihl);
	//@@@ub km 2002/10/25 count the tcp header len
	//data_len = ntohs(iph->tot_len) - (iph->ihl << 2) - 20;
	data_len = ntohs(iph->tot_len) - (iph->ihl << 2) - (tcph->doff <<2);
	//@@@ue km 2002/10/25 count the tcp header len
	new_entry->sport = tcph->dest;
	new_entry->ack_seq = htonl(ntohl(tcph->seq) + data_len);
	//printf("seq = %d, data_len = %d, so ack_seq = %d\n", ntohl(tcph->seq), data_len, ntohl(new_entry->ack_seq));
	
	new_entry->more_data = 0;
	new_entry->next = NULL;
	
	if(*head == NULL)
	{
		*head = new_entry;
		*tail = new_entry;
	}
	else
	{
		(**tail).next = new_entry;
		*tail = new_entry;
	}
}

void Add_DLfile_Script_table2(script_entry *modify, char *data, int data_len, int more_data)
{
	strncpy(modify->data, data, data_len);
	modify->data[data_len] = 0;	// 
	modify->more_data = more_data;
}

/* -------------------------------------------- */
/*	    [Jssuscript talbe		*/
/* -------------------------------------------- */
void Add_Script_table(script_entry **head, script_entry **tail, struct iphdr *iph, char *data, int data_len, int more_data)
{
	script_entry *new_entry;
	struct tcphdr *tcph;
	
	//printf("Adding script entry.\n");

	new_entry = (script_entry *)malloc(sizeof(script_entry));
	
	new_entry->sip = iph->saddr;
	tcph = (struct tcphdr*)((__u32 *)iph + iph->ihl);
	new_entry->sport = tcph->source;
	new_entry->ack_seq = tcph->ack_seq;
	
	strncpy(new_entry->data, data, data_len);
	new_entry->data[data_len] = 0;	// 
	new_entry->more_data = more_data;
	//new_entry->p_count = 1;
	new_entry->next = NULL;
	
	if(*head == NULL)
	{
		*head = new_entry;
		*tail = new_entry;
	}
	else
	{
		(**tail).next = new_entry;
		*tail = new_entry;
	}
	
	//List_Script_table(*head);
}

int Append_Script_table(script_entry *obj, char *data, int data_len)
{
	int old_data_len;
	
	old_data_len = strlen(obj->data);
	strncpy(obj->data, obj->data + old_data_len - RETAIN_DATA, RETAIN_DATA);
	strncpy(obj->data + RETAIN_DATA, data, data_len);
	obj->data[data_len + RETAIN_DATA] = 0;	// 
	
	obj->more_data -= data_len;
	//printf("more data = %d\n", obj->more_data);
	//obj->p_count++;
	
	if(obj->more_data <= 0)
	{
		return 1;	// oscriptwg
	}
	else
	{
		return 0;	// |
	}
}


void List_Script_table(script_entry *head)
{
	script_entry *temp;
	int i = 1;
	
	printf("--------------SCRIPT TABLE--------------\n");
	temp = head;
	while(temp != NULL)
	{
		printf("%d-- %d:%d ack = %d, moredata = %d\n", i, temp->sip, ntohs(temp->sport), ntohl(temp->ack_seq), temp->more_data);
		temp = temp->next;
		i++;
	}
	printf("----------------------------------------\n");
}

void Kill_Script_table(script_entry **head, script_entry **tail, script_entry *node)
{
	script_entry *temp;
	
	if(*head == node)
	{
		if(*head == *tail)
		{
			*head = *tail = NULL;
		}
		else
		{
			temp = *head;
			*head = (**head).next;
			free(temp);
		}
	}
	else
	{
		temp = *head;
		while(temp->next != node)
		{
			temp = temp->next;
		}
		temp->next = node->next;
		free(node);
	}
}

/* -------------------------------------------- */
/*		data			*/
/* -------------------------------------------- */
int MatchScriptMethod1(char *data, int data_len)
{
	FILE *script_fp;	// Vscript file
	char script_method[MAX_SCRIPT_METHOD];
	
	script_fp = fopen(FILE_PATH, "r");	// wɮצW١Gscript
	fseek(script_fp, 0L, SEEK_SET);
	script_method[0] = 0;
	while((fgets(script_method, MAX_SCRIPT_METHOD, script_fp)) != NULL)
	{
		script_method[strlen(script_method) - 1] = 0;	// '\n'
		//fprintf(stdout, "%s, len = %d\n", script_method, strlen(script_method));
		if(KMPmatch(data, data_len, script_method, NULL))
		{
			// 
			printf("Find %s method in this script.\n", script_method);
			fclose(script_fp);
			return 1;
		}
		script_method[0] = 0;
	}
	// S
	fclose(script_fp);
	return 0;

}


/* -------------------------------------------- */
/*		script entry		*/
/* -------------------------------------------- */
int MatchScriptMethod2(script_entry *entry)
{
	FILE *script_fp;	// Vscript file
	//int data_len;
	char script_method[MAX_SCRIPT_METHOD];
	
	//data_len = strlen(entry->data);
	
	script_fp = fopen(FILE_PATH, "r");	// wɮצW١Gscript
	fseek(script_fp, 0L, SEEK_SET);
	script_method[0] = 0;
	while((fgets(script_method, MAX_SCRIPT_METHOD, script_fp)) != NULL)
	{
		script_method[strlen(script_method) - 1] = 0;	// '\n'
		if(KMPmatch(entry->data, strlen(entry->data), script_method, NULL))
		{
			// 
			printf("Find %s method in this script.\n", script_method);
			fclose(script_fp);
			return 1;
		}
		script_method[0] = 0;
	}
	// S
	fclose(script_fp);
	return 0;
}

void Rebuild_sfile1(char *data, int data_len)
{
	FILE *fp;
	int i;
	
	fp = fopen("1LOG", "a+");
	
	for(i = 0; i < data_len; i++)
	{
		fputc(*(data + i), fp);
	}
	
	for(i = 0; i < 50; i++)
	{
		fputc('*', fp);
	}
	fclose(fp);
}

void Rebuild_sfile2(script_entry *obj)
{
	FILE *fp;
	int i;
	
	fp = fopen("2LOG", "a+");
	
	for(i = 0; obj->data[i] != 0; i++)
	{
		fputc(obj->data[i], fp);
	}
	
	for(i = 0; i < 50; i++)
	{
		fputc('*', fp);
	}

	fclose(fp);
}






