#define FOR_DEBUG 4
//#undef FOR_DEBUG




/* *************************************** */
/* Name : rc2.c                            */
/* Programmer : changkm                    */
/* Date : 2002/8/23                        */
/* Version : v1.0 (use Amit.h)             */
/* Function : set environment after reboot */
/* *************************************** */


/* ===================== */
/* Header file inclusion */
/* ===================== */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <string.h>

//
#include<stdio.h>
#include<stdlib.h>
#include<netinet/in.h>

#include "usercfg5.h"
#include "../../../uC-src/amit_include/amit.h"



/* ================== */
/* Literal definition */
/* ================== */

//---for different flashing
#define ARM_MIPS 1	//0: for Conexant ARM9; 1: for Brecis MIPS 2000


//---check wan
#ifndef SOCK_DGRAM
	#define SOCK_DGRAM 1
#endif
#ifndef SIOCGIFADDR
	#define SIOCGIFADDR 0x01
#endif
//
#define OFFSET 4259856

#define SLEEP_TIME 300
//---new actrl
#define CONF_PATH	"/proc/access_ctrl_setting"
#define GROUP_NUM	4
#define BOUND		16
//---End new actrl

//---IPSec Manual
#define DEBUG_IPSEC_MANUAL

//---SAVE IP info
#define IP_INFO_FILE "/var/config/host.arg"
//---static DNS file
#define DNS_INFO_FILE "/var/config/resolv.conf"

//---ids
#define PINGF_NUM	"103"
#define SMURF_NUM	"104"
#define PSD_NUM		"201"
#define FRAGGLE_NUM	"202"
#define SNORK_NUM	"203"
#define LAND_NUM	"204"
#define DNS_SCAN_NUM	"206"
//---End ids

//---virus parser
#define MAX 80
#define VIRUS_PATH "/var/config/ipq/virus/"
//---End virus parser

#define MBOMB_PATH "/var/config/ipq/mbomb1.conf"
#define MBOMB2_PATH "/var/config/ipq/mbomb2.conf"

//----Alert Mail
#define MAIL_LIST_FILE "/var/config/mail_list.conf"
#define ALERT_TABLE_FILE "/var/config/alert_table"



/* =================== */
/* Function prototypes */
/* =================== */

int ipinfo(char *, ip_info_struct *);//find ip information
int findGW(ip_info_struct *);//find Getway
int setenv(const char *name, const char *value, int overwrite);
int fseek(FILE *stream, long offset, int whence);
long ftell(FILE *stream);
void rewind(FILE *stream);
int set_wanget_result(int act);
void restart_dhcpcd(ACONFIG *ACONF);


/* ===================== */
/* Global variables      */
/* ===================== */

unsigned char during_booting = 0;

#if ARM_MIPS
  //sync with ACONFIG in the Flash Rom
  ACONFIG FlashACONF;
#endif



/* ===================== */
/* All procedures        */
/* ===================== */

//succ: insertion sort for dhcpd with pmac
void sort(int *r, int num)
{
  int i, j;
  int tempr;
  
  //for(i=0;i<num;i++)
  //  printf("%d -> ",r[i]);
  
  for(i=0 ; i<num; i++)
  {
  	for(j=i+1 ; j<num ; j++)
  	{
  		if(r[i] > r[j])
  		{
  			tempr = r[i];
  			r[i] = r[j];
  			r[j] = tempr;	
  		}
  	}	
  }
  
  //for(i=0;i<num;i++)
  //  printf("%d *> ",r[i]);
  
}

/* *****check wan ip**** */
/*                       */
/* ********************* */

unsigned long query_netdevice(char *device_name, int query_flag)
{
	int fd;
	struct ifreq ifr;
	unsigned long ul;

	fd = socket(AF_INET, SOCK_DGRAM, 0);
	if(fd<0)
	{
		//Nprintf("socket open error\n\r");
		return 0;
	}
	else
	{
		strcpy(ifr.ifr_name, device_name);
		ifr.ifr_addr.sa_family = AF_INET;
		if(ioctl(fd, query_flag, &ifr) == 0)
		{
			memcpy(&ul, ifr.ifr_addr.sa_data+2, sizeof(ul));
			//Nprintf("return value=%lX\n", ul);
		}
		else
			ul = 0;
	}
	close(fd);

	return ul;
}

unsigned long getmyWANip()
{
	return query_netdevice("eth1", SIOCGIFADDR);
}

/* ****get DNS ******** */
/* file:resolv.conf     */
/* ******************** */
int getDNS( char *dns1, char *dns2 )
{
	FILE *fd;
	char buf[80],temp[17];
	char *pt;
	int flag;
	
	flag=0;
	fd=fopen(DNS_INFO_FILE,"r");
	while(fgets(buf,80,fd)!=NULL)
	{
		if((pt=strstr(buf,"nameserver"))!=NULL && (flag==0))
		{
			pt=pt+11;
			strcpy(temp,pt);
			temp[strlen(temp)-1]=0;
			strcpy(dns1,temp);
			flag=1;
			continue;
		}
		if((pt=strstr(buf,"nameserver"))!=NULL && (flag==1))
		{
			pt=pt+11;
			strcpy(temp,pt);
			temp[strlen(temp)-1]=0;
			strcpy(dns2,temp);
			flag=1;
			continue;
		}
	}

	return 0;
}

/* ****save IP info**** */
/*  file:host.arg       */
/*  WAN IP;             */
/*  WAN Netmask;        */
/*  WAN Gateway         */
/* ******************** */
int saveIPinfo(ACONFIG *a)
{

	FILE *fd;
	int i;
	ip_info_struct ife;
	ACONFIG * ACONF;
	
	#ifdef FOR_DEBUG
    		printf("-------------------------------------------------------------------------------\n\r");
    		printf("Enter saveIPinfo procedure\n\r");
    	#endif
	
	#if ARM_MIPS
		ACONF = &FlashACONF;
  		read_Aconfig(ACONF);
	#else
		ACONF = (ACONFIG *)OFFSET;
	#endif
	
	close(2);

	if(a->local.wtype!=2) ipinfo("eth1", &ife); else ipinfo("ppp0", &ife);
	
	findGW(&ife);
	
	for(i = 0; i < 5; i++)//check if file can open
	{
		fd=fopen(IP_INFO_FILE,"w");
		if(fd == NULL)
		{
			sleep(1);
			continue;
		}
		else
			break;
	}
	if(fd == NULL)
	{
		printf("saveIPinfo: cannot open file %s.\n", IP_INFO_FILE);
		return 1;
	}
	else
	{
		printf("Open host.arg file ok\n\r");// IMPORTANT!!!   delete this will cause error!!!
	}
		
	fprintf(fd,"%d.%d.%d.%d\n",ife.ip[0],ife.ip[1],ife.ip[2],ife.ip[3]);//save ip
	fprintf(fd,"%d.%d.%d.%d\n",ife.mask[0],ife.mask[1],ife.mask[2],ife.mask[3]);//save wan mask
	fprintf(fd,"%d.%d.%d.%d\n",ife.gw[0],ife.gw[1],ife.gw[2],ife.gw[3]);//save wan gateway
	fclose(fd);
	
	#ifdef FOR_DEBUG
		printf("Save ip ok\n\r");
	#endif

	return 1;
}




void setpmac(int act)
{
  char temp[150];
  int i;

  ACONFIG * ACONF;
  
  #if ARM_MIPS
	ACONF = &FlashACONF;
  	read_Aconfig(ACONF);
  #else
	ACONF = (ACONFIG *)OFFSET;
  #endif

  if(act == 1)
  {
    if((ACONF->pmac.flag & PMF_MAC_CONTROL) == PMF_MAC_CONTROL) //pmac enable
    {
      /* ******************** */
      /* setup iptables rules */
      /* ******************** */
      if((ACONF->pmac.flag & PMF_D_ENABLE) == PMF_D_ENABLE) //connection control enable
      {
        /* create a new chain, PMAC in nat table from eth0 */
        system("iptables -t nat -N PMAC");
        system("iptables -t nat -I PREROUTING -i eth0 -j PMAC");

        if((ACONF->pmac.flag & PMF_D_DENY_OTHERS) != PMF_D_DENY_OTHERS) //allow
        {
          for(i = 0 ; i < PMAC_NUM ; i++)
          {
            if(ACONF->pmac.list[i].prop == 1)
            {
              sprintf(temp,"iptables -t nat -I PMAC -s %d.%d.%d.%d -m mac --mac-source ! %x:%x:%x:%x:%x:%x -j DROP",
                            ACONF->local.ip[0],ACONF->local.ip[1],
                            ACONF->local.ip[2],ACONF->pmac.list[i].ip,
                            ACONF->pmac.list[i].mac[0],ACONF->pmac.list[i].mac[1],
                            ACONF->pmac.list[i].mac[2],ACONF->pmac.list[i].mac[3],
                            ACONF->pmac.list[i].mac[4],ACONF->pmac.list[i].mac[5]
              );
	      system(temp);
              sprintf(temp,"iptables -t nat -I PMAC -s ! %d.%d.%d.%d -m mac --mac-source %x:%x:%x:%x:%x:%x -j DROP",
                            ACONF->local.ip[0],ACONF->local.ip[1],
                            ACONF->local.ip[2],ACONF->pmac.list[i].ip,
                            ACONF->pmac.list[i].mac[0],ACONF->pmac.list[i].mac[1],
                            ACONF->pmac.list[i].mac[2],ACONF->pmac.list[i].mac[3],
                            ACONF->pmac.list[i].mac[4],ACONF->pmac.list[i].mac[5]
              );
	      system(temp);
            }
          }
          system("iptables -t nat -A PMAC -j RETURN");
        }
        else if((ACONF->pmac.flag & PMF_D_DENY_OTHERS) == PMF_D_DENY_OTHERS) //deny
        {
	  for(i = 0 ; i < PMAC_NUM ; i++)
	  {
	    if(ACONF->pmac.list[i].prop == 1)
	    {
              sprintf(temp,"iptables -t nat -A PMAC -s %d.%d.%d.%d -m mac --mac-source %x:%x:%x:%x:%x:%x -j RETURN",
                            ACONF->local.ip[0],ACONF->local.ip[1],
                            ACONF->local.ip[2],ACONF->pmac.list[i].ip,
                            ACONF->pmac.list[i].mac[0],ACONF->pmac.list[i].mac[1],
                            ACONF->pmac.list[i].mac[2],ACONF->pmac.list[i].mac[3],
                            ACONF->pmac.list[i].mac[4],ACONF->pmac.list[i].mac[5]
              );
	      system(temp);
              sprintf(temp,"iptables -t nat -A PMAC -s %d.%d.%d.%d -j DROP",
			   ACONF->local.ip[0],ACONF->local.ip[1],
			   ACONF->local.ip[2],ACONF->pmac.list[i].ip
	      );
	      system(temp);
            }
          }
	  for(i = 0 ; i < PMAC_NUM ; i++)
          {
            if(ACONF->pmac.list[i].prop == 0)
            {
              sprintf(temp,"iptables -t nat -A PMAC -m mac --mac-source %x:%x:%x:%x:%x:%x -j RETURN",
                           ACONF->pmac.list[i].mac[0],ACONF->pmac.list[i].mac[1],
	                   ACONF->pmac.list[i].mac[2],ACONF->pmac.list[i].mac[3],
			   ACONF->pmac.list[i].mac[4],ACONF->pmac.list[i].mac[5]
	      );
	      system(temp);
	    }
	  }
          system("iptables -t nat -A PMAC -j DROP");
        }
      }    

      /* return to PREROUTING */

    }
    else
      goto stop_pmac;
  }
  else //act == 0
  {
stop_pmac:
    if((ACONF->pmac.flag & PMF_MAC_CONTROL) == PMF_MAC_CONTROL)
    {
    	system("iptables -t nat -F PMAC");
    	system("iptables -t nat -D PREROUTING -i eth0 -j PMAC");
    	system("iptables -t nat -X PMAC");
    }
    setdhcpd(0);
    setdhcpd(1);
  }
}

/* ************* */
/* Set LAN       */
/* 0     : ok    */
/* other : error */
/* ************* */
int setlan(int act)
{
  unsigned char temp[60];
  unsigned char AND1, AND2, AND3, AND4;
  ACONFIG * ACONF;
  
  #if ARM_MIPS
	ACONF = &FlashACONF;
  	read_Aconfig(ACONF);
  #else
	ACONF = (ACONFIG *)OFFSET;
  #endif

  close(2);

  if(act == 0) {
  
    #ifdef FOR_DEBUG
    	printf("-------------------------------------------------------------------------------\n\r");
    	printf("Enter setlan 0 procedure\n\r");
    #endif
  
    system("ifconfig eth0 down");
    
  } else {
  	
    #ifdef FOR_DEBUG
    	printf("-------------------------------------------------------------------------------\n\r");
    	printf("Enter setlan 1 procedure\n\r");
    #endif
    
    sprintf(temp,"ifconfig eth0 %d.%d.%d.%d netmask 255.255.255.0 up",
    		ACONF->local.ip[0],ACONF->local.ip[1],
      		ACONF->local.ip[2],ACONF->local.ip[3]);
    system(temp);
    
    set_wanget_result(0);
    
    system("amit_ftpd&");
    
  }
  
  #ifdef FOR_DEBUG
    system("ifconfig");
  #endif
  
  usleep(SLEEP_TIME);
}






/* ************* */
/* Set WAN       */
/* 0     : ok    */
/* other : error */
/* ************* */
int setwan(int act)
{
  unsigned char temp[120];
  unsigned char AND1, AND2, AND3, AND4;
  FILE *fd, *fd2;
  unsigned char pid[10];
  int i;
  FILE *fd_dns;	//succ : for dns
  ACONFIG * ACONF;
  char *cp;
  unsigned char found;
  long file_pos;
  
  #ifdef FOR_DEBUG
  	printf("-------------------------------------------------------------------------------\n\r");
  	printf("Enter setwan %d procedure\n",act);
  #endif

  #if ARM_MIPS
	ACONF = &FlashACONF;
  	read_Aconfig(ACONF);
  #else
	ACONF = (ACONFIG *)OFFSET;
  #endif
  
  close(2);

  //set if_wan down
  if(act == 0) {
  	
    switch(ACONF->local.wtype)
    {
   
      case 0:  //Static IP
      
        //set if_wan down
	system("ifconfig eth1 down");
	
        //set default gw down
        sprintf(temp,"route del default gw %d.%d.%d.%d",ACONF->local.wgw[0],ACONF->local.wgw[1],
                                                        ACONF->local.wgw[2],ACONF->local.wgw[3]);
        system(temp);
        
        usleep(SLEEP_TIME);
        
        break;

      case 1:  //dynamic IP
      
        if((fd = fopen("/var/run/dhcpcd-eth1.pid","r")) != NULL) {
          fgets(pid,10,fd);
          sprintf(temp,"kill %s",pid);
          system(temp);
          fclose(fd);
        }
        
        set_wanget_result(0);
        
        system("led 77 0&");
        #ifdef FOR_DEBUG
        	printf("setwan: Led M2 off\n\r");
        #endif
        
        break;
        
      case 2: //PPPoE
		// 1. Qadsl-stoppppoe
		system("adsl-stop");
		// 2. eth1
		system("ifconfig eth1 down");
		// 3. pppoeconfig
		remove("/var/config/ppp/pppoe.conf");
		// 4. /var/config/resolv.conf
		if(ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[0] != 0 ||
			ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[1] != 0 ||
			ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[2] != 0 ||
			ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[3] != 0 ||
			ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[0] != 0 ||
			ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[1] != 0 ||
			ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[2] != 0 ||
			ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[3] != 0)
		{
			remove(DNS_INFO_FILE);
			fd = fopen(DNS_INFO_FILE, "w");
			fclose (fd);
		}
		// 5. קpap-secrets
		if((fd = fopen("/var/config/pap-secrets", "r")) != NULL)
		{
			if ((fd2 = fopen("/var/config/pap-secrets.tmp", "w")) != NULL)
			{
				for(i = 0; i < 4; i++)
				{
					fgets(temp, 120, fd);
					fputs(temp, fd2);
				}
				fclose(fd);
				fclose(fd2);
			}
			remove("/var/config/pap-secrets");
			rename("/var/config/pap-secrets.tmp", "/var/config/pap-secrets");
		}
		// 6. קchap-secrets
		if((fd = fopen("/var/config/chap-secrets", "r+")) != NULL)
		{
			if((fd2 = fopen("/var/config/chap-secrets.tmp", "w")) != NULL)
			{
				for(i = 0; i < 4; i++)
				{
					fgets(temp, 120, fd);
					fputs(temp, fd2);
		    		}
				fclose(fd);
				fclose(fd2);
			}
			remove("/var/config/chap-secrets");
			rename("/var/config/chap-secrets.tmp", "/var/config/chap-secrets");
		}
		break;
	}
  }
  else if(act == 1)	//start WAN up
  {
    
    switch(ACONF->local.wtype)
    {
    	
      case 0:  //Static IP
      
        //set if_wan up
        sprintf(temp,"ifconfig eth1 %d.%d.%d.%d netmask %d.%d.%d.%d up",
        	ACONF->local.wip[0],ACONF->local.wip[1],
                ACONF->local.wip[2],ACONF->local.wip[3],
                ACONF->local.wnm[0],ACONF->local.wnm[1],
                ACONF->local.wnm[2],ACONF->local.wnm[3]);
        system(temp);
        #ifdef FOR_DEBUG
    		printf("Static WAN: set IP: %s",temp);
  	#endif
  	
  	usleep(SLEEP_TIME);
        
        //set default gw
        sprintf(temp,"route add default gw %d.%d.%d.%d",
        	ACONF->local.wgw[0],ACONF->local.wgw[1],
                ACONF->local.wgw[2],ACONF->local.wgw[3]);
        system(temp);
        #ifdef FOR_DEBUG
    		printf("Static WAN: set default GW: %s\n\r",temp);
  	#endif
        usleep(SLEEP_TIME);
        
        system("led 77 0&");
  	#ifdef FOR_DEBUG
    		printf("Static WAN: led off M2\n\r");
  	#endif
        
        //save WAN's IP in /var/config/host.arg
        i = saveIPinfo(ACONF);
	#ifdef FOR_DEBUG
    		printf("Static WAN: save WAN's IP in /var/config/host.arg: %d(0 for success)\n\r",i);
  	#endif
        
        //succ : save domain, dns, and search in /var/config/resolv.conf
        if(((ACONF->acctpool[0].dns[0].ip[0]+ACONF->acctpool[0].dns[0].ip[1]+ACONF->acctpool[0].dns[0].ip[2]+ACONF->acctpool[0].dns[0].ip[3]) == 0) &&
           ((ACONF->acctpool[0].dns[1].ip[0]+ACONF->acctpool[0].dns[1].ip[1]+ACONF->acctpool[0].dns[1].ip[2]+ACONF->acctpool[0].dns[1].ip[3]) == 0)   )
        {
      		fd_dns = fopen(DNS_INFO_FILE,"w");
        	//dns of static ip is empty
        	fprintf(fd_dns,"domain\n");

     		fprintf(fd_dns,"nameserver %d.%d.%d.%d\n",
          			ACONF->local.ip[0],
          			ACONF->local.ip[1],
          			ACONF->local.ip[2],
          			ACONF->local.ip[3]        );
		fprintf(fd_dns,"search\n");
		fclose(fd_dns);        		
        }
        else
        {
        	fd_dns = fopen(DNS_INFO_FILE,"w");
        	//dns of static ip is empty
        	fprintf(fd_dns,"domain\n");
          	if((ACONF->acctpool[0].dns[0].ip[0]+ACONF->acctpool[0].dns[0].ip[1]+ACONF->acctpool[0].dns[0].ip[2]+ACONF->acctpool[0].dns[0].ip[3]) != 0)
          	{
            		fprintf(fd_dns,"nameserver %d.%d.%d.%d\n",
          			ACONF->acctpool[0].dns[0].ip[0],
          			ACONF->acctpool[0].dns[0].ip[1],
          			ACONF->acctpool[0].dns[0].ip[2],
          			ACONF->acctpool[0].dns[0].ip[3]     );
        	}
        	if((ACONF->acctpool[0].dns[1].ip[0]+ACONF->acctpool[0].dns[1].ip[1]+ACONF->acctpool[0].dns[1].ip[2]+ACONF->acctpool[0].dns[1].ip[3]) != 0)
        	{
          		fprintf(fd_dns,"nameserver %d.%d.%d.%d\n",
          			ACONF->acctpool[0].dns[1].ip[0],
          			ACONF->acctpool[0].dns[1].ip[1],
          			ACONF->acctpool[0].dns[1].ip[2],
          			ACONF->acctpool[0].dns[1].ip[3] );	
		}
		fprintf(fd_dns,"search\n");
		fclose(fd_dns);
	}
	
	#ifdef FOR_DEBUG
    		printf("Static WAN: create /var/config/resolv.conf\n\r");
    	#endif
    	
    	//1st char in monitor file: check_eth1: 1: want, 0:no need
	if ((fd = fopen("/var/config/monitor","r+")) != NULL) {	
		if (fgets(temp,120,fd) == NULL) {
			memset(temp, '0', 120);  
			temp[117] = '\n'; temp[118] = '\r'; temp[119] = 0;
		}
		temp[0] = '0';
		rewind(fd);
		fputs(temp,fd);
		fclose(fd);
	} else {
		#ifdef FOR_DEBUG
			printf("Open R/W file : monitor fail, Create it\n\r");
		#endif
		if ((fd = fopen("/var/config/monitor","w")) != NULL) {
			memset(temp, '0', 120);
			temp[117] = '\n'; temp[118] = '\r'; temp[119] = 0;
			fputs(temp,fd);
			fclose(fd);
		} else {
			#ifdef FOR_DEBUG
				printf("Can not create monitor file\n\r");
			#endif
		}
	}
	
	#ifdef FOR_DEBUG
		system("ifconfig");
	#endif
	
	set_wanget_result(0);
  	
        break;

      case 1:  //dynamic IP
      
        #if ARM_MIPS
        
        	system("ifconfig eth1 inet 0.0.0.0");	//hsujp
		#ifdef FOR_DEBUG
	  		printf("ifconfig eth1 0.0.0.0\n\r");
		#endif
		
		restart_dhcpcd(ACONF);
		
		//set the flag indicating eth1 is required to be checked
		i = -99;
		while (i == -99) {
			i = system("monitor 91 0 1"); //91: set function but don't invoke another monitor
			                              //    if it is 1, set and invoke;
			                              // 0: bit 0, eth1 need to be checked
			                              // 1: set to 1
		}
		usleep(SLEEP_TIME);
		
		//set the flag indicating dhcpcd-eth1.pid is required to be checked
		i = -99;
		while (i == -99) {
			if (during_booting == 1)
			i = system("monitor 91 1 1"); //91: set function but don't invoke another monitor
			                              //    if it is 1, set and invoke;
			                              // 1: bit 1, dhcpcd-eth1.pid need to be checked
			                              // 1: set to 1
			else i = system("monitor 1 1 1");
			//sleep(1);
		}
			
      	#else //for conexant arm9
      	
		system("ifconfig eth1 down;ifconfig eth1 up;dhcpcd eth1 &");
		
      	#endif
      	
        break;

      case 2: //PPPoE
      		//succ : for dns
        	if(((ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[0]+ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[1]+ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[2]+ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[3]) == 0) &&
           	   ((ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[0]+ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[1]+ACONF->acctpool[ACONF->local3.acct[1]].dns[0].ip[2]+ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[3]) == 0)   )
        	{
      			fd_dns = fopen(DNS_INFO_FILE,"w");
        		//dns of static ip is empty
        		fprintf(fd_dns,"domain\n");
	
     			fprintf(fd_dns,"nameserver %d.%d.%d.%d\n",
          				ACONF->local.ip[0],
          				ACONF->local.ip[1],
          				ACONF->local.ip[2],
          				ACONF->local.ip[3]        );
			fprintf(fd_dns,"search\n");
			fclose(fd_dns);        		
        	}
		if(((ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[0]+ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[1]+ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[2]+ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[3]) != 0) ||
           	   ((ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[0]+ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[1]+ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[2]+ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[3]) != 0)   )
        	{
   	    		fd_dns = fopen(DNS_INFO_FILE,"w");
        		//dns of static ip is empty
        		fprintf(fd_dns,"domain\n");
          		if((ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[0]+ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[1]+ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[2]+ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[3]) != 0)
          		{
	            		fprintf(fd_dns,"nameserver %d.%d.%d.%d\n",
        	  			ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[0],
          				ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[1],
          				ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[2],
          				ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[3]     );
        		}
        		if((ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[0]+ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[1]+ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[2]+ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[3]) != 0)
        		{
	          		fprintf(fd_dns,"nameserver %d.%d.%d.%d\n",
          				ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[0],
          				ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[1],
          				ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[2],
          				ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[3] );	
			}
			fprintf(fd_dns,"search\n");
			fclose(fd_dns);
		}
      
		system("ifconfig eth1 inet 0.0.0.0");
		if((fd = fopen("/var/config/ppp/pppoe.conf", "w")) != NULL)
		{
			fprintf(fd, "ETH=eth1\n");
			fprintf(fd, "USER=%s\n", ACONF->acctpool[ACONF->local3.acct[0]].user);
			if((ACONF->acctpool[ACONF->local3.acct[0]].flag & LFLAG_RENEWIP) == LFLAG_RENEWIP)
				fprintf(fd, "DEMAND=no\n");
			else
				fprintf(fd, "DEMAND=%d\n", ACONF->acctpool[ACONF->local3.acct[0]].to);
			i = 0;
			if(ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[0] != 0 ||
				ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[1] != 0 ||
				ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[2] != 0 ||
				ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[3] != 0)
			{
				fprintf(fd, "DNSTYPE=SPECIFY\n");
				fprintf(fd, "USEPEERDNS=no\n");
				fprintf(fd, "DNS1=%d.%d.%d.%d\n",
					ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[0],
					ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[1],
					ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[2],
					ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[3]);
				i++;
			}
			if(ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[0] != 0 ||
				ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[1] != 0 ||
				ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[2] != 0 ||
				ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[3] != 0)
			{
				if(i == 0)
				{
					fprintf(fd, "DNSTYPE=SPECIFY\n");
					fprintf(fd, "USEPEERDNS=no\n");
					fprintf(fd, "DNS1=%d.%d.%d.%d\n",
						ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[0],
						ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[1],
						ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[2],
						ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[3]);
				}
				else
				{
					fprintf(fd, "DNS2=%d.%d.%d.%d\n",
						ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[0],
						ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[1],
						ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[2],
						ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[3]);
				}
				i++;
			}
			if(!i)
			{
				fprintf(fd, "USEPEERDNS=yes\n");
			}
			fprintf(fd, "CONNECT_TIMEOUT=60\n");
			fprintf(fd, "CONNECT_POLL=6\n");
			fprintf(fd, "PING=\".\"\n");
			fprintf(fd, "PIDFILE=/var/run/pppoe.pid\n");
			fprintf(fd, "SYNCHRONOUS=no\n");
			fprintf(fd, "CLAMPMSS=1412\n");
			fprintf(fd, "LCP_INTERVAL=20\n");
			fprintf(fd, "LCP_FAILURE=3\n");
			fprintf(fd, "PPPOE_TIMEOUT=300\n");
			if((ACONF->acctpool[ACONF->local3.acct[0]].ip[0] + 
				ACONF->acctpool[ACONF->local3.acct[0]].ip[1] +
				ACONF->acctpool[ACONF->local3.acct[0]].ip[2] +
				ACONF->acctpool[ACONF->local3.acct[0]].ip[3]) == 0)
				fprintf(fd, "ASSIGNEDIP=no\n");
			else
				fprintf(fd, "ASSIGNEDIP=%d.%d.%d.%d\n",
					ACONF->acctpool[ACONF->local3.acct[0]].ip[0],
					ACONF->acctpool[ACONF->local3.acct[0]].ip[1],
					ACONF->acctpool[ACONF->local3.acct[0]].ip[2],
					ACONF->acctpool[ACONF->local3.acct[0]].ip[3]);
			if(ACONF->acctpool[ACONF->local3.acct[0]].tel[0] == 0)
				fprintf(fd, "SERVICENAME=no\n");
			else
				fprintf(fd, "SERVICENAME=%s\n", ACONF->acctpool[ACONF->local3.acct[0]].tel);
			fprintf(fd, "FIREWALL=NONE\n");
			fprintf(fd, "PPPOE_EXTRA=\"\"\n");
			fprintf(fd, "PPPD_EXTRA=\"\"\n");
			fclose(fd);
		}
		fd2 = fopen("/var/config/pap-secrets", "a+");
		fprintf(fd2, "\"%s\"\t*\t\"%s\"\n",
			ACONF->acctpool[ACONF->local3.acct[0]].user,
			ACONF->acctpool[ACONF->local3.acct[0]].pass);
		fclose(fd2);
		fd2 = fopen("/var/config/chap-secrets", "a+");
		fprintf(fd2, "\"%s\"\t*\t\"%s\"\n",
			ACONF->acctpool[ACONF->local3.acct[0]].user,
			ACONF->acctpool[ACONF->local3.acct[0]].pass);
		fclose(fd2);
		system("adsl-start 6 60");
		break;

    }
  }
  usleep(SLEEP_TIME);
}

/* ************* */
/* Set DHCPD     */
/* 0     : ok    */
/* other : error */
/* ************* */
int setdhcpd(int act)
{

	/* ************************************************************ */
	/* The DHCP server ip range support netmask 255.255.255.0 now!! */
	/* ************************************************************ */

  	unsigned char temp[300];
  	unsigned char SUB[4];
  	unsigned char pid[10];
  	unsigned char check1, check2;
  	char dns_ip1[16],dns_ip2[16];
  	FILE *fd, *fd2;
  	unsigned long default_lease_time,max_lease_time;
  	unsigned long temp_lease_time;
  	ip_info_struct ife;
  	int i,num,pmac1,pmac2;
  	int ip_list[PMAC_NUM];
  	char host = 'A';
  	num = 0;
  	ACONFIG *ACONF;
  	
  	
  	#ifdef FOR_DEBUG
  		printf("-------------------------------------------------------------------------------\n\r");
  		printf("Enter setdhcpd %d procedure\n",act);
  	#endif

	// 1. read Aconfig
	#if ARM_MIPS
		ACONF = &FlashACONF;
  		read_Aconfig(ACONF);
  	#else
		ACONF = (ACONFIG *)OFFSET;
  	#endif
  	
  	// 2. close stderr
  	close(2);
  	
  	if(act == 0) {
 
   		// --- //
  		// OFF //
  		// --- //
  	 		
  		//dummy
		goto dhcpd_off;
		
  	} else if (ACONF->dhcp.enable == 1) {
 
   		// --- //
  		// ON //
  		// --- //  		
  		
  		// 1. set resolv.conf: domain, nameserver, and search
  		
  		ife.ip[0] = 0x00; ife.ip[1] = 0x00; ife.ip[2] = 0x00; ife.ip[3] = 0x00; 
		if(ACONF->local.wtype!=2) ipinfo("eth1", &ife); 
		else ipinfo("ppp0", &ife);
	
		if ((ife.ip[0]+ife.ip[1]+ife.ip[2]+ife.ip[3]) == 0) 
		{
		  //succ : for dns
		  if( ((ACONF->dhcp.dns[0].ip[0]+ACONF->dhcp.dns[0].ip[1]+ACONF->dhcp.dns[0].ip[2]+ACONF->dhcp.dns[0].ip[3]) != 0) ||
	    	      ((ACONF->dhcp.dns[1].ip[0]+ACONF->dhcp.dns[1].ip[1]+ACONF->dhcp.dns[1].ip[2]+ACONF->dhcp.dns[1].ip[3]) != 0)   )
		  {
	  		fd2 = fopen(DNS_INFO_FILE,"w");
	  		fprintf(fd2,"domain\n");
	  		if((ACONF->dhcp.dns[0].ip[0]+ACONF->dhcp.dns[0].ip[1]+ACONF->dhcp.dns[0].ip[2]+ACONF->dhcp.dns[0].ip[3]) != 0)
	  		{  
	    			fprintf(fd2,"nameserver %d.%d.%d.%d\n",
	    				ACONF->dhcp.dns[0].ip[0],
	    				ACONF->dhcp.dns[0].ip[1],
	    				ACONF->dhcp.dns[0].ip[2],
	    				ACONF->dhcp.dns[0].ip[3]           );
	  		}
	  		if((ACONF->dhcp.dns[1].ip[0]+ACONF->dhcp.dns[1].ip[1]+ACONF->dhcp.dns[1].ip[2]+ACONF->dhcp.dns[1].ip[3]) != 0)
	  		{  
	    			fprintf(fd2,"nameserver %d.%d.%d.%d\n",
	    				ACONF->dhcp.dns[1].ip[0],
	    				ACONF->dhcp.dns[1].ip[1],
	    				ACONF->dhcp.dns[1].ip[2],
	    				ACONF->dhcp.dns[1].ip[3]           );
	  		}
	  		fprintf(fd2,"search\n");	  
	  		fclose(fd2);	
		  }
		}
		
		#ifdef FOR_DEBUG
   	    		printf("dhcpd: Create recolv.conf over\n\r");
    		#endif
	
  		default_lease_time=max_lease_time=60;//KM

    		SUB[0] = ACONF->local.ip[0] & 0xff;//255
    		SUB[1] = ACONF->local.ip[1] & 0xff;//255
    		SUB[2] = ACONF->local.ip[2] & 0xff;//255
    		SUB[3] = ACONF->local.ip[3] & 0x00;//0
    		
    		if (ACONF->dhcp.lease > 0) {
    			temp_lease_time = ACONF->dhcp.lease;
    		} else {
    			temp_lease_time = 86400;
    		}
      				
		#ifdef FOR_DEBUG
			printf("dhcpd: The lease time is set to %d for dhcpd\n\r",temp_lease_time);
		#endif
	
		if((ACONF->pmac.flag & PMF_MAC_CONTROL) == PMF_MAC_CONTROL) //pmac enable
        	{
          		/* --------------- */
          		/* edit dhcpd.conf */
          		/* --------------- */
          		if((fd = fopen("/var/config/dhcpd.conf","w")) == NULL)
            			printf("PMAC: open dhcpd.conf failed!\n\r");
  	  		ife.ip[0] = 0x00; ife.ip[1] = 0x00; ife.ip[2] = 0x00; ife.ip[3] = 0x00; 
	  		if(ACONF->local.wtype!=2) 
	    			ipinfo("eth1", &ife); 
	  		else 
	    			ipinfo("ppp0", &ife);
	  		//wan is not ok
	  		if ((ife.ip[0]+ife.ip[1]+ife.ip[2]+ife.ip[3]) == 0) 
          		{
            			fprintf(fd,"default-lease-time %d;\n",60);
            			fprintf(fd,"max-lease-time %d;\n",60);
			}
			else //WAN ok
			{
		 		fprintf(fd,"default-lease-time %d;\n",86400);
	    			fprintf(fd,"max-lease-time %d;\n",86400);       
		        }

			/* dns server */
	      		strcpy(dns_ip2,"NOT");
			getDNS(dns_ip1,dns_ip2);
				
			fprintf(fd,"option domain-name-servers %s",dns_ip1);
            		if(strcmp(dns_ip2,"NOT"))
            		{
            		  fprintf(fd,", %s;\n",dns_ip2);	
            		}
            		else
            		{
            		  fprintf(fd,";\n");
            		}
        
        		/* broadcase address */
          		fprintf(fd,"option broadcast-address %d.%d.%d.%d;\n",
                		ACONF->local.ip[0],ACONF->local.ip[1],
                		ACONF->local.ip[2],255                    );
          		/* gateway */
          		fprintf(fd,"option routers %d.%d.%d.%d;\n",
                		ACONF->local.ip[0],ACONF->local.ip[1],
                		ACONF->local.ip[2],ACONF->local.ip[3] );

          		/* header : subnet & netmask */
          		fprintf(fd,"subnet %d.%d.%d.%d netmask %d.%d.%d.%d {\n",
                   		ACONF->local.ip[0],ACONF->local.ip[1],
                     		ACONF->local.ip[2],0,
                     		255,255,255,0                                  );
			
			/* pmac host */
          		for(i = 0; i < PMAC_NUM ; i++)
          		{
            			if(ACONF->pmac.list[i].ip != 0 &&
	       			   ACONF->pmac.list[i].ip >= ACONF->dhcp.range[0] &&
               			   ACONF->pmac.list[i].ip <= ACONF->dhcp.range[1]    )	     
            			{
              				ip_list[num] = (int)(ACONF->pmac.list[i].ip);
	      				num++;
		   
              				fprintf(fd,"\thost %c {\n",host);
              				fprintf(fd,"\t\thardware ethernet %x:%x:%x:%x:%x:%x;\n",
                        		ACONF->pmac.list[i].mac[0],ACONF->pmac.list[i].mac[1],
                         		ACONF->pmac.list[i].mac[2],ACONF->pmac.list[i].mac[3],
	     	         		ACONF->pmac.list[i].mac[4],ACONF->pmac.list[i].mac[5] );
              				fprintf(fd,"\t\tfixed-address %d.%d.%d.%d;\n",
                         			ACONF->local.ip[0],ACONF->local.ip[1],
                         			ACONF->local.ip[2],ACONF->pmac.list[i].ip);
              				fprintf(fd,"\t}\n");
              				host++;
	    			}
          		}

			/* ip range */
          		sort(ip_list,num);  //not implement
          				
          		pmac1 = ACONF->dhcp.range[0];
          		for(i = 0 ; i < num ; i++)
          		{
            			if(pmac1 == ip_list[i])
            			{
              				pmac1 = ip_list[i] + 1;
              				continue;
            			}

            			pmac2 = ip_list[i] - 1;
            			fprintf(fd,"\trange %d.%d.%d.%d %d.%d.%d.%d;\n",
                      				ACONF->local.ip[0],ACONF->local.ip[1],
                       				ACONF->local.ip[2],pmac1,
                       				ACONF->local.ip[0],ACONF->local.ip[1],
                       				ACONF->local.ip[2],pmac2              );
            
            			pmac1 = ip_list[i] + 1;
          		}
                    
	  		if(pmac1 != ip_list[i])
            			fprintf(fd,"\trange %d.%d.%d.%d %d.%d.%d.%d;\n",
                       				ACONF->local.ip[0],ACONF->local.ip[1],
                       				ACONF->local.ip[2],pmac1,
                       				ACONF->local.ip[0],ACONF->local.ip[1],
                       				ACONF->local.ip[2],ACONF->dhcp.range[1]);
          		/* tailer */
          		fprintf(fd,"}\n");

          		fclose(fd);

          		/* ------------------- */
          		/* restart dhcp server */
          		/* ------------------- */
          		if((fd = fopen("/var/run/dhcpd.pid","r")) != NULL)
          		{
      	    			fgets(pid,5,fd);
      	    			pid[strlen(pid)-1] = 0;
            			sprintf(temp,"kill %s",pid);
            			system(temp);
            			fclose(fd);
	  		}
	  				
	  		system("dhcpd eth0 &");
	  				
        	}
        	else //pmac disable
        	{
        		#ifdef FOR_DEBUG
   	    			printf("dhcpd: PMAC is disabled\n\r");
    			#endif
    			
    			if ((ACONF->dhcp.dns[0].ip[0] | ACONF->dhcp.dns[0].ip[1] | 
    			     ACONF->dhcp.dns[0].ip[2] | ACONF->dhcp.dns[0].ip[3]  ) == 0)
    				check1 = 0; else check1 = 1;
    			if ((ACONF->dhcp.dns[1].ip[0] | ACONF->dhcp.dns[1].ip[1] | 
    			     ACONF->dhcp.dns[1].ip[2] | ACONF->dhcp.dns[1].ip[3]  ) == 0)
    				check2 = 0; else check2 = 1;
    			
    			if ((check1 | check2) == 0)
    			{
    				#ifdef FOR_DEBUG
    					printf("Get DNS from resolv.conf\n\r");
    				#endif
				/* dns server */
	      			fd2=fopen(DNS_INFO_FILE,"r");
	      			if(fd2 == NULL)
              			{
                			printf("PMAC: open resolve.conf failed!!\n\r");
	        			return;
	      			}
	      			dns_ip2[0] = 0;
				getDNS(dns_ip1,dns_ip2);
	    			fclose(fd2);
	       			if(dns_ip2[0] == 0) strcpy(dns_ip2,"NOT");
    			} else {
    				#ifdef FOR_DEBUG
    					printf("Get DNS from Aconfig\n\r");
    				#endif
    				if (check1 == 1)
    					sprintf(dns_ip1,"%d.%d.%d.%d",ACONF->dhcp.dns[0].ip[0],
    					ACONF->dhcp.dns[0].ip[1],ACONF->dhcp.dns[0].ip[2],
    					ACONF->dhcp.dns[0].ip[3]);
    				else strcpy(dns_ip1,"NOT");
    				if (check2 == 1)
    					sprintf(dns_ip2,"%d.%d.%d.%d",ACONF->dhcp.dns[1].ip[0],
    					ACONF->dhcp.dns[1].ip[1],ACONF->dhcp.dns[1].ip[2],
    					ACONF->dhcp.dns[1].ip[3]);
    				else strcpy(dns_ip2,"NOT");
    			}
    				
        			  
          		/* make /var/config/dhcpd.conf */
          		sprintf(temp,"dhcpdconf -r -a %d -b %d -c %d.%d.%d.%d -d %d.%d.%d.%d -e %d.%d.%d.%d -f %d.%d.%d.%d -g %d.%d.%d.%d -h %s -i %d.%d.%d.%d -j %s -k %s\n\r",
	    			temp_lease_time, //ACONF->dhcps.default_lease_time,
	    			temp_lease_time, //ACONF->dhcps.max_lease_time,
	    			SUB[0],SUB[1],SUB[2],SUB[3],
	    			0xff,0xff,0xff,0x00,
	    			ACONF->local.ip[0], ACONF->local.ip[1],
	    			ACONF->local.ip[2],ACONF->dhcp.range[0],	
	    			ACONF->local.ip[0], ACONF->local.ip[1],
	    			ACONF->local.ip[2],ACONF->dhcp.range[1],
	    			ACONF->local.ip[0], ACONF->local.ip[1],ACONF->local.ip[2],255,
	    			dns_ip1,
	    			ACONF->local.ip[0], ACONF->local.ip[1],ACONF->local.ip[2],ACONF->local.ip[3],
	    			dns_ip2,
	    			ACONF->dhcp.domain);
				
          		system(temp);
          			
          		#ifdef FOR_DEBUG
   	    			printf("dhcpd: Create dhcpd.conf (%s) over\n\r", temp);
    			#endif
    			
        	}
      		
      	} else {

dhcpd_off:
		if((fd = fopen("/var/run/dhcpd.pid","r")) != NULL) {
	  		fgets(pid,10,fd);
	  		fclose(fd);
          		sprintf(temp,"kill %s",pid);
          		system(temp);
        	}
        	
	}
	
	usleep(SLEEP_TIME);

	return 0;
}




/* ************* */
/* Set NAT       */
/* 0     : ok    */
/* other : error */
/* ************* */
int setnat(int act)
{
  	unsigned char temp[100];
	ACONFIG * ACONF;
	
	#ifdef FOR_DEBUG
    		printf("-------------------------------------------------------------------------------\n\r");
    		printf("Enter setnat %d procedure\n",act);
    	#endif
	
  	#if ARM_MIPS
		ACONF = &FlashACONF;
  		read_Aconfig(ACONF);
  	#else
		ACONF = (ACONFIG *)OFFSET;
  	#endif
  
  	close(2);

	if(act == 0)	// disable
	{
		if(ACONF->local.wtype == 2)	// pppoe
		{
			sprintf(temp, "iptables -t nat -D POSTROUTING -o ppp0 -s %d.%d.%d.%d/255.255.255.0 -j MASQUERADE",
				ACONF->local.ip[0], ACONF->local.ip[1],
				ACONF->local.ip[2], ACONF->local.ip[3]);
			system(temp);
			usleep(SLEEP_TIME);
			
			sprintf(temp,"iptables -t nat -D PREROUTING -i ppp0 -d %d.%d.%d.%d/24 -j DROP",
				ACONF->local.ip[0],ACONF->local.ip[1],
				ACONF->local.ip[2],ACONF->local.ip[3]);
			system(temp);
			usleep(SLEEP_TIME);
		}
		else	//Static or Dynamic
		{
			sprintf(temp,"iptables -t nat -D POSTROUTING -o eth1 -s %d.%d.%d.%d/255.255.255.0 -j MASQUERADE",
				ACONF->local.ip[0],ACONF->local.ip[1],
				ACONF->local.ip[2],ACONF->local.ip[3]);
			system(temp);
			usleep(SLEEP_TIME);
			
			sprintf(temp,"iptables -t nat -D PREROUTING -i eth1 -d %d.%d.%d.%d/24 -j DROP",
				ACONF->local.ip[0],ACONF->local.ip[1],
				ACONF->local.ip[2],ACONF->local.ip[3]);
			system(temp);
			usleep(SLEEP_TIME);
		}
	}
	else		// enable
	{
		if(ACONF->local.wtype == 2)	//pppoe
		{
			sprintf(temp, "iptables -t nat -A POSTROUTING -o ppp0 -s %d.%d.%d.%d/255.255.255.0 -j MASQUERADE",
				ACONF->local.ip[0], ACONF->local.ip[1],
				ACONF->local.ip[2], ACONF->local.ip[3]);
			system(temp);
			usleep(SLEEP_TIME);
			
			sprintf(temp,"iptables -t nat -A PREROUTING -i ppp0 -d %d.%d.%d.%d/24 -j DROP",
				ACONF->local.ip[0],ACONF->local.ip[1],
				ACONF->local.ip[2],ACONF->local.ip[3]);
			system(temp);
			usleep(SLEEP_TIME);
		}
		else	//Static or Dynamic
		{
			sprintf(temp,"iptables -t nat -A POSTROUTING -o eth1 -s %d.%d.%d.%d/255.255.255.0 -j MASQUERADE",
				ACONF->local.ip[0],ACONF->local.ip[1],
				ACONF->local.ip[2],ACONF->local.ip[3]);
			system(temp);
			usleep(SLEEP_TIME);
			
			sprintf(temp,"iptables -t nat -A PREROUTING -i eth1 -d %d.%d.%d.%d/24 -j DROP",
				ACONF->local.ip[0],ACONF->local.ip[1],
				ACONF->local.ip[2],ACONF->local.ip[3]);
			system(temp);
			usleep(SLEEP_TIME);
	
		}
	}


}




/* ************* */
/* Set smap      */
/* 0     : ok    */
/* other : error */
/* ************* */

int setsmap(int act)
{

	char command[150];
	int i;
	ACONFIG *ACONF;
	
	#ifdef FOR_DEBUG
    		printf("-------------------------------------------------------------------------------\n\r");
    		printf("Enter setsmap %d (virtual server) procedure\n\r",act);
    	#endif
    	
	#if ARM_MIPS
		ACONF = &FlashACONF;
  		read_Aconfig(ACONF);
	#else
		ACONF = (ACONFIG *)OFFSET;
	#endif
	
	close(2);

	if (act)	// starting enabled server mapping
	{
		
		for(i = 0; i < SMAP_NUM; i++)
		{
			if(ACONF->smap[i].flag == 1)
			{
				sprintf(command, "iptables -t nat -I PREROUTING -i eth1 -p tcp --dport %d:%d -j DNAT --to %d.%d.%d.%d",
					ACONF->smap[i].port, ACONF->smap[i].uport,
					ACONF->local.ip[0], ACONF->local.ip[1], ACONF->local.ip[2], ACONF->smap[i].host);
				system(command);
				
				#ifdef FOR_DEBUG
					printf("setsmap: (%d)%s\n", i, command);
				#endif
				
				memcpy(&command[41], "udp", 3);
				system(command);
				
				#ifdef FOR_DEBUG
					printf("setsmap: (%d)%s\n\r", i, command);
				#endif	
			}
		}
	}
	else	// closing enabled server mapping
	{

		for(i = 0; i < SMAP_NUM; i++)
		{
			if(ACONF->smap[i].flag == 1)
			{
				sprintf(command, "iptables -t nat -D PREROUTING -i eth1 -p tcp --dport %d:%d -j DNAT --to %d.%d.%d.%d",
					ACONF->smap[i].port, ACONF->smap[i].uport,
					ACONF->local.ip[0], ACONF->local.ip[1], ACONF->local.ip[2], ACONF->smap[i].host);
				system(command);
				#ifdef FOR_DEBUG
					printf("setsmap: (%d)%s\n\r", i, command);
				#endif
				
				memcpy(&command[41], "udp", 3);
				system(command);
				
				#ifdef DEBUG
					printf("setsmap: (%d)%s\n\r", i, command);
				#endif
			}
		}
	}

	return 0;
}




/* ************* */
/* Set DMZ host  */
/* 0     : ok    */
/* other : error */
/* ************* */
int setdmz(int act)
{

  	char temp[120];
  	ACONFIG *ACONF;
  	
  	#ifdef FOR_DEBUG
    		printf("-------------------------------------------------------------------------------\n\r");
    		printf("Enter setdmz %d procedure\n",act);
    	#endif
    	
  	#if ARM_MIPS
		ACONF = &FlashACONF;
  		read_Aconfig(ACONF);
  	#else
		ACONF = (ACONFIG *)OFFSET;
  	#endif
  	
  	close(2);

  	if (act == 0) {
  		
    		sprintf(temp,"iptables -t nat -D PREROUTING -i eth1 -p tcp -j DNAT --to %d.%d.%d.%d",
					ACONF->local.ip[0],
					ACONF->local.ip[1],
					ACONF->local.ip[2],
					ACONF->local.dmz_host);
    		system(temp);
    		usleep(SLEEP_TIME);
    		
    		#ifdef FOR_DEBUG
    			printf("setdmz 0: %s\n",temp);
    		#endif
    		
    		sprintf(temp,"iptables -t nat -D PREROUTING -i eth1 -p udp -j DNAT --to %d.%d.%d.%d",
                                        ACONF->local.ip[0],
                                        ACONF->local.ip[1],
                                        ACONF->local.ip[2],
                                        ACONF->local.dmz_host);
    		system(temp);
    		usleep(SLEEP_TIME);
    		
    		#ifdef FOR_DEBUG
    			printf("setdmz 0: %s\n",temp);
    		#endif
    		
  	} else if (act == 1) {
  		
    		if((ACONF->local.wflag & LFLAG_DMZ) != LFLAG_DMZ) { //disable DMZ
    			
      			sprintf(temp,"iptables -t nat -D PREROUTING -i eth1 -p tcp -j DNAT --to %d.%d.%d.%d",
                                          ACONF->local.ip[0],
                                          ACONF->local.ip[1],
                                          ACONF->local.ip[2],
                                          ACONF->local.dmz_host);
      			system(temp);
      			usleep(SLEEP_TIME);
      			
      			#ifdef FOR_DEBUG
    				printf("setdmz disable: %s\n",temp);
    			#endif
    			
      			sprintf(temp,"iptables -t nat -D PREROUTING -i eth1 -p udp -j DNAT --to %d.%d.%d.%d",
                                          ACONF->local.ip[0],
                                          ACONF->local.ip[1],
                                          ACONF->local.ip[2],
                                          ACONF->local.dmz_host);
      			system(temp);
      			usleep(SLEEP_TIME);
      			
      			#ifdef FOR_DEBUG
    				printf("setdmz 1&disable: %s\n",temp);
    			#endif
    			
    		} else { //enable DMZ
    			
      			sprintf(temp,"iptables -t nat -A PREROUTING -i eth1 -p tcp -j DNAT --to %d.%d.%d.%d",
                                          ACONF->local.ip[0],
                                          ACONF->local.ip[1],
                                          ACONF->local.ip[2],
                                          ACONF->local.dmz_host);
      			system(temp);
      			usleep(SLEEP_TIME);
      			
      			#ifdef FOR_DEBUG
    				printf("setdmz 1&enable: %s\n",temp);
    			#endif
    			
      			sprintf(temp,"iptables -t nat -A PREROUTING -i eth1 -p udp -j DNAT --to %d.%d.%d.%d",
                                          ACONF->local.ip[0],
                                          ACONF->local.ip[1],
                                          ACONF->local.ip[2],
                                          ACONF->local.dmz_host);
      			system(temp);
      			usleep(SLEEP_TIME);
      			
      			#ifdef FOR_DEBUG
    				printf("setdmz enable: %s\n",temp);
    			#endif
    			
    		}
  	}
  	
  	return 1;
  
}





/* ****************** */
/* set block wan ping */
/* ****************** */

int setbwping(int act)
{
	ACONFIG *ACONF;
	
	#ifdef FOR_DEBUG
    		printf("-------------------------------------------------------------------------------\n\r");
    		printf("Enter setbwping %d procedure\n\r",act);
    	#endif
    	
	#if ARM_MIPS
		ACONF = &FlashACONF;
  		read_Aconfig(ACONF);
	#else
		ACONF = (ACONFIG *)OFFSET;
	#endif
	
	close(2);
	

	if (act)	// if function is enable, go to start it.
	{
		//check the bit to see if need to on.
		if((ACONF->local.wflag & LFLAG_BWPING) == LFLAG_BWPING) {
			//system("iptables -A INPUT -p icmp --icmp-type ping -i eth1 -j DROP");
			system("iptables -t nat -A PREROUTING -p icmp --icmp-type ping -i eth1 -j DROP");
			#ifdef FOR_DEBUG
    				printf("setbwping 1&eable: iptables -t nat -A PREROUTING -p icmp --icmp-type ping -i eth1 -j DROP\n\r");
    			#endif
		}
	}
	else	// if function is enable, go to close it.
	{
		//if((ACONF->local.wflag & LFLAG_BWPING) == LFLAG_BWPING) {
			//system("iptables -D INPUT -p icmp --icmp-type ping -i eth1 -j DROP");
			system("iptables -t nat -D PREROUTING -p icmp --icmp-type ping -i eth1 -j DROP");
			#ifdef FOR_DEBUG
    				//printf("setdmz 0&enable: iptables -t nat -D PREROUTING -p icmp --icmp-type ping -i eth1 -j DROP\n\r");
    				printf("setbwping 0: iptables -t nat -D PREROUTING -p icmp --icmp-type ping -i eth1 -j DROP\n\r");
    			#endif
		//}
	}

	return 1;
}





/* ************* */
/* Set  PPTPD    */
/* 0     : ok    */
/* other : error */
/* ************* */
/*
int setpptpd(int act)
{

  char temp[120];
  char pid[15];
  FILE *fd;

  ACONFIG *ACONF;
  #if ARM_MIPS
	ACONF = &FlashACONF;
  	read_Aconfig(ACONF);
  #else
	ACONF = (ACONFIG *)OFFSET;
  #endif
  close(2);
  if(act == 1){
     sprintf(temp,"iptables -t nat -I PREROUTING -i eth1 -p tcp --dport 1723 -j ACCEPT");
     system(temp);
     sprintf(temp,"pptpdconf -a %d.%d.%d.%d -b %d.%d.%d.%d -c %d",
     		ACONF->local.ip[0],ACONF->local.ip[1],ACONF->local.ip[2],ACONF->pptp.localIP[3],
		ACONF->local.ip[0],ACONF->local.ip[1],ACONF->local.ip[2],ACONF->pptp.start,
		ACONF->pptp.end);
     //sprintf(temp,"pptpdconf -a %d.%d.%d.%d -b %d.%d.%d.%d -c %d.%d.%d.%d",
     	//	ACONF->local.rhip[0],ACONF->local.rhip[1],ACONF->local.rhip[2],ACONF->pptp.localIP[3],
	//	ACONF->local.rhip[0],ACONF->local.rhip[1],ACONF->local.rhip[2],ACONF->pptp.start,
	//	ACONF->local.rhip[0],ACONF->local.rhip[1],ACONF->local.rhip[2],ACONF->pptp.end);
     system(temp);
     system("pptpd");
  }
  else{
     sprintf(temp,"iptables -t nat -D PREROUTING -i eth1 -p tcp --dport 1723 -j ACCEPT");
     system(temp);
     //system("pptpdconf");
     if((fd = fopen("/var/run/pptpd.pid","r")) != NULL) {
     	fgets(pid,10,fd);
     	sprintf(temp,"kill %s",pid);
     	printf("%s\n",temp);
     	system(temp);
     	fclose(fd);
	if((fd= fopen("/var/run/pptpd.pid","w")) !=NULL) {
		fprintf(fd,"");
		fclose(fd);
	}
     }
  }
}
*/







/* ************* */
/* Set PPPD      */
/* 0     : ok    */
/* other : error */
/* ************* */
/*
int setpppd(int act)
{
  unsigned char temp[50];
  FILE *fd,*fd2;

  ACONFIG *ACONF;
  #if ARM_MIPS
	ACONF = &FlashACONF;
  	read_Aconfig(ACONF);
  #else
	ACONF = (ACONFIG *)OFFSET;
  #endif
  close(2);

  if(act == 0) {

  } else if(act == 1) {

    //options file
    strcpy(temp,"pppdconf ");

    if(ACONF->pppd.pap != 0)
      strcat(temp,"-a ");
      usleep(SLEEP_TIME);
    if(ACONF->pppd.chap != 0)
      strcat(temp,"-b ");
      usleep(SLEEP_TIME);
    if(ACONF->pppd.mschap != 0)
      strcat(temp,"-c ");
      usleep(SLEEP_TIME);
    if(ACONF->pppd.mschap2 != 0)
      strcat(temp,"-d ");
      usleep(SLEEP_TIME);

    system(temp);

    //secrets files
    if(((fd  = fopen("/var/config/pap-secrets","w")) == NULL) ||
       ((fd2 = fopen("/var/config/chap-secrets","w")) == NULL)  ) {
      fprintf(stderr,"[pppd secrets maker] open file error!!\n\r");
    }
#if 1
    //1
    fprintf(fd,"%s\t*\t%s\t*\n",ACONF->pppd.name1,ACONF->pppd.pass1);
    usleep(500);
    fprintf(fd2,"%s\t*\t%s\t*\n",ACONF->pppd.name1,ACONF->pppd.pass1);
    usleep(500);
    //2
    fprintf(fd,"%s\t*\t%s\t*\n",ACONF->pppd.name2,ACONF->pppd.pass2);
    usleep(500);
    fprintf(fd2,"%s\t*\t%s\t*\n",ACONF->pppd.name2,ACONF->pppd.pass2);
    usleep(500);
    //3
    fprintf(fd,"%s\t*\t%s\t*\n",ACONF->pppd.name3,ACONF->pppd.pass3);
    usleep(SLEEP_TIME);
    fprintf(fd2,"%s\t*\t%s\t*\n",ACONF->pppd.name3,ACONF->pppd.pass3);
    usleep(SLEEP_TIME);
    //4
    fprintf(fd,"%s\t*\t%s\t*\n",ACONF->pppd.name4,ACONF->pppd.pass4);
    usleep(SLEEP_TIME);
    fprintf(fd2,"%s\t*\t%s\t*\n",ACONF->pppd.name4,ACONF->pppd.pass4);
    usleep(SLEEP_TIME);
#endif

    fclose(fd);
    fclose(fd2);
  }
}
*/

/* ****************** */
/* for Set special ap */
/* ****************** */

int htoi(char *src, int len)
{
        int i;
        int result;
        char temp;

        for(i = len - 1, result = 0; i >=0; i--)
        {
                temp = *(src + i);
                if(temp >= '0' && temp <= '9')
                        result += (temp - '0') << (4 * (len - i - 1));
                else if(temp >= 'a' && temp <= 'f')
                        result += (temp - 'a' + 10) << (4 * (len - i - 1));
                else
                        return -1;
        }
        return result;
}

/* ****************** */
/* for Set special ap */
/* ****************** */

int atoh(char *src, char *dst, int dst_len)
{
        char temp[] = "0000000000";
        int len;

        // the required length is longer than the length of temp,
        // so we can't create this string.
        if(dst_len >= strlen(temp))
                return 0;

        sprintf(dst, "%x", atoi(src));
        len = dst_len - strlen(dst);
        if(len != 0)
        {
                memcpy(temp + len, dst, strlen(dst));
                temp[dst_len] = 0;
                memcpy(dst, temp, dst_len + 1);
#ifdef DEBUG
                fprintf(stderr, "dst = %s\n", dst);
#endif
                return 1;
        }
        else
        {
#ifdef DEBUG
                fprintf(stderr, "dst = %s\n", dst);
#endif
                return 1;
        }
}


/* ************** */
/* Set Special Ap */
/* 0     : ok     */
/* other : error  */
/* ************** */

int setspap(int act)
{
	char command[110];	// 105 is the best
	char dec_port[6];
	char hex_port[5];
	int i, j;
	FILE *conf;
	FILE *dmz;
	FILE *pidf;
	char host_info[25];
	char port_range[12];
	char ip[16];
	FILE *host;
	char pid[8];
	FILE *spapd_pid;
	char temp;

  ACONFIG *ACONF;
  #if ARM_MIPS
	ACONF = &FlashACONF;
  	read_Aconfig(ACONF);
  #else
	ACONF = (ACONFIG *)OFFSET;
  #endif
  close(2);

	if(act)
	{
		conf = fopen("/var/config/spap/spap.conf", "w+");
		fseek(conf, 0L, SEEK_SET);
		for(i = 0; i < SPAP_NUM; i++)
		{
			if(ACONF->spap.trig[i].flag == 1)
			{
				sprintf(command, "iptables -t mangle -A PREROUTING -i eth0 -p tcp -s ! %d.%d.%d.%d --dport %d -j MARK --set-mark %d",
					ACONF->local.ip[0],
					ACONF->local.ip[1],
					ACONF->local.ip[2],
					ACONF->local.dmz_host,
					ACONF->spap.trig[i].port,
					i + 100);
				system(command);

				memcpy(&command[44], (void *)"udp", 3);
				system(command);

				sprintf(command, "iptables -A FORWARD -i eth0 -p tcp -s ! %d.%d.%d.%d --dport %d -j QUEUE",
					ACONF->local.ip[0],
					ACONF->local.ip[1],
					ACONF->local.ip[2],
					ACONF->local.dmz_host,
					ACONF->spap.trig[i].port);
				system(command);

				memcpy(&command[31], (void *)"udp", 3);
				system(command);

				sprintf(dec_port, "%d", ACONF->spap.trig[i].port);
				//printf("ACONF->spap.trig[%d].port = %d, dec_port = %s, ", i, ACONF->spap.trig[i].port, dec_port);
                                atoh(dec_port, hex_port, 4);
                                //printf("hex_port = %s\n", hex_port);
                                fprintf(conf, "1%s", hex_port);
                                //printf("1%s", hex_port);	// debug
                                for(j = ACONF->spap.trig[i].sp0; j <= ACONF->spap.trig[i].sp1; j++)
                                {
                                	sprintf(dec_port, "%d", ACONF->spap.sepl[j].lb);
                        	        atoh(dec_port, hex_port, 4);
                	                fprintf(conf, "%s", hex_port);
                	                //printf("%s", hex_port);	// debug
        	                        sprintf(dec_port, "%d", ACONF->spap.sepl[j].ub);
	                                atoh(dec_port, hex_port, 4);
                                	fprintf(conf, "%s", hex_port);
                                	//printf("%s", hex_port);	// debug
                        	}
                        	fprintf(conf, "\n");
                        	//printf("\n");	// debug
			}
			else
			{
				sprintf(dec_port, "%d", ACONF->spap.trig[i].port);
				//printf("ACONF->spap.trig[%d].port = %d, dec_port = %s, ", i, ACONF->spap.trig[i].port, dec_port);
				atoh(dec_port, hex_port, 4);
				//printf("hex_port = %s\n", hex_port);
				fprintf(conf, "0%s", hex_port);
				//printf("0%s", hex_port);	// debug
				for(j = ACONF->spap.trig[i].sp0; j <= ACONF->spap.trig[i].sp1; j++)
                                {
					sprintf(dec_port, "%d", ACONF->spap.sepl[j].lb);
					atoh(dec_port, hex_port, 4);
					fprintf(conf, "%s", hex_port);
					//printf("%s", hex_port);	// debug
					sprintf(dec_port, "%d", ACONF->spap.sepl[j].ub);
					atoh(dec_port, hex_port, 4);
					fprintf(conf, "%s", hex_port);
					//printf("%s", hex_port);	// debug
				}
				fprintf(conf, "\n");
				//printf("\n");	// debug
			}
		}
		fclose(conf);
		
		host = fopen("/var/config/spap/spap.host", "w+");
		for(i = 0; i < SPAP_NUM; i++)
		{
			fprintf(host, "000000000000000000000000\n");
		}
		fclose(host);

		// generate dmz file
		dmz = fopen("/var/config/spap/dmz", "w+");
		fprintf(dmz, "%d.%d.%d.%d",
			ACONF->local.ip[0],
			ACONF->local.ip[1],
			ACONF->local.ip[2],
			ACONF->local.dmz_host);
		fclose(dmz);

	}
	else
	{
		// remove WAN to LAN rules
		host = fopen("/var/config/spap/spap.host", "r");
		if(host != NULL)
		{
			fseek(host, 0L, SEEK_SET);
			i = 1;
			while(fgets(host_info, 9, host) != NULL)
			{
				if(!strncmp(host_info, "00000000", 8))
				{
					i++;
					temp = fgetc(host);
					while(temp != '\n' && temp != 0)
						temp = fgetc(host);
					continue;
				}
				else
				{
					sprintf(ip, "%d.%d.%d.%d", htoi(host_info, 2), htoi(host_info + 2, 2), htoi(host_info + 4, 2), htoi(host_info + 6, 2));
					fgets(host_info, 9, host);
					while(host_info[0] != '\n')
					{
						sprintf(port_range, "%d:%d", htoi(host_info, 4), htoi(host_info + 4, 4));
						sprintf(command, "iptables -t nat -D PREROUTING -i eth1 -p tcp --dport %s -j DNAT --to %s",
							port_range, ip);
						system(command);

						memcpy(&command[41], (void *)"udp", 3);
						system(command);

						sprintf(command, "iptables -t mangle -D PREROUTING -i eth1 -p tcp --dport %s -j MARK --set-mark %d",
							port_range, i + 199);
						system(command);

						memcpy(&command[44], (void *)"udp", 3);
						system(command);

						sprintf(command, "iptables -D FORWARD -i eth1 -p tcp --dport %s -j QUEUE",
							port_range);
						system(command);
	
						memcpy(&command[31], (void *)"udp", 3);
						system(command);
					}
					i++;
				}
			}
			fclose(host);
		}

		// remove LAN to WAN rules
		for(i = 0; i < SPAP_NUM; i++)
                {
                        if(ACONF->spap.trig[i].flag == 1)
                        {
                                sprintf(command, "iptables -t mangle -D PREROUTING -i eth0 -p tcp -s ! %d.%d.%d.%d --dport %d -j MARK --set-mark %d",
                                        ACONF->local.ip[0],
                                        ACONF->local.ip[1],
                                        ACONF->local.ip[2],
                                        ACONF->local.dmz_host,
                                        ACONF->spap.trig[i].port,
                                        i + 99);
                                system(command);

                                memcpy(&command[44], (void *)"udp", 3);
                                system(command);

                                sprintf(command, "iptables -D FORWARD -i eth0 -p tcp -s ! %d.%d.%d.%d --dport %d -j QUEUE",
                                        ACONF->local.ip[0],
                                        ACONF->local.ip[1],
                                        ACONF->local.ip[2],
                                        ACONF->local.dmz_host,
                                        ACONF->spap.trig[i].port);
                                system(command);

                                memcpy(&command[31], (void *)"udp", 3);
                                system(command);
			}
		}
		remove("/var/config/spap/spap.conf");
		remove("/var/config/spap/spap.host");
		if((pidf = fopen("/var/run/spapd", "r")) != NULL)
		{
			fgets(pid, 8, pidf);
			printf("setspap: kill pid %d\n", atoi(pid));
			kill(atoi(pid));
			fclose(pidf);
			remove("/var/run/spapd");
		}
	}
}

/* ************ */
/* set firewall */
/* ************ */

void getNetmask(DWORD ip1, DWORD ip2, BYTE *nmask)
{
	BYTE *temp_ip1, *temp_ip2;
	int i;
	BYTE op1, op2;

	temp_ip1 = (BYTE *)&ip1;
	temp_ip2 = (BYTE *)&ip2;

	for(i = 0; i < 4; i++)
	{
		if(*(temp_ip1 + i) != *(temp_ip2 + i))
			break;
		else
			*(nmask + i) = 255;
	}
	op1 = ~(*(temp_ip1 + i) | *(temp_ip2 + i));
	op2 = *(temp_ip1 + i) & *(temp_ip2 + i);
	*(nmask + i) = op1 | op2;
	i++;
	while(i < 4)
	{
		*(nmask + i) = 0;
		i++;
	}
//#ifdef DEBUG
	fprintf(stdout, "getNetmask: %d.%d.%d.%d\n", nmask[0], nmask[1], nmask[2], nmask[3]);
//#endif
}

void getNetid(DWORD ip, DWORD *nm, DWORD *netid)
{
//#ifdef DEBUG
	BYTE *dbg;
//#endif
	*netid = ip & *nm;
//#ifdef DEBUG
	dbg = (BYTE *)netid;
	fprintf(stdout, "getNetid: %d.%d.%d.%d\n", dbg[0], dbg[1], dbg[2], dbg[3]);
//#endif
}

int setfirewall(int act)
{
	char command[180];	// about 160 is enough
	WORD rflag_prot;
	char prot[4];
	BYTE nmask0[4], nmask1[4];
	BYTE netid0[4], netid1[4];
	char policy[7];
	int i;

	ACONFIG *ACONF;
	#if ARM_MIPS
		ACONF = &FlashACONF;
  		read_Aconfig(ACONF);
	#else
		ACONF = (ACONFIG *)OFFSET;
	#endif

	if(act)
	{
		// inbound
		if((ACONF->actl.ipf.flag[0] & FDF_ENABLED) == FDF_ENABLED)
		{
			system("iptables -t filter -N inbound");
			system("iptables -t filter -A FORWARD -i eth1 -j inbound");
			if((ACONF->actl.ipf.flag[0] & FDF_PASSRULE) == FDF_PASSRULE)
			{
				sprintf(policy, "DROP");
				system("iptables -t filter -A inbound -j ACCEPT");
			}
			else
			{
				sprintf(policy, "ACCEPT");
				system("iptables -t filter -A inbound -j DROP");
			}
			for(i = 0; i < PF_RULE_NUM; i++)
			{
				if((ACONF->actl.ipf.rule[i].rflag & FRF_ENABLED) != FRF_ENABLED)
					continue;
				rflag_prot = (ACONF->actl.ipf.rule[i].rflag & FRF_PROT_MASK);
				switch(rflag_prot)
				{
					case FRF_PROT_BOTH:
						*prot = 1;
						break;
					case FRF_PROT_TCP:
						sprintf(prot, "tcp");
						break;
					case FRF_PROT_UDP:
						sprintf(prot, "udp");
						break;
				}
				getNetmask(ACONF->actl.ipf.rule[i].ip0[0], ACONF->actl.ipf.rule[i].ip0[1], nmask0);
				getNetid(ACONF->actl.ipf.rule[i].ip0[0], (DWORD *)&nmask0, (DWORD *)&netid0);
				getNetmask(ACONF->actl.ipf.rule[i].ip1[0], ACONF->actl.ipf.rule[i].ip1[1], nmask1);
				getNetid(ACONF->actl.ipf.rule[i].ip1[0], (DWORD *)&nmask1, (DWORD *)&netid1);
				if(*prot == 1)	// protocol = all
				{
					sprintf(command, "iptables -t filter -I inbound -p tcp -s %d.%d.%d.%d/%d.%d.%d.%d --sport %d:%d -d %d.%d.%d.%d/%d.%d.%d.%d --dport %d:%d -j %s",
						netid0[0], netid0[1], netid0[2], netid0[3],
						nmask0[0], nmask0[1], nmask0[2], nmask0[3],
						ACONF->actl.ipf.rule[i].port0[0], ACONF->actl.ipf.rule[i].port0[1],
						netid1[0], netid1[1], netid1[2], netid1[3],
						nmask1[0], nmask1[1], nmask1[2], nmask1[3],
						ACONF->actl.ipf.rule[i].port1[0], ACONF->actl.ipf.rule[i].port1[1],
						policy);
#ifdef DEBUG
					// too long to print, or will cause crash. Do not use
					//printf("setfirewall: %s\n", command);
#endif
					system(command);

					sprintf(command, "iptables -t filter -I inbound -p udp -s %d.%d.%d.%d/%d.%d.%d.%d --sport %d:%d -d %d.%d.%d.%d/%d.%d.%d.%d --dport %d:%d -j %s",
						netid0[0], netid0[1], netid0[2], netid0[3],
						nmask0[0], nmask0[1], nmask0[2], nmask0[3],
						ACONF->actl.ipf.rule[i].port0[0], ACONF->actl.ipf.rule[i].port0[1],
						netid1[0], netid1[1], netid1[2], netid1[3],
						nmask1[0], nmask1[1], nmask1[2], nmask1[3],
						ACONF->actl.ipf.rule[i].port1[0], ACONF->actl.ipf.rule[i].port1[1],
						policy);
#ifdef DEBUG
					// too long to print, and will cause crash. Do not use
					//printf("setfirewall: %s\n", command);
#endif
					system(command);
				}
				else	// protocol only tcp or udp
				{
					sprintf(command, "iptables -t filter -I inbound -p %s -s %d.%d.%d.%d/%d.%d.%d.%d --sport %d:%d -d %d.%d.%d.%d/%d.%d.%d.%d --dport %d:%d -j %s",
						prot,
						netid0[0], netid0[1], netid0[2], netid0[3],
						nmask0[0], nmask0[1], nmask0[2], nmask0[3],
						ACONF->actl.ipf.rule[i].port0[0], ACONF->actl.ipf.rule[i].port0[1],
						netid1[0], netid1[1], netid1[2], netid1[3],
						nmask1[0], nmask1[1], nmask1[2], nmask1[3],
						ACONF->actl.ipf.rule[i].port1[0], ACONF->actl.ipf.rule[i].port1[1],
						policy);
#ifdef DEBUG
					// too long to print, and will cause crash. Do not use
					//printf("setfirewall: %s\n", command);
#endif
					system(command);
				}
			}
		}
		// outbound
		if((ACONF->actl.ipf.flag[1] & FDF_ENABLED) == FDF_ENABLED)
		{
			system("iptables -t filter -N outbound");
			system("iptables -t filter -A FORWARD -o eth1 -j outbound");
			if((ACONF->actl.ipf.flag[1] & FDF_PASSRULE) == FDF_PASSRULE)
			{
				sprintf(policy, "DROP");
				system("iptables -t filter -A outbound -j ACCEPT");
			}
			else
			{
				sprintf(policy, "ACCEPT");
				system("iptables -t filter -A outbound -j DROP");
			}
			for(i = PF_RULE_NUM; i < PF_RULE_NUM * 2; i++)
			{
				if((ACONF->actl.ipf.rule[i].rflag & FRF_ENABLED) != FRF_ENABLED)
					continue;
				rflag_prot = (ACONF->actl.ipf.rule[i].rflag & FRF_PROT_MASK);
				switch(rflag_prot)
				{
					case FRF_PROT_BOTH:
						*prot = 1;
						break;
					case FRF_PROT_TCP:
						sprintf(prot, "tcp");
						break;
					case FRF_PROT_UDP:
						sprintf(prot, "udp");
						break;
				}
				getNetmask(ACONF->actl.ipf.rule[i].ip0[0], ACONF->actl.ipf.rule[i].ip0[1], nmask0);
				getNetid(ACONF->actl.ipf.rule[i].ip0[0], (DWORD *)&nmask0, (DWORD *)&netid0);
				getNetmask(ACONF->actl.ipf.rule[i].ip1[0], ACONF->actl.ipf.rule[i].ip1[1], nmask1);
				getNetid(ACONF->actl.ipf.rule[i].ip1[0], (DWORD *)&nmask1, (DWORD *)&netid1);
				if(*prot == 1)	// protocol = all
				{
					sprintf(command, "iptables -t filter -I outbound -p tcp -s %d.%d.%d.%d/%d.%d.%d.%d --sport %d:%d -d %d.%d.%d.%d/%d.%d.%d.%d --dport %d:%d -j %s",
						netid0[0], netid0[1], netid0[2], netid0[3],
						nmask0[0], nmask0[1], nmask0[2], nmask0[3],
						ACONF->actl.ipf.rule[i].port0[0], ACONF->actl.ipf.rule[i].port0[1],
						netid1[0], netid1[1], netid1[2], netid1[3],
						nmask1[0], nmask1[1], nmask1[2], nmask1[3],
						ACONF->actl.ipf.rule[i].port1[0], ACONF->actl.ipf.rule[i].port1[1],
						policy);
#ifdef DEBUG
					// too long to print, and will cause crash. Do not use
					//fprintf(stdout, "setfirewall: %s\n", command);
#endif
					system(command);

					sprintf(command, "iptables -t filter -I outbound -p udp -s %d.%d.%d.%d/%d.%d.%d.%d --sport %d:%d -d %d.%d.%d.%d/%d.%d.%d.%d --dport %d:%d -j %s",
						netid0[0], netid0[1], netid0[2], netid0[3],
						nmask0[0], nmask0[1], nmask0[2], nmask0[3],
						ACONF->actl.ipf.rule[i].port0[0], ACONF->actl.ipf.rule[i].port0[1],
						netid1[0], netid1[1], netid1[2], netid1[3],
						nmask1[0], nmask1[1], nmask1[2], nmask1[3],
						ACONF->actl.ipf.rule[i].port1[0], ACONF->actl.ipf.rule[i].port1[1],
						policy);
#ifdef DEBUG
					// too long to print, and will cause crash. Do not use
					//fprintf(stdout, "setfirewall: %s\n", command);
#endif
					system(command);
				}
				else	// protocol only tcp or udp
				{
					sprintf(command, "iptables -t filter -I outbound -p %s -s %d.%d.%d.%d/%d.%d.%d.%d --sport %d:%d -d %d.%d.%d.%d/%d.%d.%d.%d --dport %d:%d -j %s",
						prot,
						netid0[0], netid0[1], netid0[2], netid0[3],
						nmask0[0], nmask0[1], nmask0[2], nmask0[3],
						ACONF->actl.ipf.rule[i].port0[0], ACONF->actl.ipf.rule[i].port0[1],
						netid1[0], netid1[1], netid1[2], netid1[3],
						nmask1[0], nmask1[1], nmask1[2], nmask1[3],
						ACONF->actl.ipf.rule[i].port1[0], ACONF->actl.ipf.rule[i].port1[1],
						policy);
#ifdef DEBUG
					// too long to print, and will cause crash. Do not use
					//fprintf(stdout, "setfirewall: %s\n", command);
#endif
					system(command);
				}
			}
		}
	}
	else
	{
		// inbound
		if((ACONF->actl.ipf.flag[0] & FDF_ENABLED) == FDF_ENABLED)
		{
			system("iptables -t filter -D FORWARD -i eth1 -j inbound");
			system("iptables -t filter -F inbound");
			system("iptables -t filter -X inbound");
		}
		// outbound
		if((ACONF->actl.ipf.flag[1] & FDF_ENABLED) == FDF_ENABLED)
		{
			system("iptables -t filter -D FORWARD -o eth1 -j outbound");
			system("iptables -t filter -F outbound");
			system("iptables -t filter -X outbound");
		}
	}
	return 0;
}

/* ********** */
/* pptpc_dial */
/* ********** */
/*
int pptpc_dial(char *ip,char *name, char *pswd)
{
  unsigned char temp[50];
  sprintf(temp,"pptp %s name %s -r",ip,name);
  system(temp);
}
*/
// succ 0513
/*
int pptpc_disc(int index, VPN_struct *vpn)
{
  unsigned char command[50],pid[10];
  FILE *fd;

  // remove ip file in /var/run/pptp
  sprintf(command,"/var/run/pptp/%d.%d.%d.%d",vpn->connections[index].ip[0],vpn->connections[index].ip[1],
                                              vpn->connections[index].ip[2],vpn->connections[index].ip[3] );
  remove(command);

  // remove pid of pppd
  sprintf(command,"/var/run/pptp/pptpc.%d.%d.%d.%d",vpn->connections[index].ip[0],vpn->connections[index].ip[1],
                                                    vpn->connections[index].ip[2],vpn->connections[index].ip[3] );
  fd = fopen(command,"r");
  fgets(pid,10,fd);
  fclose(fd);
  remove(command);
  sprintf(command,"kill %s",pid);
  system(command);

  // remove pid of pptpc
  sprintf(command,"/var/run/pptp/pptpcall.%d.%d.%d.%d",vpn->connections[index].ip[0],vpn->connections[index].ip[1],
                                                       vpn->connections[index].ip[2],vpn->connections[index].ip[3] );
  fd = fopen(command,"r");
  fgets(pid,10,fd);
  fclose(fd);
  remove(command);
  sprintf(command,"kill %s",pid);
  system(command);
}
*/
// succ

/* ************ */
/* url blocking */
/* ************ */
/*
int add_url(ACONFIG *src, char *url)
{
	int i = 0;
	while(src->ids.urlblock.url[i].string[0] != 0)
		i++;

	if(i < 100)
		strcpy(src->ids.urlblock.url[i].string,url);
	else
		return 0;

	return 1;
}
int del_url(ACONFIG *src, int num)
{
	int i;
	num--;
	if(src->ids.urlblock.url[num].string[0] != 0)
		src->ids.urlblock.url[num].string[0] = 0;

	i = num + 1;
	if(i == 100)
		return 1;
	while(src->ids.urlblock.url[i].string[0] != 0)
	{
		//memcpy((void *)src->ids.urlblock.url[i - 1].string, (void *)src->ids.urlblock.url[i].string, strlen(src->ids.urlblock.url[i].string));
		strcpy(src->ids.urlblock.url[i-1].string,src->ids.urlblock.url[i].string);
		i++;
		if(i == 100)
		{
			src->ids.urlblock.url[i - 1].string[0] = 0;
			return 1;
		}
	}
	src->ids.urlblock.url[i - 1].string[0] = 0;
	return 1;
}
*/
/* ************ */
/* ids switch   */
/* ************ */
/*
int setids_pingf(int act)
{
	char command[100];
	ACONFIG *ACONF;
	#if ARM_MIPS
		ACONF = &FlashACONF;
  		read_Aconfig(ACONF);
	#else
		ACONF = (ACONFIG *)OFFSET;
	#endif
	close(2);

	if(act)
	{
		sprintf(command, "iptables -N pingflood");
		system(command);

		sprintf(command, "iptables -A pingflood -m limit --limit 1/sec --limit-burst 1 -j RETURN");
		system(command);

		sprintf(command, "iptables -A pingflood -m limit --limit 10/minute --limit-burst 1 -j LOG --log-prefix %s", PINGF_NUM);
		system(command);

		sprintf(command, "iptables -A pingflood -j DROP");
		system(command);

		sprintf(command, "iptables -A INPUT -i eth1 -p icmp --icmp-type echo-request -m state --state NEW -j pingflood");
		system(command);
	}
	else
	{
		sprintf(command, "iptables -D INPUT -i eth1 -p icmp --icmp-type echo-request -m state --state NEW -j pingflood");
		system(command);

		sprintf(command, "iptables -F pingflood");
		system(command);

		sprintf(command, "iptables -X pingflood");
		system(command);
	}

	return 0;
}
*/
/*
int setids_smurf(int act)
{
	char command[90];
	ACONFIG *ACONF;
	#if ARM_MIPS
		ACONF = &FlashACONF;
  		read_Aconfig(ACONF);
	#else
		ACONF = (ACONFIG *)OFFSET;
	#endif
	close(2);

	if(act)
	{
		sprintf(command, "iptables -N smurf");
		system(command);

		sprintf(command, "iptables -A smurf -m state --state ESTABLISHED,RELATED -j ACCEPT");
		system(command);

		sprintf(command, "iptables -A smurf -m limit --limit 10/minute --limit-burst 1 -j LOG --log-prefix %s", SMURF_NUM);
		system(command);

		sprintf(command, "iptables -A smurf -j DROP");
		system(command);

		sprintf(command, "iptables -A INPUT -i eth1 -p ICMP --icmp-type echo-reply -j smurf");
		system(command);
	}
	else
	{
		sprintf(command, "iptables -D INPUT -i eth1 -p ICMP --icmp-type echo-reply -j smurf");
		system(command);

		sprintf(command, "iptables -F smurf");
		system(command);

		sprintf(command, "iptables -X smurf");
		system(command);
	}

	return 0;
}
*/
/*
int setids_psd(int act)
{
	char command[130];
	ACONFIG *ACONF;
	#if ARM_MIPS
		ACONF = &FlashACONF;
  		read_Aconfig(ACONF);
	#else
		ACONF = (ACONFIG *)OFFSET;
	#endif
	close(2);

	if(act)
	{
		sprintf(command, "iptables -N psd");
		system(command);

		sprintf(command, "iptables -A psd -m limit --limit 10/minute --limit-burst 1 -j LOG --log-prefix %s", PSD_NUM);
		system(command);

		//sprintf(command, "iptables -A psd -d %d.%d.%d.%d -j ACCEPT",
		//	ACONF->local.rhip[0],
		//	ACONF->local.rhip[1],
		//	ACONF->local.rhip[2],
		//	ACONF->local.dmz_host);
		//system(command);

		sprintf(command, "iptables -A psd -j DROP");
		system(command);

		sprintf(command, "iptables -A FORWARD -i eth1 -o eth0 -p tcp -d %d.%d.%d.0/24 -m psd --psd-weight-threshold 5 --psd-delay-threshold 200 -j psd",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2]);
		system(command);
	}
	else
	{
		sprintf(command, "iptables -D FORWARD -i eth1 -o eth0 -p tcp -d %d.%d.%d.0/24 -m psd --psd-weight-threshold 5 --psd-delay-threshold 200 -j psd",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2]);
		system(command);

		sprintf(command, "iptables -F psd");
		system(command);

		sprintf(command, "iptables -X psd");
		system(command);
	}

	return 0;
}
*/
/*
int setids_fraggle(int act)
{
	char command[120];
	ACONFIG *ACONF;
	#if ARM_MIPS
		ACONF = &FlashACONF;
  		read_Aconfig(ACONF);
	#else
		ACONF = (ACONFIG *)OFFSET;
	#endif
	close(2);

	if(act)
	{
		sprintf(command, "iptables -N fraggle");
		system(command);

		sprintf(command, "iptables -A fraggle -p udp -m state --state ESTABLISHED -j ACCEPT");
		system(command);

		sprintf(command, "iptables -A fraggle -m limit --limit 10/minute --limit-burst 1 -j LOG --log-prefix %s", FRAGGLE_NUM);
		system(command);

		sprintf(command, "iptables -A fraggle -j DROP");
		system(command);

		//sprintf(command, "iptables -A FORWARD -i eth1 -o eth0 -p udp -m multiport --sports 7,11,19,37,45,513,550 -d ! %d.%d.%d.%d -j fraggle",
		//	ACONF->local.rhip[0],
		//	ACONF->local.rhip[1],
		//	ACONF->local.rhip[2],
		//	ACONF->local.dmz_host);
		sprintf(command, "iptables -A FORWARD -i eth1 -o eth0 -p udp -m multiport --sports 7,11,19,37,45,513,550 -j fraggle");
		system(command);
	}
	else
	{
		//sprintf(command, "iptables -D FORWARD -i eth1 -o eth0 -p udp -m multiport --sports 7,11,19,37,45,513,550 -d ! %d.%d.%d.%d -j fraggle",
		//	ACONF->local.rhip[0],
		//	ACONF->local.rhip[1],
		//	ACONF->local.rhip[2],
		//	ACONF->local.dmz_host);
		sprintf(command, "iptables -D FORWARD -i eth1 -o eth0 -p udp -m multiport --sports 7,11,19,37,45,513,550 -j fraggle");
		system(command);

		sprintf(command, "iptables -F fraggle");
		system(command);

		sprintf(command, "iptables -X fraggle");
		system(command);
	}

	return 0;
}
*/
/*
int setids_snork(int act)
{
	char command[140];
	ACONFIG *ACONF;
	#if ARM_MIPS
		ACONF = &FlashACONF;
  		read_Aconfig(ACONF);
	#else
		ACONF = (ACONFIG *)OFFSET;
	#endif
	close(2);

	if(act)
	{
		sprintf(command, "iptables -N snork");
		system(command);

		sprintf(command, "iptables -A snork -m limit --limit 10/minute --limit-burst 1 -j LOG --log-prefix %s", SNORK_NUM);
		system(command);

		sprintf(command, "iptables -A snork -j DROP");
		system(command);

		sprintf(command, "iptables -A FORWARD -i eth1 -o eth0 -p udp --dport 135 -m multiport --sports 7,11,19,37,45,135,513,550 -j snork");
		system(command);
	}
	else
	{
		sprintf(command, "iptables -D FORWARD -i eth1 -o eth0 -p udp --dport 135 -m multiport --sports 7,11,19,37,45,135,513,550 -j snork");
		system(command);

		sprintf(command, "iptables -F snork");
		system(command);

		sprintf(command, "iptables -X snork");
		system(command);
	}

	return 0;
}
*/
/*
int setids_land(int act)
{
	char command[100];
	ACONFIG *ACONF;
	#if ARM_MIPS
		ACONF = &FlashACONF;
  		read_Aconfig(ACONF);
	#else
		ACONF = (ACONFIG *)OFFSET;
	#endif
	close(2);

	if(act)
	{
		sprintf(command, "iptables -t mangle -N land");
		system(command);

		sprintf(command, "iptables -t mangle -A land -m limit --limit 10/minute --limit-burst 1 -j LOG --log-prefix %s", LAND_NUM);
		system(command);

		sprintf(command, "iptables -t mangle -A land -j DROP");
		system(command);

		sprintf(command, "iptables -t mangle -A PREROUTING -p TCP -i eth1 -s %d.%d.%d.%d -d %d.%d.%d.%d -j land",
			ACONF->local.wip[0],
			ACONF->local.wip[1],
			ACONF->local.wip[2],
			ACONF->local.wip[3],
			ACONF->local.wip[0],
			ACONF->local.wip[1],
			ACONF->local.wip[2],
			ACONF->local.wip[3]);
		system(command);
	}
	else
	{
		sprintf(command, "iptables -t mangle -D PREROUTING -p TCP -i eth1 -s %d.%d.%d.%d -d %d.%d.%d.%d -j land",
			ACONF->local.wip[0],
			ACONF->local.wip[1],
			ACONF->local.wip[2],
			ACONF->local.wip[3],
			ACONF->local.wip[0],
			ACONF->local.wip[1],
			ACONF->local.wip[2],
			ACONF->local.wip[3]);
		system(command);

		sprintf(command, "iptables -t mangle -F land");
		system(command);

		sprintf(command, "iptables -t mangle -X land");
		system(command);
	}

	return 0;
}
*/
/*
int setids_urlblock(int act)
{
	FILE *fp;
	int i;
	char command[110];
	ACONFIG *ACONF;
	#if ARM_MIPS
		ACONF = &FlashACONF;
  		read_Aconfig(ACONF);
	#else
		ACONF = (ACONFIG *)OFFSET;
	#endif
	close(2);

	if(act)
	{
		fp = fopen("/var/config/ipq/url.conf", "w");
		if(fp == NULL)
		{
			fclose(fp);
			return 0;
		}
		for(i = 0; ACONF->ids.urlblock.url[i].string[0] != 0; i++)
		{
			fprintf(fp, "%s\n", ACONF->ids.urlblock.url[i].string);
		}
		fclose(fp);

		sprintf(command, "iptables -t mangle -A PREROUTING -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport 80 -j MARK --set-mark 3",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);

		sprintf(command, "iptables -A FORWARD -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport 80 -j QUEUE",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);

		if(ACONF->ids.urlblock.proxy)
		{
			sprintf(command, "iptables -t mangle -A PREROUTING -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport %d -j MARK --set-mark 3",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host,
				ACONF->ids.urlblock.proxy);
			system(command);

			sprintf(command, "iptables -A FORWARD -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport %d -j QUEUE",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host,
				ACONF->ids.urlblock.proxy);
			system(command);
		}
	}
	else
	{
		fp = fopen("/var/config/ipq/url.conf", "w");
		fclose(fp);

		sprintf(command, "iptables -t mangle -D PREROUTING -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport 80 -j MARK --set-mark 3",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);

		sprintf(command, "iptables -D FORWARD -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport 80 -j QUEUE",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);

		if(ACONF->ids.urlblock.proxy)
		{
			sprintf(command, "iptables -t mangle -D PREROUTING -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport %d -j MARK --set-mark 3",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host,
				ACONF->ids.urlblock.proxy);
			system(command);

			sprintf(command, "iptables -D FORWARD -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport %d -j QUEUE",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host,
				ACONF->ids.urlblock.proxy);
			system(command);
		}
	}

	return 0;
}
*/
/* ************ */
/* virus pattern*/
/* 0:error      */
/* 1:success    */
/* ************ */
/*
int add_virus(ACONFIG *src, int protocol, int port, char * pattern)
{
	int i = 0;
	while(src->ids.virus[i].pattern[0] != 0)
		i++;
	//memcpy((void *)src->ids.urlblock.url[i].string, (void *)url, strlen(url));
	if(i == VIRUS_PATTERN_NUM )
		return 0;
	strcpy(src->ids.virus[i].pattern,pattern);
	src->ids.virus[i].protocol = protocol;
	src->ids.virus[i].port = port;
	return 1;
}
int del_virus(ACONFIG *src, int num)
{
	int i;
	num--;
	if(num < 0 || num >VIRUS_PATTERN_NUM )
		return 0;
	if(src->ids.virus[num].pattern[0] != 0)
	{
		src->ids.virus[num].protocol=0;
		src->ids.virus[num].port=0;
		src->ids.virus[num].pattern[0] = 0;
	}
	i = num + 1;
	if( i == VIRUS_PATTERN_NUM )
		return 1;
	while( src->ids.virus[i].pattern[0] != 0 )
	{
		//memcpy((void *)src->ids.urlblock.url[i - 1].string, (void *)src->ids.urlblock.url[i].string, strlen(src->ids.urlblock.url[i].string));
		strcpy(src->ids.virus[i-1].pattern,src->ids.virus[i].pattern);
		src->ids.virus[i-1].protocol = src ->ids.virus[i].protocol;
		src->ids.virus[i-1].port = src ->ids.virus[i].port;
		i++;
		if(i == VIRUS_PATTERN_NUM)
			break;
	}
	src->ids.virus[i - 1].pattern[0] = 0;
	src->ids.virus[i-1].protocol = 0;
	src->ids.virus[i-1].port = 0;
	return 1;
}
*/
/*-----Virus Parser-----*/
/*
int virusParser()
{
	FILE *creat;
	char protocol[4];
	char port[6];
	char pattern[MAX];
	char name[100];
	char hostnet[25];
	char command1[110];
	char command2[110];
	char DMZ[25];
	int i,temp;
	ACONFIG *a;
	#if ARM_MIPS
		a = &FlashACONF;
  		read_Aconfig(a);
	#else
		a = (ACONFIG *)OFFSET;
	#endif
	close(2);

	printf("in parser\n\r");
	//strcpy(name,VIRUS_PATH);
	//strcat(name,pattern);
	//sprintf(hostnet,"%d.%d.%d.0/24",a->local.rhip[0],a->local.rhip[1],a->local.rhip[2]);
	sprintf(DMZ,"%d.%d.%d.%d",a->local.rhip[0],a->local.rhip[1],a->local.rhip[2],a->local.dmz_host);
	//printf("hostnet=%s\n",hostnet);
	for(i=0;i<50;i++)
	{
		if(a->ids.virus[i].pattern[0]=='\0')
			continue;
		printf("i=%d \n",i);
		if(a->ids.virus[i].protocol== 0)
			strcpy(protocol,"tcp");
		else
			strcpy(protocol,"udp");
		temp=(int)a->ids.virus[i].port;
		//printf("port=%d\n",temp);
		sprintf(port,"%d",temp);
		//printf("port=%s\n",port);
		//set command1 to add "mark"
		//strcpy(command1,"iptables -t mangle -A PREROUTING -p ");
		//strcat(command1,protocol);
		//strcat(command1," -s ! ");
		//strcat(command1,hostnet);
		//strcat(command1," --dport ");
		//strcat(command1,port);
		//strcat(command1," -j MARK --set-mark 6");
		//command1[strlen(command1)] = '\0';
		//sprintf(command1,"iptables -t mangle -A PREROUTING -p %s -s ! %s --dport %s -j MARK --set-mark 6",
		//		protocol, hostnet, port);
		sprintf(command1,"iptables -t mangle -A PREROUTING -i eth1 -p %s -d ! %s --dport %s -j MARK --set-mark 6",
				protocol, DMZ, port);
		//set command2 to add "QUEUE"
		//strcpy(command2,"iptables -A FORWARD -p ");
		//strcat(command2,protocol);
		//strcat(command2," -s ! ");
		//strcat(command2,hostnet);
		//strcat(command2," --dport ");
		//strcat(command2,port);
		//strcat(command2," -j QUEUE");
		//command2[strlen(command2)] = '\0';
		//sprintf(command2,"iptables -A FORWARD -p %s -s ! %s --dport %s -j QUEUE",
		//		protocol, hostnet, port);
		sprintf(command2,"iptables -A FORWARD -i eth1 -p %s -d ! %s --dport %s -j QUEUE",
				protocol, DMZ, port);
		//printf("protocol=%s\n",protocol);
		//printf("port=%s\n",port);
		//printf("pattern=%s\n",pattern);
		if(strcmp(protocol,"tcp")==0){
			name[0]='\0';
			//strcpy(name,"t");
			strcpy(name,VIRUS_PATH);
			strcat(name,"t");
			system(command1);
			system(command2);
		}
		else if(strcmp(protocol,"udp")==0){
			name[0]='\0';
			//strcpy(name,"u");
			strcpy(name,VIRUS_PATH);
			strcat(name,"u");
			system(command1);
			system(command2);
		}
		else {
			//printf("protocol unknow\n");
			return 0;
		}
		strcat(name,port);
		//printf("file=%s\n",name);
		//getchar();
		for(temp=0;temp<5;temp++)
		{
			if((creat=fopen(name,"a"))==NULL)
				continue;
			else
				break;
		}
		if(creat != NULL)
		{
			fprintf(creat,"%s\n",a->ids.virus[i].pattern,creat);
			fclose(creat);
		}
		else
			printf("can't open file\n\r");
	}

	return 0;
}
*/
/*-----End Virus Parser-----*/
/* ************** */
/* set virus scan */
/* ************** */
/*
int setids_virusscan(int act)
{
	//char buf[10];
	char protocol[4];
	//char port[6];
	char command[110];
	int i;
	ACONFIG *a;
	#if ARM_MIPS
		a = &FlashACONF;
  		read_Aconfig(a);
	#else
		a = (ACONFIG *)OFFSET;
	#endif
	close(2);
	//printf("1-2\n");
	if(act)
	{
		//printf("1-3\n");
		virusParser();
		//printf("1-4\n");
	}
	else
	{
		//printf("1-5\n");
		if((a->ids.flag[1]&0x20)==0x20)
		{
			for(i=0;i<50;i++)
			{
				//printf("1-6\n");
				if(a->ids.virus[i].pattern[0]==0)
				{
					continue;
					//printf("1-7\n");
				}
				if(a->ids.virus[i].protocol==0)
					sprintf(protocol,"tcp");
				else
					sprintf(protocol,"udp");
				//printf("1-7.\n");
				sprintf(command,"iptables -t mangle -D PREROUTING -i eth1 -p %s -d ! %d.%d.%d.%d --dport %d -j MARK --set-mark 6",
						protocol,a->local.rhip[0],a->local.rhip[1],a->local.rhip[2],a->local.dmz_host,
						a->ids.virus[i].port);
				system(command);
				//printf("%s\n",command);
				//printf("1-8\n");
				sprintf(command,"iptables -D FORWARD -i eth1 -p %s -d ! %d.%d.%d.%d --dport %d -j QUEUE",
						protocol,a->local.rhip[0],a->local.rhip[1],a->local.rhip[2],a->local.dmz_host,
						a->ids.virus[i].port);
				system(command);
				//printf("%s\n",command);
				//printf("1-9\n");
			}
			//printf("1-10\n");
			//strcpy(command,VIRUS_PATH);
			//strcat(command,"*");
			//remove(command);
		}
	}
	return 0;
}
*/
/*-----*/
/*
int setids_udpbomb(int act)
{
	FILE *fp;

	if(act)
	{
		fp = fopen("/proc/sys/net/ipv4/udp_bomb", "w");
		if(fp == NULL)
		{
			fclose(fp);
			return 1;
		}
		fprintf(fp, "1");
		fclose(fp);
	}
	else
	{
		fp = fopen("/proc/sys/net/ipv4/udp_bomb", "w");
		if(fp == NULL)
		{
			fclose(fp);
			return 1;
		}
		fprintf(fp, "0");
		fclose(fp);
	}

	return 0;
}

int setids_synf(int act)
{
	FILE *fp;

	if(act)
	{
		fp = fopen("/proc/sys/net/ipv4/tcp_syncookies", "w");
		if(fp == NULL)
		{
			fclose(fp);
			return 1;
		}
		fprintf(fp, "1");
		fclose(fp);
	}
	else
	{
		fp = fopen("/proc/sys/net/ipv4/tcp_syncookies", "w");
		if(fp == NULL)
		{
			fclose(fp);
			return 1;
		}
		fprintf(fp, "0");
		fclose(fp);
	}

	return 0;
}

int setids_icmpun(int act)
{
	FILE *fp;
	char command[110];
	ACONFIG *ACONF;
	#if ARM_MIPS
		ACONF = &FlashACONF;
  		read_Aconfig(ACONF);
	#else
		ACONF = (ACONFIG *)OFFSET;
	#endif
	close(2);

	if(act)
	{
		fp = fopen("/proc/sys/net/ipv4/icmp_ignore_dest_unreach", "w");
		if(fp == NULL)
		{
			fclose(fp);
			return 1;
		}
		fprintf(fp, "1");
		fclose(fp);

		sprintf(command, "iptables -A FORWARD -i eth1 -o eth0 -p icmp --icmp-type network-unreachable -j DROP");
		system(command);

		sprintf(command, "iptables -A FORWARD -i eth1 -o eth0 -p icmp --icmp-type host-unreachable -j DROP");
		system(command);

		sprintf(command, "iptables -A FORWARD -i eth1 -o eth0 -p icmp --icmp-type protocol-unreachable -j DROP");
		system(command);

		sprintf(command, "iptables -A FORWARD -i eth1 -o eth0 -p icmp --icmp-type port-unreachable -j DROP");
		system(command);
	}
	else
	{
		fp = fopen("/proc/sys/net/ipv4/icmp_ignore_dest_unreach", "w");
		if(fp == NULL)
		{
			fclose(fp);
			return 1;
		}
		fprintf(fp, "0");
		fclose(fp);

		sprintf(command, "iptables -D FORWARD -i eth1 -o eth0 -p icmp --icmp-type network-unreachable -j DROP");
		system(command);

		sprintf(command, "iptables -D FORWARD -i eth1 -o eth0 -p icmp --icmp-type host-unreachable -j DROP");
		system(command);

		sprintf(command, "iptables -D FORWARD -i eth1 -o eth0 -p icmp --icmp-type protocol-unreachable -j DROP");
		system(command);

		sprintf(command, "iptables -D FORWARD -i eth1 -o eth0 -p icmp --icmp-type port-unreachable -j DROP");
		system(command);
	}

	return 0;
}

int setids_dns(int act)
{
	char command[100];
	ACONFIG *ACONF;
	#if ARM_MIPS
		ACONF = &FlashACONF;
  		read_Aconfig(ACONF);
	#else
		ACONF = (ACONFIG *)OFFSET;
	#endif
	close(2);

	if(act)
	{
		sprintf(command, "iptables -N dns");
		system(command);

		sprintf(command, "iptables -A dns -m limit --limit 10/minute --limit-burst 1 -j LOG --log-prefix %s", DNS_SCAN_NUM);
		system(command);
		sprintf(command, "iptables -A dns -j DROP");
		system(command);

		sprintf(command, "iptables -A FORWARD -p tcp -s ! %d.%d.%d.%d -d %d.%d.%d.%d --dport 53 -j dns",
			ACONF->ids.dns_scan.wan_dns[0],
			ACONF->ids.dns_scan.wan_dns[1],
			ACONF->ids.dns_scan.wan_dns[2],
			ACONF->ids.dns_scan.wan_dns[3],
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->ids.dns_scan.lan_dns);
		//printf("%s\n",command);
		system(command);
	}
	else
	{
		if((ACONF->ids.flag[1] & 0x04) == 0x04)
		{
			sprintf(command, "iptables -D FORWARD -p tcp -s ! %d.%d.%d.%d -d %d.%d.%d.%d --dport 53 -j dns",
				ACONF->ids.dns_scan.wan_dns[0],
				ACONF->ids.dns_scan.wan_dns[1],
				ACONF->ids.dns_scan.wan_dns[2],
				ACONF->ids.dns_scan.wan_dns[3],
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->ids.dns_scan.lan_dns);
			//printf("%s\n",command);
			system(command);

			sprintf(command, "iptables -F dns");
			system(command);

			sprintf(command, "iptables -X dns");
			system(command);
		}
	}

	return 0;
}

int setids_mailblock(int act)
{
	FILE *fp;
	int i;
	char command[110];
	ACONFIG *ACONF;
	#if ARM_MIPS
		ACONF = &FlashACONF;
  		read_Aconfig(ACONF);
	#else
		ACONF = (ACONFIG *)OFFSET;
	#endif
	close(2);

	if(act)
	{

		//----mbomb2 flow block
		if((ACONF->ids.flag[1]&0x80)==0x80)
		{
			//printf("m2\n");
			fp=fopen(MBOMB2_PATH,"w");
			fprintf(fp,"1\n");
			fprintf(fp,"%d\n",ACONF->ids.mbomb2.total_sender);
			fprintf(fp,"%d\n",ACONF->ids.mbomb2.total_mails);
			fclose(fp);
		}
		else
		{
			//printf("off m2\n");
			fp=fopen(MBOMB2_PATH,"w");
			fprintf(fp,"0\n");
			fclose(fp);
		}

		//----mbomb1 address block
		if((ACONF->ids.flag[1]&0x40)==0x40)
		{
			//printf("m1\n");
			fp=fopen(MBOMB_PATH,"w");
			fprintf(fp,"1\n");
			fclose(fp);
		}
		else
		{	//printf("off m1\n");
			fp=fopen(MBOMB_PATH,"w");
			fprintf(fp,"0\n");
			fclose(fp);
		}

		fp = fopen("/var/config/ipq/mailaddr.conf", "w");
		if(fp == NULL)
		{
			fclose(fp);
			return 0;
		}
		for(i = 0; ACONF->ids.mailblock[i].string[0] != 0; i++)
		{
			fprintf(fp, "%s\n", ACONF->ids.mailblock[i].string);
		}
		fclose(fp);

		sprintf(command, "iptables -t mangle -A PREROUTING -i eth1 -p TCP ! --syn -d ! %d.%d.%d.%d --dport 25 -j MARK --set-mark 4",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);

		sprintf(command, "iptables -A FORWARD -i eth1 -o eth0 -p TCP ! --syn -d ! %d.%d.%d.%d --dport 25 -j QUEUE",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);
	}
	else
	{

		//----close mbomb2 flow block
		fp=fopen(MBOMB2_PATH,"w");
		fprintf(fp,"0\n");
		fclose(fp);
		//----close mbomb address block
		fp=fopen(MBOMB_PATH,"w");
		fprintf(fp,"0\n");
		fclose(fp);


		fp = fopen("/var/config/ipq/mailaddr.conf", "w");
		fclose(fp);

		sprintf(command, "iptables -t mangle -D PREROUTING -i eth1 -p TCP ! --syn -d ! %d.%d.%d.%d --dport 25 -j MARK --set-mark 4",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);

		sprintf(command, "iptables -D FORWARD -i eth1 -o eth0 -p TCP ! --syn -d ! %d.%d.%d.%d --dport 25 -j QUEUE",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);
	}

	return 0;
}

int setids_mscript(int act)
{
	FILE *fp;
	//char temp[10];
	char command[120];
	ACONFIG *ACONF;
	#if ARM_MIPS
		ACONF = &FlashACONF;
  		read_Aconfig(ACONF);
	#else
		ACONF = (ACONFIG *)OFFSET;
	#endif
	close(2);

	if(act)
	{
		fp = fopen("/var/config/ipq/mscript.conf", "w");
		if(fp == NULL)
		{
			return 0;
		}
		fprintf(fp, "1");
		fclose(fp);

		if((ACONF->ids.flag[1] & 0x08) != 0x08)
		{
			sprintf(command, "iptables -t mangle -A PREROUTING -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport 80 -j MARK --set-mark 3",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host);
			system(command);

			sprintf(command, "iptables -A FORWARD -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport 80 -j QUEUE",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host);
			system(command);

			if(ACONF->ids.mscript_proxy)
			{
				sprintf(command, "iptables -t mangle -A PREROUTING -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport %d -j MARK --set-mark 3",
					ACONF->local.rhip[0],
					ACONF->local.rhip[1],
					ACONF->local.rhip[2],
					ACONF->local.dmz_host,
					ACONF->ids.mscript_proxy);
				system(command);

				sprintf(command, "iptables -A FORWARD -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport %d -j QUEUE",
					ACONF->local.rhip[0],
					ACONF->local.rhip[1],
					ACONF->local.rhip[2],
					ACONF->local.dmz_host,
					ACONF->ids.mscript_proxy);
				system(command);
			}
		}

		sprintf(command, "iptables -t mangle -A PREROUTING -i eth1 -p tcp ! --syn -d ! %d.%d.%d.%d --sport 80 -j MARK --set-mark 5",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);

		sprintf(command, "iptables -A FORWARD -i eth1 -o eth0 -p tcp ! --syn -d ! %d.%d.%d.%d --sport 80 -j QUEUE",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);

		if(ACONF->ids.mscript_proxy)
		{
			sprintf(command, "iptables -t mangle -A PREROUTING -i eth1 -p TCP ! --syn -d ! %d.%d.%d.%d --sport %d -j MARK --set-mark 5",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host,
				ACONF->ids.mscript_proxy);
			system(command);

			sprintf(command, "iptables -A FORWARD -i eth1 -o eth0 -p TCP ! --syn -d ! %d.%d.%d.%d --sport %d -j QUEUE",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host,
				ACONF->ids.mscript_proxy);
			system(command);
		}
	}
	else
	{
		fp = fopen("/var/config/ipq/mscript.conf", "w");
		if(fp == NULL)
		{
			return 0;
		}
		fprintf(fp, "0");
		fclose(fp);

		if((ACONF->ids.flag[1] & 0x08) != 0x08)
		{
			sprintf(command, "iptables -t mangle -D PREROUTING -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport 80 -j MARK --set-mark 3",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host);
			system(command);

			sprintf(command, "iptables -D FORWARD -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport 80 -j QUEUE",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host);
			system(command);

			if(ACONF->ids.mscript_proxy)
			{
				sprintf(command, "iptables -t mangle -D PREROUTING -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport %d -j MARK --set-mark 3",
					ACONF->local.rhip[0],
					ACONF->local.rhip[1],
					ACONF->local.rhip[2],
					ACONF->local.dmz_host,
					ACONF->ids.mscript_proxy);
				system(command);

				sprintf(command, "iptables -D FORWARD -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport %d -j QUEUE",
					ACONF->local.rhip[0],
					ACONF->local.rhip[1],
					ACONF->local.rhip[2],
					ACONF->local.dmz_host,
					ACONF->ids.mscript_proxy);
				system(command);
			}
		}

		sprintf(command, "iptables -t mangle -D PREROUTING -i eth1 -p tcp ! --syn -d ! %d.%d.%d.%d --sport 80 -j MARK --set-mark 5",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);

		sprintf(command, "iptables -D FORWARD -i eth1 -o eth0 -p tcp ! --syn -d ! %d.%d.%d.%d --sport 80 -j QUEUE",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);

		if(ACONF->ids.mscript_proxy)
		{
			sprintf(command, "iptables -t mangle -D PREROUTING -i eth1 -p TCP ! --syn -d ! %d.%d.%d.%d --sport %d -j MARK --set-mark 5",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host,
				ACONF->ids.mscript_proxy);
			system(command);

			sprintf(command, "iptables -D FORWARD -i eth1 -o eth0 -p TCP ! --syn -d ! %d.%d.%d.%d --sport %d -j QUEUE",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host,
				ACONF->ids.mscript_proxy);
			system(command);
		}
	}

	return 0;
}

int add_maddr(ACONFIG *src, char *mail)
{
	int i = 0;

	while(src->ids.mailblock[i].string[0] != 0)
		i++;

	if(i < 100)
		strcpy(src->ids.mailblock[i].string, mail);
	else
		return 0;

	return 1;
}

int del_maddr(ACONFIG *src, int num)
{
	int i;

	num--;
	if(num < 0 && num > 100)
		return 0;

	if(src->ids.mailblock[num].string[0] != 0)
		src->ids.mailblock[num].string[0] = 0;
	else
		return 0;

	i = num + 1;
	if(i == 100)
		return 1;
	while(src->ids.mailblock[i].string[0] != 0)
	{
		strcpy(src->ids.mailblock[i - 1].string, src->ids.mailblock[i].string);
		i++;
		if(i == 100)
		{
			src->ids.mailblock[i - 1].string[0] = 0;
			return 1;
		}
	}
	src->ids.mailblock[i - 1].string[0] = 0;

	return 1;
}

int setids(int act)
{
	ACONFIG *a;
	#if ARM_MIPS
		a = &FlashACONF;
  		read_Aconfig(a);
	#else
		a = (ACONFIG *)OFFSET;
	#endif
	close(2);

	if(act)
	{
		if((a->ids.flag[0]&0x01)==0x01)
		{
			//printf("1 - flag[0]:0x01\n");
			setids_snork(1);
		}
		if((a->ids.flag[0]&0x02)==0x02)
		{
			//printf("1 - flag[0]:0x02\n");
			setids_smurf(1);
		}
		//if((a->ids.flag[0]&0x04)==0x04)
		//	;
		if((a->ids.flag[0]&0x08)==0x08)
		{
			//printf("1 - flag[0]:0x08\n");
			setids_psd(1);
		}
		if((a->ids.flag[0]&0x10)==0x10)
		{
			//printf("1 - flag[0]:0x10\n");
			setids_udpbomb(1);
		}
		if((a->ids.flag[0]&0x20)==0x20)
		{
			//printf("1 - flag[0]:0x20\n");
			setids_synf(1);
		}
		if((a->ids.flag[0]&0x40)==0x40)
		{
			//printf("1 - flag[0]:0x40\n");
			setids_fraggle(1);
		}
		if((a->ids.flag[0]&0x80)==0x80)
		{
			//printf("1 - flag[0]:0x80\n");
			setids_land(1);
		}
		if((a->ids.flag[1]&0x01)==0x01)
		{
			//printf("1 - flag[1]:0x01\n");
			setids_icmpun(1);
		}
		if((a->ids.flag[1]&0x02)==0x02)
		{
			//printf("1 - flag[1]:0x02\n");
			setids_pingf(1);
		}
		// --- DNS Scan has its own menu, do not set it ---
		if((a->ids.flag[1]&0x04)==0x04)	// DNS Scan
			setids_dns(1);
		if((a->ids.flag[1]&0x08)==0x08)	// http url block
			setids_urlblock(1);
		// --- Malicious Script has its own menu, do not set it ---
		if((a->ids.flag[1]&0x10)==0x10)	// Malicious Script
			setids_mscript(1);
		if((a->ids.flag[1]&0x20)==0x20)	// Virus
			setids_virusscan(1);
		if(((a->ids.flag[1]&0x40)==0x40)  || ((a->ids.flag[1]&0x80)==0x80) )
			setids_mailblock(1);
		//if((a->ids.flag[1]&0x40)==0x40)	// Mail Bomb - Address Blocking
		//	setids_mailblock(1);
		//if((a->ids.flag[1]&0x80)==0x80)		// Mail Bomb - total number
			;
	}
	else
	{
		// Closing already opened items.
		// If we just close all items but doesn't check that had been opened or not,
		// it will cause some problems like "fault-common.c 242".
		if((a->ids.flag[0]&0x01)==0x01)		// Snork
		{
			//printf("0 - flag[0]:0x01\n");
			setids_snork(0);
		}
		if((a->ids.flag[0]&0x02)==0x02)		// Smurf
		{
			//printf("0 - flag[0]:0x02\n");
			setids_smurf(0);
		}
		//if((a->ids.flag[0]&0x04)==0x04)	// Nothing
		//	;
		if((a->ids.flag[0]&0x08)==0x08)		// Port Scan Detection
		{
			//printf("0 - flag[0]:0x08\n");
			setids_psd(0);
		}
		if((a->ids.flag[0]&0x10)==0x10)		// UDP Bomb
		{
			//printf("0 - flag[0]:0x10\n");
			setids_udpbomb(0);
		}
		if((a->ids.flag[0]&0x20)==0x20)		// SYN Flooding
		{
			//printf("0 - flag[0]:0x20\n");
			setids_synf(0);
		}
		if((a->ids.flag[0]&0x40)==0x40)		// Fraggle
		{
			//printf("0 - flag[0]:0x40\n");
			setids_fraggle(0);
		}
		if((a->ids.flag[0]&0x80)==0x80)		// Land Attack
		{
			//printf("0 - flag[0]:0x80\n");
			setids_land(0);
		}
		if((a->ids.flag[1]&0x01)==0x01)		// ICMP Unreachable
		{
			//printf("0 - flag[1]:0x01\n");
			setids_icmpun(0);
		}
		if((a->ids.flag[1]&0x02)==0x02)		// Ping Flooding (ICMP Echo Flooding)
		{
			//printf("0 - flag[1]:0x02\n");
			setids_pingf(0);
		}
		// --- DNS Scan has its own menu, do not set it ---
		if((a->ids.flag[1]&0x04)==0x04)	// DNS Scan
			setids_dns(0);
		if((a->ids.flag[1]&0x08)==0x08)	// http url block
			setids_urlblock(0);
		// --- Malicious Script has its own menu, do not set it ---
		if((a->ids.flag[1]&0x10)==0x10)	// Malicious Script
			setids_mscript(0);
		if((a->ids.flag[1]&0x20)==0x20)		// Virus
			setids_virusscan(0);
		if(((a->ids.flag[1]&0x40)==0x40)  || ((a->ids.flag[1]&0x80)==0x80) )
			setids_mailblock(0);
		// --- Mail Bomb has its own menu, do not set it ---
		//if((a->ids.flag[1]&0x40)==0x40)	// Mail Bomb - Address Blocking
		//	setids_mailblock(0);
		//if((a->ids.flag[1]&0x80)==0x80)		// Mail Bomb - total number
	}

	return 0;
}
*/
/*---set Send ---*/
/*
int setsend(int act)
{
	int i;
	char command[80];
	FILE *alert_table, *mail_list, *send_pid;
	ACONFIG * ACONF;
	#if ARM_MIPS
		ACONF = &FlashACONF;
  		read_Aconfig(ACONF);
	#else
		ACONF = (ACONFIG *)OFFSET;
	#endif

	close(2);
	if(act ==1)
	{
		for(i=0;i<5;i++)
		{
			if((mail_list=fopen(MAIL_LIST_FILE,"w"))!=NULL)
				break;
			sleep(1);
		}
		if(mail_list==NULL)
			return 0;//error to open file
		if(ACONF->mailalert.mail_from[0]!= '\0')
			fprintf(mail_list,"%s\n",ACONF->mailalert.mail_from);
		if(ACONF->mailalert.list[0].mail_to[0] != '\0')
			fprintf(mail_list,"%s\n",ACONF->mailalert.list[0].mail_to);
		if(ACONF->mailalert.list[1].mail_to[0] != '\0')
			fprintf(mail_list,"%s\n",ACONF->mailalert.list[1].mail_to);
		if(ACONF->mailalert.list[2].mail_to[0] != '\0')
			fprintf(mail_list,"%s\n",ACONF->mailalert.list[2].mail_to);
		fclose(mail_list);

		for(i=0;i<5;i++)
		{
			if((alert_table=fopen(ALERT_TABLE_FILE,"w"))!=NULL)
				break;
			sleep(1);
		}
		if(alert_table==NULL)
			return 0;//error to open file
		for(i=0;i<20;i++)
		{
			if(ACONF->mailalert.alert_table[i].logname[0]==0)
				continue;//no data
			fprintf(alert_table,"%d %d %s\n",
			ACONF->mailalert.alert_table[i].lognum,
			ACONF->mailalert.alert_table[i].emergency,
			ACONF->mailalert.alert_table[i].logname);
		}
		fclose(alert_table);
		system("send");
	}
	else
	{
		printf("set send off\n");
		remove(MAIL_LIST_FILE);
		remove(ALERT_TABLE_FILE);
		for(i=0;i<5;i++)
		{
			if((send_pid=fopen("/var/run/send","r"))!=NULL)
				break;
			sleep(1);
		}
		if(send_pid==NULL)
		{
			printf("can't open file /var/run/send\n");
			return 0;//error to open file
		}
		fgets(command,80,send_pid);
		//command[strlen(command)-1]=0;
		i=atoi(command);
		sprintf(command,"kill %d",i);
		printf("%s\n",command);
		system(command);
	}
	return 0;
}
*/
/* *************** */
/* IPsec  settings */
/* *************** */

// *************** *
// IPsec setManual *
// *************** *
/*
int do_command(char *cmd, int mode)
{
	if( mode )
	{
		printf("%s\n", cmd);
		return 0;
	}
//printf("%s\n", cmd);
	return system(cmd);
}

int
setmanual(int index_of_tunnel, int action)
{

	char command[80];
	char temp[6];
	char dir[25];
	char spi[6];
	char local_ip[16];
	char remote_ip[16];
	char auth[8];
	char authkey[43];
	char enckey[51];
	char gateway[16];
	char local_net[16];
	char l_mask[16];
	char remote_net[16];
	char r_mask[16];
	int debug,i,j;
	BYTE encap_protocol;
	ACONFIG *a;
	FILE *fp_ip;
	ip_info_struct ife;
	#if ARM_MIPS
		a = &FlashACONF;
  		read_Aconfig(a);
	#else
		a = (ACONFIG *)OFFSET;
	#endif
	strcpy(dir,"/usr/local/lib/ipsec/");
	//--get spi (0x100~0xfff)
	sprintf(temp,"%lx",a->ipsec.Tunnel_Info[index_of_tunnel].key_method.manual.local_spi);
	strcpy(spi,"0x000");
	for(i=strlen(temp)-1,j=0;i>=0;i--,j++)
	{
		spi[4-j]=temp[i];
	}

	//get local wan ip
	fp_ip = fopen(IP_INFO_FILE,"r");
	fgets(local_ip,16,fp_ip);

	//get remote ip
	sprintf(remote_ip,"%d.%d.%d.%d",
			a->ipsec.Tunnel_Info[index_of_tunnel].remote_gateway[0],
			a->ipsec.Tunnel_Info[index_of_tunnel].remote_gateway[1],
			a->ipsec.Tunnel_Info[index_of_tunnel].remote_gateway[2],
			a->ipsec.Tunnel_Info[index_of_tunnel].remote_gateway[3]);
	//get auth & auth key
	if(a->ipsec.Tunnel_Info[index_of_tunnel].key_method.manual.auth_algorithm==0)
	{
		strcpy(auth,"");
		strcpy(authkey,"");
	}
	else if(a->ipsec.Tunnel_Info[index_of_tunnel].key_method.manual.auth_algorithm==1)//MD5
	{
		strcpy(auth,"md5-96");
		strcpy(authkey,"0x");
		memcpy(authkey+2,a->ipsec.Tunnel_Info[index_of_tunnel].key_method.manual.auth_key,32);
		authkey[34]=0;
	}
	else
	{
		strcpy(auth,"sha1-96");
		strcpy(authkey,"0x");
		memcpy(authkey+2,a->ipsec.Tunnel_Info[index_of_tunnel].key_method.manual.auth_key,40);
		authkey[42]=0;
	}

	//get enckey
	strcpy(enckey,"0x");
	memcpy(enckey+2,a->ipsec.Tunnel_Info[index_of_tunnel].key_method.manual.encry_num[0].encryption_key,48);
	enckey[50]=0;
	//get GW
	findGW(&ife);
	sprintf(gateway,"%d.%d.%d.%d",ife.gw[0],ife.gw[1],ife.gw[2],ife.gw[3]);
	//get local subnet
	if(a->ipsec.Tunnel_Info[index_of_tunnel].local_subnet[0]==0 &&
	   a->ipsec.Tunnel_Info[index_of_tunnel].local_subnet[1]==0 &&
	   a->ipsec.Tunnel_Info[index_of_tunnel].local_subnet[2]==0 &&
	   a->ipsec.Tunnel_Info[index_of_tunnel].local_subnet[3]==0 )
		strcpy(local_net,"");
	else
		sprintf(local_net,"%d.%d.%d.%d",a->ipsec.Tunnel_Info[index_of_tunnel].local_subnet[0],
						a->ipsec.Tunnel_Info[index_of_tunnel].local_subnet[1],
						a->ipsec.Tunnel_Info[index_of_tunnel].local_subnet[2],
						a->ipsec.Tunnel_Info[index_of_tunnel].local_subnet[3]);
	//get local netmask
	if(a->ipsec.Tunnel_Info[index_of_tunnel].local_netmask[0]==0 &&
	   a->ipsec.Tunnel_Info[index_of_tunnel].local_netmask[1]==0 &&
	   a->ipsec.Tunnel_Info[index_of_tunnel].local_netmask[2]==0 &&
	   a->ipsec.Tunnel_Info[index_of_tunnel].local_netmask[3]==0 )
	   	strcpy(l_mask,"");
	else
		sprintf(l_mask,"%d.%d.%d.%d",a->ipsec.Tunnel_Info[index_of_tunnel].local_netmask[0],
						a->ipsec.Tunnel_Info[index_of_tunnel].local_netmask[1],
						a->ipsec.Tunnel_Info[index_of_tunnel].local_netmask[2],
						a->ipsec.Tunnel_Info[index_of_tunnel].local_netmask[3]);
	//get remote subnet
	if(a->ipsec.Tunnel_Info[index_of_tunnel].remote_subnet[0]==0 &&
	   a->ipsec.Tunnel_Info[index_of_tunnel].remote_subnet[1]==0 &&
	   a->ipsec.Tunnel_Info[index_of_tunnel].remote_subnet[2]==0 &&
	   a->ipsec.Tunnel_Info[index_of_tunnel].remote_subnet[3]==0 )
	   	strcpy(remote_net,"");
	else
		sprintf(remote_net,"%d.%d.%d.%d",a->ipsec.Tunnel_Info[index_of_tunnel].remote_subnet[0],
						a->ipsec.Tunnel_Info[index_of_tunnel].remote_subnet[1],
						a->ipsec.Tunnel_Info[index_of_tunnel].remote_subnet[2],
						a->ipsec.Tunnel_Info[index_of_tunnel].remote_subnet[3]);
	//get remote netmask
	if(a->ipsec.Tunnel_Info[index_of_tunnel].remote_netmask[0]==0 &&
	   a->ipsec.Tunnel_Info[index_of_tunnel].remote_netmask[1]==0 &&
	   a->ipsec.Tunnel_Info[index_of_tunnel].remote_netmask[2]==0 &&
	   a->ipsec.Tunnel_Info[index_of_tunnel].remote_netmask[3]==0 )
	   	strcpy(r_mask,"");
	else
		sprintf(r_mask,"%d.%d.%d.%d",a->ipsec.Tunnel_Info[index_of_tunnel].remote_netmask[0],
						a->ipsec.Tunnel_Info[index_of_tunnel].remote_netmask[1],
						a->ipsec.Tunnel_Info[index_of_tunnel].remote_netmask[2],
						a->ipsec.Tunnel_Info[index_of_tunnel].remote_netmask[3]);
	//get encap_protocol
	encap_protocol=a->ipsec.Tunnel_Info[index_of_tunnel].key_method.manual.encap_protocol;

	//char spi[] = "0x600";
	//char local_ip[] =  "140.116.247.37";
	//char remote_ip[] =  "140.116.247.9";
	//char auth[] = "sha1-96";
	//char authkey[] = "0x1111222233334444555566667777888899990000";
	//char enckey[] = "0x111122223333444455556666777788889999000011112222";
	//char gateway[] = "140.116.247.253";
	//char local_net[] ="192.168.37.0";
	//char l_mask[] = "24";
	//char remote_net[] = "192.168.9.0";
	//char r_mask[] = "24";



	 // unsigned char encap_protocol
	 //
	 // 0x01	 AH_TUNNEL
	 // 0x02  AH_TRANSPORT
	 // 0x03  ESP_TUNNEL
	 // 0x04  ESP_TRANSPORT
	 // 0x05  ESP_TUNNEL_WITH_AUTH
	 // 0x06  ESP_TRANSPORT_WITH_AUTH


	//unsigned char encap_protocol = 0x06;

	debug=0;

//printf(" %x \n\n", encap_protocol);



#ifdef DEBUG_IPSEC_MANUAL
	debug = 1;;
#endif

	if( action )	// ipsec manual --up tunnel_i
	{
		if( encap_protocol == 0x01 ){		// AH_TUNNEL

			// outbound
			sprintf(command, "%sspi --af inet --said tun%s@%s --ip4 --src %s --dst %s", dir, spi, remote_ip, local_ip, remote_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --said ah%s@%s --ah hmac-%s --src %s --authkey %s", dir, spi, remote_ip, auth, local_ip, authkey);
			do_command(command,debug);
			sprintf(command, "%sspigrp --said tun%s@%s ah%s@%s", dir, spi, remote_ip, spi, remote_ip);
			do_command(command,debug);

			// inbound
			sprintf(command, "%sspi --af inet --said tun%s@%s --ip4 --src %s --dst %s", dir, spi, local_ip, remote_ip, local_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --said ah%s@%s --ah hmac-%s --src %s --authkey %s", dir, spi, local_ip, auth, remote_ip, authkey);
			do_command(command,debug);
			sprintf(command, "%sspigrp --said tun%s@%s ah%s@%s", dir, spi, local_ip, spi, local_ip);
			do_command(command,debug);
			// eroute
			if( strlen(local_net)==0 && strlen(remote_net) != 0)
				sprintf(command,"%seroute --eraf inet --replace --src %s/32 --dst %s/%s --said tun%s@%s", dir,local_ip, remote_net, r_mask,spi,  remote_ip);
			else if(strlen(local_net) !=0 && strlen(remote_net) ==0  )
				sprintf(command,"%seroute --eraf inet --replace --src %s/%s --dst %s/32 --said tun%s@%s",dir, local_net, l_mask, remote_ip,  spi, remote_ip);
			else
				sprintf(command,"%seroute --eraf inet --replace --src %s/%s --dst %s/%s --said tun%s@%s",dir, local_net, l_mask, remote_net, r_mask, spi, remote_ip);
			do_command(command,debug);
		}
		else if( encap_protocol == 0x02){	// AH_TRANSPORT

			// outbound
			sprintf(command,"%sspi --af inet --said ah%s@%s --ah hmac-%s --src %s --authkey %s", dir, spi, remote_ip, auth, local_ip, authkey);
			do_command(command,debug);
			// inbound
			sprintf(command,"%sspi --af inet --said ah%s@%s --ah hmac-%s --src %s --authkey %s", dir, spi, local_ip, auth, remote_ip, authkey);
			do_command(command,debug);
			// eroute
			sprintf(command,"%seroute --eraf inet --replace  --src %s/32 --dst %s/32 --said ah%s@%s",dir, local_ip, remote_ip, spi, remote_ip);
			do_command(command,debug);

		}
		else if( encap_protocol == 0x03 ){	// ESP_TUNNEL


			// outbound
			sprintf(command, "%sspi --af inet --said tun%s@%s --ip4 --src %s --dst %s", dir, spi, remote_ip,  local_ip, remote_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --said esp%s@%s --esp 3des --src %s --enckey %s", dir, spi, remote_ip, local_ip, enckey);
			do_command(command,debug);
			sprintf(command, "%sspigrp --said tun%s@%s esp%s@%s", dir, spi, remote_ip, spi, remote_ip);
			do_command(command,debug);

			// inbound
			sprintf(command, "%sspi --af inet --said tun%s@%s --ip4 --src %s --dst %s", dir, spi, local_ip,  remote_ip, local_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --said esp%s@%s --esp 3des --src %s --enckey %s", dir, spi, local_ip, remote_ip, enckey);
			do_command(command,debug);
			sprintf(command, "%sspigrp --said tun%s@%s esp%s@%s", dir, spi, local_ip, spi, local_ip);
			do_command(command,debug);

			// eroute
			if( strlen(local_net)==0 && strlen(remote_net) != 0)
				sprintf(command,"%seroute --eraf inet --replace --src %s/32 --dst %s/%s --said tun%s@%s", dir,local_ip, remote_net, r_mask,spi,  remote_ip);
			else if(strlen(local_net) !=0 && strlen(remote_net) ==0  )
				sprintf(command,"%seroute --eraf inet --replace --src %s/%s --dst %s/32 --said tun%s@%s",dir, local_net, l_mask, remote_ip,  spi, remote_ip);
			else
				sprintf(command,"%seroute --eraf inet --replace --src %s/%s --dst %s/%s --said tun%s@%s",dir, local_net, l_mask, remote_net, r_mask, spi, remote_ip);
			do_command(command,debug);
		}
		else if( encap_protocol == 0x04){	// ESP_TRANSPORT

			// outbound
			sprintf(command, "%sspi --af inet --said esp%s@%s --esp 3des --src %s --enckey %s", dir, spi, remote_ip, local_ip, enckey);
			do_command(command,debug);
			// inbound
			sprintf(command, "%sspi --af inet --said esp%s@%s --esp 3des --src %s --enckey %s", dir, spi, local_ip, remote_ip, enckey);
			do_command(command,debug);
			// eroute
			sprintf(command, "%seroute --eraf inet --replace --src %s/32 --dst %s/32 --said esp%s@%s", dir, local_ip, remote_ip, spi, remote_ip);
			do_command(command,debug);

		}
		else if( encap_protocol == 0x05){//ESP_TUNNEL_WITH_AUTH


			// outbound
			sprintf(command, "%sspi --af inet --said tun%s@%s --ip4 --src %s --dst %s", dir, spi, remote_ip, local_ip, remote_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --said esp%s@%s --esp 3des-%s --src %s --authkey %s --enckey %s", dir, spi, remote_ip, auth, local_ip, authkey, enckey);
			do_command(command,debug);
			sprintf(command, "%sspigrp --said tun%s@%s esp%s@%s", dir, spi, remote_ip, spi, remote_ip);
			do_command(command,debug);

			// inbound
			sprintf(command, "%sspi --af inet --said tun%s@%s --ip4 --src %s --dst %s", dir, spi, local_ip, remote_ip, local_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --said esp%s@%s --esp 3des-%s --src %s --authkey %s --enckey %s", dir, spi, local_ip, auth, remote_ip, authkey, enckey);
			do_command(command,debug);
			sprintf(command, "%sspigrp --said tun%s@%s esp%s@%s", dir, spi, local_ip, spi, local_ip);
			do_command(command,debug);

			//eroute
			if( strlen(local_net)==0 && strlen(remote_net) != 0)
				sprintf(command,"%seroute --eraf inet --replace --src %s/32 --dst %s/%s --said tun%s@%s", dir,local_ip, remote_net, r_mask,spi,  remote_ip);
			else if(strlen(local_net) !=0 && strlen(remote_net) ==0  )
				sprintf(command,"%seroute --eraf inet --replace --src %s/%s --dst %s/32 --said tun%s@%s",dir, local_net, l_mask, remote_ip,  spi, remote_ip);
			else
				sprintf(command,"%seroute --eraf inet --replace --src %s/%s --dst %s/%s --said tun%s@%s",dir, local_net, l_mask, remote_net, r_mask, spi, remote_ip);
			do_command(command,debug);
		}
		else{				//ESP_TRANSPORT_WITH_AUTH

			// outbound
			sprintf(command, "%sspi --af inet --said esp%s@%s --esp 3des-%s --src %s --authkey %s --enckey %s", dir, spi, remote_ip, auth, local_ip, authkey, enckey);
			do_command(command,debug);
			// inbound
			sprintf(command, "%sspi --af inet --said esp%s@%s --esp 3des-%s --src %s --authkey %s --enckey %s", dir, spi, local_ip, auth, remote_ip, authkey, enckey);
			do_command(command,debug);
			// eroute
			sprintf(command, "%seroute --replace --src %s/32 --dst %s/32 --said esp%s@%s", dir, local_ip, remote_ip, spi, remote_ip);
			do_command(command,debug);
		}

		//---------------------------
		//  add a routing table entry
		//---------------------------
		if( encap_protocol == 0x02 ||  encap_protocol == 0x04 ||  encap_protocol == 0x06 )	// all transport modes
		{
			sprintf(command,"route add -host %s/32 dev ipsec0 gw %s", remote_ip, gateway);
		}
		else{	// all tunnel modes
			if(  strlen(remote_net) == 0 )
				sprintf(command,"route add -host %s/32 dev ipsec0 gw %s", remote_ip, gateway);
			else
				sprintf(command,"route add -net %s/%s dev ipsec0 gw %s", remote_net,r_mask, gateway);
		}
		do_command(command, debug);

	}
	else		// ipsec_manual --down tunnel_i
	{


		if( encap_protocol  == 0x01 || encap_protocol == 0x03 || encap_protocol == 0x05 ) 	// all tunnel modes
		{

			if( strlen(local_net)==0 && strlen(remote_net) != 0)
				sprintf(command,"%seroute --del --eraf inet --src %s/32 --dst %s/%s", dir, local_ip, remote_net, r_mask);
			else if(strlen(local_net) !=0 && strlen(remote_net) ==0 )
				sprintf(command,"%seroute --del --eraf inet --src %s/%s --dst %s/32", dir, local_net,l_mask, remote_ip);
			else
				sprintf(command,"%seroute --del --eraf inet --src %s/%s --dst %s/%s", dir, local_net,l_mask, remote_net, r_mask);
			do_command(command,debug);
			sprintf(command,"%sspi --af inet --del --said tun%s@%s", dir, spi, remote_ip);
			do_command(command,debug);
			sprintf(command,"%sspi --af inet --del --said tun%s@%s", dir, spi, local_ip);
			do_command(command,debug);
		}
		else if( encap_protocol == 0x02){	// AH_TRANSPORT
			sprintf(command, "%seroute --del --eraf inet --src %s/32 --dst %s/32", dir, local_ip, remote_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --del --said ah%s@%s", dir, spi, remote_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --del --said ah%s@%s", dir, spi, local_ip);
			do_command(command,debug);

			sprintf(command, "route del -host %s", remote_ip);
			do_command(command,debug);
		}
		else{	// ESP_TRANSPORT or ESP_TRANSPORT_WITH_AUTH
			sprintf(command, "%seroute --del --eraf inet --src %s/32 --dst %s/32", dir, local_ip, remote_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --del --said esp%s@%s", dir, spi, remote_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --del --said esp%s@%s", dir, spi, local_ip);
			do_command(command,debug);

		}
		//---------------------------
		// delete a routing table entry
		//---------------------------
		if( encap_protocol == 0x02 ||  encap_protocol == 0x04 ||  encap_protocol == 0x06 )	// all transport modes
		{
			sprintf(command,"route del -host %s/32 dev ipsec0 gw %s", remote_ip, gateway);
		}
		else{	// all tunnel modes
			if(  strlen(remote_net) == 0 )
				sprintf(command,"route del -host %s/32 dev ipsec0 gw %s", remote_ip, gateway);
			else
				sprintf(command,"route del -net %s/%s dev ipsec0 gw %s", remote_net,r_mask, gateway);
		}
		do_command(command, debug);

	}

}

//----end set manual ---by wnlee
//----by succ
void setsecrets(int switchs)
{
	int i,j,ip_value;
	FILE *fp, *fp_ip;
	BYTE ip_now[4];
	char ip_temp[20],ip_num[4];
	char *tp;
	ACONFIG * ACONF;
	#if ARM_MIPS
		ACONF = &FlashACONF;
  		read_Aconfig(ACONF);
	#else
		ACONF = (ACONFIG *)OFFSET;
	#endif

	//get now ip
	fp_ip = fopen(IP_INFO_FILE,"r");
	fgets(ip_temp,20,fp_ip);
	tp=ip_temp;
	for(j=0;j<4;j++)
	{
		i=0;
		while(*tp!='.' && *tp!= '\0')
		{
			ip_num[i]=*tp;
			i++;
			tp++;
		}
		ip_num[i]=0;
		ip_value=atoi(ip_num);
		ip_now[j]=ip_value;
	}

  if(switchs == 1)
  {
    if(ACONF->ipsec.Tunnel_Info[i].type_of_key_method == 0 &&  //IKE
       ACONF->ipsec.Tunnel_Info[i].tunnel_name == NULL)               //Legal tunnel
    {
      fp = fopen("/var/ipsec.secrets","a+");
      for(i=0;i<MAX_NUMBER_OF_TUNNELS;i++)
      {
        fprintf(fp,"%d.%d.%d.%d %d.%d.%d.%d: PSK \"%s\"\n",
                    ip_now[0],
    	            ip_now[1],
  	            ip_now[2],
  	            ip_now[3],
        	    ACONF->ipsec.Tunnel_Info[i].remote_gateway[0],
    	            ACONF->ipsec.Tunnel_Info[i].remote_gateway[1],
  	            ACONF->ipsec.Tunnel_Info[i].remote_gateway[2],
  	            ACONF->ipsec.Tunnel_Info[i].remote_gateway[3],
  	            ACONF->ipsec.Tunnel_Info[i].key_method.ike.preshared_key);
      }
      fclose(fp);
    }
  }
  else
  {
    // *********************** *
    // remove the secrets file *
    // *********************** *
    remove("/var/ipsec.secrets");
  }
}

// ******* *
// set ike *
// ******* *
void setike(int index,int switchs)
{
	int i,j,ip_value;
	char temp[300];
	char time[30];
	FILE *fp, *fp_ip;
	BYTE ip_now[4];
	char ip_temp[20],ip_num[4];
	char *tp;
	ACONFIG * ACONF;
	#if ARM_MIPS
		ACONF = &FlashACONF;
  		read_Aconfig(ACONF);
	#else
		ACONF = (ACONFIG *)OFFSET;
	#endif

	//get now ip
	fp_ip = fopen(IP_INFO_FILE,"r");
	fgets(ip_temp,20,fp_ip);
	tp=ip_temp;
	for(j=0;j<4;j++)
	{
		i=0;
		while(*tp!='.' && *tp!= '\0')
		{
			ip_num[i]=*tp;
			i++;
			tp++;
		}
		ip_num[i]=0;
		ip_value=atoi(ip_num);
		ip_now[j]=ip_value;
	}

  if(switchs == 1) //ON
  {
    setsecrets(1);

    // ****************** *
    // add ike connection *
    // ****************** *
    if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.mode == 0) //transport mode
    {
      sprintf(temp,"/bin/whack --name %s --host %d.%d.%d.%d --to --host %d.%d.%d.%d",
                   ACONF->ipsec.Tunnel_Info[i].tunnel_name,
                   ip_now[0],
                   ip_now[1],
                   ip_now[2],
                   ip_now[3],
                   ACONF->ipsec.Tunnel_Info[i].remote_gateway[0],
                   ACONF->ipsec.Tunnel_Info[i].remote_gateway[1],
                   ACONF->ipsec.Tunnel_Info[i].remote_gateway[2],
                   ACONF->ipsec.Tunnel_Info[i].remote_gateway[3]);

      if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.encap_protocol == 0) //ESP only
      {
        strcat(temp," --encrypt");
      }
      else if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.encap_protocol == 1) //AH only
      {
        strcat(temp," --authentication");
      }
      else //ESP and AH
      {
        strcat(temp," --encrypt --authentication");
      }

      if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.pfs == 1) //pfs enable
      {
        strcat(temp," --pfs");
      }

      if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.ikelifetime != 0)
      {
      	sprintf(time," --ikelifetime %d",ACONF->ipsec.Tunnel_Info[i].key_method.ike.ikelifetime);
        strcat(temp,time);
      }

      if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.ipseclifetime != 0)
      {
      	sprintf(time," --ipseclifetime %d",ACONF->ipsec.Tunnel_Info[i].key_method.ike.ikelifetime);
        strcat(temp,time);
      }

      strcat(temp," --delete");

    }
    else  //tunnel mode
    {
      sprintf(temp,"/bin/whack --name %s --host %d.%d.%d.%d --client %d.%d.%d.%d/%d --to --host %d.%d.%d.%d --client %d.%d.%d.%d/%d",
                   ACONF->ipsec.Tunnel_Info[i].tunnel_name,
                   ip_now[0],
                   ip_now[1],
		   ip_now[2],
                   ip_now[3],
                   ACONF->ipsec.Tunnel_Info[i].local_subnet[0],
                   ACONF->ipsec.Tunnel_Info[i].local_subnet[1],
                   ACONF->ipsec.Tunnel_Info[i].local_subnet[2],
                   ACONF->ipsec.Tunnel_Info[i].local_subnet[3],
                   ACONF->ipsec.Tunnel_Info[i].local_netmask[0],
                   ACONF->ipsec.Tunnel_Info[i].local_netmask[1],
                   ACONF->ipsec.Tunnel_Info[i].local_netmask[2],
                   ACONF->ipsec.Tunnel_Info[i].local_netmask[3],
                   ACONF->ipsec.Tunnel_Info[i].remote_gateway[0],
                   ACONF->ipsec.Tunnel_Info[i].remote_gateway[1],
                   ACONF->ipsec.Tunnel_Info[i].remote_gateway[2],
                   ACONF->ipsec.Tunnel_Info[i].remote_gateway[3],
                   ACONF->ipsec.Tunnel_Info[i].remote_subnet[0],
                   ACONF->ipsec.Tunnel_Info[i].remote_subnet[1],
                   ACONF->ipsec.Tunnel_Info[i].remote_subnet[2],
                   ACONF->ipsec.Tunnel_Info[i].remote_subnet[3],
                   ACONF->ipsec.Tunnel_Info[i].remote_netmask[0],
                   ACONF->ipsec.Tunnel_Info[i].remote_netmask[1],
                   ACONF->ipsec.Tunnel_Info[i].remote_netmask[2],
                   ACONF->ipsec.Tunnel_Info[i].remote_netmask[3] );

      if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.encap_protocol == 0) //ESP only
      {
        strcat(temp," --encrypt");
      }
      else if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.encap_protocol == 1) //AH only
      {
        strcat(temp," --authentication");
      }
      else //ESP and AH
      {
        strcat(temp," --encrypt --authentication");
      }

      if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.pfs == 1) //pfs enable
      {
        strcat(temp," --pfs");
      }

      if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.ikelifetime != 0)
      {
      	sprintf(time," --ikelifetime %d",ACONF->ipsec.Tunnel_Info[i].key_method.ike.ikelifetime);
        strcat(temp,time);
      }

      if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.ipseclifetime != 0)
      {
      	sprintf(time," --ipseclifetime %d",ACONF->ipsec.Tunnel_Info[i].key_method.ike.ikelifetime);
        strcat(temp,time);
      }

      strcat(temp," --delete");
    }
  }
  else
  {
    setsecrets(0);


    // delete ike connection

    sprintf(temp,"/bin/whack --delete --name %s",ACONF->ipsec.Tunnel_Info[i].tunnel_name);
    system(temp);
  }
}
*/
// ********** *
// Set IPSec  *
// ********** *
/*
setipsec(int mode, int switchs)   //mode = -1,reset,_hھindexh@reset
{
  int i;
  FILE *fp;
  char pid[10];
  char temp[80];
  ACONFIG * ACONF;
  #if ARM_MIPS
	ACONF = &FlashACONF;
  	read_Aconfig(ACONF);
  #else
	ACONF = (ACONFIG *)OFFSET;
  #endif

  if(switchs == 1)
  {
    if(ACONF->ipsec.if_enable_ipsec == 1)
    {
      // *********************
      // setup ipsec interface
      // *********************
      if(mode == -1) //OPEN ALL
      {
        system("/usr/local/lib/ipsec/tncfg --attach --virtual ipsec0 --physical eth1");
        sprintf(temp,"ifconfig ipsec0 %d.%d.%d.%d netmask %d.%d.%d.%d",
                     ACONF->local.rhip[0],
                     ACONF->local.rhip[1],
                     ACONF->local.rhip[2],
                     ACONF->local.rhip[3],
                     ACONF->local.rhnm[0],
                     ACONF->local.rhnm[1],
                     ACONF->local.rhnm[2],
                     ACONF->local.rhnm[3]);


        // setup ipsec connections
        for(i = 0;i<MAX_NUMBER_OF_TUNNELS;i++)
        {
      	  if(ACONF->ipsec.Tunnel_Info[i].tunnel_name != NULL)
      	  {
            if(ACONF->ipsec.Tunnel_Info[i].type_of_key_method == 0) //IKE
            {
              // setup ike connection
 	      setike(i,1);
            }
            else if(ACONF->ipsec.Tunnel_Info[i].type_of_key_method == 1)
            {
              // setup manual connection
      	      setmanual(i,1);
            }
          }
        }
      }
      else  //mode != -1
      {
      	if(ACONF->ipsec.Tunnel_Info[mode].tunnel_name != NULL)
      	{
          if(ACONF->ipsec.Tunnel_Info[mode].type_of_key_method == 0) //IKE
          {
            // setup ike connection
 	    setike(mode,1);
          }
          else if(ACONF->ipsec.Tunnel_Info[mode].type_of_key_method == 1)
          {
            // setup manual connection
      	    setmanual(mode,1);
          }
        }
      }

      // open pluto
      system("/bin/pluto --nofork &");
      system("/bin/whack --listen");
    }
    else
    {
      goto stop_ipsec;
    }
  }
  else // close ipsec
  {
stop_ipsec:

    // close pluto

    fp = fopen("/var/run/pluto.pid","w");
    fgets(pid,10,fp);
    fclose(fp);
    sprintf(temp,"kill %s",pid);
    system(temp);


    // shutdowm ipsec connections
    if(mode == -1)
    {
      for(i = 0;i<MAX_NUMBER_OF_TUNNELS;i++)
      {
        if(ACONF->ipsec.Tunnel_Info[i].tunnel_name != NULL)
        {
          if(ACONF->ipsec.Tunnel_Info[i].type_of_key_method == 0) //IKE
          {
 	    setike(i,0);
          }
          else if(ACONF->ipsec.Tunnel_Info[i].type_of_key_method == 1)
          {
      	    setmanual(i,0);
          }
        }
      }

      // shutdown ipsec interface
      system("ifconfig ipsec0 down");
      system("/usr/local/lib/ipsec/tncfg --dttach --virtual ipsec0 --physical eth1");
    }
    else //mode != -1
    {
      if(ACONF->ipsec.Tunnel_Info[mode].tunnel_name != NULL)
      {
        if(ACONF->ipsec.Tunnel_Info[mode].type_of_key_method == 0) //IKE
        {
          setike(mode,0);
        }
        else if(ACONF->ipsec.Tunnel_Info[mode].type_of_key_method == 1)
        {
      	  setmanual(mode,0);
        }
      }
    }
  }
}
*/

/* ********** */
/* set boot   */
/* ********** */

int setboot(int act)
{
	FILE *fd;
	ACONFIG * ACONF;
	
	// 0. --- set global variables and initialization for some procedures
	during_booting = 1;
	set_wanget_result(77);
	
	// 1. --- get ACONF
	#if ARM_MIPS
		ACONF = &FlashACONF;
  		read_Aconfig(ACONF);
	#else
		ACONF = (ACONFIG *)OFFSET;
	#endif
	#ifdef FOR_DEBUG
		printf("-------------------------------------------------------------------------------\n\r");
		printf("ACONF is read OK\n\r");
	#endif
	
	
	// 2. --- close stderr
	close(2);

	// 3. --- create linked file "/var/config/resolv.conf" for "/etc/resolv.conf" ---
	fd = fopen(DNS_INFO_FILE, "w");
	if(fd == NULL)
	{
	  printf("setboot : open resolv.conf failed\n\r");
	  return;	
	}
	fprintf(fd,"domain\n");
	fprintf(fd,"nameserver %d.%d.%d.%d\n",
		ACONF->local.ip[0],
		ACONF->local.ip[1],
		ACONF->local.ip[2],
		ACONF->local.ip[3]            );
	fprintf(fd,"search\n");
	fclose(fd);
	#ifdef FOR_DEBUG
		printf("-------------------------------------------------------------------------------\n\r");
		printf("/var/config/resolv.conf is created OK: DNS: local IP\n\r");
	#endif


	//setpppd(1);
	
	setnat(1);//ok 0824 by km //original position: following dhcpd
		  //it must be invoked before setlan
	
	setlan(1);//ok 0824 by km
	
	//system("amit_httpd&");
	
	setwan(1);//ok 0824 by km
	
	setdhcpd(1);//ok 0824 by km
	
	setsmap(1);//ok 0824
	
	setdmz(1);//ok 0824 by km
	
	setbwping(1);//ok 0824 by km
	
	//setspap(1);
	
	saveIPinfo(ACONF);//ok 0824 by km
	
	//setfirewall(1);//ok 0825 by km

	//if(ACONF->pptp.enable==1) setpptpd(1);
	//system("l2tpd_conf");
	//system("l2tpd");
	//setids(1);
	//setipsec(-1,1);
	//if(ACONF->mailalert.enable==1) setsend(1);
	
	system("ifconfig lo 127.0.0.1");
    
    	#ifdef FOR_DEBUG
    		system("ifconfig");
    	#endif
    	
    	system("monitor 2&");
	
	// 9. --- reset global variables
	during_booting = 0;
	
	return 0;
}


int set_wanget_result(int act)
{
	FILE *fd;
	
	#ifdef FOR_DEBUG
		printf("Set wanget.result %d\n\r",act);
	#endif
	
	switch (act) {
		
		case 77:	//init
		case 0:		//get no
			if ((fd = fopen("/var/run/wanget.result","w")) != NULL)
			{
				fputs("0",fd);
				fclose(fd);
			} else {
				printf("WANget result(%d): Open write file:/var/run/wanget.result fail!\n",act);
			}
			break;
			
		case 1:		//get yes
			if ((fd = fopen("/var/run/wanget.result","w")) != NULL)
			{
				fputs("1",fd);
				fclose(fd);
			} else {
				printf("WANget result(%d): Open write file:/var/run/wanget.result fail!\n",act);
			}
			break;
			
		case 99:	//get yes
			if ((fd = fopen("/var/run/wanget.result","w")) != NULL)
			{
				fputs("99",fd);
				fclose(fd);
			} else {
				printf("WANget result(%d): Open write file:/var/run/wanget.result fail!\n",act);
			}
			break;
			
	} //end switch
	
}





void restart_dhcpcd(ACONFIG *ACONF)
{
	FILE *fd;
	unsigned char temp[120];
	unsigned char pid[10];
	
	if((fd = fopen("/var/run/dhcpcd-eth1.pid","r")) != NULL) {
	  	fgets(pid,10,fd);
          	sprintf(temp,"kill %s",pid);
          	system(temp);
          	fclose(fd);
          	#ifdef FOR_DEBUG
	    		printf("Kill older dhcpcd daemon\n\r");
	  	#endif
        }
	
	if (ACONF->local.host[0] > ' ') {
		sprintf(temp,"dhcpcd -h %s eth1 &",ACONF->local.host);
        } else {
		sprintf(temp,"dhcpcd eth1 &");
	}
	system(temp);
	#ifdef FOR_DEBUG
		printf("Run dhcpcd eth1 background: %s\n\r",temp);
	#endif
		
	set_wanget_result(99);	//the state that dhcpcd is tring to get an IP and other information
		
}	



