#define FOR_DEBUG 4
//#undef FOR_DEBUG




#include<stdio.h>
#include<signal.h>
#include<string.h>
#include"usercfg5.h"
#include"../../../uC-src/amit_include/amit.h"
//---write flash
#include <fcntl.h>
#include <getopt.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <linux/config.h>
#ifdef CONFIG_MTD
#include <linux/mtd/mtd.h>
#else
#include <linux/blkmem.h>
#endif
//--define L2TP
#define L2TPSFROM a->l2tpd.lns.local_ip[0],a->l2tpd.lns.local_ip[1],a->l2tpd.lns.local_ip[2],a->l2tpd.lns.ip_range_from
#define L2TPSTO a->l2tpd.lns.local_ip[0],a->l2tpd.lns.local_ip[1],a->l2tpd.lns.local_ip[2],a->l2tpd.lns.ip_range_to
#define L2TPSIP a->l2tpd.lns.local_ip[0],a->l2tpd.lns.local_ip[1],a->l2tpd.lns.local_ip[2],a->l2tpd.lns.local_ip[3]
#define L2TPSNO1 a->l2tpd.lns.no_lac[0].ip[0],a->l2tpd.lns.no_lac[0].ip[1],a->l2tpd.lns.no_lac[0].ip[2],a->l2tpd.lns.no_lac[0].ip[3]
#define L2TPSNO2 a->l2tpd.lns.no_lac[1].ip[0],a->l2tpd.lns.no_lac[1].ip[1],a->l2tpd.lns.no_lac[1].ip[2],a->l2tpd.lns.no_lac[1].ip[3]
#define L2TPSNO3 a->l2tpd.lns.no_lac[2].ip[0],a->l2tpd.lns.no_lac[2].ip[1],a->l2tpd.lns.no_lac[2].ip[2],a->l2tpd.lns.no_lac[2].ip[3]
#define L2TPCLIST a->l2tpd.lac[i].peer[0],a->l2tpd.lac[i].peer[1],a->l2tpd.lac[i].peer[2],a->l2tpd.lac[i].peer[3]
//---L2TP status
#define L2TP_STATE_FILE "/var/run/l2tp-status"
#define L2TP_AUTHNAME_FILE "/var/run/l2tp-lac-authname"

//---FindGW
#define ROUTE_PATH	"/proc/net/route"
#define GW_PATH		"/var/config/gw.conf"

#define OFFSET 4259856

#define ARM_MIPS 1
#define DEARRANGE_START   (8) // Lily
#define DEARRANGE_LEN   ((68)+(540))   // Lily


int read_Aconfig(ACONFIG *);//read struct from flash
int write_Aconfig(ACONFIG *);//write struct to flash
int reset_Default(ACONFIG *);//set the struct with default value
int userMainMenu(ACONFIG *);//show the User's Main Menu
int adminMainMenu(ACONFIG *);//show the Administrator's Main Menu
int status(ACONFIG *);//get the system status function
int login(ACONFIG *);//authenticate the user
int toolbox(ACONFIG *);//administrator't Toolbox
int primarySetup(ACONFIG *);//primary setup
int dhcpServer(ACONFIG *);//DHCP Server setting
int virtualServer(ACONFIG *);//Virtual Server setting
int specialApplications(ACONFIG *);//Special Applications setting
int firewall(ACONFIG *);//firewall seeting
int miscellancous(ACONFIG *);//Miscellancouns Items
int pppdMenu(ACONFIG *);//pppd Main Menu
int pptpMenu(ACONFIG *);//pptp Main Menu
int reboot(void);//Toolbox ->'R' reboot
int lanIpSet(ACONFIG *);//Primary Setup->(1) LAN IP Address seting
int wanType(ACONFIG *);//Primary Setup->(2) WAN Type
int wanTypeStatic(ACONFIG *);//Primary Setup->(2) WAN Type (1)-> Static IP Address
int wanTypePPPoE(ACONFIG *);//Primary Setup->(2) WAN Type (3)-> PPPoE Setting
int pptpClient(ACONFIG *);//pptp Client setting
int vpnStatus(ACONFIG *);
int l2tpdMainMenu(ACONFIG *);//L2TP Server setting
int idsMainMenu(ACONFIG *);//IDS Setting
int getIP(char *, BYTE *);//get IP from user to structure
int getPort(char *, WORD *);//get Port from user to structure
int getIPrange(char *, BYTE *);//get 1 BYTE of IP
int actlDefaultGroup(ACONFIG *);//Access Control -> Default Group
int actlGroup(int , ACONFIG *);//Access Control -> Group 1~3
int actlShowStr(char *, char , int , ACONFIG *);//Access Control, read the rule of IP or Port to show as String
void acparser(char *, char , int, ACONFIG *);
int l2tpStatus(void);//Read L2TP state from file then save in VPN structure
int ipinfo(char *, ip_info_struct *);
int urlblockMainMenu(ACONFIG *);//ids -> http url block
int urlblocklist(ACONFIG *);//ids -> http url block -> url list
int saveIPinfo(ACONFIG *);
int htoi_GW(char *, int);//used by findGW
int findGW(ip_info_struct *);//find Getway
int virusScanMainMenu(ACONFIG * );//ids ->virus scan
int viruslist(ACONFIG *);//ids-> virus scan -> virus list
int dnsMainMenu(ACONFIG * );//ids-> dns scan
int mscriptMainMenu(ACONFIG * );//ids-> malicious script
int sendalertmail(ACONFIG * );//Administrator -> send alert mail main menu
int alerttablelist(ACONFIG *);//Adminicstrator -> send alert mail -> alert table list
int setIPSecMainMenu(ACONFIG *);//Administrator -> set IPSec Main Menu
int setIPSecTunnel(int, ACONFIG *);//Administrator -> set IPSec Main Menu -> add/modify tunnels
int setPMACMainMenu(ACONFIG *);//Administrator->setPMACMainMenu 
int getMAC(char*, BYTE *);//Administrator ->setPMACMainMenu ->getMAC
void restart_dhcpcd(void);
int write_script(void);




//---creat VPN structure
VPN_struct vpn;
//---End

char *topLine=	"=================================================================================\n";
char *line=	"\t+-----------------------------------------------------------------------+\n";
char *primary_setup_title="Primary Setup";
char *lanip_setup_title="LAN's IP Setup";
	
//char pptpc_state[5];//to save what pptp client connected

#if ARM_MIPS
  //sync with ACONFIG in the Flash Rom
  ACONFIG FlashACONF;
  ACONFIG RamACONF;
#endif
ACONFIG *ACONF;
ACONFIG *oldACONF;

//--IPSec curren tunnel count
//static int total_tunnels=0;

/*-----main-----*/
int main(int argc,char* argv[])
{
	int logIn=0;//default not log in.
	int i, child_id;
	char command[80],ch;
	//ACONFIG memACONF;

	
	#if ARM_MIPS == 0
		//---stop signal
		signal(SIGINT,SIG_IGN);//---ctrl+c
		signal(SIGTSTP,SIG_IGN);//---ctrl+z
		signal(SIGQUIT,SIG_IGN);//---ctrl+4
		//---End stop signal
	#endif

	if(argc != 2)
	{
		//@@@ModifyBegin just for testing by KM 2002/10/05
		ACONF = &FlashACONF;
  		read_Aconfig(ACONF);
  		write_oldAconfig();
  		//@@@ModifyEnd by KM

		printf("USAGE: ed <option num>\noption num: 1 - normal booting,\n            else - do nothing.\n");
		return;
	}
	//---pptpc
	//for(i=0;i<5;i++)
	//	pptpc_state[i]=0;
	
	
	#if ARM_MIPS
		ACONF = &FlashACONF;
  		read_Aconfig(ACONF);
  		oldACONF = &RamACONF;
  		read_oldAconfig();
	#else
		ACONF = (ACONFIG *)OFFSET;
	#endif
		
	
	switch (argv[1][0]) {
		
		// ------ //
		// For UI //
		// ------ //
		
		case 'a':	//renew button: ed a
			set_wanget_result(99);
			setwan(1);
			system("killall routed");	//must but don't know the reason
			system("routed&");
		case 'b':	//release button: ed b
			set_wanget_result(0);
			setwan(0);
		case 'c':	//misc items saved: ed c: for ping from WAN
			setbwping(0);
			setbwping(1);
		case 'd':	//dmz saved: ed d: cacel, replaced by ed 1
			setdmz(1);
		case 'e':	//routed configure saved: ed e: for RIP
			setrouted(1);
		case 'f':	//snmpd configure saved: ed f
			setsnmpd(1);
		case 'g':	//syslog configure saved: ed g
			system("amit_syslogd");
			system("amit_send f&");	
		case 'h':	//virtual computer
			setmnat(1);
		case 'i':	//for special ap
			setspap(1);
		case 'j':	//Domain filter configure saved: ed j
			setdomainf(1);
		case 'k':	//set WAN'MAC: ed k
			setwanmac(1);
		case 'l':	//set remote administrator: ed l
			setremoteadmin(1);
		case 'm':	//set mac control: ed m
			setpmac(1);
		case 'n':	//set virtual server: ed n
			setsmap(1);
		case 'o':	//set firewall: ed o
			setfirewall(1);
		case 'p':	//connect for pppoe wan type: ed p
			system("adsl-start 6 60");
		case 'q':	//disconnect for pppoe an type: ed q
			system("adsl-stop");
		
		// --------- //
		// For Hsujp //
		// --------- //
		
		case 'A':	//set wanget result = 0: ed A	//for UI sensing
			set_wanget_result(0);
			restart_dhcpcd();
		case 'B':	//restart dhcpcd: ed B		//for testing
			restart_dhcpcd();
		case 'C':	//start routed: ed C		//no use
			setrouted(1);
		
		// ----------- //	
		// For monitor //
		// ----------- //
		
		case '4':	//restart dhcpd: ed 4 		//for monitor senses WAN is up
			set_wanget_result(1);
			setdhcpd(1);
		case '5':	//restart routed: ed 5 		//for monitor senses WAN is up
			setrouted(1);
		case '1':	//bishan boot: ed 1		//for reboot
			setboot(1);
		case '9':	//bishan boot: ed 9		//for reboot
			setboot(9);				//no invoking amit_httpd
	}
	
	if (argv[1][0] != '2') {
		write_oldAconfig();
		return 0;
	}
	
	//---init vpn connection
	for(i=0;i<5;i++)
	{
		vpn.connections[i].type=0;
		vpn.connections[i].enable=0;
		vpn.connections[i].ip[0]='\0';
		vpn.connections[i].name[0]='\0';
		vpn.connections[i].pswd[0]='\0';
	}
	
	
	//ed 2
	//system("clear");
	//memcpy(&memACONF,ACONF,sizeof(ACONFIG));//10/05
	while(1)
	{
		system("clear");
		/*
		if(logIn)
			logIn=adminMainMenu();
		else
			logIn=userMainMenu();
		*/
		//----test----
		if(logIn)
			//logIn=adminMainMenu(&memACONF);//10/05
			logIn=adminMainMenu(ACONF);
		//else if((i=userMainMenu(&memACONF))==3)//10/05
		else if((i=userMainMenu(ACONF))==3)
			break;
		else
			logIn=i;
		//----End test----
	}
	
	return 0;
	
}
/*-----End main-----*/









/*-----Read struct from flash-----*/
#if ARM_MIPS
int read_Aconfig(ACONFIG *a )
{
  	int fd = 0;
  	u_int32_t offset = 0x8000;
  	int err = 0;
  
  	fd = open("/dev/mtd0", O_SYNC | O_RDONLY);
  	/* check the project's memory map for 16*/
  	flash_to_ptr(fd, offset+16, sizeof(ACONFIG), (unsigned char *)a);
  	close(fd);
  	
  	//dearrange((char*)a+DEARRANGE_START, DEARRANGE_LEN);
  
  return 0;    
}

int read_oldAconfig(void)
{
  	FILE *fd;
  
  	if ((fd = fopen("/var/config/ACONF","r")) != NULL) {
  		fread(oldACONF, 1, sizeof(ACONFIG), fd);
  		fclose(fd);
  		return 0;
  	} else {
  		#ifdef FOR_DEBUG
  			printf("read oldAconfig: open the read file (/var/config/ACONF) fail\r\n");
  		#endif
  		return -1;
  	}
  	
}

#else
int read_Aconfig(ACONFIG *a )
{
	int	fd;
	int	len, size, pos, end, i;
	long	offset;
	char	*file, *flashdev, *sp, *pbuf;
	char	buf[1024];
	offset = 16;
	flashdev = "/dev/rom2";
	//printf("ip=%d.%d.%d.%d\n",a->local.ip[0],a->local.ip[1],a->local.ip[2],a->local.ip[3]);
	/* Open and size the FLASH device. */
	if ((fd = open(flashdev, O_RDWR)) < 0) {
		exit(1);
	}
	if (ioctl(fd, BMGETSIZEB, &len) < 0) {
		exit(1);
	}
	//printf("len=%d\n",len);
	if (ioctl(fd, BMSGSIZE, &size) < 0) {
		exit(1);
	}
	//printf("size=%d\n",size);
	if (offset >= len) {
		exit(1);
	}
	/* Start reprogram from begining of FLASH */
	if (lseek(fd, 0, SEEK_SET) < 0) {
		exit(1);
	}
	/* seek to offset */
	if (lseek(fd, offset, SEEK_SET) < 0) {
		exit(1);
	}
	/* All ready, now read contents */
	if (read(fd, a, sizeof(ACONFIG)) != sizeof(ACONFIG)) {
		exit(1);
	}
	//printf("read ok\n");
	close(fd);
	return 1;
}
#endif
/*-----End Read struct from flash-----*/

/*-----Write struct to flash-----*/
#if ARM_MIPS
int write_Aconfig(ACONFIG * a)
{
  int fd = 0;
  u_int32_t offset = 0x8000;
  int err = 0;
  
  fd = open("/dev/mtd0", O_SYNC | O_RDWR);
  erase_flash(fd, offset, 32768);
  close(fd);
  
  /* dearrange((char*)a+DEARRANGE_START, DEARRANGE_LEN);
  a->header.size   = sizeof(ACONFIG);
  a->header.chksum = 0;
  a->header.chksum = ~Nchksum((WORD*)a, sizeof(ACONFIG)/sizeof(WORD)); */
  
  fd = open("/dev/mtd0", O_SYNC | O_RDWR);
  err = ptr_to_flash(fd, offset+16, sizeof(ACONFIG), (unsigned char *)a);  
  close(fd);
  
  return 0;
}


int write_oldAconfig(void)
{
  	FILE *fd;
  
  	if ((fd = fopen("/var/config/ACONF","w")) != NULL) {
  		fwrite(ACONF, 1, sizeof(ACONFIG), fd);
  		fclose(fd);
  		return 0;
  	} else {
  		#ifdef FOR_DEBUG
  			printf("read oldAconfig: open the write file (/var/config/ACONF) fail\r\n");
  		#endif
  		return -1;
  	}
  	
}

#else
int write_Aconfig(ACONFIG * a)
{
	int	fd, erase, preserve;
	int	len, size, pos, end, i, write_len;
	long	offset;
	char	*file, *flashdev, *sp, *pbuf, *temp;
	char	buf[1024];
	write_len=sizeof(ACONFIG);
	temp=(char *)a;
	file = NULL;
	erase = 1;
	preserve = 1;
	offset = 16;
	flashdev = "/dev/rom2";
	/* Open and size the FLASH device. */
	if ((fd = open(flashdev, O_RDWR)) < 0) {
		exit(1);
	}
	if (ioctl(fd, BMGETSIZEB, &len) < 0) {
		exit(1);
	}
	if (ioctl(fd, BMSGSIZE, &size) < 0) {
		exit(1);
	}
	if (offset >= len) {
		exit(1);
	}
	/* Preserve FLASH contents if possible */
	pbuf = (char *) malloc(size);
	if (pbuf == (char *) NULL) {
		exit(1);
	}
	if ((i = read(fd, pbuf, size)) != size) {
		exit(1);
	}
	/* Erase first segment(65536) of FLASH in this device */
	if (erase) {
		pos = 0;
		if (ioctl(fd, BMSERASE, pos) < 0) {
			exit(1);
		}
	}
	/* Start reprogram from begining of FLASH */
	if (lseek(fd, 0, SEEK_SET) < 0) {
		exit(1);
	}
	/* Write preserve buffer upto offset, or seek to offset */
	if (preserve) {
		if (write(fd, pbuf, offset) < offset) {
			exit(1);
		}
	} else {
		if (lseek(fd, offset, SEEK_SET) < 0) {
			exit(1);
		}
	}
	/* All ready, now write out new contents */
	if(write(fd, a, sizeof(ACONFIG) )!= sizeof(ACONFIG)) {
		exit(1);
	}
	/* Write remaining contents of preserve buffer */
	if (preserve) {
		if (write(fd, (pbuf + 32768), (size-32768)) < (size-32768)) {
			exit(1);
		}
	}
	close(fd);

#if DEBUG_IPSEC_MANUAL	
	printf("Write finished\n");
	fflush(stdout);	//wnlee
#endif
	return 0;
}
#endif
/*-----End Write struct to flash-----*/

/*-----reset default value-----*/
int reset_Default(ACONFIG * a)
{
	int i,j;
    // (8) header of configuration data
	a->header.resvFFFF=0xFFFF;
	a->header.minor_ver=0x00;
	a->header.major_ver=0x00;
	a->header.chksum=0x0000;
	a->header.size=0x0000;
    // (64) local configuration
	a->local.ip[0]=192;//Local IP
	a->local.ip[1]=168;
	a->local.ip[2]=123;
	a->local.ip[3]=1;
	a->local.host[0]=0;//Dynamic IP Address->Host Name
	strcpy(a->local.pass,"admin");//password
	a->local.wip[0]=0;//Static IP Address->WAN IP Address
	a->local.wip[1]=0;
	a->local.wip[2]=0;
	a->local.wip[3]=0;
	a->local.wgw[0]=0;//Static IP Address->WAN Gateway
	a->local.wgw[1]=0;
	a->local.wgw[2]=0;
	a->local.wgw[3]=0;
	a->local.wnm[0]=255;//Static IP Address->WAN netmask
	a->local.wnm[1]=255;
	a->local.wnm[2]=255;
	a->local.wnm[3]=0;
	a->local.rhip[0]=0;//Misc->Remote Administrator Host IP
	a->local.rhip[1]=0;
	a->local.rhip[2]=0;
	a->local.rhip[3]=0;
	a->local.rhnm[0]=0;//Misc->Remote Administrator Netmask
	a->local.rhnm[1]=0;
	a->local.rhnm[2]=0;
	a->local.rhnm[3]=0;
	a->local.uwid[0]=0x00;//Admin->WAN's MAC Address
	a->local.uwid[1]=0x11;
	a->local.uwid[2]=0x22;
	a->local.uwid[3]=0x33;
	a->local.uwid[4]=0x44;
	a->local.uwid[5]=0x66;
	a->local.wflag=0x0000;//bit0:Misc->DMZ Host (disable0/enable1)
			 //bit2:Misc->Remote Admin (disable0/enable1)
			 //bit4:Misc->Discard PING (disable0/enable1)
	a->local.wtype=0;//WAN->WAN type
			 //0:static 1:dynamic 2:pppoe 3:pptp 6:Dial-up
	a->local.dmz_host=119;//Misc->DMZ host IP
	a->local.adm_to=0;//X
	a->local.buivar=0;//X
	a->local.wtypex=0;//X
	a->local.upnp_disabled=1;//
	a->local.led_mode=0;//
    // (64) DHCP
	a->dhcp.domain[0]=0;//LAN->Domain Name
	a->dhcp.lease=7200;
	a->dhcp.dns[0].ip[0]=0;
	a->dhcp.dns[0].ip[1]=0;
	a->dhcp.dns[0].ip[2]=0;
	a->dhcp.dns[0].ip[3]=0;
	a->dhcp.dns[1].ip[0]=0;
	a->dhcp.dns[1].ip[1]=0;
	a->dhcp.dns[1].ip[2]=0;
	a->dhcp.dns[1].ip[3]=0;
	a->dhcp.netmask[0]=0;
	a->dhcp.netmask[1]=0;
	a->dhcp.netmask[2]=0;
	a->dhcp.netmask[3]=0;
	a->dhcp.enable=0;
	a->dhcp.range[0]=10;
	a->dhcp.range[1]=20;
    // 
    a->local3.acct[0]=0;
    // (208) server mapping
    for(i=0;i<SMAP_NUM;i++)
    {
	a->smap[i].port=0;
	a->smap[i].uport=0;
	a->smap[i].host=0;
	a->smap[i].flag=0;
    }
    // (384) special application
    for(i=0;i<SPAP_NUM;i++)
    {
	a->spap.trig[i].port=0;
	a->spap.trig[i].flag=0;
	a->spap.trig[i].sp0=0;
	a->spap.trig[i].sp1=0;
    }
    for(i=0;i<SPAP_SEPL_NUM;i++)
    {
	a->spap.sepl[i].lb=0;
	a->spap.sepl[i].ub=0;
    }
    // (576) access contral
    for(i=0;i<PF_RULE_NUM*2;i++)
    {
	a->actl.ipf.rule[i].ip0[0]=0;
	a->actl.ipf.rule[i].ip0[1]=0;
	a->actl.ipf.rule[i].ip1[0]=0;
	a->actl.ipf.rule[i].ip1[1]=0;
	a->actl.ipf.rule[i].port0[0]=0;
	a->actl.ipf.rule[i].port0[1]=0;
	a->actl.ipf.rule[i].port1[0]=0;
	a->actl.ipf.rule[i].port1[1]=0;
	a->actl.ipf.rule[i].rflag=0;
	a->actl.ipf.rule[i].t_index=0;
    }
    a->actl.ipf.flag[0]=0;
    a->actl.ipf.flag[1]=0;
    // (520) properties 0f MAC
    a->pmac.flag=0x0000;//bit0:global enable, bit1:X, bit2:connect control, bit3:allow(0)/deny(1)
    for(i=0;i<PMAC_NUM;i++)
    {
	a->pmac.list[i].mac[0]=0x00;
	a->pmac.list[i].mac[1]=0x00;
	a->pmac.list[i].mac[2]=0x00;
	a->pmac.list[i].mac[3]=0x00;
	a->pmac.list[i].mac[4]=0x00;
	a->pmac.list[i].mac[5]=0x00;
	a->pmac.list[i].ip=0;
	a->pmac.list[i].prop=0;
    }
    // (1536) acctpool1
    a->use_acctpool2=0;//0: use acctpool1, 1:use acctpool2
    for(i=0;i<6;i++)
    {
	a->acctpool[i].desc[0]=0;//DESCription
	a->acctpool[i].user[0]=0;
	a->acctpool[i].flag=0;//auto-reconnect
	a->acctpool[i].pass[0]=0;
	a->acctpool[i].tel[0]=0;
	a->acctpool[i].dns[0].ip[0]=0;
	a->acctpool[i].dns[0].ip[1]=0;
	a->acctpool[i].dns[0].ip[2]=0;
	a->acctpool[i].dns[0].ip[3]=0;
	a->acctpool[i].dns[1].ip[1]=0;
	a->acctpool[i].dns[1].ip[2]=0;
	a->acctpool[i].dns[1].ip[3]=0;
	a->acctpool[i].dns[1].ip[4]=0;
	a->acctpool[i].ip[0]=0;
	a->acctpool[i].ip[1]=0;
	a->acctpool[i].ip[2]=0;
	a->acctpool[i].ip[3]=0;
	a->acctpool[i].baud=0;
	a->acctpool[i].mtu=0;
	a->acctpool[i].to=0;
    }

//----------------^amit.h

/*
    // (8) pptp
	a->pptp.localIP[0]=192;
	a->pptp.localIP[1]=168;
	a->pptp.localIP[2]=0;
	a->pptp.localIP[3]=1;
	a->pptp.start=10;
	a->pptp.end=20;
	a->pptp.enable=0;
	a->pptp.resv=0;
    // (132) pppd
	strcpy(a->pppd.name1,"Name1");
	strcpy(a->pppd.pass1,"Pass1");
	strcpy(a->pppd.name2,"Name2");
	strcpy(a->pppd.pass2,"Pass2");
	strcpy(a->pppd.name3,"Name3");
	strcpy(a->pppd.pass3,"Pass3");
	strcpy(a->pppd.name4,"Name4");
	strcpy(a->pppd.pass4,"Pass4");
	a->pppd.pap=0;
	a->pppd.chap=0;
	a->pppd.mschap=0;
	a->pppd.mschap2=0;
*/
//@@@ModifyBegin by KM 2002/10/5
#ifdef L2TP
    // (116) L2tpd
	a->l2tpd.lns.ip_range_from=11;
	a->l2tpd.lns.ip_range_to=21;
	a->l2tpd.lns.local_ip[0]=192;
	a->l2tpd.lns.local_ip[1]=168;
	a->l2tpd.lns.local_ip[2]=1;
	a->l2tpd.lns.local_ip[3]=1;
	for(i=0;i<3;i++)
		for(j=0;j<4;j++)
			a->l2tpd.lns.no_lac[i].ip[j]=0;
	strcpy(a->l2tpd.lns.name,"");
	for(i=0;i<5;i++)
	{
		for(j=0;j<4;j++)
			a->l2tpd.lac[i].peer[j]=0;
		strcpy(a->l2tpd.lac[i].name,"");
		strcpy(a->l2tpd.lac[i].pswd,"");
	}
#endif
//@@@ModifyEnd
/*
   // (120) pptpc
	for(i=0;i<5;i++)
	{
		strcpy(a->pptpc[i].name,"");
		strcpy(a->pptpc[i].pswd,"");
		a->pptpc[i].ip[0]=0;
		a->pptpc[i].ip[1]=0;
		a->pptpc[i].ip[2]=0;
		a->pptpc[i].ip[3]=0;
		a->pptpc[i].resv[0]=0;
		a->pptpc[i].resv[1]=0;
	}
*/

//@@@ModifyBegin by KM 2002/10/5
   #ifdef IDS
   //(4) IDS
	a->ids.flag[0]=0;
	a->ids.flag[1]=0;
	a->ids.flag[2]=0;
	a->ids.flag[3]=0;
    //(8004)url block
	a->ids.urlblock.flag=0;
	a->ids.urlblock.resv=0;
	a->ids.urlblock.proxy=0;
	for(i=0;i<URL_NUM;i++)
		a->ids.urlblock.url[i].string[0]=0;
    //(4200)virus pattern
	for(i=0;i<VIRUS_PATTERN_NUM;i++)
	{
		a->ids.virus[i].protocol=0;
		a->ids.virus[i].port=1;
		a->ids.virus[i].pattern[0]=0;
	}
    //(8)dns scan
	a->ids.dns_scan.wan_dns[0]=0;
	a->ids.dns_scan.wan_dns[1]=0;
	a->ids.dns_scan.wan_dns[2]=0;
	a->ids.dns_scan.wan_dns[3]=0;
	a->ids.dns_scan.lan_dns=0;
    //(4)malicious script
	a->ids.mscript_proxy=0;
    //(8000)80*100 mail address block
	for(i=0;i<MAIL_ADDRESS_NUM;i++)
		a->ids.mailblock[i].string[0]=0;
    //(4)mail bomb2 mail flow block
	a->ids.mbomb2.total_sender=1000;
	a->ids.mbomb2.total_mails=2000;
#endif
//@@@ModifyEnd by KM
/*
    //(1044)send alert mail
	a->mailalert.enable=0;
	a->mailalert.mail_from[0]=0;
	a->mailalert.list[0].mail_to[0]=0;
	a->mailalert.list[1].mail_to[0]=0;
	a->mailalert.list[2].mail_to[0]=0;
    //alert table
	a->mailalert.alert_table[0].lognum=101;
	a->mailalert.alert_table[0].emergency=0;
	strcpy(a->mailalert.alert_table[0].logname,"ping of death");
	a->mailalert.alert_table[1].lognum=102;
	a->mailalert.alert_table[1].emergency=0;
	strcpy(a->mailalert.alert_table[1].logname,"tear drop");
	a->mailalert.alert_table[2].lognum=103;
	a->mailalert.alert_table[2].emergency=0;
	strcpy(a->mailalert.alert_table[2].logname,"ping flood");
	a->mailalert.alert_table[3].lognum=104;
	a->mailalert.alert_table[3].emergency=0;
	strcpy(a->mailalert.alert_table[3].logname,"smurf");
	a->mailalert.alert_table[4].lognum=201;
	a->mailalert.alert_table[4].emergency=0;
	strcpy(a->mailalert.alert_table[4].logname,"port scan");
	a->mailalert.alert_table[5].lognum=202;
	a->mailalert.alert_table[5].emergency=0;
	strcpy(a->mailalert.alert_table[5].logname,"fraggle");
	a->mailalert.alert_table[6].lognum=203;
	a->mailalert.alert_table[6].emergency=0;
	strcpy(a->mailalert.alert_table[6].logname,"snork");
	a->mailalert.alert_table[7].lognum=204;
	a->mailalert.alert_table[7].emergency=0;
	strcpy(a->mailalert.alert_table[7].logname,"land attack");
	a->mailalert.alert_table[8].lognum=205;
	a->mailalert.alert_table[8].emergency=0;
	strcpy(a->mailalert.alert_table[8].logname,"udp bomb");
	a->mailalert.alert_table[9].lognum=206;
	a->mailalert.alert_table[9].emergency=0;
	strcpy(a->mailalert.alert_table[9].logname,"DNS scan");
	a->mailalert.alert_table[10].lognum=207;
	a->mailalert.alert_table[10].emergency=0;
	strcpy(a->mailalert.alert_table[10].logname,"ICMP unreachable");
	a->mailalert.alert_table[11].lognum=301;
	a->mailalert.alert_table[11].emergency=0;
	strcpy(a->mailalert.alert_table[11].logname,"URL blocking");
	a->mailalert.alert_table[12].lognum=302;
	a->mailalert.alert_table[12].emergency=0;
	strcpy(a->mailalert.alert_table[12].logname,"malicious script");
	a->mailalert.alert_table[13].lognum=303;
	a->mailalert.alert_table[13].emergency=0;
	strcpy(a->mailalert.alert_table[13].logname,"illegal mail sender");
	a->mailalert.alert_table[14].lognum=304;
	a->mailalert.alert_table[14].emergency=0;
	strcpy(a->mailalert.alert_table[14].logname,"virus scan");
	a->mailalert.alert_table[15].lognum=305;
	a->mailalert.alert_table[15].emergency=0;
	strcpy(a->mailalert.alert_table[15].logname,"mail flow control");
	for(i=16;i<20;i++)
	{
		a->mailalert.alert_table[i].lognum=0;
		a->mailalert.alert_table[i].emergency=0;
		strcpy(a->mailalert.alert_table[i].logname,"");
	}
    // (3652) IPSec
	a->ipsec.if_enable_ipsec=0;
	a->ipsec.max_number_of_tunnels=5;
	a->ipsec.resv[0]=0;
	a->ipsec.resv[1]=0;
	for(i=0;i<MAX_NUMBER_OF_TUNNELS;i++)
	{
		a->ipsec.Tunnel_Info[i].tunnel_name[0]=0;
		for(j=0;j<4;j++)
		{
			a->ipsec.Tunnel_Info[i].local_subnet[j]=0;
			a->ipsec.Tunnel_Info[i].local_netmask[j]=0;
			a->ipsec.Tunnel_Info[i].remote_subnet[j]=0;
			a->ipsec.Tunnel_Info[i].remote_netmask[j]=0;
			a->ipsec.Tunnel_Info[i].remote_gateway[j]=0;
		}
		a->ipsec.Tunnel_Info[i].type_of_key_method=0;
		a->ipsec.Tunnel_Info[i].resv[0]=0;
		a->ipsec.Tunnel_Info[i].resv[1]=0;
		a->ipsec.Tunnel_Info[i].resv[2]=0;
		for(j=0;j<4;j++)
		{
			a->ipsec.Tunnel_Info[i].key_method.ike.ike_proposal_index[j]=0;
			a->ipsec.Tunnel_Info[i].key_method.ike.ipsec_proposal_index[j]=0;
		}
		for(j=0;j<20;j++)
			a->ipsec.Tunnel_Info[i].key_method.ike.preshared_key[j]=0;
		a->ipsec.Tunnel_Info[i].key_method.ike.encap_protocol=0;
		a->ipsec.Tunnel_Info[i].key_method.ike.mode=0;
		a->ipsec.Tunnel_Info[i].key_method.ike.pfs=0;
		a->ipsec.Tunnel_Info[i].key_method.ike.auth_method=0;
		a->ipsec.Tunnel_Info[i].key_method.ike.ikelifetime=0;
		a->ipsec.Tunnel_Info[i].key_method.ike.ipseclifetime=0;
		for(j=0;j<64;j++)
			a->ipsec.Tunnel_Info[i].key_method.ike.resv[j]=0;
	}

*/
		return 0;
}
/*-----End reset default value-----*/

/*-----User Main Menu-----*/
int userMainMenu(ACONFIG *a)
{
	int i;
	unsigned long *ulp;
	
	char *user_main_menu[7]={	"================================================================================",
					"\t\t\t\tUser's Main Menu",
					"================================================================================",
					"",
					"\t\t(1)Status",
					"\t\t(2)Log in",
					"\tPlease enter your choice. (1~2)",
				};
	char command[80],ch;
	ip_info_struct ife;
	while(1)
	{
		system("clear");
		for(i=0; i<7; i++)
			printf("%s\n",user_main_menu[i]);
		fgets(command,80,stdin);
		command[strlen(command)-1]=0;
		if(!strcmp(command,"prompt 13"))
		{
			return 3;
		}
		if(strlen(command)!=1)
			continue;
		ch=command[0];
		switch (ch){
			
		case '1':
			status(a);
			break;
			
		case '2':
			return(login(a));
			break;
			
		//---test----
		case '3':
			if(ipinfo("eth1", &ife))
			{
			printf("     name=%s\n",ife.name);
			printf("     ip=%d.%d.%d.%d\n",ife.ip[0],ife.ip[1],ife.ip[2],ife.ip[3]);
			printf("     bcast=%d.%d.%d.%d\n",ife.bcast[0],ife.bcast[1],ife.bcast[2],ife.bcast[3]);
			printf("     mask=%d.%d.%d.%d\n",ife.mask[0],ife.mask[1],ife.mask[2],ife.mask[3]);
			printf("     HWaddr=%s\n",ife.HWaddr);
			}
			getchar();
			break;
		case '4':
			fprintf(stdout, "sizeof ACONFIG = %d bytes\n", sizeof(ACONFIG));
			getchar();
			break;
		case '6':
			printf("passwd: %s", a->local.pass);		
			break;
		case '7':
			//i = *((int *)(0x800006f4));
			ulp = 0x800006f4;
			printf("hardware configure status: %lx", *ulp);		
			break;
		case 'Y':
			reset_Default(a);
			write_Aconfig(a);
			read_Aconfig(a);
			break;
		case 'z':
			printf("size of ACONFIG=%d\n",sizeof(ACONFIG));
			getchar();
			break;
		//case 'p':
		//	printf("%s\n",command);
		//	getchar();
		//	if(!strcmp(command,"prompt 13"))
		//	{
		//		return 3;//exit the main program (for test)
		//	}
		//---End test---
		default:
			continue;
		};
	}
	return 0;
}
/*-----End User Main Menu-----*/

/*-----Administrator's Main Menu-----*/
int adminMainMenu(ACONFIG *a)
{
	int i;
	char *admin_main_menu[23]={	"================================================================================",
					"\t\t\t\tAdministrator's Main Menu",
					"================================================================================",
					"\t\t(1)Status",
					"\t\t(2)Toolbox",
					"\t\t(3)Primary Setup",
					"\t\t(4)DHCP Server",
					"\t\t(5)Virtual Server",
					"\t\t(6)Special Applications",
					"\t\t(7)Firewall",
					"\t\t(8)Miscellancous Items",
					"\t\t(9)pppd",
					"\t\t(A)pptp server",
					"\t\t(B)pptp client",
					"\t\t(C)VPN status",
					"\t\t(D)L2TP Setting",
					"\t\t(E)IDS Setting",
					"\t\t(F)Send Alert Mail",
					"\t\t(G)IPSec Setting",
					"\t\t(H)Filter",
					"\t\t(Y)Default Setting",
					"\t\t(Z)Save Setting",
					"\tPlease enter your choice. (1~E),or press 'b' to log out",
				};
	char command[80],ch;
	while(1)
	{
		system("clear");
		for(i=0; i<23; i++)
			printf("%s\n",admin_main_menu[i]);
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case '1':
			status(a);
			break;
		case '2':
			toolbox(a);
			break;
		case '3':
			primarySetup(a);
			break;
		case '4':
			dhcpServer(a);
			break;
		case '5':
			virtualServer(a);
			break;
		case '6':
			specialApplications(a);
			break;
		case '7':
			firewall(a);
			break;
		case '8':
			miscellancous(a);
			break;
		case '9':
			pppdMenu(a);
			break;
		case 'A':
			pptpMenu(a);
			break;
		case 'B':
			pptpClient(a);
			break;
		case 'C':
			vpnStatus(a);
			break;
		case 'D':
			l2tpdMainMenu(a);
			break;
		case 'E':
			#ifdef IDS
				idsMainMenu(a);
			#endif
			break;
		case 'F':
			sendalertmail(a);
			break;
		case 'G':
			setIPSecMainMenu(a);
			break;
		case 'H':
			setPMACMainMenu(a);
			break;
		case 'Y':
			reset_Default(a);
			write_Aconfig(a);
			read_Aconfig(a);
			break;
		case 'Z':
			write_Aconfig(a);
			sleep(1);
			break;
		case 'b':
			system("clear");
			return 0;//log out
			break;
		default:
			continue;
		};
	}
	return 1;//still log in
}
/*-----End Administrator's Main Menu-----*/

/*-----Login-----*/
int login(ACONFIG * a)
{
	char *pwd;//old password in system
	char input[80];
	strcpy(pwd,a->local.pass);
	//printf("%s\n",pwd);
#ifdef PASSWORD
	//pwd="firewall";
#endif
	printf("\tPlease input Administrator't password\n");
	fgets(input,80,stdin);
	if(strlen(input)>1 && strlen(input)<=10)//because there is \n in the end of string.
	{
			input[strlen(input)-1]='\0';//replace the \n to \0
			if(!strcmp(pwd,input))
				return 1;//log in
	}
	return 0;//not log in
}
/*-----End Login-----*/

/*-----System Status-----*/
int status(ACONFIG * a)
{

	char * leaseTime;
	char * ipAddress;
	char * subnetMask;
	char * gateway;
	char * dns;
	char * moden;
	char * printer;
	char * status_title="System Status";
	int i;
	char command[80],ch;
	ip_info_struct ife;
	//---test
	leaseTime="00";
	moden="no";
	printer="no";
	//---end test
	while(1)
	{
		if(a->local.wtype == 2)
		{
			if(!ipinfo("ppp0", &ife))
			{
				sleep(1);
				continue;
			}
		}
		else
		{
			if(!ipinfo("eth1", &ife))
			{
				sleep(1);
				continue;
				//printf("     bcast=%d.%d.%d.%d\n",ife.bcast[0],ife.bcast[1],ife.bcast[2],ife.bcast[3]);
				//printf("     HWaddr=%s\n",ife.HWaddr);
			}
		}
		findGW(&ife);
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",status_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\tIterm\t\t\tWAN Status\t\t\t\t|\n");
		printf("%s",line);
		//printf("\t|\tLease Time\t\t%-10s\t\t\t\t|\n",leaseTime);
		printf("\t|\tIP Address\t\t%3d.%3d.%3d.%3d\t\t\t\t|\n",ife.ip[0],ife.ip[1],ife.ip[2],ife.ip[3]);
		printf("\t|\tSubnet Mask\t\t%3d.%3d.%3d.%3d\t\t\t\t|\n",ife.mask[0],ife.mask[1],ife.mask[2],ife.mask[3]);
		printf("\t|\tGateway\t\t\t%3d.%3d.%3d.%3d\t\t\t\t|\n",ife.gw[0],ife.gw[1],ife.gw[2],ife.gw[3]);
		//printf("\t|\tGateway\t\t\t%3d.%3d.%3d.%3d\t\t\t\t|\n",a->local.wgw[0],a->local.wgw[1],a->local.wgw[2],a->local.wgw[3]);
		//printf("\t|\tDomain Name Servers\t%3d.%3d.%3d.%3d\t\t\t\t|\n",a->local.rhnm[0],a->local.rhnm[1],a->local.rhnm[2],a->local.rhnm[3]);
		//printf("%s",line);
		//printf("\t|\tIterm\t\t\tPeripheral Status\t\t\t|\n");
		//printf("%s",line);
		//printf("\t|\tModen\t\t\t%-10s\t\t\t\t|\n",moden);
		//printf("\t|\tPrinter\t\t\t%-10s\t\t\t\t|\n",printer);
		printf("%s",line);
		printf("\tPlease press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 'b':
			system("clear");
			return 1;
			break;
		default:
			continue;
		};
	}

	return 0;
}
/*-----End System Status-----*/

/*-----Toolbox-----*/
int toolbox(ACONFIG *a)
{

	char pwd[10];//old password in system
	char newPwd[10];
	char *toolbox_title="Administrator's Toolbox";
	char *vision;
	char *mac;
	char command[80],ch;
	int i;
	while(1)
	{
		system("clear");
		strcpy(pwd,a->local.pass);
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",toolbox_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\t(1)Change Administrator't Password\t\t\t\t|\n");
		printf("%s",line);
		printf("\t|\t(R)Save and Reboot\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\t|\tMiscellaneous Information & Commands\t\t\t\t|\n");
		printf("%s",line);
		//printf("\t|\tFirmware version: %20s\t\t\t\t|\n",vision);
		printf("\t|\tWAN.s MAC Address:%2x-%2x-%2x-%2x-%2x-%2x   \t\t\t\t|\n",
				a->local.uwid[0],
				a->local.uwid[1],
				a->local.uwid[2],
				a->local.uwid[3],
				a->local.uwid[4],
				a->local.uwid[5]);
		printf("%s",line);
		printf("\tPlease enter your choice (1), 'R' , or press 'b' to back\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case '1':
			printf("Old Password=");
			fgets(command,80,stdin);
			if(strlen(command)>1 && strlen(command)<=10)//because there is \n in the end of string.
			{
				command[strlen(command)-1]='\0';//replace the \n to \0
				if(!strcmp(pwd,command))
				{
					printf("New Password=");
					fgets(command,80,stdin);
					command[strlen(command)-1]='\0';//replace the \n to \0
					strcpy(newPwd,command);
					printf("Reconfirm   =");
					fgets(command,80,stdin);
					command[strlen(command)-1]='\0';//replace the \n to \0
					if(!strcmp(newPwd,command))//New password==Reconfirm
					{
						printf("New password OK!\n");
						strcpy(a->local.pass,newPwd);
						sleep(1);
					}
				}
			}
			break;
		case 'R':
			printf("Worning! this will reboot!\n");
			printf("press 'reboot' to make sure\n");
			fgets(command,80,stdin);
			if(strlen(command)==7)
			{
				command[strlen(command)-1]='\0';
				if(!strcmp(command,"reboot"))
				{
					reboot();
				}
			}
			break;
		case 'b':
			return(1);
			break;
		default:
			continue;
		};
	}

	return 0;
}
/*-----End Toolbox-----*/

/*-----Primary Setup-----*/
int primarySetup(ACONFIG *a)
{

	int wType;
	int renewIP;
	int i;
	char command[80],ch;
	while(1)
	{
		if(a->local.wflag&LFLAG_RENEWIP==LFLAG_RENEWIP)
			renewIP=1;
		else
			renewIP=0;
		wType=(int)a->local.wtype;
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",primary_setup_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\tIterm\t\t\t\tSetting\t\t\t\t|\n");
		printf("%s",line);
		printf("\t|\t(1)LAN IP Address\t\t%3d.%3d.%3d.%3d\t\t\t|\n",a->local.ip[0],a->local.ip[1],a->local.ip[2],a->local.ip[3]);
		if(wType==0)//static
		{
			printf("\t|\t(2)WAN Type\t\t\tStatic IP Address\t\t|\n");
			//printf("\t|\t(s)Save and Reset\t\t\t\t\t\t|\n");
		}
		else if(wType==1)//dynamic
		{
			printf("\t|\t(2)WAN Type\t\t\tDynamic IP Address\t\t|\n");
			//if(renewIP==1)
			//	printf("\t|\t(3)Renew IP Forever\t\tEnable\t\t\t\t|\n");
			//else
			//	printf("\t|\t(3)Renew IP Forever\t\tDisable\t\t\t\t|\n");
			//printf("\t|\t(s)Save and Reset\t\t\t\t\t\t|\n");
		}
		else//pppoe
		{
			printf("\t|\t(2)WAN Type\t\t\tPPP over Ethernet\t\t|\n");
			//printf("\t|\t(s)Save and Reset\t\t\t\t\t\t|\n");
		}
		printf("%s",line);
		printf("\tPlease enter your choice, or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		#if 0
		case 's':
			//@@@ModifyBegin by KM 2002/10/5
			//setlan(0);
			//setwan(0);
			//setdhcpd(0);
			//setnat(0);
			//setsmap(0);
			//setdmz(0);
			//@@@ModifyEnd by KM
			write_Aconfig(a);
			setlan(1);
			setwan(1);
			setdhcpd(1);
			setnat(1);
			setsmap(1);
			setdmz(1);
			break;
		#endif
		case '1':
			lanIpSet(a);
			break;
		case '2':
			wanType(a);
			break;
		
		#if 0
		case '3':
			if(wType==1)
			{
				if((a->local.wflag & LFLAG_RENEWIP)==LFLAG_RENEWIP)
					a->local.wflag&=(~LFLAG_RENEWIP);
				else
					a->local.wflag|=LFLAG_RENEWIP;
			}
			break;
		#endif
		
		case 'b':
			system("clear");
			return 1;
			break;
		default:
			continue;
		};
	}

	return 0;
}
/*-----End Primary Setup-----*/

/*-----DHCP Server-----*/
int dhcpServer(ACONFIG * a)
{

	int  dhcpServer_enable,temp;
	char buf[4];
	char *ipPoolStart;
	char *ipPoolEnd;
	char *domainName;
	char *dhcp_title="DHCP Server";
	int i;
	char command[80],ch;
	while(1)
	{
		dhcpServer_enable=(int)a->dhcp.enable;
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",dhcp_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\tIterm\t\t\t\tSetting\t\t\t\t|\n");
		printf("%s",line);
		if(dhcpServer_enable==1)
			printf("\t|\t(1)DHCP Server\t\t\t\t Enable\t\t\t|\n");
		else
			printf("\t|\t(1)DHCP Server\t\t\t\tDisable\t\t\t|\n");
		printf("\t|\t(2)IP Pool Starting Address\t\t%3d.%3d.%3d.%3d\t\t|\n",a->local.ip[0],a->local.ip[1],a->local.ip[2],a->dhcp.range[0]);
		printf("\t|\t(3)IP Pool Ending Address\t\t%3d.%3d.%3d.%3d\t\t|\n",a->local.ip[0],a->local.ip[1],a->local.ip[2],a->dhcp.range[1]);
		printf("\t|\t(4)Domain Name Server1\t\t\t%3d.%3d.%3d.%3d\t\t|\n",a->dhcp.dns[0].ip[0],a->dhcp.dns[0].ip[1],a->dhcp.dns[0].ip[2],a->dhcp.dns[0].ip[3]);
		printf("\t|\t(5)Domain Name Server2\t\t\t%3d.%3d.%3d.%3d\t\t|\n",a->dhcp.dns[1].ip[0],a->dhcp.dns[1].ip[1],a->dhcp.dns[1].ip[2],a->dhcp.dns[1].ip[3]);
		//printf("\t|\t(5)Default Lease Time\t\t\t%-10d\t\t|\n",a->dhcps.default_lease_time);
		//printf("\t|\t(6)MAX Lease Time\t\t\t%-10d\t\t|\n",a->dhcps.max_lease_time);
		printf("\t|\t(s)Save and Reset\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice, or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 's':
			//ModifyBegin by KM 2002/10/05
			//setdhcpd(0);
			//ModifyEnd by KM
			write_Aconfig(a);
			setdhcpd(1);
			break;
		case '1':
			a->dhcp.enable=(BYTE)-1*(dhcpServer_enable-1);
			break;
		case '2':
			printf("IP Pool Start:%d.%d.%d.",a->local.ip[0],a->local.ip[1],a->local.ip[2]);
			fgets(command,80,stdin);
			getIPrange(command, &(a->dhcp.range[0]));
			break;
		case '3':
			printf("IP Pool End:%d.%d.%d.",a->local.ip[0],a->local.ip[1],a->local.ip[2]);
			fgets(command,80,stdin);
			getIPrange(command, &(a->dhcp.range[1]));
			break;
		case '4':
		case '5':
			i=ch-'0'-4;
			printf("Domain Name Server=");
			fgets(command,80,stdin);
			getIP(command, a->dhcp.dns[i].ip);
			break;
		case 'b':
			system("clear");
			return 1;
			break;
		default:
			continue;
		};
	}

	return 0;
}
/*-----End DHCP Server-----*/

/*-----Virtual Server-----*/

int virtualServer(ACONFIG * a)
{

	char *q="Service Port";
	char *q2="Server IP";
	char *virtual_server_title="Virtual Server";
	int i;
	char temp_index;
	char command[80],ch;
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",virtual_server_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|ID\t%s\t%s\t\tStatus\t\t\t|\n",q,q2);
		printf("%s",line);
		for(i=0;i<8;i++)
		{
			if(a->smap[i].flag==1)
				printf("\t|(%d)\t%5d-%-5d\t%3d.%3d.%3d.%3d\t\t(%2d) Enable\t\t|\n",
					i+1,a->smap[i].port,a->smap[i].uport,a->local.ip[0],a->local.ip[1],a->local.ip[2],a->smap[i].host,i+9);
			else
				printf("\t|(%d)\t%5d-%-5d\t%3d.%3d.%3d.%3d\t\t(%2d)Disable\t\t|\n",
					i+1,a->smap[i].port,a->smap[i].uport,a->local.ip[0],a->local.ip[1],a->local.ip[2],a->smap[i].host,i+9);
		}

				printf("\t|(s)Save and Reset\t\t\t\t\t\t\t|\n");

		printf("%s",line);
		printf("\tPlease enter your choice (1~G),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){

		case 's':
			//ModifyBegin by KM 2002/10/05
			//setsmap(0);
			//ModifyEnd by KM
			write_Aconfig(a);
			setsmap(1);
			break;

		case '1':
			printf("%s start:",q);
			fgets(command,80,stdin);
			getPort(command, &(a->smap[0].port));
			printf("%s end:",q);
			fgets(command,80,stdin);
			getPort(command, &(a->smap[0].uport));
			printf("%s%3d.%3d.%3d.",q2,a->local.ip[0],a->local.ip[1],a->local.ip[2]);
			fgets(command,80,stdin);
			getIPrange(command, &(a->smap[0].host));
			break;
		case '2':
			printf("%s start:",q);
			fgets(command,80,stdin);
			getPort(command, &(a->smap[1].port));
			printf("%s end:",q);
			fgets(command,80,stdin);
			getPort(command, &(a->smap[1].uport));
			printf("%s%3d.%3d.%3d.",q2,a->local.ip[0],a->local.ip[1],a->local.ip[2]);
			fgets(command,80,stdin);
			getIPrange(command, &(a->smap[1].host));
			break;
		case '3':
			printf("%s start:",q);
			fgets(command,80,stdin);
			getPort(command, &(a->smap[2].port));
			printf("%s end:",q);
			fgets(command,80,stdin);
			getPort(command, &(a->smap[2].uport));
			printf("%s%3d.%3d.%3d.",q2,a->local.ip[0],a->local.ip[1],a->local.ip[2]);
			fgets(command,80,stdin);
			getIPrange(command, &(a->smap[2].host));
			break;
		case '4':
			printf("%s start:",q);
			fgets(command,80,stdin);
			getPort(command, &(a->smap[3].port));
			printf("%s end:",q);
			fgets(command,80,stdin);
			getPort(command, &(a->smap[3].uport));
			printf("%s%3d.%3d.%3d.",q2,a->local.ip[0],a->local.ip[1],a->local.ip[2]);
			fgets(command,80,stdin);
			getIPrange(command, &(a->smap[3].host));
			break;
		case '5':
			printf("%s start:",q);
			fgets(command,80,stdin);
			getPort(command, &(a->smap[4].port));
			printf("%s end:",q);
			fgets(command,80,stdin);
			getPort(command, &(a->smap[4].uport));
			printf("%s%3d.%3d.%3d.",q2,a->local.ip[0],a->local.ip[1],a->local.ip[2]);
			fgets(command,80,stdin);
			getIPrange(command, &(a->smap[4].host));
			break;
		case '6':
			printf("%s start:",q);
			fgets(command,80,stdin);
			getPort(command, &(a->smap[5].port));
			printf("%s end:",q);
			fgets(command,80,stdin);
			getPort(command, &(a->smap[5].uport));
			printf("%s%3d.%3d.%3d.",q2,a->local.ip[0],a->local.ip[1],a->local.ip[2]);
			fgets(command,80,stdin);
			getIPrange(command, &(a->smap[5].host));
			break;
		case '7':
			printf("%s start:",q);
			fgets(command,80,stdin);
			getPort(command, &(a->smap[6].port));
			printf("%s end:",q);
			fgets(command,80,stdin);
			getPort(command, &(a->smap[6].uport));
			printf("%s%3d.%3d.%3d.",q2,a->local.ip[0],a->local.ip[1],a->local.ip[2]);
			fgets(command,80,stdin);
			getIPrange(command, &(a->smap[6].host));
			break;
		case '8':
			printf("%s start:",q);
			fgets(command,80,stdin);
			getPort(command, &(a->smap[7].port));
			printf("%s end:",q);
			fgets(command,80,stdin);
			getPort(command, &(a->smap[7].uport));
			printf("%s%3d.%3d.%3d.",q2,a->local.ip[0],a->local.ip[1],a->local.ip[2]);
			fgets(command,80,stdin);
			getIPrange(command, &(a->smap[7].host));
			break;
		case '9':
			a->smap[0].flag=-1*(a->smap[0].flag-1);
			break;
		case 'A':
			a->smap[1].flag=-1*(a->smap[1].flag-1);
			break;
		case 'B':
			a->smap[2].flag=-1*(a->smap[2].flag-1);
			break;
		case 'C':
			a->smap[3].flag=-1*(a->smap[3].flag-1);
			break;
		case 'D':
			a->smap[4].flag=-1*(a->smap[4].flag-1);
			break;
		case 'E':
			a->smap[5].flag=-1*(a->smap[5].flag-1);
			break;
		case 'F':
			a->smap[6].flag=-1*(a->smap[6].flag-1);
			break;
		case 'G':
			a->smap[7].flag=-1*(a->smap[7].flag-1);
			break;
		case 'b':
			return 0;
		default:
			continue;
		};
	}

	return 0;
}

/*-----End Virtual Server-----*/

/*-----Firewall-----*/
int firewall(ACONFIG *a)
{

	char *access_control_title[2]={"Inbound Firewall","Outbound Firewall"};
	char *status[2]={"Disable", "Enable"};
	//char *rule[2]={"Allow","Deny"};
	char *rule[2] = {"Deny", "Allow"};
	char prot[5];
	int i,index,temp,h,j,k,rflag_prot;
	char command[80],ch;
	char buf[4];
	BYTE *ip_temp;
	index=0;//Inbound
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",access_control_title[index]);
		printf("%s",topLine);
		printf("%s",line);
		if((a->actl.ipf.flag[index] & FDF_ENABLED) == FDF_ENABLED)
			temp=1;//enable
		else
			temp=0;//disable
		printf("\t|\t(A)%s\t\t\t%s\t\t\t|\n",access_control_title[index],status[temp]);
		if((a->actl.ipf.flag[index] & FDF_PASSRULE )== FDF_PASSRULE)
			temp=1;//deny
		else
			temp=0;//allow
		printf("\t|\t(B)%-5s all to pass except those that match the fllowing rules\t|\n",rule[temp]);
		printf("\t|ID\tSource IP:\tPorts\t\tDestination IP:\tPorts\tstate\t|\n");
		for(i=0;i<8;i++)
		{
			if((a->actl.ipf.rule[i+PF_RULE_NUM*(index)].rflag & FRF_ENABLED) == FRF_ENABLED)
				temp=1;// enable
			else
				temp=0;// disable

			ip_temp=(BYTE *)&a->actl.ipf.rule[i+PF_RULE_NUM*(index)].ip0[0];
			printf("\t|%d %3d.%3d.%3d.%3d/",i+1,
				ip_temp[0],ip_temp[1],ip_temp[2],ip_temp[3]);

			ip_temp=(BYTE *)&a->actl.ipf.rule[i+PF_RULE_NUM*(index)].ip0[1];
			printf("%d:%d-%d ",
				a->actl.ipf.rule[i+PF_RULE_NUM*(index)].ip0[1],//range
				a->actl.ipf.rule[i+PF_RULE_NUM*(index)].port0[0],
				a->actl.ipf.rule[i+PF_RULE_NUM*(index)].port0[1]);

			ip_temp=(BYTE *)&a->actl.ipf.rule[i+PF_RULE_NUM*(index)].ip1[0];
			printf("%3d.%3d.%3d.%3d/",
				ip_temp[0],ip_temp[1],ip_temp[2],ip_temp[3]);

			//check port type
			rflag_prot = (a->actl.ipf.rule[i+PF_RULE_NUM*(index)].rflag & FRF_PROT_MASK);
				switch(rflag_prot)
				{
					case FRF_PROT_BOTH:
						sprintf(prot, "both");
						break;
					case FRF_PROT_TCP:
						sprintf(prot, "tcp");
						break;
					case FRF_PROT_UDP:
						sprintf(prot, "udp");
						break;
				}
			ip_temp=(BYTE *)&a->actl.ipf.rule[i+PF_RULE_NUM*(index)].ip1[1];
			printf("%d:%d-%d %s %s\n",
				a->actl.ipf.rule[i+PF_RULE_NUM*(index)].ip1[1],
				a->actl.ipf.rule[i+PF_RULE_NUM*(index)].port1[0],
				a->actl.ipf.rule[i+PF_RULE_NUM*(index)].port1[1],
				prot,
				status[temp]);

		}
		printf("\t|\t(C)%s or %s\t\t\t|\n",access_control_title[0],access_control_title[1]);
		printf("\t|\t(s)Save and Reset\t\t\t\t\t\t|\n");
		printf("%s",line);
		//printf("\tPlease enter your choice, or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
// pj
		case 's':
			setfirewall(0);
			write_Aconfig(a);
			setfirewall(1);
			break;
// pj
		case 'A'://change state
			printf("before flag = %d, ", a->actl.ipf.flag[index]);
			if((a->actl.ipf.flag[index] & FDF_ENABLED) == FDF_ENABLED)
				a->actl.ipf.flag[index]&=(~FDF_ENABLED);
			else
				a->actl.ipf.flag[index]|=FDF_ENABLED;
			printf("after flag = %d\n", a->actl.ipf.flag[index]);
			break;
		case 'B'://change Allow/Deny
			if((a->actl.ipf.flag[index] & FDF_PASSRULE) == FDF_PASSRULE)
				a->actl.ipf.flag[index]&=(~FDF_PASSRULE);
			else
				a->actl.ipf.flag[index]|=FDF_PASSRULE;
			break;
		case 'C':
			index=-1*(index-1);
			break;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
			i=ch-'0'-1;
			printf("Source IP netid:");
			fgets(command, 80, stdin);
			command[strlen(command) - 1] = 0;
			for(h = k = 0, ip_temp=(BYTE *)&a->actl.ipf.rule[i+PF_RULE_NUM*(index)].ip0[0]; k < 4; k++)
			{
				for(j =0; command[h] != '.' && command[h] != 0; h++)
					j++;
				strncpy(buf, command + h - j, j);
				buf[j] = 0;
				ip_temp[k] = atoi(buf);
				h++;
			}
			printf("Source IP netmask(0~32):");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			if(atoi(command)<0 || atoi(command)>32)
				continue;
			a->actl.ipf.rule[i+PF_RULE_NUM*(index)].ip0[1]=(DWORD)atoi(command);
			//command[strlen(command) - 1] = 0;
			//for(h = k = 0, ip_temp=(BYTE *)&a->actl.ipf.rule[i+PF_RULE_NUM*(index)].ip0[1]; k < 4; k++)
			//{
			//	for(j =0; command[h] != '.' && command[h] != 0; h++)
			//		j++;
			//	strncpy(buf, command + h - j, j);
			//	buf[j] = 0;
			//	ip_temp[k] = atoi(buf);
			//	h++;
			//}
			printf("Port type tcp/udp/both:(t/u/b)\n");
			fgets(command,80,stdin);
			if(command[0]=='t')//tcp
			{
				a->actl.ipf.rule[i+PF_RULE_NUM*(index)].rflag&=(~FRF_PROT_MASK);
				a->actl.ipf.rule[i+PF_RULE_NUM*(index)].rflag|=FRF_PROT_TCP;
			}
			else if(command[0]=='u') //udp
			{
				a->actl.ipf.rule[i+PF_RULE_NUM*(index)].rflag&=(~FRF_PROT_MASK);
				a->actl.ipf.rule[i+PF_RULE_NUM*(index)].rflag|=FRF_PROT_UDP;
			}
			else //both
			{
				a->actl.ipf.rule[i+PF_RULE_NUM*(index)].rflag&=(~FRF_PROT_MASK);
				a->actl.ipf.rule[i+PF_RULE_NUM*(index)].rflag|=FRF_PROT_BOTH;
			}
			printf("Source Port start:");
			fgets(command,80,stdin);
			getPort(command,&a->actl.ipf.rule[i+PF_RULE_NUM*(index)].port0[0]);
			printf("Source Port end:");
			fgets(command,80,stdin);
			getPort(command,&a->actl.ipf.rule[i+PF_RULE_NUM*(index)].port0[1]);
			printf("Destination IP netid:");
			fgets(command,80,stdin);
			command[strlen(command) - 1] = 0;
			for(h = k = 0, ip_temp=(BYTE *)&a->actl.ipf.rule[i+PF_RULE_NUM*(index)].ip1[0]; k < 4; k++)
			{
				for(j =0; command[h] != '.' && command[h] != 0; h++)
					j++;
				strncpy(buf, command + h - j, j);
				buf[j] = 0;
				ip_temp[k] = atoi(buf);
				h++;
			}
			printf("Destination IP netmask(0~32):");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			if(atoi(command)<0 || atoi(command)>32)
				continue;
			a->actl.ipf.rule[i+PF_RULE_NUM*(index)].ip1[1]=(DWORD)atoi(command);
			//for(h = k = 0, ip_temp=(BYTE *)&a->actl.ipf.rule[i+PF_RULE_NUM*(index)].ip1[1]; k < 4; k++)
			//{
			//	for(j =0; command[h] != '.' && command[h] != 0; h++)
			//		j++;
			//	strncpy(buf, command + h - j, j);
			//	buf[j] = 0;
			//	ip_temp[k] = atoi(buf);
			//	h++;
			//}
			printf("Destination Port start:");
			fgets(command,80,stdin);
			getPort(command,&a->actl.ipf.rule[i+PF_RULE_NUM*(index)].port1[0]);
			printf("Destination Port end:");
			fgets(command,80,stdin);
			getPort(command,&a->actl.ipf.rule[i+PF_RULE_NUM*(index)].port1[1]);
			printf("Enable?(Y/N)");
			fgets(command,80,stdin);
			if(command[0]== 'Y' || command[0]== 'y')
				a->actl.ipf.rule[i+PF_RULE_NUM*(index)].rflag|=FRF_ENABLED;
			else
				a->actl.ipf.rule[i+PF_RULE_NUM*(index)].rflag&=(~FRF_ENABLED);
			break;
		case 'b':
			return 1;
		default:
			continue;
		}
	}


	return 0;
}
/*-----End Firewall-----*/

/*-----Miscellancous Items-----*/
int miscellancous(ACONFIG *a)
{

	char buf[4];
	char *state[2]={"Disable", "Enable"};
	int temp;
	char *misc_items_title="Miscellancous Items";
	int i;
	char command[80],ch;
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",misc_items_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\tIterm\t\t\t\t\tSetting\t\tEnable\t|\n");
		printf("%s",line);
		if((a->local.wflag & LFLAG_DMZ)== LFLAG_DMZ )
			temp=1;
		else
			temp=0;
		printf("\t|\t(1)IP Address of DMS Host\t%3d.%3d.%3d.%3d\t(2)%7s\t|\n",a->local.ip[0],a->local.ip[1],a->local.ip[2],a->local.dmz_host,state[temp]);
		if((a->local.wflag & LFLAG_RADM)== LFLAG_RADM )
			temp=1;
		else
			temp=0;
		printf("\t|\t(3)Remote Administrator Host\t%3d.%3d.%3d.%3d\t(4)%7s\t|\n",a->local.rhip[0],a->local.rhip[1],a->local.rhip[2],a->local.rhip[3],state[temp]);
		if((a->local.wflag & LFLAG_BWPING)== LFLAG_BWPING )
			temp=1;
		else
			temp=0;
		printf("\t|\t(5)Discard PING from WAN side \t\t\t%s\t\t|\n",state[temp]);
		printf("\t|\t(s)Save and Reset\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice, or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 's':
			//@@@ModifyBegin by KM 2002/10/05
			//setdmz(0);
			//@@@ModifyEnd by KM
			setbwping(0);
			write_Aconfig(a);
			setdmz(1);
			setbwping(1);
			break;
		case '1':
			printf("DMZ host=%d.%d.%d.",a->local.ip[0],a->local.ip[1],a->local.ip[2]);
			fgets(command,80,stdin);
			getIPrange(command,&(a->local.dmz_host));
			break;
		case '2':
			if((a->local.wflag & LFLAG_DMZ)== LFLAG_DMZ )
				a->local.wflag&=(~LFLAG_DMZ);
			else
				a->local.wflag|=LFLAG_DMZ;
			break;
		case '3':
			printf("Remote Administrator Host=");
			fgets(command,80,stdin);
			getIP(command, a->local.rhip);
			break;
		case '4':
			if((a->local.wflag & LFLAG_RADM)== LFLAG_RADM )
				a->local.wflag&=(~LFLAG_RADM);
			else
				a->local.wflag|=LFLAG_RADM;
			break;
		case '5':
			if((a->local.wflag & LFLAG_BWPING)== LFLAG_BWPING )
				a->local.wflag&=(~LFLAG_BWPING);
			else
				a->local.wflag|=LFLAG_BWPING;
			break;
		case 'b':
			system("clear");
			return 1;
			break;
		default:
			continue;
		}//End switch
	}//While End

	return 0;
}
/*-----End Miscellancous Items-----*/

/*-----pppd Main Menu-----*/
int pppdMenu(ACONFIG *a)
{
/*
	char *q[2]={	"Name:",
			"Password:",
		    };
	char name[16];
	char pass[16];
	char *pppd_title="pppd Main Menu";
	int i;
	char command[80],ch;
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",pppd_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\tName\t\t\tPassword\t\t\t\t|\n");
		printf("%s",line);
		printf("\t|\t(1)%-16s\t%-16s\t\t\t|\n",a->pppd.name1,a->pppd.pass1);
		printf("\t|\t(2)%-16s\t%-16s\t\t\t|\n",a->pppd.name2,a->pppd.pass2);
		printf("\t|\t(3)%-16s\t%-16s\t\t\t|\n",a->pppd.name3,a->pppd.pass3);
		printf("\t|\t(4)%-16s\t%-16s\t\t\t|\n",a->pppd.name4,a->pppd.pass4);
		printf("%s",line);
		printf("\t|\tItem\t\t\tSetting\t\t\t\t\t|\n");
		printf("%s",line);
		if(a->pppd.pap==1)
			printf("\t|\t(5)pap\t\t\tEnable\t\t\t\t\t|\n");
		else
			printf("\t|\t(5)pap\t\t\tDisable\t\t\t\t\t|\n");
		if(a->pppd.chap==1)
			printf("\t|\t(6)chap\t\t\tEnable\t\t\t\t\t|\n");
		else
			printf("\t|\t(6)chap\t\t\tDisable\t\t\t\t\t|\n");
		if(a->pppd.mschap==1)
			printf("\t|\t(7)mschap\t\tEnable\t\t\t\t\t|\n");
		else
			printf("\t|\t(7)mschap\t\tDisable\t\t\t\t\t|\n");
		if(a->pppd.mschap2==1)
			printf("\t|\t(8)mschap2\t\tEnable\t\t\t\t\t|\n");
		else
			printf("\t|\t(8)mschap2\t\tDisable\t\t\t\t\t|\n");
// succ
			printf("\t|\t(s)Save and Reset\t\t\t\t\t\t|\n");
// succ
		printf("%s",line);
		printf("\tPlease enter your choice (1~8),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
// succ
		case 's':
			setpppd(0);
			setpptpd(0);
			write_Aconfig(a);
			setpppd(1);
			setpptpd(1);
			break;
// succ
		case '1':
			printf("%s",q[0]);
			fgets(command,80,stdin);
			if(strlen(command)>17)
				continue;
			command[strlen(command)-1]='\0';
			strcpy(a->pppd.name1,command);
			printf("%s",q[1]);
			fgets(command,80,stdin);
			if(strlen(command)>17)
				continue;
			command[strlen(command)-1]='\0';
			strcpy(a->pppd.pass1,command);
			break;
		case '2':
			printf("%s",q[0]);
			fgets(command,80,stdin);
			if(strlen(command)>17)
				continue;
			command[strlen(command)-1]='\0';
			strcpy(a->pppd.name2,command);
			printf("%s",q[1]);
			fgets(command,80,stdin);
			if(strlen(command)>17)
				continue;
			command[strlen(command)-1]='\0';
			strcpy(a->pppd.pass2,command);
			break;
		case '3':
			printf("%s",q[0]);
			fgets(command,80,stdin);
			if(strlen(command)>17)
				continue;
			command[strlen(command)-1]='\0';
			strcpy(a->pppd.name3,command);
			printf("%s",q[1]);
			fgets(command,80,stdin);
			if(strlen(command)>17)
				continue;
			command[strlen(command)-1]='\0';
			strcpy(a->pppd.pass3,command);
			break;
		case '4':
			printf("%s",q[0]);
			fgets(command,80,stdin);
			if(strlen(command)>17)
				continue;
			command[strlen(command)-1]='\0';
			strcpy(a->pppd.name4,command);
			printf("%s",q[1]);
			fgets(command,80,stdin);
			if(strlen(command)>17)
				continue;
			command[strlen(command)-1]=='\0';
			strcpy(a->pppd.pass4,command);
			break;
		case '5':
			a->pppd.pap=-1*(a->pppd.pap-1);
			break;
		case '6':
			a->pppd.chap=-1*(a->pppd.chap-1);
			break;
		case '7':
			a->pppd.mschap=-1*(a->pppd.mschap-1);
			break;
		case '8':
			a->pppd.mschap2=-1*(a->pppd.mschap2-1);
			break;
		case 'b':
			system("clear");
			return 1;
			break;
		default:
			continue;
		};
	}
*/
	return 0;
}
/*-----End pppd Main Menu-----*/

/*-----pptp Main Menu-----*/

int pptpMenu(ACONFIG *a)
{
/*
	char *remoteIpStart;
	char *remoteIpEnd;
	char *state[2]={"Disable",
			"Enable",
			};
	char *pptp_title="pptp Main Menu";
	int i,temp;
	char command[80],ch;
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",pptp_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\tIterm\t\t\t\tSetting\t\t\t\t|\n");
		printf("%s",line);
		printf("\t|\t(1)Local IP\t\t\t:%3d.%3d.%3d.%3d\t\t|\n",a->local.rhip[0],a->local.rhip[1],a->local.rhip[2],a->pptp.localIP[3]);
		printf("\t|\t(2)Remote IP Start\t\t:%3d.%3d.%3d.%3d\t\t|\n",a->local.rhip[0],a->local.rhip[1],a->local.rhip[2],a->pptp.start);
		printf("\t|\t(3)Remote IP End\t\t:%3d.%3d.%3d.%3d\t\t|\n",a->local.rhip[0],a->local.rhip[1],a->local.rhip[2],a->pptp.end);
		printf("\t|\t(4)pptpd state \t\t\t%-8s\t\t\t|\n",state[a->pptp.enable] );
// succ
		printf("\t|\t(s)Save and Rset\t\t\t\t\t\t|\n");
// succ
		printf("%s",line);
		printf("\tPlease enter your choice (1~3),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
// succ
		case 's':
			if(a->pptp.enable==0)
			{
				setpptpd(0);
				write_Aconfig(a);
			}
			else
			{
				setpptpd(0);
				setpptpd(1);
				write_Aconfig(a);
			}
			break;
// succ
		case '1':
			printf("Local IP=%d.%d.%d.",a->local.rhip[0],a->local.rhip[1],a->local.rhip[2]);
			fgets(command,80,stdin);
			getIPrange(command, &(a->pptp.localIP[3]));
			if(a->pptp.localIP[3] == a->local.rhip[3])
			{
				printf("Worring! pptp local ip can't be the same as LAN local ip\n");
				getchar();
				(a->pptp.localIP[3])+=1;
			}
			break;
		case '2':
			printf("remote IP start:%3d.%3d.%3d.",a->pptp.localIP[0],a->pptp.localIP[1],a->pptp.localIP[2]);
			fgets(command,80,stdin);
			getIPrange(command,&(a->pptp.start));
			break;
		case '3':
			printf("remote IP end:%3d.%3d.%3d.",a->pptp.localIP[0],a->pptp.localIP[1],a->pptp.localIP[2]);
			fgets(command,80,stdin);
			getIPrange(command, &(a->pptp.end));
			break;
		case '4':
			a->pptp.enable= -1*(a->pptp.enable - 1);
			break;
		case 'b':
			system("clear");
			return 1;
			break;
		default:
			continue;
		}
	}
*/
	return 0;
}

/*-----End pptp Main Menu-----*/

/*-----Reboot-----*/
int reboot()
{
/*
	printf("Rebooting!!\n");
	sleep(1);
*/
	return 0;
}
/*-----End Reboot-----*/

/*-----LAN IP Address-----*/
int lanIpSet(ACONFIG *a)
{
	char command[80];
	char ch;
	
	while (1) {
		
		system("clear");
		
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",lanip_setup_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\tIterm\t\t\t\tSetting\t\t\t\t|\n");
		printf("%s",line);
		printf("\t|\t(1)LAN IP Address\t\t%3d.%3d.%3d.%3d\t\t\t|\n",a->local.ip[0],a->local.ip[1],a->local.ip[2],a->local.ip[3]);
		printf("\t|\t(s)Save and Reset\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease keyin LAN's IP and press s to save, or press 'b' to back.\n");
		
		fgets(command,80,stdin);
		if(strlen(command) >= 8) {
			getIP(command, a->local.ip);
			continue;
		} else if(strlen(command) != 2) {
			continue;
		} else {
			ch=command[0];
			switch (ch){
				case 'b':
					system("clear");
					return 1;
					break;
				case 's':
					write_Aconfig(a);
					setlan(1);
					break;
				default:
					continue;
			}
		}
	}
		
	return 1;
}






/*-----WAN Type-----*/
int wanType(ACONFIG * a)
{

	char *type;
	char *wan_type_title="WAN Type";
	int i;
	char command[80],ch;
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",wan_type_title);
		printf("%s",topLine);
		printf("%s",line);
		if(a->local.wtype==0)
		{
			printf("\t|\t(1)Static IP Address\t\t\t\tEnable\t\t|\n");
			printf("\t|\t(2)Dynamic IP Address\t\t\t\tDisable\t\t|\n");
			printf("\t|\t(3)PPP over Ethernet\t\t\t\tDisable\t\t|\n");
		}
		else if(a->local.wtype==1)
		{
			printf("\t|\t(1)Static IP Address\t\t\t\tDisable\t\t|\n");
			printf("\t|\t(2)Dynamic IP Address\t\t\t\tEnable\t\t|\n");
			printf("\t|\t(3)PPP over Ethernet\t\t\t\tDisable\t\t|\n");
		}
		else
		{
			printf("\t|\t(1)Static IP Address\t\t\t\tDisable\t\t|\n");
			printf("\t|\t(2)Dynamic IP Address\t\t\t\tDisable\t\t|\n");
			printf("\t|\t(3)PPP over Ethernet\t\t\t\tEnable\t\t|\n");
		}
		printf("\t|\t(s)Save and Reset\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~3),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 's':
			//@@@ModifyBegin by KM 2002/10/05
			//setwan(0);
			//@@@ModifyEnd by KM 
			write_Aconfig(a);
			setwan(1);
			break;
		case '1':
			a->local.wtype=0;
			wanTypeStatic(a);
			break;
		case '2':
			a->local.wtype=1;
			system("clear");
			break;
		case '3':
			a->local.wtype=2;
			wanTypePPPoE(a);
			//system("clear");
			break;
		case 'b':
			system("clear");
			return 0;
			break;
		default:
			continue;
		};
	}

	return 1;
}
/*-----End WAN Tpye-----*/

/*-----Static IP Address Setting-----*/
int wanTypeStatic( ACONFIG * a)
{

	char command[80],ch,buf[3];
	int i,tempa,tempb,tempc,tempd;
	char *static_ip_title="Static IP Address";
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",static_ip_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\t(1)WAN IP Address\t%3d.%3d.%3d.%3d\t\t\t\t|\n",a->local.wip[0],a->local.wip[1],a->local.wip[2],a->local.wip[3]);
		printf("\t|\t(2)Subnet Mask\t\t%3d.%3d.%3d.%3d\t\t\t\t|\n",a->local.wnm[0],a->local.wnm[1],a->local.wnm[2],a->local.wnm[3]);
		printf("\t|\t(3)Getway\t\t%3d.%3d.%3d.%3d\t\t\t\t|\n",a->local.wgw[0],a->local.wgw[1],a->local.wgw[2],a->local.wgw[3]);
		printf("\t|\t(4)Primary DNS\t\t%3d.%3d.%3d.%3d\t\t\t\t|\n",a->acctpool[0].dns[0].ip[0],a->acctpool[0].dns[0].ip[1],a->acctpool[0].dns[0].ip[2],a->acctpool[0].dns[0].ip[3]);
		printf("\t|\t(5)Secondary DNS\t\t%3d.%3d.%3d.%3d\t\t\t\t|\n",a->acctpool[0].dns[1].ip[0],a->acctpool[0].dns[1].ip[1],a->acctpool[0].dns[1].ip[2],a->acctpool[0].dns[1].ip[3]);
		printf("\t|\t(s)Save and Reset\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~4),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 's':
			write_Aconfig(a);
			setwan(1);
			break;
		case '1':
			printf("IP:");
			fgets(command,80,stdin);
			getIP(command,a->local.wip);
			break;
		case '2':
			printf("Net mask:");
			fgets(command,80,stdin);
			getIP(command,a->local.wnm);
			break;
		case '3':
			printf("GW:");
			fgets(command,80,stdin);
			getIP(command, a->local.wgw);
			break;
		case '4':
		case '5':
			i=ch-'0'-4;
			printf("DNS:");
			fgets(command,80,stdin);
			getIP(command, a->acctpool[0].dns[i].ip);
			break;
		case 'b':
			system("clear");
			return 0;
			break;
		default:
			continue;
		};
	}

	return 1;
}
/*-----End Static IP Address Setting-----*/

/*----- PPPoE Setting-----*/
int wanTypePPPoE(ACONFIG * a)
{
	char command[80], ch, buf[4];
	int i, j, k;
	char *pppoe_title="PPPoE Setting";
	while(1)
	{
		system("clear");
		printf("%s", topLine);
		printf("\t\t\t\t%s\n", pppoe_title);
		printf("%s", topLine);
		printf("%s", line);
		printf("\t|\t(1)PPPoE Account\t%s\n", a->acctpool[a->local3.acct[0]].user);
		printf("\t|\t(2)PPPoE Password\t%s\n", a->acctpool[a->local3.acct[0]].pass);
		printf("\t|\t(3)Primary DNS\t\t%3d.%3d.%3d.%3d\n", a->acctpool[a->local3.acct[0]].dns[0].ip[0], a->acctpool[a->local3.acct[0]].dns[0].ip[1], a->acctpool[a->local3.acct[0]].dns[0].ip[2], a->acctpool[a->local3.acct[0]].dns[0].ip[3]);
		printf("\t|\t(4)Secondary DNS\t%3d.%3d.%3d.%3d\n", a->acctpool[a->local3.acct[0]].dns[1].ip[0], a->acctpool[a->local3.acct[0]].dns[1].ip[1], a->acctpool[a->local3.acct[0]].dns[1].ip[2], a->acctpool[a->local3.acct[0]].dns[1].ip[3]);
		printf("\t|\t(5)Maximum Idle Time\t%d seconds\n", a->acctpool[a->local3.acct[0]].to);
		printf("\t|\t(6)Auto-reconnect\t");
		if((a->acctpool[a->local3.acct[0]].flag & LFLAG_RENEWIP) == LFLAG_RENEWIP)
			printf("Enable\n");
		else
			printf("Disable\n");
		printf("\t|\t(7)PPPoE Service Name\t%s(optional)\n", a->acctpool[a->local3.acct[0]].tel);
		printf("\t|\t(8)Assigned IP Address\t%3d.%3d.%3d.%3d(optional)\n", a->acctpool[a->local3.acct[0]].ip[0], a->acctpool[a->local3.acct[0]].ip[1], a->acctpool[a->local3.acct[0]].ip[2], a->acctpool[a->local3.acct[0]].ip[3]);
		printf("%s",line);
		printf("\tPlease enter your choice (1~6),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case '1':
			printf("PPPoE Account:");
			fgets(command,80,stdin);
			command[strlen(command) - 1] = 0;
			strcpy(a->acctpool[a->local3.acct[0]].user, command);
			break;
		case '2':
			printf("PPPoE Password:");
			fgets(command, 80, stdin);
			command[strlen(command) - 1] = 0;
			strcpy(a->acctpool[a->local3.acct[0]].pass, command);
			break;
		case '3':
			printf("Primary DNS:");
			fgets(command, 80, stdin);
			command[strlen(command) - 1] = 0;
			for(i = k = 0; k < 4; k++)
			{
				for(j =0; command[i] != '.' && command[i] != 0; i++)
					j++;
				strncpy(buf, command + i - j, j);
				buf[j] = 0;
				a->acctpool[a->local3.acct[0]].dns[0].ip[k] = atoi(buf);
				i++;
			}
			break;
		case '4':
			printf("Secondary DNS:");
			fgets(command, 80, stdin);
			command[strlen(command) - 1] = 0;
			for(i = k = 0; k < 4; k++)
			{
				for(j =0; command[i] != '.' && command[i] != 0; i++)
					j++;
				strncpy(buf, command + i - j, j);
				buf[j] = 0;
				a->acctpool[a->local3.acct[0]].dns[1].ip[k] = atoi(buf);
				i++;
			}
			break;
		case '5':
			printf("Maximum Idle Time(in seconds):");
			fgets(command, 80, stdin);
			command[strlen(command) - 1] = 0;
			a->acctpool[a->local3.acct[0]].to = atoi(command);
			break;
		case '6':
			if((a->acctpool[a->local3.acct[0]].flag & LFLAG_RENEWIP) == LFLAG_RENEWIP)
				a->acctpool[a->local3.acct[0]].flag &= (~LFLAG_RENEWIP);
			else
				a->acctpool[a->local3.acct[0]].flag |= LFLAG_RENEWIP;
			break;
		case '7':
			printf("PPPoE Service Name:");
			fgets(command, 80, stdin);
			command[strlen(command) - 1] = 0;
			strcpy(a->acctpool[a->local3.acct[0]].tel, command);
			break;
		case '8':
			printf("Assigned IP Address:");
			fgets(command, 80, stdin);
			command[strlen(command) - 1] = 0;
			for(i = k = 0; k < 4; k++)
			{
				for(j = 0; command[i] != '.' && command[i] != 0; i++)
					j++;
				strncpy(buf, command + i - j, j);
				buf[j] = 0;
				a->acctpool[a->local3.acct[0]].ip[k] = atoi(buf);
				i++;
			}
			break;
		case 'b':
			system("clear");
			return 0;
			break;
		default:
			continue;
		};
	}
	return 1;
}
/*-----End PPPoE Setting-----*/

/*-----pptp Client Setting-----*/

int pptpClient(ACONFIG *a)
{
/*
	char name[9];
	char pswd[9];
	char ip[16];
	char buf[4];
	int i,temp;
	char *pptp_client_title="pptp Client";
	char command[80],ch;
	name[0]='\0';
	pswd[0]='\0';
	ip[0]='\0';
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",pptp_client_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\tName\t\tPassword\t\tIP\tstate\t\t|\n");
		for(i=0;i<5;i++)
		{
			if( pptpc_state[i] == 1)
				printf("\t|\t(%d)%-8s\t%-8s\t%3d.%3d.%3d.%3d\t  Connected\t|\n",i+1,a->pptpc[i].name,a->pptpc[i].pswd,a->pptpc[i].ip[0],a->pptpc[i].ip[1],a->pptpc[i].ip[2],a->pptpc[i].ip[3]);
			else
				printf("\t|\t(%d)%-8s\t%-8s\t%3d.%3d.%3d.%3d\t\t\t|\n",i+1,a->pptpc[i].name,a->pptpc[i].pswd,a->pptpc[i].ip[0],a->pptpc[i].ip[1],a->pptpc[i].ip[2],a->pptpc[i].ip[3]);
		}
		printf("\t|\t(C)Choose which to connect\t\t\t\t\t|\n");
		printf("\t|\t(s)Save setting\t\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~5) to modify or 'C' to connect,\n\tPress 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 's':
			write_Aconfig(a);
			break;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
			i=ch-'0'-1;
			printf("Name=");
			fgets(command,80,stdin);
			if(strlen(command)>10)
				continue;
			command[strlen(command)-1]='\0';
			strcpy(a->pptpc[i].name,command);
			printf("Password=");
			fgets(command,80,stdin);
			if(strlen(command)>10)
				continue;
			command[strlen(command)-1]='\0';
			strcpy(a->pptpc[i].pswd,command);
			printf("IP=");
			fgets(command,80,stdin);
			if(strlen(command)>16)
				continue;
			getIP(command,a->pptpc[i].ip);
			break;
		case 'C':
			printf("which pptpc[1-5]:");
			fgets(command,80,stdin);
			if(strlen(command)!=2)
				continue;
			ch=command[0];
			i=ch-'0'-1;
			temp=i;//pptpc number
			sprintf(ip,"%d.%d.%d.%d",a->pptpc[i].ip[0],a->pptpc[i].ip[1],a->pptpc[i].ip[2],a->pptpc[i].ip[3]);
// succ
                        strcpy(name,a->pptpc[i].name);
                        strcpy(pswd,a->pptpc[i].pswd);
                        pptpc_dial(ip,name,pswd);
// succ
			//---save to VPN status
			for(i=0;vpn.connections[i].enable==1;i++);
			strcpy(vpn.connections[i].name,a->pptpc[temp].name);
			strcpy(vpn.connections[i].pswd,a->pptpc[temp].pswd);
			vpn.connections[i].enable=1;
			vpn.connections[i].type=1;//pptpc
			memcpy(vpn.connections[i].ip,a->pptpc[temp].ip,4);
			name[0]='\0';
			pswd[0]='\0';
			ip[0]='\0';
			pptpc_state[temp]=1;//pptpc connected status
			break;
		case 'b':
			system("clear");
			return 0;
			break;
		default:
			continue;
		};
	}
	return 0;
*/
}
/*-----End pptp Client Setting-----*/
/*-----VPN status----*/
int vpnStatus(ACONFIG * a)
{
/*
	int i,j;
	int flag;
	char ch;
	char command[80];
	char *vps_status_title="VPN Status";

// succ 0515 for pptpc disconnect
        FILE *fd;
        unsigned char temp[20];
        unsigned char pid[10];
// succ
	l2tpStatus();//get the l2tp status
	while(1)
	{
		flag=0;
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",vps_status_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|Portocol\tIP\t\t\tName\t\tPassword\t|\n");
		printf("%s",line);
		for(i=0;i<5;i++)
		{
			if(vpn.connections[i].enable==0)
				continue;
			flag=1;
			if(vpn.connections[i].type==1)
				printf("\t|(%d)pptpc\t%3d.%3d.%3d.%3d\t\t%-10s\t%-10s\t|\n",i+1,vpn.connections[i].ip[0],vpn.connections[i].ip[1],vpn.connections[i].ip[2],vpn.connections[i].ip[3],vpn.connections[i].name,vpn.connections[i].pswd);
			else if(vpn.connections[i].type==2)
				printf("\t|(%d)pptpd\t%3d.%3d.%3d.%3d\t\t%-10s\t%-10s\t|\n",i+1,vpn.connections[i].ip[0],vpn.connections[i].ip[1],vpn.connections[i].ip[2],vpn.connections[i].ip[3],vpn.connections[i].name,vpn.connections[i].pswd);
			else if(vpn.connections[i].type==3)//lac
				printf("\t|(%d)L2TP\t%3d.%3d.%3d.%3d\t\t%-10s\t%-10s\t|\n",i+1,vpn.connections[i].ip[0],vpn.connections[i].ip[1],vpn.connections[i].ip[2],vpn.connections[i].ip[3],vpn.connections[i].name,vpn.connections[i].pswd);
		}
		if(flag==0)
			printf("\t|\t\t\t\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease choice the number to disconnect, or press 'b' to back\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
			i=ch-'0'-1;
			vpn.connections[i].name[0]='\0';
			vpn.connections[i].pswd[0]='\0';
			vpn.connections[i].enable=0;
// succ 0515 for pptpc disconnect
			if(vpn.connections[i].type == 1)//pptpc
			{
				pptpc_disc(i,&vpn);
				for(j=0;j<5;j++)
				{
					if( (!memcmp(vpn.connections[i].ip,a->pptpc[j].ip,4)) && (!strcmp(vpn.connections[i].name,a->pptpc[j].name)) )
						pptpc_state[j]=0;
				}
			}
			else if(vpn.connections[i].type == 2)
				;
			else if(vpn.connections[i].type == 3)
			{
				vpn.connections[i].enable=0;
				vpn.connections[i].name[0]='\0';
				vpn.connections[i].pswd[0]='\0';
				sprintf(command, "echo \"h %d \" > /var/run/l2tp-control",vpn.connections[i].cid);
				system(command);
				sprintf(command, "echo \"d %d \" > /var/run/l2tp-control",vpn.connections[i].tid);
				system(command);//disconnect
			}
			else if(vpn.connections[i].type == 4)
				;
// succ
			break;
		case 'b':
			return 0;
			break;
		default:
			continue;
		};
	}
*/
	return 1;
}
/*-----End VPN status-----*/

#ifdef L2TP
/*-----L2TP Server setting-----*/
int l2tpdMainMenu(ACONFIG *a)
{
	char command[80],ch,buf[3];
	int i,temp,flag;
	char *l2tp_title="L2TP Setting";
	FILE *fd;
	int tid, cid;//Tunnel id, Call id
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",l2tp_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\t\t\tLNS\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\t|\t(1)Local Virtual IP\t\t%3d.%3d.%3d.%3d\t\t\t|\n",L2TPSIP);
		printf("\t|\t(2)Static IP Pool from:\t%3d.%3d.%3d.%3d to:%3d.%3d.%3d.%3d\t|\n",L2TPSFROM,L2TPSTO);
		printf("\t|\t(3)Deny[1] LAC IP\t\t%3d.%3d.%3d.%3d\t\t\t|\n",L2TPSNO1);
		printf("\t|\t(4)Deny[2] LAC IP\t\t%3d.%3d.%3d.%3d\t\t\t|\n",L2TPSNO2);
		printf("\t|\t(5)Deny[3] LAC IP\t\t%3d.%3d.%3d.%3d\t\t\t|\n",L2TPSNO3);
		printf("\t|\t(6)Host Name for pppd\t\t%-10s\t\t\t|\n",a->l2tpd.lns.name);
		printf("%s",line);
		printf("\t|\t\t\tLAC\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\t|\t(7)Setup LAC\t\t\t\t\t\t\t|\n");
		printf("\t|\t(8)Choose which Amit to connect\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\t|\tLAC Amit\tLNS IP\t\tname\t\tpassword\t|\n");
		for(i=0;i<5;i++)
		{
			printf("\t|\t%d\t%3d.%3d.%3d.%3d\t\t%-8s\t%-8s\t|\n",i+1,L2TPCLIST,a->l2tpd.lac[i].name,a->l2tpd.lac[i].pswd);
		}
		printf("\t|\t(s)Save setting\t\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~8),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 's':
			write_Aconfig(a);//need to restart L2TP daemon!!
			break;
		case '1':
			printf("Local virtual ip(*.*.*.*):");
			fgets(command,80,stdin);
			getIP(command, a->l2tpd.lns.local_ip);
			break;
		case '2':
			printf("Static IP Pool from(1~254):");
			fgets(command,80,stdin);
			if(strlen(command)>4 || strlen(command) < 2)
				continue;
			command[strlen(command)-1]=0;
			temp=atoi(command);
			if(temp<1 || temp >254)
				continue;
			a->l2tpd.lns.ip_range_from=(BYTE)temp;
			printf("Static IP Pool to(1~254):");
			fgets(command,80,stdin);
			if(strlen(command)>4 || strlen(command) < 2)
				continue;
			command[strlen(command)-1]=0;
			temp=atoi(command);
			if(temp<1 || temp >254)
				continue;
			a->l2tpd.lns.ip_range_to=(BYTE)temp;
			if(a->l2tpd.lns.ip_range_from > a->l2tpd.lns.ip_range_to)//if from > to ,swap them
			{
				temp=a->l2tpd.lns.ip_range_to;
				a->l2tpd.lns.ip_range_to=a->l2tpd.lns.ip_range_from;
				a->l2tpd.lns.ip_range_from=temp;
			}
			break;
		case '3':
		case '4':
		case '5':
			i=ch-'0';
			i=i-3;
			printf("Set or Clean (S/C):");
			fgets(command,80,stdin);
			if(strlen(command)>2)
				continue;
			ch=command[0];
			if(ch=='C')
			{
				a->l2tpd.lns.no_lac[i].ip[0]=0;
				a->l2tpd.lns.no_lac[i].ip[1]=0;
				a->l2tpd.lns.no_lac[i].ip[2]=0;
				a->l2tpd.lns.no_lac[i].ip[3]=0;
			}
			else if(ch=='S')
			{
				printf("Deny LAC IP(*.*.*.*):");
				fgets(command,80,stdin);
				getIP(command, a->l2tpd.lns.no_lac[i].ip);
			}
			break;
		case '6':
			printf("Host Name for pppd:");
			fgets(command,80,stdin);
			if(strlen(command)>10)
				continue;
			command[strlen(command)-1]='\0';
			strcpy(a->l2tpd.lns.name,command);
			break;
		case '7'://setup LAC
			printf("Which LAC [1-5]?");
			fgets(command,80,stdin);
			if(strlen(command)>2)
				continue;
			command[strlen(command)-1]='\0';
			i=atoi(command);
			if(i<0 || i>5)
				continue;
			i--;
			printf("Please enter your LNS ip(*.*.*.*):");
			fgets(command,80,stdin);
			getIP(command, a->l2tpd.lac[i].peer);
			printf("Name?");
			fgets(command,80,stdin);
			if(strlen(command)>10)
				continue;
			command[strlen(command)-1]='\0';
			strcpy(a->l2tpd.lac[i].name,command);
			printf("Password?");
			fgets(command,80,stdin);
			if(strlen(command)>10)
				continue;
			command[strlen(command)-1]='\0';
			strcpy(a->l2tpd.lac[i].pswd,command);
			break;
		case '8'://connect LAC
			printf("Which LAC [1-5]?");
			fgets(command,80,stdin);
			if(strlen(command)>2)
				continue;
			command[strlen(command)-1]='\0';
			temp=atoi(command);
			if(temp<0 || temp>5)
				continue;
			temp--;//the LAC number
			//--- Connect
			sprintf(command,"iptables -t nat -D PREROUTING -d %d.%d.%d.%d -p udp --dport 1701 -j ACCEPT",a->local.wip[0],a->local.wip[1],a->local.wip[2],a->local.wip[3]);
			printf("%s\n",command);
			system(command);
			sprintf(command,"iptables -t nat -I PREROUTING -d %d.%d.%d.%d -p udp --dport 1701 -j ACCEPT",a->local.wip[0],a->local.wip[1],a->local.wip[2],a->local.wip[3]);
			printf("%s\n",command);
			system(command);
			fd=fopen(L2TP_AUTHNAME_FILE,"w");
			fprintf(fd,"%s\n",a->l2tpd.lac[temp].name);
			fclose(fd);
			i=temp;//the LAC number
			sprintf(command,"echo \"t %d.%d.%d.%d\" > /var/run/l2tp-control",L2TPCLIST);
			printf("%s\n",command);
			system(command);//creat Tunnel
			for(i=0,flag=0;i<5;i++)
			{
				if((fd=fopen("/var/run/l2tpd.tid","r"))==NULL )
				{
					fprintf(stdout,"Connection fail !");
					sleep(1);
					fprintf(stdout,"Try again times=%d\n",i+1);
					continue;
				}
				flag=1;
				break;
			}
			if(flag==0)//can't open file
			{
				printf("connection fail!");
				unlink(L2TP_AUTHNAME_FILE);
				sprintf(command,"iptables -t nat -D PREROUTING -d %d.%d.%d.%d -p udp --dport 1701 -j ACCEPT",a->local.wip[0],a->local.wip[1],a->local.wip[2],a->local.wip[3]);
				system(command);
				break;
			}
			fgets(command,80,fd);//read the Tunnel_id;
			fclose(fd);
			fprintf(stdout,"%s\n",command);
			command[strlen(command)-1]=0;
			tid=atoi(command);
			//---debug
			//printf("tid=%d\n",tid);
			//---end debug
			if(!unlink("/var/run/l2tpd.tid"))
				printf("unlink success\n");
			else
				printf("unlink error\n");
			sprintf(command,"echo \"c %d \" > /var/run/l2tp-control", tid);
			printf("%s\n",command);
			system(command);//creat Call

		//	if((fd=fopen("/var/run/l2tpd.csf","r"))==NULL )
		//	{
		//		fprintf(stdout,"open /var/run/l2tpd.csf fail !");
		//		sleep(2);
		//		break;
		//	}
		//	fgets(command,80,fd);
		//	if(command[0]='1')
		//	{
		//		sprintf(command, "echo \"h %d \" > /var/run/l2tp-control",cid);
		//		system(command);
		//		sprintf(command, "echo \"d %d \" > /var/run/l2tp-control",tid);
		//		system(command);//disconnect
		//	}
		//	else
		//	{
		//		fprintf(stdout,"Connection established successfully!");
				//---SAVE to the VPN status
				//for(i=0;vpn.connections[i].enable==1;i++);//find empty vpn connect [i]
				//strcpy(vpn.connections[i].name,a->l2tpd.lac[temp].name);//save name
				//strcpy(vpn.connections[i].pswd,a->l2tpd.lac[temp].pswd);//save password
				//memcpy(vpn.connections[i].ip,a->l2tpd.lac[temp].peer,4);//save LAC IP
				//vpn.connections[i].enable=1;
				//vpn.connections[i].type=3;//l2tpc
		//	}

			unlink(L2TP_AUTHNAME_FILE);
			//--- End Connect
			break;
		case 'b':
			system("clear");
			return 0;
			break;
		default:
			continue;
		};
	}
	return 0;
}
/*-----End L2TP Server setting-----*/
#endif

#ifdef IDS
/*-----IDS Setting-----*/
int idsMainMenu(ACONFIG * a)
{
	char command[80],ch;
	int i,temp;
	char *state[2]={"OFF",
			"ON",
			};
	char *ids_title="IDS Main Menu";
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",ids_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\tItem\t\t\t\t\tState\t\t\t|\n");
		printf("%s",line);
		i=(a->ids.flag[0]&0x01);
		printf("\t|\t(1)Snork\t\t\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[0]&0x02)>>1;
		printf("\t|\t(2)Smurf\t\t\t\t%3s\t\t\t|\n",state[i]);
		//i=(a->ids.flag[0]&0x04)>>2;
		//printf("\t|\t(3)Teardrop\t\t\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[0]&0x08)>>3;
		printf("\t|\t(3)Port Scan\t\t\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[0]&0x10)>>4;
		printf("\t|\t(4)UDP Bomb\t\t\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[0]&0x20)>>5;
		printf("\t|\t(5)SYN Flooding\t\t\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[0]&0x40)>>6;
		printf("\t|\t(6)Fraggle\t\t\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[0]&0x80)>>7;
		printf("\t|\t(7)Land Attack\t\t\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[1]&0x01);
		printf("\t|\t(8)ICMP Unreachable\t\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[1]&0x02)>>1;
		printf("\t|\t(9)Ping flooding\t\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[1]&0x04)>>2;
		printf("\t|\t(A)DNS Scan\t\t\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[1]&0x08)>>3;
		printf("\t|\t(B)http url block\t\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[1]&0x10)>>4;
		printf("\t|\t(C)Malicious Script\t\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[1]&0x20)>>5;
		printf("\t|\t(D)Virus scan\t\t\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[1]&0x40)>>6;
		printf("\t|\t(E)Mail Bomb - Address Block\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[1]&0x80)>>7;
		printf("\t|\t(F)Mail Bomb - Total number\t\t%3s\t\t\t|\n",state[i]);
		printf("\t|\t(s)Save and Rest\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~G),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 's':
			//@@@ModifyBegin by KM 2002/10/05
			//setids(0);
			write_Aconfig(a);
			setids(1);
			write_oldAconfig();
			//@@@ModifyEnd by KM 2002/10/05
			break;
		case '1'://Snork
			if((a->ids.flag[0]&0x01)==0x01)//OFF
				a->ids.flag[0]=a->ids.flag[0]&(~0x01);
			else//ON
				a->ids.flag[0]=a->ids.flag[0]|0x01;
			break;
		case '2'://smurf
			if((a->ids.flag[0]&0x02)==0x02)//OFF
				a->ids.flag[0]=a->ids.flag[0]&(~0x02);
			else//ON
				a->ids.flag[0]=a->ids.flag[0]|0x02;
			break;
		case '3'://port scan
			if((a->ids.flag[0]&0x08)==0x08)//OFF
				a->ids.flag[0]=a->ids.flag[0]&(~0x08);
			else//ON
				a->ids.flag[0]=a->ids.flag[0]|0x08;
			break;
		case '4'://udp bomb
			if((a->ids.flag[0]&0x10)==0x10)//OFF
				a->ids.flag[0]=a->ids.flag[0]&(~0x10);
			else//ON
				a->ids.flag[0]=a->ids.flag[0]|0x10;
			break;
		case '5'://SYN flooding
			if((a->ids.flag[0]&0x20)==0x20)//OFF
				a->ids.flag[0]=a->ids.flag[0]&(~0x20);
			else//ON
				a->ids.flag[0]=a->ids.flag[0]|0x20;
			break;
		case '6'://fraggle
			if((a->ids.flag[0]&0x40)==0x40)//OFF
				a->ids.flag[0]=a->ids.flag[0]&(~0x40);
			else//ON
				a->ids.flag[0]=a->ids.flag[0]|0x40;
			break;
		case '7'://land attack
			if((a->ids.flag[0]&0x80)==0x80)//OFF
				a->ids.flag[0]=a->ids.flag[0]&(~0x80);
			else//ON
				a->ids.flag[0]=a->ids.flag[0]|0x80;
			break;
		case '8'://icmp unreachable
			if((a->ids.flag[1]&0x01)==0x01)//OFF
				a->ids.flag[1]=a->ids.flag[1]&(~0x01);
			else//ON
				a->ids.flag[1]=a->ids.flag[1]|0x01;
			break;
		case '9'://icmp flooding
			if((a->ids.flag[1]&0x02)==0x02)//OFF
				a->ids.flag[1]=a->ids.flag[1]&(~0x02);
			else//ON
				a->ids.flag[1]=a->ids.flag[1]|0x02;
			break;
		case 'A'://dns
			dnsMainMenu(a);
			//if((a->ids.flag[1]&0x04)==0x04)//OFF
			//	a->ids.flag[1]=a->ids.flag[1]&(~0x04);
			//else//ON
			//	a->ids.flag[1]=a->ids.flag[1]|0x04;
			break;
		case 'B'://http url block
			urlblockMainMenu(a);
			break;
		case 'C'://malicious script
			mscriptMainMenu(a);
			//if((a->ids.flag[1]&0x10)==0x10)//OFF
			//	a->ids.flag[1]=a->ids.flag[1]&(~0x10);
			//else//ON
			//	a->ids.flag[1]=a->ids.flag[1]|0x10;
			break;
		case 'D'://virus
			virusScanMainMenu(a);
			//if((a->ids.flag[1]&0x20)==0x20)//OFF
			//	a->ids.flag[1]=a->ids.flag[1]&(~0x20);
			//else//ON
			//	a->ids.flag[1]=a->ids.flag[1]|0x20;
			break;
		case 'E'://mail bomb1
			mailblockMainMenu(a);
			//if((a->ids.flag[1]&0x40)==0x40)//OFF
			//	a->ids.flag[1]=a->ids.flag[1]&(~0x40);
			//else//ON
			//	a->ids.flag[1]=a->ids.flag[1]|0x40;
			break;
		case 'F'://mail bomb2
			mailblockMainMenu(a);
			//if((a->ids.flag[1]&0x80)==0x80)//OFF
			//	a->ids.flag[1]=a->ids.flag[1]&(~0x80);
			//else//ON
			//	a->ids.flag[1]=a->ids.flag[1]|0x80;
			break;
		case 'b':
			return 0;
		default:
			continue;
		};
	}
	return 0;
}
/*-----End IDS Setting-----*/
#endif


/*-----Get IP-----*/
int getIP(char * command, BYTE *ip)
{
	char * temp;
	char buf[3];
	int i, x;
	command[strlen(command)-1]='\0';//use "fgets" need to ignore '\n'
	i=strlen(command);
	if(i>15 || i<7)
		return 0;//check len 7~15
	temp=command;
	for(x=0;x<4;x++)
	{
		i=0;
		while(*temp != '.' && *temp!='\0')
		{
			buf[i]=*temp;
			i++;
			temp++;
		}
		temp++;
		buf[i]='\0';
		i=atoi(buf);
		if(i<0 || i>255)
			return 0;//error value
		*(ip+x)=(BYTE)i;
	}
	return 1;
}
/*-----End Get IP-----*/

/*-----Get Port-----*/
int getPort(char * command, WORD *port)
{
	int temp;
	command[strlen(command)-1]='\0';//use "fgets" need to ignore '\n'
	temp=strlen(command);
	if(temp==0 || temp >5)
		return 0; //check len 1~5
	temp=atoi(command);
	if(temp<0 || temp >65535)
		return 0;//overflow
	*port=(WORD)temp;
	return 1;
}
/*-----End Get Port-----*/

/*-----Get IP range-----*/
int getIPrange(char * command, BYTE *ip)
{
	int i;
	command[strlen(command)-1]='\0';//use "fgets" need to ignore '\n'
	i=strlen(command);
	if(i==0 || i>3)
		return 0; //check len 1~3
	i=atoi(command);
	if(i<0 || i>255)
		return 0;//error value
	*ip=(BYTE)i;
	return 1;
}
/*-----End Get IP range-----*/

/*-----Access Control Show String-----*/
//type 0 -> IP
//type 1 -> Port
int actlShowStr(char *str, char type, int group ,ACONFIG *a)
{
/*
	int temp;
	char buf[6]="00000";
	int i,j;
	if(type=='0')
	{
		for(i=0;i<16;i++)
		{
			if(a->actl2[group].ip[i].sip==a->actl2[group].ip[i].eip && a->actl2[group].ip[i].sip!=0)
			{
				sprintf(buf,"%d",a->actl2[group].ip[i].sip);
				strcat(str,buf);
				strcat(str,",");
			}
			else
			{
				temp=a->actl2[group].ip[i].sip;
				if(temp==0)
					continue;
				temp=a->actl2[group].ip[i].eip;
				if(temp==0)
					continue;
				sprintf(buf,"%d",a->actl2[group].ip[i].sip);
				strcat(str,buf);
				strcat(str,"-");
				sprintf(buf,"%d",a->actl2[group].ip[i].eip);
				strcat(str,buf);
				strcat(str,",");
			}
		}
	}
	else
	{
		for(i=0;i<16;i++)
		{
			if(a->actl2[group].port[i].sp==a->actl2[group].port[i].ep && a->actl2[group].port[i].sp!=0)
			{
				sprintf(buf,"%d",a->actl2[group].port[i].sp);
				strcat(str,buf);
				strcat(str,",");

			}
			else
			{
				temp=a->actl2[group].port[i].sp;
				if(temp==0)
					continue;
				temp=a->actl2[group].port[i].ep;
				if(temp==0)
					continue;
				sprintf(buf,"%d",a->actl2[group].port[i].sp);
				strcat(str,buf);
				strcat(str,"-");
				sprintf(buf,"%d",a->actl2[group].port[i].ep);
				strcat(str,buf);
				strcat(str,",");
			}
		}
	}
*/
	return 1;
}
/*-----End Access Control Show String-----*/

/* succ */ /* access control */
/* type 0 : IP   */
/* type 1 : port */
void acparser(char *a,char type,int group,ACONFIG *aconf)
{
/*
  int head = 0, tail = 1;
  int tlen;
  int i,j,flag;
  int mark = 0;
  int index = 0;
  char temp[10];

  tlen = strlen(a);
  flag=1;

  while(head<tlen)
  {

    for(j=tail ; a[j]!=',' && a[j]!='\0' ; j++) tail += 1;

    i = 0;

    for(j=head ; j <= tail ; j++)
    {
      if(a[j] != ',' && a[j] != '-' && a[j] != '\0') {
        temp[i++] = a[j];
        continue;
      } else if(a[j] == ',' || a[j] == '\0')
      {
        //fprintf(stderr,"[%s]\n",temp);
	if(atoi(temp)==0)
	{
		flag=0;
		break;
	}
	else
		flag=1;
	if(type == 0) {
          if(mark == 0) {
            aconf->actl2[group].ip[index].sip = (BYTE)atoi(temp);
            aconf->actl2[group].ip[index].eip = (BYTE)atoi(temp);
          } else {
	    aconf->actl2[group].ip[index].eip = (BYTE)atoi(temp);
          }
        } else//type=1
        {
          if(mark == 0) {
            aconf->actl2[group].port[index].sp  = (WORD)atoi(temp);
            aconf->actl2[group].port[index].ep  = (WORD)atoi(temp);
          } else {
            aconf->actl2[group].port[index].ep  = (WORD)atoi(temp);
          }
        }
        break;
      } else if(a[j] == '-')
      {
	mark = 1;
        //fprintf(stderr,"[%s]-",temp);
	if(atoi(temp)==0)
	{
		flag=0;
		break;
	}
	else
		flag=1;
        if(type == 0) {
            aconf->actl2[group].ip[index].sip  = (BYTE)atoi(temp);
        } else {
            aconf->actl2[group].port[index].sp   = (WORD)atoi(temp);
        }
	//
        i = 0;
        continue;
      }
    }

    head = tail+1;
    tail += 2;
    mark = 0;
    index+=flag;
  }
  for(i=index;i<16;i++)
  {
	if(type==0)
	{
		aconf->actl2[group].ip[i].sip=0;
		aconf->actl2[group].ip[i].eip=0;
	}
	else
	{
		aconf->actl2[group].port[i].sp=0;
		aconf->actl2[group].port[i].ep=0;
	}
  }
  for(i=0;i<16;i++)
  {
	if(type==0)
	{	//if start > end, swap them.
		if(aconf->actl2[group].ip[i].sip > aconf->actl2[group].ip[i].eip)
		{
			j = aconf->actl2[group].ip[i].sip;
			aconf->actl2[group].ip[i].sip = aconf->actl2[group].ip[i].eip;
			aconf->actl2[group].ip[i].eip = j;
		}
	}
	else
	{
		if(aconf->actl2[group].port[i].sp > aconf->actl2[group].port[i].ep )
		{
			j = aconf->actl2[group].port[i].sp;
			aconf->actl2[group].port[i].sp = aconf->actl2[group].port[i].ep;
			aconf->actl2[group].port[i].ep = j;
		}
	}
  }
  */
}

/* succ */

#ifdef L2TP
/* **************** */
/* read L2TP status */
/* 0:error          */
/* 1:success        */
/* **************** */
int l2tpStatus(void)
{
	FILE * fd;
	char num[10],buf[100],ip_buf[22];
	char *temp;
	int i,flag,tid,cid;
	BYTE ip[4];
	flag=0;
	system("echo \"s\" > /var/run/l2tp-control");
	for(i=0,flag=0;i<5;i++)
	{
		if((fd=fopen(L2TP_STATE_FILE,"r"))==NULL)
		{
			//printf("can't read file \n");
			//printf("try again times=%d\n",i+1);
			sleep(1);
			continue;
		}
		flag=1;
		break;
	}
	if(flag==0)//can't open file
		return 0;
	flag=0;//no read tid
	//printf("c\n\n");
	while(fgets(buf,100,fd)!=NULL)
	{
		if((temp=strstr(buf,"Tunnel , ID = "))!=NULL)//read Tunnel ID & remote IP
		{
			//printf("d\n\n");
			temp+=14;
			i=0;
			while(*temp != ' ')//save tid
			{
				num[i++]=*temp;
				temp++;
			}
			num[i]='\0';
			tid=atoi(num);
			//printf("tid=%d\n\n",tid);
			temp=buf+(strlen(buf)-1);
			//printf("1\n\n");
			while(*temp != ' ')
				temp=temp-1;
			//printf("2\n\n");
			//printf("temp=%s.\n\n",temp);
			i=0;
			temp=temp+1;
			while((*temp) != ':')//save remote IP
			{
				//printf("x\n\n");
				ip_buf[i++]=*temp;
				temp++;
			}
			//printf("3\n\n");
			ip_buf[i]='\n';
			ip_buf[i+1]=0;
			//printf("ip=%s\n",ip_buf);
			getIP(ip_buf,ip);
		}
		//printf("e\n\n");
		if((temp=strstr(buf,"Call , ID = "))!=NULL)//read Call ID
		{
			printf("f\n\n");
			temp+=12;
			i=0;
			while(*temp != ' ')//save cid
			{
				num[i++]=*temp;
				temp++;
			}
			num[i]=0;
			cid=atoi(num);
			for(i=0;vpn.connections[i].enable==1;i++);//find empty vpn connect [i]
			strcpy(vpn.connections[i].name,"*");
			strcpy(vpn.connections[i].pswd,"*");
			memcpy(vpn.connections[i].ip,ip,4);
			vpn.connections[i].enable=1;
			vpn.connections[i].type=3;
			vpn.connections[i].tid=tid;
			vpn.connections[i].cid=cid;
		}
		//printf("g\n\n");
	}//while end
	fclose(fd);
	return 1;
}
#endif


/*-----ip information-----*/
/*  0:error               */
/*  1:success             */
int ipinfo(char *name, ip_info_struct * ife)
{
	FILE *fd;
	char buf[80],temp[20];
	char *pt;
	int i,flag;
	int find = 0;	// use this var to specify we get the interface or not.
	//----set ip info
	system("ifconfig > /var/config/ife.conf");
	//----End

	sleep(1);
	for(i=0;i<5;i++)
	{
		if((fd=fopen("/var/config/ife.conf","r"))==NULL)
		{
			sleep(1);
			continue;
		}
		flag=1;
		break;
	}
	if(flag==0)
	{
		printf("can't open file");
		return 0;
	}
	flag=0;
	while(fgets(buf,80,fd)!=NULL)
	{
		if((pt=strstr(buf,name))!=NULL && flag==0)
		{
			strcpy(ife->name,name);
			flag=1;
			find = 1;
			if((pt=strstr(buf,"HWaddr "))!=NULL)
			{
				pt=pt+7;
				i=0;
				while(*pt!='\n')
				{
					temp[i++]=*pt;
					pt++;
				}
				temp[i]='\0';
				strcpy(ife->HWaddr,temp);
			}
		}
		if(flag==1)//get the interface at pt
		{
			if((pt=strstr(buf,"addr:"))!=NULL)
			{
				pt=pt+5;
				i=0;
				while(*pt!=' ')
				{
					temp[i++]=*pt;
					pt++;
				}
				temp[i]='\n';
				temp[i+1]='\0';
				getIP(temp,ife->ip);
				flag=0;
			}
			if((pt=strstr(buf,"Bcast:"))!=NULL)
			{
				pt=pt+6;
				i=0;
				while(*pt!=' ')
				{
					temp[i++]=*pt;
					pt++;
				}
				temp[i]='\n';
				temp[i+1]='\0';
				getIP(temp,ife->bcast);
			}
			if((pt=strstr(buf,"Mask:"))!=NULL)
			{
				pt=pt+5;
				i=0;
				//while(*pt!=' ')
				while (*pt > ' ')		//hsujp
				{
					temp[i++]=*pt;
					pt++;
				}
				temp[i]='\n';
				temp[i+1]='\0';
				getIP(temp,ife->mask);
			}
		}
	}
	fclose(fd);
	unlink("/var/config/ife.conf");
	if(!find)	// we cannot find the interface, so we store some information into ife to express.
	{
		// interface
		sprintf(ife->name, "none");
		// ip
		sprintf(temp, "0.0.0.0\n");
		getIP(temp, ife->ip);
		// netmask
		sprintf(temp, "255.255.255.255\n");
		getIP(temp, ife->mask);
		// broadcast
		sprintf(temp, "0.0.0.0\n");
		getIP(temp, ife->bcast);
		// ether addr
		sprintf(ife->HWaddr, "Cannot used!");
	}
	return 1;
}
/*-----End ip information-----*/



#ifdef IDS
/*-----url block Main Menu----*/
int urlblockMainMenu(ACONFIG * a)
{
	char command[80],ch;
	int i,temp;
	char *state[2]={"Disable",
			"Enable",
			};
	char *title="http URL blocking Main Menu";
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",title);
		printf("%s",topLine);
		printf("%s",line);
		i=(a->ids.flag[1]&0x08)>>3;
		printf("\t|\t(1)State\t\t\t\t%7s\t\t\t|\n",state[i]);
		printf("\t|\t(2)Proxy port\t\t\t\t%d\t\t\t|\n",a->ids.urlblock.proxy);
		printf("\t|\t(3)Edit url list\t\t\t\t\t\t|\n");
		printf("\t|\t(s)Save and Rest\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~G),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 's':
			if((a->ids.flag[1]&0x08)==0x08)
			{//ON
				setids_urlblock(0);
				write_Aconfig(a);
				setids_urlblock(1);
			}
			else
			{//OFF
				setids_urlblock(0);
				write_Aconfig(a);
			}
			break;
		case '1':
			if((a->ids.flag[1]&0x08)==0x08)
			{//OFF
				a->ids.flag[1]=a->ids.flag[1]&(~0x08);
			}
			else
			{//ON
				a->ids.flag[1]=a->ids.flag[1]|0x08;
			}
			break;
		case '2':
			printf("Proxy Port[1~65536]:");
			fgets(command,80,stdin);
			getPort(command,&(a->ids.urlblock.proxy));
			break;
		case '3':
			urlblocklist(a);
			break;
		case 'b':
			return 0;
		default:
			continue;
		}//switch end
	}//while end
	return 0;
}
/*-----End url block Main Menu----*/

/*-----url block list-----*/
int urlblocklist(ACONFIG *a)
{
	char command[80],ch;
	int i,page,temp;
	char *line="+-----------------------------------------------------------------------+\n";
	char *title="http URL blocking list";
	page =0;
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t%s\n",title);
		printf("%s",topLine);
		printf("%s",line);
		for(i=0;i<10;i++)
			printf("(%d)%-80s\n",page*10+(i+1),a->ids.urlblock.url[page*10+i].string);
		printf("[Page%2d]\t\t\t\t\t\t\n",page+1);
		printf("%s",line);
		printf("|(U)page up\t\t\t\t\t\t\t\t|\n");
		printf("|(D)page down\t\t\t\t\t\t\t\t|\n");
		printf("|(G)Go page?\t\t\t\t\t\t\t\t|\n");
		printf("|(a)Add new URL\t\t\t\t\t\t\t\t|\n");
		printf("|(d)Delete a URL\t\t\t\t\t\t\t|\n");
		//printf("|(s)Save and Rest\t\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~G),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 'D':
			//@@@ModifyBegin by KM 2002/10/05
			if(page==((URL_NUM/10)-1))
			//@@@ModifyEnd by KM
				page=-1;
			page=page+1;
			break;
		case 'U':
			if(page==0)
			//@@@ModifyBegin by KM 2002/10/05
				page=URL_NUM/10;
			//@@@ModifyEnd by KM
			page=page-1;
			break;
		case 'G':
			printf("go to page?");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			temp=atoi(command);
			//@@@ModifyBegin by KM 2002/10/05
			if(temp<1 || temp>(URL_NUM/10))
			//@@@ModifyEnd
				continue;
			page=temp-1;
			break;
		case 'a':
			printf("url:");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			add_url(a,command);
			break;
		case 'd':
			printf("delet which?");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			del_url(a, atoi(command));
			break;
		case 'b':
			return 0;
		default:
			continue;
		}//switch end
	}//while end
	return 0;
}
/*-----url block list-----*/
#endif


/* *********** */
/* find getway */
/* *********** */

int htoi_GW(char *src, int len)
{
	int i;
	int result;

	for(result = 0, i = 0; i < len; i++)
	{
		if(src[i] >= '0' && src[i] <= '9')
			result += (src[i] - '0') * (i == len - 1 ? 1 : 16 * (len - i - 1));
		else
			result += (src[i] - 'A' + 10) * (i == len - 1 ? 1 : 16 * (len - i - 1));
	}

	return result;
}


int findGW(ip_info_struct * ife)
{
	FILE *route;
	FILE *gw;
	char buffer[129];
	int before_pos;
	int index;
#ifdef DEBUG
	char temp[9];
#endif

	route = fopen(ROUTE_PATH, "r");
	if(route == NULL)
	{
		fclose(route);
#ifdef DEBUG
		fprintf(stderr, "%s: Cannot open file \"%s\".\n", argv[0], ROUTE_PATH);
#endif
		return 0;
	}

	fseek(route, 128L, SEEK_SET);
	before_pos = ftell(route);

	fgets(buffer, 129, route);
	while(strlen(buffer) != 0)
	{
		if(ftell(route) == before_pos)
		{
#ifdef DEBUG
			fprintf(stderr, "%s: Reach the end of file.\n", argv[0]);
#endif
			break;
		}
		else
		{
			before_pos = ftell(route);
		}

		index = 0;
		while(buffer[index] != '\t')
			index++;
		index++;
#ifdef DEBUG
		strncpy(temp, buffer + index, 8);
		temp[8] = 0;
		fprintf(stderr, "%s: We may get the string of destination: %s.\n", argv[0], temp);
#endif
		if(strncmp(buffer + index, "00000000", 8))
		{
#ifdef DEBUG
			fprintf(stderr, "%s: %s is not the default destination.\n", argv[0], temp);
#endif
			fgets(buffer, 129, route);
			continue;
		}
		else
		{
#ifdef DEBUG
			fprintf(stderr, "%s: We get the default destination.\n", argv[0]);
#endif
			while(buffer[index] != '\t')
				index++;
			index++;
#ifdef DEBUG
			gw = fopen(GW_PATH, "w");
			fprintf(gw, "%d.%d.%d.%d", htoi_GW(buffer + index + 6, 2), htoi_GW(buffer + index + 4, 2), htoi_GW(buffer + index + 2, 2), htoi_GW(buffer + index, 2));
			fclose(gw);
#endif
#if  ARM_MIPS
			ife->gw[0]=htoi_GW(buffer + index, 2);
			ife->gw[1]=htoi_GW(buffer + index + 2, 2);
			ife->gw[2]=htoi_GW(buffer + index + 4, 2);
			ife->gw[3]=htoi_GW(buffer + index + 6, 2);
#else
			ife->gw[0]=htoi_GW(buffer + index + 6, 2);
			ife->gw[1]=htoi_GW(buffer + index + 4, 2);
			ife->gw[2]=htoi_GW(buffer + index + 2, 2);
			ife->gw[3]=htoi_GW(buffer + index, 2);
#endif
			break;
		}
	}
	fclose(route);
	return 1;
}


#ifdef IDS
/*-----virus scan Main Menu----*/
int virusScanMainMenu(ACONFIG * a)
{
	char command[80],ch;
	int i,temp;
	char *state[2]={"Disable",
			"Enable",
			};
	char *title="Virus Scan Main Menu";
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",title);
		printf("%s",topLine);
		printf("%s",line);
		i=(a->ids.flag[1]&0x20)>>5;
		printf("\t|\t(1)State\t\t\t\t%7s\t\t\t|\n",state[i]);
		printf("\t|\t(2)Edit virus list\t\t\t\t\t\t|\n");
		printf("\t|\t(s)Save and Rest\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~G),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 's':
			if((a->ids.flag[1]&0x20)==0x20)
			{
			//ON
				//fprintf(stdout,"1\n");
				setids_virusscan(0);
				//fprintf(stdout,"2\n");
				write_Aconfig(a);
				//fprintf(stdout,"3\n");
				setids_virusscan(1);
				//fprintf(stdout,"4\n");
			}
			else
			{//OFF
				//printf("5\n");
				setids_virusscan(0);
				//printf("6\n");
				write_Aconfig(a);
				//printf("7\n");
			}
			break;
		case '1':
			if((a->ids.flag[1]&0x20)==0x20)
				a->ids.flag[1]=a->ids.flag[1]&(~0x20);//turn OFF
			else
				a->ids.flag[1]=a->ids.flag[1]|0x20;//turn ON
			break;
		case '2':
			viruslist(a);
			break;
		case 'b':
			return 0;
		default:
			continue;
		}//switch end
	}//while end
	return 0;
}
/*-----End virus scan Main Menu----*/

/*-----virus pattern list-----*/
int viruslist(ACONFIG *a)
{
	char command[80],ch;
	int i,page,temp;
	char *line="+-----------------------------------------------------------------------+\n";
	char *title="Virus Pattern list";
	int protocol;
	int port;
	page =0;
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t%s\n",title);
		printf("%s",topLine);
		printf("%s",line);
		printf(" protocal\tport\t\t\tpattern\n");
		for(i=0;i<10;i++)
		{
			if ( a->ids.virus[page*10+i].pattern[0] == 0 )
				printf("(%d)\n", page*10+(i+1));
			else
			{
				if(a->ids.virus[page*10+i].protocol == 0)
					printf("(%d)tcp %5d %-80s\n",page*10+(i+1),a->ids.virus[page*10+i].port,a->ids.virus[page*10+i].pattern);
				else
					printf("(%d)udp %5d %-80s\n",page*10+(i+1),a->ids.virus[page*10+i].port,a->ids.virus[page*10+i].pattern);
			}
		}
		printf("[Page%2d]\t\t\t\t\t\t\n",page+1);
		printf("%s",line);
		printf("|(U)page up\t\t\t\t\t\t\t\t|\n");
		printf("|(D)page down\t\t\t\t\t\t\t\t|\n");
		printf("|(G)Go page?[1~5]\t\t\t\t\t\t\t|\n");
		printf("|(a)Add new virus pattern\t\t\t\t\t\t|\n");
		printf("|(d)Delete a virus pattern\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~G),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 'D':
			//@@@ModifyBegin by KM 2002/10/05
			if(page==((VIRUS_PATTERN_NUM/10)-1))
			//@@@ModifyEnd by KM
				page= -1;
			page=page+1;
			break;
		case 'U':
			if(page==0)
			//@@@ModifyBegin by KM 2002/10/05
				page=(VIRUS_PATTERN_NUM/10);
			//@@@ModifyEnd by KM
			page=page-1;
			break;
		case 'G':
			printf("go to page?");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			temp=atoi(command);
			//@@@ModifyBegin by KM 2002/10/05
			if(temp<1 || temp>(VIRUS_PATTERN_NUM/10))
			//@@@ModifyEnd by KM
				continue;
			page=temp-1;
			break;
		case 'a':
			printf("protocal (0)tcp or (1)udp?[0/1]");
			fgets(command,80,stdin);
			if(strlen(command)>2)
				continue;
			command[strlen(command)-1]=0;
			protocol = atoi(command);
			printf("port [1~65535]?");
			fgets(command,80,stdin);
			if(strlen(command)>6)
				continue;
			command[strlen(command)-1]=0;
			port = atoi(command);
			printf("pattern?");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			if(add_virus(a,protocol,port,command))
				printf("Add success\n");
			else
				printf("Add error\n");
			break;
		case 'd':
			printf("delet which?");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			if(del_virus(a, atoi(command)))
				printf("Delet success");
			else
				printf("Delet error");
			break;
		case 'b':
			return 0;
		default:
			continue;
		}//switch end
	}//while end
	return 0;
}
/*-----End virus pattern list-----*/
#endif

#ifdef IDS
/*-----DNS Main Menu----*/
int dnsMainMenu(ACONFIG * a)
{
	char command[80],ch;
	int i,temp;
	char *state[2]={"Disable",
			"Enable",
			};
	char *title="DNS Main Menu";
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",title);
		printf("%s",topLine);
		printf("%s",line);
		i=(a->ids.flag[1]&0x04)>>2;
		printf("\t|\t(1)State\t\t\t\t%7s\t\t\t|\n",state[i]);
		printf("\t|\t(2)WAN DNS\t\t\t%3d.%3d.%3d.%3d\t\t\t|\n",
			a->ids.dns_scan.wan_dns[0],
			a->ids.dns_scan.wan_dns[1],
			a->ids.dns_scan.wan_dns[2],
			a->ids.dns_scan.wan_dns[3]);
		printf("\t|\t(3)LAN DNS\t\t\t%3d.%3d.%3d.%3d\t\t\t|\n",
			a->local.rhip[0],
			a->local.rhip[1],
			a->local.rhip[2],
			a->ids.dns_scan.lan_dns);
		printf("\t|\t(s)Save and Rest\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~3),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 's':
			if((a->ids.flag[1]&0x04)==0x04)
			{//ON
				setids_dns(0);
				write_Aconfig(a);
				setids_dns(1);
			}
			else
			{//OFF
				setids_dns(0);
				write_Aconfig(a);
			}
			break;
		case '1':
			if((a->ids.flag[1]&0x04)==0x04)
			{//OFF
				a->ids.flag[1]=a->ids.flag[1]&(~0x04);
			}
			else
			{//ON
				a->ids.flag[1]=a->ids.flag[1]|0x04;
			}
			break;
		case '2':
			printf("WAN DNS?[x.x.x.x]");
			fgets(command,80,stdin);
			getIP(command,a->ids.dns_scan.wan_dns);
			break;
		case '3':
			printf("LAN DNS?%d.%d.%d.",
			a->local.rhip[0],
			a->local.rhip[1],
			a->local.rhip[2]);
			fgets(command,80,stdin);
			if(strlen(command) <2 || strlen(command) >6)
				continue;
			command[strlen(command)-1]=0;
			temp=atoi(command);
			if(temp <1 || temp >254)
				continue;
			a->ids.dns_scan.lan_dns=temp;
			break;
		case 'b':
			return 0;
		default:
			continue;
		}//switch end
	}//while end
	return 0;
}
/*-----End DNS Main Menu----*/
#endif

#ifdef IDS
/*-----Malicious Script Main Menu----*/
int mscriptMainMenu(ACONFIG * a)
{
	char command[80],ch;
	int i,temp;
	char *state[2]={"Disable",
			"Enable",
			};
	char *title="Malicious Script Main Menu";
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",title);
		printf("%s",topLine);
		printf("%s",line);
		i=(a->ids.flag[1]&0x10)>>4;
		printf("\t|\t(1)State\t\t\t\t%7s\t\t\t|\n",state[i]);
		printf("\t|\t(2)Proxy port\t\t\t\t%d\t\t\t|\n",a->ids.mscript_proxy);
		printf("\t|\t(s)Save and Rest\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~3),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 's':
			if((a->ids.flag[1]&0x10)==0x10)
			{//ON
				setids_mscript(0);
				write_Aconfig(a);
				setids_mscript(1);
			}
			else
			{//OFF
				setids_mscript(0);
				write_Aconfig(a);
			}
			break;
		case '1':
			if((a->ids.flag[1]&0x10)==0x10)
			{//OFF
				a->ids.flag[1]=a->ids.flag[1]&(~0x10);
			}
			else
			{//ON
				a->ids.flag[1]=a->ids.flag[1]|0x10;
			}
			break;
		case '2':
			printf("Proxy?[0~65535]");
			fgets(command,80,stdin);
			getPort(command,&(a->ids.mscript_proxy));
			break;
		case 'b':
			return 0;
		default:
			continue;
		}//switch end
	}//while end
	return 0;
}
/*-----End Malicious Script Main Menu----*/
#endif

#ifdef IDS
/*-----mail address Main Menu----*/
int mailblockMainMenu(ACONFIG * a)
{
	char command[80],ch;
	int i,temp;
	char *state[2]={"Disable",
			"Enable",
			};
	char *title="Mail Bomb Main Menu";
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",title);
		printf("%s",topLine);
		printf("%s",line);
		i=(a->ids.flag[1]&0x40)>>6;
		printf("\t|\t(1)Mail address block State\t\t%7s\t\t\t|\n",state[i]);
		printf("\t|\t(2)Edit address list\t\t\t\t\t\t|\n");
		i=(a->ids.flag[1]&0x80)>>7;
		printf("\t|\t(3)Mail flow control State\t\t%7s\t\t\t|\n",state[i]);
		printf("\t|\t(4)Alow total number of sender a day\t\t%d\t\t|\n",a->ids.mbomb2.total_sender);
		printf("\t|\t(5)Alow total number of mails a day\t\t%d\t\t|\n",a->ids.mbomb2.total_mails);
		printf("\t|\t(s)Save and Rest\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~5),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 's':
			if(((a->ids.flag[1]&0x40)==0x40)  || ((a->ids.flag[1]&0x80)==0x80) )
			{//mbomb1 on
				setids_mailblock(0);
				write_Aconfig(a);
				setids_mailblock(1);
			}
			else
			{//OFF
				setids_mailblock(0);
				write_Aconfig(a);
			}
			break;
		case '1':
			if((a->ids.flag[1]&0x40)==0x40)
			{//OFF
				a->ids.flag[1]=a->ids.flag[1]&(~0x40);
			}
			else
			{//ON
				a->ids.flag[1]=a->ids.flag[1]|0x40;
			}
			break;
		case '2':
			mailblocklist(a);
			break;
		case '3':
			if((a->ids.flag[1]&0x80)==0x80)
			{//OFF
				a->ids.flag[1]=a->ids.flag[1]&(~0x80);
			}
			else
			{//ON
				a->ids.flag[1]=a->ids.flag[1]|0x80;
			}
			break;
		case '4':
			printf("total number of sender?[0~65535]");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			if(strlen(command)< 1 || strlen(command) > 5)
				continue;
			temp=atoi(command);
			if(temp <0 || temp >65535)
				continue;
			a->ids.mbomb2.total_sender=temp;
			break;
		case '5':
			printf("total number of sender?[0~65535]");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			if(strlen(command)< 1 || strlen(command) > 5)
				continue;
			temp=atoi(command);
			if(temp <0 || temp >65535)
				continue;
			a->ids.mbomb2.total_mails=temp;
			break;

		case 'b':
			return 0;
		default:
			continue;
		}//switch end
	}//while end
	return 0;
}
/*-----End mail address Main Menu----*/

/*-----Mail address list-----*/
int mailblocklist(ACONFIG *a)
{
	char command[80],ch;
	int i,page,temp;
	char *line="+-----------------------------------------------------------------------+\n";
	char *title="Mail address block list";
	page =0;
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t%s\n",title);
		printf("%s",topLine);
		printf("%s",line);
		for(i=0;i<10;i++)
			printf("(%d)%-80s\n",page*10+(i+1),a->ids.mailblock[page*10+i].string);
		printf("[Page%2d]\t\t\t\t\t\t\n",page+1);
		printf("%s",line);
		printf("|(U)page up\t\t\t\t\t\t\t\t|\n");
		printf("|(D)page down\t\t\t\t\t\t\t\t|\n");
		printf("|(G)Go page?\t\t\t\t\t\t\t\t|\n");
		printf("|(a)Add new address\t\t\t\t\t\t\t|\n");
		printf("|(d)Delete a address\t\t\t\t\t\t\t|\n");
		//printf("|(s)Save and Rest\t\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~G),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 'D':
			//@@@ModifyBegin by KM 2002/10/05
			if(page==(MAIL_ADDRESS_NUM/10)-1)
			//@@@ModifyEnd by KM
				page=-1;
			page=page+1;
			break;
		case 'U':
			if(page==0)
			//@@@ModifyBegin by KM 2002/10/05
				page=MAIL_ADDRESS_NUM/10;
			//@@@ModifyEnd by KM
			page=page-1;
			break;
		case 'G':
			printf("go to page?");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			temp=atoi(command);
			//@@@ModifyBegin by KM 2002/10/05
			if(temp<1 || temp>(MAIL_ADDRESS_NUM/10))
			//@@@ModifyEnd by KM
				continue;
			page=temp-1;
			break;
		case 'a':
			printf("address:");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			add_maddr(a,command);
			break;
		case 'd':
			printf("delet which?");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			del_maddr(a, atoi(command));
			break;
		case 'b':
			return 0;
		default:
			continue;
		}//switch end
	}//while end
	return 0;
}
/*-----End mail address list-----*/
#endif


/*-----send alert mail main menu-----*/
int sendalertmail(ACONFIG * a)
{
/*
	char *type;
	char *title="Send Alert Mail Main Menu";
	int i,temp;
	char command[80],ch;
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\t(1)Mail from:\t\t%s\t\t\t\t\t|\n",a->mailalert.mail_from);
		printf("\t|\t(2)Mail to 1:\t\t%s\t\t\t\t\t|\n",a->mailalert.list[0].mail_to);
		printf("\t|\t(3)Mail to 2:\t\t%s\t\t\t\t\t|\n",a->mailalert.list[1].mail_to);
		printf("\t|\t(4)Mail to 3:\t\t%s\t\t\t\t\t|\n",a->mailalert.list[2].mail_to);
		if(a->mailalert.enable==0)
			printf("\t|\t(5)Alert state:\t\tDisable\t\t\t\t\t|\n");
		else
			printf("\t|\t(5)Alert state:\t\tEnable\t\t\t\t\t|\n");
		printf("\t|\t(6)Alert table list\t\t\t\t\t\t|\n");
		printf("\t|\t(7)Clean Mail address 1~4\t\t\t\t\t|\n");
		printf("\t|\t(s)Save and Reset\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~7),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 's':
			setsend(0);
			write_Aconfig(a);
			if(a->mailalert.enable==1)
			setsend(1);
			break;
		case '1':
			printf("Mail from:");
			fgets(command,80,stdin);
			if(strlen(command)<4)
				continue;
			command[strlen(command)-1]=0;
			strcpy(a->mailalert.mail_from, command);
			break;
		case '2':
		case '3':
		case '4':
			temp=ch-'0';
			temp=temp-2;
			printf("Mail to%d:",temp+1);
			fgets(command,80,stdin);
			if(strlen(command)<4)
				continue;
			command[strlen(command)-1]=0;
			strcpy(a->mailalert.list[temp].mail_to, command);
			break;
		case '5':
			a->mailalert.enable= -1*(a->mailalert.enable -1);
			break;
		case '6':
			alerttablelist(a);
			break;
		case '7':
			printf("clean which one?[1~4]");
			fgets(command,80,stdin);
			if(strlen(command)>2)
				continue;
			command[strlen(command)-1]=0;
			i=atoi(command);
			if(i==1)
				a->mailalert.mail_from[0]=0;
			else
				a->mailalert.list[i-2].mail_to[0]=0;
			break;
		case 'b':
			return 0;
			break;
		default:
			continue;
		}//switch end
	}//while end
*/
	return 1;
}
/*-----End send alert mail main menu-----*/

/*-----Alert table list-----*/
int alerttablelist(ACONFIG *a)
{
/*
	char command[80],ch;
	int i,page,temp;
	char *line="+-----------------------------------------------------------------------+\n";
	char *title="Alert table list";
	char *state[2]={"Disable",
			"Enable",
			};
	page =0;
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t%s\n",title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\tAttack name\t\tEmergency(Send Mail)\n");
		printf("%s",line);
		for(i=0;i<10;i++)
		{
			if(a->mailalert.alert_table[page*10+i].logname[0]==0)
				continue;
			printf("(%d)%-35s\t%s\n",i,a->mailalert.alert_table[page*10+i].logname,state[a->mailalert.alert_table[page*10+i].emergency]);
		}
		printf("   [Page%2d]\n",page+1);
		printf("%s",line);
		printf("|(U)page up\t\t\t\t\t\t\t\t|\n");
		printf("|(D)page down\t\t\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (0~9),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
			i=ch-'0';
			i=page*10+i;
			a->mailalert.alert_table[i].emergency= -1 * (a->mailalert.alert_table[i].emergency - 1) ;
			break;
		case 'D':
			if(page==1)
				page=-1;
			page=page+1;
			break;
		case 'U':
			if(page==0)
				page=2;
			page=page-1;
			break;
		case 'b':
			return 0;
		default:
			continue;
		}//switch end
	}//while end
*/
	return 0;
}
/*-----End alert table list-----*/
/*-----Set IPSec  main menu-----*/
int setIPSecMainMenu(ACONFIG * a)
{
/*
	char *type;
	char *title="set IPSec main menu";
//	int i,temp,total_tunnels;
	int i,temp;
	char *state[2]={"Disable",
			"Enable",
			};
	char *encap[2]={"IKE",
			"Manual",
			};
	char *m_encry[3]={"none",
			"DES",
			"3DES",
			};
	char *m_hash[3]={"none",
			"MD5",
			"SHA1",
			};
	char command[80],ch;
//	total_tunnels=0;	//wnlee
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\t(1)IPSec state\t\t%s\t\t\t\t\t|\n",state[a->ipsec.if_enable_ipsec]);
		if(a->ipsec.if_enable_ipsec==1)
		{
			printf("\t|\t   Max. number of tunnels %d\t\t\t\t\t|\n",a->ipsec.max_number_of_tunnels);
			printf("%s",line);
			printf("\t|No.\tName\tRemote GW\tEncap.\t\tEncry.\t\tHash\t|\n");
			for(i=0;i<a->ipsec.max_number_of_tunnels;i++)	//list tunnel info
			{
				if(a->ipsec.Tunnel_Info[i].tunnel_name[0]==0)
					continue;
				//total_tunnels++;	// wnlee: list should not increase the total_tunnels
				printf("\t|%d\t%4s\t%3d.%3d.%3d.%3d\t%6s\t\t",
					i+1,
					a->ipsec.Tunnel_Info[i].tunnel_name,
					a->ipsec.Tunnel_Info[i].remote_gateway[0],
					a->ipsec.Tunnel_Info[i].remote_gateway[1],
					a->ipsec.Tunnel_Info[i].remote_gateway[2],
					a->ipsec.Tunnel_Info[i].remote_gateway[3],
					encap[a->ipsec.Tunnel_Info[i].type_of_key_method]);
				if(a->ipsec.Tunnel_Info[i].type_of_key_method==0)//IKE
					printf("  -  \t\t  - \t|\n");
				else //Manual
				{
					printf("%s\t\t%s\t|\n",
						m_encry[a->ipsec.Tunnel_Info[i].key_method.manual.encrypt_algorithm],
						m_hash[a->ipsec.Tunnel_Info[i].key_method.manual.auth_algorithm]);
				}
			}//End list tunnel info
			printf("%s",line);
		}
		printf("\t|\t(2)Add tunnel\t\t\t\t\t\t\t|\n");
		printf("\t|\t(3)Del tunnel\t\t\t\t\t\t\t|\n");
		printf("\t|\t(4)Modify tunnel\t\t\t\t\t\t|\n");
		printf("\t|\t(s)Save and Reset\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~4),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 's':
			//call set ipsec
			setipsec(-1,0);			//wnlee
			write_Aconfig(a);
			setipsec(-1,1);
			break;
		case '1':
			a->ipsec.if_enable_ipsec= -1*(a->ipsec.if_enable_ipsec - 1);
			break;
		case '2'://add tunnel
			for(i=0;i<a->ipsec.max_number_of_tunnels;i++)	//list tunnel info
			{
				if(a->ipsec.Tunnel_Info[i].tunnel_name[0]==0)
					continue;
				//total_tunnels++;	// wnlee
			}
			if(total_tunnels<a->ipsec.max_number_of_tunnels)
			{
				i=0;
				while(a->ipsec.Tunnel_Info[i].tunnel_name[0]!=0)
					i++;	//find the empty Tunnel_Ifno to write
				//call set tunnel #i
				setIPSecTunnel(i,a);
			}
			else
			{
				printf("Have the Max# of tunnels, Please delete before adding\n");
				printf("Press any key to continue ...\n");
				getchar();
			}
			break;
		case '3'://del tunnel
			printf("Please input the number of the tunnel:");
			fgets(command,80,stdin);
			if(strlen(command)>3)
				continue;
			command[strlen(command)-1]=0;

			a->ipsec.Tunnel_Info[atoi(command)-1].tunnel_name[0]=0;	//del
#if 0
			// wnlee
			// delete SAs and eroute and the corresponding routing table entry of this tunnel
			if( a->ipsec.Tunnel_Info[atoi(command)-1].tunnel_name[0] != 0 )
			{
				setipsec(atoi(command)-1,0);
				//setmanual(atoi(command)-1,0, &total_tunnels);
				// remove tunnel_name
				a->ipsec.Tunnel_Info[atoi(command)-1].tunnel_name[0]=0;//del
			}
#endif			
			break;

		case '4'://modify tunnel
			printf("Please input the number of the tunnel(1~%d):",a->ipsec.max_number_of_tunnels);
			fgets(command,80,stdin);
			if(strlen(command)>3)
				continue;
			command[strlen(command)-1]=0;
			i=atoi(command)-1;
			if(i>a->ipsec.max_number_of_tunnels)
				continue;
			// check if this tunnel exist, using the 1st char of this tunnel
			if( a->ipsec.Tunnel_Info[atoi(command)-1].tunnel_name[0] == 0 )		//wnlee
			{
				printf("Tunnel [%d] doesn't exist, Add it first\n",i+1);
				sleep(3);
				continue;			
			}
			//call set tunnel #i
			setIPSecTunnel(i,a);
			break;
		case 'm'://hide, set max nuber of tunnels
			fgets(command,80,stdin);
			if(strlen(command)>3)
				continue;
			command[strlen(command)-1]=0;
			a->ipsec.max_number_of_tunnels=atoi(command);
			i=a->ipsec.max_number_of_tunnels;
			if( i<0 || i>16 )
				a->ipsec.max_number_of_tunnels=5;//default
			break;
		case 'b':
			return 0;
			break;
		default:
			continue;
		}//switch end
	}//while end
*/
	return 1;
}
/*-----End Set IPSec main menu-----*/
/*-----Set IPSec Tunnel Information-----*/
int setIPSecTunnel(int num_of_tunnel, ACONFIG * a)
{
/*
	char *type;
	char *title="IPSec Tunnel Information";
	int i,j,k,l;
	char *state[2]={"Disable",
			"Enable"};
	char *encap[2]={"IKE",
			"Manual"};
	char *i_encry[3]={"AH",
			"ESP",
			"AH,ESP"};
	char *m_encry[3]={"none",
			"DES",
			"3DES"};
	char *m_hash[3]={"none",
			"MD5",
			"SHA1"};
	char *switch_str[2]={"OFF",
			"ON"};
	char command[80],ch,temp[5],spi_str[6];
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\t(1)Tunnel name:\t%16s\t\t\t\t|\n",a->ipsec.Tunnel_Info[num_of_tunnel].tunnel_name);
		printf("\t|\t(2)Local subnet:\t%3d.%3d.%3d.%3d\t\t\t\t|\n",
						a->ipsec.Tunnel_Info[num_of_tunnel].local_subnet[0],
						a->ipsec.Tunnel_Info[num_of_tunnel].local_subnet[1],
						a->ipsec.Tunnel_Info[num_of_tunnel].local_subnet[2],
						a->ipsec.Tunnel_Info[num_of_tunnel].local_subnet[3]);
		printf("\t|\t(3)Local netmask:\t%3d.%3d.%3d.%3d\t\t\t\t|\n",
						a->ipsec.Tunnel_Info[num_of_tunnel].local_netmask[0],
						a->ipsec.Tunnel_Info[num_of_tunnel].local_netmask[1],
						a->ipsec.Tunnel_Info[num_of_tunnel].local_netmask[2],
						a->ipsec.Tunnel_Info[num_of_tunnel].local_netmask[3]);
		printf("\t|\t(4)Remote subnet:\t%3d.%3d.%3d.%3d\t\t\t\t|\n",
						a->ipsec.Tunnel_Info[num_of_tunnel].remote_subnet[0],
						a->ipsec.Tunnel_Info[num_of_tunnel].remote_subnet[1],
						a->ipsec.Tunnel_Info[num_of_tunnel].remote_subnet[2],
						a->ipsec.Tunnel_Info[num_of_tunnel].remote_subnet[3]);
  		printf("\t|\t(5)Remote netmask:\t%3d.%3d.%3d.%3d\t\t\t\t|\n",
						a->ipsec.Tunnel_Info[num_of_tunnel].remote_netmask[0],
						a->ipsec.Tunnel_Info[num_of_tunnel].remote_netmask[1],
						a->ipsec.Tunnel_Info[num_of_tunnel].remote_netmask[2],
						a->ipsec.Tunnel_Info[num_of_tunnel].remote_netmask[3]);
		printf("\t|\t(6)Remote gateway:\t%3d.%3d.%3d.%3d\t\t\t\t|\n",
						a->ipsec.Tunnel_Info[num_of_tunnel].remote_gateway[0],
						a->ipsec.Tunnel_Info[num_of_tunnel].remote_gateway[1],
						a->ipsec.Tunnel_Info[num_of_tunnel].remote_gateway[2],
						a->ipsec.Tunnel_Info[num_of_tunnel].remote_gateway[3]);
		printf("\t|\t(7)Keying:\t\t\t%s\t\t\t\t|\n",encap[a->ipsec.Tunnel_Info[num_of_tunnel].type_of_key_method]);
		printf("%s",line);
		if(a->ipsec.Tunnel_Info[num_of_tunnel].type_of_key_method==0)//IKE
		{
			printf("\t|\t(8)pre-shard:\t%20s\t\t\t\t|\n",
					a->ipsec.Tunnel_Info[num_of_tunnel].key_method.ike.preshared_key);
			printf("\t|\t(9)Encap protocol:\t\t%s\t\t\t\t|\n",
					i_encry[a->ipsec.Tunnel_Info[num_of_tunnel].key_method.ike.encap_protocol]);
			printf("\t|\t(A)Perfect forward security:\t%s\t\t\t\t|\n",
					switch_str[a->ipsec.Tunnel_Info[num_of_tunnel].key_method.ike.pfs]);
			printf("\t|\t(B)ike life time:\t%8d\t\t\t\t|\n",
					a->ipsec.Tunnel_Info[num_of_tunnel].key_method.ike.ikelifetime);
			printf("\t|\t(C)ipsec life time:\t%8d\t\t\t\t|\n",
					a->ipsec.Tunnel_Info[num_of_tunnel].key_method.ike.ipseclifetime);
		}//ike
		else //Manual
		{
			//--get spi in spi_str (0x100~0xfff)
			sprintf(temp,"%lx",a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.local_spi);
			strcpy(spi_str,"0x000");
			for(i=strlen(temp)-1,j=0;i>=0;i--,j++)
			{
				spi_str[4-j]=temp[i];
			}
			printf("\t|\t(8)SPI:\t\t\t%5s\t\t\t\t\t|\n",spi_str);
			//select ESP or AH
			printf("\t|\t(9)Select ESP or AH\t\t\t\t\t\t|\n");
			if(a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.encap_protocol>2)//ESP
			{
				printf("\t|\tESP:\t\t\t\t\t\t\t\t|\n");
				printf("\t|\t(A)Encry:\t\t%4s\t\t\t\t\t|\n",
					m_encry[a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.encrypt_algorithm]);
				if(a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.encrypt_algorithm!=0)//key
				{
					printf("\t|\t(B)Key:\t\t0x");
					for(i=0;i<3;i++)
					{
						for(j=0;j<16;j++)
							printf("%c",
							   a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.encry_num[i].encryption_key[j]);
						printf("\t\t\t\t|\n");
						if(i!=2)
							printf("\t|\t\t\t  ");
					}
				}
				printf("\t|\t(C)Auth:\t%s\t\t\t\t\t\t|\n",
					m_hash[a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.auth_algorithm]);
				if(a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.auth_algorithm == 1)//MD5
					k=32;//MD5 32nibbles
				else if(a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.auth_algorithm == 2)//SHA1
					k=40;//SHA1 40nibbles
				else//none
					k=0;
				if(k!=0)//list key
				{
					printf("\t|\t(D)Key:\t0x");
					for(i=0;i<k;i++)//list the auth_key
					{
						printf("%c",a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.auth_key[i]);
						if((i%16)==15)
						{
							printf("\t\t\t\t\t|\n");
							if(k==32 && i !=31)
								printf("\t|\t\t  ");
							if(k==40)
								printf("\t|\t\t\t  ");
						}
					}
					if(i==40)
						printf("\t\t\t\t\t\t|\n");
				}
			}//ESP
			else//AH
			{
				printf("\t|\tAH:\t\t\t\t\t\t\t\t|\n");
				printf("\t|\t(A)Auth:\t%s\t\t\t\t\t\t|\n",
					m_hash[a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.auth_algorithm]);
				if(a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.auth_algorithm == 1)//MD5
					k=32;//MD5 32nibbles
				else if(a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.auth_algorithm == 2)//SHA1
					k=40;//SHA1 40nibbles
				else//none
					k=0;
				if(k!=0)
				{
					printf("\t|\t(B)Key:\t0x");
					for(i=0;i<k;i++)//list the auth_key
					{
						printf("%c",a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.auth_key[i]);
						if((i%16)==15)
						{
							printf("\t\t\t\t\t|\n");
							if(k==32 && i !=31)
								printf("\t|\t\t  ");
							if(k==40)
								printf("\t|\t\t  ");
						}
					}
					if(i==40)
						printf("\t\t\t\t\t\t|\n");
				}
			}//AH
		}//manual
		printf("%s",line);
		printf("\t|\t(s)Save and Reset\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice ,or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 's':
			//save the tunnel mode or transport mode End
			if(a->ipsec.Tunnel_Info[num_of_tunnel].type_of_key_method==1)	//Manual
			{	//check and save the manual encap protocol in flash
				//check if transport
				for(i=0,j=0;i<4;i++)
				{
					k=a->ipsec.Tunnel_Info[num_of_tunnel].local_subnet[i];
					j+=k;
					k=a->ipsec.Tunnel_Info[num_of_tunnel].local_netmask[i];
					j+=k;
					k=a->ipsec.Tunnel_Info[num_of_tunnel].remote_subnet[i];
					j+=k;
					k=a->ipsec.Tunnel_Info[num_of_tunnel].remote_netmask[i];
					j+=k;
				}//if j==0 --> Transport
				//check if ESP, ESP with AH, or AH
				if(a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.encap_protocol>2)//ESP
				{
					if(a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.auth_algorithm==0)//ESP without AH
					{
						if(j==0)//transport
							a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.encap_protocol=4;
						else
							a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.encap_protocol=3;
					}
					else//ESP with AH
					{
						if(j==0)//transport
							a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.encap_protocol=6;
						else
							a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.encap_protocol=5;
					}
				}
				else//AH
				{
					if(j==0)//transport
						a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.encap_protocol=2;
					else
						a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.encap_protocol=1;
				}
			}
			else//IKE
			{
				//check if transport
				for(i=0,j=0;i<4;i++)
				{
					k=a->ipsec.Tunnel_Info[num_of_tunnel].local_subnet[i];
					j+=k;
					k=a->ipsec.Tunnel_Info[num_of_tunnel].local_netmask[i];
					j+=k;
					k=a->ipsec.Tunnel_Info[num_of_tunnel].remote_subnet[i];
					j+=k;
					k=a->ipsec.Tunnel_Info[num_of_tunnel].remote_netmask[i];
					j+=k;
				}//if j==0 --> Transport
				if(j==0)
					a->ipsec.Tunnel_Info[num_of_tunnel].key_method.ike.mode=2;//transport
				else
					a->ipsec.Tunnel_Info[num_of_tunnel].key_method.ike.mode=1;//tunnel

			}
			//save the tunnel mode or transport mode End
			//call set ipsec
			setipsec(num_of_tunnel,0);	//wnlee
#if DEBUG_IPSEC_MANUAL
			printf("setipsec 0 ok !\n");
#endif			
			write_Aconfig(a);
#if DEBUG_IPSEC_MANUAL		
			fflush(stdout);
			sleep(1);
			printf("call setipsec 1 tunnel number [%d]!\n\n", num_of_tunnel);
			fflush(stdout);
			sleep(1);
#endif
			setipsec(num_of_tunnel,1);	//wnlee
			//setipsec(-1,1);
#if DEBUG_IPSEC_MANUAL
			printf("setipsec 1 ok !");
			fflush(stdout);
#endif			
			break;
		case '1':
			printf("Name:");
			fgets(command,80,stdin);
			if(strlen(command)>17)
				continue;
			command[strlen(command)-1]=0;
			strcpy(a->ipsec.Tunnel_Info[num_of_tunnel].tunnel_name,command);
			break;
		case '2':
			printf("Write or Clean (w/c):");
			fgets(command,80,stdin);
			if(strlen(command)!=2)
				continue;
			if(command[0]=='c' || command[0]=='C')//clean
			{
				a->ipsec.Tunnel_Info[num_of_tunnel].local_subnet[0]=0;
				a->ipsec.Tunnel_Info[num_of_tunnel].local_subnet[1]=0;
				a->ipsec.Tunnel_Info[num_of_tunnel].local_subnet[2]=0;
				a->ipsec.Tunnel_Info[num_of_tunnel].local_subnet[3]=0;
			}
			else if(command[0]=='w' || command[0]=='W')
			{
				printf("local subnet(xxx.xxx.xxx.xxx):");
				fgets(command,80,stdin);
				getIP(command,a->ipsec.Tunnel_Info[num_of_tunnel].local_subnet);
			}
			break;
		case '3':
			printf("Write or Clean (w/c):");
			fgets(command,80,stdin);
			if(strlen(command)!=2)
				continue;
			if(command[0]=='c' || command[0]=='C')//clean
			{
				a->ipsec.Tunnel_Info[num_of_tunnel].local_netmask[0]=0;
				a->ipsec.Tunnel_Info[num_of_tunnel].local_netmask[1]=0;
				a->ipsec.Tunnel_Info[num_of_tunnel].local_netmask[2]=0;
				a->ipsec.Tunnel_Info[num_of_tunnel].local_netmask[3]=0;
			}
			else if(command[0]=='w' || command[0]=='W')
			{
				printf("local netmask(xxx.xxx.xxx.xxx):");
				fgets(command,80,stdin);
				getIP(command,a->ipsec.Tunnel_Info[num_of_tunnel].local_netmask);
			}
			break;
		case '4':
			printf("Write or Clean (w/c):");
			fgets(command,80,stdin);
			if(strlen(command)!=2)
				continue;
			if(command[0]=='c' || command[0]=='C')//clean
			{
				a->ipsec.Tunnel_Info[num_of_tunnel].remote_subnet[0]=0;
				a->ipsec.Tunnel_Info[num_of_tunnel].remote_subnet[1]=0;
				a->ipsec.Tunnel_Info[num_of_tunnel].remote_subnet[2]=0;
				a->ipsec.Tunnel_Info[num_of_tunnel].remote_subnet[3]=0;
			}
			else if(command[0]=='w' || command[0]=='W')
			{
				printf("remote subnet(xxx.xxx.xxx.xxx):");
				fgets(command,80,stdin);
				getIP(command,a->ipsec.Tunnel_Info[num_of_tunnel].remote_subnet);
			}
			break;
		case '5':
			printf("Write or Clean (w/c):");
			fgets(command,80,stdin);
			if(strlen(command)!=2)
				continue;
			if(command[0]=='c' || command[0]=='C')//clean
			{
				a->ipsec.Tunnel_Info[num_of_tunnel].remote_netmask[0]=0;
				a->ipsec.Tunnel_Info[num_of_tunnel].remote_netmask[1]=0;
				a->ipsec.Tunnel_Info[num_of_tunnel].remote_netmask[2]=0;
				a->ipsec.Tunnel_Info[num_of_tunnel].remote_netmask[3]=0;
			}
			else if(command[0]=='w' || command[0]=='W')
			{
				printf("remote netmask(xxx.xxx.xxx.xxx):");
				fgets(command,80,stdin);
				getIP(command,a->ipsec.Tunnel_Info[num_of_tunnel].remote_netmask);
			}
			break;
			break;
		case '6':
			printf("Remote Getway:");
			fgets(command,80,stdin);
			getIP(command,a->ipsec.Tunnel_Info[num_of_tunnel].remote_gateway);
			break;
		case '7':
			a->ipsec.Tunnel_Info[num_of_tunnel].type_of_key_method =
			-1*(a->ipsec.Tunnel_Info[num_of_tunnel].type_of_key_method -1);
			break;
		case '8':
			if(a->ipsec.Tunnel_Info[num_of_tunnel].type_of_key_method==0)//IKE
			{
				printf("please input pre-shard:");
				fgets(command,80,stdin);
				command[strlen(command)-1]=0;
				if(strlen(command)<1 || strlen(command)>19 )
					continue;
				strcpy(a->ipsec.Tunnel_Info[num_of_tunnel].key_method.ike.preshared_key,command);
			}
			else//Manual
			{
				printf("spi (0x100~0xfff):");
				fgets(command,80,stdin);
				command[strlen(command)-1]=0;
				if(strlen(command)!=5)
					continue;
				j=0;
				for(i=0;i<3;i++)
				{
					switch (command[4-i]) {
						case '0':
						case '1':
						case '2':
						case '3':
						case '4':
						case '5':
						case '6':
						case '7':
						case '8':
						case '9':
							if(i==0)
								j=command[4-i]-'0';
							else if(i==1)
								j=j+16*(command[4-i]-'0');
							else
								j=j+16*16*(command[4-i]-'0');
							break;
						case 'a':
						case 'b':
						case 'c':
						case 'd':
						case 'e':
						case 'f':
							if(i==0)
								j=10+(command[4-i]-'a');
							else if(i==1)
								j=j+16*(10+(command[4-i]-'a'));
							else
								j=j+16*16*(10+(command[4-i]-'a'));
							break;
						default:
							break;
					}//end switch
				}
				if(j<0x100 || j>0xfff)
					continue;
				a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.local_spi=j;
				a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.remote_spi=j;
			}
			break;
		case '9':
			if(a->ipsec.Tunnel_Info[num_of_tunnel].type_of_key_method==0)//IKE
			{
				printf("0.AH 1.ESP 2.AH,ESP (0/1/2):");
				fgets(command,80,stdin);
				if(strlen(command)!=2)
					continue;
				command[strlen(command)-1]=0;
				if(command[0]!='0' && command[0]!='1' && command[0]!='2')
					continue;
				i=command[0]-'0';
				a->ipsec.Tunnel_Info[num_of_tunnel].key_method.ike.encap_protocol=i;
			}
			else//Manual
			{
				if(a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.encap_protocol<2)//AH
					a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.encap_protocol=3;
				else//ESP
					a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.encap_protocol=1;
			}
			break;
		case 'A':
			if(a->ipsec.Tunnel_Info[num_of_tunnel].type_of_key_method==0)//IKE
			{
				a->ipsec.Tunnel_Info[num_of_tunnel].key_method.ike.pfs =
				-1*(a->ipsec.Tunnel_Info[num_of_tunnel].key_method.ike.pfs -1 );
			}
			else//Manual
			{
				if(a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.encap_protocol>2)//ESP
				{
					printf("3DES");
					a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.encrypt_algorithm=2;
				}
				else//AH
				{
					printf("0.none, 1.MD5, 2.SHA1 (0/1/2):");
					fgets(command,80,stdin);
					if(strlen(command)!=2)
						continue;
					if(command[0]!='0' && command[0]!='1' && command[0]!='2')
						continue;
					a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.auth_algorithm=command[0]-'0';
				}
			}
			break;
		case 'B':
			if(a->ipsec.Tunnel_Info[num_of_tunnel].type_of_key_method==0)//IKE
			{
				printf("ike life time:");
				fgets(command,80,stdin);
				if(strlen(command)<2)
					continue;
				command[strlen(command)-1]=0;
				i=atoi(command);
				a->ipsec.Tunnel_Info[num_of_tunnel].key_method.ike.ikelifetime=i;
			}
			else//Manual
			{
				if(a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.encap_protocol>2)//ESP
				{
					printf("key:");
					fgets(command,80,stdin);
					if(strlen(command)!=49)
						continue;
					command[strlen(command)-1]=0;
					for(i=0;i<48;i++)
					{
						if(((command[i]>='0')&&(command[i]<='9')) ||
						   ((command[i]>='a')&&(command[i]<='f')) )
						{
							a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.encry_num[(i/16)].encryption_key[(i%16)]= command[i];
						}
					}
				}
				else//AH
				{
					if(a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.auth_algorithm == 1)//MD5
						k=32;//MD5 32nibbles
					else if(a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.auth_algorithm == 2)//SHA1
						k=40;//SHA1 40nibbles
					printf("key(%d nibbles):",k);
					fgets(command,80,stdin);
					if(strlen(command)!=(k+1))
						continue;
					for(i=0;i<k;i++)
					{
						if(((command[i]>='0')&&(command[i]<='9')) ||
						   ((command[i]>='a')&&(command[i]<='f')) )
						{
							a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.auth_key[i] = command[i];
						}
					}
				}
			}
			break;
		case 'C':
			if(a->ipsec.Tunnel_Info[num_of_tunnel].type_of_key_method==0)//IKE
			{
				printf("ipsec life time:");
				fgets(command,80,stdin);
				if(strlen(command)<2)
					continue;
				command[strlen(command)-1]=0;
				i=atoi(command);
				a->ipsec.Tunnel_Info[num_of_tunnel].key_method.ike.ipseclifetime=i;
			}
			else//Manual
			{
				printf("0.none, 1.MD5, 2.SHA1 (0/1/2):");
				fgets(command,80,stdin);
				if(strlen(command)!=2)
					continue;
				if(command[0]!='0' && command[0]!='1' && command[0]!='2')
					continue;
				a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.auth_algorithm=(command[0]-'0');
			}
			break;
		case 'D'://Manual ESP AH
			if(a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.auth_algorithm == 1)//MD5
				k=32;//MD5 32nibbles
			else if(a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.auth_algorithm == 2)//SHA1
				k=40;//SHA1 40nibbles
			printf("key(%d nibbles):",k);
			fgets(command,80,stdin);
			if(strlen(command)!=(k+1))
				continue;
			for(i=0;i<k;i++)
			{
				if(((command[i]>='0')&&(command[i]<='9')) ||
				   ((command[i]>='a')&&(command[i]<='f')) )
				{
					a->ipsec.Tunnel_Info[num_of_tunnel].key_method.manual.auth_key[i] = command[i];
				}
			}
			break;
		case 'b':
			return 0;
			break;
		default:
			continue;

		}	//switch end

	}	//while end
*/
	return 1;
}

/*-----End Set IPSec Tunnel Information-----*/

/*-----SPAP MainMenu -----*/

int spapparser(char *src, sepl *dst)
{
	int head = 0, tail = 1;
	int tlen;
	int i, j;
	int mark = 0;	// 0range, 1@port
	char temp[10];
	int numofport = 0;

	tlen = strlen(src);

	while(head < tlen)
	{
		for(j = tail; src[j]!=',' && src[j]!='\0'; j++)
			tail += 1;

		for(i = 0, j = head; j <= tail; j++)
		{
			if(src[j] != ',' && src[j] != '-' && src[j] != '\0')
			{
				temp[i++] = src[j];
				continue;
			}
			else if(src[j] == ',' || src[j] == '\0')
			{
				if(atoi(temp)==0)
					break;
				if(mark == 0)
			        {
			        	dst[numofport].lb = (WORD)atoi(temp);
			        	dst[numofport].ub = (WORD)atoi(temp);
			        }
				else
			        {
					dst[numofport].ub = (WORD)atoi(temp);
				}
				numofport++;
        			break;
			}
			else if(src[j] == '-')
			{
				mark = 1;
				if(atoi(temp)==0)
					break;
				dst[numofport].lb = (WORD)atoi(temp);
				i = 0;
				continue;
			}
		}

		head = tail+1;
		tail += 2;
		mark = 0;
	}
	for(i = 0; i < numofport; i++)
	{
		if(dst[i].lb > dst[i].ub)
		{
			j = dst[i].lb;
			dst[i].lb = dst[i].ub;
			dst[i].ub = j;
		}
	}

	return numofport;
}

// groupq@Ӷ}lW

void normalize_sepl(int group, ACONFIG *a)
{
	BYTE start;
	BYTE c_head, c_tail;
	int i;

	while(group < 4)
	{
		i = 1;
		while(i <= group)
		{
			start = a->spap.trig[group - i].sp1;
			if(start != 0)
				break;
			else
				i++;
		}
		start++;
		c_head = a->spap.trig[group].sp0;
		c_tail = a->spap.trig[group].sp1;
		if(c_head != 0 && c_tail != 0)
		{
			a->spap.trig[i].sp0 = start;
			a->spap.trig[i].sp1 = start + c_tail - c_head;
			for(i = c_head; i <= c_tail; i++)
			{
				memcpy(&a->spap.sepl[start], &a->spap.sepl[i], sizeof(sepl));
				start++;
			}
		}
		group++;
	}
	return;
}

int specialApplications(ACONFIG *a)
{

	char *q[2]={	"Trigger port:",
			"Incoming port range:",
		   };
	char *special_ap_title="Special Applications";
	int i, j;
	char command[80],ch;

	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",special_ap_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\tID\tTrigger\t\tIncoming Ports\t\tEnable\t\t|\n");
		printf("%s",line);
		for(i = 0; i < 4; i++)
		{
			printf("\t|\t(%d)%6d sp0=%d sp1=%d ", i+1, a->spap.trig[i].port, a->spap.trig[i].sp0, a->spap.trig[i].sp1);
			for(j = a->spap.trig[i].sp0; j < a->spap.trig[i].sp1; j++)
			{
				if(a->spap.sepl[j].lb == a->spap.sepl[j].ub)
					printf("%d,", a->spap.sepl[j].lb);
				else
					printf("%d-%d,", a->spap.sepl[j].lb, a->spap.sepl[j].ub);
			}
			if(a->spap.sepl[j].lb == a->spap.sepl[j].ub)
				printf("%d", a->spap.sepl[j].lb);
			else
				printf("%d-%d", a->spap.sepl[j].lb, a->spap.sepl[j].ub);
			if(a->spap.trig[i].flag == 1)
				printf("  Enable\n");
			else
				printf("  Disable\n");
		}
		printf("\t|\t(s)Save and Reset\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~4) to change,(5~8)to enable,or press 'b' to back.\n");
		fgets(command, 80, stdin);
		if(strlen(command)!=2)
			continue;
		ch = command[0];
		switch (ch){
		case 's':
			setspap(0);
			write_Aconfig(a);
			setspap(1);
			break;
		case '1':
			printf("%s",q[0]);
			fgets(command,80,stdin);
			getPort(command, &(a->spap.trig[0].port));
			printf("%s", q[1]);
			fgets(command, 80, stdin);
			a->spap.trig[0].sp0 = 1;
			i = spapparser(command, (sepl *)&a->spap.sepl[a->spap.trig[0].sp0]);
			if(i != 0)
			{
				a->spap.trig[0].sp1 = i;
				// assign group 0, ҥHnWgroup 1Ψᤧgroup
				normalize_sepl(1, a);
			}
			else
				a->spap.trig[0].sp0 = a->spap.trig[0].sp1 = 0;
			break;
		case '2':
			printf("%s",q[0]);
			fgets(command,80,stdin);
			getPort(command, &(a->spap.trig[1].port));
			printf("%s", q[1]);
			fgets(command, 80, stdin);
			a->spap.trig[1].sp0 = a->spap.trig[0].sp1 + 1;
			i = spapparser(command, (sepl *)&a->spap.sepl[a->spap.trig[1].sp0]);
			if(i != 0)
			{
				a->spap.trig[1].sp1 = i + a->spap.trig[1].sp0 - 1;
				// assign group 1, ҥHnWgroup 2Ψᤧgroup
				normalize_sepl(2, a);
			}
			else
				a->spap.trig[1].sp0 = a->spap.trig[1].sp1 = 0;
			break;
		case '3':
			printf("%s",q[0]);
			fgets(command, 80, stdin);
			getPort(command, &(a->spap.trig[2].port));
			printf("%s",q[1]);
			fgets(command, 80, stdin);
			a->spap.trig[2].sp0 = a->spap.trig[1].sp1 + 1;
			i = spapparser(command, (sepl *)&a->spap.sepl[a->spap.trig[2].sp0]);
			if(i != 0)
			{
				a->spap.trig[2].sp1 = i + a->spap.trig[2].sp0 - 1;
				// assign group 2, ҥHnWgroup 3Ψᤧgroup
				normalize_sepl(3, a);
			}
			else
				a->spap.trig[2].sp0 = a->spap.trig[2].sp1 = 0;
			break;
		case '4':
			printf("%s",q[0]);
			fgets(command,80,stdin);
			getPort(command,&(a->spap.trig[3].port));
			printf("%s",q[1]);
			fgets(command, 80, stdin);
			a->spap.trig[3].sp0 = a->spap.trig[2].sp1 + 1;
			i = spapparser(command, (sepl *)&a->spap.sepl[a->spap.trig[3].sp0]);
			if(i != 0)
			{
				a->spap.trig[3].sp1 = i + a->spap.trig[3].sp0 - 1;
				// group 3wgO̫@group...ҥHSgroupiHLW
			}
			else
				a->spap.trig[3].sp0 = a->spap.trig[3].sp1 = 0;
			break;
		case '5':
			a->spap.trig[0].flag=-1*(a->spap.trig[0].flag-1);
			break;
		case '6':
			a->spap.trig[1].flag=-1*(a->spap.trig[1].flag-1);
			break;
		case '7':
			a->spap.trig[2].flag=-1*(a->spap.trig[2].flag-1);
			break;
		case '8':
			a->spap.trig[3].flag=-1*(a->spap.trig[3].flag-1);
			break;
		case 'b':
			system("clear");
			return 1;
			break;
		default:
			continue;
		}
	}

	return 0;
}

/*-----End SPAP MainMenu-----*/

/*-----set PMAC MainMenu-----*/
int setPMACMainMenu(ACONFIG *a)
{
	
	char *pmac_title="Filter";
	char *rule[2]={"allow","deny"};
	char *state[2]={"disable","enable"};
	int temp;
	int i;
	char temp_index;
	char command[80],ch;
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",pmac_title);
		printf("%s",topLine);
		printf("\t|\tIterm\t\t\tSetting\t\t\t\t\t|\n");
		if((a->pmac.flag & PMF_MAC_CONTROL) == PMF_MAC_CONTROL)
			temp=1;
		else 
			temp=0;
		printf("\t|\t(A)MAC Address Control\t\t\t%s\t\t\t|\n",state[temp]);
		if((a->pmac.flag & PMF_D_ENABLE) == PMF_D_ENABLE)
			temp=1;
		else 
			temp=0;
		printf("\t|\t(B)Connection control\t\t\t%s\t\t\t|\n",state[temp]);
		printf("\t|\t   Clients with C checked can connect to this device;\t\t|\n");
		if((a->pmac.flag & PMF_D_DENY_OTHERS) == PMF_D_DENY_OTHERS)
			temp=1;
		else
			temp=0;
		printf("\t|\t(C)And  %s unspecified MAC addresses to connect\t\t|\n",rule[temp]);
		printf("%s",line);
		printf("\t|ID\tMAC Address\t\tIP Address\t\tStatus\t\t|\n");
		for(i=0;i<9;i++)
		{
			printf("\t|(%d) %2x-%2x-%2x-%2x-%2x-%2x\t\t%3d.%3d.%3d.%3d\t\t%s\t\t|\n",i+1,
					a->pmac.list[i].mac[0],
					a->pmac.list[i].mac[1],
					a->pmac.list[i].mac[2],
					a->pmac.list[i].mac[3],
					a->pmac.list[i].mac[4],
					a->pmac.list[i].mac[5],
					a->local.ip[0],
					a->local.ip[1],
					a->local.ip[2],
					a->pmac.list[i].ip,
					state[a->pmac.list[i].prop]			);
			
		}
		printf("\t|(s)Save and Reset\t\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice, or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){

		case 's':
			setpmac(0);
			write_Aconfig(a);
			setpmac(1);
			break;

		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
			i=ch-'0'-1;
			printf("MAC:");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			getMAC(command,a->pmac.list[i].mac);
			printf("IP:");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			a->pmac.list[i].ip=atoi(command);
			printf("disable or enable(d/e)");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			if(command[0]=='e' || command[0]=='E')
				a->pmac.list[i].prop=1;
			else
				a->pmac.list[i].prop=0;
			break;
		case 'A':
			if((a->pmac.flag & PMF_MAC_CONTROL) == PMF_MAC_CONTROL)
				a->pmac.flag &= ~PMF_MAC_CONTROL;
			else 
				a->pmac.flag |= PMF_MAC_CONTROL;	
			break;
		case 'B'://PFM_D_ENABLE
			if((a->pmac.flag & PMF_D_ENABLE) == PMF_D_ENABLE)
				a->pmac.flag &= ~PMF_D_ENABLE;
			else 
				a->pmac.flag |= PMF_D_ENABLE;	
			break;
		case 'C'://PFM_D_DENY_OTHERS
			if((a->pmac.flag & PMF_D_DENY_OTHERS) == PMF_D_DENY_OTHERS)
				a->pmac.flag &= ~PMF_D_DENY_OTHERS;
			else 
				a->pmac.flag |= PMF_D_DENY_OTHERS;
				
			break;
		case 'b':
			return 0;
		default:
			continue;
		};
	}

	return 0;
}
/*-----End set PMAC MainMenu-----*/

/*-----Get MAC-----*/
int getMAC(char *buf, BYTE *mac)
{
	char ch;
	int i,num;
	
	for(i=0;i<6;i++)
	{
		num=0;
		ch=buf[i*3];
		if(ch >= '0' && ch <= '9')
			num=(ch-'0')*16;
		else
		{
			switch (ch){
				case 'A':
				case 'a':
					num=10*16;
					break;
				case 'B':
				case 'b':
					num=11*16;
					break;
				case 'C':
				case 'c':
					num=12*16;
					break;
				case 'D':
				case 'd':
					num=13*16;
					break;
				case 'E':
				case 'e':
					num=14*16;
					break;
				case 'F':
				case 'f':
					num=15*16;
					break;
				default:
					num=0;
					break;
			}//END SWITCH
			
		}
		ch=buf[i*3+1];
		if(ch >= '0' && ch <= '9')
			num+=(ch-'0');
		else
		{
			switch (ch){
				case 'A':
				case 'a':
					num+=10;
					break;
				case 'B':
				case 'b':
					num+=11;
					break;
				case 'C':
				case 'c':
					num+=12;
					break;
				case 'D':
				case 'd':
					num+=13;
					break;
				case 'E':
				case 'e':
					num+=14;
					break;
				case 'F':
				case 'f':
					num+=15;
					break;
				default:
					num=0;
			}//END SWITCH
		}
		//
		mac[i]=(BYTE)num;
	}
	return 0;
}
/*-----end Get MAC-----*/





