//#define BRECIS    1234

#ifndef AMITH

#define AMITH

#define IP_LENS 16 //succ_0617

//#include "ver.h"

#ifdef _IPSEC
//#include "ipsec.h"
#endif

// 2002/07/04 Aries,
//		1. add Aconfig.sntp, Aconfig.emalt, Aconfig.radius
//		2. add Aconfig.dhcp.lease

#ifndef FARDATA
#define FARDATA
#endif

/* modules included */
#define ROADRUNNER_SESSION_MANAGER      1       /* 0:none, 1:client, 2:server */
#define xSLIP_ENABLED
#define xP_SERVER

/* MAX_DATA: max data size on ethernet TCP/IP packet */
#define MAX_DATA                (1500-20-20)
/* BUFF_SIZE: for receiving, extra 8 bytes is for 1461-packet and pop3d! */
#define BUFF_SIZE               (MAX_DATA+8)

//#define LOG_TRAFFIC
#define LOG_TRA_SIZE            8

//#define LOG_MEMORY
#define LOG_MEM_SIZE            (16*1024)
//#define LOG_MEM_SIZE            (8*1024)

#define Cprintf	Nprintf		//wallance 90.11.27
int Dprintf(char const *fmt, ...);
int copystr(char *dst, char const *src);      /* return strlen(src) */

/* for ip_name, IP_NAME(0) is never used as ip name, it may be useful  */
#if 0
    extern unsigned char FARDATA    comp_name[];
    #define IP_NAME_LEN             16
    #define IP_NAME(x)              (comp_name+(unsigned)(x)*IP_NAME_LEN)
#else
    char *get_ip_name(int);
    #define IP_NAME_LEN             16
    #define IP_NAME(x)              get_ip_name(x)
#endif

/* boolean literal */
#ifndef TRUE
#define FALSE           0
#define TRUE            (!FALSE)
#endif

/* commonly used type */
#define BYTE            unsigned char
#define WORD            unsigned short
#define DWORD           unsigned long

#define UINT8   unsigned char
#define UINT16  unsigned short
#define UINT32  unsigned long

extern unsigned long    CurrDeciSec;
unsigned long h2i(unsigned char *buf, int len);

/*******************/
/* for misc switch */
/*******************/

#define MISC_SW         1

#if MISC_SW
extern unsigned short   MiscSwitch;
#define MS_SINK_LPD     0x0001
#endif

/*********************/
/* for local flag    */
/*********************/

#define LFLAG_DMZ       0x0001  /*DMZ host*/
#define LFLAG_ACTL      0x0002  /*Access ConTroL*/
#define LFLAG_RADM      0x0004  /*Remote ADMinistration*/
#define LFLAG_RENEWIP   0x0008  /*RENEW IP forever, Auto-Reconnect for DHCP, PPPoE*/
#define LFLAG_BWPING    0x0010  /*Block Wan PING*/
//#define LFLAG_AUTORED   0x0020  /*Auto-Redial for DUN*/
//#define LFLAG_DISDOD    0x0040  /*Disable DOD*/
#define LFLAG_IOPF      0x0080  /*IO Packet Filter*/

#define LFLAG_EFFMASK   0x0013  /*take effective immediately*/

/*********************/
/* for AcctPool flag */
/*********************/

/* remain here to set config */
#define LFLAG_RENEWIP   0x0008  /*RENEW IP forever, Auto-Reconnect for DHCP, PPPoE*/
#define LFLAG_AUTORED   0x0020  /*Auto-Redial for DUN*/
#define LFLAG_DISDOD    0x0040  /*Disable DOD*/

#define AFLAG_AUTOREC   0x0001  /*Auto-Reconnect for DHCP, PPPoE, PPTP, DUN...*/
#define AFLAG_DISDOD    0x0002  /*Disable DOD*/
#define AFLAG_PAPONLY   0x0100  /**/
#define AFLAG_CHAPONLY  0x0200  /**/

/*********************/
/* for PMac Flag    */
/*********************/

#define PMF_MAC_CONTROL         0x0001  /*MAC Address Control*/
#define PMF_D_ENABLE            0x0004  /*Connect to device*/
#define PMF_D_DENY_OTHERS       0x0008  /*Deny Others*/
#define PMF_W_ENABLE            0x0010  /*Associate to WLAN*/
#define PMF_W_ALLOW_OTHERS      0x0020  /*Allow Others*/
#define PMF_MUST_BE_ZERO        0x8000  /*No used but occupies a bit, for backward compatible*/

/* Pmac Prop */
#define PMP_CONNECT_DEVICE      0x01    /*Connect to device*/
#define PMP_ASSOCIATE_WLAN      0x02    /*Associate to WLAN*/

/*******************/
/* for Filter Flag */
/*******************/

#define FDF_ENABLED             0x0001
#define FDF_PASSRULE            0x0002

#define FRF_ENABLED             0x0001

#define FRF_PROT_SHIFT          6
#define FRF_PROT_MASK           0x00C0
#define FRF_PROT_BOTH           0x0000
#define FRF_PROT_TCP            0x0040
#define FRF_PROT_UDP            0x0080

#define FRF_DPORT_SHIFT         8
#define FRF_DPORT_MASK          0x0300
#define FRF_DPORT_SKIP          0x0000
#define FRF_DPORT_EQ            0x0100
#define FRF_DPORT_IN            0x0200

#define FRF_DIP_SHIFT           10
#define FRF_DIP_MASK            0x0C00
#define FRF_DIP_SKIP            0x0000
#define FRF_DIP_EQ              0x0400
#define FRF_DIP_IN              0x0800

#define FRF_SPORT_SHIFT         12
#define FRF_SPORT_MASK          0x3000
#define FRF_SPORT_SKIP          0x0000
#define FRF_SPORT_EQ            0x1000
#define FRF_SPORT_IN            0x2000

#define FRF_SIP_SHIFT           14
#define FRF_SIP_MASK            0xC000
#define FRF_SIP_SKIP            0x0000
#define FRF_SIP_EQ              0x4000
#define FRF_SIP_IN              0x8000

/*********************/
/* for configuration */
/*********************/

/* ODM customization BEGIN */
#define SMAP_NUM        26      /* default 8, no limit */
#define SPAP_NUM        16      /* default 4, limit:only 1.5K CGI buffer */
#define SPAP_SEPL_NUM   64      /* default 20: 21*SPAP_NUM+14*SPAP_SEPL_NUM */
#define AGRP_NUM        8       /* default 4, limit:only 1.5K CGI buffer */
#define AGRP_PORTS      32      /* default 20  */
#define PMAC_NUM        64      /* default 32  */
#define RTAB_NUM        32      /* default 10  */
#define MNAT_NUM        32      /* default 16  */
#define DCTL_RULE_NUM	20
#define DCTL_SUFFIX_SZ	64
/* ODM customization END */

#define PF_RULE_NUM     48       /* number packet filter rules */

typedef struct {
    BYTE    dip[4];          // destination ip address
    BYTE    dnm[4];          // destination subnet mask
    BYTE    dgw[4];          // default gateway
    BYTE    dif;             // destination interface -- 0: LAN, 1: WAN, else reserved
    BYTE    hop;             // hop count (matrix)
    BYTE    flag;            // flag for Static Routing
    BYTE    enable_flags;    // bit0: enable/disable; else reserved
} STRoutingTableEntry;

// bit masks for STRoutingTableEntry.enable_flags
#define RTAB_ENTRY_ENABLE  0x01  // bit 0: to indicate whether this entry is enabled or disabled

// bit masks for dyna_route.enable_flags
#define DYNA_ROUTE_RIP_ENABLE  0x0001  // bit 0: to indicate whether RIP1/RIP2 is enabled or disabled

//#define _IPSEC : Symbol "IPSEC" can be set to 1 in config.mak
//               : and "_IPSEC" will be defined in the compiler
//               : flag
//#define _IPSEC

/* when this structure is changed, please review side-effect in
   CGI.C. Which items must take effect after setup? */
typedef struct {
    /* (8) header of configuration data */
    struct {
        WORD resvFFFF;  // ثeNȶJ 0xFFFF, HKª (R1.94f0 Τe) {ˬd config ɵoͿ~Ӧ۰ reset to default
        BYTE minor_ver;  // config  minor version
        BYTE major_ver;  // config  major version
                         // t downgrade , Yo{ flash W major version {Ҥ䴩ٷs, hj reset to default
        WORD    chksum;
        WORD    size;
    } header;
    /* (64) local configuration */
    struct {
        BYTE    ip[4];          /* important, recovering mode use it */
        char    host[16];
        char    pass[10];       // system password
        BYTE    wip[4];
        BYTE    wgw[4];
        BYTE    wnm[4];
        BYTE    rhip[4];
        BYTE    rhnm[4];
        BYTE    uwid[6];
        WORD    wflag;
        BYTE    wtype;          // WAN type
        BYTE    dmz_host;
        WORD    adm_to;         /* din_to; */
        BYTE    buivar;         /* din_ip; */
        BYTE    wtypex;         /* din_auth; */
        BYTE    upnp_disabled;  // 1: disable UPnP; 0: enable UPnP
        BYTE    led_mode;       // ѩ󤣦PȤ, i|ݭnP LED ܼҦ
                                // ]HذO LED ܼҦ
                                // C@ؼҦܤ覡, ثeO led_change_system_state {Mw
        BYTE    resv[2];
    } local;

    /* reserved */
    char resv_local[540];

    /* (512) ip flag */
    struct {
        WORD    val[256];
    } flag;
    /* (64) dhcp */
    struct {
        char    domain[32];
        //char    resv1[4];
        unsigned long lease;	// in secod. Default(=0) is DEF_LEASE_TIME
        struct {
                BYTE ip[4];
        } dns[2];
        struct {
                BYTE ip[4];
        } wins[2];
        BYTE    netmask[4];
        BYTE    enable;
        BYTE    range[2];
        char    resv2;
        char    gwip[4];        /* for CyberChannel only */
    } dhcp;
    /* (208) 8*26, server mapping */
    struct {
        WORD    port;
        WORD    uport;
        BYTE    host;
        BYTE    flag;
        char    resv_smap[2];    // for ARM9 alignment
    } smap[SMAP_NUM];         // SMAP_NUM = 26
    /* (384) 8*16+4*64, special application */
    struct {
        struct {
                WORD port;
                WORD downcount;
                BYTE sp0;
                BYTE sp1;
                BYTE flag;
                BYTE host;
        } trig[SPAP_NUM];       /* SPAP_NUM = 16 */
        struct {
                WORD lb;
                WORD ub;
        } sepl[SPAP_SEPL_NUM];  /* SPAP_SEPL_NUM = 64, Subsequence Enable Port List */
    } spap;
    /* (576) (8+2*32)*8, access control */
union {
    struct {
        BYTE    type;
        BYTE    count;
        WORD    ports[AGRP_PORTS];      // AGRP_PORTS = 32
        BYTE    resv[6];
    } agrp[AGRP_NUM];           // AGRP_NUM = 8
    struct {
        struct {
            DWORD       ip0[2];         // source ip. 0 for lowerbound, 1 for upperbound
            DWORD       ip1[2];         // target ip. 0 for lowerbound, 1 for upperbound
            WORD        port0[2];       // source port. 0 for lowerbound, 1 for upperbound
            WORD        port1[2];       // target port. 0 for lowerbound, 1 for upperbound
            DWORD       dresv;
            WORD        rflag;          // rule flag
            WORD        t_index;        // temp var to record original rule index
        } rule[PF_RULE_NUM*2];          // PF_RULE_NUM = 48. eb in bound, b out bound
        WORD    flag[2];		// 0 for inbound, 1 for outbound
        char    resv[56];
        short   t_count[2];
    } ipf;
} actl;
    /* (4) reserved */
    char resv4[4];
    /* (256) access point */
/*
#if PSIS_SONIC_FAMILY()
    struct{
        char ssid[33];  // SSID
        char ssid_resv[32];
        BYTE channel; //channel
        BYTE security; //security. 0: no WEP; 1: 64-bit WEP; 2: 128-bit WEP; 3: 256-bit WEP
        BYTE select_wep_key;  //selected security key, range: 0 to 3
        BYTE wep_key[52];  //security key
                           // 64-bit:
                           //     52 bytes  4 , C@Ӭ 13 bytes
                           //     4  WEP keys Ob byte 0-5, 13-18, 26-31, 39-44 m
                           //     C WEP key u 5  bytes, ]OH WORD , ] 6  bytes
                           // 128-bit:
                           //     52 bytes  4 , C@Ӭ 13 bytes
                           //     4  WEP keys Ob byte 0-12, 13-25, 26-28, 39-51 m
                           // 256-bit:
                           //     52 bytes  2 , C@Ӭ 26 bytes
                           //     2  WEP keys Ob byte 0-25, 26-51 m
        char wep_key_resv[26];
        BYTE area_code;     // area code, this will used to decide what channels will be supported
        BYTE wireless_mode; // Wireless Mode. The meaning of value are defined as "WLAN_MODE_xxx" constants in wlan.h
        WORD basic_rate;    // Basic Rate. This field is a bit-map of basic data rates.
                            // Its value specifies the basic rates used
                            // and reported for this BSS by the AP.
                            // Bit       Data Rate
                            //  0           1 Mbps
                            //  1           2 Mbps
                            //  2         5.5 Mbps
                            //  3          11 Mbps
                            //  4          22 Mbps
                            // ***** NOTE *****
                            // The meaning of this item's value depends on the definition of both Intersil 802.11b and TI 802.11b+
        // 2001/10/25, by Aries
        BYTE pp_method;     // passphrase method:
                            // 0: hex (no passphrase)
                            // 1: Intersil
                            // 2: Lucent
        char pp_string[33]; // passphrase key string, max length=32
        WORD enhanced_security;  // Allows configuration of enhanced security items in the AP.
                                 // Bit       Control
                                 //  0        Hide SSID name in Beacon frame
                                 //  1        Block response to "Unspecified-SSID"
                                 // 2~15      Reserved (set to 0)
                                 // ***** NOTE *****
                                 // The meaning of this item's value depends on the definition of Intersil
        WORD frag_threshold;     // Fragmentation Threshold (Even number from 256 to 2346)
        WORD cts_rts_threshold;  // CTS/RTS Threshold
                                 // range: 0 ~ 3000 for Intersil 802.11b
                                 //        256 ~ 2432 for TI 802.11b+
        WORD supported_rate;     // Supported Rate. This field is a bit-map of basic data rates.
                                 // Its value specifies the basic rates used
                                 // and reported for this BSS by the AP.
                                 // Bit       Data Rate
                                 //  0           1 Mbps
                                 //  1           2 Mbps
                                 //  2         5.5 Mbps
                                 //  3          11 Mbps
                                 //  4          22 Mbps
                                 // ***** NOTE *****
                                 // The meaning of this item's value depends on the definition of both Intersil 802.11b and TI 802.11b+
        BYTE prev_security;      // OϥΪ̤W@ܪ security type
                                 // HKbϥΪ̭쥻FY WEP Type, F WEP,
                                 // MS^_쥻 WEP type , ڭ̥iHܥT WEP 
                                 // 0: no WEP; 1: 64-bit WEP; 2: 128-bit WEP; 3: 256-bit WEP
        char resv[63];           // reserved
    } apnt;
#elif PSIS_SONICPLUS_FAMILY()
    struct{
        char ssid[32];  // SSID
        BYTE channel; //channel
        BYTE pp_method;     // passphrase method:
                            // 0: hex (no passphrase)
                            // 1: Intersil
                            // 2: Lucent
        BYTE security; //security. 0: no WEP; 1: 64-bit WEP; 2: 128-bit WEP; 3: 256-bit WEP
        BYTE select_wep_key;  //selected security key, range: 0 to 3
        BYTE wep_key[120]; //security key
                           // 64-bit:
                           //     52 bytes  4 , C@Ӭ 13 bytes
                           //     4  WEP keys Ob byte 0-5, 13-18, 26-31, 39-44 m
                           //     C WEP key u 5  bytes, ]OH WORD , ] 6  bytes
                           // 128-bit:
                           //     52 bytes  4 , C@Ӭ 13 bytes
                           //     4  WEP keys Ob byte 0-12, 13-25, 26-28, 39-51 m
                           // 256-bit:
                           //     52 bytes  2 , C@Ӭ 26 bytes
                           //     2  WEP keys Ob byte 0-25, 26-51 m
        char pp_string[32]; // passphrase key string, max length=32
        BYTE area_code;     // area code, this will used to decide what channels will be supported
        BYTE wireless_mode; // Wireless Mode. The meaning of value are defined as "WLAN_MODE_xxx" constants in wlan.h
        WORD basic_rate;    // Basic Rate. This field is a bit-map of basic data rates.
                            // Its value specifies the basic rates used
                            // and reported for this BSS by the AP.
                            // Bit       Data Rate
                            //  0           1 Mbps
                            //  1           2 Mbps
                            //  2         5.5 Mbps
                            //  3          11 Mbps
                            //  4          22 Mbps
                            // ***** NOTE *****
                            // The meaning of this item's value depends on the definition of both Intersil 802.11b and TI 802.11b+
        WORD enhanced_security;  // Allows configuration of enhanced security items in the AP.
                                 // Bit       Control
                                 //  0        Hide SSID name in Beacon frame
                                 //  1        Block response to "Unspecified-SSID"
                                 // 2~15      Reserved (set to 0)
                                 // ***** NOTE *****
                                 // The meaning of this item's value depends on the definition of Intersil
        WORD frag_threshold;     // Fragmentation Threshold (Even number from 256 to 2346)
        WORD cts_rts_threshold;  // CTS/RTS Threshold
                                 // range: 0 ~ 3000 for Intersil 802.11b
                                 //        256 ~ 2432 for TI 802.11b+
        WORD supported_rate;     // Supported Rate. This field is a bit-map of basic data rates.
                                 // Its value specifies the basic rates used
                                 // and reported for this BSS by the AP.
                                 // Bit       Data Rate
                                 //  0           1 Mbps
                                 //  1           2 Mbps
                                 //  2         5.5 Mbps
                                 //  3          11 Mbps
                                 //  4          22 Mbps
                                 // ***** NOTE *****
                                 // The meaning of this item's value depends on the definition of both Intersil 802.11b and TI 802.11b+
        BYTE prev_security;      // OϥΪ̤W@ܪ security type
                                 // HKbϥΪ̭쥻FY WEP Type, F WEP,
                                 // MS^_쥻 WEP type , ڭ̥iHܥT WEP 
                                 // 0: no WEP; 1: 64-bit WEP; 2: 128-bit WEP; 3: 256-bit WEP
        BYTE preamble_type;        // 0: long preamble;  1: short preamble
        BYTE authentication_type;  // 0: open system;  1: shared key;  2: Both
        BYTE antenna_selection;    // 1: Left antenna only;  2: Right antenna only;  3: Diversity;  0 N default  3
        WORD beacon_interval;      // range: 1 ~ 1000; : msec; 0 N default  100
        WORD DTIM_interval;        // range: 1 ~ 65535; 0 N default  3
        char resv[48];             // reserved
    } apnt;
#else
    char resv_apnt[256];           // reserved
#endif
*/
//bishan
char resv_apnt[256];
    /* (520) 8+8*64 properties of MAC */
    struct {
        WORD flag;
        BYTE resv[6];
        struct {
            BYTE mac[6];
            BYTE ip;
            BYTE prop;
        } list[PMAC_NUM];  // PMAC_NUM = 64
    } pmac;
    /* (76) 8*5+36 local3 */
    struct {
        struct {
            BYTE    gip[4];     /* global IP */
            BYTE    lip;        /* local IP */
            BYTE    flag;
            char    resv_mnat[2];  // for alignment
        } mnat[MNAT_NUM];
        DWORD   real_max_speed;  // added by Herbert at 2002/01/17
        char    resv1[20];
        WORD    raport;
        BYTE    acct[2];
        BYTE    wolmac[6];
        char    resv2[2];
    } local3;

    // (4) Syslog
    struct {
        unsigned char enabled;   // does Syslog enabled. 1: enabled; 0: disabled
        unsigned char host_ip;   // host ip for Syslog
        char resv2[2];
    } syslog;

    /* (64) */
    char resv_syslog[64];

    /* (260) Email Alert */
    struct {
        unsigned short port;	// default=0 means using port 25.
    	BYTE enable;		// default=0 means disable
        BYTE select;		// what kinds of log will be emailed
        char smtp_server[64];	// DNS allowed
        char receiver[128];	// allow multiple receivers
        char subject[64];	// default is null string
    } emalt;

    /* (107) */
    char resv_emalt[107];

    /* (1536) acctpool1 */
    unsigned char use_acctpool2;  // 0: use acctpool1;  1: use acctpool2
    struct {
        char    desc[16];       /* DESCription */
        char    user[54];
        WORD    flag;           // auto-reconnect
        char    pass[24];
        char    tel[32];
        struct {
                BYTE ip[4];
        } dns[2];
        BYTE    ip[4];
        DWORD   baud;
        WORD    mtu;
        WORD    to;             // max. idle time
        char    init[82];
        char    resv[26];
    } acctpool[6];

    // (836) SNMP
    struct {
        unsigned short flags;
        char resv[2];
        unsigned char community[2][32];
        unsigned char  sys_contact[256];
        unsigned char  sys_name[256];
        unsigned char  sys_location[256];
    } psnmp;
    // (252) reserved for SNMP future using
    char        snmp_resv[252];
    // (4) Dynamic Routing
    struct {
    	unsigned short enable_flags;  // bit 0: to indicate whether RIP1/RIP2 is enabled or disabled
                                      // others: reserved
    	char resv[2];
    } dyna_route;
    // (512) Routing Table
    STRoutingTableEntry rtab[RTAB_NUM];
    /* 3244 (340) ddns */
    struct {
    	BYTE	flag;
    	BYTE	provider;
    	char    resv[2];
    	char	fqdn[64];	//Full Qualified Domain Name
    	char	user[64];	//username to login DDNS provider
    	char	pass[64];	//password to login DDNS provider, sometimes, e-mail address
    	char	cmds[256];	//command string
    } ddns;

    /* (128) */
    char resv_ddns[128];

    /* (4608) 256x16, acctpool2 */
    struct {
        char	desc[16];	//DESCription
        char    user[54];	//account name of ISP account
        WORD    flag;       // auto-reconnect
        char    pass[24];	//password of ISP account
        char    tel[32];	//Tel number for dial-up
        struct {
                BYTE ip[4];
        } dns[2];           //dns IP address
        BYTE    ip[4];		//WAN IP assigned by ISP
        DWORD   baud;       //baud rate
        WORD    mtu;
        WORD    to;
        char    init[82];
        BYTE    wtypex;		//extended WAN type (low byte of little endian word)
        BYTE    wtype;		//WAN type (high byte of little endian word)
        char    resv[56];
    } acctpool2[16];

    /* (128) */
    char resv_acctpool2[128];

    /* (80) Simple NTP */
    struct {
    	long tz_min;	// time zone offset, in minute; (can be negative)
    	char dnip[64];	// Time Server, domain name
    	BYTE autosync;	// Auto sync, 0:disable, maybe 1:per day, 2:per week,...
    	BYTE timezone;	// the index of SELECT with rspected to UI
    	char resv[10];
    } sntp;

    /* (128) */
    char resv_sntp[128];

    /* (132) 802.1X & RADIUS */
    struct {
    	unsigned long timeout;	// when to re-auth, in 0.1 second
    	char server[64];	// RADIUS server IP, domain name allowed
    	BYTE enable;		// default=0 :disable
    	char key[63];		// share key
    } radius;

    /* (128) */
    char resv_radius[128];

#ifdef _IPSEC

    #define MAX_NUMBER_OF_TUNNELS         16
    #define MAX_NUMBER_OF_IKE_PROPOSALS   20
    #define MAX_NUMBER_OF_IPSEC_PROPOSALS 20
    #define IPSEC_ENTRY_NAME_LEN          20

    /* (3652) IPSec */
    struct {

        char if_enable_ipsec;
        char max_number_of_tunnels;
        char resv[2];
        struct {
            char          tunnel_name[IPSEC_ENTRY_NAME_LEN];
                          //first char with 0 value stands for
                          //the tunnel information is not available
            BYTE          local_subnet[4];
            BYTE          local_netmask[4];
            BYTE          remote_subnet[4];
            BYTE          remote_netmask[4];
            BYTE          remote_gateway[4];
            unsigned char type_of_key_method;//0: IKE; 1: Manual
            char          resv[3];
            union {
                struct {
                    unsigned char ike_proposal_index[4];    // index of selected IKE proposal
                                                            // 0xff indicates no indexing
                                                            // at least one element with non-ff value
                    unsigned char ipsec_proposal_index[4];  // index of selected IPSec proposal
                                                            // 0xff indicates no indexing
                                                            // at least one element with non-ff value
                    unsigned char preshared_key[20];
                    char          resv[76];
                } ike;
                struct {
                    unsigned long local_spi;
                    unsigned long remote_spi;
                    unsigned char encryption_key[3][16];
                    //for ESP only; DES: 1*16 nibbles, 3DES: 3*16 nibbles
                    //value of a nibble is among the set of "0"~"9" and "a"~"f"
                    unsigned char encap_protocol;
                    //AH_TUNNEL(1); AH_TRANSPORT(2); ESP_TUNNEL(3);
                    //ESP_TRANSPORT(4); ESP_TUNNEL_WITH_AUTH(5);
                    //ESP_TRANSPORT_WITH_AUTH(6);
                    unsigned char encrypt_algorithm;
                    //0:none; 1:DES; 2:3DES
                    unsigned char auth_algorithm;
                    //0:none; 1:MD5; 2:SHA1
                    unsigned char life_time_unit;
                    //1:second; 2:KB;
                    unsigned char auth_key[40];
                    //SHA1: 20 bytes=40 nibbles;  MD5: 16 bytes;  None: 0 byte
                    //value of a nibble is among the set of "0"~"9" and "a"~"f"
                    unsigned long life_time;
                    //may be in second or KB unit
                } manual;
            } key_method ;

        } Tunnel_Info[MAX_NUMBER_OF_TUNNELS]; //16

        struct {
            char          proposal_name[IPSEC_ENTRY_NAME_LEN];
                          //first char with 0 value stands for
                          //the proposal is not available
            unsigned char dh_group;              // 1:MODP768, 2:MODP1024, 5:MODP1536
            unsigned char encrypt_algorithm;     // 5:3DES;  1:DES
            unsigned char auth_algorithm;        // 2:SHA1;  1:MD5
            unsigned char life_time_unit;        // 1:second;  2:Kbyte
            unsigned long life_time;
            char          resv[4];
        } IKE_Proposal_Pool[MAX_NUMBER_OF_IKE_PROPOSALS];

        struct {
            char          proposal_name[IPSEC_ENTRY_NAME_LEN];
                          //first char with 0 value stands for
                          //the proposal is not available
            unsigned char dh_group;              // 0:none 1:MODP768, 2:MODP1024, 5:MODP1536
            unsigned char encap_protocol;        // 3: ESP;  2: AH
            unsigned char encrypt_algorithm;     // 2: 3DES;  1: DES;  0: none only for AH
            unsigned char auth_algorithm;        // 2: SHA1;  1: MD5;  0: None for ESP only
            unsigned long life_time;             //
            unsigned char life_time_unit;        // 1: second; 2: Kbyte;
            char          resv[3];
        } IPSec_Proposal_Pool[MAX_NUMBER_OF_IPSEC_PROPOSALS];

    } ipsec;
#else
    char resv_ipsec[3652];
#endif  // ifdef _IPSEC

    /* O=0x1DF0 L=0x208(520) U=domain control */
    struct {
    	struct {
    	    char suffix[DCTL_SUFFIX_SZ];	//domain name suffix
    	    BYTE flag;		//bit0: 1=enable rule, bit1: 0=pass,1=block bit2=log
    	} rules[DCTL_RULE_NUM];
    	BYTE	privilege[2];	//ip range that have privilege
    	BYTE	flag;		//bit0: 1=enable all
    	                        //bit1: 0=pass, 1=block if no rule matched
    	                        //bit2: 1=log if no rule matched
    	                        //bit4: log enable
    	BYTE	resv_flag;
    	BYTE	resv[2];
    	int	rule_count;	//use as variable only, not configuration item
    } dctl;

} ACONFIG;

#ifdef _IPSEC

  typedef struct {

//    #include "..\ipsec\ipsec.h"

    struct cfg_IPSecGlobalStatus_t {
      char if_enable_ipsec;
      char if_use_isakmp;        // (0)only manual keying SA, (1)IKE supported
    } cfg_IPSecGlobalStatus;

    /* --- IPsec SA DB --- */
    char    num_of_StaticSA;               // <= MAX_STATIC_IPSEC_SA

    struct  cfg_SA_Info {
      unsigned long SABundle_id;           /* 4,bundle ID, 1~MAX_STATIC_IPSEC_SA */
      unsigned long priority;              /* 4,## */
      unsigned char direction;             /* 1,OUTBOUND/INBOUND */
      unsigned long spi;                   /* 4,index in SA list */
      char     local_ip_str[IP_LENS];      /* 16,packet local ip address, ## */
      char     local_netmask_str[IP_LENS]; /* 16,local netmask, ## */
      unsigned short local_upper_port;     /* 2,packet local upper port, ## */
      unsigned short local_lower_port;     /* 2,packet local lower port, ## */
      char     remote_ip_str[IP_LENS];     /* 16,packet remote ip address, ## */
      char     remote_netmask_str[IP_LENS];/* 16,remote netmask, ## */
      unsigned short remote_upper_port;    /* 2,packet remote upper port, ## */
      unsigned short remote_lower_port;    /* 2,packet remote lower port, ## */
      char     peer_IKE_str[IP_LENS];      /* 6,peer IKE IP, ## */
      unsigned char proto;                 /* 1,protocol number in ip header, ## */
      unsigned char ipsec_mode;            /* 1,AH_TUNNEL or ESP_TUNNEL, ipsec.h */
      unsigned char auth_algorithm;        /* 1,Authentication algorithm, HMAC_MD5 or HMAC_SHA1*/
      unsigned char authenticator[50];     /* 50,Hash key */
      unsigned char cipher_algorithm;      /* 1,Encryption algorithm: DES_CBC*/
      unsigned char cipher[80];            /* 80,Encryption key */
      unsigned char esp_iv[20];            /* 20,ESP's initialization vector (only for outboundSA)*/
      unsigned char life_type;             /* 1,SA lifetime type */
      unsigned long life_deadline;         /* 4,the deadline (seconds) of SA (Sec mode) */
      unsigned long life_availableKB;     /* 2,the available kbytes for SA */
    } cfg_SADB[MAX_IPSEC_SA];

    // ## NOTE: these fields of all SAs with the same bundle ID should be identical
    //          otherwise, only the 1st SA's parameters are referred

    /* -------------------------- */
    /* --- Security Policy DB --- */
    /* -------------------------- */

    // 1. IPsec Action Pool

    char    num_of_cfg_IPsecAction;
            /* should be smaller than 'MAX_STATIC_IPSEC_ACTION' */

    struct IPsecAction_t
    {

      char           reserved[1];
      char           status;                                         // 1, (0)ENTRY_FREE, (1)ENTRY_USED
      char           name[IPSEC_ENTRY_NAME_LEN];
                     // 20, identified name for this action

      unsigned char  ESP_mode; // 1, (0)none, (1)tunnel, (2)transport (ike/idoi.h)

      unsigned short num_of_ESP_Transform;// 2,

      struct ESPTransform_t
      {
        unsigned char  cipher_alg;             // 1, (0)none, (1)DES-CBC, (2)3DES
        unsigned short cipher_key_len;         // 2,
        unsigned char  integrity_alg;          // 1, (0)none, (1)HMAC-MD5, (2)HMAC-SHA1
        unsigned short integrity_key_len;      // 2,
      } ESPTransform[MAX_IPSEC_ESP_TRANSFORM]; // 6*5

      unsigned char  AH_mode;             // 1, (0)none, (1)tunnel, (2)transport

      unsigned short num_of_AH_Transform; // 2,

      struct AHTransform_t
      {
        unsigned char  integrity_alg;        // 1, (0)none, (1)HMAC-MD5, (2)HMAC-SHA1
        unsigned short integrity_key_len;    // 2,
      } AHTransform[MAX_IPSEC_AH_TRANSFORM]; // 3*2

      unsigned char order;        // 1, (0)none--single IPsec mode, (1)ESP_First, (2)AH_First
      unsigned char pfs;          // 1, (0)none, (1)MODP768 (refer to IKE/iked.h)
      unsigned char life_type;    // 1, (1)LIFETYPE_SEC,(2)LIFETYPE_KB,(3)LIFETYPE_HYBRID,(4)LIFETYPE_ENDLESS
      unsigned long life_max_sec; // 4, the longest lifetime for SA (Sec mode)
      unsigned long life_max_kb;  // 4, the max kbytes for SA

    } cfg_IPSecActionPool[MAX_STATIC_IPSEC_ACTION];

    // 2. IPsec Policy DB
    char    num_of_cfg_IPsecPolicy; // should be smaller than 'MAX_STATIC_IPSEC_POLICY'

    struct cfg_IPsecPolicy_t                        // NOTE: this structure is different from the format of run-time IPsecPolicy
    {
      char           name[IPSEC_ENTRY_NAME_LEN];    // 20, identified name for this policy
      unsigned long  priority;                      // 4, smaller value is higher priority
      unsigned char  startup;                       // 1, (0)disable, (1)onBoot , (2)onDataTraffic
      unsigned char  direction;                     // 1, (0)bi-dir, (1)outbound, (2)inbound
      char           local_ip_str[IP_LENS];
      char           local_netmask_str[IP_LENS];
      unsigned short local_upper_port;
      unsigned short local_lower_port;
      char           remote_ip_str[IP_LENS];
      char           remote_netmask_str[IP_LENS];
      unsigned short remote_upper_port;
      unsigned short remote_lower_port;
      unsigned char  protocol;
      char           peer_IKE_str[IP_LENS];
      unsigned char  num_of_IPsecAction;            // 1, number of available actions in the following list
      unsigned char  IPsecAction[MAX_IPSEC_ACTION]; // , list of IPsecAction Index
    } cfg_IPsecPolicyDB[MAX_IPSEC_POLICY];

    // 3. IKE Action Pool
    char    num_of_cfg_IKEAction; // should be smaller than MAX_STATIC_IKE_ACTION

    struct IKEAction_t
    {
      char          reserved[2];
      char          status;                     // 1, (0)ENTRY_FREE, (1)ENTRY_USED
      char          name[IPSEC_ENTRY_NAME_LEN]; // 20, identified name for this action
      unsigned char auth;                       /* 1,authentication method, 1:pre-shared key */
      unsigned char hash;                       /* 1,hash algorithm, 1:MD5 */
      unsigned char cipher;                     /* 1,cipher algorithm, 1:DES_CBC, 5:3DES_CBC */
      unsigned char group;                      /* 1,initial group name, 1:MODP768 */
      unsigned char life_t;                     /* 1,LIFETYPE_SEC/LIFETYPE_KB/LIFETYPE_HYBRID */
      unsigned long lifetime_sec;               /* 4,lifetime seconds */
      unsigned long lifetime_kb;                /* 4,lifetime KB */
    } cfg_IKEActionPool[MAX_STATIC_IKE_ACTION];

    // 4. IKE Policy DB
    char    num_of_cfg_IKEPolicy;              // should be smaller than MAX_STATIC_IKE_POLICY

    struct cfg_IKEPolicy_t
    {
      char           peer_IKE_str[IP_LENS];    // 16, ip address of peer Security Gateway
      unsigned char  startup;                  // 1, (0)disable, (1)onBoot , (2)onDataTraffic
      unsigned short auth_data_size;           // 2, (byte) size of auth_data
      unsigned char  auth_data[128];           // 128, to store the pre-shared key
      unsigned char  num_of_IKEAction;         // 1, number of available actions in the following list
      unsigned char  IKEAction[MAX_IKE_ACTION];// , list of IKEAction Index
    } cfg_IKEPolicyDB[MAX_IKE_POLICY];

  } BCONFIG;

#endif /* _IPSEC */

extern ACONFIG Aconfig;
extern char ispScript[];
#define MAX_SCRIPT_SIZE         480

int read_Aconfig(ACONFIG *a);
int write_Aconfig(ACONFIG *a);
int check_passwd(char *pass);
int encrypt_passwd(char *encrypt, char *pass, int len);
int decrypt_passwd(char *pass, char *encrypt, int len);

#define PASSWD_SUPER    2
#define PASSWD_ROOT     1
#define PASSWD_NONE     0

#define DCE_FUNC_DUN    0x01
#define DCE_FUNC_FAX    0x02
#define DCE_FUNC_DIN    0x04

/***********************/
/* our own return code */
/***********************/

/* AMIT ok code +100 ~ */
#define AOC_PEER_CLOSE          100
#define AOC_SERV_TIMEOUT        101

/* AMIT error code -100 ~ */
#define AEC_NINIT_FAIL          -100
#define AEC_PINIT_FAIL          -101
#define AEC_PERIOD_FAIL         -102
#define AEC_NO_BUFFERS          -103
#define AEC_CONNECT_FAIL        -104
#define AEC_FORK_FAIL           -105

/*************/
/* for httpd */
/*************/

/* for httpd.c */
#define HTTP_V09                1
#define HTTP_V10                2

/*************/
/* for modem */
/*************/

#define WAN_NETNO               3

/* MODEM_NUM, N2MODEM(), M2NETNO() is critical to netconf.c */
#define MODEM_NUM               2

/* netno to modem index conversion */
/* depend on netconf.c */
#define N2MODEM(x)              ((x)==2)        //(((x)!=2)?0:1)  //Net for COM2
#define M2NETNO(x)              ((x)+1)
#define N2NAME(x)               (x)             //netno=1, com=1
#define M2NAME(x)               ((x)+1)         //mno=0, com=1
#define LAN_NETNO_LB            0

#define NETNO2IP(x)             (x)
#define IP2NETNO(x)             (x)

/* LAN v.s MODEM */
#define LAN_PORT_NUM            1
#define LAN_NETNO_UB            (LAN_NETNO_LB+LAN_PORT_NUM-1)

/* LANno to NETno convserion */
#define L2NETNO(x)              ((x)+LAN_NETNO_LB)
#define N2LANNO(x)              ((x)-LAN_NETNO_LB)

#if LAN_NETNO_LB == LAN_NETNO_UB
    #define IS_LAN(x)           ((x)==LAN_NETNO_LB)
#else
    #define IS_LAN(x)           (LAN_NETNO_LB<=(x) && (x)<=LAN_NETNO_UB)
#endif

/* track modem status */
#define MS_STABLE               0x01
#define MS_TRANSIT              0x40    /* stable after 6*2 sec(0x20 = 0b01000001) */
#define MS_TRANSIT2             0x08    /* stable after 2*2 sec(0x20 = 0b00000101) */

/* modem flag */
#define MF_BEEN_SHUTED          0x01
#define MF_BAUD_CHANGED         0x02
#define MF_TO_DIALUP            0x04
#define MF_TO_HANGUP            0x08
#define MF_LOW_RTS              0x80

struct _modem {
    unsigned char transit_state;
    unsigned char stable_state;
    unsigned char misc_flag;
    unsigned char transit_flag;
    char connect_speed[24];
#ifdef LOG_TRAFFIC
    long load;
    int  index;
    long rxbc[LOG_TRA_SIZE];
    long txbc[LOG_TRA_SIZE];
#endif
};

/*************/
/* for PPPoE */
/*************/

#define PPPOE_PADT              0
#define PPPOE_PADI              1
#define PPPOE_PADO              2
#define PPPOE_PADR              3
#define PPPOE_PADS              4

#define PPPOE_TODIAL            6
#define PPPOE_TODISC            7
#define PPPOE_CONNECT           8       //connect state 1
#define PPPOE_BROKEN            9       //connect state 2

/************/
/* for PPTP */
/************/

#define PPTP_DISCONNECT         0
#define PPTP_TODIAL             1
#define PPTP_CONNECTING         2       //Control connection OK
#define PPTP_TODISC             3
#define PPTP_DISCONNECTING      4       //PPP close OK

#define PPTP_CONNECT            PPPOE_CONNECT      //connect state 1
#define PPTP_BROKEN             PPPOE_BROKEN       //connect state 2

/***************/
/* for dial-up */
/***************/

#define DF_NO_DIAL              1
#define DF_NO_LAST              2
#define DF_MANUAL               4

/* status for COMx */
#define DIALUP_ALREADYCONNECTED 10 /* for inter_dial(), cgi.c only */
#define DIALUP_DIALEDIN         5 /* for DIAL-IN */
#define DIALUP_FAXING           4
#define DIALUP_HANGING_UP       3 /* hang-up in proces */
#define DIALUP_CONNECTED        2
#define DIALUP_DIALING_UP       1 /* dial-up in proces */
#define DIALUP_DISCONNECTED     0
#define DIALUP_NO_POWER         -1
#define DIALUP_FAIL             -2

#define CONNECT_MODE(cs)         ((cs)==DIALUP_CONNECTED || (cs)==DIALUP_DIALEDIN)

int dod_connect_count(int mno);
unsigned long dod_connect_time(int mno);
int check_online(int ip);

#ifdef LITTLE
/* Host to Big-endian - Long : Hsujp */
#define H2BL(x)         (((unsigned long)(x)<<24) |           \
                        (((unsigned long)(x)&0xFF00)<<8) |    \
                        (((unsigned long)(x)>>8)&0xFF00) |    \
                        ((unsigned long)(x)>>24))
/* Host to Big-endian - Short */
#define H2BS(x)         ((unsigned short)(x<<8) | (unsigned short)(x>>8))	//wallance 90.11.22
#else
#define H2BL(x)         (x)
#define H2BS(x)         (x)
#endif

#define B2HL(x)         H2BL(x)
#define B2HS(x)         H2BS(x)

/* redefine by Aries, 2002/08/08
//* DCVAL = Double Char Value
#ifdef LITTLE
  #define DCVAL(x, y)   (((unsigned short)(y)<<8) + (x))
#else
  #define DCVAL(x, y)   (((unsigned short)(x)<<8) + (y))
#endif
*/

/* QB=Quad-Byte, DB=Dual-Byte
   UL=Unsigned-Long, SL=Signed-Long
   US=Unsigned-Short, SS=Signed-Short */
#define QB2UL(x)        (*(unsigned long*)(x))
#define QB2SL(x)        (*(signed long*)(x))
#define DB2US(x)        (*(unsigned short*)(x))
#define DB2SS(x)        (*(signed short*)(x))

/***************/
/* for buffer  */
/***************/
int Ainitbuf(void);
char *Agetbuf(void);
int Arelbuf(char *p);
#define POOL_NUM        16

/*******************/
/* for printer/fax */
/*******************/
#define QUEUE_NUM       2

/* int get_printer(int pno, unsigned long timeout, int (*callback)(), int from); */
int get_printer(int pno, unsigned long timeout, int from);
unsigned do_print(int pno, char *buf, int len);
unsigned get_print_status(int pno);
int rel_printer(int pno, int kill);

int get_fax(void (*callback)(int, unsigned char), int from, int conno);
unsigned do_fax(int conno, char *buf, int len);
unsigned get_fax_status(void);
int query_fax(void);

#define PRN_READY       0x0000    /* ready to print */
/* the following are intended to assign as negative value */
#define PRN_PRINTING    0x8001    /* job is submitted ok */
#define PRN_BUSY        0x8002    /* locked by other process, or queue full */
#define PRN_UCERROR     0x8004    /* un-classfied error */
#define PRN_NOTREADY    0x8008    /* not ready: no printer of power off */
#define PRN_OUTOFPAPER  0x8010    /* out of paper */
#define PRN_PGMERROR    0x8080    /* programimg error */

#if defined(CPU_IS_AM186)
#define FQUEUE_LEN      16
#define PQUEUE_LEN      ((65535U-1024)/BUFF_SIZE)       /* 1K for stack */
#else
#define FQUEUE_LEN      4
#define PQUEUE_LEN      8
#endif

/*********************/
/* for task priority */
/*********************/

#define PRIOR_START_DAEMONS     (NET_PRIOR+10)
#define PRIOR_MONITOR           (NET_PRIOR+9)
#define PRIOR_DIALUP            (SERV_PRIOR)    //(NET_PRIOR-1)   //(NET_PRIOR+7)
#define PRIOR_CONSOLE           (NET_PRIOR)     //must be
#define PRIOR_HTTPD             (SERV_PRIOR)
#define PRIOR_AMITD             (SERV_PRIOR)
#define PRIOR_PRINTD            (SERV_PRIOR)
#define PRIOR_FAXD              (SERV_PRIOR)
#define PRIOR_LPD               (SERV_PRIOR)
#define PRIOR_DHCPD             (SERV_PRIOR)
#define PRIOR_POP3D             (SERV_PRIOR)
#define PRIOR_IPNAME            (SERV_PRIOR)
#define PRIOR_DNSD              (SERV_PRIOR)
#define PRIOR_FTPD              (SERV_PRIOR)    //(SERV_PRIOR-9)
#define PRIOR_SNMPD             (SERV_PRIOR)    //(SERV_PRIOR-9)
#define PRIOR_UPNPD             (SERV_PRIOR)    //(SERV_PRIOR-9)
#define PRIOR_SYSLOGC           (SERV_PRIOR)
#define PRIOR_LOW_MONITOR       (SERV_PRIOR)
#define PRIOR_DDNSC             (SERV_PRIOR)
#define PRIOR_IKED              (SERV_PRIOR)

#ifdef P_SERVER
    #define PRIOR_RESPONSE1     (SERV_PRIOR)
    #define PRIOR_PSERVER       (SERV_PRIOR)
    #define PRIOR_REGISTER      (SERV_PRIOR)
    #define PRIOR_MAILSLOT      (SERV_PRIOR)
#endif

/*************************/
/* for flash programming */
/*************************/

int open_flashbuf(void);
int write_flashbuf(char *buf, unsigned len);
int close_flashbuf(void);
int dump_flashbuf(void);

/****************/
/* for ip flags */
/****************/

//#define SET_IPFLAG(x,ip,type)   ((x).flag.val[(ip)] |= (type))
//#define CLR_IPFLAG(x,ip,type)   ((x).flag.val[(ip)] &= ~(type))
//#define TEST_IPFLAG(x,ip,type)  ((x).flag.val[(ip)] & (type))

/* IP Flag type, in fact, bit offset */
#define IPF_ACC_GROUP   0x0007    /* access group */
//#define IPF_DHCPD_NOTP  0x0100    /* not ip pool */
//#define IPF_DHCPD_USED  0x0200    /* is used */

/*********************/
/* for resource data */
/*********************/

/*  RESLANG(0) default
    RESLANG(1) post-setting
*/
//char *normalize_segoff_address(char *base, unsigned long offset);	//marked by wallance 90.11.29 -- defined in common.c
//#define RESDATA(x)  normalize_segoff_address((char*)0xE0000000L,*(unsigned long*)(0xE0000020L+sizeof(long)*x))	//old code --wallance
//#define RESDATA(x)  normalize_segoff_address((char*)DATA_BASE,*(unsigned long*)(DATA_BASE+0x20+sizeof(long)*x))	//wallance 90.11.26
#define RESDATA(x)  (unsigned char*)(FLASH_START + DATA_START + *(unsigned long*)(FLASH_START + DATA_START + DATA_OFS_ENTRY + (x<<2)))	//wallance 90.11.29

#define RES_IDX_NUM_URITAB      0
#define RES_IDX_PAGESDATA       1
#define RES_IDX_PAGE_HEAD       2
#define RES_IDX_BODY_HEAD       3
#define RES_IDX_DDNS_PROVIDER   3
#define RES_IDX_REBOOT_PAGE     4
#define RES_IDX_SSI_DATA        5
/* #define RES_IDX_CGI_DATA        6 */
#define RES_IDX_ODM_DATA        7
#define RES_IDX_PATCH_OLV       9

	//replaced by wallance 90.11.29
//extern const char CodeName[];	//old code -- wallance
extern const char *CodeName;	//wallance 90.11.29
extern char VersionName[];
char *ROMstring(int,int);

/*******************/
/* for LED display */
/*******************/

extern unsigned short CurrStatus;
#define CURRS_DUN1      0x0001
#define CURRS_DUN2      0x0100          /* should be ((CURRS_DUN1)<<8) */
#define CURRS_DIN1      0x0002
#define CURRS_DIN2      0x0200          /* should be ((CURRS_DIN1)<<8) */
#define CURRS_FAX1      0x0008
#define CURRS_FAX2      0x0800          /* should be ((CURRS_FAX1)<<8) */

#define CURRS_DHCPC     0x0040
#define CURRS_PRN       0x0080
#define CURRS_UPGRADE   0x8000

/* for DIAL-IN */
#define CURRS_DXN1      (CURRS_DUN1+CURRS_DIN1)
#define CURRS_DXN2      (CURRS_DUN2+CURRS_DIN2)

#define COM_IS_BUSY(m)  (CurrStatus & ((CURRS_DXN1+CURRS_FAX1)<<(8*(m))))

void update_curr_status(unsigned short status);
#define IDLE_STATUS(x)  ((x) == 0)
#define BUSY_STATUS(x)  ((x) != 0)
#define ENTER_STATE(x)  update_curr_status(CurrStatus |   (x) )
#define LEAVE_STATE(x)  update_curr_status(CurrStatus & (~(x)))

/*********************/
/* for user accounts */
/*********************/

#define MAX_USER_ID_LENGTH 15
#define MAX_USER_PASSWORD_LENGTH 9
struct STUser {
  char id[MAX_USER_ID_LENGTH + 1];  /* user id \]t " < : , Ϊťյr */
  char password[MAX_USER_PASSWORD_LENGTH + 1];
  unsigned char resv[4];
  unsigned short rights;
};

#define USER_DATA       struct STUser

/* User Rights */
#define UR_CHECKMAIL    0x0001
#define UR_DIALIN       0x0002
#define USER_CAN(x, y)  (((x)->rights & (y)) == 0)

/**********************/
/* for common routine */
/**********************/

//int sscan_ip(char *buf, int *ip);	//marked by wallance 90.11.30
#define SAME_NET(a, b, m)       (((a)&(m)) == ((b)&(m)))
#define P2LONG(x)               (*(unsigned long*)(x))

#define MAXPFLEN        256

/* don't change, this is configured values stored in coninfo */
#define IS_WT_PPP(x)    ((x)&0x02)
#define WT_STATIC       0x00
#define WT_DYNAMIC      0x01
#define WT_PPPOE        0x02    /* bit1 PPP 0010 */
#define WT_PPTP         0x03    /* bit1 PPP 0011 */
#define WT_DUN          0x06    /* bit1 PPP 0110 */

/* Aconfig.local.wtypex for Aconfig.local.wtype = WT_STATIC */
#define WTEX_STATIC      0x00	/* WAN type : static IP address */

/* Aconfig.local.wtypex for Aconfig.local.wtype = WT_DYNAMIC*/
#define WTEX_DYNAMIC    0x00	/* WAN type : dynamic IP address */
#define WTEX_ROADRUNNER 0x01	/* WAN type : Road Runner Session Management (Telstra BigPond) */

/* Aconfig.local.wtypex for Aconfig.local.wtype = WT_PPPOE*/
#define WTEX_PPPOE      0x00	/* WAN type : PPPoE */
#define WTEX_UNNUMBERED_PPPOE 0x01	/* WAN type : unnumbered PPPoE */
#define WTEX_MULTI_SESSION_PPPOE 0x02	/* WAN type : multi-session PPPoE */

/* Aconfig.local.wtypex for Aconfig.local.wtype = WT_PPTP */
#define WTEX_PPTP      0x00	/* WAN type : PPPT */

/* Aconfig.local.wtypex for Aconfig.local.wtype = WT_DUN */
#define WTEX_DUN       0x00	/* WAN type : dial-up network (PSTN/ISDN) */

/*
  //modififed by wallance 91.4.25 -- for S5N8947
  #if PSIS_CPU_TYPE() == CPU_CONXT_ARM9
    #define PRINTER_BUFFER	0x00F80000		//buffer for data printed
                                            //15.5MB ~ 16MB => 512 KB
                                            //memory size : MAX_FLASHBUF(128KB) defined in FLASHBUF.c
  #elif PSIS_CPU_TYPE() == CPU_SAMSUNG_ARM7
    #define PRINTER_BUFFER	0x00380000		//buffer for data printed
                                            //3.5MB ~ 4MB => 512 KB
                                            //memory size : MAX_FLASHBUF(128KB) defined in FLASHBUF.c
  #endif
*/

// functions to get the proper acctpool data from Aconfig
// the body of these functions are defined in coninfo.c
BYTE *acctpool_ip(ACONFIG *pConfig, int iAcctpoolIndex);
BYTE *acctpool_dns_ip(ACONFIG *pConfig, int iAcctpoolIndex, int iDNSIndex);
WORD acctpool_flag(ACONFIG *pConfig, int iAcctpoolIndex);
char *acctpool_pass(ACONFIG *pConfig, int iAcctpoolIndex);
char *acctpool_user(ACONFIG *pConfig, int iAcctpoolIndex);
char *acctpool_tel(ACONFIG *pConfig, int iAcctpoolIndex);
WORD acctpool_mtu(ACONFIG *pConfig, int iAcctpoolIndex);


// this should be not defined here!
#define Eid_SZ 6
struct Eid {unsigned char c[Eid_SZ];};
/* internal or IP address format */
#define Iid_SZ 4
typedef union {
    unsigned char  c[Iid_SZ];
    unsigned short s[Iid_SZ/2];
    unsigned long  l;
} Iid;
#define WLAN_STATE_INIT_OK    2    // WLAN card Ұ OK (lan.h)

#endif
