#include "dhcpd.h"
#include "flash.h"
#include "amit.h"

#define CurrDeciSec		(get_current_time())
extern int flashcpy(unsigned char *buf, unsigned char *src, int len);

int device_discover(struct Device_MSG *outMSG)
{
	int i;
	ACONFIG Aconfig;
	char SecID[] = {SecA_ID,SecB_ID,SecD_ID};
	long TagValue[] = {SecA_Tag,SecB_Tag,SecD_Tag};
	unsigned char c_temp[20];
	char VersionName[32] = {
#ifdef	FOR_DEBUG
		'T',	//---Means for TEST only
#else
    	'R',	//---Means for Release
#endif	//FOR_DEBUG
    	'1',
    	'.',
    	'0',
    	'0',
#if VER_CHR != '`'
    	'b',
#endif
    	'6',
    	'v',
    	0
	};
	
	//---init---
	outMSG->op=opReply;
	outMSG->pversion=protVer_1;
	outMSG->result=rAccept;
	outMSG->rlifetime=CurrDeciSec;
	read_Aconfig(&Aconfig);
	memcpy((char*)outMSG->cMAC,(char*)Aconfig.local3.wolmac, 6);	//AP_MAC ٥iH[iӬ
	
	for(i=0;i<SectionNumber;i++)
	{
		outMSG->sdata.infoData.secID[i]=SecID[i];
		outMSG->sdata.infoData.tagValue[i]=TagValue[i];
	}
	
	flashcpy(c_temp, (unsigned char *)normalize_addr(FLASH_START, ODM_START+ODM_ROM_ID), MAX_ROM_ID_LEN);
	memcpy(outMSG->dROMID, c_temp, MAX_ROM_ID_LEN);
	
	outMSG->dROMID[14] = '\0';

	memcpy((char*)outMSG->firmwareVer, VersionName, sizeof(VersionName));
	return(1);
} //device_discover()


void amitp (struct packet *packet)
{
	char l_arrayROMID[MAX_ROM_ID_LEN];
	char c_temp[20];
	struct packet outgoing;
	struct dhcp_packet raw;
	struct sockaddr_in to;
	struct in_addr from;
	struct hardware hto;
	struct Device_MSG *deviceMSG;
	struct iaddr ip_address;
	
	deviceMSG = packet -> raw;
	if((deviceMSG->op != opRequest) && (deviceMSG->op != opReply))
		return;//not AMITD protocol
	
	if(deviceMSG->pversion >protVer_1)
		return;
	
	flashcpy(c_temp, (unsigned char *)normalize_addr(FLASH_START, ODM_IMG_INFO), 16);
	if (c_temp[14]!='L' || c_temp[15]!='i')	//complete mark
		return;
	
	flashcpy(l_arrayROMID, (unsigned char *)normalize_addr(FLASH_START, ODM_START+ODM_ROM_ID), MAX_ROM_ID_LEN);
	if (l_arrayROMID[0] == 0xFF)
		return;

	if(strncmp((char*)deviceMSG->dROMID, l_arrayROMID, strlen((char*)deviceMSG->dROMID)) != 0)
		return; //discard this packet by ROMID error
	
	/* Set up the outgoing packet... */
	memset (&outgoing, 0, sizeof outgoing);
	memset (&raw, 0, sizeof raw);
	outgoing.raw = &raw;

	/* Take the fields that we care about... */
	raw.op = BOOTREPLY;
	raw.htype = packet -> raw -> htype;
	raw.hlen = packet -> raw -> hlen;
	memcpy (raw.chaddr, packet -> raw -> chaddr, sizeof raw.chaddr);
	raw.hops = packet -> raw -> hops;
	raw.xid = packet -> raw -> xid;
	raw.secs = packet -> raw -> secs;
	raw.flags = packet -> raw -> flags;
	raw.ciaddr = packet -> raw -> ciaddr;
	memcpy (&raw.yiaddr, ip_address.iabuf, sizeof raw.yiaddr);

	/* Set up the hardware destination address... */
	hto.htype = packet -> raw -> htype;
	hto.hlen = packet -> raw -> hlen;
	memcpy (hto.haddr, packet -> raw -> chaddr, hto.hlen);

	from = packet -> interface -> primary_address;

	switch(deviceMSG->comm)
	{
		case commDiscover :
			if(device_discover((struct Device_MSG *)&raw) < 0)
				return;
			break;
		case commUnlock :
			return;
		default:
			return;
	}

	/* Set up the parts of the address that are in common. */
	to.sin_family = AF_INET;
#ifdef HAVE_SA_LEN
	to.sin_len = sizeof to;
#endif
	memset (to.sin_zero, 0, sizeof to.sin_zero);

	/* If this was gatewayed, send it back to the gateway... */
	if (raw.giaddr.s_addr)
	{
		to.sin_addr = raw.giaddr;
		to.sin_port = local_port;

		if (fallback_interface)
		{
			send_packet (fallback_interface,
					      (struct packet *)0,
					      &raw, outgoing.packet_length,
					      from, &to, &hto);
			return;
		}

	/* If it comes from a client that already knows its address
	   and is not requesting a broadcast response, and we can
	   unicast to a client without using the ARP protocol, sent it
	   directly to that client. */
	}
	else if (!(raw.flags & htons (BOOTP_BROADCAST)) &&
		   can_unicast_without_arp ())
	{
		to.sin_addr = raw.yiaddr;
		to.sin_port = remote_port;

	/* Otherwise, broadcast it on the local network. */
	}
	else
	{
		to.sin_addr.s_addr = INADDR_BROADCAST;
		to.sin_port = remote_port; /* XXX */
	}

	send_packet (packet -> interface, packet, &raw, sizeof(struct Device_MSG), from, &to, &hto);
	return;
}
