/*
** Second, newer version of Brecis security engine.
**
** A.k.a. Solo or Polo security engine.
*/

/*
** Hardware details that are of use ONLY to the driver.
*/

#define HW_NR_WORK_QUEUES 2
#define HW_NR_COMP_QUEUES 2

#define SEC2_BASE 0xB8800200

/*
** requests to the hardware are placed in a "work queue".
** indications of completion are placed in a "completion queue".
**
** This structure describes the hardware's picture of a queue.
*/

struct sec2_q_regs {

	/* the registers live across a bus that's not all that efficient
	** to go across; shadow the registers whenever possible, access
	** them only when necessary.
	*/

	unsigned int      *avail_addr ;	/* software sets this pointer, */
					/* hw writes avail space there */

	unsigned int      avail ;	/* register version of avail */

	unsigned char     *base ;       /* base address of queue */
					/*
					** Must be aligned on the boundary
					** of the size of the buffer.
					** i.e. base & (size-1) == 0
					*/
	unsigned int      size ;        /* size of buffer */
	unsigned int      in ;          /* offset of in address */
					/* actual in is at base + in */
	unsigned int      out ;         /* offset of head address */
					/* actual out is at base + out */
} ;

struct sec2_regs {
	unsigned int		res1[5] ;

	unsigned int		sis ;	/* Solo Interupt Status */

				#define SEC2_INT_CQ0		0x000001
				#define SEC2_INT_CQ1		0x000002
				#define SEC2_INT_BAD_ADDR 	0x000004
				#define SEC2_INT_HASH_NON_64	0x000008
				#define SEC2_INT_DES_NON_8	0x000010
				#define SEC2_INT_AES_NON_16	0x000020
				#define SEC2_INT_WQ0_HIGH	0x000040
				#define SEC2_INT_WQ1_HIGH	0x000080
				#define SEC2_INT_CQ0_HIGH	0x000100
				#define SEC2_INT_CQ1_HIGH	0x000200
				#define SEC2_INT_WQ0_FULL	0x000400
				#define SEC2_INT_WQ1_FULL	0x000800
				#define SEC2_INT_CQ0_FULL	0x001000
				#define SEC2_INT_CQ1_FULL	0x002000
				#define SEC2_INT_WQ0_EMPTY	0x004000
				#define SEC2_INT_WQ1_EMPTY	0x008000
				#define SEC2_INT_CQ0_EMPTY	0x010000
				#define SEC2_INT_CQ1_EMPTY	0x020000
				#define SEC2_INT_BAD_GATHER	0x040000
				#define SEC2_INT_ICV_COMP_ERR	0x080000
				#define SEC2_INT_MBX_ENABLE	0x100000
				#define SEC2_INT_OFFSET_ERR	0x10000000
				#define SEC2_INT_GS_BALANCE_ERR	0x20000000
	
	unsigned int		esr ;	/* Engine Status Register */

				#define SEC2_ESR_DMA_IDLE	0x01
				#define SEC2_ESR_DMA_DONE	0x02
				#define SEC2_ESR_HASH_IDLE	0x04
				#define SEC2_ESR_HASH_DONE	0x08
				#define SEC2_ESR_DES_IDLE	0x10
				#define SEC2_ESR_DES_DONE	0x20
				#define SEC2_ESR_AES_IDLE	0x40
				#define SEC2_ESR_AES_DONE	0x80

	unsigned int		ier ;	/* Interrupt Enable Register */

				/*
				** ier uses same bits as sis
				*/
	
	unsigned int		res2[3] ;
	unsigned int		rst ;	/* Reset Register */

				#define SEC2_RST_DMA		0x01
				#define SEC2_RST_HASH		0x02
				#define SEC2_RST_DES		0x04
				#define SEC2_RST_AES		0x08
				#define SEC2_RST_MASTER		0x0F

	unsigned int		res3 ;
	struct sec2_q_regs	wq[2] ;	/* work queues */
	struct sec2_q_regs	cq[2] ;	/* completion queues */
	unsigned int		dwpd ; /* "Duet Write Protection Disable" */
	unsigned int		sget ; /* "SRAM GSE End Tag" */
	unsigned int		aesc[4] ; /* AES Counter mode Counter */
	unsigned int		aesk[8] ; /* AES Last Expanded Key */
} ;

