/*
 $Header: /proj/software/pub/CVSROOT/uClinux/linux/include/brecis/mspCommon.h,v 1.3 2002/12/11 21:10:17 tld Exp $
 */

/****************************************************************************/
/*																			*/
/*	Title:	mspVELevel2API.c												*/
/*																			*/
/*	Modification History:													*/
/*	Author:Date				: Description									*/
/*	Tony Raetz:2-1-2000	: Initial version of document  						*/
/*																			*/
/****************************************************************************/
/*	Description:															*/
/*	The include file common.h contains constant definitions that apply		*/
/*	across all of the HAL drivers.											*/
/*																			*/
/****************************************************************************/



/******************************************************************/
/* Copyright (c) 2001 BRECIS Communications                       */
/*      This software is the property of BRECIS Communications    */
/*      and may not be copied or distributed in any form without  */
/*      a prior licensing arrangement.                            */
/*                                                                */
/* BRECIS COMMUNICATIONS DISCLAIMS ANY LIABILITY OF ANY KIND      */
/* FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS      */
/* SOFTWARE.                                                      */
/*                                                                */
/******************************************************************/

#ifndef __MSPCOMMON__
#define __MSPCOMMON__

#define		CU8			const unsigned char
#define		CU32		const unsigned int
#define		BITFIELD 	unsigned

#define		FALSE		0
#define		TRUE		1

#define		TEST		1

#define		DISABLED		0
#define		ENABLED			1

#define MSP_ALL_ONES_32BITS					0xFFFFFFFF
#define MSP_ALL_ONES_16BITS					0xFFFF
#define MSP_ALL_ONES_8BITS					0xFF

#define	MSP_SUCCESS					0

/* Cache Control Masks and Sets */
#define KSEG0_MASK 		0x1FFFFFFF
#define KESG0_SET 		0x80000000
#define KSEG1_MASK		0x1FFFFFFF
#define	KSEG1_SET		0xa0000000

/* Shift Masks */
#define MSP_UPPER16_BITS	0xFFFF0000
#define MSP_LOWER16_BITS 	0x0000FFFF

/*  Constants for Task Priorities */

#define	MSP_UHP		26			/* Ultra High Priority 	*/
#define MSP_VHP		50			/* Very High Priority 	Serialization Task Level*/
#define MSP_HP		100			/* High Priority 		*/
#define MSP_MP		150			/* Medium Priority 		*/
#define MSP_LP		200			/* Low Priority			*/
#define MSP_VLP		225			/* Very Low Priority	*/
#define MSP_ULP		250			/* Ultra Low Priority	*/

/* Packet size constants for calculations */
#define	MSP_LARGE_PACKET	1000
#define MSP_MEDIUM_PACKET	100
#define MSP_SMALL_PACKET	99

/* MSP TriadBCopy Constants */
#define MSP_BCOPY_EFFICIENCY	32	/* BCOPY vs MIPS copy tradeoff point in bytes */

/* Max Ports Supported */
#define MAX_128_PORTS		128
#define MAX_256_PORTS		256
#define MAX_384_PORTS		384
#define MAX_512_PORTS		512

#define PORTS_IN_USE		MAX_128_PORTS
#define TRANS_PATHS			3
#define NUM_PORTS_ALLOCATED 31

/* Defined transmission source paths */
#define MSP_VPM_TDMBUS_0						0
#define MSP_VPM_TDMBUS_1						1
#define MSP_DV_BUS_HFP							2
#define MSP_DV_BUS_SFP							3
#define SUSPEND_SELF							0

/* Host Address - Mask Entry */
typedef struct 
{
	unsigned char *devNumber;
	unsigned char *name;
	unsigned char *ipAddr;
	unsigned char *ipMask;
} IP_ADDR_TEMPLATE;

/* 
 * Routing Table Entry 
 * GateWay of "0.0.0.0" indicates last entry in the table
 */
typedef struct
{
	char	*pGate;
	char	*pMask;
	char	*pDest;
} MSP_ROUTE_ENTRY;

#ifndef   __KERNEL__
typedef unsigned char	    U8,	 *P_U8,  *PU8;		/*  8-bit unsigned value */
typedef unsigned short      U16, *P_U16, *PU16;  	/* 16-bit unsigned value */
typedef unsigned int	    U32, *P_U32, *PU32;		/* 32-bit unsigned value */
#else  /* __KERNEL__ */
typedef u8                  U8,    *P_U8,  *PU8;      /*  8-bit unsigned value */
typedef u16                U16, *P_U16, *PU16;    /* 16-bit unsigned value */
typedef u32                U32, *P_U32, *PU32;        /* 32-bit unsigned value */
#endif /* __KERNEL__ */

typedef volatile short 		V_U16, VU16, *PV_U16, *PVU16;
typedef volatile int		V_U32, VU43, *PV_U32, *PVU32;

typedef char		        S8,  *P_S8;   			/*  8-bit signed value */
typedef short 	    		S16, *P_S16, *PS16;  	/* 16-bit signed value */
typedef int			    	S32, *P_S32;  			/* 32-bit signed value */

typedef void  		*P_UNKNOWN;
typedef P_UNKNOWN 	*PP_UNKNOWN;
typedef char		*P_STRING;

typedef U32		    SIZEOF, *P_SIZEOF;
/* typedef P_UNKNOWN  (* P_PROC)();  "warning: function declaration isn't a prototype" */

typedef S32		    TAG, *P_TAG;


/* Define Routing / Bridging Options for PE */
#define RFC1483_ROUTED_LLC		"RFC1483_ROUTED_LLC"
#define RFC1483_BRIDGED_LLC		"RFC1483_BRIDGE_LLC"
#define RFC1483_ROUTED_SNAP		"RFC1483_ROUTED_SNAP"
#define RFC1483_BRIDGED_SNAP	"RFC1483_BRIDGE_SNAP"

#define RFC1490_ROUTED_LLC		"RFC1490_ROUTED_LLC"
#define RFC1490_BRIDGED_LLC		"RFC1490_BRIDGE_LLC"
#define RFC1490_ROUTED_SNAP		"RFC1490_ROUTED_SNAP"
#define RFC1490_BRIDGED_SNAP	"RFC1490_BRIDGE_SNAP"

/* common prepend size for ethernet and pe */
#define	MSP_END_PREPEND 		224
#if MSP5000_CACHE_DATA_LINE_SIZE
#if (MSP_END_PREPEND%MSP5000_CACHE_DATA_LINE_SIZE) != 0
#error MSP_END_PREPEND must be multiple of cache line size
#endif
#endif

#endif

