/*
 $Header: /proj/software/pub/CVSROOT/uClinux/linux/include/brecis/msp.h,v 1.1 2002/07/19 14:15:34 tld Exp $
 */



/******************************************************************/
/* Copyright (c) 2001 BRECIS Communications                       */
/*      This software is the property of BRECIS Communications    */
/*      and may not be copied or distributed in any form without  */
/*      a prior licensing arrangement.                            */
/*                                                                */
/* BRECIS COMMUNICATIONS DISCLAIMS ANY LIABILITY OF ANY KIND      */
/* FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS      */
/* SOFTWARE.                                                      */
/*                                                                */
/******************************************************************/

/* msp.h - Brecis Communication  MSP50000 CPU Board header */

/*
modification history
--------------------
*/


#ifdef    VXWORKS
#include "vxWorks.h"
#endif /* VXWORKS */


/************************************/
/* define VERSION ID of each Target */
/************************************/

#define CPU_DEVID_MASK			0xff00
#define CPU_REVNUM_MASK			0xff
#define CPU_MSP_5000			0x50
#define CPU_MSP_4000			0x40
#define CPU_MSP_3000			0x30
#define CPU_MSP_2000			0x20
#define CPU_MSP_1000			0x10
#define CPU_MSP_FPGA			0x00
#define CPU_MSP_FPGA_5000		0x05
#define CPU_MSP_FPGA_4000		0x04

/* Reset bits 	*/
#define GLOBAL_RST  0x1                     /* Global Reset */
#define MIPS_RST    0x2                     /* MIPS reset   */
#define VE_DMA_RST  0x4                     /* Voice Engine DMA reset  */
#define VE_CPU_RST  0x8                     /* Voice Processor Reset   */
#define FE_DMA_RST  0x10                    /* Framer Engine DMA reset */
#define FE_CPU_RST  0x20                    /* Framer Engine Processor */
#define MAC0_RST    0x40                    /* Ethernet 0 Reset */
#define MAC1_RST    0x80                    /* Ethernet 1 Reset */
#define MAC2_RST    0x400                   /* Ethernet 2 Reset */
#define SE_RST      0x100                   /* Security Engine Reset */
#define PER_RST     0x200                   /* Peripheral Block Reset */

#define FE_RST      0x00000020              /* Reset FE Processor          */
#define VE_RST      0x00000008              /* Reset VE Processor          */

#define MSP5_RESET_VAL  (MAC0_RST | MAC1_RST | VE_DMA_RST       \
                        | VE_CPU_RST | FE_DMA_RST | FE_CPU_RST  \
                        | SE_RST | PER_RST)

#define MSP4_RESET_VAL  (MAC0_RST | MAC1_RST | MAC2_RST | VE_DMA_RST    \
                        | VE_CPU_RST | FE_DMA_RST | FE_CPU_RST          \
                        | SE_RST | PER_RST)
#define MSP_CRESET_VAL  (PER_RST)


#define MSP5000_300 	1
#define MSP5000_400 	2
#define MSP5500		 	3


/*********************************************************************/
/* Clock and Target Definition										 */
/*********************************************************************/

#if (MSP_TARGET == 1)				/* set for FPGA */
#define CPU_MODEL				CPU_MSP_FPGA
#define CPU_CLOCK_RATE	        10000000
#define CPU_CLOCK_VAL			0
#define DRAM_CLOCK_RATE			0
#define DRAM_CLOCK_VAL			0
#define DRAM_REFRESH_VAL		0x61a800	
#define SLM_CLOCK_RATE			10000000
#define SLM_CLOCK_VAL			0
#define SEC_CLOCK_RATE			0
#define SEC_CLOCK_VAL			0
#define PE_CLOCK_RATE			0
#define PE_CLOCK_VAL			0
#define VE_CLOCK_RATE			0
#define VE_CLOCK_VAL			0
#define PER_CLOCK_RATE			0
#define PER_CLOCK_VAL			0
#define REAL_CPU_CLOCK_RATE    	CPU_CLOCK_RATE
#define	BUILD_OPTION_STRING		"FPGA build"

#elif (BUILD_OPTION==MSP5000_300)
#define CPU_MODEL				CPU_MSP_5000
#define CPU_CLOCK_RATE			75000000	/* 150 MHz (half) 	*/
#define CPU_CLOCK_VAL			0x78		/* Parameter value 	*/
#define DRAM_CLOCK_RATE			100000000	/* 100 MHz DRAM		*/
#define DRAM_CLOCK_VAL			0x50		/* Parameter value	*/
#define DRAM_REFRESH_VAL		0x61a800	/* 0.064*dram clk	*/
#define SLM_CLOCK_RATE			50000000	/* 50MHz SLM/MAC/SEC*/
#define SLM_CLOCK_VAL			0x28		/* Parameter value	*/
#define SEC_CLOCK_RATE			100000000	/* 100Mhz - MSP2000	*/
#define SEC_CLOCK_VAL			0x50		/* Parameter value	*/
#define PE_CLOCK_RATE			100000000	/* 100 MHz PE		*/
#define PE_CLOCK_VAL			0x50		/* Parameter value	*/
#define VE_CLOCK_RATE			1000000000	/* 100 MHz VE		*/
#define VE_CLOCK_VAL			0x50		/* Parameter value	*/
#define PER_CLOCK_RATE			25000000	/* 25MHz peripheral	*/
#define PER_CLOCK_VAL			0x14		/* Parameter value 	*/
#define PLL_DIVIDER_VAL			15
#define	BUILD_OPTION_STRING		"Build option MSP5000-300"

#elif (BUILD_OPTION==MSP5000_400)
#define CPU_MODEL				CPU_MSP_5000
#define CPU_CLOCK_RATE			76000000	/* 152 MHz (half) 	*/
#define CPU_CLOCK_VAL			0x96		/* Parameter value 	*/
#define DRAM_CLOCK_RATE			95000000	/* 95 MHz DRAM		*/
#define DRAM_CLOCK_VAL			0x60		/* Parameter value	*/
#define DRAM_REFRESH_VAL		0x5cc600	/* 0.064*dram clk	*/
#define SLM_CLOCK_RATE			50000000	/* 50MHz SLM/MAC/SEC*/
#define SLM_CLOCK_VAL			0x31		/* Parameter value	*/
#define SEC_CLOCK_RATE			100000000	/* 100Mhz - MSP2000	*/
#define SEC_CLOCK_VAL			0x50		/* Parameter value	*/
#define PE_CLOCK_RATE			126670000	/* 126.67 MHz PE	*/
#define PE_CLOCK_VAL			0x80		/* Parameter value	*/
#define VE_CLOCK_RATE			126670000	/* 126.67 MHz VE	*/
#define VE_CLOCK_VAL			0x80		/* Parameter value	*/
#define PER_CLOCK_RATE			25000000	/* 25MHz peripheral	*/
#define PER_CLOCK_VAL			0x15		/* Parameter value 	*/
#define PLL_DIVIDER_VAL			19
#define	BUILD_OPTION_STRING		"Build option MSP5000-400"

#elif (BUILD_OPTION==MSP5500)
#error BUILD_SPPED_OPTION_MSP5500_NOT_SUPPORTED
#elif (BUILD_OPTION==MSP2000)
#define CPU_MODEL				CPU_MSP_2000
#define CPU_CLOCK_RATE			75000000	/* 150 MHz (half) 	*/
#define CPU_CLOCK_VAL			0x78		/* Parameter value 	*/
#define DRAM_CLOCK_RATE			100000000	/* 100 MHz DRAM		*/
#define DRAM_CLOCK_VAL			0x50		/* Parameter value	*/
#define DRAM_REFRESH_VAL		0x61a800	/* 0.064*dram clk	*/
#define SLM_CLOCK_RATE			50000000	/* 50MHz SLM/MAC/SEC*/
#define SLM_CLOCK_VAL			0x28		/* Parameter value	*/
#define SEC_CLOCK_RATE			100000000	/* 100Mhz - MSP2000	*/
#define SEC_CLOCK_VAL			0x50		/* Parameter value	*/
#define PE_CLOCK_RATE			SEC_CLOCK_RATE	/* set Seurity val	*/
#define PE_CLOCK_VAL			SEC_CLOCK_VAL	/* Parameter value	*/
#define VE_CLOCK_RATE			0			/* reserved on MSP2000	*/
#define VE_CLOCK_VAL			0			/* Parameter value	*/
#define PER_CLOCK_RATE			25000000	/* 25MHz peripheral	*/
#define PER_CLOCK_VAL			0x14		/* Parameter value 	*/
#define PLL_DIVIDER_VAL			15
#define	BUILD_OPTION_STRING		"Build option MSP2000"

#elif (BUILD_OPTION==MSP3000)
#define CPU_MODEL				CPU_MSP_3000
#define CPU_CLOCK_RATE			75000000	/* 150 MHz (half) 	*/
#define CPU_CLOCK_VAL			0x78		/* Parameter value 	*/
#define DRAM_CLOCK_RATE			100000000	/* 100 MHz DRAM		*/
#define DRAM_CLOCK_VAL			0x50		/* Parameter value	*/
#define DRAM_REFRESH_VAL		0x61a800	/* 0.064*dram clk	*/
#define SLM_CLOCK_RATE			50000000	/* 50MHz SLM/MAC/SEC*/
#define SLM_CLOCK_VAL			0x28		/* Parameter value	*/
#define SEC_CLOCK_RATE			100000000	/* 100Mhz - MSP3000	*/
#define SEC_CLOCK_VAL			0x50		/* Parameter value	*/
#define PE_CLOCK_RATE			SEC_CLOCK_RATE	/* set Seurity val	*/
#define PE_CLOCK_VAL			SEC_CLOCK_VAL	/* Parameter value	*/
#define VE_CLOCK_RATE			1000000000	/* 100 MHz Packet Engine	*/
#define VE_CLOCK_VAL			0x50		/* Parameter value	*/
#define PER_CLOCK_RATE			25000000	/* 25MHz peripheral	*/
#define PER_CLOCK_VAL			0x14		/* Parameter value 	*/
#define PLL_DIVIDER_VAL			15
#define	BUILD_OPTION_STRING		"Build option MSP3000"

#elif (BUILD_OPTION==MSP4000)
#define CPU_MODEL				CPU_MSP_4000
#define CPU_CLOCK_RATE			75000000	/* 150 MHz (half) 	*/
#define CPU_CLOCK_VAL			0x78		/* Parameter value 	*/
#define DRAM_CLOCK_RATE			100000000	/* 100 MHz DRAM		*/
#define DRAM_CLOCK_VAL			0x50		/* Parameter value	*/
#define DRAM_REFRESH_VAL		0x61a800	/* 0.064*dram clk	*/
#define SLM_CLOCK_RATE			50000000	/* 50MHz SLM/MAC/SEC*/
#define SLM_CLOCK_VAL			0x28		/* Parameter value	*/
#define SEC_CLOCK_RATE			100000000	/* 100Mhz - MSP3000	*/
#define SEC_CLOCK_VAL			0x50		/* Parameter value	*/
#define PE_CLOCK_RATE			SEC_CLOCK_RATE	/* set Seurity val	*/
#define PE_CLOCK_VAL			SEC_CLOCK_VAL	/* Parameter value	*/
#define VE_CLOCK_RATE			1000000000	/* 100 MHz PE/VE Engine	*/
#define VE_CLOCK_VAL			0x50		/* Parameter value	*/
#define PER_CLOCK_RATE			25000000	/* 25MHz peripheral	*/
#define PER_CLOCK_VAL			0x14		/* Parameter value 	*/
#define PLL_DIVIDER_VAL			15
#define	BUILD_OPTION_STRING		"Build option MSP4000"
#elif (BUILD_OPTION==MSP5000_400)
#else
#error BUILD_OPTION_NOT_DEFINED
#endif /* BUILD_OPTION_MSP5500 */



/*
 * CPU takes 2 cycles for one clock tick so we pass
 * it half the true rate
 * use this define if you need the actual value.
 *
 */
#if (MSP_TARGET == 0)				/* set for EVM 		*/
#define REAL_CPU_CLOCK_RATE    (CPU_CLOCK_RATE * 2)
#endif



/*********************************************************************/
/* Triad Hardware initialize at boot time value x                    */
/*********************************************************************/

/*********************************************************************/
/* External Local Buss Init at boot Time                             */
/*********************************************************************/

#define	CS_SIZE_8MEG	0x0
#define	CS_SIZE_4MEG	0x40
#define	CS_SIZE_2MEG	0x60
#define	CS_SIZE_1MEG	0x70
#define	CS_SIZE_512K	0x78
#define	CS_SIZE_256K	0x7c
#define	CS_SIZE_128K	0x7e
#define	CS_SIZE_64K 	0x7f

/*********************************************************/
/*  CS0 - ROM ICE or Flash if JP25 set to AB             */
/*  base reg    = 0x180     Base Addr   = 0x1f800000     */
/*  Config Reg  = 765       Max Time, Intel, 8bits       */
/*  Mask reg    = 0                                      */
/*********************************************************/
#define CS0_BASE_ADD_VAL	0x180			/* base 0x1f800000	*/
#define CS0_CNFG_REG_VAL	0x765			/* Time = Max, Size 8bits, Mode Intel */
#define CS0_ADD_SPACE		CS_SIZE_8MEG	/* Last 8 MegBytes	*/

#define CS1_BASE_ADD_VAL	0x0				/* base 0x1E000000	*/
#define CS1_CNFG_REG_VAL	0x5				/* Size 8bits, Mode Intel	*/
#define CS1_ADD_SPACE		CS_SIZE_4MEG	/* Address Space 4 MB	*/

#define CS2_BASE_ADD_VAL	0x40			/* base 0x1E400000	*/
#define CS2_CNFG_REG_VAL	0x5				/* Size 8bits, Mode Intel	*/
#define CS2_ADD_SPACE		CS_SIZE_4MEG	/* Address Space 4 MB	*/

#define CS3_BASE_ADD_VAL	0x80			/* base 0x1E800000	*/
#define CS3_CNFG_REG_VAL	0x5				/* Size 8bits, Mode Intel	*/
#define CS3_ADD_SPACE		CS_SIZE_4MEG	/* Address Space 4 MB	*/

#define CS4_BASE_ADD_VAL	0xc0			/* base 0x1EC00000	*/
#define CS4_CNFG_REG_VAL	0x765			/* Time = Max, Size 8bits, Mode Intel */
#define CS4_ADD_SPACE		CS_SIZE_4MEG	/* Address Space 4 MB	*/

#define CS5_BASE_ADD_VAL	0x100			/* base 0x1F000000	*/
#define CS5_CNFG_REG_VAL	0x5				/* Size 8bits, Mode Intel             */
#define CS5_ADD_SPACE		CS_SIZE_4MEG	/* Address Space 4 MB	*/

#define CS6_BASE_ADD_VAL	0x140			/* base 0x1F400000	*/
#define CS6_CNFG_REG_VAL	0x5				/* Size 8bits, Mode Intel	*/
#define CS6_ADD_SPACE		CS_SIZE_2MEG	/* Address Space 2 MB	*/

#define CS7_BASE_ADD_VAL	0x160			/* base 0x1F600000	*/
#define CS7_CNFG_REG_VAL	0x5  			/* Size 8bits, Mode Intel             */
#define CS7_ADD_SPACE		CS_SIZE_2MEG	/* Address Space 2 MB	*/


/* clocks */
#define MSP_EXT_CLK			20000000
#define UART_FPGA_FREQ		6000000

#define TIMER_NOT_DONE		0x0
#define TIMER_DONE			0x1
#define PIT_TIMER_NOT_DONE	0x0
#define PIT_TIMER_DONE		0x1


/************************************************************************/
/* interrupt logic definition 											*/
/* interrupt levels 													*/
/************************************************************************/
#define INT_LVL_TIMER           SR_IBIT8        /* MIPS timer (fixed) */
#define INT_LVL_IORQ4           SR_IBIT7        /* SLM Interrupt      */
#define INT_LVL_IORQ3           SR_IBIT6        /* FE Packet Engine   */
#define INT_LVL_IORQ2           SR_IBIT5        /* VE Void Engine     */
#define INT_LVL_IORQ1           SR_IBIT4        /* MAC1 Ethernet 1    */
#define INT_LVL_IORQ0           SR_IBIT3        /* MAC0 Ethernet 2    */
#define INT_LVL_SW1             SR_IBIT2        /* sw interrupt 1 (fixed) */
#define INT_LVL_SW0             SR_IBIT1        /* sw interrupt 0 (fixed) */
#define INT_LVL_MAC0            SR_IBIT3        /* MAC0					 */
#define INT_LVL_MAC1            SR_IBIT4        /* MAC1					 */

#define TRIAD_SR				( INT_LVL_TIMER | INT_LVL_IORQ4 |INT_LVL_MAC0 | INT_LVL_MAC1 | \
									INT_LVL_SW1 | INT_LVL_IORQ2 | INT_LVL_IORQ3 | INT_LVL_SW0 | SR_IE)
#define TRIAD_INT_MASKOUT       (INT_LVL_TIMER | INT_LVL_SLM |  INT_LVL_FE | INT_LVL_VE |\
								 INT_LVL_MAC1 | INT_LVL_MAC0  | INT_LVL_SW1 | INT_LVL_SW0)

/* interrupt indexes */

#define INT_INDX_TIMER          7       /* MIPS timer (fixed) 	   */
#define INT_INDX_IORQ4          6		/* IORQ 4 SLM interrupt    */
#define INT_INDX_IORQ3          5       /* IORQ 3 FE Packet Engine */
#define INT_INDX_IORQ2          4       /* IORQ 2 VE Voice Engine  */
#define INT_INDX_IORQ1          3       /* IORQ 1 MAC0 Ethernet 1  */
#define INT_INDX_IORQ0          2       /* IORQ 0 MAC1 Ethernet 0  */
#define INT_INDX_SW1            1       /* sw interrupt 1          */
#define INT_INDX_SW0            0       /* sw interrupt 0          */

/* interrupt vectors */


#define IV_TIMER_VEC            70      /* R4K timer (fixed)        */
#define IV_IORQ4_VEC            69      /* SLM  - IORQ 4 			*/
#define IV_IORQ3_VEC            68      /* FE   - IORQ 3             */
#define IV_IORQ2_VEC            67      /* VPM  - IORQ 2 */
#define IV_IORQ1_VEC            66      /* MAC1 - IORQ 1 */
#define IV_IORQ0_VEC            65      /* MAC0 - IORQ 0 */


#define INT_VEC_IORQ0           IV_IORQ0_VEC
#define INT_VEC_IORQ1           IV_IORQ1_VEC
#define INT_VEC_IORQ2           IV_IORQ2_VEC
#define INT_VEC_IORQ3           IV_IORQ3_VEC
#define INT_VEC_IORQ4           IV_IORQ4_VEC
#define INT_VEC_IORQ5           IV_TIMER_VEC


/* SLM Multiplexed interrupt vectors	*/

#define IV_SLM_EXT0				71
#define IV_SLM_EXT1				72
#define IV_SLM_EXT2				73
#define IV_SLM_EXT3				74
#define IV_SLM_EXT4				75
#define IV_SLM_EXT5				76
#define IV_SLM_EXT6				77
#define IV_SLM_EXT7				78
#define	IV_SLM_VE_MBOX			79
#define	IV_SLM_FE_MBOX			80
#define	IV_SLM_MAC0				81
#define	IV_SLM_MAC1				82
#define	IV_SLM_SEC				83
#define	IV_SLM_PIM				84
#define	IV_SLM_TIMER0			85
#define	IV_SLM_TIMER1			86
#define	IV_SLM_TIMER2			87
#define	IV_SLM_MIPS_TIMER		88
#define	IV_SLM_BCOPY			89
#define	IV_SLM_UART				90
#define	IV_SLM_ERR_BAD_ADD		91
#define	IV_SLM_ERR_BAD_ELB		92
#define	IV_SLM_ERR_BIG_ELB		93
#define	IV_SLM_ERR_NWORD_UART	94
#define	IV_SLM_ERR_NWORD_REG	95
#define	IV_SLM_ERR_READ			96
#define	IV_SLM_MAC2				97


/* Peripheral Multiplexed interrupt vectors	*/

#define	IV_PER_SCCA_TXDMA_BD		100
#define	IV_PER_SCCA_RXDMA_BD		101
#define	IV_PER_SCCA_GENERAL			102
#define	IV_PER_SCCB_TXDMA_BD		103
#define	IV_PER_SCCB_RXDMA_BD		104
#define	IV_PER_SCCB_GENERAL			105
#define	IV_PER_I2C_INT				106
#define	IV_PER_TIMER0				107
#define	IV_PER_TIMER1				108
#define	IV_PER_TIMER2				109
#define	IV_PER_SPI_MPI_RX			110
#define	IV_PER_SPI_MPI_TX			111
#define	IV_PER_GPIO					112
#define	IV_PER_ERROR				113

/* Peripheral GPIO Multiplexed interrupt vectors	*/

#define	IV_GPIO_BIT0			114
#define	IV_GPIO_BIT1			115
#define	IV_GPIO_BIT2			116
#define	IV_GPIO_BIT3			117
#define	IV_GPIO_BIT4			118
#define	IV_GPIO_BIT5			119
#define	IV_GPIO_BIT6			120
#define	IV_GPIO_BIT7			121
#define	IV_GPIO_BIT8			122
#define	IV_GPIO_BIT9			123
#define	IV_GPIO_BIT10			124
#define	IV_GPIO_BIT11			125
#define	IV_GPIO_BIT12			126
#define	IV_GPIO_BIT13			127
#define	IV_GPIO_BIT14			128
#define	IV_GPIO_BIT15			129


/* system interrupt bits	*/

#define EXT0_INT			(1<<0)		/* bit 0 */
#define EXT1_INT			(1<<1)		/* bit 1 */
#define EXT2_INT			(1<<2)		/* bit 2 */
#define EXT3_INT			(1<<3)		/* bit 3 */
#define EXT4_INT			(1<<4)		/* bit 4 */
#define EXT5_INT			(1<<5)		/* bit 5 */
#define EXT6_INT			(1<<6)		/* bit 6 */
#define EXT7_INT			(1<<7)		/* bit 7 */

#define SLM_VE_MBOX_INT		(1<<8)		/* bit 8 */
#define SLM_FE_MBOX_INT		(1<<9)		/* bit 9 */
#define SLM_MAC0			(1<<10)		/* bit10 */
#define SLM_MAC1			(1<<11)		/* bit11 */
#define SLM_SEC				(1<<12)		/* bit12 */
#define SLM_PIM_INT			(1<<13)		/* bit13 */
#define SLM_TIMER0_INT		(1<<14)		/* bit14 */
#define SLM_TIMER1_INT		(1<<15)		/* bit15 */
#define SLM_TIMER2_INT		(1<<16)		/* bit16 */
#define SLM_MIPS_TIMER_INT	(1<<17)		/* bit17 */
#define BCOPY_INT			(1<<18)		/* bit18 */
#define UART_INT			(1<<19)		/* bit19 */

#define ERR_BAD_ADD_INT		(1<<20)		/* bit20 */
#define ERR_BAD_ELB_INT		(1<<21)		/* bit21 */
#define ERR_BIG_ELB_INT		(1<<22)		/* bit22 */
#define ERR_NWORD_UART_INT	(1<<23)		/* bit23 */
#define ERR_NWORD_REG_INT	(1<<24)		/* bit24 */
#define ERR_READ_INT		(1<<25)		/* bit25 */
#define SLM_MAC2			(1<<26)		/* bit26 */

/* Peripheral interrupt bits	*/
/************************************************************************************************/
/* Peripheral Interrupt Controller																*/
/*																								*/
/*  14  13  12  11  10 	9  	8  	7  	6  	5  	4  	3  	2  	1  	0									*/
/*		|	|	|	|	|	|	|	|	|	|	|	|	|	|________PER_SCCA_TXDMA_BD_INT		*/
/*		|	|	|	|	|	|	|	|	|	|	|	|	|____________PER_SCCA_RXDMA_BD_INT		*/
/*		|	|	|	|	|	|	|	|	|	|	|   |________________PER_SCCA_GENERAL_INT		*/
/*		|	|	|	|	|	|	|	|	|	|	|____________________PER_SCCB_TXDMA_BD_INT		*/
/*		|	|	|	|	|	|	|	|	|	|________________________PER_SCCB_RXDMA_BD_INT		*/
/*		|	|	|	|	|	|	|	|	|____________________________PER_SCCA_GENERAL_INT		*/
/*		|	|	|	|	|	|	|	|________________________________PER_I2C_INT				*/
/*		|	|	|	|	|	|	|____________________________________PER_TIMER0_INT				*/
/*		|	|	|	|	|	|________________________________________PER_TIMER1_INT				*/
/*		|	|	|	|   |____________________________________________PER_TIMER2_INT				*/
/*		|	|	|	|________________________________________________PER_SPI_MPI_RX_INT			*/
/*		|	|	|____________________________________________________PER_SPI_MPI_TX_INT			*/
/*		|	|________________________________________________________PER_GPIO_INT				*/
/*		|____________________________________________________________PER_ERROR_INT				*/
/************************************************************************************************/


#define PER_SCCA_TXDMA_BD_INT	(1<<0)	/* SCCA Transmit DMA BD	*/
#define PER_SCCA_RXDMA_BD_INT	(1<<1)	/* SCCA Receive  DMA BD	*/
#define PER_SCCA_GENERAL_INT	(1<<2)	/* SCCA General Int		*/
#define PER_SCCB_TXDMA_BD_INT	(1<<3)	/* SCCB Transmit DMA BD	*/
#define PER_SCCB_RXDMA_BD_INT	(1<<4)	/* SCCB Receive  DMA BD	*/
#define PER_SCCB_GENERAL_INT	(1<<5)	/* SCCB General Int		*/
#define PER_I2C_INT				(1<<6)	/* I2C Interrupt		*/
#define PER_TIMER0_INT			(1<<7)	/* Peripheral Timer0	*/
#define PER_TIMER1_INT			(1<<8)	/* Peripheral Timer1	*/
#define PER_TIMER2_INT			(1<<9)	/* Peripheral Timer2	*/
#define PER_SPI_MPI_RX_INT		(1<<10)	/* SPI & MPI Receive	*/
#define PER_SPI_MPI_TX_INT		(1<<11)	/* SPI & MPI Transmit	*/
#define PER_GPIO_INT			(1<<12)	/* GPIO interrupt		*/
#define PER_ERROR_INT			(1<<13)	/* Peripheral Error		*/

/* Peripheral GPIO Multiplexed interrupt bits	*/

#define	GPIO_BIT0			(1<<0)
#define	GPIO_BIT1			(1<<1)
#define	GPIO_BIT2			(1<<2)
#define	GPIO_BIT3			(1<<3)
#define	GPIO_BIT4			(1<<4)
#define	GPIO_BIT5			(1<<5)
#define	GPIO_BIT6			(1<<6)
#define	GPIO_BIT7			(1<<7)
#define	GPIO_BIT8			(1<<8)
#define	GPIO_BIT9			(1<<9)
#define	GPIO_BIT10			(1<<10)
#define	GPIO_BIT11			(1<<11)
#define	GPIO_BIT12			(1<<12)
#define	GPIO_BIT13			(1<<13)
#define	GPIO_BIT14			(1<<14)
#define	GPIO_BIT15			(1<<15)


/* system interrupt configuration   */

#define	INT3_VOICE_ENGINE		(0<<10)
#define	INT3_PACKET_ENGINE		(1<<10)
#define	INT3_SECURITY_ENGINE	(2<<10)
#define	INT3_ETHERNET_MAC2		(3<<10)

#define	INT2_VOICE_ENGINE		(0<<8)
#define	INT2_PACKET_ENGINE		(1<<8)
#define	INT2_SECURITY_ENGINE	(2<<8)
#define	INT2_ETHERNET_MAC2		(3<<8)

#define	EDGE_TRIGGER			0x1
#define	LEVEL_TRIGGER			0x0

#define PLL_CK_DIV_VAL			240
#define PLL_MIN_VAL				15
#define PLL_MAX_VAL				20
#define CLK_MAX_VAL				120
#define CLK_MIN_VAL				2

#define	SYS_CLKGEN_MODULUS		240 /* Manifest Constant - function of h/w */


/* Miscellaneous */

#ifdef _ASMLANGUAGE
#define CAST(c)
#else
#define CAST(c) (c)
#endif


#define N_SIO_CHANNELS         1     /* Number of serial I/O channels */
#define N_UART_CHANNELS        1

/* 1 = FPGA */
#if (MSP_TARGET==1)
#define NS16550_XTAL_FREQ       6000000
#elif (MSP_TARGET==0)
#define NS16550_XTAL_FREQ       (SLM_CLOCK_RATE / 2)
#endif

/* Internal Uart definitions */


#define COM2_BASE_ADR           0xb8000823
#define COM1_BASE_ADR           0xBC000100
#define UART_REG_ADDR_INTERVAL  4
#define COM1_INT_VEC            IV_IORQ4_VEC
#define COM2_INT_VEC            IV_IORQ4_VEC
#define COM1_INT_LVL            0
#define COM2_INT_LVL            0


/*
 *  Aux Clock and timer defines
 *
 */
/*#define USE_LED_FOR_DEBUG*/
#define EXTERNAL_XTL  	(20000000)	/* 20 Mhz crystal */
#define DISABLE_ALL		0x00000000
/* timer Int bit */
#define AUXTIMER_INT (1<<14)
/* gate control setings */
#define DISABLE_COUNT  (0x0<<0)
#define ENABLE_COUNT   (0x1<<0)
/* modes of operation */
#define SINGLE_SHOT		0
#define CONTINUOUS		1
#define CNTR0_SINGLE_SHOT  (0x0<<0)
#define CNTR0_CONTINUOUS   (0x1<<0)
#define CNTR1_SINGLE_SHOT  (0x0<<1)
#define CNTR1_CONTINUOUS   (0x1<<1)
#define CNTR2_SINGLE_SHOT  (0x0<<2)
#define CNTR2_CONTINUOUS   (0x1<<2)


/*  CACHE LINE CONSTANTS  */

#define MSP5000_CACHE_DATA_LINE_SIZE    (0x10)
#define MSP5000_CACHE_DATA_SIZE         (0x4000)
#define MSP5000_CACHE_INST_LINE_SIZE    (0x10)
#define MSP5000_CACHE_INST_SIZE         (0x4000)


/* DEFINES FOR USING CLOCK FUNCTIONS */
#define MSP_PCM_HIGHWAY_ZERO				(19)
#define MSP_PCM_HIGHWAY_ONE					(20)
#define MSP_WAN_SERIAL_INTERFACE_ZERO_TX	(30)
#define MSP_WAN_SERIAL_INTERFACE_ZERO_RX	(31)
#define MSP_WAN_SERIAL_INTERFACE_ONE_TX		(40)
#define MSP_WAN_SERIAL_INTERFACE_ONE_RX		(41)
