/*
 $Header: /proj/software/pub/CVSROOT/uClinux/linux/include/brecis/errorGlobalMsp.h,v 1.2 2002/11/20 00:08:18 araetz Exp $
 */


/****************************************************************************/
/*																			*/
/*	Title:	errorGlobalMsp.h												*/
/*																			*/
/*	Modification History:													*/
/*	Author:Date				: Description									*/
/*	Tony Raetz:	5-1-2001	: Initial version of document 					*/
/*  Ying Wu:    7-10-2001	: Add error code bases for each function module	*/
/*																			*/
/****************************************************************************/
/*	Description:															*/
/*	This include file contains global error code  definitions that apply	*/
/*	across all of the HAL drivers and PE, VPM firmware						*/
/*																			*/
/****************************************************************************/



/******************************************************************/
/* Copyright (c) 2001 BRECIS Communications                       */
/*      This software is the property of BRECIS Communications    */
/*      and may not be copied or distributed in any form without  */
/*      a prior licensing arrangement.                            */
/*                                                                */
/* BRECIS COMMUNICATIONS DISCLAIMS ANY LIABILITY OF ANY KIND      */
/* FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS      */
/* SOFTWARE.                                                      */
/*                                                                */
/******************************************************************/

#ifndef __errorGlobalMspH__
#define __errorGlobalMspH__

#define MSP_SUCCESS		0

/* VPM firmware error code definitions   */
#define MSP_VPM_FW_ERROR_BASE			1000			/* error code base for VPM */


/* PE firmware error code definitions   */
#define MSP_PE_FW_ERROR_BASE			2000			/* error code base for PE */

#define MSP_PE_FW_ERROR_INVALID_DATA            (MSP_PE_FW_ERROR_BASE + 0)
#define MSP_PE_FW_ERROR_INVALID_CMD             (MSP_PE_FW_ERROR_BASE + 1)
#define MSP_PE_FW_ERROR_NO_MEMORY               (MSP_PE_FW_ERROR_BASE + 2)
#define MSP_PE_FW_ERROR_INVALID_PHYCLK          (MSP_PE_FW_ERROR_BASE + 3)
#define MSP_PE_FW_ERROR_VCADD_BAD_IFNUM         (MSP_PE_FW_ERROR_BASE + 4)
#define MSP_PE_FW_ERROR_VCADD_DUPLICATE_VCID    (MSP_PE_FW_ERROR_BASE + 5)
#define MSP_PE_FW_ERROR_VCADD_TOO_MANY_VCS      (MSP_PE_FW_ERROR_BASE + 6)
#define MSP_PE_FW_ERROR_PECFG_TOO_MANY_WANIFS   (MSP_PE_FW_ERROR_BASE + 7)
#define MSP_PE_FW_ERROR_PECFG_TOO_MANY_PHYS     (MSP_PE_FW_ERROR_BASE + 8)
#define MSP_PE_FW_ERROR_PECFG_TOO_MANY_VCS      (MSP_PE_FW_ERROR_BASE + 9)
#define MSP_PE_FW_ERROR_PECFG_TOO_MANY_CIDS     (MSP_PE_FW_ERROR_BASE + 10)
#define MSP_PE_FW_ERROR_VC_NOT_FOUND            (MSP_PE_FW_ERROR_BASE + 11)
#define MSP_PE_FW_ERROR_CIDADD_VC_NOT_AAL2      (MSP_PE_FW_ERROR_BASE + 12)
#define MSP_PE_FW_ERROR_CIDADD_DUPLICATE_CID    (MSP_PE_FW_ERROR_BASE + 13)
#define MSP_PE_FW_ERROR_CIDADD_TOO_MANY_CIDS    (MSP_PE_FW_ERROR_BASE + 14)
#define MSP_PE_FW_ERROR_CIDDEL_CID_NOT_FOUND    (MSP_PE_FW_ERROR_BASE + 15)
#define MSP_PE_FW_ERROR_UNKNOWN_BASIC_CMD       (MSP_PE_FW_ERROR_BASE + 16)
#define MSP_PE_FW_ERROR_UNKNOWN_EXTENDED_CMD    (MSP_PE_FW_ERROR_BASE + 17)
#define MSP_PE_FW_ERROR_CIDSTAT_UNKNOWN_CID     (MSP_PE_FW_ERROR_BASE + 18)
#define MSP_PE_FW_ERROR_VCSTAT_UNKNOWN_VC       (MSP_PE_FW_ERROR_BASE + 19)
#define MSP_PE_FW_ERROR_DELVC_CIDS_NOT_DELETED  (MSP_PE_FW_ERROR_BASE + 20)
#define MSP_PE_FW_ERROR_UTOPIA_TIMEOUT          (MSP_PE_FW_ERROR_BASE + 21)
#define MSP_PE_FW_ERROR_INVALID_TXBD_PTR        (MSP_PE_FW_ERROR_BASE + 22)
#define MSP_PE_FW_ERROR_INVALID_RXBD_PTR        (MSP_PE_FW_ERROR_BASE + 23)
#define MSP_PE_FW_ERROR_VLAN_NOT_ALLOWED		(MSP_PE_FW_ERROR_BASE + 24)

/* System error code definitions   */
#define MSP_SYS_ERROR_BASE			3000			/* error code base for the system */
#define MSP_SYS_ERROR_UNKNOWN		   			(MSP_SYS_ERROR_BASE + 0)
#define MSP_SYS_ERROR_CLKRATE					(MSP_SYS_ERROR_BASE + 1)

/* Memory allocator error code definitions   */
#define MSP_MEM_ERROR_BASE			4000			/* error code base for memory allocator */


/* VPM API error code definitions   */
#define MSP_VPM_ERROR_BASE	   	5000			/* error code base for the VPM API */

#define	MSP_VPM_CALLBACKNOTFOUND				(MSP_VPM_ERROR_BASE + 1)
#define MSP_VPM_INSERTIONPOINTINUSE				(MSP_VPM_ERROR_BASE + 2)
#define	MSP_VPM_NOAVAILINSERTIONPOINT			(MSP_VPM_ERROR_BASE + 3)
#define	MSP_VPM_DUPLICATE_ENTRY					(MSP_VPM_ERROR_BASE + 4)
#define	MSP_VPM_TABLE_ENTRY_ERROR				(MSP_VPM_ERROR_BASE + 5)
#define	MSP_VPM_BCOPY_ERROR						(MSP_VPM_ERROR_BASE + 6)
#define MSP_VPM_EVENT_RECORD_RING_WRAP			(MSP_VPM_ERROR_BASE + 7)
#define	MSP_VPM_EVENT_RECORD_INT_NO_EVENT		(MSP_VPM_ERROR_BASE + 8)
#define MSP_VPM_ZSP_CODE_NOT_LOADED				(MSP_VPM_ERROR_BASE + 9)
#define MSP_VPM_INVALID_CLOCK_RATE				(MSP_VPM_ERROR_BASE + 10)
#define MSP_VPM_INVALID_TDMBUS_SELECT			(MSP_VPM_ERROR_BASE + 11)
#define MSP_VPM_INVALID_MAX_TIMESLOTS			(MSP_VPM_ERROR_BASE + 12)
#define MSP_VPM_INVALID_START_TIMESLOTS			(MSP_VPM_ERROR_BASE + 13)
#define MSP_VPM_INVALID_ACTIVENUM_TIMESLOTS 	(MSP_VPM_ERROR_BASE + 14)
#define MSP_VPM_INVALID_MAX_VIRTUAL_SLOTS		(MSP_VPM_ERROR_BASE + 15)
#define MSP_VPM_INVALID_ECHO_TAIL_LENGTH		(MSP_VPM_ERROR_BASE + 16)
#define MSP_VPM_INVALID_COMPANDING_TYPE			(MSP_VPM_ERROR_BASE + 17)
#define MSP_VPM_INVALID_PORT_VALUE				(MSP_VPM_ERROR_BASE + 18)
#define MSP_VPM_INVALID_SOURCE_VALUE			(MSP_VPM_ERROR_BASE + 19)
#define	MSP_VPM_PORT_NOT_REGISTERED				(MSP_VPM_ERROR_BASE + 20)
#define MSP_VPM_INVALID_CODEC					(MSP_VPM_ERROR_BASE + 21)
#define MSP_VPM_INVALID_TONEDISABLE_OPTION		(MSP_VPM_ERROR_BASE + 22)
#define	MSP_VPM_INVALID_HREGISTER_SET_VALUE		(MSP_VPM_ERROR_BASE + 23)
#define MSP_VPM_TOO_MANY_DIGITS_FOR_MESSAGE		(MSP_VPM_ERROR_BASE + 24)
#define MSP_VPM_TOO_FEW_DIGITS_FOR_MESSAGE		(MSP_VPM_ERROR_BASE + 25)
#define MSP_VPM_NO_SUCH_COMMAND					(MSP_VPM_ERROR_BASE + 26)
#define MSP_VPM_INVALID_TIMESLOT_ALLOCATION		(MSP_VPM_ERROR_BASE + 27)
#define MSP_VPM_INVALID_RESPONSE_EVENT_ID		(MSP_VPM_ERROR_BASE + 28)
#define MSP_VPM_INVALID_OFFSET_VALUE			(MSP_VPM_ERROR_BASE + 29)
#define MSP_VPM_VPMZSP_NO_RUNTIME				(MSP_VPM_ERROR_BASE + 30)
#define MSP_VPM_INVALID_PING_RECEIVED			(MSP_VPM_ERROR_BASE + 31)
#define MSP_VPM_INVALID_GAINADJUST				(MSP_VPM_ERROR_BASE + 32)
#define MSP_VPM_INVALID_FRAMING_MODE			(MSP_VPM_ERROR_BASE + 33)
#define MSP_VPM_INVALID_JITTER_BUFFER_DEPTH		(MSP_VPM_ERROR_BASE + 34)
#define MSP_VPM_INVALID_TDM_HIGHWAY				(MSP_VPM_ERROR_BASE + 35)
#define MSP_VPM_UNUSED_ERROR_VALUE_36			(MSP_VPM_ERROR_BASE + 36)
#define MSP_VPM_UNUSED_ERROR_VALUE_37			(MSP_VPM_ERROR_BASE + 37)
#define MSP_VPM_INVALID_TIMESLOT_MASK			(MSP_VPM_ERROR_BASE + 38)
#define MSP_VPM_INVALID_NUM_FRAMES_PER_BUFFER	(MSP_VPM_ERROR_BASE + 39)
#define MSP_VPM_NO_BUFFERS_AVAIL				(MSP_VPM_ERROR_BASE + 40)
#define MSP_VPM_TDM_NOT_CONFIG_FOR_CES			(MSP_VPM_ERROR_BASE + 41)
#define MSP_VPM_INVALID_STATE_FOR_CONFIG		(MSP_VPM_ERROR_BASE + 42)
#define MSP_VPM_INVALID_STATE_FOR_DISABLE		(MSP_VPM_ERROR_BASE + 43)
#define MSP_VPM_CES_RXBUFFER_UNDERRUN			(MSP_VPM_ERROR_BASE + 44)
#define MSP_VPM_MEMORY_ALLOCATION_FAIL			(MSP_VPM_ERROR_BASE + 45)
#define MSP_VPM_INVALID_STATE_FOR_DATA_TX		(MSP_VPM_ERROR_BASE + 46)
#define MSP_VPM_NO_PECID_HANDLE					(MSP_VPM_ERROR_BASE + 47)
#define MSP_VPM_INVALID_PAYLOAD_LENGTH			(MSP_VPM_ERROR_BASE + 48)	
#define MSP_VPM_INVALID_CALL_PROG_TONE_ID		(MSP_VPM_ERROR_BASE + 49)
#define MSP_VPM_SFP_TASK_START_FAILURE			(MSP_VPM_ERROR_BASE + 50)
#define MSP_VPM_SFP_CALLBACK_IS_NULL			(MSP_VPM_ERROR_BASE + 51)
#define MSP_VPM_SFP_MBLKCLST_INIT_FAIL			(MSP_VPM_ERROR_BASE + 52)
#define MSP_VPM_SFP_DATASPACE_ALLOC_FAIL		(MSP_VPM_ERROR_BASE + 53)
#define MSP_VPM_SFP_CHANNEL_MEM_CNFG_FAILURE	(MSP_VPM_ERROR_BASE + 54)
#define MSP_VPM_SFP_INVALID_STATE_FOR_DISABLE	(MSP_VPM_ERROR_BASE + 55)
#define MSP_VPM_SFP_TASK_DELETE_FAILURE			(MSP_VPM_ERROR_BASE + 56)
#define MSP_VPM_SFP_DISABLE_PATH_FAILURE		(MSP_VPM_ERROR_BASE + 57)
#define MSP_VPM_SFP_INV_PKTLOSS_CNCLMODE        (MSP_VPM_ERROR_BASE + 58)
#define MSP_VPM_PORT_IS_ACTIVE					(MSP_VPM_ERROR_BASE + 59)
#define MSP_VPM_SFP_INVALID_FRAMEPERCODEC		(MSP_VPM_ERROR_BASE + 60)
#define MSP_VPM_SFP_INVALID_MID_POINT			(MSP_VPM_ERROR_BASE + 61)
#define MSP_VPM_SFP_INVALID_JITTER_BUF_DEPTH	(MSP_VPM_ERROR_BASE + 62)
#define MSP_VPM_SFP_MAKES_PLAYOUT_INVALID		(MSP_VPM_ERROR_BASE + 63)
#define MSP_VPM_SFP_INVALID_PACKET_FORMAT		(MSP_VPM_ERROR_BASE + 64)
#define MSP_VPM_SFP_USERTX_INVALID_CHAN			(MSP_VPM_ERROR_BASE + 65)
#define MSP_VPM_USERTX_CHAN_INACTIVE			(MSP_VPM_ERROR_BASE + 66)
#define MSP_VPM_SFP_USER_BUF_NULL			    (MSP_VPM_ERROR_BASE + 67)
#define MSP_VPM_SFP_USER_BUF_INVALID_LENGTH		(MSP_VPM_ERROR_BASE + 68)
#define MSP_VPM_INVALID_CLOCK_MODE				(MSP_VPM_ERROR_BASE + 69)
#define MSP_VPM_INVALID_FRAME_SYNC_MODE			(MSP_VPM_ERROR_BASE + 70)
#define MSP_VPM_INVALID_BIT_TIME_DELAY			(MSP_VPM_ERROR_BASE + 71)
#define MSP_VPM_INVALID_FRAME_BIT_SETTING		(MSP_VPM_ERROR_BASE + 72)
#define MSP_VPM_INVALID_VAD_SETTING				(MSP_VPM_ERROR_BASE + 73)


/* Voice engine direct API error code definitions   */
#define MSP_VPM_ENGINE_ERROR_BASE	   	5500			/* error code base for the VPM API */

#define	MSP_VPM_ENG_RESP_QUE_CMD_LEN_WRONG					(MSP_VPM_ENGINE_ERROR_BASE + 1)
#define MSP_VPM_ENG_TDM_BUS_NOT_EXIST						(MSP_VPM_ENGINE_ERROR_BASE + 2)
#define	MSP_VPM_ENG_TDM_BUS_MAX_SLOT_128					(MSP_VPM_ENGINE_ERROR_BASE + 3)
#define	MSP_VPM_ENG_TDM_SLOT_NOT_START_AT_0					(MSP_VPM_ENGINE_ERROR_BASE + 4)
#define	MSP_VPM_ENG_TDM_BIT_DELAY_NOT_SUPPORT				(MSP_VPM_ENGINE_ERROR_BASE + 5)
#define	MSP_VPM_ENG_ECHO_TAIL_NOT_SUPPORT		   			(MSP_VPM_ENGINE_ERROR_BASE + 6)
#define	MSP_VPM_ENG_COMP_TYPE_NOT_SUPPORT		   			(MSP_VPM_ENGINE_ERROR_BASE + 7)
#define	MSP_VPM_ENG_TDM_SLOT_OVER_LIMIT			   			(MSP_VPM_ENGINE_ERROR_BASE + 8)
#define	MSP_VPM_ENG_WRONG_PACKET_PORT_NUM		   			(MSP_VPM_ENGINE_ERROR_BASE + 9)
#define	MSP_VPM_ENG_PACKET_PORT_OVER_LIMIT 		   			(MSP_VPM_ENGINE_ERROR_BASE +10)
#define	MSP_VPM_ENG_PORT_TYPE_NOT_SUPPORT		   			(MSP_VPM_ENGINE_ERROR_BASE +11)
#define	MSP_VPM_ENG_FRAME_TYPE_NOT_SUPPORT		   			(MSP_VPM_ENGINE_ERROR_BASE +12)
#define	MSP_VPM_ENG_JITTER_DELAY_OVER_LIMIT		   			(MSP_VPM_ENGINE_ERROR_BASE +13)

#define ERR_MAX_CONF_PARTY_EXCEEDED							(MSP_VPM_ENGINE_ERROR_BASE +14)
#define ERR_NO_PARTY_TO_BE_DELETED      					(MSP_VPM_ENGINE_ERROR_BASE +15)
#define ERR_CONF_FULL                   					(MSP_VPM_ENGINE_ERROR_BASE +16)
#define ERR_XC_FULL                     					(MSP_VPM_ENGINE_ERROR_BASE +17)
#define ERR_XC_INDEX                    					(MSP_VPM_ENGINE_ERROR_BASE +18)
#define ERR_XC_FREE                     					(MSP_VPM_ENGINE_ERROR_BASE +19)

#define ERR_CNX_REPEATED                					(MSP_VPM_ENGINE_ERROR_BASE +20)
#define ERR_CNX_DETACH_FAILED           					(MSP_VPM_ENGINE_ERROR_BASE +21)
#define ERR_CNX_DEACTV_FAILED           					(MSP_VPM_ENGINE_ERROR_BASE +22)
#define ERR_CNX_ATTACH_FAILED           					(MSP_VPM_ENGINE_ERROR_BASE +23)
#define ERR_CNX_ATTACH_REDUNDANT        					(MSP_VPM_ENGINE_ERROR_BASE +24)
#define ERR_CNX_ACTV_FAILED             					(MSP_VPM_ENGINE_ERROR_BASE +25)

#define	MSP_VPM_ENG_BLES_MODE_NOT_SUPPORT		   			(MSP_VPM_ENGINE_ERROR_BASE +26)
#define	MSP_VPM_ENG_CES_WRONG_TDM_BUS			   			(MSP_VPM_ENGINE_ERROR_BASE +27)
#define	MSP_VPM_ENG_CES_WRONG_FRAME_TYPE		   			(MSP_VPM_ENGINE_ERROR_BASE +28)
#define	MSP_VPM_ENG_CES_ALREADY_ENABLED			   			(MSP_VPM_ENGINE_ERROR_BASE +29)
#define	MSP_VPM_ENG_CES_TDM_BUS_USED_FOR_FSYN_GEN  			(MSP_VPM_ENGINE_ERROR_BASE +30)
#define	MSP_VPM_ENG_TDM_BUS_USED_CES		  				(MSP_VPM_ENGINE_ERROR_BASE +31)
#define	MSP_VPM_ENG_FSYN_GEN_ALREADY_ENABLE		  			(MSP_VPM_ENGINE_ERROR_BASE +32)
#define	MSP_VPM_ENG_FSYN_GEN_WRONG_TDM_BUS			   		(MSP_VPM_ENGINE_ERROR_BASE +33)
#define	MSP_VPM_ENG_FSYN_GEN_WRONG_FRAME_BIT			   	(MSP_VPM_ENGINE_ERROR_BASE +34)
#define	MSP_VPM_ENG_FSYN_GEN_NOT_ENABLE			  			(MSP_VPM_ENGINE_ERROR_BASE +35)
#define	MSP_VPM_ENG_SFP_SDRAM_BUF_NUM_MISMARCH	   			(MSP_VPM_ENGINE_ERROR_BASE +36)
#define	MSP_VPM_ENG_SFP_PORT_OVER_LIMIT			   			(MSP_VPM_ENGINE_ERROR_BASE +37)
#define	MSP_VPM_ENG_SFP_PORT_NUM_BASE_WRONG		   			(MSP_VPM_ENGINE_ERROR_BASE +38)
#define	MSP_VPM_ENG_CODEC_NOT_SUPPORT			   			(MSP_VPM_ENGINE_ERROR_BASE +39)


/* PE API error code definitions   */
#define MSP_PE_ERROR_BASE    	6000			/* error code base for the PE API */

#define MSP_PE_ERROR_START_FAIL             (MSP_PE_ERROR_BASE + 0)
#define MSP_PE_ERROR_START_ALREADY_CALLED   (MSP_PE_ERROR_BASE + 1)
#define MSP_PE_ERROR_CONFIG_NO_START_CALL   (MSP_PE_ERROR_BASE + 2)
#define MSP_PE_ERROR_CONFIG_ALREADY_CALLED  (MSP_PE_ERROR_BASE + 3)
#define MSP_PE_ERROR_CONFIG_MAX_CMDS        (MSP_PE_ERROR_BASE + 4)
#define MSP_PE_ERROR_CONFIG_MAX_HDLC        (MSP_PE_ERROR_BASE + 5)
#define MSP_PE_ERROR_CONFIG_MAX_UTOPIA      (MSP_PE_ERROR_BASE + 6)
#define MSP_PE_ERROR_CONFIG_MAX_SATM        (MSP_PE_ERROR_BASE + 7)
#define MSP_PE_ERROR_CONFIG_MAX_NOKIA       (MSP_PE_ERROR_BASE + 8)
#define MSP_PE_ERROR_CONFIG_MAX_DATA_VCS    (MSP_PE_ERROR_BASE + 9)
#define MSP_PE_ERROR_CONFIG_MAX_VOICE_VCS   (MSP_PE_ERROR_BASE + 10)
#define MSP_PE_ERROR_CONFIG_MAX_CIDS        (MSP_PE_ERROR_BASE + 11)
#define MSP_PE_ERROR_PHY_NO_PECONFIG_CALL   (MSP_PE_ERROR_BASE + 12)
#define MSP_PE_ERROR_PHY_MAX_PORT_NUM       (MSP_PE_ERROR_BASE + 13)
#define MSP_PE_ERROR_PHY_IDLE_CELL_MODE     (MSP_PE_ERROR_BASE + 14)
#define MSP_PE_ERROR_PHY_RX_LINE_SPEED      (MSP_PE_ERROR_BASE + 15)
#define MSP_PE_ERROR_PHY_TX_LINE_SPEED      (MSP_PE_ERROR_BASE + 16)
#define MSP_PE_ERROR_PHY_COSET_FLAG         (MSP_PE_ERROR_BASE + 17)
#define MSP_PE_ERROR_PHY_PAYLOAD_SCRAMBLE   (MSP_PE_ERROR_BASE + 18)
#define MSP_PE_ERROR_PHY_CLOCK_MODE         (MSP_PE_ERROR_BASE + 19)
#define MSP_PE_ERROR_PHY_TDM_FRAME_SYNC_BIT_MODE    (MSP_PE_ERROR_BASE + 20)
#define MSP_PE_ERROR_PHY_TDM_EXT_TX_FRAME_SYNC      (MSP_PE_ERROR_BASE + 21)
#define MSP_PE_ERROR_PHY_TDM_SLOTS          (MSP_PE_ERROR_BASE + 22)
#define MSP_PE_ERROR_PHY_AUTO_F5OAM_LOOPBACK        (MSP_PE_ERROR_BASE + 23)
#define MSP_PE_ERROR_PHY_AUTO_F4OAM_LOOPBACK        (MSP_PE_ERROR_BASE + 24)
#define MSP_PE_ERROR_UTOPIA_ALREADY_CALLED  (MSP_PE_ERROR_BASE + 25)
#define MSP_PE_ERROR_UTOPIA_MODE            (MSP_PE_ERROR_BASE + 26)
#define MSP_PE_ERROR_UTOPIA_PARITY          (MSP_PE_ERROR_BASE + 27)
#define MSP_PE_ERROR_UTOPIA_MAX_PHYS        (MSP_PE_ERROR_BASE + 28)
#define MSP_PE_ERROR_NOKIA_ALREADY_CALLED   (MSP_PE_ERROR_BASE + 29)
#define MSP_PE_ERROR_NOKIA_MAX_PHYS_ZERO    (MSP_PE_ERROR_BASE + 30)
#define MSP_PE_ERROR_SATM_ALREADY_CALLED    (MSP_PE_ERROR_BASE + 31)
#define MSP_PE_ERROR_SATM_MAX_PHYS_ZERO     (MSP_PE_ERROR_BASE + 32)
#define MSP_PE_ERROR_HDLC_ALREADY_CALLED    (MSP_PE_ERROR_BASE + 33)
#define MSP_PE_ERROR_HDLC_MAX_PHYS_ZERO     (MSP_PE_ERROR_BASE + 34)
#define MSP_PE_ERROR_HDLC_ITFPATTERN        (MSP_PE_ERROR_BASE + 35)
#define MSP_PE_ERROR_HDLC_CRCTYPE           (MSP_PE_ERROR_BASE + 36)
#define MSP_PE_ERROR_RESPONSE_STRUCT        (MSP_PE_ERROR_BASE + 37)
#define MSP_PE_ERROR_COMPLETE_FUNC          (MSP_PE_ERROR_BASE + 38)
#define MSP_PE_ERROR_VC_RX_COMPLETE_FUNC    (MSP_PE_ERROR_BASE + 39)
#define MSP_PE_ERROR_VC_VOICE_PROTOCOL      (MSP_PE_ERROR_BASE + 40)
#define MSP_PE_ERROR_VC_ATM_SRV_TYPE        (MSP_PE_ERROR_BASE + 41)
#define MSP_PE_ERROR_ADDVC_NO_WANCONFIG_CALL    (MSP_PE_ERROR_BASE + 42)
#define MSP_PE_ERROR_ADDVC_IND_MODE         (MSP_PE_ERROR_BASE + 43)
#define MSP_PE_ERROR_ADDVC_NO_RX_COMP       (MSP_PE_ERROR_BASE + 44)
#define MSP_PE_ERROR_ADDVC_ALREADY_ADDED    (MSP_PE_ERROR_BASE + 45)
#define MSP_PE_ERROR_ADDVC_ATM_VPI          (MSP_PE_ERROR_BASE + 46)
#define MSP_PE_ERROR_ADDVC_ATM_VCI          (MSP_PE_ERROR_BASE + 47)
#define MSP_PE_ERROR_ADDVC_ATM_VC_TYPE      (MSP_PE_ERROR_BASE + 48)
#define MSP_PE_ERROR_ADDVC_FR_VC_TYPE       (MSP_PE_ERROR_BASE + 49)
#define MSP_PE_ERROR_VC_BAD_PEVCHANDLE      (MSP_PE_ERROR_BASE + 50)
#define MSP_PE_ERROR_STATS_STRUCT           (MSP_PE_ERROR_BASE + 51)
#define MSP_PE_ERROR_CID_MODE               (MSP_PE_ERROR_BASE + 52)
#define MSP_PE_ERROR_CID_VOICE_PROFILE      (MSP_PE_ERROR_BASE + 53)
#define MSP_PE_ERROR_CID_BAD_PECIDHANDLE    (MSP_PE_ERROR_BASE + 54)
#define MSP_PE_ERROR_NO_CMD_AVAIL           (MSP_PE_ERROR_BASE + 55)
#define MSP_PE_ERROR_NO_SER_BUF_AVAIL       (MSP_PE_ERROR_BASE + 56)
#define MSP_PE_ERROR_NO_VC_AVAIL            (MSP_PE_ERROR_BASE + 57)
#define MSP_PE_ERROR_NO_CID_AVAIL           (MSP_PE_ERROR_BASE + 58)
#define MSP_PE_ERROR_TX_BUFF_LENGTH         (MSP_PE_ERROR_BASE + 59)
#define MSP_PE_ERROR_TX_BUFF_DESCRIPTORS    (MSP_PE_ERROR_BASE + 60)
#define MSP_PE_ERROR_RX_UNKNOWN             (MSP_PE_ERROR_BASE + 61)
#define MSP_PE_ERROR_RX_LENGTH              (MSP_PE_ERROR_BASE + 62)
#define MSP_PE_ERROR_RX_CRC                 (MSP_PE_ERROR_BASE + 63)
#define MSP_PE_ERROR_RX_ABORT               (MSP_PE_ERROR_BASE + 64)
#define MSP_PE_ERROR_RX_CPI                 (MSP_PE_ERROR_BASE + 65)
#define MSP_PE_ERROR_RX_OVERRUN             (MSP_PE_ERROR_BASE + 66)
#define MSP_PE_ERROR_ADDVC_MRU_NOT_MULTIPLE48 (MSP_PE_ERROR_BASE + 67)
#define MSP_PE_ERROR_VC_ATM_VCFLAGS			(MSP_PE_ERROR_BASE + 68)
#define MSP_PE_ERROR_CID_BAD_CIDFLAGS       (MSP_PE_ERROR_BASE + 69)
#define MSP_PE_ERROR_SEMAPHORE_NOT_AVAILABLE	(MSP_PE_ERROR_BASE + 70)
#define MSP_PE_ERROR_VC_NOT_ADDED           (MSP_PE_ERROR_BASE + 71)
#define MSP_PE_ERROR_VC_NOT_ENABLED         (MSP_PE_ERROR_BASE + 72)
#define MSP_PE_ERROR_ADDCID_ALREADY_ADDED	(MSP_PE_ERROR_BASE + 73)
#define MSP_PE_ERROR_CONFIG_VE_FAILED		(MSP_PE_ERROR_BASE + 74)

/* SCC API error code definitions */
#define MSP_SCC_ERROR_BASE		7000		/* error code base for the scc and scc API */

#define MSP_SCC_ERROR_CHAN_NO_OPEN	(MSP_SCC_ERROR_BASE+1)	/* channel has not been opened */
#define MSP_SCC_ERROR_CHAN_OPENED	(MSP_SCC_ERROR_BASE+2)	/* channel has already been opened */
#define MSP_SCC_ERROR_SIZE_NO_ZERO	(MSP_SCC_ERROR_BASE+3)	/* size cannot be zero */
#define MSP_SCC_ERROR_MEM_CACHE		(MSP_SCC_ERROR_BASE+4)	/* memory must be in non-cache */
#define MSP_SCC_ERROR_NO_PARITY		(MSP_SCC_ERROR_BASE+5)	/* parity not allowed for 8 char-bits */
#define MSP_SCC_ERROR_NO_BRK		(MSP_SCC_ERROR_BASE+6)	/* no BREAK in HDLC or SYNC */
#define MSP_SCC_ERROR_NO_ABORT		(MSP_SCC_ERROR_BASE+7)	/* ABORT not allowed in UART mode */
#define MSP_SCC_ERROR_NO_PRIME		(MSP_SCC_ERROR_BASE+8)	/* no prime char in HDLC or SYNC */
#define MSP_SCC_ERROR_NO_UART		(MSP_SCC_ERROR_BASE+9)	/* UART mode not allowed */
#define MSP_SCC_ERROR_NO_NULL		(MSP_SCC_ERROR_BASE+10)	/* NULL pointer not allowed */
#define MSP_SCC_ERROR_RX_POLL		(MSP_SCC_ERROR_BASE+11)	/* rxPoll must be TRUE for polling on getting the rx frames */
#define MSP_SCC_ERROR_CHAN_NUM		(MSP_SCC_ERROR_BASE+12)	/* channel number: out-of-range(OOR) */
#define MSP_SCC_ERROR_COM_MODE		(MSP_SCC_ERROR_BASE+13)	/* communication mode: OOR */
#define MSP_SCC_ERROR_LB_MODE		(MSP_SCC_ERROR_BASE+14)	/* loopback mode: OOR */
#define MSP_SCC_ERROR_SYNC_MODE		(MSP_SCC_ERROR_BASE+15)	/* sync mode: OOR */
#define MSP_SCC_ERROR_CLK_SOURCE	(MSP_SCC_ERROR_BASE+16)	/* clock source: OOR */
#define MSP_SCC_ERROR_CLK_RATE		(MSP_SCC_ERROR_BASE+17)	/* clock rate: OOR */    
#define MSP_SCC_ERROR_CHAR_BITS		(MSP_SCC_ERROR_BASE+18)	/* char bits: OOR */
#define MSP_SCC_ERROR_STOP_BITS		(MSP_SCC_ERROR_BASE+19)	/* stop bits: OOR */
#define MSP_SCC_ERROR_PARITY		(MSP_SCC_ERROR_BASE+20)	/* parity mode: OOR */
#define MSP_SCC_ERROR_ENHAN_MODE	(MSP_SCC_ERROR_BASE+21)	/* user's canned configuration must be for
					/  the SCC enhanced mode */
#define	MSP_SCC_ERROR_TXBD_OVERFLOW	(MSP_SCC_ERROR_BASE+22)
#define MSP_SCC_ERROR_RXBD_NODATA	(MSP_SCC_ERROR_BASE+23)
#define	MSP_SCC_ERROR_NO_BUF		(MSP_SCC_ERROR_BASE+24)
#define	MSP_SCC_ERROR_HUNTFAIL		(MSP_SCC_ERROR_BASE+25)
#define	MSP_SCC_ERROR_SYNCHFAIL		(MSP_SCC_ERROR_BASE+26)
#define	MSP_SCC_ERROR_RESTART_TX_FAIL	(MSP_SCC_ERROR_BASE+27)
#define MSP_SCC_ERROR_EXTRA_RX		(MSP_SCC_ERROR_BASE+28)
#define	MSP_SCC_ERROR_BITORDER		(MSP_SCC_ERROR_BASE+29)

#define MSP_SCC_ERROR_HDLC_ADDR		(MSP_SCC_ERROR_BASE+30)
#define MSP_SCC_ERROR_HDLC_FIFO_OVERRUN	(MSP_SCC_ERROR_BASE+31)
#define MSP_SCC_ERROR_PC_CTL		(MSP_SCC_ERROR_BASE+32)
#define MSP_SCC_ERROR_WRONG_PAR		(MSP_SCC_ERROR_BASE+33)
#define	MSP_SCC_ERROR_ABORT			(MSP_SCC_ERROR_BASE+34)
#define MSP_SCC_ERROR_HDLC_CRC		(MSP_SCC_ERROR_BASE+35)
#define	MSP_SCC_ERROR_OVERRUN		(MSP_SCC_ERROR_BASE+36)
#define	MSP_SCC_ERROR_CDLOST		(MSP_SCC_ERROR_BASE+37)

/* Security engine error code definitions   */
#define MSP_SE_ERROR_BASE			8000			/* error code base for the security engine */

#define MSP_SE_ERROR_DES_RESET_FAIL     (MSP_SE_ERROR_BASE + 0)
#define MSP_SE_ERROR_HSH_RESET_FAIL     (MSP_SE_ERROR_BASE + 1)
#define MSP_SE_ERROR_DES_INVALID_SOURCE (MSP_SE_ERROR_BASE + 2)
#define MSP_SE_ERROR_DES_INVALID_DEST   (MSP_SE_ERROR_BASE + 3)
#define MSP_SE_ERROR_DES_INVALID_MODE   (MSP_SE_ERROR_BASE + 4)
#define MSP_SE_ERROR_DES_INVALID_LENGTH (MSP_SE_ERROR_BASE + 5)
#define MSP_SE_ERROR_DES_NO_EVENTS      (MSP_SE_ERROR_BASE + 6)
#define MSP_SE_ERROR_DES_NO_INIT_DESCS  (MSP_SE_ERROR_BASE + 7)
#define MSP_SE_ERROR_DES_NO_CONT_DESCS  (MSP_SE_ERROR_BASE + 8)
#define MSP_SE_ERROR_DES_INVALID_CHAIN  (MSP_SE_ERROR_BASE + 9)
#define MSP_SE_ERROR_DES_ENGINE_BUSY    (MSP_SE_ERROR_BASE + 10)
#define MSP_SE_WARNING_DES_WEAK_KEY     (MSP_SE_ERROR_BASE + 11)
#define MSP_SE_ERROR_HSH_INVALID_SOURCE (MSP_SE_ERROR_BASE + 12)
#define MSP_SE_ERROR_HSH_INVALID_DEST   (MSP_SE_ERROR_BASE + 13)
#define MSP_SE_ERROR_HSH_INVALID_LENGTH (MSP_SE_ERROR_BASE + 14)
#define MSP_SE_ERROR_HSH_INVALID_CHAIN_VARS     (MSP_SE_ERROR_BASE + 15)
#define MSP_SE_ERROR_HSH_NO_EVENTS      (MSP_SE_ERROR_BASE + 16)
#define MSP_SE_ERROR_HSH_NO_INIT_DESCS  (MSP_SE_ERROR_BASE + 17)
#define MSP_SE_ERROR_HSH_NO_CONT_DESCS  (MSP_SE_ERROR_BASE + 18)
#define MSP_SE_ERROR_HSH_INVALID_CHAIN  (MSP_SE_ERROR_BASE + 19)
#define MSP_SE_ERROR_HSH_NO_RESULT_BUFF (MSP_SE_ERROR_BASE + 20)
#define MSP_SE_ERROR_HSH_ENGINE_BUSY    (MSP_SE_ERROR_BASE + 21)
#define MSP_SE_ERROR_NO_SER_BUF_AVAIL   (MSP_SE_ERROR_BASE + 22)
#define MSP_SE_ERROR_WRONG_MODE         (MSP_SE_ERROR_BASE + 23)
#define MSP_SE_ERROR_BAD_MODE_VALUE		(MSP_SE_ERROR_BASE + 24)
#define MSP_SE_ERROR_HSH_INVALID_MODE	(MSP_SE_ERROR_BASE + 25)
#define MSP_SE_ERROR_HSH_UNKNOWN_HMAC_MODE	(MSP_SE_ERROR_BASE + 26)
#define MSP_SE_ERROR_HSH_INVALID_CHAINID	(MSP_SE_ERROR_BASE + 27)
#define MSP_SE_ERROR_HMAC_NO_COMPARE		(MSP_SE_ERROR_BASE + 28)

/* Ethernet MAC error code definitions   */
#define MSP_MAC_ERROR_BASE			9000			/* error code base for the ethernet MAC */

#define MSP_MAC_INVALID_IFNUMBER			(MSP_MAC_ERROR_BASE + 1)
#define MSP_MAC_MEM_ALLOC_ERROR				(MSP_MAC_ERROR_BASE + 2)
#define MSP_MAC_TX_RELATED_ERROR			(MSP_MAC_ERROR_BASE + 3)
#define MSP_MAC_RX_RELATED_ERROR			(MSP_MAC_ERROR_BASE + 4)
#define MSP_MAC_ARC_ERROR					(MSP_MAC_ERROR_BASE + 5)
#define MSP_MAC_PHY_ERROR					(MSP_MAC_ERROR_BASE + 6)
#define MSP_MAC_EEPROM_ERROR				(MSP_MAC_ERROR_BASE + 7)
#define MSP_MAC_GENERAL_ERROR				(MSP_MAC_ERROR_BASE + 10)
#define MSP_MAC_PHY_DUPLEX_ERROR			(MSP_MAC_ERROR_BASE + 11)
#define MSP_MAC_PHY_NO_LINK					(MSP_MAC_ERROR_BASE + 12)
#define MSP_MAC_PHY_NOT_FOUND				(MSP_MAC_ERROR_BASE + 13)



/* QSLAC error code definitions   */
#define MSP_QSLAC_ERROR_BASE	 	10000	  		/* error code base for QSLAC */


/* E2PROM error code definitions   */
#define MSP_ESP_ERR_BASE	 	    11000	  		/* error code base for E2PROM */

#define MSP_ESP_ERR_HW_INVALID   (MSP_ESP_ERR_BASE+1)  /* ESP component does not exist */
#define MSP_ESP_ERR_TYPE         (MSP_ESP_ERR_BASE+2)  /* type of ESP component not correct */
#define MSP_ESP_ERR_CHKSUM       (MSP_ESP_ERR_BASE+3)  /* error on check-sum */
#define MSP_ESP_ERR_USER_ID      (MSP_ESP_ERR_BASE+4)  /* user's ID is out of range(OOR) */
#define MSP_ESP_ERR_REC_ID       (MSP_ESP_ERR_BASE+5)  /* user's record ID is not found  */
#define MSP_ESP_ERR_MEM_NO_SPACE (MSP_ESP_ERR_BASE+6)  /* memory of ESP is full */
#define MSP_ESP_ERR_NO_NULL      (MSP_ESP_ERR_BASE+7)  /* pointer cannot be null */
#define MSP_ESP_ERR_REC_SIZE     (MSP_ESP_ERR_BASE+8)  /* record size is zero or too big:
                                                          must be <= 255 bytes  */


/* SDSL WAN interface error code definitions   */
#define MSP_SDSL_ERROR_BASE	 		12000	  		/* error code base for SDSL WAN interface  */
#define MSP_SDSL_ERROR_BAD_INIT_STRING	(MSP_SDSL_ERROR_BASE+1)		


/* T1 WAN interface error code definitions   */
#define MSP_T1WAN_ERROR_BASE	   	13000	 		/* error code base for T1 WAN interface  */
#define MSP_T1WAN_BAD_IFNUM			(MSP_T1WAN_ERROR_BASE+1)


/* Flash Memory error code definitions   */
#define MSP_FLASH_ERROR_BASE	 	14000	  		/* error code base for Flash Memory */

#define MSP_FLASH_ERROR_HW_INVALID    (MSP_FLASH_ERROR_BASE+1)   /* flash memory does not exist */
#define MSP_FLASH_ERROR_TYPE          (MSP_FLASH_ERROR_BASE+2)   /* type of flash memory not correct */
#define MSP_FLASH_ERROR_CHKSUM        (MSP_FLASH_ERROR_BASE+3)   /* error on check-sum */
#define MSP_FLASH_ERROR_USER_ID       (MSP_FLASH_ERROR_BASE+4)   /* user's ID is out of range */
#define MSP_FLASH_ERROR_MEM_NO_SPACE  (MSP_FLASH_ERROR_BASE+5)   /* memory not available for the record*/
#define MSP_FLASH_ERROR_REC_ID        (MSP_FLASH_ERROR_BASE+6)   /* user's record ID is not found  */
#define MSP_FLASH_ERROR_NO_NULL       (MSP_FLASH_ERROR_BASE+7)   /* pointer cannot be null */
#define MSP_FLASH_ERROR_SIZE_NO_ZERO  (MSP_FLASH_ERROR_BASE+8)   /* size cannot be zero */
#define MSP_FLASH_ERROR_TOO_MANY_REC  (MSP_FLASH_ERROR_BASE+9)   /* too many records: maximal # of record 
                                                                 /  for each user is S_FM_USER_REC */

/* Peripheral Engine Loader error code definitions */
#define MSP_LOADER_ERROR_BASE		15000			/* error code base for code loading functions */

#define MSP_LOADER_INVALID_APP_ID	   	(MSP_LOADER_ERROR_BASE + 1)
#define MSP_LOADER_INVALID_APP_NAME		(MSP_LOADER_ERROR_BASE + 2)
#define MSP_LOADER_CODE_NOT_FOUND		(MSP_LOADER_ERROR_BASE + 3)
#define MSP_LOADER_BOOT_LOAD_FAIL		(MSP_LOADER_ERROR_BASE + 4)
#define MSP_LOADER_BCOPY_FAIL			(MSP_LOADER_ERROR_BASE + 5)

/* MSP BUFFER ERROR VALUES */
#define MSP_ALLOCATION_ERROR_START 	16000

#define MSP_FIFO_JOIN_FAILURE			(MSP_ALLOCATION_ERROR_START + 1)
#define MSP_TASKLOCK_FAIL				(MSP_ALLOCATION_ERROR_START + 2)
#define MSP_INVALID_BUFFSIZE			(MSP_ALLOCATION_ERROR_START + 3)
#define	MSP_NOBUFFS_AVAILABLE			(MSP_ALLOCATION_ERROR_START + 4)
#define MSP_NUMBUFFS_REQ_UNAVAIL		(MSP_ALLOCATION_ERROR_START + 5)
#define	MSP_MINFIFODEPTH_EXCEEDED		(MSP_ALLOCATION_ERROR_START + 6)
#define MSP_FIFOSTRUCT_IS_NULL			(MSP_ALLOCATION_ERROR_START + 7)
#define MSP_BUF_INVALID_OFFSET			(MSP_ALLOCATION_ERROR_START + 8)
#define MSP_FIFO_BUF_FIFO_NULL 			(MSP_ALLOCATION_ERROR_START + 9)
#define MSP_FIFO_BUFFER_NULL			(MSP_ALLOCATION_ERROR_START + 10)
#define MSP_BCOPY_FAIL					(MSP_ALLOCATION_ERROR_START + 11)
#define MSP_RTOSBUF_ALLOCATE_FAIL		(MSP_ALLOCATION_ERROR_START + 12)
#define MSP_MBLKCLSTR_INIT_FAIL_NO_MEM	(MSP_ALLOCATION_ERROR_START + 13)
#define MSP_RTOS_DATASPACE_INIT_FAIL	(MSP_ALLOCATION_ERROR_START + 14)
#define MSP_RTOS_NETPOOL_INIT_FAIL		(MSP_ALLOCATION_ERROR_START + 15)


/* SHDSL WAN interface error code definitions   */
#define MSP_SHDSL_ERROR_BASE	 		17000	  		/* error code base for SHDSL WAN interface  */
#define MSP_SHDSL_ERROR_BAD_INIT_STRING			(MSP_SHDSL_ERROR_BASE+1)
#define MSP_SHDSL_ERROR_EOC_BUFFER_ALREADY_IN_USE	(MSP_SHDSL_ERROR_BASE+2)		
#define MSP_SHDSL_ERROR_ILLEGAL_EOC_MSG_LEGNTH		(MSP_SHDSL_ERROR_BASE+3)		

#define MSP_PHY_ERROR_BASE				18000
#define MSP_PHY_LINK_UP					(MSP_PHY_ERROR_BASE+1)					
#define	MSP_PHY_LINK_DOWN				(MSP_PHY_ERROR_BASE+2)
#define MSP_PHY_LINK_TRANSITION			(MSP_PHY_ERROR_BASE+3)
#define	MSP_PHY_ALARM					(MSP_PHY_ERROR_BASE+4)

#define MSP_CLOCKING_ERROR_BASE				19000
#define MSP_INVALID_CLOCKING_MODE			(MSP_CLOCKING_ERROR_BASE + 1)
#define MSP_INVALID_CLOCK_SOURCE			(MSP_CLOCKING_ERROR_BASE + 2)
#define MSP_INVALID_CLOCK_TX_DIRECTION		(MSP_CLOCKING_ERROR_BASE + 3)
#define MSP_INVALID_TX_FRAME_SYNC_DIRECTION	(MSP_CLOCKING_ERROR_BASE + 4)
#define MSP_INVALID_VPM_CLK_MUX				(MSP_CLOCKING_ERROR_BASE + 5)
#define MSP_PFD_MODE_TIMERBLOCK_ALLOC_FAIL	(MSP_CLOCKING_ERROR_BASE + 6)
#define MSP_INVALID_PFD_REPORTING_FUNC		(MSP_CLOCKING_ERROR_BASE + 7)

#define MSP_PERIPERAL_BLOCK_BASE		20000
#define MSP_MEMORY_ALLOCATION_ERROR_PERIPH			(MSP_PERIPERAL_BLOCK_BASE + 1)
#define MSP_GPIO_INVALID_IO_DIRECTION				(MSP_PERIPERAL_BLOCK_BASE + 2)
#define MSP_GPIO_INVALID_GPIO_PIN					(MSP_PERIPERAL_BLOCK_BASE + 3)
#define MSP_GPIO_INVALID_INTHANDLER					(MSP_PERIPERAL_BLOCK_BASE + 4)
#define MSP_GPIO_INVALID_OUTPUT_SOURCE				(MSP_PERIPERAL_BLOCK_BASE + 5)
#define MSP_GPIO_INVALID_INPUT_DEST					(MSP_PERIPERAL_BLOCK_BASE + 6)
#define MSP_GPIO_PIN_ALREADY_INUSE					(MSP_PERIPERAL_BLOCK_BASE + 7)
#define MSP_GPIO_TIMER_COUNTER_OUT_INUSE			(MSP_PERIPERAL_BLOCK_BASE + 8)
#define MSP_GPIO_TIMER_COUNTER_GATE_INUSE			(MSP_PERIPERAL_BLOCK_BASE + 9)
#define MSP_GPIO_TIMER_COUNTER_CLK_INUSE			(MSP_PERIPERAL_BLOCK_BASE + 10)
#define MSP_GPIO_PIN_NOT_ASSIGNED					(MSP_PERIPERAL_BLOCK_BASE + 11)
#define MSP_TIMER_TIMER_BLOCK_OUT_OF_RANGE			(MSP_PERIPERAL_BLOCK_BASE + 12)
#define MSP_TIMER_INVALID_MODE						(MSP_PERIPERAL_BLOCK_BASE + 13)
#define MSP_TIMER_INVALID_INVERSION_VALUE			(MSP_PERIPERAL_BLOCK_BASE + 14)
#define MSP_TIMER_INVALID_GATE_STATE				(MSP_PERIPERAL_BLOCK_BASE + 15)
#define MSP_TIMER_TIMER_NOT_ASSIGNED				(MSP_PERIPERAL_BLOCK_BASE + 16)
#define MSP_GPIO_PIN_NOT_CONFIGED_FOR_ACTION		(MSP_PERIPERAL_BLOCK_BASE + 17)

#define MEMORY_ALLOCATION_ERROR_ST    	0x00000001
#define MEMORY_ALLOCATION_ERROR_FE    	0x00000002
#define MEMORY_ALLOCATION_ERROR_VE    	0x00000004
#define MEMORY_ALLOCATION_ERROR_MAC0  	0x00000008
#define MEMORY_ALLOCATION_ERROR_MAC1  	0x00000010
#define MEMORY_ALLOCATION_ERROR_PIB   	0x00000020
#define MEMORY_ALLOCATION_ERROR_DES   	0x00000040

#define ISR_ASSIGNMENT_ERROR_PE       	0x00000080
#define ISR_ASSIGNMENT_ERROR_VE       	0x00000100
#define ISR_ASSIGNMENT_ERROR_MAC0     	0x00000200
#define ISR_ASSIGNMENT_ERROR_MAC1     	0x00000400
#define ISR_ASSIGNMENT_ERROR_PIB      	0x00000800
#define ISR_ASSIGNMENT_ERROR_DES      	0x00001000


#define SEMAPHORE_CREATION_ERROR_FE   	0x00002000
#define SEMAPHORE_CREATION_ERROR_VE   	0x00004000
#define SEMAPHORE_CREATION_ERROR_MAC0 	0x00008000
#define SEMAPHORE_CREATION_ERROR_MAC1 	0x00010000
#define SEMAPHORE_CREATION_ERROR_PIB  	0x00020000
#define SEMAPHORE_CREATION_ERROR_DES  	0x00040000



#endif /*ERR_GLOBAL_MSP_H */

