#ifndef	   BRECIS_TDMSDMA_DVR_H_INC_
#define	   BRECIS_TDMSDMA_DVR_H_INC_
/* $Header: /proj/software/pub/CVSROOT/uClinux/linux/include/brecis/brecis_tdmsdma_dvr.h,v 1.9 2002/09/25 16:59:10 tld Exp $ */
/* ************************************************************************ *
 *
 * brecis_tdmsdma_dvr.h
 *
 *                  Copyright 2002, Brecis Communications
 *
 * Originator: TL Donahue
 *
 *          [Generated by tld on Wed 21 Aug 2002 at 14:00:30 UTC]
 * ************************************************************************ */
				
#define BRECIS_TDMSDMA_NAME	"tdmsdma"
#define BRECIS_TDMSDMA_DEV_ROOT	"/proc/"

#define BRECIS_TDMSDMA_API      BRECIS_TDMSDMA_DEV_ROOT BRECIS_TDMSDMA_NAME

/* declarations and definitions for IOCTLs */

typedef enum {
	TDM_SLOTS_1=1,
	TDM_SLOTS_2,
	TDM_SLOTS_3,
	TDM_SLOTS_4,
	TDM_SLOTS_T1=24,
	TDM_SLOTS_E1=32
} TDM_TOTAL_TIME_SLOTS;

enum {
	TDM_TX=1,
	TDM_RX,
	TDM_TX_RX
};

typedef struct {
	TDM_TOTAL_TIME_SLOTS slots;
	unsigned int rx_frames_in_buffer; /* 0 or multiple of frames/burst */
	unsigned int tx_frames_in_buffer; /* 0 or multiple of frames/burst */
	unsigned int rx_active_time_slot_mask;
	unsigned int tx_active_time_slot_mask;
} TDM_IOCTL_CONFIG;

/*
 * This interface can be used to query or set the burst count on which to
 *  interrupt and to query the burst length.
 *
 * The defaults are usually satisfactory.  Tuning may be used in special
 *  circumstances.  The burst count is recomputed by configure IOCTL,
 *  so the burst count should be queried/set only after configuring.
 */
typedef struct {
	unsigned char rx_burst_cnt; /* 0 to fetch current, non-0 to set */
	unsigned char tx_burst_cnt; /* 0 to fetch current, non-0 to set */
	unsigned char burst_length; /* read only */
} TDM_IOCTL_BURST;

/* the following enum is *not* for use in user programs */
enum {
	TDM_IOCTL_CODE_CONFIG=0,
	TDM_IOCTL_CODE_START,
	TDM_IOCTL_CODE_STOP,
	TDM_IOCTL_CODE_BURST,
	TDM_IOCTL_CODE_FIRST_UNUSED	/* must always be last */
};
/* the preceeding enum is *not* for use in user programs */


#define TDMSDMA_DVR_IOC_MAGIC 'T'
#define TDMSDMA_DVR_IOC_CONFIG	_IOWR(TDMSDMA_DVR_IOC_MAGIC, \
     TDM_IOCTL_CODE_CONFIG, sizeof(TDM_IOCTL_CONFIG))
#define TDMSDMA_DVR_IOC_START	 _IOW(TDMSDMA_DVR_IOC_MAGIC, \
     TDM_IOCTL_CODE_START, sizeof(int))
#define TDMSDMA_DVR_IOC_STOP	 _IOW(TDMSDMA_DVR_IOC_MAGIC, \
     TDM_IOCTL_CODE_STOP, sizeof(int))
#define TDMSDMA_DVR_IOC_BURST	_IOWR(TDMSDMA_DVR_IOC_MAGIC, \
     TDM_IOCTL_CODE_BURST, sizeof(TDM_IOCTL_BURST))

#endif	/* BRECIS_TDMSDMA_DVR_H_INC_ */
/* ******************** End of brecis_tdmsdma_dvr.h *********************** */
