/*
 $Header: /proj/software/pub/CVSROOT/uClinux/linux/include/brecis/MspSysDef.h,v 1.1 2002/07/19 14:32:35 tld Exp $
 */


/****************************************************************************/
/*																			*/
/*																			*/
/*	Modification History:													*/
/*	Author:Date				: Description									*/
/*  Ying Wu:    8-21-2001													*/
/****************************************************************************/
/*	Description:															*/
/*	This files contains the type definition for Msp System					*/
/****************************************************************************/



/******************************************************************/
/* Copyright (c) 2001 BRECIS Communications                       */
/*      This software is the property of BRECIS Communications    */
/*      and may not be copied or distributed in any form without  */
/*      a prior licensing arrangement.                            */
/*                                                                */
/* BRECIS COMMUNICATIONS DISCLAIMS ANY LIABILITY OF ANY KIND      */
/* FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS      */
/* SOFTWARE.                                                      */
/*                                                                */
/******************************************************************/

#ifndef __MspSysDefH__
#define __MspSysDefH__

#include "mspCommon.h"

/*============================ defines ================================*/

#define AND		    &&
#define OR		    ||
#define NOT		    !
#define MOD		    %
#define ON		    1
#define OFF		    0
#define FAIL		    1
#define PASS                0

#define TRIAD_OK	 0
#define TRIAD_NOTOK -1 

#define null		    (0)
#define pNull		    ((P_UNKNOWN)0)
#define ppNull		    ((PP_UNKNOWN)0)
#define Nil(type)	    ((type)0)


#define on_bit0		    (0x00000001)
#define on_bit1		    (0x00000002)
#define on_bit2		    (0x00000004)
#define on_bit3		    (0x00000008)
#define on_bit4		    (0x00000010)
#define on_bit5		    (0x00000020)
#define on_bit6		    (0x00000040)
#define on_bit7		    (0x00000080)
#define on_bit8		    (0x00000100)
#define on_bit9		    (0x00000200)
#define on_bit10	    (0x00000400)
#define on_bit11            (0x00000800)
#define on_bit12	    (0x00001000)
#define on_bit13	    (0x00002000)
#define on_bit14	    (0x00004000)
#define on_bit15	    (0x00008000)
#define on_bit16	    (0x00010000)
#define on_bit17	    (0x00020000)
#define on_bit18	    (0x00040000)
#define on_bit19	    (0x00080000)
#define on_bit20	    (0x00100000)
#define on_bit21	    (0x00200000)
#define on_bit22	    (0x00400000)
#define on_bit23	    (0x00800000)
#define on_bit24	    (0x01000000)
#define on_bit25	    (0x02000000)
#define on_bit26	    (0x04000000)
#define on_bit27	    (0x08000000)
#define on_bit28	    (0x10000000)
#define on_bit29	    (0x20000000)
#define on_bit30	    (0x40000000)
#define on_bit31	    (0x80000000)

#define off_bit0	    (0xfffffffe)
#define off_bit1	    (0xfffffffd)
#define off_bit2	    (0xfffffffb)
#define off_bit3	    (0xfffffff7)
#define off_bit4	    (0xffffffef)
#define off_bit5	    (0xffffffdf)
#define off_bit6	    (0xffffffbf)
#define off_bit7	    (0xffffff7f)
#define off_bit8	    (0xfffffeff)
#define off_bit9	    (0xfffffdff)
#define off_bit10           (0xfffffbff)
#define off_bit11           (0xfffff7ff)
#define off_bit12           (0xffffefff)
#define off_bit13           (0xffffdfff)
#define off_bit14           (0xffffbfff)
#define off_bit15           (0xffff7fff)
#define off_bit16           (0xfffeffff)
#define off_bit17           (0xfffdffff)
#define off_bit18           (0xfffbffff)
#define off_bit19           (0xfff7ffff)
#define off_bit20           (0xffefffff)
#define off_bit21           (0xffdfffff)
#define off_bit22           (0xffbfffff)
#define off_bit23           (0xff7fffff)
#define off_bit24           (0xfeffffff)
#define off_bit25           (0xfdffffff)
#define off_bit26           (0xfbffffff)
#define off_bit27           (0xf7ffffff)
#define off_bit28           (0xefffffff)
#define off_bit29           (0xdfffffff)
#define off_bit30           (0xbfffffff)
#define off_bit31           (0x7fffffff)



#define flag0		    (0x0001)
#define flag1		    (0x0002)
#define flag2		    (0x0004)
#define flag3		    (0x0008)
#define flag4		    (0x0010)
#define flag5		    (0x0020)
#define flag6		    (0x0040)
#define flag7		    (0x0080)
#define flag8		    (0x0100)
#define flag9		    (0x0200)
#define flag10		    (0x0400)
#define flag11		    (0x0800)
#define flag12		    (0x1000)
#define flag13		    (0x2000)
#define flag14		    (0x4000)
#define flag15		    (0x8000)
#define flag16	    	(0x00010000L)
#define flag17		    (0x00020000L)
#define flag18		    (0x00040000L)
#define flag19		    (0x00080000L)
#define flag20		    (0x00100000L)
#define flag21		    (0x00200000L)
#define flag22		    (0x00400000L)
#define flag23		    (0x00800000L)
#define flag24		    (0x01000000L)
#define flag25		    (0x02000000L)
#define flag26		    (0x04000000L)
#define flag27		    (0x08000000L)
#define flag28		    (0x10000000L)
#define flag29		    (0x20000000L)
#define flag30		    (0x40000000L)
#define flag31		    (0x80000000L)

#define maxU8		    ((U8)0xFF)
#define minS8		    ((S8)0x80)
#define maxS8		    ((S8)0x7F)
#define maxU16		    ((U16)0xFFFF)
#define minS16		    ((S16)0x8000)
#define maxS16		    ((S16)0x7FFF)
#define maxU32		    ((U32)0xFFFFFFFF)
#define minS32		    ((S32)0x80000000)
#define maxS32		    ((S32)0x7FFFFFFF)

/*=========================== intrinsics ==============================*/

#define Abs(v)		    	((v)<0 ? (-(v)):(v))
#define Max(a,b)	    	((a)>(b) ? (a):(b))
#define Min(a,b)	    	((a)<(b) ? (a):(b))
#define Even(v)		    	(!((v) & 1))
#define Odd(v)		    	(!!((v) & 1))

#define LowU16(dw)	      	((U16)(U32)(dw))
#define HighU16(dw)	    	((U16)(((U32)(dw) >> 16) & 0xFFFF))
#define LowU8(w)	    	((U8)(w))
#define HighU8(w)	    	((U8)(((U16)(w) >> 8) & 0xFF))
#define MakeU16(lb,hb)	    (((U16)(hb) << 8) | (U16)(lb))
#define MakeU32(lw,hw)	    (((U32)(hw) << 16) | (U32)(lw))

#define FlagOn(f,v)	    	(!!((v)&(f)))
#define FlagOff(f,v)	    (!((v)&(f)))
#define FlagSet(f,v)	    ((v)|(f))
#define FlagClr(f,v)	    ((v)&(~(f)))

#define OutRange(v,l,h)	    (!!((v)<(l) || (v)>(h)))
#define InRange(v,l,h)	    (!!((v)>=(l) && (v)<=(h)))

#define SizeOf(t)	    	((SIZEOF)sizeof(t))

#define verbose 1
#define quiet   0

#define testFailed  0
#define testPassed  1
#define testAborted 2
#define testNotDone 3

#define BiosPutChar(x)          com_putc(x)
#define BiosGetChar()           com_getc()

#ifndef EOF
#define EOF	-1
#endif

#define         BIT0            0x1
#define         BIT1            0x2
#define         BIT2            0x4
#define         BIT3            0x8
#define         BIT4            0x10
#define         BIT5            0x20 
#define         BIT6            0x40 
#define         BIT7            0x80 
#define         BIT8            0x100
#define         BIT9            0x200
#define         BIT10           0x400
#define         BIT11           0x800 
#define         BIT12           0x1000 
#define         BIT13           0x2000 
#define         BIT14           0x4000
#define         BIT15           0x8000 
#define         BIT16           0x10000
#define         BIT17           0x20000
#define         BIT18           0x40000
#define         BIT19           0x80000
#define         BIT20           0x100000
#define         BIT21           0x200000
#define         BIT22           0x400000 
#define         BIT23           0x800000
#define         BIT24           0x1000000
#define         BIT25           0x2000000
#define         BIT26           0x4000000
#define         BIT27           0x8000000
#define         BIT28           0x10000000
#define         BIT29           0x20000000
#define         BIT30           0x40000000
#define         BIT31           0x80000000


/****************************************************/
/* TRIAD TABLE STATUS FOR HW STAGE                  */
/****************************************************/

enum TRIAD_STATUS_HW {
	 TRIAD_RST_NOT_OK,
	 TRIAD_RST_OK,
	 TRIAD_RST_CLR_OK,
	 TRIAD_RST_CLR_NOTOK,
	 TRIAD_RST_UNKNOW_DEV,
	 TRIAD_BCOPY_BUSY,
	 TRIAD_BCOPY_COMPLETE,
	 TRIAD_BCOPY_TX_ERROR,
	 TRIAD_QSLAC_NOT_OK,
	 TRIAD_QSLAC_OK,
	 TRIAD_I2C_OK,
	 TRIAD_I2C_NOT_OK,
	 TRIAD_EEPROM_TX_BUSY,
	 TRIAD_EEPROM_FIFO_FULL,
	 TRIAD_EEPROM_NOT_OK,
	 TRIAD_EEPROM_OK
};
typedef enum TRIAD_STATUS_HW TRIAD_STATUS;


/****************************************************/
/* Definitions for VE/PE ZSP		                */
/****************************************************/

#define ZSP_PASS					0xBEEF				/* first 16 bits */
#define ZSP_FAIL					0xDEAF
#define END_OF_TABLE		 		0xffffffff

/************/
/* File ID */
/***********/

#define ZSP_FE						1
#define ZSP_VE						2
#define ZSP_VPM_PE				ZSP_VE
#define ZSP_VPM					ZSP_VE
#define	ZSP_PE					ZSP_FE

#define TEST_MODE_ALL				0x1
#define TEST_MODE_SINGLE			0x2
#define TEST_MODE_BLOCK				0x4
#define TEST_MODE_EXT				0x8
#define TEST_MODE_INT				0x10
#define TEST_MODE_EXT_INT_ENG		0x20

#define ZSP_APP_DIAG_INT			1
#define ZSP_APP_DIAG_EXT			2
#define ZSP_APP_FIRMWARE			3

#if 0
/****************************/
/** Error Status For Loader */
/****************************/
enum ZSP_LD_STATUS {
	TriadLd_OK,
	TriadLd_ERR,
	TriadZspDoWrMem_BadEntry,
	TriadZspDoWrMem_BadReturn,
	TriadCp2ZspTestTable_Error,
	TriadZspLoader_invalid,
	TriadZspLoader_WR_ERR,
	TriadZspXferDmaD_BadEntry,
	TriadZspXferDmaD_ErroBcpy,
	TriadZspXferDmaD_TimeOut,
	TriadZspXferDmaD_BadReturnInt,
	TriadGetTestTable_noIndexFound,
	TriadZspTest_NoIndexFound,
 	TriadZspTest_WrMemError,
	TriadZspTest_unkownApp,
	TriadZspGetFlag_pass,
	TriadZspGetFlag_fail,
	TriadZspGetFlag_Abort,
	TriadZspGetFlag_TimeOut,
	TriadZspGetFlag_unkown,
	TriadZspCmpMemIbootFail,
	TriadZspCmpMemItextFail,
	TriadZspCmpMemDataFail,
	TriadZspCmpMemPass
};

typedef enum ZSP_LD_STATUS LD_STATUS;
#endif


/*--------------------------------------------------------------------------+
|  MPI Interface Controller
|	MPI_BASE = 0x184000		
|
|  Register Address Map
+--------------------------------------------------------------------------*/

#define  MPI_NULL    0xFF

typedef struct qslac_cmd_table {
	U8			decimal_num;
	U8			hex_num;
	U8			cmd_size;
} QSLAC_CMD_DATA_TAB;

#if 0
enum U8 {
	DUMMY = 0,
	DEACTIVATE,
	SOFT_RESET,
	HARD_RESET,
	NO_OPERATION,
	ACTIVATE,
	WRITE_TX_TIME_PCM,
	READ_TX_TIME_PCM,
	WRITE_RX_TIME_PCM,
	READ_RX_TIME_PCM,
	WRITE_REC_TXCLK,
	READ_REX_TXCLK,
	WRITE_CONFIG_REG,             
	READ_CONFIG_REG,
	WRITE_CHAN_ENA_OPMODE,        
	READ_CHAN_ENA_OPMODE,	  
	READ_REALTIME_DATA,
	READ_REALTIME_DATA_CLR_INT,
	WRITE_AISN_ANALOGUE_GAINS,
	READ_AISN_ANALOGUE_GAINS,
	WRITE_SLIC_IO_REGISTER,       
	READ_SLIC_IO_REGISTER,        
	WR_SLIC_IO_DIR_STATUS_BIT,
	RD_SLIC_IO_DIR_STATUS_BIT,
	WRITE_OPERATION_FCNS,
	READ_OPERATION_FCNS,
	WRITE_INTERRUPT_MASK_REG,
	READ_INTERRUPT_MASK_REG,
	WRITE_OPERATION_CONDITIONS,
	READ_OPERATION_CONDITIONS,
	READ_REV_CODE_NUMBER,
	WR_GX_FILTER_COEFFICIENTS,
	RD_GX_FILTER_COEFFICIENTS,
	WR_GR_FILTER_COEFFICIENTS,
	RD_GR_FILTER_COEFFICIENTS,
	WR_Z_FILTER_COEFFICIENTS,
	RD_Z_FILTER_COEFFICIENTS,
	WR_B1_FILTER_COEFFICIENTS,
	RD_B1_FILTER_COEFFICIENTS,
	WR_X_FILTER_COEFFICIENTS,
	RD_X_FILTER_COEFFICIENTS,
	WR_R_FILTER_COEFFICIENTS,
	RD_R_FILTER_COEFFICIENTS,
	WR_B2_FILTER_COEFFICIENTS,
	RD_B2_FILTER_COEFFICIENTS,
	WR_DEBOUNCE_TIME_REG,
	RD_DEBOUNCE_TIME_REG,
	RD_TX_PCM_DATA,
	WR_FIR_Z_FILTER_COEFFICIENTS,
	RD_FIR_Z_FILTER_COEFFICIENTS,
	WR_IIR_Z_FILTER_COEFFICIENTS,
	RD_IIR_Z_FILTER_COEFFICIENTS,
	WR_GRD_KEY_FILTER_SAMP_INTR,
	RD_GRD_KEY_FILTER_SAMP_INTR
} ;
#endif
#define CS_ASSERT_DELAY \
        { \
		 U32 periErrorRegValue; \
			periErrorRegValue = *PER_ERR_BIT_REG; \
			periErrorRegValue = *PER_ERR_BIT_REG; \
			periErrorRegValue = *PER_ERR_BIT_REG; \
        }

#endif
