/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

    Module Name:
    rtmp.h

    Abstract:
    Miniport generic portion header file

    Revision History:
    Who         When          What
    --------    ----------    ----------------------------------------------
    Paul Lin    08-01-2002    created

*/
#ifndef __RTMP_H__
#define __RTMP_H__

#include "mlme.h"
#include "oid.h"

//
//  Queue structure and macros
//
typedef struct _QUEUE_ENTRY    {
    struct _QUEUE_ENTRY     *Next;
}   QUEUE_ENTRY, *PQUEUE_ENTRY;

// Queue structure
typedef struct _QUEUE_HEADER   {
    PQUEUE_ENTRY    Head;
    PQUEUE_ENTRY    Tail;
    ULONG			Number;
}   QUEUE_HEADER, *PQUEUE_HEADER;

#define InitializeQueueHeader(QueueHeader)              \
{                                                       \
    (QueueHeader)->Head = (QueueHeader)->Tail = NULL;   \
    (QueueHeader)->Number = 0;							\
}

#define RemoveHeadQueue(QueueHeader)                \
(QueueHeader)->Head;                                \
{                                                   \
    PQUEUE_ENTRY pNext;                             \
    pNext = (QueueHeader)->Head->Next;              \
    (QueueHeader)->Head = pNext;                    \
    if (pNext == NULL)                              \
        (QueueHeader)->Tail = NULL;                 \
    (QueueHeader)->Number--;						\
}

#define InsertHeadQueue(QueueHeader, QueueEntry)            \
{                                                           \
    ((PQUEUE_ENTRY)QueueEntry)->Next = (QueueHeader)->Head; \
    (QueueHeader)->Head = (PQUEUE_ENTRY)(QueueEntry);       \
    if ((QueueHeader)->Tail == NULL)                        \
        (QueueHeader)->Tail = (PQUEUE_ENTRY)(QueueEntry);   \
    (QueueHeader)->Number++;								\
}

#define InsertTailQueue(QueueHeader, QueueEntry)                \
{                                                               \
    ((PQUEUE_ENTRY)QueueEntry)->Next = NULL;                    \
    if ((QueueHeader)->Tail)                                    \
        (QueueHeader)->Tail->Next = (PQUEUE_ENTRY)(QueueEntry); \
    else                                                        \
        (QueueHeader)->Head = (PQUEUE_ENTRY)(QueueEntry);       \
    (QueueHeader)->Tail = (PQUEUE_ENTRY)(QueueEntry);           \
    (QueueHeader)->Number++;					\
}

//
//  MACRO for debugging information
//
#ifdef RT2500_DBG
extern ULONG    RTDebugLevel;

#define DBGPRINT(Level, fmt, args...)           \
{                                               \
    if (Level <= RTDebugLevel)                  \
    {                                           \
        printk(NIC_DBG_STRING);                 \
        printk(KERN_DEBUG fmt, ## args);        \
    }                                           \
}
#else
#define DBGPRINT(Level, fmt, args...)
#endif

//
//	spin_lock enhanced for Nested spin lock
//
extern unsigned long IrqFlags;

#define	NdisAllocateSpinLock(lock)		\
{                                       \
	spin_lock_init(lock);				\
}

#define NdisReleaseSpinLock(lock)			\
{											\
	spin_unlock_irqrestore(lock, IrqFlags);	\
}

#define NdisAcquireSpinLock(lock)			\
{											\
	spin_lock_irqsave(lock, IrqFlags);		\
}

#define RTMPFreeSkbBuffer(skb)				\
{											\
	dev_kfree_skb_any(skb);					\
}

//  Assert MACRO to make sure program running
//
#undef  ASSERT
#define ASSERT(x)                                                                       \
{                                                                                       \
    if (!(x))                                                                           \
    {                                                                                   \
        printk(KERN_WARNING __FILE__ ":%d assert " #x "failed\n", __LINE__);            \
    }                                                                                   \
}

//
//  Macros for flag and ref count operations
//
#define RTMP_SET_FLAG(_M, _F)       ((_M)->Flags |= (_F))
#define RTMP_CLEAR_FLAG(_M, _F)     ((_M)->Flags &= ~(_F))
#define RTMP_CLEAR_FLAGS(_M)        ((_M)->Flags = 0)
#define RTMP_TEST_FLAG(_M, _F)      (((_M)->Flags & (_F)) != 0)
#define RTMP_TEST_FLAGS(_M, _F)     (((_M)->Flags & (_F)) == (_F))

#define RTMP_INC_RCV_REF(_A)        ((_A)->RcvRefCount++)
#define RTMP_DEC_RCV_REF(_A)        ((_A)->RcvRefCount--)
#define RTMP_GET_RCV_REF(_A)        ((_A)->RcvRefCount)

#define RTMP_INC_SEND_REF(_A)       ((_A)->SendRefCount++)
#define RTMP_DEC_SEND_REF(_A)       ((_A)->SendRefCount--)
#define RTMP_GET_SEND_REF(_A)       ((_A)->SendRefCount)

#define	NdisEqualMemory(Source1, Source2, Length)	RTMPEqualMemory(Source1, Source2, Length)

//
// MACRO for 32-bit PCI register read / write
//
// Usage : RTMP_IO_READ32(
//              PRTMP_ADAPTER pAdapter,
//              ULONG Register_Offset,
//              PULONG  pValue)
//
//         RTMP_IO_WRITE32(
//              PRTMP_ADAPTER pAdapter,
//              ULONG Register_Offset,
//              ULONG Value)
//
#ifdef RTMP_EMBEDDED
#define RTMP_IO_READ32(_A, _R, _pV)     (*_pV = PCIMemRead32(__mem_pci(_A->CSRBaseAddress+_R)))
#define RTMP_IO_WRITE32(_A, _R, _V)     (PCIMemWrite32(__mem_pci(_A->CSRBaseAddress+_R),_V))
#else
#define RTMP_IO_READ32(_A, _R, _pV)     (*_pV = readl(_A->CSRBaseAddress+_R))
#define RTMP_IO_WRITE32(_A, _R, _V)     (writel(_V, _A->CSRBaseAddress+_R))
#endif

//
// BBP & RF are using indirect access. Before write any value into it.
// We have to make sure there is no outstanding command pending via checking busy bit.
//
#define	MAX_BUSY_COUNT	10			// Nunber of retry before failing access BBP & RF indirect register
//
#define	RTMP_BBP_IO_WRITE32(_A, _V)				\
{												\
	BBPCSR_STRUC	Value;						\
	ULONG			BusyCnt = 0;				\
	do {										\
		RTMP_IO_READ32(_A, BBPCSR, &Value.word);	\
		if (Value.field.Busy == IDLE)			\
			break;								\
		BusyCnt++;								\
	}	while (BusyCnt < MAX_BUSY_COUNT);		\
	RTMP_IO_WRITE32(_A, BBPCSR, _V);				\
}
//
#define	RTMP_RF_IO_WRITE32(_A, _V)				\
{												\
	RFCSR_STRUC		Value;						\
	ULONG			BusyCnt = 0;				\
	do {										\
		RTMP_IO_READ32(_A, RFCSR, &(Value.word));	\
		if (Value.field.Busy == IDLE)			\
			break;								\
		BusyCnt++;								\
	}	while (BusyCnt < MAX_BUSY_COUNT);		\
	RTMP_IO_WRITE32(_A, RFCSR, _V);				\
}
//
#define	RTMP_BBP_IO_READ32(_A, _pV)				\
{												\
	BBPCSR_STRUC	Value;						\
	ULONG			BusyCnt = 0;				\
	RTMP_BBP_IO_WRITE32(_A, *(_pV));			\
	do {										\
		RTMP_IO_READ32(_A, BBPCSR, &Value.word);\
		if (Value.field.Busy == IDLE)			\
			break;								\
		BusyCnt++;								\
	}	while (BusyCnt < MAX_BUSY_COUNT);		\
	if (BusyCnt == MAX_BUSY_COUNT)				\
		*(_pV) = 0xff;							\
	else										\
        *(_pV) = Value.field.Value;             \
}
// Read BBP register by register's ID
#define	RTMP_BBP_IO_READ32_BY_REG_ID(_A, _I, _pV)	\
{												\
	BBPCSR_STRUC	BbpCsr;						\
	BbpCsr.word = 0;							\
	BbpCsr.field.WriteControl = 0;				\
	BbpCsr.field.Busy = 1;						\
	BbpCsr.field.RegNum = _I;					\
	RTMP_BBP_IO_READ32(_A, &BbpCsr.word);		\
	*(_pV) = (UCHAR) BbpCsr.field.Value;        \
}
// Write BBP register by register's ID & value
#define	RTMP_BBP_IO_WRITE32_BY_REG_ID(_A, _I, _V)	\
{												\
	BBPCSR_STRUC	BbpCsr;						\
	BbpCsr.word = 0;                            \
    BbpCsr.field.WriteControl = 1;				\
    BbpCsr.field.Busy = 1;						\
    BbpCsr.field.Value = _V;					\
    BbpCsr.field.RegNum = _I;					\
    RTMP_BBP_IO_WRITE32(_A, BbpCsr.word);		\
    (_A)->PortCfg.BbpWriteLatch[_I] = _V;       \
}


//
//  Some utility macros
//
#ifndef min
#define min(_a, _b)     (((_a) < (_b)) ? (_a) : (_b))
#endif

#ifndef max
#define max(_a, _b)     (((_a) > (_b)) ? (_a) : (_b))
#endif

#define	INC_COUNTER(Val)	(Val++)

//#define	INFRA_ON(_p)		        (((_p)->PortCfg.Massoc) == TRUE)	// Check Massoc
//#define   ADHOC_ON(_p)                (((_p)->PortCfg.Mibss) == TRUE)    // check Mibss

#define	RTMP_SET_PACKET_FRAGMENTS(_p, number)	((_p)->cb[10] = number)
#define RTMP_GET_PACKET_FRAGMENTS(_p)			((_p)->cb[10])
#define	RTMP_SET_PACKET_RTS(_p, number)			((_p)->cb[11] = number)
#define RTMP_GET_PACKET_RTS(_p)					((_p)->cb[11])
#define RTMP_SET_PACKET_SOURCE(_p, pktsrc)      ((_p)->cb[12] = pktsrc)
#define RTMP_GET_PACKET_SOURCE(_p)              ((_p)->cb[12])
#define RTMP_SET_PACKET_TXRATE(_p, rate)        ((_p)->cb[13] = rate)
#define RTMP_GET_PACKET_TXRATE(_p)              ((_p)->cb[13])
#ifdef WDS
#define RTMP_SET_PACKET_NET_DEVICE(_p, idx)    	((_p)->cb[14] = (idx + 0x10))
#define RTMP_GET_PACKET_NET_DEVICE(_p)			((_p)->cb[14])
#endif

#define	MAKE_802_3_HEADER(_p, _pMac1, _pMac2, _pType)								\
{																					\
	NdisMoveMemory(_p, _pMac1, ETH_LENGTH_OF_ADDRESS);								\
	NdisMoveMemory((_p + ETH_LENGTH_OF_ADDRESS), _pMac2, ETH_LENGTH_OF_ADDRESS);	\
	NdisMoveMemory((_p + ETH_LENGTH_OF_ADDRESS * 2), _pType, LENGTH_802_3_TYPE);	\
}

// upon TX complete, this value decide to return the NDIS_PACKET to NDIS wraper
// or release directly.
//  PKTSRC_UNKNOWN - should never happen
//  PKTSRC_NDIS - this packet is sent by NDIS, driver should indicate TX status to NDIS layer
//  PKTSRC_BRG - this packet is allocated internally for wireless bridging, and should be released within miniport driver
typedef enum {PKTSRC_UNKNOWN, PKTSRC_INTERNAL, PKTSRC_NDIS} PKT_SRC;

//
// Register set pair for initialzation register set definition
//
typedef	struct	_RTMP_REG_PAIR
{
	ULONG	Register;
	ULONG	Value;
}	RTMP_REG_PAIR, *PRTMP_REG_PAIR;

//
// Register set pair for initialzation register set definition
//
typedef struct _RTMP_RF_REGS
{
    UCHAR   Channel;
    ULONG   R1;
    ULONG   R2;
    ULONG   R3;
    ULONG   R4;
}   RTMP_RF_REGS, *PRTMP_RF_REGS;

//
//  Statistic counter structure
//
typedef struct _COUNTER_802_3
{
    // General Stats
	ULONG		GoodTransmits;
	ULONG		GoodReceives;
	ULONG		TxErrors;
	ULONG		RxErrors;
	ULONG		RxNoBuffer;

    // Ethernet Stats
	ULONG		RcvAlignmentErrors;
	ULONG		OneCollision;
	ULONG		MoreCollisions;

}   COUNTER_802_3, *PCOUNTER_802_3;

typedef struct _COUNTER_802_11 {
    ULONG           Length;
    LARGE_INTEGER   TransmittedFragmentCount;
    LARGE_INTEGER   MulticastTransmittedFrameCount;
    LARGE_INTEGER   FailedCount;
    LARGE_INTEGER   RetryCount;
    LARGE_INTEGER   MultipleRetryCount;
    LARGE_INTEGER   RTSSuccessCount;
    LARGE_INTEGER   RTSFailureCount;
    LARGE_INTEGER   ACKFailureCount;
    LARGE_INTEGER   FrameDuplicateCount;
    LARGE_INTEGER   ReceivedFragmentCount;
    LARGE_INTEGER   MulticastReceivedFrameCount;
    LARGE_INTEGER   FCSErrorCount;
} COUNTER_802_11, *PCOUNTER_802_11;

typedef struct _COUNTER_RALINK {
    ULONG           TransmittedByteCount;   // both successful and failure, used to calculate TX throughput
    ULONG           ReceivedByteCount;      // both CRC okay and CRC error, used to calculate RX throughput
    ULONG           BeenDisassociatedCount;
    ULONG           BadCQIAutoRecoveryCount;
    ULONG           PoorCQIRoamingCount;
    ULONG           MgmtRingFullCount;
    ULONG           RxCount;
    ULONG           DecryptCount;
    ULONG           RxRingErrCount;
    ULONG           EncryptCount;
    ULONG           KickTxCount;
    ULONG           TxRingErrCount;	
} COUNTER_RALINK, *PCOUNTER_RALINK;

//
//  Arcfour Structure Added by PaulWu
//
typedef struct PACKED _ARCFOUR
{
	UINT			X;
	UINT			Y;
	UCHAR			STATE[256];
}   ARCFOURCONTEXT, *PARCFOURCONTEXT;

// Shared key data structure
typedef	struct	_WEP_KEY {
	UCHAR	KeyLen;						// Key length for each key, 0: entry is invalid
	UCHAR	Key[MAX_LEN_OF_KEY];		// right now we implement 4 keys, 128 bits max
}	WEP_KEY, *PWEP_KEY;

// Shared key data structure
typedef	struct	_WPA_KEY {
	UCHAR	KeyLen;				// Key length for each key, 0: entry is invalid
	UCHAR	Key[16];			// right now we implement 4 keys, 128 bits max
	UCHAR	RxMic[8];
	UCHAR	TxMic[8];
	NDIS_802_11_MAC_ADDRESS	BssId;	// For pairwise key only
	UCHAR	TxTsc[6];			// 48bit TSC value
	UCHAR	RxTsc[6];			// 48bit TSC value
}	WPA_KEY, *PWPA_KEY;

// configuration to be used when this STA starts a new ADHOC network
typedef struct _IBSS_CONFIG {
    USHORT    BeaconPeriod;
    USHORT    AtimWin;
    UCHAR     Channel;
    UCHAR     SupportedRates[MAX_LEN_OF_SUPPORTED_RATES];    // Supported rates
    UCHAR     SupportedRatesLen;
}   IBSS_CONFIG, *PIBSS_CONFIG;

typedef struct _LED_CONTROL {
    BOOLEAN				fOdd;
    BOOLEAN				fRxActivity;
    struct timer_list	BlinkTimer; // 50 ms periodic timer
    ULONG				LastLedCsr;
}   LED_CONTROL;

// structure to define WPA Group Key Rekey Interval
typedef struct _RT_802_11_WPA_REKEY {
    ULONG ReKeyMethod;          // mechanism for rekeying: 0:disable, 1: time-based, 2: packet-based
    ULONG ReKeyInterval;        // time-based: seconds, packet-based: kilo-packets
} RT_WPA_REKEY,*PRT_WPA_REKEY,RT_802_11_WPA_REKEY, *PRT_802_11_WPA_REKEY;

#ifdef WDS
typedef struct _RT_802_11_WDS_ENTRY {
    UCHAR	   				WdsAddr[ETH_LENGTH_OF_ADDRESS];
    struct net_device		*dev;
    UCHAR           		MaxSupportedRate;
    UCHAR           		CurrTxRate;
    USHORT          		TxQuality[MAX_LEN_OF_SUPPORTED_RATES];
    USHORT          		OneSecTxOkCount;
    USHORT          		OneSecTxRetryOkCount;
    USHORT          		OneSecTxFailCount;
    ULONG                   CurrTxRateStableTime; // # of second in current TX rate
    UCHAR                   TxRateUpPenalty;      // extra # of second penalty due to last unstable condition
} RT_802_11_WDS_ENTRY, PRT_802_11_WDS_ENTRY;

typedef struct _RT_802_11_WDS_TABLE {
	ULONG					Num;
	WPA_KEY					Wpa_key;
    RT_802_11_WDS_ENTRY	   	WdsEntry[MAX_WDS_ENTRY];
} RT_802_11_WDS_TABLE, PRT_802_11_WDS_TABLE;

typedef struct _WDS_ADAPTER
{
	struct net_device		*RtmpDev;
	struct net_device		*WdsDev;
} WDS_ADAPTER, PWDS_ADAPTER;
#endif

#define MAC_TABLE_FULL(Tab) ((Tab).size == MAX_LEN_OF_MAC_TABLE)

typedef struct _MAC_TABLE_ENTRY {
    BOOLEAN         Valid;
    //jan for wpa
    BOOLEAN         RetryTimerRunning;  
    // record which entry revoke MIC Failure , if it leaves the BSS itself, AP won't update aMICFailTime MIB
    UCHAR           CMTimerRunning;
    UCHAR           RSNIE_Len;
    UCHAR           RSN_IE[MAX_LEN_OF_RSNIE];
    UCHAR           ANonce[32];
    UCHAR           Flag;   
    UCHAR           R_Counter[LEN_KEY_DESC_REPLAY];
    UCHAR           PTK[64];
    UCHAR           ReTryCounter;   
    struct timer_list                 RetryTimer;
    NDIS_802_11_AUTHENTICATION_MODE     AuthMode;   // This should match to whatever microsoft defined
    NDIS_802_11_WEP_STATUS              WepStatus;
    WPA_STATE       WpaState;
    GTK_STATE       GTKState;
    USHORT          PortSecured;
    NDIS_802_11_PRIVACY_FILTER  PrivacyFilter;      // PrivacyFilter enum for 802.1X
    WPA_KEY         PairwiseKey[PAIRWISE_KEY_NO];
    
    MACADDR         Addr;
    UCHAR           PsMode;
    SST             Sst;
    AUTH_STATE      AuthState; // for SHARED KEY authentication state machine used only
    USHORT          Aid;
    USHORT          CapabilityInfo;
    UCHAR           MaxSupportedRate;
    UCHAR           CurrTxRate;
    UCHAR           LastRssi;
    ULONG           NoDataIdleCount;
    ULONG           PsQIdleCount;
    QUEUE_HEADER    PsQueue;
    struct _MAC_TABLE_ENTRY *pNext;

    // to record the each TX rate's quality. 0 is best, the bigger the worse.
    USHORT          TxQuality[MAX_LEN_OF_SUPPORTED_RATES];
    USHORT          OneSecTxOkCount;
    USHORT          OneSecTxRetryOkCount;
    USHORT          OneSecTxFailCount;

    ULONG           CurrTxRateStableTime; // # of second in current TX rate
    UCHAR           TxRateUpPenalty;      // extra # of second penalty due to last unstable condition
} MAC_TABLE_ENTRY, *PMAC_TABLE_ENTRY;

typedef struct _MAC_TABLE {
    UCHAR           Size;
    MAC_TABLE_ENTRY *Hash[HASH_TABLE_SIZE];
    MAC_TABLE_ENTRY Content[MAX_LEN_OF_MAC_TABLE];
    QUEUE_HEADER    McastPsQueue;
    ULONG           PsQIdleCount;
    BOOLEAN         fAnyStationInPsm;   // TRUE, then outgoing BCAST/MCAST frame should 
                                        // be put into McastPsQueue until DtimCount=0
} MAC_TABLE, *PMAC_TABLE;

typedef struct _SOFT_RX_ANT_DIVERSITY_STRUCT {
    BOOLEAN   PrimaryInUsed;
    UCHAR     PrimaryRxAnt;     // 0:Ant-A, 1:Ant-B
    UCHAR     SecondaryRxAnt;   // 0:Ant-A, 1:Ant-B
    USHORT    AvgRssi[2];       // AvgRssi[0]:Ant-A, AvgRssi[1]:Ant-B
    struct timer_list    RxAntDiversityTimer;
} SOFT_RX_ANT_DIVERSITY, *PSOFT_RX_ANT_DIVERSITY;

// PortConfig
typedef struct _PORT_CONFIG {
    // MIB:ieee802dot11.dot11smt(1).dot11StationConfigTable(1)
    USHORT    CapabilityInfo;
    USHORT    BeaconPeriod;         // in units of TU

	NDIS_802_11_AUTHENTICATION_MODE		AuthMode;	// This should match to whatever microsoft defined
	NDIS_802_11_WEP_STATUS				WepStatus;
    ULONG        ApdPid;
    // MIB:ieee802dot11.dot11smt(1).dot11WEPDefaultKeysTable(3)
    WEP_KEY         SharedKey[SHARE_KEY_NO];      // Keep for backward compatiable
    WPA_KEY         GroupKey[GROUP_KEY_NO];
    
    // for wpa
    UCHAR           R_Counter[LEN_KEY_DESC_REPLAY];
    UCHAR           GMK[32];
    UCHAR           PMK[32];
    UCHAR           GNonce[32];
    UCHAR           PortSecured;  // WPA 802.1x port control, WPA_802_1X_PORT_SECURED, WPA_802_1X_PORT_NOT_SECURED
    WPA_GTK_STATE   WpaGTKState;
    struct timer_list         CounterMeasureTimer;
    ULONG           MICErrorCounter;
    NDIS_802_11_PRIVACY_FILTER  PrivacyFilter;      // PrivacyFilter enum for 802.1X
    UCHAR           GKeyDoneStations; // number of entry left to update group key
    UCHAR           WPAGKeyID;
    // MIB:ieee802dot11.dot11smt(1).dot11WEPKeyMappingsTable(4)
    // not implemented yet

    UCHAR           CMTimerRunning;
    UCHAR           BANClass3Data;
    LARGE_INTEGER   aMICFailTime;
    LARGE_INTEGER   PrevaMICFailTime;
    ULONG           MICFailureCounter;
    // for Group Rekey 
    RT_WPA_REKEY    WPAREKEY;
    ULONG           REKEYCOUNTER;
    struct timer_list     REKEYTimer;
    UCHAR           REKEYTimerRunning;
        
    // MIB:ieee802dot11.dot11smt(1).dot11PrivacyTable(5)
    // 2 counters dot11WEPICVErrorCount and dot11WEPExcludedCount put in g_portsts
    UCHAR     DefaultKeyId;

    // MIB:ieee802dot11.dot11mac(2).dot11OperationTable(1)
    USHORT    RtsThreshold;       // in units of BYTE
    USHORT    FragmentThreshold;
    BOOLEAN   bFragmentZeroDisable;		// Microsoft use 0 as disable 
    
    // MIB:ieee802dot11.dot11phy(4).dot11PhyAntennaTable(2)
    UCHAR     CurrentTxAntenna;
    UCHAR     CurrentRxAntenna;
    UCHAR     NumberOfAntenna;

    // MIB:ieee802dot11.dot11phy(4).dot11PhyTxPowerTable(3)
    UCHAR     TxPower;      // in mW
    UCHAR     TxRate;       // RATE_1, RATE_2, RATE_5_5, RATE_11, ...
    BOOLEAN   EnableAutoRateSwitching;  // 1 - enable auto rate switching; 0 - disable
    ULONG     TxPowerPercentage;        // 0~100%
    
    // MIB:ieee802dot11.dot11phy(4).dot11PhyDSSSTable(5)
    UCHAR     Channel;        // current (I)BSS channel used in the station
    UCHAR     CountryRegion;	// Enum of country region, 0:FCC, 1:IC, 2:ETSI, 3:SPAIN, 4:France, 5:MKK, 6:MKK1, 7:Israel
    
	// Use user changed MAC
    BOOLEAN bLocalAdminMAC;                           
    
    // MIB:ieee802dot11.dot11phy(4).dot11SupportedDataRatesTxTable(9)
    // MIB:ieee802dot11.dot11phy(4).dot11SupportedDataRatesRxTable(10)
    UCHAR     SupportedRates[MAX_LEN_OF_SUPPORTED_RATES];    // Supported rates
    UCHAR     SupportedRatesLen;
    UCHAR     ExpectedACKRate[MAX_LEN_OF_SUPPORTED_RATES];

    //
    // other parameters not defined in standard MIB
    //
    UCHAR     DesiredRates[MAX_LEN_OF_SUPPORTED_RATES];      // OID_802_11_DESIRED_RATES
    MACADDR   Bssid;
    MACADDR   Broadcast;            // FF:FF:FF:FF:FF:FF
    UCHAR     LastRssi;             // last received BEACON's RSSI
    USHORT    AvgRssi;
    ULONG     NumOfAvgRssiSample;
    UCHAR     MlmeRate;
    UCHAR     RtsRate;
    UCHAR     MaxTxRate;            // RATE_1, RATE_2, RATE_5_5, RATE_11
    UCHAR     SsidLen;               // the actual ssid length in used
    CHAR      Ssid[MAX_LEN_OF_SSID]; // NOT NULL-terminated

    // PHY specification
    UCHAR     PhyMode;    // PHY_11A, PHY_11B, PHY_11BG_MIXED, PHY_ABG_MIXED
    USHORT    Dsifs;      // in units of usec
    USHORT    TxPreamble; // Rt802_11PreambleLong, Rt802_11PreambleShort

    ULONG     WindowsPowerMode;			// Power mode for AC power
    ULONG     WindowsBatteryPowerMode;	// Power mode for battery if exists
    BOOLEAN   WindowsACCAMEnable;		// Enable CAM power mode when AC on
    ULONG     PacketFilter;				// Packet filter for receiving

    UCHAR	ChannelTxPower[MAX_LEN_OF_CHANNELS];		// Store Tx power value for all channels.

    LED_CONTROL					LedCntl;
    UCHAR						RfType;
    UCHAR						LedMode;
    struct timer_list			RfTuningTimer;

	// New for WPA, windows want us to to keep association information and
	// Fixed IEs from last association response
	NDIS_802_11_ASSOCIATION_INFORMATION		AssocInfo;
//	NDIS_802_11_FIXED_IEs					FixIEs;
	UCHAR					ReqVarIELen;				// Length of next VIE include EID & Length
	UCHAR					ReqVarIEs[MAX_VIE_LEN];
	UCHAR					ResVarIELen;				// Length of next VIE include EID & Length
	UCHAR					ResVarIEs[MAX_VIE_LEN];

    ULONG                   EnableTurboRate;      // 1: enable 72/100 Mbps whenever applicable, 0: never use 72/100 Mbps
    ULONG                   EnableTxBurst;        // 1: enble TX PACKET BURST, 0: disable TX PACKET BURST
    ULONG                   IsolateInterStaTraffic;
    ULONG                   HideSsid;
    ULONG                   UseBGProtection;      // 0:AUTO, 1-always ON,2-always OFF
    ULONG                   UseShortSlotTime;     // 0: disable, 1 - use short slot (9us)

    RT_802_11_ACL           AccessControlList;
    UCHAR                   RSNIE_Len;
    UCHAR                   RSN_IE[MAX_LEN_OF_RSNIE];
        
    UCHAR                   Key_Counter[32];  //jan for wpa

    // latch th latest RF programming value here since RF IC doesn't support READ operation
    RTMP_RF_REGS            LatchRfRegs;
    
    BOOLEAN                       BbpTuningEnable;
    UCHAR                         VgcLowerBound;
    RT_802_11_RX_AGC_VGC_TUNING   BbpTuning;
    UCHAR                         LastR17Value;

    ULONG                         SystemErrorBitmap;  // b0: E2PROM version error

	// This soft Rx Antenna Diversity mechanism is used only when user set 
    // RX Antenna = DIVERSITY ON
    SOFT_RX_ANT_DIVERSITY         RxAnt;

    ULONG                   Rt2560Version;        // 2560 MAC/BBP serial interface bug solved after version D
    UCHAR                   AutoChannelAtBootup;  // 0: disable, 1: enable
    ULONG                   EepromVersion;        // byte 0: version, byte 1: revision, byte 2~3: unused
    UCHAR                   BbpWriteLatch[100];   // record last BBP register value written via BBP_IO_WRITE

    // temporary latch for Auto channel selection
    UCHAR                   AutoChannel_MaxRssi;  // max RSSI during Auto Channel Selection period
    UCHAR                   AutoChannel_Channel;  // channel number during Auto Channel Selection
} PORT_CONFIG, *PPORT_CONFIG;

typedef struct _MLME_STRUCT {
	STATE_MACHINE           CntlMachine, AssocMachine, AuthMachine, AuthRspMachine, SyncMachine, WpaMachine;
    STATE_MACHINE_FUNC      CntlFunc[CNTL_FUNC_SIZE], AssocFunc[ASSOC_FUNC_SIZE];
    STATE_MACHINE_FUNC      AuthFunc[AUTH_FUNC_SIZE], AuthRspFunc[AUTH_RSP_FUNC_SIZE];
    STATE_MACHINE_FUNC      SyncFunc[SYNC_FUNC_SIZE], WpaFunc[WPA_FUNC_SIZE];
    
    AUTH_RSP_AUX            AuthRspAux;
    
    COUNTER_802_11          PrevWlanCounters;
    ULONG                   ChannelQuality;  // 0..100, Channel Quality Indication for Roaming
//  ULONG                   DrsCqi;   // 0..100, Channel Quality Indication for Dynamic Rate Switching
    ULONG                   TxPER;    // 0..100 %
    ULONG                   RxPER;    // 0..100 %
    ULONG                   Now32;    // latch the value of NdisGetSystemUpTime()

    BOOLEAN                 Running;
    spinlock_t				TaskLock;
    MLME_QUEUE              Queue;

    UINT                    ShiftReg;
//  PSPOLL_FRAME            PsFr;
    
    struct timer_list		PeriodicTimer;
	ULONG                   PeriodicRound;

    UCHAR       TimIELocationInBeacon;
    UCHAR       CapabilityInfoLocationInBeacon;
    ULONG       TimBitmap;      // bit0 for broadcast, 1 for AID1, 2 for AID2, ...so on
    UCHAR       DtimCount;      // 0.. DtimPeriod-1
    UCHAR       DtimPeriod;     // default = 3

    UCHAR       ErpIeContent;
    ULONG       LastOLBCDetectTime;
} MLME_STRUCT, *PMLME_STRUCT;

//
// Management ring buffer format
//
typedef	struct	_MGMT_STRUC	{
	BOOLEAN		Valid;
	PUCHAR		pBuffer;
	ULONG		Length;
}	MGMT_STRUC, *PMGMT_STRUC;

//
// P802.11 Frame control field, 16 bit
//
typedef	struct	PACKED _FRAME_CONTROL	{
#ifdef	BIG_ENDIAN
	USHORT		Order:1;
	USHORT		Wep:1;
	USHORT		MoreData:1;
	USHORT		PwrMgt:1;
	USHORT		Retry:1;
	USHORT		MoreFrag:1;
	USHORT		FrDs:1;
	USHORT		ToDs:1;
	USHORT		Subtype:4;
	USHORT		Type:2;
	USHORT		Ver:2;
#else
	USHORT		Ver:2;				// Protocol version
	USHORT		Type:2;				// MSDU type
	USHORT		Subtype:4;			// MSDU subtype
	USHORT		ToDs:1;				// To DS indication
	USHORT		FrDs:1;				// From DS indication
	USHORT		MoreFrag:1;			// More fragment bit
	USHORT		Retry:1;			// Retry status bit
	USHORT		PwrMgt:1;			// Power management bit
	USHORT		MoreData:1;			// More data bit
	USHORT		Wep:1;				// Wep data
	USHORT		Order:1;			// Strict order expected
#endif

}	FRAME_CONTROL, *PFRAME_CONTROL;

//
// P802.11 intermediate header format
//
typedef	struct	PACKED _CONTROL_HEADER	{
	FRAME_CONTROL	Frame;				// Frame control structure
	USHORT			Duration;			// Duration value
	MACADDR			Addr1;				// Address 1 field
	MACADDR			Addr2;				// Address 2 field
}	CONTROL_HEADER, *PCONTROL_HEADER;

//
// P802.11 header format
//
typedef	struct	PACKED _HEADER_802_11	{
	CONTROL_HEADER	Controlhead;
	MACADDR			Addr3;				// Address 3 field
#ifdef BIG_ENDIAN
	USHORT			Sequence:12;		// Sequence number
	USHORT			Frag:4;				// Fragment number
#else
	USHORT			Frag:4;				// Fragment number
	USHORT			Sequence:12;		// Sequence number
#endif
}	HEADER_802_11, *PHEADER_802_11;

//
// Receive Tuple Cache Format
//
typedef	struct	PACKED _TUPLE_CACHE	{
	BOOLEAN			Valid;
	MACADDR			MAC;
	USHORT			Sequence; 
	USHORT			Frag;
}	TUPLE_CACHE, *PTUPLE_CACHE;

//
// Fragment Frame structure
//
typedef	struct	PACKED _FRAGMENT_FRAME	{
	UCHAR		Header802_3[14];
	UCHAR		Header_LLC[8];
	UCHAR		Buffer[MAX_FRAME_SIZE];
	ULONG		RxSize;
	USHORT		Sequence;
	USHORT		LastFrag;
	ULONG		Flags;			// Some extra frame information. bit 0: LLC presented
}	FRAGMENT_FRAME, *PFRAGMENT_FRAME;

//
// Tkip Key structure which RC4 key & MIC calculation
//
typedef	struct	PACKED _TKIP_KEY_INFO	{
	UINT		nBytesInM;	// # bytes in M for MICKEY
	ULONG		IV16;
	ULONG		IV32;	
	ULONG		K0;			// for MICKEY Low
	ULONG		K1;			// for MICKEY Hig
	ULONG		L;			// Current state for MICKEY
	ULONG		R;			// Current state for MICKEY
	ULONG		M;			// Message accumulator for MICKEY
	UCHAR		RC4KEY[16];
	UCHAR		MIC[8];
}	TKIP_KEY_INFO, *PTKIP_KEY_INFO;

//
// Expanded IV for TKIP function.
//
#if 0
typedef	struct	_IV_CONTROL_
{
	union
	{
		struct 
		{
			UCHAR		rc0;
			UCHAR		rc1;
			UCHAR		rc2;

			union
			{
				struct
				{
#ifdef BIG_ENDIAN
					UCHAR	KeyID:2;
					UCHAR	ExtIV:1;
					UCHAR	Rsvd:5;
#else
					UCHAR	Rsvd:5;
					UCHAR	ExtIV:1;
					UCHAR	KeyID:2;
#endif
				}	field;
				UCHAR		Byte;
			}	CONTROL;
		}	field;
		
		ULONG	word;
	}	IV16;
	
	ULONG	IV32;
}	TKIP_IV, *PTKIP_IV;
#else
typedef	struct	_IV_CONTROL_
{
	union
	{
		struct 
		{
		#ifdef BIG_ENDIAN
			union
			{
				struct  
				{
					UCHAR KeyID:2;
					UCHAR ExtIV:1;
					UCHAR Rsvd:5;
				} field;
				UCHAR		Byte;
			} CONTROL;
			UCHAR		rc2;
			UCHAR		rc1;
			UCHAR		rc0;
		#else
			UCHAR		rc0;
			UCHAR		rc1;
			UCHAR		rc2;
			union
			{
				struct
				{
					UCHAR	Rsvd:5;
					UCHAR	ExtIV:1;
					UCHAR	KeyID:2;
				}	field;
				UCHAR		Byte;
			}	CONTROL;
		#endif
		}	field;
		
		ULONG	word;
	}	IV16;
	
	ULONG	IV32;
}	TKIP_IV, *PTKIP_IV;
#endif
//
// Private / Misc data, counters for driver internal use
//
typedef	struct	__PRIVATE_STRUC	{
	ULONG		SystemResetCnt;			// System reset counter
	ULONG		TxRingFullCnt;			// Tx ring full occurrance number
	ULONG		ResetCountDown;			// Count down before issue reset, patch for RT2430
	ULONG		CCAErrCnt;				// CCA error count, for debug purpose, might move to global counter
	ULONG		PhyRxErrCnt;			// PHY Rx error count, for debug purpose, might move to global counter
	ULONG		PhyTxErrCnt;			// PHY Tx error count, for debug purpose, might move to global counter
	// Variables for WEP encryption / decryption in rtmp_wep.c
	ULONG			FCSCRC32;
	ULONG			RxSetCnt;
	ULONG			DecryptCnt;
	ARCFOURCONTEXT	WEPCONTEXT;
	// Tkip stuff
	TKIP_KEY_INFO	Tx;
	TKIP_KEY_INFO	Rx;
}	PRIVATE_STRUC, *PPRIVATE_STRUC;

//
//	All DMA ring formats
//
struct ring_desc {
	// Descriptor size & dma address
	u32			size;
	void		*va_addr;
	dma_addr_t	pa_addr;
	// Dma buffer size and address for real transfer
	u32			data_size;
	void		*va_data_addr;
	dma_addr_t	pa_data_addr;
    UCHAR		FrameType;			// Type of frame in ring buffer
};

#ifdef RALINK_ATE
typedef	struct _ATE_INFO {
	UCHAR	Mode;
	UCHAR	TxPower;
	UCHAR	Addr1[6];
	UCHAR	Addr2[6];
	UCHAR	Addr3[6];
	ULONG	TxLength;
	ULONG	TxCount;
	ULONG	TxDoneCount;
	ULONG	TxRate;
}	ATE_INFO, *PATE_INFO;
#endif	//#ifdef RALINK_ATE

//
//  The miniport adapter structure
//
typedef struct _RTMP_ADAPTER
{
	// configuration
	CHAR					nickn[IW_ESSID_MAX_SIZE+1];      // nickname, only used in the iwconfig i/f
	INT						chip_id;
    ULONG                   CSRBaseAddress;     // PCI MMIO Base Address, all access will use

    UCHAR                   PermanentAddress[ETH_LENGTH_OF_ADDRESS];    // Factory default MAC address
    UCHAR                   CurrentAddress[ETH_LENGTH_OF_ADDRESS];      // User changed MAC address

    UCHAR					EEPROMAddressNum;		// 93c46=6	93c66=8
    USHORT					EEPROMDefaultValue[NUM_EEPROM_BBP_PARMS];

    // resource for DMA operation
    struct ring_desc		TxRing[TX_RING_SIZE];       // Tx Ring
    struct ring_desc		AtimRing[ATIM_RING_SIZE];   // Atim Ring
    struct ring_desc		PrioRing[PRIO_RING_SIZE];   // Priority Ring
    struct ring_desc		RxRing[RX_RING_SIZE];       // Rx Ring
    struct ring_desc		BeaconRing;       			// Beacon Ring, only one

    MGMT_STRUC				MgmtRing[MGMT_RING_SIZE];	// management ring size
	
    ULONG					CurRxIndex;					// Next RxD read pointer
	ULONG					CurDecryptIndex;			// Next RxD decrypt read pointer
	ULONG					CurTxIndex;					// Next TxD write pointer
	ULONG					CurEncryptIndex;			// Next TxD encrypt write pointer
	ULONG					CurAtimIndex;				// Next AtimD write pointer
	ULONG					CurPrioIndex;				// Next PrioD write pointer
	ULONG					PushMgmtIndex;				// Next SW management ring index
	ULONG					PopMgmtIndex;				// Next SW management ring index
	ULONG					MgmtQueueSize;				// Number of Mgmt request stored in MgmtRing
	ULONG					NextEncryptDoneIndex;
	ULONG					NextTxDoneIndex;
	ULONG					NextAtimDoneIndex;
	ULONG					NextPrioDoneIndex;
	ULONG					NextDecryptDoneIndex;

    // 802.3 multicast support
    ULONG					NumberOfMcAddresses;		// Number of mcast entry exists
    UCHAR					McastTable[MAX_MCAST_LIST_SIZE][ETH_LENGTH_OF_ADDRESS];		// Mcast list
   //flags
    ULONG					Flags;                      // Represent current device status

    // SEND queue list
    QUEUE_HEADER            TxSwQueue0;
    QUEUE_HEADER            TxSwQueue1;
    QUEUE_HEADER            TxSwQueue2;
    QUEUE_HEADER            TxSwQueue3;

	USHORT					Sequence;					// Current sequence number

	TUPLE_CACHE				TupleCache[MAX_CLIENT];		// Maximum number of tuple caches, only useful in Ad-Hoc
	UCHAR                   TupleCacheLastUpdateIndex;  // 0..MAX_CLIENT-1
	FRAGMENT_FRAME			FragFrame;					// Frame storage for fragment frame
	
	// For MiniportTransferData
	PUCHAR					pRxData;					// Pointer to current RxRing offset / fragment frame offset
	
    // Counters for 802.3 & generic.
    // Add 802.11 specific counters later
    COUNTER_802_3           Counters;                   // 802.3 counters
    COUNTER_802_11          WlanCounters;				// 802.11 MIB counters
    COUNTER_RALINK          RalinkCounters;				// Ralink propriety counters

	PRIVATE_STRUC			PrivateInfo;				// Private information & counters

    // SpinLocks
	spinlock_t				TxRingLock;					// Tx Ring spinlock
	spinlock_t				PrioRingLock;				// Prio Ring spinlock
	spinlock_t				AtimRingLock;				// Atim Ring spinlock
	spinlock_t				RxRingLock;					// Rx Ring spinlock
	spinlock_t				TxSwQueueLock;				// TxSwQueueLock spinlock

// Boolean control for packet filter
	BOOLEAN					bAcceptDirect;
	BOOLEAN					bAcceptMulticast;
	BOOLEAN					bAcceptBroadcast;
	BOOLEAN					bAcceptAllMulticast;
	
	BOOLEAN					bRaConfig;
	BOOLEAN					bTxBusy;

    PORT_CONFIG             PortCfg;
    MLME_STRUCT             Mlme;

	MAC_TABLE               MacTab;
	spinlock_t              MacTabLock;
	
    RT_802_11_EVENT_TABLE   EventTab;

    struct pci_dev			*pPci_Dev;
    struct net_device		*net_dev;

    struct timer_list		timer;	// Periodic Media monitoring timer.
    
#if WIRELESS_EXT >= 12
	struct iw_statistics iw_stats;
#endif
	struct net_device_stats stats;
	
#ifdef WDS
	RT_802_11_WDS_TABLE		WdsTab;
#endif

#ifdef RALINK_ATE
	ATE_INFO				ate;
#endif	//#ifdef RALINK_ATE
}   RTMP_ADAPTER, *PRTMP_ADAPTER;

//
// Enable & Disable NIC interrupt via writing interrupt mask register
// Since it use ADAPTER structure, it have to be put after structure definition.
//
inline	VOID    NICDisableInterrupt(
    IN  PRTMP_ADAPTER   pAdapter);

inline	VOID    NICEnableInterrupt(
    IN  PRTMP_ADAPTER   pAdapter);

BOOLEAN	NICCheckForHang(
	IN	PRTMP_ADAPTER	pAd);


INT		RT2500_close(
	IN	struct net_device *net_dev);

VOID    RTMPIsr(
    IN	INT				irq, 
	IN	VOID			*dev_instance, 
	IN	struct pt_regs	*rgs);

VOID	RT2500_timer(
	IN	unsigned long data);

INT		RT2500_open(
	IN	struct net_device *net_dev);

INT	RTMPSendPackets(
	IN	struct sk_buff *skb, 
	IN	struct net_device *net_dev);

#ifdef WDS
INT	Wds_open(
	IN	struct net_device *dev);

INT	Wds_close(
	IN	struct net_device *dev);

INT Wds_ioctl(
	IN	struct net_device   *net_dev,
	IN	struct ifreq        *rq, 
	IN	INT                 cmd);

INT	WdsSendPackets(
	IN	struct sk_buff      *skb, 
	IN	struct net_device   *net_dev);
#endif

INT		RT2500_probe(
	IN	struct pci_dev              *pPci_Dev, 
	IN	const struct pci_device_id  *ent);

#if WIRELESS_EXT >= 12
struct iw_statistics *RT2500_get_wireless_stats(
	IN	struct net_device *net_dev);
#endif

struct net_device_stats *RT2500_get_ether_stats(
	IN	struct net_device *net_dev);

VOID	RT2500_set_rx_mode(
	IN	struct net_device *net_dev);

NDIS_STATUS RTMPAllocDMAMemory(
    IN  PRTMP_ADAPTER   pAd);

VOID	RTMPFreeDMAMemory(
	IN  PRTMP_ADAPTER   pAd);

VOID	NICReadEEPROMParameters(
    IN  PRTMP_ADAPTER       pAdapter);

VOID	NICInitAsicFromEEPROM(
	IN  PRTMP_ADAPTER       pAdapter);

VOID    NICInitTransmit(
    IN  PRTMP_ADAPTER   pAdapter);

NDIS_STATUS	NICReadAdapterInfo(
	IN	PRTMP_ADAPTER		pAdapter);

VOID	NICInitializeAdapter(
    IN  PRTMP_ADAPTER   pAdapter);

VOID	NICInitializeAsic(
	IN	PRTMP_ADAPTER	pAdapter);

VOID	NICIssueReset(
	IN	PRTMP_ADAPTER	pAdapter);

VOID	PortCfgInit(
	IN	PRTMP_ADAPTER	pAdapter);

VOID	NICResetFromError(
	IN	PRTMP_ADAPTER	pAdapter);

PUCHAR	RTMPFindSection(
	IN	PCHAR	buffer,
	IN	PCHAR	section);

	INT	RTMPIsFindSection(
	IN	PUCHAR	ptr,
	IN	PUCHAR	buffer);

INT RTMPGetKeyParameter(
	IN	PUCHAR	section,
	IN	PCHAR	key,
	OUT	PCHAR	dest,	
	IN	INT		destsize,
	IN	PCHAR	buffer);

VOID	RTMPReadParametersFromFile(
	IN	PRTMP_ADAPTER	pAd);
	
inline ULONG	RTMPEqualMemory(
	IN	PVOID	pSrc1,
	IN	PVOID	pSrc2,
	IN	ULONG	Length);

inline VOID	NdisZeroMemory(
	IN	PVOID	pSrc,
	IN	ULONG	Length);

inline VOID	NdisMoveMemory(
	OUT	PVOID	pDest,
	IN	PVOID	pSrc,
	IN	ULONG	Length);

void AtoH(char * src, UCHAR * dest, int destlen);
UCHAR BtoH(char ch);

//
// Private routines in rtmp_data.c
//
VOID	RTMPHandleRxDoneInterrupt(
	IN	PRTMP_ADAPTER	pAdapter);

VOID	RTMPHandleTxRingTxDoneInterrupt(
	IN	PRTMP_ADAPTER	pAdapter);

VOID	RTMPHandlePrioRingTxDoneInterrupt(
	IN	PRTMP_ADAPTER	pAdapter);

VOID	RTMPHandleAtimRingTxDoneInterrupt(
	IN	PRTMP_ADAPTER	pAdapter);

VOID	RTMPHandleTbcnInterrupt(
	IN	PRTMP_ADAPTER	pAdapter);

//VOID	RTMPHandleTwakeupInterrupt(
//	IN	PRTMP_ADAPTER	pAdapter);

VOID	RTMPHandleDecryptionDoneInterrupt(
	IN	PRTMP_ADAPTER	pAdapter);

VOID	RTMPHandleEncryptionDoneInterrupt(
	IN	PRTMP_ADAPTER	pAdapter);

VOID	RTMPHardTransmitDone(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PTXD_STRUC		pTxD,
	IN  PMACADDR        pAddr,
	IN	UCHAR			FrameType);

NDIS_STATUS	RTMPSendPacket(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	struct sk_buff *skb);
	
VOID	RTMPDeQueuePacket(
    IN	PRTMP_ADAPTER	pAdapter);

NDIS_STATUS	RTMPHardEncrypt(
    IN  PRTMP_ADAPTER   pAdapter,
    IN  struct sk_buff  *skb,
    IN  UCHAR           NumberRequired,
    IN  ULONG           EnableTxBurst,
    IN  UCHAR           AccessCategory);

NDIS_STATUS	RTMPHardTransmit(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	struct sk_buff  *skb,
	IN	UCHAR			NumberRequired);

NDIS_STATUS	RTMPFreeDescriptorRequest(
	IN		PRTMP_ADAPTER	pAdapter,
	IN		UCHAR			RingType,
	IN		UCHAR			NumberRequired);

VOID	MlmeHardTransmit(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PVOID			pBuffer,
	IN	ULONG			Length);

inline USHORT	RTMPCalcDuration(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	UCHAR			Rate,
	IN	ULONG			Size);

inline VOID	RTMPWriteTxDescriptor(
	IN	PTXD_STRUC	pSourceTxD,
	IN	BOOLEAN		DoEncrypt,
	IN	UCHAR		CipherAlg,
	IN	BOOLEAN		Ack,
	IN	BOOLEAN		Fragment,
    IN  BOOLEAN     InsTimestamp,
	IN	UCHAR		RetryMode,
	IN	UCHAR		Ifs,
	IN	UINT		Rate,
	IN	UCHAR		Service,
    IN  UINT        Length,
    IN  USHORT      TxPreamble,
    IN  UCHAR       AccessCategory);

BOOLEAN	RTMPSearchTupleCache(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PHEADER_802_11	pHeader);

VOID	RTMPUpdateTupleCache(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PHEADER_802_11	pHeader);

VOID    RTMPSuspendMsduTransmission(
   	IN	PRTMP_ADAPTER	pAdapter);

VOID    RTMPResumeMsduTransmission(
   	IN	PRTMP_ADAPTER	pAdapter);

NDIS_STATUS	MiniportMMRequest(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PVOID			pBuffer,
	IN	ULONG			Length);

NDIS_STATUS	RTMPCheckRxDescriptor(
	IN	PRXD_STRUC		pRxD);

NDIS_STATUS	RTMPApplyPacketFilter(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PRXD_STRUC		pRxD, 
	IN	PHEADER_802_11	pHeader);


NDIS_STATUS RTMPCheckDuplicateFrame(
   	IN	PRTMP_ADAPTER	pAdapter,
	IN  PHEADER_802_11	pHeader);

BOOLEAN RTMPCheckClass2Class3Error(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PHEADER_802_11	pHeader);

VOID RTMPHandleRxPsPoll(
   	IN	PRTMP_ADAPTER	pAdapter,
	IN  PMACADDR	    pAddr,
	IN  USHORT          Aid);

PQUEUE_HEADER	RTMPCheckTxSwQueue(
	IN	PRTMP_ADAPTER	pAdapter,
	OUT	ULONG			*Number,
	OUT UCHAR           *AccessCategory);

#ifdef BIG_ENDIAN
inline VOID	RTMPDescriptorEndianChange(
    IN  PUCHAR          pData_Dest,
	IN  PUCHAR			pData_Sou,
    IN  ULONG           DescriptorType);
	
inline VOID	RTMPFrameEndianChange(
	IN  PRTMP_ADAPTER   pAdapter,
	IN  PUCHAR          pData,
	IN  ULONG           Dir,
	IN  BOOLEAN         FromRxDoneInt);
#endif
//
// Private routines in rtmp_wep.c
//
VOID	RTMPInitWepEngine(
	IN	PRTMP_ADAPTER	pAdapter,	
	IN	PUCHAR			pKey,
	IN	UCHAR			KeyId,
	IN	UCHAR			KeyLen, 
	IN	PUCHAR			pDest);

VOID	RTMPEncryptData(
	IN	PRTMP_ADAPTER	pAdapter,	
	IN	PUCHAR			pSrc,
	IN	PUCHAR			pDest,
	IN	UINT			Len);

BOOLEAN	RTMPDecryptData(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			pSrc,
	IN	UINT			Len);

VOID	RTMPSetICV(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			pDest);

VOID	ARCFOUR_INIT(
	IN	PARCFOURCONTEXT	Ctx,
	IN	PUCHAR			pKey,
	IN	UINT			KeyLen);

UCHAR	ARCFOUR_BYTE(
	IN	PARCFOURCONTEXT Ctx);

VOID	ARCFOUR_DECRYPT(
	IN	PARCFOURCONTEXT	Ctx,
	IN	PUCHAR			pDest, 
	IN	PUCHAR			pSrc,
	IN	UINT			Len);

VOID	ARCFOUR_ENCRYPT(
	IN	PARCFOURCONTEXT	Ctx,
	IN	PUCHAR			pDest,
	IN	PUCHAR			pSrc,
	IN	UINT			Len);

VOID    WPAARCFOUR_ENCRYPT(
    IN  PARCFOURCONTEXT Ctx,
    IN  PUCHAR          pDest,
    IN  PUCHAR          pSrc,
    IN  UINT            Len);

ULONG	RTMP_CALC_FCS32(
	IN	ULONG	Fcs,
	IN	PUCHAR	Cp,
	IN	INT		Len);

//
// MLME routines
//

// Asic/RF/BBP related functions

VOID    AsicSwitchChannel(
    IN	PRTMP_ADAPTER	pAdapter, 
    IN  UCHAR           Channel);

VOID    AsicLockChannel(
    IN PRTMP_ADAPTER    pAd, 
    IN UCHAR            Channel) ;

VOID AsicRfTuningExec(
    IN unsigned long    data);

VOID AsicAdjustTxPower(
    IN PRTMP_ADAPTER pAd) ;

VOID    AsicSetBssid(
    IN	PRTMP_ADAPTER	pAdapter, 
    IN  MACADDR         *Bssid);

VOID    AsicDisableSync(
    IN	PRTMP_ADAPTER	pAdapter);

VOID    AsicEnableBssSync(
    IN	PRTMP_ADAPTER	pAdapter);

VOID    AsicLedPeriodicExec(
    IN unsigned long    data);

VOID AsicSetRxAnt(
    IN PRTMP_ADAPTER    pAd);

VOID AsicEvaluateSecondaryRxAnt(
    IN PRTMP_ADAPTER    pAd);

VOID AsicRxAntEvalTimeout(
    IN unsigned long    data);

VOID AsicSetSlotTime(
    IN PRTMP_ADAPTER    pAd,
    IN BOOLEAN          UseShortSlotTime);

VOID AsicBbpTuning(
    IN PRTMP_ADAPTER    pAd);

VOID    MgtMacHeaderInit(
    IN PRTMP_ADAPTER	pAdapter, 
    IN OUT PMACHDR      Hdr, 
    IN UCHAR            Subtype, 
    IN UCHAR            ToDs, 
    IN PMACADDR         Ds, 
    IN PMACADDR         Bssid);

NDIS_STATUS  MlmeQueueInit(
    IN MLME_QUEUE       *Queue);

VOID  MlmeQueueDestroy(
    IN MLME_QUEUE       *Queue);

BOOLEAN MlmeEnqueue(
    OUT MLME_QUEUE      *Queue, 
    IN ULONG            Machine, 
    IN ULONG            MsgType, 
    IN ULONG            MsgLen, 
    IN VOID             *Msg);

BOOLEAN MlmeEnqueueForRecv(
    IN	PRTMP_ADAPTER   pAdapter, 
    OUT MLME_QUEUE      *Queue, 
    IN UCHAR            Rssi, 
    IN ULONG            MsgLen, 
    IN PVOID            Msg);

BOOLEAN MlmeDequeue(
    IN MLME_QUEUE       *Queue, 
    OUT MLME_QUEUE_ELEM **Elem);

BOOLEAN MlmeQueueEmpty(
    IN MLME_QUEUE       *Queue);

BOOLEAN MlmeQueueFull(
    IN MLME_QUEUE       *Queue);

BOOLEAN  MsgTypeSubst(
    IN VOID             *Fr, 
    OUT INT             *Machine, 
    OUT INT             *MsgType);

VOID StateMachineInit(
    IN STATE_MACHINE        *Sm, 
    IN STATE_MACHINE_FUNC   Trans[], 
    IN ULONG                StNr, 
    IN ULONG                MsgNr, 
    IN STATE_MACHINE_FUNC   DefFunc, 
    IN ULONG                InitState, 
    IN ULONG                Base);

VOID StateMachineSetAction(
    IN STATE_MACHINE        *S, 
    IN ULONG                St, 
    ULONG                   Msg, 
    IN STATE_MACHINE_FUNC   F);

VOID StateMachinePerformAction(
    IN	PRTMP_ADAPTER       pAdapter, 
    IN STATE_MACHINE        *S, 
    IN MLME_QUEUE_ELEM      *Elem);

VOID Drop(
    IN	PRTMP_ADAPTER       pAdapter, 
    IN MLME_QUEUE_ELEM      *Elem);

VOID  AssocStateMachineInit(
    IN	PRTMP_ADAPTER       pAdapter, 
    IN  STATE_MACHINE       *Sm, 
    OUT STATE_MACHINE_FUNC  Trans[]);

VOID  MlmeDisassocReqAction(
    IN	PRTMP_ADAPTER       pAdapter, 
    IN  MLME_QUEUE_ELEM     *Elem);

VOID  PeerAssocReqAction(
    IN	PRTMP_ADAPTER       pAdapter, 
    IN  MLME_QUEUE_ELEM     *Elem);

VOID  PeerReassocReqAction(
    IN	PRTMP_ADAPTER       pAdapter, 
    IN  MLME_QUEUE_ELEM     *Elem);

VOID  PeerDisassocReqAction(
    IN	PRTMP_ADAPTER       pAdapter, 
    IN  MLME_QUEUE_ELEM     *Elem);

VOID  Cls3errAction(
    IN	PRTMP_ADAPTER       pAdapter, 
    IN  PMACADDR            pAddr);

USHORT AssignAid(
    IN PRTMP_ADAPTER        pAdapter);

USHORT BuildAssociation(
    IN PRTMP_ADAPTER    pAd,
    IN PMACADDR         pAddr,
    IN USHORT           CapabilityInfo,
    IN UCHAR            MaxSupportedRateIn500Kbps,
    IN UCHAR            *RSN,
    IN UCHAR            *pRSNLen, 
    OUT USHORT          *pAid);

VOID AuthStateMachineInit(
    IN PRTMP_ADAPTER        pAdapter, 
    IN PSTATE_MACHINE       sm, 
    OUT STATE_MACHINE_FUNC  Trans[]);

VOID Cls2errAction(
    IN	PRTMP_ADAPTER       pAdapter, 
    IN  PMACADDR            pAddr);

VOID MlmeDeauthReqAction(
    IN	PRTMP_ADAPTER       pAdapter, 
    IN  MLME_QUEUE_ELEM     *Elem);

VOID AuthRspStateMachineInit(
    IN	PRTMP_ADAPTER       pAdapter, 
    IN  PSTATE_MACHINE      Sm, 
    IN  STATE_MACHINE_FUNC  Trans[]);

VOID AuthRspChallengeTimeout(
    IN unsigned long        data);

VOID AuthRspChallengeTimeoutAction(
    IN	PRTMP_ADAPTER       pAdapter, 
    IN  MLME_QUEUE_ELEM     *Elem);

VOID PeerAuthAtAuthRspIdleAction(
    IN	PRTMP_ADAPTER       pAdapter, 
    IN  MLME_QUEUE_ELEM     *Elem);

VOID PeerDeauthReqAction(
    IN PRTMP_ADAPTER        pAdaptor, 
    IN MLME_QUEUE_ELEM      *Elem);

VOID PeerAuthSimpleRspGenAndSend(
    IN	PRTMP_ADAPTER       pAdapter, 
    IN  PMACHDR             Hdr, 
    IN  USHORT              Alg, 
    IN  USHORT              Seq, 
    IN  USHORT              StatusCode);

VOID SyncStateMachineInit(
    IN	PRTMP_ADAPTER       pAdapter, 
    IN  STATE_MACHINE       *Sm, 
    OUT STATE_MACHINE_FUNC  Trans[]);

VOID PeerProbeReqAction(
    IN  PRTMP_ADAPTER       pAd, 
    IN  MLME_QUEUE_ELEM     *Elem);

VOID PeerBeaconAction(
    IN PRTMP_ADAPTER        pAd, 
    IN MLME_QUEUE_ELEM      *Elem);

VOID MakeBssBeacon(
    IN	PRTMP_ADAPTER	pAdapter);

VOID  UpdateBeaconFrame(
    IN	PRTMP_ADAPTER	pAdapter);

BOOLEAN PeerAuthSanity(
    IN	PRTMP_ADAPTER	pAdapter, 
    IN  VOID *Msg, 
    IN  ULONG MsgLen, 
    OUT MACADDR *Addr, 
    OUT USHORT *Alg, 
    OUT USHORT *Seq, 
    OUT USHORT *Status, 
    OUT CHAR ChlgText[]);

BOOLEAN PeerAssocReqSanity(
    IN PRTMP_ADAPTER pAd, 
    IN  VOID *Msg, 
    IN  ULONG MsgLen, 
    OUT MACADDR *pAddr2,
    OUT USHORT *pCapabilityInfo, 
    OUT USHORT *pListenInterval, 
    OUT UCHAR *pSsidLen,
    OUT char *Ssid,
    OUT UCHAR *pRatesLen,
    OUT UCHAR Rates[],
    OUT UCHAR *RSN,
    OUT UCHAR *pRSNLen);

BOOLEAN PeerReassocReqSanity(
    IN  PRTMP_ADAPTER   pAd, 
    IN  VOID *Msg, 
    IN  ULONG MsgLen, 
    OUT MACADDR *pAddr2, 
    OUT USHORT *pCapabilityInfo, 
    OUT USHORT *pListenInterval, 
    OUT MACADDR *pApAddr,
    OUT UCHAR *pSsidLen,
    OUT char *Ssid,
    OUT UCHAR *pRatesLen,
    OUT UCHAR Rates[],
    OUT UCHAR *RSN,
    OUT UCHAR *pRSNLen);

BOOLEAN PeerDisassocReqSanity(
    IN	PRTMP_ADAPTER	pAdapter, 
    IN  VOID *Msg, 
    IN  ULONG MsgLen, 
    OUT MACADDR *Addr2, 
    OUT USHORT *Reason);

BOOLEAN PeerDeauthReqSanity(
    IN	PRTMP_ADAPTER	pAdapter, 
    IN  VOID *Msg, 
    IN  ULONG MsgLen, 
    OUT MACADDR *Addr2, 
    OUT USHORT *Reason);

BOOLEAN PeerProbeReqSanity(
    IN	PRTMP_ADAPTER	pAdapter, 
    IN  VOID *Msg, 
    IN  ULONG MsgLen, 
    OUT MACADDR *Addr2,
    OUT CHAR Ssid[], 
    OUT UCHAR *SsidLen); 
//    OUT UCHAR Rates[], 
//    OUT UCHAR *RatesLen);

BOOLEAN PeerBeaconAndProbeRspSanity(
    IN PRTMP_ADAPTER pAd, 
    IN VOID *Msg, 
    IN ULONG MsgLen, 
    OUT MACADDR *Addr2, 
    OUT MACADDR *Bssid, 
    OUT CHAR Ssid[], 
    OUT UCHAR *SsidLen, 
    OUT UCHAR *BssType, 
    OUT USHORT *BeaconPeriod, 
    OUT UCHAR *Channel, 
    OUT LARGE_INTEGER *Timestamp, 
    OUT USHORT *CapabilityInfo, 
    OUT UCHAR Rate[], 
    OUT UCHAR *RateLen,
    OUT BOOLEAN *ExtendedRateIeExist,
    OUT UCHAR *Erp);
 //     OUT UCHAR *RSN,
//    OUT UCHAR *pRSNLen);

ULONG MakeOutgoingFrame(
    OUT CHAR *Buffer, 
    OUT ULONG *Length, ...);

VOID  LfsrInit(
    IN	PRTMP_ADAPTER	pAdapter, 
    IN  ULONG Seed);

UCHAR RandomByte(
    IN	PRTMP_ADAPTER	pAdapter);

VOID  MlmePeriodicExec(
    IN unsigned long    data);

VOID MlmeAutoRecoverNetwork(
    IN PRTMP_ADAPTER    pAdapter);

VOID MlmeCheckChannelQuality(
    IN PRTMP_ADAPTER    pAdapter,
    IN ULONG            Now);

VOID MlmeCheckDynamicTxRateSwitching(
    IN PRTMP_ADAPTER    pAd);

VOID MlmeSetTxPreamble(
    IN PRTMP_ADAPTER    pAdapter, 
    IN USHORT           TxPreamble);

VOID MlmeUpdateTxRates(
    IN PRTMP_ADAPTER    pAdapter);

NDIS_STATUS MlmeInit(
    IN	PRTMP_ADAPTER	pAdapter);

VOID MlmeHandler(
    IN	PRTMP_ADAPTER	pAdapter);

VOID MlmeHalt(
    IN	PRTMP_ADAPTER	pAdapter);

VOID MlmeConfirm(
    IN	PRTMP_ADAPTER	pAdapter, 
    IN  VOID            *Msg, 
    IN  INT             MsgLen);

UCHAR FirstChannel(
    IN	PRTMP_ADAPTER	pAdapter);

UCHAR NextChannel(
    IN	PRTMP_ADAPTER	pAdapter, 
    IN  UCHAR           channel);

INT RT2500_ioctl(
	IN	struct net_device   *net_dev,
	IN	struct ifreq        *rq, 
	IN	INT                 cmd);

VOID RaiseClock(
    IN	PRTMP_ADAPTER	pAd,
    IN  ULONG *x);

VOID LowerClock(
    IN	PRTMP_ADAPTER	pAd,
    IN  ULONG *x);

USHORT ShiftInBits(
    IN	PRTMP_ADAPTER	pAd);

VOID ShiftOutBits(
    IN	PRTMP_ADAPTER	pAd,
    IN  USHORT          data,
    IN  USHORT          count);

VOID EEpromCleanup(
    IN	PRTMP_ADAPTER	pAd);

VOID EWDS(
	IN	PRTMP_ADAPTER	pAd);

VOID EWEN(
	IN	PRTMP_ADAPTER	pAd);
    
USHORT RTMP_EEPROM_READ16(
    IN	PRTMP_ADAPTER	pAd,
    IN  USHORT          Offset);

VOID RTMP_EEPROM_WRITE16(
    IN	PRTMP_ADAPTER	pAd,
    IN  USHORT          Offset,
    IN  USHORT          Data);

UCHAR ChannelSanity(
    IN PRTMP_ADAPTER    pAd, 
    IN UCHAR            channel);

//
// Prototypes of function definition in rtmp_tkip.c
//
inline BOOLEAN	RTMPTkipCompareMICValue(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			pSrc,
	IN	PUCHAR			pDA,
	IN	PUCHAR			pSA,
	IN	PUCHAR			pMICKey,
	IN	UINT			Len);

inline VOID	RTMPCalculateMICValue(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	struct sk_buff	*skb,
	IN	PUCHAR			pEncap,
	IN	INT				LenEncap,
	IN	PWPA_KEY		pWpaKey);

inline BOOLEAN	RTMPTkipCompareMICValueWithLLC(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			pLLC,
	IN	PUCHAR			pSrc,
	IN	PUCHAR			pDA,
	IN	PUCHAR			pSA,
	IN	PUCHAR			pMICKey,
	IN	UINT			Len);

VOID	RTMPSetPhyMode(
	IN	PRTMP_ADAPTER	pAdapter,
	IN  ULONG           phymode);

// ------------------------------------------------------------
NDIS_STATUS ApInitialize(
    IN  PRTMP_ADAPTER   pAdapter);

VOID ApShutdown(
    IN PRTMP_ADAPTER    pAd);

VOID ApStartUp(
    IN	PRTMP_ADAPTER	pAdapter);

VOID ApStop(
    IN	PRTMP_ADAPTER	pAdapter);

UCHAR ApAutoSelectChannel(
    IN PRTMP_ADAPTER    pAdapter);

UCHAR FirstChannel(
    IN PRTMP_ADAPTER    pAd);

UCHAR NextChannel(
    IN PRTMP_ADAPTER    pAd,
    IN UCHAR            ch);

BOOLEAN RTMPBridgeToWirelessSta(
   	IN	PRTMP_ADAPTER	pAdapter,
	IN  PUCHAR          pHeader,
	IN  UINT            HdrLen,
	IN  PUCHAR          pData,
	IN  UINT            DataLen);

VOID CleanupPsQueue(
    IN  PRTMP_ADAPTER   pAdpater,
    IN  PQUEUE_HEADER   pQueue);

VOID MacTableReset(
    IN  PRTMP_ADAPTER   pAd);

MAC_TABLE_ENTRY *MacTableInsertEntry(
    IN	PRTMP_ADAPTER	pAdapter, 
    IN  PMACADDR        pAddr); 

BOOLEAN MacTableDeleteEntry(
    IN	PRTMP_ADAPTER	pAdapter, 
    IN  PMACADDR        pAddr);

MAC_TABLE_ENTRY *MacTableLookup(
    IN	PRTMP_ADAPTER	pAdapter, 
    IN  PMACADDR        pAddr);

VOID MacTableMaintenance(
    IN PRTMP_ADAPTER    pAd);

MAC_TABLE_ENTRY *SsPsInquiry(
    IN	PRTMP_ADAPTER	pAdapter, 
    IN  MACADDR         *pAddr, 
    OUT SST             *Sst, 
    OUT USHORT          *Aid,
    OUT UCHAR           *PsMode,
    OUT UCHAR           *Rate); 

BOOLEAN PsIndicate(
    IN	PRTMP_ADAPTER	pAdapter, 
    IN  PMACADDR        pAddr, 
    IN  UCHAR           Rssi,
    IN  UCHAR           Psm);

VOID ApLogEvent(
    IN PRTMP_ADAPTER    pAd,
    IN PMACADDR         pAddr,
    IN USHORT           Event);

VOID ApUpdateCapabilityAndErpIe(
    IN PRTMP_ADAPTER    pAd);

BOOLEAN ApCheckAccessControlList(
    IN PRTMP_ADAPTER    pAd,
    IN PMACADDR         pAddr);

VOID ApUpdateAccessControlList(
    IN PRTMP_ADAPTER    pAd);

VOID ApEnqueueNullFrame(
    IN PRTMP_ADAPTER    pAd,
    IN PMACADDR         pAddr,
    IN UCHAR            TxRate,
    IN INT              ToWhichWds);

VOID	ApSendNullFrame(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PVOID			pBuffer,
	IN	ULONG			Length,
	IN  UCHAR           TxRate);

VOID    RTMPTkipAppend( 
    IN  PTKIP_KEY_INFO  pTkip,  
    IN  PUCHAR          pSrc,
    IN  UINT            nBytes);

VOID    RTMPTkipGetMIC( 
    IN  PTKIP_KEY_INFO      pTkip);

INT RTMPSetInformation(
	IN	PRTMP_ADAPTER       pAdapter,
	IN	OUT	struct ifreq	*rq,
	IN	INT					cmd);

INT RTMPQueryInformation(
	IN	PRTMP_ADAPTER       pAdapter,
	IN	OUT	struct ifreq	*rq,
	IN	INT					cmd);

//
// Prototypes of function definition for *iwpriv* in rtmp_info.c
//
INT Set_CountryRegion_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_SSID_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_WirelessMode_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT Set_TxRate_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_Channel_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_BeaconPeriod_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_Debug_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_BGProtection_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_TxAntenna_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_RxAntenna_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_TxPreamble_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_RTSThreshold_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_FragThreshold_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_TxBurst_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_TurboRate_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_NoForwarding_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_HideSSID_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_ShortSlot_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_AuthMode_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_EncrypType_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_DefaultKeyID_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_Key1_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_Key2_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_Key3_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_Key4_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_AccessPolicy_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_AccessControlList_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_WPAPSK_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_ResetStatCounter_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_RekeyType_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_RekeyPeriod_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

#ifdef RT2500_DBG
VOID RTMPIoctlBBP(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	struct iwreq	*wrq);

VOID RTMPIoctlMAC(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	struct iwreq	*wrq);

VOID RTMPIoctlE2PROM(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	struct iwreq	*wrq);

VOID RTMPIoctlStatistics(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	struct iwreq	*wrq);
#endif

#ifdef RALINK_ATE
INT	Set_ATE_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_ATE_DA_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_ATE_SA_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_ATE_BSSID_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_ATE_TX_POWER_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_ATE_TX_LENGTH_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_ATE_TX_COUNT_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);

INT	Set_ATE_TX_RATE_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg);
#endif	//#ifdef RALINK_ATE

#endif  // __RTMP_H__

