/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

	Module Name:
	mlme.h

	Abstract:

	Revision History:
	Who			When			What
	--------	----------		----------------------------------------------
	Name		Date			Modification logs
*/
#ifndef __MLME_H__
#define __MLME_H__


#define END_OF_ARGS             -1
#define LFSR_MASK               0x80000057
#define TBTT_PRELOAD_TIME       384        // usec. LomgPreamble + 24-byte at 1Mbps
#define MLME_TASK_EXEC_INTV     (1*HZ)       // 1024 ms = 2 sec
#define DEFAULT_DTIM_PERIOD     1

// 802.11g spec - if ERP rate in used, CWmin is 15, if only 11b rates in used, Cwmin is 31.
// Cwmax is always 1023
#define CW_MIN_IN_BITS          3       // actual CwMin = 2^CW_MIN_IN_BITS - 1 = 7
#define CW_MAX_IN_BITS          8       // actual CwMax = 2^CW_MAX_IN_BITS - 1 = 255

#define RSSI_TO_DBM_OFFSET          115 // RSSI-115 = dBm
#define RSSI_FOR_MID_TX_POWER       55  // -55 db is considered mid-distance
#define RSSI_FOR_LOW_TX_POWER       45  // -45 db is considered very short distance and 
                                        // eligible to use a lower TX power
#define RSSI_FOR_LOWEST_TX_POWER    30
#define MID_TX_POWER_DELTA          0   // -3 db from full TX power upon mid-distance to AP
#define LOW_TX_POWER_DELTA          3   // -8 db from full TX power upon very short distance
#define LOWEST_TX_POWER_DELTA       6   // -12 db from full TX power upon shortest distance

// Channel Quality Indication
//#define CQI_IS_GOOD(cqi)        ((cqi) >= 70)
//#define CQI_IS_FAIR(cqi)        (((cqi) >= 50) && ((cqi) < 70))
//#define CQI_IS_POOR(cqi)        (((cqi) >= 25) && ((cqi) < 50))
//#define CQI_IS_BAD(cqi)         ((cqi) < 25)

// weighting factor to calculate Channel quality, total should be 100%
#define RSSI_WEIGHTING                   0
#define TX_WEIGHTING                    40
#define RX_WEIGHTING                     60

#define PEER_KEY_NOT_USED                0
#define PEER_KEY_64_BIT                  64
#define PEER_KEY_128_BIT                 128

#define PEER_KEY_64BIT_LEN               8
#define PEER_KEY_128BIT_LEN              16

#define MAC_TABLE_AGEOUT_TIME            300		// unit: sec
#define MAC_TABLE_ASSOC_TIMEOUT          5			// unit: sec
//#define MAX_LEN_OF_BSS_TABLE             20
//#define BSS_NOT_FOUND                    0xFFFFFFFF

#define MAX_LEN_OF_MLME_QUEUE            10
#define MAX_LEN_OF_MLME_QUEUE_MSG        512

// assoc state-machine states
#define ASSOC_IDLE                       0
#define MAX_ASSOC_STATE                  1

//authentication state machine
#define AUTH_REQ_IDLE                    0
#define MAX_AUTH_STATE                   1

// authentication response state machine
#define AUTH_RSP_IDLE                    0
#define MAX_AUTH_RSP_STATE               1

// SYNC state machine
#define SYNC_IDLE                        0 
#define MAX_SYNC_STATE                   1

//WPA State machine
#define WPA_PTK					0
#define MAX_WPA_PTK_STATE		1

// Value domain of pMacEntry->Sst
typedef enum _Sst {
    SST_NOT_AUTH,   // 0: equivalent to IEEE 802.11/1999 state 1
    SST_AUTH,       // 1: equivalent to IEEE 802.11/1999 state 2
    SST_ASSOC       // 2: equivalent to IEEE 802.11/1999 state 3
} SST;

// value domain of pMacEntry->AuthState
typedef enum _AuthState {
    AS_NOT_AUTH,
    AS_AUTH_OPEN,       // STA has been authenticated using OPEN SYSTEM
    AS_AUTH_KEY,        // STA has been authenticated using SHARED KEY
    AS_AUTHENTICATING   // STA is waiting for AUTH seq#3 using SHARED KEY
} AUTH_STATE;

//for-wpa value domain of pMacEntry->WpaState  802.1i D3   p.114
typedef enum _WpaState {
	AS_NOTUSE,		//0
	AS_DISCONNECT,		//   1
	AS_DISCONNECTED,		// 2
	AS_INITIALIZE,	// 3
	AS_AUTHENTICATION,
	AS_AUTHENTICATION2,  // 5
	AS_INITPMK,	// 6
	AS_INITPSK,		// 7
	AS_PTKSTART,	// 8
	AS_PTKINIT_NEGOTIATING,	// 9
	AS_PTKINITDONE,	// 10
	AS_UPDATEKEYS,
	AS_INTEGRITY_FAILURE,
	AS_KEYUPDATE,
} WPA_STATE;

// for-wpa value domain of pMacEntry->WpaState  802.1i D3   p.114
typedef enum _GTKState {
	REKRY_NEGOTIATING,
	REKEY_ESTABLISHED,
	KEYERROR,
} GTK_STATE;

//  for-wpa  value domain of pMacEntry->WpaState  802.1i D3   p.114
typedef enum _WpaGTKState {
	SETKEYS,
	SETKEYS_DONE
} WPA_GTK_STATE;

#define MAC_ADDR_IS_GROUP(Addr)       ((((Addr).Octet[0]) & 0x01) != 0)
#define MAC_ADDR_HASH(Addr)           ((Addr).Octet[0] ^ (Addr).Octet[1] ^ (Addr).Octet[2] ^ (Addr).Octet[3] ^ (Addr).Octet[4] ^ (Addr).Octet[5])
#define MAC_ADDR_HASH_INDEX(Addr)     (MAC_ADDR_HASH(Addr) % HASH_TABLE_SIZE)
#define MAC_ADDR_EQUAL(pAddr1,pAddr2) RTMPEqualMemory((PVOID)(pAddr1), (PVOID)(pAddr2), MAC_ADDR_LEN)
#define COPY_MAC_ADDR(Addr1, Addr2)   memcpy((Addr1), (Addr2), ETH_LENGTH_OF_ADDRESS)

// LED Control
#define ASIC_LED_ACT_ON(pAdapter)        RTMP_IO_WRITE32(pAdapter, LEDCSR, 0x0003ffff)  // 0x00021E46
#define ASIC_LED_ACT_OFF(pAdapter)       RTMP_IO_WRITE32(pAdapter, LEDCSR, 0x0000ffff)  // 0x00001E46

#define CAP_IS_ESS_ON(x)                 (((x) & 0x0001) != 0)
#define CAP_IS_IBSS_ON(x)                (((x) & 0x0002) != 0)
#define CAP_IS_CF_POLLABLE_ON(x)         (((x) & 0x0004) != 0)
#define CAP_IS_CF_POLL_REQ_ON(x)         (((x) & 0x0008) != 0)
#define CAP_IS_PRIVACY_ON(x)             (((x) & 0x0010) != 0)

// 802.11G capability features
#define CAP_IS_SHORT_PREAMBLE_ON(x)      (((x) & 0x0020) != 0)
#define CAP_IS_PBCC_ON(x)                (((x) & 0x0040) != 0)
#define CAP_IS_AGILITY_ON(x)             (((x) & 0x0080) != 0)
#define CAP_IS_EXT_RATE_PBCC_ON(x)       (((x) & 0x0100) != 0)
//#define CAP_IS_CCK_OFDM_ON(x)          (((x) & 0x0200) != 0)
#define CAP_IS_QOS(x)                    (((x) & 0x0200) != 0)  // defined in 802.11e d4.3
#define CAP_IS_SHORT_SLOT_TIME(x)        (((x) & 0x0400) != 0)
#define CAP_IS_APSD(x)                   (((x) & 0x0800) != 0)  // defined in 802.11e d4.3
#define CAP_IS_Q_ACK(x)                  (((x) & 0x1000) != 0)  // defined in 802.11e d4.3
#define CAP_IS_DSSS_OFDM(x)              (((x) & 0x2000) != 0)
#define CAP_IS_BLOCK_ACK(x)              (((x) & 0x4000) != 0)  // defined in 802.11e d4.3

//#define CAP_GENERATE(ess,ibss,cfp,cfpreq,priv) ((ess) ? 0x0001 : 0x0000) | ((ibss) ? 0x0002 : 0x0000) | ((cfp) ? 0x0004 : 0x0000) | ((cfpreq) ? 0x0008 : 0x0000) | ((priv) ? 0x0010: 0x0000)
#define CAP_GENERATE(priv,s_pre,s_slot)  (0x0001 | ((priv) ? 0x0010 : 0x0000) | ((s_pre) ? 0x0020 : 0x0000) | ((s_slot) ? 0x0400 : 0x0000))

#define ERP_IS_NON_ERP_PRESENT(x)            (((x) & 0x01) != 0)    // define in 802.11g
#define ERP_IS_USE_PROTECTION(x)             (((x) & 0x02) != 0)    // define in 802.11g
#define ERP_IS_USE_BARKER_PREAMBLE(x)        (((x) & 0x04) != 0)    // define in 802.11g

#define DRS_TX_QUALITY_WORST_BOUND      4 
#define DRS_PENALTY                     8

// Mac Address data structure
typedef struct PACKED _MACADDR {
    UCHAR     Octet[MAC_ADDR_LEN];
} MACADDR, *PMACADDR;

// Mac Frame Header
typedef struct PACKED _MACHDR {
    // 2-byte Frame Control. NOTE: bit field assigned from LSB first
#ifdef BIG_ENDIAN
    USHORT    Order:1;
    USHORT    Wep:1;
    USHORT    MoreData:1;
    USHORT    PwrMgmt:1;
    USHORT    Retry:1;
    USHORT    MoreFrag:1;
    USHORT    Frds:1;
    USHORT    Tods:1;
    USHORT    SubType:4;
    USHORT    Type:2;
    USHORT    Ver:2;
#else
    USHORT    Ver:2;
    USHORT    Type:2;
    USHORT    SubType:4;
    USHORT    Tods:1;
    USHORT    Frds:1;
    USHORT    MoreFrag:1;
    USHORT    Retry:1;
    USHORT    PwrMgmt:1;
    USHORT    MoreData:1;
    USHORT    Wep:1;
    USHORT    Order:1;
#endif
    
    USHORT    Duration;
    MACADDR   Addr1;
    MACADDR   Addr2;
    MACADDR   Addr3;
    
#ifdef BIG_ENDIAN
    USHORT    Seq:12;
    USHORT    Frag:4;
#else
    USHORT    Frag:4;
    USHORT    Seq:12;
#endif
} MACHDR, *PMACHDR;

typedef struct PACKED _MACFRAME {
    MACHDR    Hdr;
    CHAR      Octet[1];
} MACFRAME, *PMACFRAME;

typedef struct PACKED _PSPOLL_FRAME {
    USHORT    Ver:2;
    USHORT    Type:2;
    USHORT    SubType:4;
    USHORT    Tods:1;
    USHORT    Frds:1;
    USHORT    MoreFrag:1;
    USHORT    Retry:1;
    USHORT    PwrMgmt:1;
    USHORT    MoreData:1;
    USHORT    Wep:1;
    USHORT    Order:1;
    
    USHORT    Aid;
    MACADDR   Bssid;
    MACADDR   Ta;
} PSPOLL_FRAME;

//
// Contention-free parameter (without ID and Length)
//
typedef struct PACKED _CF_PARM {
    UCHAR        CfpCount;
    UCHAR        CfpPeriod;
    USHORT       CfpMaxDuration;
    USHORT       CfpDurRemaining;
} CF_PARM, *PCF_PARM;

#if 0
typedef struct {
    MACADDR Bssid;
    UCHAR   Channel;
    UCHAR   BssType;
    USHORT  AtimWin;
    USHORT  BeaconPeriod;

    UCHAR   Rates[MAX_LEN_OF_SUPPORTED_RATES];
    UCHAR   RatesLen;
    BOOLEAN ExtendedRateIeExist; // records if this AP use EXTENDED_SUPPORTED_RATES IE
    UCHAR   Rssi;
    UCHAR   Privacy;

    USHORT  DtimPeriod;
    USHORT  CapabilityInfo;

    USHORT  CfpCount;
    USHORT  CfpPeriod;
    USHORT  CfpMaxDuration;
    USHORT  CfpDurRemaining;
    UCHAR   SsidLen;
    CHAR    Ssid[MAX_LEN_OF_SSID];
    
    ULONG   LastBeaconRxTime; // OS's timestamp

	// New for microsoft WPA support
	NDIS_802_11_FIXED_IEs	FixIEs;
	UCHAR					VarIELen;				// Length of next VIE include EID & Length
	UCHAR					VarIEs[MAX_VIE_LEN];
} BSS_ENTRY, *PBSS_ENTRY;

typedef struct {
    UCHAR           BssNr;
    BSS_ENTRY       BssEntry[MAX_LEN_OF_BSS_TABLE];
} BSS_TABLE, *PBSS_TABLE;
#endif

typedef struct PACKED _MLME_QUEUE_ELEM {
    ULONG             Machine;
    ULONG             MsgType;
    ULONG             MsgLen;
//  LARGE_INTEGER     TimeStamp;
    UCHAR             Rssi;
    UCHAR             Channel;
    BOOLEAN           Occupied;
    PUCHAR			  Msg;//UCHAR Msg[MAX_LEN_OF_MLME_QUEUE_MSG];(tt_lin)
	dma_addr_t		  pa_data_addr;//tt_lin 
} MLME_QUEUE_ELEM, *PMLME_QUEUE_ELEM;

typedef struct PACKED _MLME_QUEUE {
    ULONG             Num;
    ULONG             Head;
    ULONG             Tail;
    spinlock_t        Lock;
    MLME_QUEUE_ELEM   Entry[MAX_LEN_OF_MLME_QUEUE];
} MLME_QUEUE, *PMLME_QUEUE;

typedef VOID (*STATE_MACHINE_FUNC)(VOID *Adaptor, MLME_QUEUE_ELEM *Elem);

typedef struct PACKED _STATE_MACHINE {
    ULONG                           Base;
    ULONG                           NrState;
    ULONG                           NrMsg;
    ULONG                           CurrState;
    STATE_MACHINE_FUNC             *TransFunc;
} STATE_MACHINE, *PSTATE_MACHINE;

// AUTH-RSP State Machine Aux data structure
typedef struct PACKED _AUTH_RSP_AUX {
    MACADDR             Addr;
    USHORT              Alg;
    CHAR                Challenge[CIPHER_TEXT_LEN];
} AUTH_RSP_AUX, *PAUTH_RSP_AUX;

 // assoc struct is equal to reassoc
typedef struct PACKED _MLME_ASSOC_REQ_STRUCT{
    MACADDR   Addr;
    USHORT    CapabilityInfo;
    USHORT    ListenIntv;
    ULONG     Timeout;
} MLME_ASSOC_REQ_STRUCT, *PMLME_ASSOC_REQ_STRUCT, MLME_REASSOC_REQ_STRUCT, *PMLME_REASSOC_REQ_STRUCT;

typedef struct PACKED _MLME_DISASSOC_REQ_STRUCT{
    MACADDR   Addr;
    USHORT    Reason;
} MLME_DISASSOC_REQ_STRUCT, *PMLME_DISASSOC_REQ_STRUCT;

typedef struct PACKED _MLME_AUTH_REQ_STRUCT {
    MACADDR      Addr;
    USHORT       Alg;
    ULONG        Timeout;
} MLME_AUTH_REQ_STRUCT, *PMLME_AUTH_REQ_STRUCT;

typedef struct PACKED _MLME_DEAUTH_REQ_STRUCT {
    MACADDR      Addr;
    USHORT       Reason;
} MLME_DEAUTH_REQ_STRUCT, *PMLME_DEAUTH_REQ_STRUCT;

//typedef struct _MLME_AUTH_IND_STRUCT {
//    MACADDR      Addr;
//    USHORT       Alg;
//} MLME_AUTH_IND_STRUCT, *PMLME_AUTH_IND_STRUCT;

//typedef struct _CLS2ERR_STRUCT {
//    MACADDR      Addr;
//} CLS2ERR_STRUCT, *PCLS2ERR_STRUCT;

typedef struct {
    ULONG      BssIdx;
} MLME_JOIN_REQ_STRUCT;

typedef struct PACKED _MLME_SCAN_REQ_STRUCT {
    MACADDR    Bssid;
    UCHAR      BssType;
    UCHAR      ScanType;
    UCHAR      SsidLen;
    CHAR       Ssid[MAX_LEN_OF_SSID];
} MLME_SCAN_REQ_STRUCT, *PMLME_SCAN_REQ_STRUCT;

typedef struct PACKED _MLME_START_REQ_STRUCT {
    CHAR        Ssid[MAX_LEN_OF_SSID];
    UCHAR       SsidLen;
} MLME_START_REQ_STRUCT, *PMLME_START_REQ_STRUCT;

typedef struct PACKED _ARC4_CONTEXT {
    UCHAR x, y, State[256], Key[16];     // 128 bits key
} ARC4_CONTEXT, *PARC4_CONTEXT;

typedef struct PACKED _EID_STRUCT {
    UCHAR   Eid;
    UCHAR   Len;
    CHAR    Octet[1];
} EID_STRUCT,*PEID_STRUCT;

// New for WPA cipher suite 
typedef	struct	PACKED _RSN_EID_STRUCT	{
	UCHAR	Eid;
	UCHAR	Length;
	UCHAR	Oui[4];
	USHORT	Version;
	UCHAR	Multicast[4];
	USHORT	Count;
	struct	{
		UCHAR	Oui[4];
	}Unicast[1];
} RSN_EID_STRUCT, *PRSN_EID_STRUCT;

extern UCHAR  RateIdToMbps[];
extern USHORT RateIdTo500Kbps[];

#endif	// MLME_H__
