/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

	Module Name:
	rtmp_info.c

	Abstract:
	IOCTL related subroutines

	Revision History:
	Who         When          What
	--------    ----------    ----------------------------------------------
	Rory Chen   01-03-2003    created

*/

#include	"rt_config.h"


/* The frequency of each channel in MHz */
const long channel_frequency[] = {
        2412, 2417, 2422, 2427, 2432, 2437, 2442,
        2447, 2452, 2457, 2462, 2467, 2472, 2484
};
#define NUM_CHANNELS ( sizeof(channel_frequency) / sizeof(channel_frequency[0]) )


static const USHORT RateIdTo500Kbps2[] = {2, 4, 11, 22, 12, 18, 24, 36, 48, 72, 96, 108, 144, 200};
#define NUM_RateIdTo500Kbps ( sizeof(RateIdTo500Kbps2) / sizeof(RateIdTo500Kbps2[0]) )

struct iw_priv_args privtab[] = {
{ RTPRIV_IOCTL_SET, 
  IW_PRIV_TYPE_CHAR | 1024, 0,
  "set"},
#ifdef RT2500_DBG
{ RTPRIV_IOCTL_BBP,
  IW_PRIV_TYPE_CHAR | 1024, IW_PRIV_TYPE_CHAR | 1024,
  "bbp"},
{ RTPRIV_IOCTL_MAC,
  IW_PRIV_TYPE_CHAR | 1024, IW_PRIV_TYPE_CHAR | 1024,
  "mac"},
{ RTPRIV_IOCTL_E2P,
  IW_PRIV_TYPE_CHAR | 1024, IW_PRIV_TYPE_CHAR | 1024,
  "e2p"},
{ RTPRIV_IOCTL_STATISTICS,
  IW_PRIV_TYPE_CHAR | 1024, IW_PRIV_TYPE_CHAR | 1024,
  "stat"}
#endif
};

static struct {
	char *name;
	int (*set_proc)(PRTMP_ADAPTER pAdapter, PUCHAR arg);
} *PRTMP_PRIVATE_SET_PROC, RTMP_PRIVATE_SUPPORT_PROC[] = {
	{"CountryRegion", Set_CountryRegion_Proc },
	{"SSID", Set_SSID_Proc},
	{"WirelessMode", Set_WirelessMode_Proc},
	{"TxRate", Set_TxRate_Proc},
	{"Channel", Set_Channel_Proc},
	{"BeaconPeriod", Set_BeaconPeriod_Proc},	
	{"BGProtection", Set_BGProtection_Proc},
	{"TxAntenna", Set_TxAntenna_Proc},
	{"RxAntenna", Set_RxAntenna_Proc},
	{"TxPreamble", Set_TxPreamble_Proc},
	{"RTSThreshold", Set_RTSThreshold_Proc},
	{"FragThreshold", Set_FragThreshold_Proc},
	{"TxBurst", Set_TxBurst_Proc},
	{"TurboRate", Set_TurboRate_Proc},
	{"NoForwarding", Set_NoForwarding_Proc},
	{"HideSSID", Set_HideSSID_Proc},
	{"ShortSlot", Set_ShortSlot_Proc},
	{"AuthMode", Set_AuthMode_Proc},
	{"EncrypType", Set_EncrypType_Proc},
	{"DefaultKeyID", Set_DefaultKeyID_Proc},
	{"Key1", Set_Key1_Proc},
	{"Key2", Set_Key2_Proc},
	{"Key3", Set_Key3_Proc},
	{"Key4", Set_Key4_Proc},
	{"AccessPolicy", Set_AccessPolicy_Proc},
	{"AccessControlList", Set_AccessControlList_Proc},
	{"WPAPSK", Set_WPAPSK_Proc},
	{"ResetCounter", Set_ResetStatCounter_Proc},
	{"Rekeytype", Set_RekeyType_Proc},
	{"Rekeyperiod", Set_RekeyPeriod_Proc},
#ifdef RT2500_DBG	
	{"Debug", Set_Debug_Proc},
#endif

#ifdef RALINK_ATE
	{"ATE",       Set_ATE_Proc		},	// set ATE Mode to: STOP, TXCONT, TXCARR, TXFRAME, RXFRAME
	{"ATEDA",     Set_ATE_DA_Proc		},	// set ATE TxFrames ADDR1, DA
	{"ATESA",     Set_ATE_SA_Proc		},	// set ATE TxFrames ADDR2, SA
	{"ATEBSSID",  Set_ATE_BSSID_Proc	},	// set ATE TxFrames ADDR3, BSSID
	{"ATETXPOW",  Set_ATE_TX_POWER_Proc	},	// set ATE TxPower
	{"ATETXLEN",  Set_ATE_TX_LENGTH_Proc    },	// set ATE TxLength
	{"ATETXCNT",  Set_ATE_TX_COUNT_Proc	},	// set ATE TxCount
	{"ATETXRATE", Set_ATE_TX_RATE_Proc	},	// set ATE TxRate
#endif	//#ifdef RALINK_ATE

	{NULL,}
};

INT RTMPSetInformation(
	IN	PRTMP_ADAPTER pAdapter,
	IN	OUT	struct ifreq	*rq,
	IN	INT					cmd)
{
	struct iwreq						*wrq = (struct iwreq *) rq;
	INT									Status = NDIS_STATUS_SUCCESS;
	ULONG								phymode;
	BOOLEAN								RestartAPIsRequired = FALSE;
	NDIS_802_11_CONFIGURATION			Configuration;
	NDIS_802_11_ANTENNA					Antenna;
	RT_802_11_PREAMBLE					Preamble;
	NDIS_802_11_RTS_THRESHOLD           RtsThresh;
	NDIS_802_11_FRAGMENTATION_THRESHOLD FragThresh;
	RT_802_11_AP_CONFIG                 ApConfig, *pApConfig=NULL;
	NDIS_802_11_AUTHENTICATION_MODE		AuthMode;
	NDIS_802_11_WEP_STATUS				WepStatus;
	NDIS_802_11_REMOVE_KEY				RemoveKey, *pRemoveKey=NULL;
	NDIS_802_11_KEY						WepKey, *pKey=NULL;
	NDIS_802_11_SSID					Ssid, *pSsid=NULL;	
	RT_802_11_ACL						Acl;
	UCHAR                               CountryRegion;
	ULONG                               KeyIdx;
	UCHAR								TxValue;
	UCHAR								RxValue;
	UINT                                 i;
	RT_WPA_REKEY						WPA_REKEY;
#ifdef	WDS
	RT_802_11_WDS						Wds;
#endif

	switch(cmd & 0x7FFF) {
		case RT_OID_802_11_COUNTRY_REGION:
			if (wrq->u.data.length != sizeof(CountryRegion))
				Status = -EINVAL;
			else
			{
				copy_from_user(&CountryRegion, wrq->u.data.pointer, wrq->u.data.length);			
				pAdapter->PortCfg.CountryRegion = CountryRegion;
				DBGPRINT(RT_DEBUG_TRACE, "Set::RT_OID_802_11_COUNTRY_REGION (=%d) \n", pAdapter->PortCfg.CountryRegion)
			}
			break;
		case RT_OID_802_11_RESET_COUNTERS:
			NdisZeroMemory(&pAdapter->WlanCounters, sizeof(COUNTER_802_11));
			NdisZeroMemory(&pAdapter->Counters, sizeof(COUNTER_802_3));
			NdisZeroMemory(&pAdapter->RalinkCounters, sizeof(COUNTER_RALINK));
			NdisZeroMemory(&pAdapter->Mlme.PrevWlanCounters, sizeof(COUNTER_802_11));
			DBGPRINT(RT_DEBUG_INFO, "Set::RT_OID_802_11_RESET_COUNTERS \n")
			break;
		case RT_OID_802_11_ACL:
			if (wrq->u.data.length != sizeof(RT_802_11_ACL))
				Status = -EINVAL;
			else 
			{
				copy_from_user(&Acl, wrq->u.data.pointer, wrq->u.data.length);
				NdisMoveMemory(&pAdapter->PortCfg.AccessControlList, &Acl, sizeof(RT_802_11_ACL));
				if (pAdapter->PortCfg.AccessControlList.Num > MAX_LEN_OF_MAC_TABLE)
					pAdapter->PortCfg.AccessControlList.Num = MAX_LEN_OF_MAC_TABLE;

				// check if ACL change affects any existent associtions
				ApUpdateAccessControlList(pAdapter);
				DBGPRINT(RT_DEBUG_TRACE, "Set::RT_OID_802_11_ACL (Policy=%d, Entry#=%d\n",
							pAdapter->PortCfg.AccessControlList.Policy, pAdapter->PortCfg.AccessControlList.Num);
			}
			break;
		case OID_802_11_SSID:
			if (wrq->u.data.length != sizeof(NDIS_802_11_SSID))
				Status = -EINVAL;
			else 
			{
				copy_from_user(&Ssid, wrq->u.data.pointer, wrq->u.data.length);
				pSsid = &Ssid;

				if(pSsid->SsidLength > MAX_LEN_OF_SSID)
					Status = -EINVAL;
				else
				{
					NdisZeroMemory(pAdapter->PortCfg.Ssid, MAX_LEN_OF_SSID);
					NdisMoveMemory(pAdapter->PortCfg.Ssid, pSsid->Ssid, pSsid->SsidLength);
					pAdapter->PortCfg.SsidLen = (UCHAR)pSsid->SsidLength;
				}
				DBGPRINT(RT_DEBUG_TRACE, "Set::OID_802_11_SSID (Len=%d,Ssid=%s)\n", pAdapter->PortCfg.SsidLen, pAdapter->PortCfg.Ssid);
			}
			RestartAPIsRequired = TRUE;
			break;
		case OID_802_11_ADD_KEY:
			copy_from_user(&WepKey, wrq->u.data.pointer, wrq->u.data.length);
			pKey = &WepKey;

			if (pAdapter->PortCfg.AuthMode >= Ndis802_11AuthModeWPA)
			{
				if(pKey->KeyLength==32)
				{
					NdisMoveMemory(pAdapter->PortCfg.PMK, pKey->KeyMaterial, 32);
                    DBGPRINT(RT_DEBUG_TRACE, "  after ADD_KEY :  PMK = %x %x %x %x \n",pAdapter->PortCfg.PMK[0],pAdapter->PortCfg.PMK[1],pAdapter->PortCfg.PMK[2],pAdapter->PortCfg.PMK[3]);
#ifdef RT2500_DBG
					printk("OID_802_11_ADD_KEY:: Key=>\n");
					for (i = 0; i < 32; i++)
					{
						printk("%02x:", pAdapter->PortCfg.PMK[i]);
						if ((i%16) == 15)
							printk("\n");
					}
					printk("\n");
#endif
				}
				else
                    DBGPRINT(RT_DEBUG_TRACE, "Set::OID_802_11_ADD_KEY ERROR \n");
			}
			else	// Old WEP stuff
			{
				KeyIdx = pKey->KeyIndex & 0x0fffffff;

				// it is a shared key
				if (KeyIdx > 4)
					Status = -EINVAL;
				else
				{
					pAdapter->PortCfg.SharedKey[KeyIdx].KeyLen = (UCHAR) pKey->KeyLength;
					NdisMoveMemory(pAdapter->PortCfg.SharedKey[KeyIdx].Key, &pKey->KeyMaterial, pKey->KeyLength);
					if (pKey->KeyIndex & 0x80000000)
					{
						// Default key for tx (shared key)
						pAdapter->PortCfg.DefaultKeyId = (UCHAR) KeyIdx;								
					}
				}
			}
			DBGPRINT(DEBUG_TEMP, "Set::OID_802_11_ADD_KEY (info-len=%d, id=0x%x, Len=%d-byte)\n", wrq->u.data.length, pKey->KeyIndex, pKey->KeyLength);
			break;
		case OID_802_11_REMOVE_KEY:
			if (wrq->u.data.length != sizeof(NDIS_802_11_REMOVE_KEY))
				Status = -EINVAL;
			else 
			{
				copy_from_user(&RemoveKey, wrq->u.data.pointer, wrq->u.data.length);
				pRemoveKey = &RemoveKey;
				if (pAdapter->PortCfg.AuthMode >= Ndis802_11AuthModeWPA)
				{
				}
				else
				{
					KeyIdx = pRemoveKey->KeyIndex;

					if (KeyIdx & 0x80000000)
					{
						// Should never set default bit when remove key
						Status = -EINVAL;
					}
					else
					{
						KeyIdx = KeyIdx & 0x0fffffff;
						if (KeyIdx > 4)
							Status = -EINVAL;
						else
							pAdapter->PortCfg.SharedKey[KeyIdx].KeyLen = 0;
					}
				}
			}
			DBGPRINT(RT_DEBUG_TRACE, "Set::OID_802_11_REMOVE_KEY (id=0x%x, Len=%d-byte)\n", pRemoveKey->KeyIndex, pRemoveKey->Length);
			break;
		case OID_802_11_WEP_STATUS:
			if (wrq->u.data.length != sizeof(NDIS_802_11_WEP_STATUS))
				Status = -EINVAL;
			else 
			{
				copy_from_user(&WepStatus, wrq->u.data.pointer, wrq->u.data.length);
				// Since TKIP, AES, WEP are all supported. It should not have any invalid setting
				if (WepStatus <= Ndis802_11Encryption3KeyAbsent)
				{
					pAdapter->PortCfg.WepStatus = WepStatus;
				}
				else
					Status = -EINVAL;
                RTMPMakeRSNIE(pAdapter, pAdapter->PortCfg.AuthMode, pAdapter->PortCfg.WepStatus);
				DBGPRINT(RT_DEBUG_TRACE, "Set::OID_802_11_WEP_STATUS (=%d)\n",WepStatus);
			}
			break;
		case OID_802_11_AUTHENTICATION_MODE:
			if (wrq->u.data.length != sizeof(NDIS_802_11_AUTHENTICATION_MODE))
				Status = -EINVAL;
			else 
			{
				copy_from_user(&AuthMode, wrq->u.data.pointer, wrq->u.data.length);
				if (AuthMode > Ndis802_11AuthModeMax)
					Status = -EINVAL;
				else
					pAdapter->PortCfg.AuthMode = AuthMode;
			}
			pAdapter->PortCfg.PortSecured = WPA_802_1X_PORT_NOT_SECURED;
            RTMPMakeRSNIE(pAdapter, pAdapter->PortCfg.AuthMode, pAdapter->PortCfg.WepStatus);
			DBGPRINT(RT_DEBUG_TRACE, "Set::OID_802_11_AUTHENTICATION_MODE (=%d) \n",pAdapter->PortCfg.AuthMode);
			break;
		case RT_OID_802_11_AP_CONFIG:
			if (wrq->u.data.length != sizeof(RT_802_11_AP_CONFIG))
				Status = -EINVAL;
			else 
			{
				copy_from_user(&ApConfig, wrq->u.data.pointer, wrq->u.data.length);
				pApConfig = &ApConfig;
				pAdapter->PortCfg.EnableTxBurst = pApConfig->EnableTxBurst;
				pAdapter->PortCfg.EnableTurboRate = pApConfig->EnableTurboRate;
				pAdapter->PortCfg.IsolateInterStaTraffic = pApConfig->IsolateInterStaTraffic;
				if (pAdapter->PortCfg.HideSsid != pApConfig->HideSsid)
				{
					pAdapter->PortCfg.HideSsid = pApConfig->HideSsid;
					// re-built BEACON frame format
					AsicDisableSync(pAdapter);
					MakeBssBeacon(pAdapter);
					UpdateBeaconFrame(pAdapter);
					AsicEnableBssSync(pAdapter);
				}
				pAdapter->PortCfg.UseBGProtection = pApConfig->UseBGProtection;
				pAdapter->PortCfg.UseShortSlotTime = pApConfig->UseShortSlotTime;
				ApUpdateCapabilityAndErpIe(pAdapter);
				DBGPRINT(RT_DEBUG_TRACE, "Set::RT_OID_802_11_AP_CONFIG (Burst=%d,72/100=%d,Hotspot=%d,HideSsid=%d,Protection=%d,ShortSlot=%d\n",
									pApConfig->EnableTxBurst,
									pApConfig->EnableTurboRate,
									pApConfig->IsolateInterStaTraffic,
									pApConfig->HideSsid,
									pApConfig->UseBGProtection,
									pApConfig->UseShortSlotTime);
			}
			break;
		case OID_802_11_FRAGMENTATION_THRESHOLD:
			if (wrq->u.data.length != sizeof(NDIS_802_11_FRAGMENTATION_THRESHOLD)) 
				Status = -EINVAL;
			else
			{
				copy_from_user(&FragThresh, wrq->u.data.pointer, wrq->u.data.length);
				pAdapter->PortCfg.bFragmentZeroDisable = FALSE;
				if (FragThresh > MAX_FRAG_THRESHOLD || FragThresh < MIN_FRAG_THRESHOLD)
					if (FragThresh == 0)
					{
						pAdapter->PortCfg.FragmentThreshold = MAX_FRAG_THRESHOLD;
						pAdapter->PortCfg.bFragmentZeroDisable = TRUE;
					}
					else
						Status = -EINVAL;
				else
					pAdapter->PortCfg.FragmentThreshold = (USHORT)FragThresh;
				DBGPRINT(RT_DEBUG_TRACE, "Set::OID_802_11_FRAGMENTATION_THRESHOLD (=%d) \n",FragThresh);
			}					
			break;
		case OID_802_11_RTS_THRESHOLD:
			if (wrq->u.data.length != sizeof(NDIS_802_11_RTS_THRESHOLD)) 
				Status = -EINVAL;
			else
			{
				copy_from_user(&RtsThresh, wrq->u.data.pointer, wrq->u.data.length);
				if (RtsThresh > MAX_RTS_THRESHOLD)
					Status = -EINVAL;
				else
					pAdapter->PortCfg.RtsThreshold = (USHORT)RtsThresh;
				DBGPRINT(RT_DEBUG_TRACE, "Set::OID_802_11_RTS_THRESHOLD (=%d)\n",RtsThresh);
			}
			break;
		case RT_OID_802_11_PREAMBLE:
			if (wrq->u.data.length != sizeof(RT_802_11_PREAMBLE)) 
				Status = -EINVAL;
			else
			{
				copy_from_user(&Preamble, wrq->u.data.pointer, wrq->u.data.length);
				if (Preamble == Rt802_11PreambleShort)
					MlmeSetTxPreamble(pAdapter, Rt802_11PreambleShort);
			    else 
				    MlmeSetTxPreamble(pAdapter, Rt802_11PreambleLong);
			}
			//RestartAPIsRequired = TRUE;
			DBGPRINT(RT_DEBUG_TRACE, "Set::RT_OID_802_11_PREAMBLE (=%d)\n", Preamble);
			break;
		case OID_802_11_RX_ANTENNA_SELECTED:
			if (wrq->u.data.length != sizeof(NDIS_802_11_ANTENNA)) 
				Status = -EINVAL;
			else
			{
				copy_from_user(&Antenna, wrq->u.data.pointer, wrq->u.data.length);
				if(Antenna == 0xFFFFFFFF) 
				{// Diversity
					pAdapter->PortCfg.CurrentRxAntenna = (UCHAR)Antenna;
					RTMP_BBP_IO_READ32_BY_REG_ID(pAdapter, BBP_Rx_Configure, &RxValue);
					RxValue = (RxValue & 0xFC) | 0x01;
					RTMP_BBP_IO_WRITE32_BY_REG_ID(pAdapter, BBP_Rx_Configure, RxValue);
				}
				else if(Antenna >= pAdapter->PortCfg.NumberOfAntenna)
					Status = -EINVAL;
				else
				{
					pAdapter->PortCfg.CurrentRxAntenna = (UCHAR)Antenna;

					RTMP_BBP_IO_READ32_BY_REG_ID(pAdapter, BBP_Rx_Configure, &RxValue);
					if(Antenna == 0)
					{// Antenna A
						RxValue = (RxValue & 0xFC) | 0x00;
					}
					else if(Antenna == 1)
					{// Antenna B
						RxValue = (RxValue & 0xFC) | 0x02;
					}
					RTMP_BBP_IO_WRITE32_BY_REG_ID(pAdapter, BBP_Rx_Configure, RxValue);
				}
			}
			DBGPRINT(RT_DEBUG_TRACE, "Set::OID_802_11_RX_ANTENNA_SELECTED (=%d)\n",Antenna);
			break;
		case OID_802_11_TX_ANTENNA_SELECTED:
			if (wrq->u.data.length != sizeof(NDIS_802_11_ANTENNA)) 
				Status = -EINVAL;
			else
			{
				ULONG BbpCsr1;

				RTMP_IO_READ32(pAdapter, BBPCSR1, &BbpCsr1);
				copy_from_user(&Antenna, wrq->u.data.pointer, wrq->u.data.length);
				if (Antenna == 0xFFFFFFFF) // Diversity
				{
					pAdapter->PortCfg.CurrentTxAntenna = (UCHAR)Antenna;
					RTMP_BBP_IO_READ32_BY_REG_ID(pAdapter, BBP_Tx_Configure, &TxValue);
					TxValue = (TxValue & 0xFC) | 0x01;
					RTMP_BBP_IO_WRITE32_BY_REG_ID(pAdapter, BBP_Tx_Configure, TxValue);
					BbpCsr1 = (BbpCsr1 & 0xFFFCFFFC) | 0x00010001;
					RTMP_IO_WRITE32(pAdapter, BBPCSR1, BbpCsr1);
				}
				else if (Antenna >= pAdapter->PortCfg.NumberOfAntenna)
					Status = -EINVAL;
				else
				{
					pAdapter->PortCfg.CurrentTxAntenna = (UCHAR)Antenna;

					RTMP_BBP_IO_READ32_BY_REG_ID(pAdapter, BBP_Tx_Configure, &TxValue);
					if(Antenna == 0) // Antenna A
					{
						TxValue = (TxValue & 0xFC) | 0x00;
						BbpCsr1 = (BbpCsr1 & 0xFFFCFFFC) | 0x00000000;
					}
					else if(Antenna == 1) // Antenna B
					{
						TxValue = (TxValue & 0xFC) | 0x02;
						BbpCsr1 = (BbpCsr1 & 0xFFFCFFFC) | 0x00020002;
					}
					RTMP_BBP_IO_WRITE32_BY_REG_ID(pAdapter, BBP_Tx_Configure, TxValue);
					RTMP_IO_WRITE32(pAdapter, BBPCSR1, BbpCsr1);
				}
			}
			DBGPRINT(RT_DEBUG_TRACE, "Set::OID_802_11_TX_ANTENNA_SELECTED (=0x%08x) \n",Antenna);
			break;
		case OID_802_11_CONFIGURATION:
			if (wrq->u.data.length != sizeof(NDIS_802_11_CONFIGURATION))
				Status = -EINVAL;
			else
			{
				copy_from_user(&Configuration, wrq->u.data.pointer, wrq->u.data.length);
				pAdapter->PortCfg.BeaconPeriod = (USHORT) Configuration.BeaconPeriod;
				//pAdapter->PortCfg.AtimWin = (USHORT) Configuration.ATIMWindow;
				if (Configuration.DSConfig == 2484000)
					pAdapter->PortCfg.Channel = 14;
				else if (Configuration.DSConfig >= 2412000 && Configuration.DSConfig < 2484000) 
					pAdapter->PortCfg.Channel = (UCHAR)((Configuration.DSConfig - 2412000) / 5000) + 1;
				else
					Status = -EINVAL;

				RestartAPIsRequired = TRUE;
			}
		    DBGPRINT(RT_DEBUG_TRACE, "Set::OID_802_11_CONFIGURATION (BeacnPeriod=%d,AtimW=%d,Ch=%d)\n",
		        Configuration.BeaconPeriod, Configuration.ATIMWindow, pAdapter->PortCfg.Channel);
		    break;
		case RT_OID_802_11_PHY_MODE:
			copy_from_user(&phymode, wrq->u.data.pointer, wrq->u.data.length);
			if (phymode != pAdapter->PortCfg.PhyMode)
			{
				RTMPSetPhyMode(pAdapter, phymode);
				RestartAPIsRequired = TRUE;
			}
			DBGPRINT(RT_DEBUG_TRACE, "Set::RT_OID_802_11_PHY_MODE (=%d)\n", phymode);
			break;
		case OID_802_11_DESIRED_RATES:
			if (wrq->u.data.length != sizeof(NDIS_802_11_RATES))
				Status = -EINVAL;
			else 
			{
				NdisZeroMemory(pAdapter->PortCfg.DesiredRates, MAX_LEN_OF_SUPPORTED_RATES);
				copy_from_user(pAdapter->PortCfg.DesiredRates, wrq->u.data.pointer, wrq->u.data.length);						
				DBGPRINT(RT_DEBUG_TRACE, "Set::OID_802_11_DESIRED_RATES (%02x,%02x,%02x,%02x,%02x,%02x,%02x,%02x)\n", 
					pAdapter->PortCfg.DesiredRates[0],pAdapter->PortCfg.DesiredRates[1],
					pAdapter->PortCfg.DesiredRates[2],pAdapter->PortCfg.DesiredRates[3],
					pAdapter->PortCfg.DesiredRates[4],pAdapter->PortCfg.DesiredRates[5],
					pAdapter->PortCfg.DesiredRates[6],pAdapter->PortCfg.DesiredRates[7] );
				MlmeUpdateTxRates(pAdapter);
			}
			break;
        case RT_OID_802_11_RADIUS_DATA:
	    {
                DBGPRINT(DEBUG_TEMP, "  SET :: RT_OID_802_11_RADIUS_DATA !!!!!!!!!!!!!      \n");
                DBGPRINT(DEBUG_TEMP, " wrq->u.data.length = %d = 0x%x \n",wrq->u.data.length,wrq->u.data.length);
                DBGPRINT(DEBUG_TEMP, " wrq->u.data = %x %x \n",*(wrq->u.data.pointer+12),*(wrq->u.data.pointer+13));

                if (pAdapter->PortCfg.AuthMode == Ndis802_11AuthModeWPA)
                    WpaSend(pAdapter, wrq->u.data.pointer, wrq->u.data.length);                
            break;
        }
		case RT_OID_802_11_WPA_REKEY:
            if (pAdapter->PortCfg.AuthMode < Ndis802_11AuthModeWPA)
            {
                if(pAdapter->PortCfg.REKEYTimerRunning == TRUE)
                {
                    del_timer_sync(&pAdapter->PortCfg.REKEYTimer);
                    pAdapter->PortCfg.REKEYTimerRunning = FALSE;
                }
                break;
            }
            copy_from_user(&WPA_REKEY, wrq->u.data.pointer, wrq->u.data.length);
            // mechanism for rekeying: 0:disable, 1: time-based, 2: packet-based
            if (WPA_REKEY.ReKeyMethod >MAX_REKEY)
                Status = -EINVAL;
            else if (WPA_REKEY.ReKeyInterval > MAX_REKEY_INTER)
                Status = -EINVAL;
            else if ((WPA_REKEY.ReKeyMethod == DISABLE_REKEY) ||(WPA_REKEY.ReKeyInterval == 0))
            {
                DBGPRINT(RT_DEBUG_TRACE, "  DISABLE WPA_REKEY      \n");
                pAdapter->PortCfg.WPAREKEY.ReKeyInterval = WPA_REKEY.ReKeyInterval;                
                pAdapter->PortCfg.WPAREKEY.ReKeyMethod = DISABLE_REKEY;
                if(pAdapter->PortCfg.REKEYTimerRunning == TRUE)
                {
                    del_timer_sync(&pAdapter->PortCfg.REKEYTimer);
                    pAdapter->PortCfg.REKEYTimerRunning = FALSE;
                }
            }
            else if ((WPA_REKEY.ReKeyMethod == PKT_REKEY)    || (WPA_REKEY.ReKeyMethod == TIME_REKEY))  //packet-based
            {
                if(pAdapter->PortCfg.REKEYTimerRunning == FALSE)
                {
			        pAdapter->PortCfg.REKEYTimer.expires = jiffies + GUPDATE_EXEC_INTV;
			        add_timer(&pAdapter->PortCfg.REKEYTimer);
			        
                    pAdapter->PortCfg.REKEYTimerRunning = TRUE;
                    pAdapter->PortCfg.REKEYCOUNTER = 0;
                }
                pAdapter->PortCfg.WPAREKEY.ReKeyInterval = WPA_REKEY.ReKeyInterval;
                pAdapter->PortCfg.WPAREKEY.ReKeyMethod = WPA_REKEY.ReKeyMethod;                    
            }                         
            DBGPRINT(RT_DEBUG_TRACE, "Set::RT_OID_802_11_SET_WPA_REKEY , ReKeyMethod= %x  , interval= %x    \n",WPA_REKEY.ReKeyMethod,WPA_REKEY.ReKeyInterval);
            break;
#if 0
		case RT_OID_802_11_WDS:
			copy_from_user(&Wds, wrq->u.data.pointer, sizeof(RT_802_11_WDS));
			pAdapter->WdsTab.Num = Wds.Num;
			for(i = 0; i < pAdapter->WdsTab.Num; i++)
			{
				NdisMoveMemory(&pAdapter->WdsTab.WdsEntry[i].WdsAddr[0], &Wds.Entry[i], MAC_ADDR_LEN);
				DBGPRINT(RT_DEBUG_TRACE,"WDS-AP(%d)-%02x:%02x:%02x:%02x:%02x:%02x\n", i,
	                pAdapter->WdsTab.WdsEntry[i].WdsAddr[0], pAdapter->WdsTab.WdsEntry[i].WdsAddr[1], pAdapter->WdsTab.WdsEntry[i].WdsAddr[2], 
	                pAdapter->WdsTab.WdsEntry[i].WdsAddr[3], pAdapter->WdsTab.WdsEntry[i].WdsAddr[4], pAdapter->WdsTab.WdsEntry[i].WdsAddr[5]);
			}

			NdisZeroMemory(&pAdapter->WdsTab.Wpa_key, sizeof(WPA_KEY));
			NdisMoveMemory(&pAdapter->WdsTab.Wpa_key.Key, &Wds.KeyMaterial[0], 16);
			pAdapter->WdsTab.Wpa_key.KeyLen = 16;
			NdisMoveMemory(&pAdapter->WdsTab.Wpa_key.RxMic, &Wds.KeyMaterial[16], 8);
			NdisMoveMemory(&pAdapter->WdsTab.Wpa_key.TxMic, &Wds.KeyMaterial[24], 8);
			DBGPRINT(RT_DEBUG_TRACE,"Set::RT_OID_802_11_WDS (num=%d, keylen=%d)\n", pAdapter->WdsTab.Num, Wds.KeyLength);
#ifdef RT2500_DBG
			DBGPRINT(RT_DEBUG_TRACE, "Wpa_key=>\n");
			for (i=0; i<16; i++)
				printk("%02x:", pAdapter->WdsTab.Wpa_key.Key[i]);
			DBGPRINT(RT_DEBUG_TRACE, "\nRxMic Key=>\n");
			for (i=0; i<8; i++)
				printk("%02x:", pAdapter->WdsTab.Wpa_key.RxMic[i]);
			DBGPRINT(RT_DEBUG_TRACE, "\nTxMic Key=>\n");
			for (i=0; i<8; i++)
				printk("%02x:", pAdapter->WdsTab.Wpa_key.TxMic[i]);
			printk("\n");
#endif
			break;
#endif
		default:
			DBGPRINT(RT_DEBUG_TRACE, "Set::unknown IOCTL's subcmd = 0x%08x\n", cmd);
			Status = -EOPNOTSUPP;
			break;
	}

	if (RestartAPIsRequired) 
    {
        ApStop(pAdapter);
        ApStartUp(pAdapter);
    }
	
	return Status;
}

INT RTMPQueryInformation(
	IN	PRTMP_ADAPTER       pAdapter,
	IN	OUT	struct ifreq    *rq,
	IN	INT                 cmd)
{
	struct iwreq						*wrq = (struct iwreq *) rq;
    INT									Status = NDIS_STATUS_SUCCESS;
    ULONG								ulInfo = 0;
    NDIS_802_11_CONFIGURATION			Configuration;
    RT_802_11_PREAMBLE					Preamble;
    RT_802_11_AP_CONFIG                 ApConfig;
    NDIS_802_11_WEP_STATUS				WepStatus;
    RT_802_11_LINK_STATUS               LinkStatus;
    NDIS_802_11_SSID					Ssid;
    NDIS_802_11_MAC_ADDRESS             Bssid;
    RT_802_11_MAC_TABLE                 MacTab;
    NDIS_802_11_STATISTICS              Statistics;
    RT_VERSION_INFO						DriverVersionInfo;
    ULONG								FcsValue;
    UINT                                i;

	switch(cmd) {
		case RT_OID_DEVICE_NAME:
			DBGPRINT(RT_DEBUG_TRACE, "Query::RT_OID_DEVICE_NAME\n");
			wrq->u.data.length = sizeof(NIC_DEVICE_NAME);
			copy_to_user(wrq->u.data.pointer, NIC_DEVICE_NAME, wrq->u.data.length);
			break;
		case RT_OID_VERSION_INFO:
            DBGPRINT(RT_DEBUG_INFO, "Query::RT_OID_VERSION_INFO \n");
            DriverVersionInfo.DriverVersionW = 1;
            DriverVersionInfo.DriverVersionX = 4;
            DriverVersionInfo.DriverVersionY = 2;
            DriverVersionInfo.DriverVersionZ = 0;
            DriverVersionInfo.DriverBuildYear = 2004;
            DriverVersionInfo.DriverBuildMonth = 3;
            DriverVersionInfo.DriverBuildDay = 19;
            wrq->u.data.length = sizeof(RT_VERSION_INFO);
            copy_to_user(wrq->u.data.pointer, &DriverVersionInfo, wrq->u.data.length);
            break;
		case OID_GEN_RCV_NO_BUFFER:
			DBGPRINT(RT_DEBUG_INFO, "Query::OID_GEN_RCV_NO_BUFFER \n");
			ulInfo = pAdapter->Counters.RxNoBuffer;
			wrq->u.data.length = sizeof(ulInfo);
			copy_to_user(wrq->u.data.pointer, &ulInfo, wrq->u.data.length);
			break;
		case OID_GEN_RCV_OK:
			DBGPRINT(RT_DEBUG_INFO, "Query::OID_GEN_RCV_OK \n");
			ulInfo = pAdapter->Counters.GoodReceives;
			wrq->u.data.length = sizeof(ulInfo);
			copy_to_user(wrq->u.data.pointer, &ulInfo, wrq->u.data.length);
			break;
		case OID_802_11_STATISTICS:
			DBGPRINT(RT_DEBUG_TRACE, "Query::OID_802_11_STATISTICS \n");
			// Update FCS counters
		    RTMP_IO_READ32(pAdapter, CNT0, &FcsValue);
		    pAdapter->WlanCounters.FCSErrorCount += FcsValue;
		    
			// Sanity check for calculation of sucessful count
			if (pAdapter->WlanCounters.TransmittedFragmentCount < pAdapter->WlanCounters.RetryCount)
				pAdapter->WlanCounters.TransmittedFragmentCount = pAdapter->WlanCounters.RetryCount;

			Statistics.TransmittedFragmentCount = pAdapter->WlanCounters.TransmittedFragmentCount;
			Statistics.MulticastTransmittedFrameCount = pAdapter->WlanCounters.MulticastTransmittedFrameCount;
			Statistics.FailedCount = pAdapter->WlanCounters.FailedCount;
			Statistics.RetryCount = pAdapter->WlanCounters.RetryCount;
			Statistics.MultipleRetryCount = pAdapter->WlanCounters.MultipleRetryCount;
			Statistics.RTSSuccessCount = pAdapter->WlanCounters.RTSSuccessCount;
			Statistics.RTSFailureCount = pAdapter->WlanCounters.RTSFailureCount;
			Statistics.ACKFailureCount = pAdapter->WlanCounters.ACKFailureCount;
			Statistics.FrameDuplicateCount = pAdapter->WlanCounters.FrameDuplicateCount;
			Statistics.ReceivedFragmentCount = pAdapter->WlanCounters.ReceivedFragmentCount;
			Statistics.MulticastReceivedFrameCount = pAdapter->WlanCounters.MulticastReceivedFrameCount;
			Statistics.FCSErrorCount = pAdapter->WlanCounters.FCSErrorCount;
		    wrq->u.data.length = sizeof(NDIS_802_11_STATISTICS);
			copy_to_user(wrq->u.data.pointer, &Statistics, wrq->u.data.length);
			break;
		case RT_OID_802_11_EVENT_TABLE:
			if (wrq->u.data.length != sizeof(RT_802_11_EVENT_TABLE))
				Status = -EINVAL;
			else 
			{
				wrq->u.data.length = sizeof(RT_802_11_EVENT_TABLE);
				copy_to_user(wrq->u.data.pointer, &pAdapter->EventTab, wrq->u.data.length);

				DBGPRINT(RT_DEBUG_TRACE, "Query::RT_OID_802_11_EVENT_TABLE\n");

				// pAd->EventTab is read-and-clear
				NdisZeroMemory(&pAdapter->EventTab, sizeof(RT_802_11_EVENT_TABLE));
			}
			break;
		case RT_OID_802_11_MAC_TABLE:
			MacTab.Num=0;
			for (i=0; i<MAX_LEN_OF_MAC_TABLE; i++)
			{
				if (pAdapter->MacTab.Content[i].Valid && (pAdapter->MacTab.Content[i].Sst == SST_ASSOC))
				{
					COPY_MAC_ADDR(MacTab.Entry[MacTab.Num].Addr, &pAdapter->MacTab.Content[i].Addr);
					MacTab.Entry[MacTab.Num].Aid = (UCHAR)pAdapter->MacTab.Content[i].Aid;
					MacTab.Entry[MacTab.Num].Psm = pAdapter->MacTab.Content[i].PsMode;
					MacTab.Num += 1;
				}
			}				
			wrq->u.data.length=sizeof(RT_802_11_MAC_TABLE);
			copy_to_user(wrq->u.data.pointer, &MacTab, wrq->u.data.length);
			DBGPRINT(RT_DEBUG_TRACE, "Query::RT_OID_802_11_MAC_TABLE \n");
			break;
		case OID_802_11_BSSID:
			COPY_MAC_ADDR(&Bssid, &pAdapter->PortCfg.Bssid);
			wrq->u.data.length=sizeof(NDIS_802_11_MAC_ADDRESS);
			copy_to_user(wrq->u.data.pointer, &Bssid, wrq->u.data.length);
		    DBGPRINT(RT_DEBUG_TRACE, "Query::OID_802_11_BSSID (=%02x:%02x:%02x:%02x:%02x:%02x)\n",
							Bssid[0],Bssid[1],Bssid[2],Bssid[3],Bssid[4],Bssid[5]);					
			break;
		case OID_802_11_SSID:
			Ssid.SsidLength = pAdapter->PortCfg.SsidLen;
			NdisZeroMemory(Ssid.Ssid, MAX_LEN_OF_SSID);
			NdisMoveMemory(Ssid.Ssid, pAdapter->PortCfg.Ssid, Ssid.SsidLength);
			wrq->u.data.length=sizeof(NDIS_802_11_SSID);
			copy_to_user(wrq->u.data.pointer, &Ssid, wrq->u.data.length);
			DBGPRINT(RT_DEBUG_TRACE, "Query::OID_802_11_SSID (Len=%d, ssid=%s)\n", Ssid.SsidLength,Ssid.Ssid);
			break;
		case OID_802_11_RSSI:
			ulInfo = pAdapter->PortCfg.LastRssi - RSSI_TO_DBM_OFFSET;
			wrq->u.data.length=sizeof(ulInfo);
			copy_to_user(wrq->u.data.pointer, &ulInfo, wrq->u.data.length);
			DBGPRINT(RT_DEBUG_INFO, "Query::OID_802_11_RSSI \n");
			break;
		case OID_GEN_MEDIA_CONNECT_STATUS:
			ulInfo = NdisMediaStateConnected; 
			wrq->u.data.length=sizeof(ulInfo);
			copy_to_user(wrq->u.data.pointer, &ulInfo, wrq->u.data.length);
			DBGPRINT(RT_DEBUG_INFO, "Query::OID_GEN_MEDIA_CONNECT_STATUS \n");
			break;
		case RT_OID_802_11_LINK_STATUS:
			LinkStatus.CurrTxRate = RateIdTo500Kbps[pAdapter->PortCfg.TxRate];   // unit : 500 kbps
			LinkStatus.ChannelQuality = pAdapter->Mlme.ChannelQuality;
			LinkStatus.RxByteCount = pAdapter->RalinkCounters.ReceivedByteCount;
			LinkStatus.TxByteCount = pAdapter->RalinkCounters.TransmittedByteCount;							
			wrq->u.data.length = sizeof(RT_802_11_LINK_STATUS);
			copy_to_user(wrq->u.data.pointer, &LinkStatus, wrq->u.data.length);
			DBGPRINT(RT_DEBUG_TRACE, "Query::RT_OID_802_11_LINK_STATUS\n");
			break;
		case OID_802_3_CURRENT_ADDRESS:
			wrq->u.data.length = ETH_LENGTH_OF_ADDRESS;
			copy_to_user(wrq->u.data.pointer, &pAdapter->CurrentAddress, wrq->u.data.length);
			DBGPRINT(RT_DEBUG_INFO, "Query::OID_802_3_CURRENT_ADDRESS \n");
			break;
		case OID_802_11_WEP_STATUS:
			WepStatus = pAdapter->PortCfg.WepStatus;
			wrq->u.data.length = sizeof(NDIS_802_11_WEP_STATUS);
			copy_to_user(wrq->u.data.pointer, &WepStatus, wrq->u.data.length);
			DBGPRINT(RT_DEBUG_TRACE, "Query::OID_802_11_WEP_STATUS (=%d)\n", WepStatus);
			break;
		case OID_802_11_AUTHENTICATION_MODE:					
			wrq->u.data.length = sizeof(pAdapter->PortCfg.AuthMode);
			copy_to_user(wrq->u.data.pointer, &pAdapter->PortCfg.AuthMode, wrq->u.data.length);
			DBGPRINT(RT_DEBUG_TRACE, "Query::OID_802_11_AUTHENTICATION_MODE (=%d)\n", pAdapter->PortCfg.AuthMode);
			break;
		case RT_OID_802_11_AP_CONFIG:
			ApConfig.EnableTxBurst = pAdapter->PortCfg.EnableTxBurst;
			ApConfig.EnableTurboRate = pAdapter->PortCfg.EnableTurboRate;
			ApConfig.IsolateInterStaTraffic = pAdapter->PortCfg.IsolateInterStaTraffic;
			ApConfig.HideSsid = pAdapter->PortCfg.HideSsid;
			ApConfig.UseBGProtection = pAdapter->PortCfg.UseBGProtection;
			ApConfig.UseShortSlotTime = pAdapter->PortCfg.UseShortSlotTime;
			ApConfig.Rsv1 = 0;
			ApConfig.SystemErrorBitmap = pAdapter->PortCfg.SystemErrorBitmap;
			wrq->u.data.length = sizeof(RT_802_11_AP_CONFIG);
			copy_to_user(wrq->u.data.pointer, &ApConfig, wrq->u.data.length);
			DBGPRINT(RT_DEBUG_TRACE, "Query::RT_OID_802_11_AP_CONFIG\n");
			break;
		case OID_802_11_FRAGMENTATION_THRESHOLD:
			ulInfo = pAdapter->PortCfg.FragmentThreshold;
			if (pAdapter->PortCfg.bFragmentZeroDisable == TRUE)
				ulInfo = 0;
			wrq->u.data.length = sizeof(ulInfo);
			copy_to_user(wrq->u.data.pointer, &ulInfo, wrq->u.data.length);
			DBGPRINT(RT_DEBUG_TRACE, "Query::OID_802_11_FRAGMENTATION_THRESHOLD (=%d)\n", ulInfo);
			break;
		case OID_802_11_RTS_THRESHOLD:
			ulInfo = pAdapter->PortCfg.RtsThreshold;
			wrq->u.data.length = sizeof(ulInfo);
			copy_to_user(wrq->u.data.pointer, &ulInfo, wrq->u.data.length);
			DBGPRINT(RT_DEBUG_TRACE, "Query::OID_802_11_RTS_THRESHOLD (=%d)\n", ulInfo);
			break;
		case RT_OID_802_11_PREAMBLE:
			Preamble = pAdapter->PortCfg.TxPreamble;
			wrq->u.data.length = sizeof(RT_802_11_PREAMBLE);
			copy_to_user(wrq->u.data.pointer, &Preamble, wrq->u.data.length);
			DBGPRINT(RT_DEBUG_TRACE, "Query::RT_OID_802_11_PREAMBLE (=%d)\n", Preamble);
			break;
		case OID_802_11_RX_ANTENNA_SELECTED:
			if (pAdapter->PortCfg.CurrentRxAntenna == 0xff)
				ulInfo = 0xffffffff;
			else
				ulInfo = pAdapter->PortCfg.CurrentRxAntenna;
			wrq->u.data.length = sizeof(ulInfo);
			copy_to_user(wrq->u.data.pointer, &ulInfo, wrq->u.data.length);
			DBGPRINT(RT_DEBUG_TRACE, "Query::OID_802_11_RX_ANTENNA_SELECTED (=%d)\n", ulInfo);
			break;

		case OID_802_11_TX_ANTENNA_SELECTED:
			if (pAdapter->PortCfg.CurrentTxAntenna == 0xff)
				ulInfo = 0xffffffff;
			else
				ulInfo = pAdapter->PortCfg.CurrentTxAntenna;
			wrq->u.data.length = sizeof(ulInfo);
			copy_to_user(wrq->u.data.pointer, &ulInfo, wrq->u.data.length);
			DBGPRINT(RT_DEBUG_TRACE, "Query::OID_802_11_TX_ANTENNA_SELECTED (=0x%08x)\n", ulInfo);
			break;
		case OID_802_11_NUMBER_OF_ANTENNAS:
			ulInfo = pAdapter->PortCfg.NumberOfAntenna;
			wrq->u.data.length = sizeof(ulInfo);
			copy_to_user(wrq->u.data.pointer, &ulInfo, wrq->u.data.length);
			DBGPRINT(RT_DEBUG_TRACE, "Query::OID_802_11_NUMBER_OF_ANTENNAS (=%d)\n", ulInfo);
			break;
		case OID_802_11_CONFIGURATION:
			Configuration.Length = sizeof(NDIS_802_11_CONFIGURATION);
			Configuration.BeaconPeriod = pAdapter->PortCfg.BeaconPeriod;
			Configuration.ATIMWindow = 0; //Configuration.ATIMWindow = pAdapter->PortCfg.AtimWin;
			if (pAdapter->PortCfg.Channel == 14)
				Configuration.DSConfig = 2484000;
			else
				Configuration.DSConfig = 2412000 + (pAdapter->PortCfg.Channel - 1) * 5000;

			DBGPRINT(RT_DEBUG_TRACE, "Query::OID_802_11_CONFIGURATION (BeaconPeriod=%d,AtimW=%d,Channel=%d) \n",
						Configuration.BeaconPeriod, Configuration.ATIMWindow, pAdapter->PortCfg.Channel);
			wrq->u.data.length = sizeof(NDIS_802_11_CONFIGURATION);
			copy_to_user(wrq->u.data.pointer, &Configuration, wrq->u.data.length);
			break;
		case RT_OID_802_11_PHY_MODE:					
			ulInfo = (ULONG)pAdapter->PortCfg.PhyMode;
			wrq->u.data.length = sizeof(ulInfo);
			copy_to_user(wrq->u.data.pointer, &ulInfo, wrq->u.data.length);
			DBGPRINT(RT_DEBUG_TRACE, "Query::RT_OID_802_11_PHY_MODE (=%d)\n", ulInfo);
			break;
		case RT_OID_802_11_WPA_REKEY:            
            wrq->u.data.length = sizeof(RT_802_11_WPA_REKEY);
            copy_to_user(wrq->u.data.pointer, &pAdapter->PortCfg.WPAREKEY, wrq->u.data.length);
            DBGPRINT(RT_DEBUG_TRACE, "Query :: RT_OID_802_11_QUERY_WPA_REKEY\n");
            break;
        case RT_OID_802_11_EEPROM_VERSION:
            wrq->u.data.length = sizeof(pAdapter->PortCfg.EepromVersion);
            copy_to_user(wrq->u.data.pointer, &pAdapter->PortCfg.EepromVersion, wrq->u.data.length);
            DBGPRINT(RT_DEBUG_TRACE, "Query::RT_OID_802_11_EEPROM_VERSION (=%d)\n", pAdapter->PortCfg.EepromVersion);
            break;
		default:
			DBGPRINT(RT_DEBUG_TRACE, "Query::unknown IOCTL's subcmd = 0x%08x\n", cmd);
			Status = -EOPNOTSUPP;
			break;
	}
	
	return Status;
}

INT RT2500_ioctl(
	IN	struct net_device	*net_dev, 
	IN	OUT	struct ifreq	*rq, 
	IN	INT					cmd)
{
	PRTMP_ADAPTER						pAdapter= net_dev->priv;
	struct iwreq						*wrq = (struct iwreq *) rq;
	NDIS_802_11_SSID                    Ssid;
	NDIS_802_11_RTS_THRESHOLD           RtsThresh;
	NDIS_802_11_FRAGMENTATION_THRESHOLD FragThresh;
	BOOLEAN								RestartAPIsRequired = FALSE;
	INT									testmode, Status = NDIS_STATUS_SUCCESS;
	USHORT								subcmd;
	ULONG								ulInfo = 0;	

	if(!RTMP_TEST_FLAG(pAdapter, fRTMP_ADAPTER_INTERRUPT_IN_USE))
	{
		DBGPRINT(RT_DEBUG_TRACE, "INFO::Network is down!\n");
		return -ENETDOWN;
	}

	switch(cmd) {
        case SIOCGIFHWADDR:
			DBGPRINT(RT_DEBUG_ERROR, "IOCTLIOCTLIOCTL::SIOCGIFHWADDR\n");
			strcpy(wrq->u.name, pAdapter->CurrentAddress);   
			break;
		case SIOCGIWNAME:
			DBGPRINT(RT_DEBUG_TRACE, "IOCTL::SIOCGIWNAME\n");
			strcpy(wrq->u.name, "RT2500 SoftAP");   
			break;
		case SIOCSIWESSID:  //Set ESSID
			{
				struct iw_point *erq = &wrq->u.essid;

				memset(&Ssid, 0x00, sizeof(NDIS_802_11_SSID));

				if (erq->flags) 
				{
					if (erq->length > IW_ESSID_MAX_SIZE)
					{
						Status = -E2BIG;
						break;
					}

					if (copy_from_user(Ssid.Ssid, erq->pointer, erq->length-1))
					{
						Status = -EFAULT;
						break;
					}

					Ssid.SsidLength = erq->length-1;	 //minus null character.					
				}
				else
				{ //Any ssid
					NdisMoveMemory(Ssid.Ssid, "RT2500SoftAP-", 7);
					Ssid.Ssid[7] = (((pAdapter->CurrentAddress[5] >> 4) > 9) ? ((pAdapter->CurrentAddress[5] >> 4) - 10 + 'A') : ((pAdapter->CurrentAddress[5] >> 4) + '0'));
					Ssid.Ssid[8] = (((pAdapter->CurrentAddress[5] & 0x0F) > 9) ? ((pAdapter->CurrentAddress[5]& 0x0F) - 10 + 'A') : ((pAdapter->CurrentAddress[5]& 0x0F) + '0'));
					Ssid.SsidLength = 9;
				}

				NdisZeroMemory(pAdapter->PortCfg.Ssid, MAX_LEN_OF_SSID);
				NdisMoveMemory(pAdapter->PortCfg.Ssid, Ssid.Ssid, Ssid.SsidLength);
				pAdapter->PortCfg.SsidLen = (UCHAR) Ssid.SsidLength;
				RestartAPIsRequired = TRUE;
				DBGPRINT(RT_DEBUG_TRACE, "IOCTL::SIOCSIWESSID (Len=%d,Ssid=%s)\n", pAdapter->PortCfg.SsidLen, pAdapter->PortCfg.Ssid);	
				DBGPRINT(RT_DEBUG_TRACE, "IOCTL::SIOCSIWESSID (Len=%d,Ssid=%s)\n", pAdapter->PortCfg.SsidLen, pAdapter->PortCfg.Ssid);	
				break;
			}
		case SIOCGIWESSID:  //Get ESSID
			{
				char *essid = NULL;
				struct iw_point *erq = &wrq->u.essid;

				erq->flags=1;
				erq->length = pAdapter->PortCfg.SsidLen;

				if(erq->pointer)
				{
					if(copy_to_user(erq->pointer, pAdapter->PortCfg.Ssid, erq->length))
					{
						Status = -EFAULT;
						break;
					}
				}
				DBGPRINT(RT_DEBUG_TRACE, "IOCTL::SIOCGIWESSID (Len=%d, ssid=%s...)\n", erq->length, erq->pointer);
			}
			break;
		case SIOCGIWNWID: // get network id 
			Status = -EOPNOTSUPP;
			break;
		case SIOCSIWNWID: // set network id (the cell)
			Status = -EOPNOTSUPP;
			break;
		case SIOCGIWFREQ: // get channel/frequency (Hz)
			wrq->u.freq.m = pAdapter->PortCfg.Channel;
			wrq->u.freq.e = 0;
			wrq->u.freq.i = 0;
			break; 
		case SIOCSIWFREQ: //set channel/frequency (Hz)
			{
				struct iw_freq *frq = &wrq->u.freq;
				int chan = -1;

				if((frq->e == 0) && (frq->m <= 1000))
				{
					// Setting by channel number
					chan = frq->m;
				}
				else
				{
					// Setting by frequency - search the table
					int mult = 1;
					int i;

					for(i = 0; i < (6 - frq->e); i++)
						mult *= 10;

					for(i = 0; i < NUM_CHANNELS; i++)
						if(frq->m == (channel_frequency[i] * mult))
							chan = i+1;
				}

				pAdapter->PortCfg.Channel = chan;
				RestartAPIsRequired = TRUE;
				DBGPRINT(RT_DEBUG_TRACE, "IOCTL::SIOCSIWFREQ (Channel=%d)\n", pAdapter->PortCfg.Channel);				
			}
			break;
		case SIOCGIWNICKN:
			{
				struct iw_point *erq = &wrq->u.data;

				erq->length = strlen(pAdapter->nickn);
				if(copy_to_user(erq->pointer, pAdapter->nickn, erq->length))
					Status = -EFAULT;
			}
			break;
		case SIOCSIWNICKN: //set node name/nickname
			{
				struct iw_point *erq = &wrq->u.data;
				char nickn[IW_ESSID_MAX_SIZE+1];

				if (erq->flags) 
				{
					if (erq->length > IW_ESSID_MAX_SIZE)
					{
						Status = -E2BIG;
						break;
					}
					if (copy_from_user(nickn, erq->pointer, erq->length))
					{
						Status = -EFAULT;
						break;
					}
					strcpy(pAdapter->nickn, nickn);
					DBGPRINT(RT_DEBUG_TRACE, "IOCTL::SIOCSIWNICKN(=%s)\n", pAdapter->nickn);
				}
			}	
			break;
		case SIOCGIWRATE:  //get default bit rate (bps)
			wrq->u.bitrate.value = RateIdTo500Kbps[pAdapter->PortCfg.TxRate] * 500000;
			wrq->u.bitrate.disabled = 0;
			break;
		case SIOCSIWRATE:  //set default bit rate (bps)
			{
				int i;
				BOOLEAN  IsSupportRate = FALSE;
				
				for(i=0; i<NUM_RateIdTo500Kbps; i++)
				{
					if( wrq->u.bitrate.value == RateIdTo500Kbps[i] * 500000)
					{
						pAdapter->PortCfg.TxRate = i;
						IsSupportRate = TRUE;
						break;
					}
				}
	
				if( !IsSupportRate )
				{
					Status = -EINVAL;
					break;
				}
				else
					DBGPRINT(RT_DEBUG_TRACE, "IOCTL::SIOCSIWRATE (rates=%d)\n", pAdapter->PortCfg.TxRate);
			}
			break;
		case SIOCGIWRTS:  // get RTS/CTS threshold (bytes)
			wrq->u.rts.value = (INT) pAdapter->PortCfg.RtsThreshold;
			wrq->u.rts.disabled = (wrq->u.rts.value == MAX_RTS_THRESHOLD);
			wrq->u.rts.fixed = 1;
			DBGPRINT(RT_DEBUG_TRACE, "IOCTL::SIOCGIWRTS (=%d)\n",wrq->u.rts.value);
			break;
		case SIOCSIWRTS:  //set RTS/CTS threshold (bytes)
			RtsThresh = wrq->u.rts.value;
			if(wrq->u.rts.disabled)
				RtsThresh = MAX_RTS_THRESHOLD;
			if (RtsThresh > MAX_RTS_THRESHOLD || RtsThresh <= 0 )
			{
				Status = -EINVAL;
				break;
			}
			else
				pAdapter->PortCfg.RtsThreshold = (USHORT)RtsThresh;
			DBGPRINT(RT_DEBUG_TRACE, "IOCTL::SIOCSIWRTS (=%d)\n",RtsThresh);
			break;
		case SIOCGIWFRAG:  //get fragmentation thr (bytes)
			wrq->u.frag.value = pAdapter->PortCfg.FragmentThreshold;
			wrq->u.frag.disabled = (wrq->u.frag.value >= MAX_FRAG_THRESHOLD);
			wrq->u.frag.fixed = 1;
			DBGPRINT(RT_DEBUG_TRACE, "IOCTL::SIOCGIWFRAG (=%d)\n", wrq->u.frag.value);
			break;
		case SIOCSIWFRAG:  //set fragmentation thr (bytes)
			FragThresh = wrq->u.frag.value;
			if(wrq->u.frag.disabled)
				FragThresh = MAX_FRAG_THRESHOLD;

			if((FragThresh < MIN_FRAG_THRESHOLD) || (FragThresh > MAX_FRAG_THRESHOLD))
			{
				Status = -EINVAL;
				break;
			}
			else
			{
				pAdapter->PortCfg.FragmentThreshold = (USHORT)FragThresh;
				DBGPRINT(RT_DEBUG_TRACE, "IOCTL::SIOCSIWFRAG (=%d)\n", FragThresh);
			}
			break;
		case SIOCGIWENCODE:  //get encoding token & mode
			{
				int index = (wrq->u.encoding.flags & IW_ENCODE_INDEX) - 1;
				if ((index < 0) || (index >= NR_WEP_KEYS))
					index = pAdapter->PortCfg.DefaultKeyId;  	// Default key for tx (shared key)
				
				wrq->u.encoding.flags = (pAdapter->PortCfg.WepStatus ==  Ndis802_11WEPEnabled) ? IW_ENCODE_RESTRICTED : IW_ENCODE_OPEN;
				if(pAdapter->PortCfg.WepStatus ==  Ndis802_11WEPDisabled)
					wrq->u.encoding.flags |= IW_ENCODE_DISABLED;
				if(wrq->u.encoding.pointer)
				{
					wrq->u.encoding.length = pAdapter->PortCfg.SharedKey[index].KeyLen;
					if (copy_to_user(wrq->u.encoding.pointer, pAdapter->PortCfg.SharedKey[index].Key, pAdapter->PortCfg.SharedKey[index].KeyLen))
					{
						Status = -EFAULT;
						break;
					}
					wrq->u.encoding.flags |= (index + 1);
				}
			}
			break;
		case SIOCSIWENCODE:  //set encoding token & mode
			{
				int index = (wrq->u.encoding.flags & IW_ENCODE_INDEX) - 1;
				/* take the old default key if index is invalid */
				if((index < 0) || (index >= NR_WEP_KEYS))
					index = pAdapter->PortCfg.DefaultKeyId;  	// Default key for tx (shared key)
				if(wrq->u.encoding.pointer)
				{
					int len = wrq->u.encoding.length;

					if(len > WEP_LARGE_KEY_LEN)
						len = WEP_LARGE_KEY_LEN;

					memset(pAdapter->PortCfg.SharedKey[index].Key, 0, MAX_LEN_OF_KEY);
					if(copy_from_user(pAdapter->PortCfg.SharedKey[index].Key, wrq->u.encoding.pointer, len)) 
					{
						pAdapter->PortCfg.SharedKey[index].KeyLen = 0;
						Status = -EFAULT;
						break;
					}
					else
						pAdapter->PortCfg.SharedKey[index].KeyLen = (len <= WEP_SMALL_KEY_LEN ) ? WEP_SMALL_KEY_LEN : WEP_LARGE_KEY_LEN;
				}
				pAdapter->PortCfg.DefaultKeyId = (UCHAR) index;
                pAdapter->PortCfg.WepStatus = (wrq->u.encoding.flags & IW_ENCODE_DISABLED) ? 1 : 0;

				if (wrq->u.encoding.flags & IW_ENCODE_RESTRICTED)
					pAdapter->PortCfg.AuthMode = AUTH_MODE_KEY;
				if ((wrq->u.encoding.flags & IW_ENCODE_OPEN) || wrq->u.encoding.flags & IW_ENCODE_NOKEY)
					pAdapter->PortCfg.AuthMode = AUTH_MODE_OPEN;

				pAdapter->PortCfg.CapabilityInfo    = CAP_GENERATE((pAdapter->PortCfg.WepStatus != Ndis802_11EncryptionDisabled), 1, pAdapter->PortCfg.UseShortSlotTime);
				// re-built BEACON frame format
				AsicDisableSync(pAdapter);
				MakeBssBeacon(pAdapter);
				UpdateBeaconFrame(pAdapter);
				AsicEnableBssSync(pAdapter);
			}
			break;
		case SIOCGIWAP:  //get access point MAC addresses
			wrq->u.ap_addr.sa_family = ARPHRD_ETHER;
			memcpy(wrq->u.ap_addr.sa_data, &pAdapter->PortCfg.Bssid, ETH_ALEN);
			DBGPRINT(RT_DEBUG_TRACE, "IOCTL::SIOCGIWAP(=%02x:%02x:%02x:%02x:%02x:%02x)\n",
				pAdapter->PortCfg.Bssid.Octet[0],pAdapter->PortCfg.Bssid.Octet[1],pAdapter->PortCfg.Bssid.Octet[2],
				pAdapter->PortCfg.Bssid.Octet[3],pAdapter->PortCfg.Bssid.Octet[4],pAdapter->PortCfg.Bssid.Octet[5]);
			break;
		case SIOCSIWAP:  //set access point MAC addresses
			Status = -EOPNOTSUPP;   //SoftAP didn't support.
			break;
		case SIOCGIWMODE:  //get operation mode
			wrq->u.mode = IW_MODE_INFRA;   //SoftAP always on INFRA mode.
			break;
		case SIOCSIWMODE:  //set operation mode
			Status = -EOPNOTSUPP;   //SoftAP didn't support.
			break;
		case SIOCGIWSENS:   //get sensitivity (dBm)
		case SIOCSIWSENS:	//set sensitivity (dBm)
		case SIOCGIWPOWER:  //get Power Management settings
		case SIOCSIWPOWER:  //set Power Management settings
		case SIOCGIWTXPOW:  //get transmit power (dBm)
		case SIOCSIWTXPOW:  //set transmit power (dBm)
#if WIRELESS_EXT >= 12
		case SIOCGIWRETRY:  //get retry limits and lifetime
		case SIOCSIWRETRY:  //set retry limits and lifetime
#endif	//WIRELESS_EXT >= 12
			Status = -EOPNOTSUPP;
			break;
		case RT_PRIV_IOCTL:
			subcmd = wrq->u.data.flags;
			if( subcmd & OID_GET_SET_TOGGLE)
				Status = RTMPSetInformation(pAdapter, rq, subcmd);
			else
				Status = RTMPQueryInformation(pAdapter, rq, subcmd);
			break;
		case SIOCGIWPRIV:
			if (wrq->u.data.pointer) {
				if ( verify_area(VERIFY_WRITE, wrq->u.data.pointer, sizeof(privtab)) )
					break;
				wrq->u.data.length = sizeof(privtab) / sizeof(privtab[0]);
				if (copy_to_user(wrq->u.data.pointer, privtab, sizeof(privtab)))
					Status = -EFAULT;
			}
			break;
		case RTPRIV_IOCTL_SET:
			{				
				char *this_char;
				char *value;

				if( verify_area(VERIFY_READ, wrq->u.data.pointer, wrq->u.data.length) )
					break;

				while ((this_char = strsep(&wrq->u.data.pointer, ",")) != NULL) 
				{
					if (!*this_char)
						 continue;

					if ((value = strchr(this_char, '=')) != NULL)
						*value++ = 0;

					if (!value || !*value)
						continue;  							

					for (PRTMP_PRIVATE_SET_PROC = RTMP_PRIVATE_SUPPORT_PROC; PRTMP_PRIVATE_SET_PROC->name; PRTMP_PRIVATE_SET_PROC++)
					{
						if (!strcmp(this_char, PRTMP_PRIVATE_SET_PROC->name)) 
						{						
							if(!PRTMP_PRIVATE_SET_PROC->set_proc(pAdapter, value))
							{   //FALSE:Set private failed then return Invalid argument 								
								Status = -EINVAL;							
							}
							break;  //Exit for loop.
						}
					}

					if(PRTMP_PRIVATE_SET_PROC->name == NULL)
					{  //Not found argument
						Status = -EINVAL;
						DBGPRINT(RT_DEBUG_TRACE, "IOCTL::(iwpriv) Not Support Set Command [%s=%s]\n", this_char, value);
						break;
					}	
				}
			}
			break;
#ifdef RT2500_DBG
		case RTPRIV_IOCTL_BBP:
			RTMPIoctlBBP(pAdapter, wrq);
			break;
			
		case RTPRIV_IOCTL_MAC:
			RTMPIoctlMAC(pAdapter, wrq);
			break;

		case RTPRIV_IOCTL_E2P:
			RTMPIoctlE2PROM(pAdapter, wrq);
			break;

		case RTPRIV_IOCTL_STATISTICS:
		    RTMPIoctlStatistics(pAdapter, wrq);
		    break;
#endif
		default:
			DBGPRINT(RT_DEBUG_TRACE, "IOCTL::unknown IOCTL's cmd = 0x%08x\n", cmd);
			Status = -EOPNOTSUPP;
			break;
	}

	if(Status == NDIS_STATUS_SUCCESS)
	{
//		if((cmd == SIOCDEVPRIVATE) && (subcmd == RTLINUX_GET_OID_802_11_BSSID_LIST))
//            kfree(pBssidList);
	}
	
	if( RestartAPIsRequired )
	{
		ApStop(pAdapter);
		ApStartUp(pAdapter);
	}

	return Status;
}

/*
	========================================================================
	
	Routine Description:
		Change NIC PHY mode. Re-association may be necessary.

	Arguments:
		pAdapter						Pointer to our adapter
        phmode
		
	========================================================================
*/
VOID	RTMPSetPhyMode(
	IN	PRTMP_ADAPTER	pAdapter,
	IN  ULONG phymode)
{
    // if no change, do nothing
    if (pAdapter->PortCfg.PhyMode == phymode)
        return;
    
    pAdapter->PortCfg.PhyMode = (UCHAR)phymode;
    switch (phymode) {
        case PHY_11B:
            pAdapter->PortCfg.SupportedRates[0]  = 0x82;    // 1 mbps, in units of 0.5 Mbps, basic rate
            pAdapter->PortCfg.SupportedRates[1]  = 0x84;    // 2 mbps, in units of 0.5 Mbps, basic rate
            pAdapter->PortCfg.SupportedRates[2]  = 0x0B;    // 5.5 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.SupportedRates[3]  = 0x16;    // 11 mbps, in units of 0.5 Mbps, basic rate
            pAdapter->PortCfg.SupportedRatesLen  = 4;
            pAdapter->PortCfg.DesiredRates[0]  = 2;     // 1 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.DesiredRates[1]  = 4;     // 2 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.DesiredRates[2]  = 11;    // 5.5 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.DesiredRates[3]  = 22;    // 11 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.DesiredRates[4]  = 0;
            pAdapter->PortCfg.DesiredRates[5]  = 0;
            pAdapter->PortCfg.DesiredRates[6]  = 0;
            pAdapter->PortCfg.DesiredRates[7]  = 0;
            pAdapter->PortCfg.DesiredRates[8]  = 0;
            pAdapter->PortCfg.DesiredRates[9]  = 0;
            pAdapter->PortCfg.DesiredRates[10] = 0;
            pAdapter->PortCfg.DesiredRates[11] = 0;
            break;
        case PHY_11BG_MIXED:
            // 2004-1-12 to keep maximum compatibility with 802.11b-only clients, we should not turn on
            // BASIC RATE bit of any OFDM rates in outgoing BEACON and ProbrResponse frames
            pAdapter->PortCfg.SupportedRates[0]  = 0x82;    // 1 mbps, in units of 0.5 Mbps, basic rate
            pAdapter->PortCfg.SupportedRates[1]  = 0x84;    // 2 mbps, in units of 0.5 Mbps, basic rate
            pAdapter->PortCfg.SupportedRates[2]  = 0x8B;    // 5.5 mbps, in units of 0.5 Mbps, basic rate
            pAdapter->PortCfg.SupportedRates[3]  = 0x96;    // 11 mbps, in units of 0.5 Mbps, basic rate
            pAdapter->PortCfg.SupportedRates[4]  = 0x24;    // 18 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.SupportedRates[5]  = 0x30;    // 24 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.SupportedRates[6]  = 0x48;    // 36 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.SupportedRates[7]  = 0x6c;    // 54 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.SupportedRates[8]  = 0x0C;    // 6 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.SupportedRates[9]  = 0x12;    // 9 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.SupportedRates[10] = 0x18;    // 12 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.SupportedRates[11] = 0x60;    // 48 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.SupportedRatesLen  = 12;
            pAdapter->PortCfg.DesiredRates[0]  = 2;     // 1 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.DesiredRates[1]  = 4;     // 2 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.DesiredRates[2]  = 11;    // 5.5 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.DesiredRates[3]  = 22;    // 11 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.DesiredRates[4]  = 12;    // 6 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.DesiredRates[5]  = 18;    // 9 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.DesiredRates[6]  = 24;    // 12 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.DesiredRates[7]  = 36;    // 18 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.DesiredRates[8]  = 48;    // 24 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.DesiredRates[9]  = 72;    // 36 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.DesiredRates[10] = 96;    // 48 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.DesiredRates[11] = 108;   // 54 mbps, in units of 0.5 Mbps
            break;
        case PHY_11G:
            pAdapter->PortCfg.SupportedRates[0]  = 0x82;    // 1 mbps, in units of 0.5 Mbps, basic rate
            pAdapter->PortCfg.SupportedRates[1]  = 0x84;    // 2 mbps, in units of 0.5 Mbps, basic rate
            pAdapter->PortCfg.SupportedRates[2]  = 0x8B;    // 5.5 mbps, in units of 0.5 Mbps, basic rate
            pAdapter->PortCfg.SupportedRates[3]  = 0x96;    // 11 mbps, in units of 0.5 Mbps, basic rate
            pAdapter->PortCfg.SupportedRates[4]  = 0x24;    // 18 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.SupportedRates[5]  = 0xb0;    // 24 mbps, in units of 0.5 Mbps, basic rate
            pAdapter->PortCfg.SupportedRates[6]  = 0x48;    // 36 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.SupportedRates[7]  = 0x6c;    // 54 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.SupportedRates[8]  = 0x8C;    // 6 mbps, in units of 0.5 Mbps, basic rate
            pAdapter->PortCfg.SupportedRates[9]  = 0x12;    // 9 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.SupportedRates[10] = 0x98;    // 12 mbps, in units of 0.5 Mbps, basic rate
            pAdapter->PortCfg.SupportedRates[11] = 0x60;    // 48 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.SupportedRatesLen  = 12;
            pAdapter->PortCfg.DesiredRates[0]  = 2;     // 1 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.DesiredRates[1]  = 4;     // 2 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.DesiredRates[2]  = 11;    // 5.5 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.DesiredRates[3]  = 22;    // 11 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.DesiredRates[4]  = 12;    // 6 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.DesiredRates[5]  = 18;    // 9 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.DesiredRates[6]  = 24;    // 12 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.DesiredRates[7]  = 36;    // 18 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.DesiredRates[8]  = 48;    // 24 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.DesiredRates[9]  = 72;    // 36 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.DesiredRates[10] = 96;    // 48 mbps, in units of 0.5 Mbps
            pAdapter->PortCfg.DesiredRates[11] = 108;   // 54 mbps, in units of 0.5 Mbps
            break;
        default:
            break;
    }
    
    MlmeUpdateTxRates(pAdapter);
}

/* 
    ==========================================================================
    Description:
        Set Country Region
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT Set_CountryRegion_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	ULONG region;
	int   success = FALSE;
		
	region = simple_strtol(arg, 0, 10);
	if( (region >= REGION_MIN) && (region <= REGION_MAX) )
	{
		pAdapter->PortCfg.CountryRegion = (UCHAR) region;
		DBGPRINT(RT_DEBUG_TRACE, "Set_CountryRegion_Proc::(CountryRegion=%d)\n", pAdapter->PortCfg.CountryRegion);

		success = TRUE;
	}
	else
		success = FALSE;

	return success;
}
/* 
    ==========================================================================
    Description:
        Set SSID
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_SSID_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	int   success = FALSE;

	if( strlen(arg) <= MAX_LEN_OF_SSID)
	{
		NdisZeroMemory(pAdapter->PortCfg.Ssid, MAX_LEN_OF_SSID);
		NdisMoveMemory(pAdapter->PortCfg.Ssid, arg, strlen(arg));
		pAdapter->PortCfg.SsidLen = (UCHAR)strlen(arg);
		success = TRUE;
		ApStop(pAdapter);
		ApStartUp(pAdapter);
		DBGPRINT(RT_DEBUG_TRACE, "Set_SSID_Proc::(Len=%d,Ssid=%s)\n", pAdapter->PortCfg.SsidLen, pAdapter->PortCfg.Ssid);
	}
	else
		success = FALSE;

	return success;
}
/* 
    ==========================================================================
    Description:
        Set Wireless Mode
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_WirelessMode_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	ULONG	WirelessMode;
	int   success = TRUE;

	WirelessMode = simple_strtol(arg, 0, 10);

	if(WirelessMode == PHY_11B)
		pAdapter->PortCfg.PhyMode = PHY_11B;
	else if(WirelessMode == PHY_11BG_MIXED)
		pAdapter->PortCfg.PhyMode = PHY_11BG_MIXED;
	else
		success = FALSE;

	if(success)
	{
		ApStop(pAdapter);
		ApStartUp(pAdapter);
		DBGPRINT(RT_DEBUG_TRACE, "Set_WirelessMode_Proc::(=%d)\n", pAdapter->PortCfg.PhyMode);
	}
	
	return success;
}
/* 
    ==========================================================================
    Description:
        Set TxRate
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT Set_TxRate_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	switch(simple_strtol(arg, 0, 10))
	{
		case 0: // Auto 
			switch(pAdapter->PortCfg.PhyMode)
			{
				case PHY_11BG_MIXED: // B/G Mixed
					pAdapter->PortCfg.DesiredRates[0] = 0x6c; // 54Mbps
					pAdapter->PortCfg.DesiredRates[1] = 0x60; // 48Mbps
					pAdapter->PortCfg.DesiredRates[2] = 0x48; // 36Mbps
					pAdapter->PortCfg.DesiredRates[3] = 0x30; // 24Mbps
					pAdapter->PortCfg.DesiredRates[4] = 0x16; // 11Mbps
					pAdapter->PortCfg.DesiredRates[5] = 0x0b; // 5.5Mbps
					pAdapter->PortCfg.DesiredRates[6] = 0x04; // 2Mbps
					pAdapter->PortCfg.DesiredRates[7] = 0x02; // 1Mbps
					break;
				case PHY_11B: // B Only
					pAdapter->PortCfg.DesiredRates[0] = 0x16; // 11Mbps
					pAdapter->PortCfg.DesiredRates[1] = 0x0b; // 5.5Mbps
					pAdapter->PortCfg.DesiredRates[2] = 0x04; // 2Mbps
					pAdapter->PortCfg.DesiredRates[3] = 0x02; // 1Mbps
					pAdapter->PortCfg.DesiredRates[4] = 0x00;
					pAdapter->PortCfg.DesiredRates[5] = 0x00;
					pAdapter->PortCfg.DesiredRates[6] = 0x00;
					pAdapter->PortCfg.DesiredRates[7] = 0x00;
					break;
			}
			break;
		case 1:
			pAdapter->PortCfg.DesiredRates[0] = 0x02;	// 1M	Mandatory
			pAdapter->PortCfg.DesiredRates[1] = 0x00;	
			pAdapter->PortCfg.DesiredRates[2] = 0x00;	
			pAdapter->PortCfg.DesiredRates[3] = 0x00;	
			pAdapter->PortCfg.DesiredRates[4] = 0x00;
			pAdapter->PortCfg.DesiredRates[5] = 0x00;
			pAdapter->PortCfg.DesiredRates[6] = 0x00;
			pAdapter->PortCfg.DesiredRates[7] = 0x00;
			break;
		case 2:
			pAdapter->PortCfg.DesiredRates[0] = 0x04;	// 2M	Mandatory
			pAdapter->PortCfg.DesiredRates[1] = 0x00;	
			pAdapter->PortCfg.DesiredRates[2] = 0x00;	
			pAdapter->PortCfg.DesiredRates[3] = 0x00;	
			pAdapter->PortCfg.DesiredRates[4] = 0x00;
			pAdapter->PortCfg.DesiredRates[5] = 0x00;
			pAdapter->PortCfg.DesiredRates[6] = 0x00;
			pAdapter->PortCfg.DesiredRates[7] = 0x00;
			break;
		case 3:
			pAdapter->PortCfg.DesiredRates[0] = 0x0b;	// 5.5M	Mandatory
			pAdapter->PortCfg.DesiredRates[1] = 0x00;	
			pAdapter->PortCfg.DesiredRates[2] = 0x00;	
			pAdapter->PortCfg.DesiredRates[3] = 0x00;	
			pAdapter->PortCfg.DesiredRates[4] = 0x00;
			pAdapter->PortCfg.DesiredRates[5] = 0x00;
			pAdapter->PortCfg.DesiredRates[6] = 0x00;
			pAdapter->PortCfg.DesiredRates[7] = 0x00;
			break;
		case 4:
			pAdapter->PortCfg.DesiredRates[0] = 0x16;	// 11M Mandatory
			pAdapter->PortCfg.DesiredRates[1] = 0x00;	
			pAdapter->PortCfg.DesiredRates[2] = 0x00;	
			pAdapter->PortCfg.DesiredRates[3] = 0x00;	
			pAdapter->PortCfg.DesiredRates[4] = 0x00;
			pAdapter->PortCfg.DesiredRates[5] = 0x00;
			pAdapter->PortCfg.DesiredRates[6] = 0x00;
			pAdapter->PortCfg.DesiredRates[7] = 0x00;
			break;
		case 5:
			pAdapter->PortCfg.DesiredRates[0] = 0x0c; // 6M
			pAdapter->PortCfg.DesiredRates[1] = 0x00;
			pAdapter->PortCfg.DesiredRates[2] = 0x00;
			pAdapter->PortCfg.DesiredRates[3] = 0x00;
			pAdapter->PortCfg.DesiredRates[4] = 0x00;
			pAdapter->PortCfg.DesiredRates[5] = 0x00;
			pAdapter->PortCfg.DesiredRates[6] = 0x00;
			pAdapter->PortCfg.DesiredRates[7] = 0x00;
			break;
		case 6:
			pAdapter->PortCfg.DesiredRates[0] = 0x12; // 9M
			pAdapter->PortCfg.DesiredRates[1] = 0x00;
			pAdapter->PortCfg.DesiredRates[2] = 0x00;
			pAdapter->PortCfg.DesiredRates[3] = 0x00;
			pAdapter->PortCfg.DesiredRates[4] = 0x00;
			pAdapter->PortCfg.DesiredRates[5] = 0x00;
			pAdapter->PortCfg.DesiredRates[6] = 0x00;
			pAdapter->PortCfg.DesiredRates[7] = 0x00;
			break;
		case 7:
			pAdapter->PortCfg.DesiredRates[0] = 0x18; // 12M
			pAdapter->PortCfg.DesiredRates[1] = 0x00;
			pAdapter->PortCfg.DesiredRates[2] = 0x00;
			pAdapter->PortCfg.DesiredRates[3] = 0x00;
			pAdapter->PortCfg.DesiredRates[4] = 0x00;
			pAdapter->PortCfg.DesiredRates[5] = 0x00;
			pAdapter->PortCfg.DesiredRates[6] = 0x00;
			pAdapter->PortCfg.DesiredRates[7] = 0x00;
			break;
		case 8:
			pAdapter->PortCfg.DesiredRates[0] = 0x24; // 18M
			pAdapter->PortCfg.DesiredRates[1] = 0x00;
			pAdapter->PortCfg.DesiredRates[2] = 0x00;
			pAdapter->PortCfg.DesiredRates[3] = 0x00;
			pAdapter->PortCfg.DesiredRates[4] = 0x00;
			pAdapter->PortCfg.DesiredRates[5] = 0x00;
			pAdapter->PortCfg.DesiredRates[6] = 0x00;
			pAdapter->PortCfg.DesiredRates[7] = 0x00;
			break;
		case 9:
			pAdapter->PortCfg.DesiredRates[0] = 0x30; // 24M
			pAdapter->PortCfg.DesiredRates[1] = 0x00;
			pAdapter->PortCfg.DesiredRates[2] = 0x00;
			pAdapter->PortCfg.DesiredRates[3] = 0x00;
			pAdapter->PortCfg.DesiredRates[4] = 0x00;
			pAdapter->PortCfg.DesiredRates[5] = 0x00;
			pAdapter->PortCfg.DesiredRates[6] = 0x00;
			pAdapter->PortCfg.DesiredRates[7] = 0x00;
			break;
		case 10:
			pAdapter->PortCfg.DesiredRates[0] = 0x48; // 36M
			pAdapter->PortCfg.DesiredRates[1] = 0x00;
			pAdapter->PortCfg.DesiredRates[2] = 0x00;
			pAdapter->PortCfg.DesiredRates[3] = 0x00;
			pAdapter->PortCfg.DesiredRates[4] = 0x00;
			pAdapter->PortCfg.DesiredRates[5] = 0x00;
			pAdapter->PortCfg.DesiredRates[6] = 0x00;
			pAdapter->PortCfg.DesiredRates[7] = 0x00;
			break;
		case 11:
			pAdapter->PortCfg.DesiredRates[0] = 0x60; // 48M
			pAdapter->PortCfg.DesiredRates[1] = 0x00;
			pAdapter->PortCfg.DesiredRates[2] = 0x00;
			pAdapter->PortCfg.DesiredRates[3] = 0x00;
			pAdapter->PortCfg.DesiredRates[4] = 0x00;
			pAdapter->PortCfg.DesiredRates[5] = 0x00;
			pAdapter->PortCfg.DesiredRates[6] = 0x00;
			pAdapter->PortCfg.DesiredRates[7] = 0x00;
			break;
		case 12:
			pAdapter->PortCfg.DesiredRates[0] = 0x6c; // 54M
			pAdapter->PortCfg.DesiredRates[1] = 0x00;
			pAdapter->PortCfg.DesiredRates[2] = 0x00;
			pAdapter->PortCfg.DesiredRates[3] = 0x00;
			pAdapter->PortCfg.DesiredRates[4] = 0x00;
			pAdapter->PortCfg.DesiredRates[5] = 0x00;
			pAdapter->PortCfg.DesiredRates[6] = 0x00;
			pAdapter->PortCfg.DesiredRates[7] = 0x00;
			break;
		default:
			return FALSE;  //Invalid argument 
	}
	
	MlmeUpdateTxRates(pAdapter);

	DBGPRINT(RT_DEBUG_TRACE, "Set_TxRate_Proc::(%02x,%02x,%02x,%02x,%02x,%02x,%02x,%02x)\n", 
			pAdapter->PortCfg.DesiredRates[0],pAdapter->PortCfg.DesiredRates[1],
			pAdapter->PortCfg.DesiredRates[2],pAdapter->PortCfg.DesiredRates[3],
			pAdapter->PortCfg.DesiredRates[4],pAdapter->PortCfg.DesiredRates[5],
			pAdapter->PortCfg.DesiredRates[6],pAdapter->PortCfg.DesiredRates[7] );

	return TRUE;
}
/* 
    ==========================================================================
    Description:
        Set Channel
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_Channel_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	int   success = FALSE;
	UCHAR channel;	

	channel = (UCHAR) simple_strtol(arg, 0, 10);

	pAdapter->PortCfg.Channel = channel;
	success = TRUE;
	ApStop(pAdapter);
	ApStartUp(pAdapter);
	DBGPRINT(RT_DEBUG_TRACE, "Set_Channel_Proc::(Channel=%d)\n", pAdapter->PortCfg.Channel);

	return success;
}
/* 
    ==========================================================================
    Description:
        Set Beacon Period
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_BeaconPeriod_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	USHORT BeaconPeriod;
	int   success = FALSE;

	BeaconPeriod = (USHORT) simple_strtol(arg, 0, 10);
	if(BeaconPeriod >= 1 )
	{
		pAdapter->PortCfg.BeaconPeriod = BeaconPeriod;
		success = TRUE;		
		AsicDisableSync(pAdapter);
		AsicEnableBssSync(pAdapter);
		DBGPRINT(RT_DEBUG_TRACE, "Set_BeaconPeriod_Proc::(BeaconPeriod=%d)\n", pAdapter->PortCfg.BeaconPeriod);
	}
	else
		success = FALSE;

	return success;
}
/* 
    ==========================================================================
    Description:
        For Debug information
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
#ifdef RT2500_DBG
INT	Set_Debug_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)

{
	DBGPRINT(RT_DEBUG_TRACE, "**************************************************************\n");
	DBGPRINT(RT_DEBUG_TRACE, "==> Set_Debug_Proc\n");

    if(simple_strtol(arg, 0, 10) <= RT_DEBUG_LOUD)
        RTDebugLevel = simple_strtol(arg, 0, 10);

	DBGPRINT(RT_DEBUG_TRACE, "<== Set_Debug_Proc(RTDebugLevel = %d)\n", RTDebugLevel);
	DBGPRINT(RT_DEBUG_TRACE, "**************************************************************\n");
	return TRUE;
}
#endif
/* 
    ==========================================================================
    Description:
        Set 11B/11G Protection
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_BGProtection_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)

{
	switch (simple_strtol(arg, 0, 10))
	{
		case 0: //AUTO
			pAdapter->PortCfg.UseBGProtection = 0;
			break;
		case 1: //Always On
			pAdapter->PortCfg.UseBGProtection = 1;
			break;
		case 2: //Always OFF
			pAdapter->PortCfg.UseBGProtection = 2;
			break;		
		default:  //Invalid argument 
			return FALSE;
	}
	ApUpdateCapabilityAndErpIe(pAdapter);
	DBGPRINT(RT_DEBUG_TRACE, "Set_BGProtection_Proc::(BGProtection=%d)\n", pAdapter->PortCfg.UseBGProtection);	

	return TRUE;
}
/* 
    ==========================================================================
    Description:
        Set TxAntenna
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_TxAntenna_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	ULONG					BbpCsr1;
	UCHAR					TxValue;

	RTMP_IO_READ32(pAdapter, BBPCSR1, &BbpCsr1);

	switch (simple_strtol(arg, 0, 10))
	{
		case 0: //Diversity
			pAdapter->PortCfg.CurrentTxAntenna = 0xFF;
			RTMP_BBP_IO_READ32_BY_REG_ID(pAdapter, BBP_Tx_Configure, &TxValue);
			TxValue = (TxValue & 0xFC) | 0x01;
			RTMP_BBP_IO_WRITE32_BY_REG_ID(pAdapter, BBP_Tx_Configure, TxValue);
			BbpCsr1 = (BbpCsr1 & 0xFFFCFFFC) | 0x00010001;
			RTMP_IO_WRITE32(pAdapter, BBPCSR1, BbpCsr1);
			break;
		case 1: //Antenna A
			pAdapter->PortCfg.CurrentTxAntenna = 0x00;
			RTMP_BBP_IO_READ32_BY_REG_ID(pAdapter, BBP_Tx_Configure, &TxValue);
			TxValue = (TxValue & 0xFC) | 0x00;
			BbpCsr1 = (BbpCsr1 & 0xFFFCFFFC) | 0x00000000;
			RTMP_BBP_IO_WRITE32_BY_REG_ID(pAdapter, BBP_Tx_Configure, TxValue);
			RTMP_IO_WRITE32(pAdapter, BBPCSR1, BbpCsr1);
			break;
		case 2: //Antenna B
			pAdapter->PortCfg.CurrentTxAntenna = 0x01;
			RTMP_BBP_IO_READ32_BY_REG_ID(pAdapter, BBP_Tx_Configure, &TxValue);
			TxValue = (TxValue & 0xFC) | 0x02;
			BbpCsr1 = (BbpCsr1 & 0xFFFCFFFC) | 0x00020002;
			RTMP_BBP_IO_WRITE32_BY_REG_ID(pAdapter, BBP_Tx_Configure, TxValue);
			RTMP_IO_WRITE32(pAdapter, BBPCSR1, BbpCsr1);
			break;
		default:  //Invalid argument 
			return FALSE;
	}

	DBGPRINT(RT_DEBUG_TRACE, "Set_TxAntenna_Proc::(TxAntenna=%d)\n", pAdapter->PortCfg.CurrentTxAntenna);	

	return TRUE;
}
/* 
    ==========================================================================
    Description:
        Set RxAntenna
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_RxAntenna_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	ULONG					BbpCsr1;
	UCHAR					RxValue;
	
	RTMP_IO_READ32(pAdapter, BBPCSR1, &BbpCsr1);

	switch (simple_strtol(arg, 0, 10))
	{
		case 0: //Diversity
			pAdapter->PortCfg.CurrentRxAntenna = 0xFF;
			RTMP_BBP_IO_READ32_BY_REG_ID(pAdapter, BBP_Rx_Configure, &RxValue);
			RxValue = (RxValue & 0xFC) | 0x01;
			RTMP_BBP_IO_WRITE32_BY_REG_ID(pAdapter, BBP_Rx_Configure, RxValue);	
			break;
		case 1: //Antenna A
			pAdapter->PortCfg.CurrentRxAntenna = 0x00;
			RTMP_BBP_IO_READ32_BY_REG_ID(pAdapter, BBP_Rx_Configure, &RxValue);
			RxValue = (RxValue & 0xFC) | 0x00;
			RTMP_BBP_IO_WRITE32_BY_REG_ID(pAdapter, BBP_Rx_Configure, RxValue);
			break;
		case 2: //Antenna B
			pAdapter->PortCfg.CurrentRxAntenna = 0x01;
			RTMP_BBP_IO_READ32_BY_REG_ID(pAdapter, BBP_Rx_Configure, &RxValue);
			RxValue = (RxValue & 0xFC) | 0x02;
			RTMP_BBP_IO_WRITE32_BY_REG_ID(pAdapter, BBP_Rx_Configure, RxValue);
			break;
		default: //Invalid argument 
			return FALSE;
	}

	DBGPRINT(RT_DEBUG_TRACE, "Set_RxAntenna_Proc::(RxAntenna=%d)\n", pAdapter->PortCfg.CurrentRxAntenna);

	return TRUE;
}
/* 
    ==========================================================================
    Description:
        Set TxPreamble
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_TxPreamble_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	switch (simple_strtol(arg, 0, 10))
	{
		case Rt802_11PreambleLong:
			pAdapter->PortCfg.TxPreamble = Rt802_11PreambleLong;
			MlmeSetTxPreamble(pAdapter, Rt802_11PreambleLong);
			break;
		case Rt802_11PreambleShort:
			pAdapter->PortCfg.TxPreamble = Rt802_11PreambleShort;
			MlmeSetTxPreamble(pAdapter, Rt802_11PreambleShort);
			break;
		case Rt802_11PreambleAuto:
			pAdapter->PortCfg.TxPreamble = Rt802_11PreambleAuto;
			MlmeSetTxPreamble(pAdapter, Rt802_11PreambleAuto);
			break;
		default: //Invalid argument 
			return FALSE;
	}

	DBGPRINT(RT_DEBUG_TRACE, "Set_TxPreamble_Proc::(TxPreamble=%d)\n", pAdapter->PortCfg.TxPreamble);

	return TRUE;
}
/* 
    ==========================================================================
    Description:
        Set RTS Threshold
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_RTSThreshold_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	ULONG	RtsThresh;

	RtsThresh = simple_strtol(arg, 0, 10);

	if( (RtsThresh >= 1) && (RtsThresh <= MAX_RTS_THRESHOLD) )
		pAdapter->PortCfg.RtsThreshold  = (USHORT)RtsThresh;
	else
		return FALSE; //Invalid argument 

	DBGPRINT(RT_DEBUG_TRACE, "Set_RTSThreshold_Proc::(RTSThreshold=%d)\n", pAdapter->PortCfg.RtsThreshold);

	return TRUE;
}
/* 
    ==========================================================================
    Description:
        Set Fragment Threshold
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_FragThreshold_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	ULONG	FragThresh;

	FragThresh = simple_strtol(arg, 0, 10);

	if ( (FragThresh >= MIN_FRAG_THRESHOLD) || (FragThresh <= MAX_FRAG_THRESHOLD) )
	{
		pAdapter->PortCfg.FragmentThreshold = MAX_FRAG_THRESHOLD;
		pAdapter->PortCfg.bFragmentZeroDisable = TRUE;
	}
	else
		return FALSE; //Invalid argument 

	DBGPRINT(RT_DEBUG_TRACE, "Set_FragThreshold_Proc::(FragThreshold=%d)\n", pAdapter->PortCfg.FragmentThreshold);

	return TRUE;
}
/* 
    ==========================================================================
    Description:
        Set TxBurst
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_TxBurst_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	ULONG TxBurst;

	TxBurst = simple_strtol(arg, 0, 10);

	if (TxBurst == 1)
		pAdapter->PortCfg.EnableTxBurst = TRUE;
	else if (TxBurst == 0)
		pAdapter->PortCfg.EnableTxBurst = FALSE;
	else
		return FALSE;  //Invalid argument 
	
	DBGPRINT(RT_DEBUG_TRACE, "Set_TxBurst_Proc::(TxBurst=%d)\n", pAdapter->PortCfg.EnableTxBurst);

	return TRUE;
}
/* 
    ==========================================================================
    Description:
        Set TurboRate Enable or Disable
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_TurboRate_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	ULONG TurboRate;

	TurboRate = simple_strtol(arg, 0, 10);

	if (TurboRate == 1)
		pAdapter->PortCfg.EnableTurboRate = TRUE;
	else if (TurboRate == 0)
		pAdapter->PortCfg.EnableTurboRate = FALSE;
	else
		return FALSE;  //Invalid argument 
	
	DBGPRINT(RT_DEBUG_TRACE, "Set_TurboRate_Proc::(TurboRate=%d)\n", pAdapter->PortCfg.EnableTurboRate);

	return TRUE;
}
/* 
    ==========================================================================
    Description:
        Set No Forwarding Enable or Disable
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_NoForwarding_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	ULONG NoForwarding;

	NoForwarding = simple_strtol(arg, 0, 10);

	if (NoForwarding == 1)
		pAdapter->PortCfg.IsolateInterStaTraffic = TRUE;
	else if (NoForwarding == 0)
		pAdapter->PortCfg.IsolateInterStaTraffic = FALSE;
	else
		return FALSE;  //Invalid argument 
	
	DBGPRINT(RT_DEBUG_TRACE, "Set_NoForwarding_Proc::(NoForwarding=%d)\n", pAdapter->PortCfg.IsolateInterStaTraffic);

	return TRUE;
}
/* 
    ==========================================================================
    Description:
        Set Hide SSID Enable or Disable
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_HideSSID_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	ULONG HideSsid;

	HideSsid = simple_strtol(arg, 0, 10);

	if (HideSsid == 1)
		HideSsid = TRUE;
	else if (HideSsid == 0)
		HideSsid = FALSE;
	else
		return FALSE;  //Invalid argument 
	
	if (pAdapter->PortCfg.HideSsid != HideSsid)
	{
		pAdapter->PortCfg.HideSsid = HideSsid;
		// re-built BEACON frame format
		AsicDisableSync(pAdapter);
		MakeBssBeacon(pAdapter);
		UpdateBeaconFrame(pAdapter);
		AsicEnableBssSync(pAdapter);
	}

	DBGPRINT(RT_DEBUG_TRACE, "Set_HideSSID_Proc::(HideSSID=%d)\n", pAdapter->PortCfg.HideSsid);

	return TRUE;
}
/* 
    ==========================================================================
    Description:
        Set Short Slot Time Enable or Disable
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_ShortSlot_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	ULONG ShortSlot;

	ShortSlot = simple_strtol(arg, 0, 10);

	if (ShortSlot == 1)
		pAdapter->PortCfg.UseShortSlotTime = TRUE;
	else if (ShortSlot == 0)
		pAdapter->PortCfg.UseShortSlotTime = FALSE;
	else
		return FALSE;  //Invalid argument 
	
	DBGPRINT(RT_DEBUG_TRACE, "Set_ShortSlot_Proc::(ShortSlot=%d)\n", pAdapter->PortCfg.UseShortSlotTime);

	return TRUE;
}
/* 
    ==========================================================================
    Description:
        Set Authentication mode
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_AuthMode_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	if ((strcmp(arg, "OPEN") == 0) || (strcmp(arg, "open") == 0))
		pAdapter->PortCfg.AuthMode = Ndis802_11AuthModeOpen;
	else if ((strcmp(arg, "SHARED") == 0) || (strcmp(arg, "shared") == 0))
		pAdapter->PortCfg.AuthMode = Ndis802_11AuthModeShared;
	else if ((strcmp(arg, "WPAPSK") == 0) || (strcmp(arg, "wpapsk") == 0))
		pAdapter->PortCfg.AuthMode = Ndis802_11AuthModeWPAPSK;
	else if ((strcmp(arg, "WPA") == 0) || (strcmp(arg, "wpa") == 0))
		pAdapter->PortCfg.AuthMode = Ndis802_11AuthModeWPA;
	else
		return FALSE;  

	pAdapter->PortCfg.PortSecured = WPA_802_1X_PORT_NOT_SECURED;
    RTMPMakeRSNIE(pAdapter, pAdapter->PortCfg.AuthMode, pAdapter->PortCfg.WepStatus);

	DBGPRINT(RT_DEBUG_TRACE, "Set_AuthMode_Proc::(AuthMode=%d)\n", pAdapter->PortCfg.AuthMode);

	return TRUE;
}
/* 
    ==========================================================================
    Description:
        Set Encryption Type
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_EncrypType_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	if ((strcmp(arg, "NONE") == 0) || (strcmp(arg, "none") == 0))
		pAdapter->PortCfg.WepStatus = Ndis802_11WEPDisabled;
	else if ((strcmp(arg, "WEP") == 0) || (strcmp(arg, "wep") == 0))
		pAdapter->PortCfg.WepStatus = Ndis802_11WEPEnabled;
	else if ((strcmp(arg, "TKIP") == 0) || (strcmp(arg, "tkip") == 0))
		pAdapter->PortCfg.WepStatus = Ndis802_11Encryption2Enabled;
	else if ((strcmp(arg, "AES") == 0) || (strcmp(arg, "aes") == 0))
		pAdapter->PortCfg.WepStatus = Ndis802_11Encryption3Enabled;
	else
		return FALSE;

    RTMPMakeRSNIE(pAdapter, pAdapter->PortCfg.AuthMode, pAdapter->PortCfg.WepStatus);
	DBGPRINT(RT_DEBUG_TRACE, "Set_EncrypType_Proc::(EncrypType=%d)\n", pAdapter->PortCfg.WepStatus);

	return TRUE;
}
/* 
    ==========================================================================
    Description:
        Set Default Key ID
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_DefaultKeyID_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	ULONG KeyIdx;

	KeyIdx = simple_strtol(arg, 0, 10);
	if((KeyIdx >= 1 ) && (KeyIdx <= 4))
		pAdapter->PortCfg.DefaultKeyId = (UCHAR) (KeyIdx - 1 );
	else
		return FALSE;  //Invalid argument 
	
	DBGPRINT(RT_DEBUG_TRACE, "Set_DefaultKeyID_Proc::(DefaultKeyID=%d)\n", pAdapter->PortCfg.DefaultKeyId);

	return TRUE;
}
/* 
    ==========================================================================
    Description:
        Set WEP KEY1
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_Key1_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	int KeyLen;
	int i;

	KeyLen = strlen(arg);

	switch (KeyLen)
	{
		case 5: //wep 40 Ascii type
			pAdapter->PortCfg.SharedKey[0].KeyLen = KeyLen;
			memcpy(pAdapter->PortCfg.SharedKey[0].Key, arg, KeyLen);	
			DBGPRINT(RT_DEBUG_TRACE, "Set_Key1_Proc::(Key1=%s and type=%s)\n", arg, "Ascii");		
			break;
		case 10: //wep 40 Hex type
			for(i=0; i < KeyLen; i++)
			{
				if( !isxdigit(*(arg+i)) )
					return FALSE;  //Not Hex value;
			}
			pAdapter->PortCfg.SharedKey[0].KeyLen = KeyLen / 2 ;
			AtoH(arg, pAdapter->PortCfg.SharedKey[0].Key, KeyLen / 2);
			DBGPRINT(RT_DEBUG_TRACE, "Set_Key1_Proc::(Key1=%s and type=%s)\n", arg, "Hex");		
			break;
		case 13: //wep 104 Ascii type
			pAdapter->PortCfg.SharedKey[0].KeyLen = KeyLen;
			memcpy(pAdapter->PortCfg.SharedKey[0].Key, arg, KeyLen);	
			DBGPRINT(RT_DEBUG_TRACE, "Set_Key1_Proc::(Key1=%s and type=%s)\n", arg, "Ascii");		
			break;
		case 26: //wep 104 Hex type
			for(i=0; i < KeyLen; i++)
			{
				if( !isxdigit(*(arg+i)) )
					return FALSE;  //Not Hex value;
			}
			pAdapter->PortCfg.SharedKey[0].KeyLen = KeyLen / 2 ;
			AtoH(arg, pAdapter->PortCfg.SharedKey[0].Key, KeyLen / 2);
			DBGPRINT(RT_DEBUG_TRACE, "Set_Key1_Proc::(Key1=%s and type=%s)\n", arg, "Hex");		
			break;
		default: //Invalid argument 
			DBGPRINT(RT_DEBUG_TRACE, "Set_Key1_Proc::Invalid argument (=%s)\n", arg);		
			return FALSE;
	}

	return TRUE;
}
/* 
    ==========================================================================
    Description:
        Set WEP KEY2
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_Key2_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	int KeyLen;
	int i;

	KeyLen = strlen(arg);

	switch (KeyLen)
	{
		case 5: //wep 40 Ascii type
			pAdapter->PortCfg.SharedKey[1].KeyLen = KeyLen;
			memcpy(pAdapter->PortCfg.SharedKey[1].Key, arg, KeyLen);	
			DBGPRINT(RT_DEBUG_TRACE, "Set_Key2_Proc::(Key2=%s and type=%s)\n", arg, "Ascii");		
			break;
		case 10: //wep 40 Hex type
			for(i=0; i < KeyLen; i++)
			{
				if( !isxdigit(*(arg+i)) )
					return FALSE;  //Not Hex value;
			}
			pAdapter->PortCfg.SharedKey[1].KeyLen = KeyLen / 2 ;
			AtoH(arg, pAdapter->PortCfg.SharedKey[1].Key, KeyLen / 2);
			DBGPRINT(RT_DEBUG_TRACE, "Set_Key2_Proc::(Key2=%s and type=%s)\n", arg, "Hex");		
			break;
		case 13: //wep 104 Ascii type
			pAdapter->PortCfg.SharedKey[1].KeyLen = KeyLen;
			memcpy(pAdapter->PortCfg.SharedKey[1].Key, arg, KeyLen);	
			DBGPRINT(RT_DEBUG_TRACE, "Set_Key2_Proc::(Key2=%s and type=%s)\n", arg, "Ascii");		
			break;
		case 26: //wep 104 Hex type
			for(i=0; i < KeyLen; i++)
			{
				if( !isxdigit(*(arg+i)) )
					return FALSE;  //Not Hex value;
			}
			pAdapter->PortCfg.SharedKey[1].KeyLen = KeyLen / 2 ;
			AtoH(arg, pAdapter->PortCfg.SharedKey[1].Key, KeyLen / 2);
			DBGPRINT(RT_DEBUG_TRACE, "Set_Key2_Proc::(Key2=%s and type=%s)\n", arg, "Hex");		
			break;
		default: //Invalid argument 
			DBGPRINT(RT_DEBUG_TRACE, "Set_Key2_Proc::Invalid argument (=%s)\n", arg);		
			return FALSE;
	}

	return TRUE;
}
/* 
    ==========================================================================
    Description:
        Set WEP KEY3
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_Key3_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	int KeyLen;
	int i;

	KeyLen = strlen(arg);

	switch (KeyLen)
	{
		case 5: //wep 40 Ascii type
			pAdapter->PortCfg.SharedKey[2].KeyLen = KeyLen;
			memcpy(pAdapter->PortCfg.SharedKey[2].Key, arg, KeyLen);	
			DBGPRINT(RT_DEBUG_TRACE, "Set_Key3_Proc::(Key3=%s and type=%s)\n", arg, "Ascii");		
			break;
		case 10: //wep 40 Hex type
			for(i=0; i < KeyLen; i++)
			{
				if( !isxdigit(*(arg+i)) )
					return FALSE;  //Not Hex value;
			}
			pAdapter->PortCfg.SharedKey[2].KeyLen = KeyLen / 2 ;
			AtoH(arg, pAdapter->PortCfg.SharedKey[2].Key, KeyLen / 2);
			DBGPRINT(RT_DEBUG_TRACE, "Set_Key3_Proc::(Key3=%s and type=%s)\n", arg, "Hex");		
			break;
		case 13: //wep 104 Ascii type
			pAdapter->PortCfg.SharedKey[2].KeyLen = KeyLen;
			memcpy(pAdapter->PortCfg.SharedKey[2].Key, arg, KeyLen);	
			DBGPRINT(RT_DEBUG_TRACE, "Set_Key3_Proc::(Key3=%s and type=%s)\n", arg, "Ascii");		
			break;
		case 26: //wep 104 Hex type
			for(i=0; i < KeyLen; i++)
			{
				if( !isxdigit(*(arg+i)) )
					return FALSE;  //Not Hex value;
			}
			pAdapter->PortCfg.SharedKey[2].KeyLen = KeyLen / 2 ;
			AtoH(arg, pAdapter->PortCfg.SharedKey[2].Key, KeyLen / 2);
			DBGPRINT(RT_DEBUG_TRACE, "Set_Key3_Proc::(Key3=%s and type=%s)\n", arg, "Hex");		
			break;
		default: //Invalid argument 
			DBGPRINT(RT_DEBUG_TRACE, "Set_Key3_Proc::Invalid argument (=%s)\n", arg);		
			return FALSE;
	}

	return TRUE;
}
/* 
    ==========================================================================
    Description:
        Set WEP KEY4
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_Key4_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	int KeyLen;
	int i;

	KeyLen = strlen(arg);

	switch (KeyLen)
	{
		case 5: //wep 40 Ascii type
			pAdapter->PortCfg.SharedKey[3].KeyLen = KeyLen;
			memcpy(pAdapter->PortCfg.SharedKey[3].Key, arg, KeyLen);	
			DBGPRINT(RT_DEBUG_TRACE, "Set_Key4_Proc::(Key4=%s and type=%s)\n", arg, "Ascii");		
			break;
		case 10: //wep 40 Hex type
			for(i=0; i < KeyLen; i++)
			{
				if( !isxdigit(*(arg+i)) )
					return FALSE;  //Not Hex value;
			}
			pAdapter->PortCfg.SharedKey[3].KeyLen = KeyLen / 2 ;
			AtoH(arg, pAdapter->PortCfg.SharedKey[3].Key, KeyLen / 2);
			DBGPRINT(RT_DEBUG_TRACE, "Set_Key4_Proc::(Key4=%s and type=%s)\n", arg, "Hex");		
			break;
		case 13: //wep 104 Ascii type
			pAdapter->PortCfg.SharedKey[3].KeyLen = KeyLen;
			memcpy(pAdapter->PortCfg.SharedKey[3].Key, arg, KeyLen);	
			DBGPRINT(RT_DEBUG_TRACE, "Set_Key4_Proc::(Key4=%s and type=%s)\n", arg, "Ascii");		
			break;
		case 26: //wep 104 Hex type
			for(i=0; i < KeyLen; i++)
			{
				if( !isxdigit(*(arg+i)) )
					return FALSE;  //Not Hex value;
			}
			pAdapter->PortCfg.SharedKey[3].KeyLen = KeyLen / 2 ;
			AtoH(arg, pAdapter->PortCfg.SharedKey[3].Key, KeyLen / 2);
			DBGPRINT(RT_DEBUG_TRACE, "Set_Key4_Proc::(Key4=%s and type=%s)\n", arg, "Hex");		
			break;
		default: //Invalid argument 
			DBGPRINT(RT_DEBUG_TRACE, "Set_Key4_Proc::Invalid argument (=%s)\n", arg);		
			return FALSE;
	}

	return TRUE;
}
/* 
    ==========================================================================
    Description:
        Set Access ctrol policy
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_AccessPolicy_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	switch (simple_strtol(arg, 0, 10))
	{
		case 0: //Disable
			pAdapter->PortCfg.AccessControlList.Policy = 0;
			break;
		case 1: //Allow All
			pAdapter->PortCfg.AccessControlList.Policy = 1;
			break;
		case 2: //Reject All
			pAdapter->PortCfg.AccessControlList.Policy = 2;
			break;
		default: //Invalid argument 
			DBGPRINT(RT_DEBUG_TRACE, "Set_AccessPolicy_Proc::Invalid argument (=%s)\n", arg);		
			return FALSE;
	}

	// check if ACL change affects any existent associtions
	ApUpdateAccessControlList(pAdapter);
	
	DBGPRINT(RT_DEBUG_TRACE, "Set_AccessPolicy_Proc::(AccessPolicy=%d)\n", pAdapter->PortCfg.AccessControlList.Policy);

	return TRUE;	
}
/* 
    ==========================================================================
    Description:
        Set Access ctrol mac table list
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_AccessControlList_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	MACADDR					macAddress;
	RT_802_11_ACL			acl;
	char					*this_char;
	char					*value;
	int						i,j;
	BOOLEAN					isDuplicat=FALSE;

	memset(&acl, 0x00, sizeof(RT_802_11_ACL));

	while ((this_char = strsep((char **)&arg, ";")) != NULL) 
	{
		if(strlen(this_char) != 17)  //Mac address acceptable format 01:02:03:04:05:06 length 17
			return FALSE;

         for (i=0, value = strtok(this_char,":"); value; value = strtok(NULL,":")) 
		 {
			if((strlen(value) != 2) || (!isxdigit(*value)) || (!isxdigit(*(value+1))) ) 
				return FALSE;  //Invalid

			AtoH(value, &macAddress.Octet[i++], 2);
		 }

		if(i != 6)
			return FALSE;  //Invalid

		//Check is duplicate
		isDuplicat = FALSE;
		for(j=0; j<acl.Num; j++)
			if(memcmp(acl.Entry[j].Addr, &macAddress, 6) == 0)
				isDuplicat = TRUE;

		if(!isDuplicat)
			memcpy(acl.Entry[acl.Num++].Addr, &macAddress, 6);

		if(acl.Num >= MAX_LEN_OF_MAC_TABLE)
			break;
	}

	acl.Policy = pAdapter->PortCfg.AccessControlList.Policy;
	memcpy(&pAdapter->PortCfg.AccessControlList, &acl, sizeof(RT_802_11_ACL));
	if (pAdapter->PortCfg.AccessControlList.Num > MAX_LEN_OF_MAC_TABLE)
		pAdapter->PortCfg.AccessControlList.Num = MAX_LEN_OF_MAC_TABLE;

	// check if ACL change affects any existent associtions
	ApUpdateAccessControlList(pAdapter);

	DBGPRINT(RT_DEBUG_TRACE, "Set::Set_AccessControlList_Proc(Policy=%d, Entry#=%d\n",
				pAdapter->PortCfg.AccessControlList.Policy, pAdapter->PortCfg.AccessControlList.Num);

#ifdef RT2500_DBG
	printk("=============== Entry ===============\n");
	for(i=0; i<pAdapter->PortCfg.AccessControlList.Num; i++)
	{
		printk("Entry #%02d: ", i+1);
		for(j=0; j<6; j++)
		   printk("%02X ", pAdapter->PortCfg.AccessControlList.Entry[i].Addr[j]);
		printk("\n");
	}
#endif
	return TRUE;
}

/* 
    ==========================================================================
    Description:
        Set WPA PSK key

    Arguments:
        pAdapter            Pointer to our adapter
        arg                 WPA pre-shared key string

    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_WPAPSK_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	UCHAR								keyMaterial[40];
	int									i;

	DBGPRINT(RT_DEBUG_TRACE, "Set_WPAPSK_Proc::(WPAPSK=%s)\n", arg);

	if ((strlen(arg) < 8) || (strlen(arg) > 64))
	{
		DBGPRINT(RT_DEBUG_TRACE, "Set failed!!(WPAPSK=%s), WPAPSK key-string required 8 ~ 64 characters \n", arg);
		return FALSE;
	}

	PasswordHash((char *)arg, pAdapter->PortCfg.Ssid, pAdapter->PortCfg.SsidLen, keyMaterial);

	NdisMoveMemory(pAdapter->PortCfg.PMK, keyMaterial, 32);

#ifdef RT2500_DBG
	printk("Set_WPAPSK_Proc WPAPSK Key => \n");
	for (i = 0; i < 32; i++)
	{
		printk("%02x:", pAdapter->PortCfg.PMK[i]);
		if ((i%16) == 15)
			printk("\n");
	}
	printk("\n");
#endif

	return TRUE;
}

/* 
    ==========================================================================
    Description:
        Reset statistics counter

    Arguments:
        pAdapter            Pointer to our adapter
        arg                 

    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_ResetStatCounter_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	DBGPRINT(RT_DEBUG_TRACE, "==>Set_ResetStatCounter_Proc\n");

	NdisZeroMemory(&pAdapter->WlanCounters, sizeof(COUNTER_802_11));
	NdisZeroMemory(&pAdapter->Counters, sizeof(COUNTER_802_3));
	NdisZeroMemory(&pAdapter->RalinkCounters, sizeof(COUNTER_RALINK));
	NdisZeroMemory(&pAdapter->Mlme.PrevWlanCounters, sizeof(COUNTER_802_11));
}

/* 
    ==========================================================================
    Description:
        Set Group Rekey interval type 

    Arguments:
        pAdapter            Pointer to our adapter
        arg                 

    Return:
          
    ==========================================================================
*/

INT	Set_RekeyType_Proc(
	IN	PRTMP_ADAPTER	pAd, 
	IN	PUCHAR			arg)
{
    if (pAd->PortCfg.AuthMode < Ndis802_11AuthModeWPA)
    {
        if(pAd->PortCfg.REKEYTimerRunning == TRUE)
        {
            del_timer_sync(&pAd->PortCfg.REKEYTimer);
            pAd->PortCfg.REKEYTimerRunning = FALSE;
        }
    	return TRUE;
    }
    
	if ((strcmp(arg, "TIME") == 0) || (strcmp(arg, "time") == 0))
		pAd->PortCfg.WPAREKEY.ReKeyMethod= TIME_REKEY;
	else if ((strcmp(arg, "PACKET") == 0) || (strcmp(arg, "packet") == 0))
		pAd->PortCfg.WPAREKEY.ReKeyMethod= PKT_REKEY;
	else if ((strcmp(arg, "NONE") == 0) || (strcmp(arg, "none") == 0))
		pAd->PortCfg.WPAREKEY.ReKeyInterval = 0;
	else
		return FALSE;
    if (( pAd->PortCfg.REKEYTimerRunning == FALSE ) && (pAd->PortCfg.WPAREKEY.ReKeyInterval != 0))
    {
        add_timer(&pAd->PortCfg.REKEYTimer);
        pAd->PortCfg.REKEYTimer.expires = jiffies + GUPDATE_EXEC_INTV;
        pAd->PortCfg.REKEYTimerRunning = TRUE;
        pAd->PortCfg.REKEYCOUNTER = 0;
    }
	DBGPRINT(RT_DEBUG_TRACE, "Set_RekeyType_Proc::(RekeyType=%d)\n", pAd->PortCfg.WPAREKEY.ReKeyMethod);

	return TRUE;

}
INT	Set_RekeyPeriod_Proc(
	IN	PRTMP_ADAPTER	pAd, 
	IN	PUCHAR			arg)
{
    ULONG period;
    
	period=simple_strtol(arg, 0, 10);
    if (period == 0)
    {
        del_timer_sync(&pAd->PortCfg.REKEYTimer);
    	pAd->PortCfg.REKEYTimerRunning = FALSE;

    }
    else if (period <= MAX_REKEY_INTER)
    {
        pAd->PortCfg.WPAREKEY.ReKeyInterval = period;
        if ( pAd->PortCfg.REKEYTimerRunning == FALSE)
        {
            add_timer(&pAd->PortCfg.REKEYTimer);
            pAd->PortCfg.REKEYTimer.expires = jiffies + GUPDATE_EXEC_INTV;
            pAd->PortCfg.REKEYTimerRunning = TRUE;
            pAd->PortCfg.REKEYCOUNTER = 0;
        }
        
    }
	else
		return FALSE;
    
	DBGPRINT(RT_DEBUG_TRACE, "Set_RekeyPeriod_Proc::(RekeyPeriod=%d)\n", period);
	return TRUE;

}
#ifdef RT2500_DBG
/* 
    ==========================================================================
    Description:
        Read / Write BBP
Arguments:
    pAdapter                    Pointer to our adapter
    wrq                         Pointer to the ioctl argument

    Return Value:
        None

    Note:
        Usage: 
               1.) iwpriv ra0 bbp               ==> read all BBP
               2.) iwpriv ra0 bbp 1,2,10,32     ==> raed BBP where ID=1,2,10,32
               3.) iwpriv ra0 bbp 1=10,17=3E    ==> write BBP R1=0x10, R17=0x3E
    ==========================================================================
*/
VOID RTMPIoctlBBP(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	struct iwreq	*wrq)
{
	char				*this_char;
	char				*value;
	int					i=0;
	int					count = 0;
	UCHAR				regBBP;
	char				msg[1024];
	char				arg[255];
	char				*ptr;
	LONG				bbpId;
	LONG				bbpValue;
	BOOLEAN				bIsPrintAllBBP = FALSE;

	printk("==>RTMPIoctlBBP\n");
	memset(msg, 0x00, 1024);
	if (wrq->u.data.length > 1) //No parameters.
	{
		memcpy(arg, wrq->u.data.pointer, (wrq->u.data.length > 255) ? 255 : wrq->u.data.length);
		ptr = arg;
		sprintf(msg, "\n");
		//Parsing Read or Write
		while ((this_char = strsep(&ptr, ",")) != NULL)
		{
			i++;
			printk("this_char=%s\n", this_char);
			if (!*this_char)
				continue;

			if ((value = strchr(this_char, '=')) != NULL)
				*value++ = 0;

			if (!value || !*value)
			{ //Read
				printk("this_char=%s, value=%s\n", this_char, value);
				if (sscanf(this_char, "%d", &(bbpId)) == 1)
				{
					if ((bbpId >=0) && (bbpId <= 63))
					{
						RTMP_BBP_IO_READ32_BY_REG_ID(pAdapter, bbpId, &regBBP);
						sprintf(msg+strlen(msg), "R%02d[0x%02X]:%02X  ", bbpId, bbpId*2, regBBP);
						count++;
						if (count%5 == 4)
							sprintf(msg+strlen(msg), "\n");
						printk("msg=%s\n", msg);
					}
					else
					{//Invalid parametes, so default printk all bbp
						bIsPrintAllBBP = TRUE;
						break;
					}
				}
				else
				{ //Invalid parametes, so default printk all bbp
					bIsPrintAllBBP = TRUE;
					break;
				}
			}
			else
			{ //Write
				printk("this_char=%s, value=%s\n", this_char, value);
				if ((sscanf(this_char, "%d", &(bbpId)) == 1) && (sscanf(value, "%x", &(bbpValue)) == 1))
				{
					printk("bbpID=%02d, value=0x%x\n", bbpId, bbpValue);
					if ((bbpId >=0) && (bbpId <= 63))
					{
						RTMP_BBP_IO_WRITE32_BY_REG_ID(pAdapter, (UCHAR) bbpId, (UCHAR) bbpValue);
						//Read it back for showing
						RTMP_BBP_IO_READ32_BY_REG_ID(pAdapter, bbpId, &regBBP);
						sprintf(msg+strlen(msg), "R%02d[0x%02X]:%02X  ", bbpId, bbpId*2, regBBP);
						count++;
						if (count%5 == 4)
							sprintf(msg+strlen(msg), "\n");
						printk("msg=%s\n", msg);
					}
					else
					{//Invalid parametes, so default printk all bbp
						bIsPrintAllBBP = TRUE;
						break;
					}
				}
				else
				{ //Invalid parametes, so default printk all bbp
					bIsPrintAllBBP = TRUE;
					break;
				}
			}
		}
	}
	else
		bIsPrintAllBBP = TRUE;

	if (bIsPrintAllBBP)
	{
		memset(msg, 0x00, 1024);
		sprintf(msg, "\n");
		for (i = 0; i <= 63; i++)
		{
			RTMP_BBP_IO_READ32_BY_REG_ID(pAdapter, i, &regBBP);
			sprintf(msg+strlen(msg), "R%02d[0x%02X]:%02X  ", i, i*2, regBBP);
			if (i%5 == 4)
				sprintf(msg+strlen(msg), "\n");
		}
		// Copy the information into the user buffer
		printk("strlen(msg) =%d\n", strlen(msg));
		wrq->u.data.length = strlen(msg);
		copy_to_user(wrq->u.data.pointer, msg, wrq->u.data.length);
	}
	else
	{
		printk("copy to user [msg=%s]\n", msg);
		// Copy the information into the user buffer
		printk("strlen(msg) =%d\n", strlen(msg));
		wrq->u.data.length = strlen(msg);
		copy_to_user(wrq->u.data.pointer, msg, wrq->u.data.length);
	}
	printk("<==RTMPIoctlBBP\n");
}

/* 
    ==========================================================================
    Description:
        Read / Write MAC
Arguments:
    pAdapter                    Pointer to our adapter
    wrq                         Pointer to the ioctl argument

    Return Value:
        None

    Note:
        Usage: 
               1.) iwpriv ra0 mac 0        ==> read MAC where Addr=0x0
               2.) iwpriv ra0 mac 0=12     ==> write MAC where Addr=0x0, value=12
    ==========================================================================
*/
VOID RTMPIoctlMAC(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	struct iwreq	*wrq)
{
	char				*this_char;
	char				*value;
	int					j=0, k=0;
	int					count = 0;
	char				msg[1024];
	char				arg[255];
	char				*ptr;
	ULONG				macAddr = 0;
	UCHAR				temp[16], temp2[16];
	ULONG				macValue;

	printk("==>RTMPIoctlMAC\n");
	memset(msg, 0x00, 1024);
	if (wrq->u.data.length > 1) //No parameters.
	{
		memcpy(arg, wrq->u.data.pointer, (wrq->u.data.length > 255) ? 255 : wrq->u.data.length);
		ptr = arg;
		sprintf(msg, "\n");
		//Parsing Read or Write
		while ((this_char = strsep(&ptr, ",")) != NULL)
		{
			printk("this_char=%s\n", this_char);
			if (!*this_char)
				continue;

			if ((value = strchr(this_char, '=')) != NULL)
				*value++ = 0;

			if (!value || !*value)
			{ //Read
				printk("Read: this_char=%s, strlen=%d\n", this_char, strlen(this_char));

				// Sanity check
				if(strlen(this_char) > 4)
					break;

				j = strlen(this_char);
				while(j-- > 0)
				{
					if(this_char[j] > 'f' || this_char[j] < '0')
						return;
				}

				// Mac Addr
				k = j = strlen(this_char);
				while(j-- > 0)
				{
					this_char[4-k+j] = this_char[j];
				}
				
				while(k < 4)
					this_char[3-k++]='0';
				this_char[4]='\0';

				if(strlen(this_char) == 4)
				{
					AtoH(this_char, temp, 4);
					macAddr = *temp*256 + temp[1];					
					if (macAddr < 0xFFFF)
					{
						RTMP_IO_READ32(pAdapter, macAddr, &macValue);
						printk("macAddr=%x, regMAC=%x\n", macAddr, macValue);
						sprintf(msg+strlen(msg), "[0x%08X]:%08X  ", macAddr , macValue);
						count++;
						if (count%5 == 4)
							sprintf(msg+strlen(msg), "\n");
						printk("msg=%s\n", msg);
					}
					else
					{//Invalid parametes, so default printk all bbp
						break;
					}
				}
			}
			else
			{ //Write
				printk("Write: this_char=%s, strlen(value)=%d, value=%s\n", this_char, strlen(value), value);
				memcpy(&temp2, value, strlen(value));
				temp2[strlen(value)] = '\0';

				// Sanity check
				if((strlen(this_char) > 4) || strlen(temp2) > 8)
					break;

				j = strlen(this_char);
				while(j-- > 0)
				{
					if(this_char[j] > 'f' || this_char[j] < '0')
						return;
				}

				j = strlen(temp2);
				while(j-- > 0)
				{
					if(temp2[j] > 'f' || temp2[j] < '0')
						return;
				}

				//MAC Addr
				k = j = strlen(this_char);
				while(j-- > 0)
				{
					this_char[4-k+j] = this_char[j];
				}

				while(k < 4)
					this_char[3-k++]='0';
				this_char[4]='\0';

				//MAC value
				k = j = strlen(temp2);
				while(j-- > 0)
				{
					temp2[8-k+j] = temp2[j];
				}
				
				while(k < 8)
					temp2[7-k++]='0';
				temp2[8]='\0';

				{
					AtoH(this_char, temp, 4);
					macAddr = *temp*256 + temp[1];

					AtoH(temp2, temp, 8);
					macValue = *temp*256*256*256 + temp[1]*256*256 + temp[2]*256 + temp[3];

					printk("macAddr=%02x, macValue=0x%x\n", macAddr, macValue);
					
					RTMP_IO_WRITE32(pAdapter, macAddr, macValue);
					sprintf(msg+strlen(msg), "[0x%02X]:%02X  ", macAddr, macValue);
					count++;
					if (count%5 == 4)
						sprintf(msg+strlen(msg), "\n");
					printk("msg=%s\n", msg);
				}
			}
		}
	}

	if(strlen(msg) == 1)
		sprintf(msg+strlen(msg), "===>Error command format!");
	printk("copy to user [msg=%s]\n", msg);
	// Copy the information into the user buffer
	printk("strlen(msg) =%d\n", strlen(msg));
	wrq->u.data.length = strlen(msg);
	copy_to_user(wrq->u.data.pointer, msg, wrq->u.data.length);
	
	printk("<==RTMPIoctlMAC\n");
}

/* 
    ==========================================================================
    Description:
        Read / Write E2PROM
Arguments:
    pAdapter                    Pointer to our adapter
    wrq                         Pointer to the ioctl argument

    Return Value:
        None

    Note:
        Usage: 
               1.) iwpriv ra0 e2p 0     	==> read E2PROM where Addr=0x0
               2.) iwpriv ra0 e2p 0=1234    ==> write E2PROM where Addr=0x0, value=1234
    ==========================================================================
*/
VOID RTMPIoctlE2PROM(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	struct iwreq	*wrq)
{
	char				*this_char;
	char				*value;
	int					j=0, k=0;
	int					count = 0;
	char				msg[1024];
	char				arg[255];
	char				*ptr;
	USHORT				eepAddr = 0;
	UCHAR				temp[16], temp2[16];
	USHORT				eepValue;

	printk("==>RTMPIoctlE2PROM\n");
	memset(msg, 0x00, 1024);
	if (wrq->u.data.length > 1) //No parameters.
	{
		memcpy(arg, wrq->u.data.pointer, (wrq->u.data.length > 255) ? 255 : wrq->u.data.length);
		ptr = arg;
		sprintf(msg, "\n");
		//Parsing Read or Write
		while ((this_char = strsep(&ptr, ",")) != NULL)
		{
			printk("this_char=%s\n", this_char);
			if (!*this_char)
				continue;

			if ((value = strchr(this_char, '=')) != NULL)
				*value++ = 0;

			if (!value || !*value)
			{ //Read
				printk("Read: this_char=%s, strlen=%d\n", this_char, strlen(this_char));

				// Sanity check
				if(strlen(this_char) > 4)
					break;

				j = strlen(this_char);
				while(j-- > 0)
				{
					if(this_char[j] > 'f' || this_char[j] < '0')
						return;
				}

				// E2PROM addr
				k = j = strlen(this_char);
				while(j-- > 0)
				{
					this_char[4-k+j] = this_char[j];
				}
				
				while(k < 4)
					this_char[3-k++]='0';
				this_char[4]='\0';

				if(strlen(this_char) == 4)
				{
					AtoH(this_char, temp, 4);
					eepAddr = *temp*256 + temp[1];					
					if (eepAddr < 0xFFFF)
					{
						eepValue = RTMP_EEPROM_READ16(pAdapter, eepAddr);
						printk("eepAddr=%x, eepValue=%x\n", eepAddr, eepValue);
						sprintf(msg+strlen(msg), "[0x%04X]:%04X  ", eepAddr , eepValue);
						count++;
						if (count%5 == 4)
							sprintf(msg+strlen(msg), "\n");
						printk("msg=%s\n", msg);
					}
					else
					{//Invalid parametes, so default printk all bbp
						break;
					}
				}
			}
			else
			{ //Write
				printk("Write: this_char=%s, strlen(value)=%d, value=%s\n", this_char, strlen(value), value);
				memcpy(&temp2, value, strlen(value));
				temp2[strlen(value)] = '\0';

				// Sanity check
				if((strlen(this_char) > 4) || strlen(temp2) > 8)
					break;

				j = strlen(this_char);
				while(j-- > 0)
				{
					if(this_char[j] > 'f' || this_char[j] < '0')
						return;
				}
				j = strlen(temp2);
				while(j-- > 0)
				{
					if(temp2[j] > 'f' || temp2[j] < '0')
						return;
				}

				//MAC Addr
				k = j = strlen(this_char);
				while(j-- > 0)
				{
					this_char[4-k+j] = this_char[j];
				}

				while(k < 4)
					this_char[3-k++]='0';
				this_char[4]='\0';

				//MAC value
				k = j = strlen(temp2);
				while(j-- > 0)
				{
					temp2[4-k+j] = temp2[j];
				}
				
				while(k < 4)
					temp2[3-k++]='0';
				temp2[4]='\0';

				AtoH(this_char, temp, 4);
				eepAddr = *temp*256 + temp[1];

				AtoH(temp2, temp, 4);
				eepValue = *temp*256 + temp[1];

				printk("eepAddr=%02x, eepValue=0x%x\n", eepAddr, eepValue);
				
				RTMP_EEPROM_WRITE16(pAdapter, eepAddr, eepValue);
				sprintf(msg+strlen(msg), "[0x%02X]:%02X  ", eepAddr, eepValue);
				count++;
				if (count%5 == 4)
					sprintf(msg+strlen(msg), "\n");
				printk("msg=%s\n", msg);
			}
		}
	}

	if(strlen(msg) == 1)
		sprintf(msg+strlen(msg), "===>Error command format!");

        // Copy the information into the user buffer	
        printk("copy to user [msg=%s]\n", msg);	
	wrq->u.data.length = strlen(msg);
	copy_to_user(wrq->u.data.pointer, msg, wrq->u.data.length);
	
	printk("<==RTMPIoctlE2PROM\n");
}

/* 
    ==========================================================================
    Description:
        Read statistics counter
Arguments:
    pAdapter                    Pointer to our adapter
    wrq                         Pointer to the ioctl argument

    Return Value:
        None

    Note:
        Usage: 
               1.) iwpriv ra0 stat 0     	==> Read statistics counter
    ==========================================================================
*/
VOID RTMPIoctlStatistics(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	struct iwreq	*wrq)
{
    char				msg[1024];
    
    DBGPRINT(RT_DEBUG_TRACE, "==>RTMPIoctlStatistics\n");

    memset(msg, 0x00, 1024);
    sprintf(msg, "\n");

    sprintf(msg+strlen(msg), "Frame Trans success = %d\n", (ULONG)pAdapter->WlanCounters.TransmittedFragmentCount);
    sprintf(msg+strlen(msg), "Frame Trans success without retry = %d\n", (ULONG)pAdapter->WlanCounters.TransmittedFragmentCount - (ULONG)pAdapter->WlanCounters.RetryCount);
    sprintf(msg+strlen(msg), "Frame Trans success after retry = %d\n", (ULONG)pAdapter->WlanCounters.RetryCount);
    sprintf(msg+strlen(msg), "Fail to Rcv ACK after all retry = %d\n", (ULONG)pAdapter->WlanCounters.FailedCount);
    sprintf(msg+strlen(msg), "RTS Success Rcv CTS = %d\n", (ULONG)pAdapter->WlanCounters.RTSSuccessCount);
    sprintf(msg+strlen(msg), "RTS Fail Rcv CTS = %d\n", (ULONG)pAdapter->WlanCounters.RTSFailureCount);

    sprintf(msg+strlen(msg), "Frame Rcv success = %d\n", (ULONG)pAdapter->Counters.GoodReceives);
    sprintf(msg+strlen(msg), "Frame Rcv with CRC = %d\n", (ULONG)pAdapter->WlanCounters.FCSErrorCount);
    sprintf(msg+strlen(msg), "Frame drop due to out of resource = %d\n", (ULONG)pAdapter->Counters.RxNoBuffer);
    sprintf(msg+strlen(msg), "Duplicate frame Rcv = %d\n", (ULONG)pAdapter->WlanCounters.FrameDuplicateCount);
    
	// Copy the information into the user buffer
	printk("copy to user [msg=%s]\n", msg);
	wrq->u.data.length = strlen(msg);
	copy_to_user(wrq->u.data.pointer, msg, wrq->u.data.length);
	
    DBGPRINT(RT_DEBUG_TRACE, "<==RTMPIoctlStatistics\n");
}
#endif //#ifdef RT2500_DBG


#ifdef RALINK_ATE
UCHAR TempletFrame[24] = {0x08,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0xAA,0xBB,0x12,0x34,0x56,0x00,0x11,0x22,0xAA,0xBB,0xCC,0x00,0x00};	// 802.11 MAC Header, Type:Data, Length:24bytes 

/*
    ==========================================================================
    Description:
        Set ATE operation mode to
        0. APSTOP  = Stop AP Mode
        1. APSTART = Start AP Mode
        2. TXCONT  = Continuous Transmit
        3. TXCARR  = Transmit Carrier
        4. TXFRAME = Transmit Frames
        5. RXFRAME = Receive Frames
    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_ATE_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	USHORT			BbpData;
	ULONG			MacData;
	PTXD_STRUC		pTxD;
	PUCHAR			pDest;
	UINT			i, j;
	struct sk_buff	*skb;
	NDIS_STATUS     Status;
	
	DBGPRINT(RT_DEBUG_TRACE, "==> Set_ATE_Proc\n");
	DBGPRINT(RT_DEBUG_TRACE, "arg=%s\n", arg);

	AsicSwitchChannel(pAdapter, pAdapter->PortCfg.Channel);
	AsicLockChannel(pAdapter, pAdapter->PortCfg.Channel);

	RTMP_BBP_IO_READ32_BY_REG_ID(pAdapter, 63, &BbpData);
	RTMP_IO_READ32(pAdapter, MACCSR1, &MacData);

	BbpData = 0;
	MacData &= 0xFBFFFFFF;

	if (!strcmp(arg, "APSTOP")) 
	{						
		DBGPRINT(RT_DEBUG_TRACE, "ATE: APSTOP\n");
		
		pAdapter->ate.Mode = ATE_APSTOP;

		netif_stop_queue(pAdapter->net_dev);
		ApStop(pAdapter);
		RTMP_IO_WRITE32(pAdapter, RXCSR0, 0xffffffff);	// Stop Rx
	}
	else if (!strcmp(arg, "APSTART")) 
	{						
		DBGPRINT(RT_DEBUG_TRACE, "ATE: APSTART\n");
		
		pAdapter->ate.Mode = ATE_APSTART;

		RTMP_IO_WRITE32(pAdapter, RXCSR0, 0x56);	// Start Rx
		netif_start_queue(pAdapter->net_dev);
		ApStartUp(pAdapter);
	}
	else if (!strcmp(arg, "TXCONT")) 		// Continuous Tx
	{						
		DBGPRINT(RT_DEBUG_TRACE, "ATE: TXCONT\n");
		
		pAdapter->ate.Mode = ATE_TXCONT;

		BbpData |= 0x80;
		MacData |= 0x04000000;

		for (i = 0; (i < TX_RING_SIZE) && (i < pAdapter->ate.TxCount); i++)
		{
			pTxD = (PTXD_STRUC)pAdapter->TxRing[pAdapter->CurEncryptIndex].va_addr;
			pDest = (PUCHAR) pAdapter->TxRing[pAdapter->CurEncryptIndex].va_data_addr;

			// Prepare frame payload
			memcpy(pDest, &TempletFrame, LENGTH_802_11);
			for(j = LENGTH_802_11; j < pAdapter->ate.TxLength; j++)
				pDest[j] = 0xAA;
			memcpy(&pDest[4], &pAdapter->ate.Addr1, ETH_LENGTH_OF_ADDRESS);
			memcpy(&pDest[10], &pAdapter->ate.Addr2, ETH_LENGTH_OF_ADDRESS);
			memcpy(&pDest[16], &pAdapter->ate.Addr3, ETH_LENGTH_OF_ADDRESS);

			RTMPWriteTxDescriptor(pTxD, TRUE, CIPHER_NONE, FALSE, FALSE, FALSE,
				SHORT_RETRY, IFS_SIFS, pAdapter->ate.TxRate, 4,
				pAdapter->ate.TxLength, pAdapter->PortCfg.TxPreamble, 0);

			pAdapter->CurEncryptIndex++;
	        if (pAdapter->CurEncryptIndex >= TX_RING_SIZE)
	        {
	            pAdapter->CurEncryptIndex = 0;
	        }
		}

		RTMP_IO_WRITE32(pAdapter, RXCSR0, 0xffffffff);
		RTMP_IO_WRITE32(pAdapter, SECCSR1, 0x1);
	}
	else if (!strcmp(arg, "TXCARR"))			// Tx Carrier -------------------------------------
	{
		DBGPRINT(RT_DEBUG_TRACE, "ATE: TXCARR\n");
		pAdapter->ate.Mode = ATE_TXCARR;

		BbpData |= 0x40;
		MacData |= 0x04000000;

		for (i = 0; (i < TX_RING_SIZE) && (i < pAdapter->ate.TxCount); i++)
		{
			pTxD = (PTXD_STRUC)pAdapter->TxRing[pAdapter->CurEncryptIndex].va_addr;
			pDest = (PUCHAR) pAdapter->TxRing[pAdapter->CurEncryptIndex].va_data_addr;

			// Prepare frame payload
			memcpy(pDest, &TempletFrame, LENGTH_802_11);
			for(j = LENGTH_802_11; j < pAdapter->ate.TxLength; j++)
				pDest[j] = 0xAA;
			memcpy(&pDest[4], &pAdapter->ate.Addr1, ETH_LENGTH_OF_ADDRESS);
			memcpy(&pDest[10], &pAdapter->ate.Addr2, ETH_LENGTH_OF_ADDRESS);
			memcpy(&pDest[16], &pAdapter->ate.Addr3, ETH_LENGTH_OF_ADDRESS);

			RTMPWriteTxDescriptor(pTxD, TRUE, CIPHER_NONE, FALSE, FALSE, FALSE,
				SHORT_RETRY, IFS_BACKOFF, pAdapter->ate.TxRate, 4,
				pAdapter->ate.TxLength, pAdapter->PortCfg.TxPreamble, 0);

			pAdapter->CurEncryptIndex++;
	        if (pAdapter->CurEncryptIndex >= TX_RING_SIZE)
	        {
	            pAdapter->CurEncryptIndex = 0;
	        }
		}

		RTMP_IO_WRITE32(pAdapter, RXCSR0, 0xffffffff);
		RTMP_IO_WRITE32(pAdapter, SECCSR1, 0x1);
	}
	else if (!strcmp(arg, "TXFRAME"))			// Tx Frames --------------------------------------
	{						
		DBGPRINT(RT_DEBUG_TRACE, "ATE: TXFRAME(Count=%d)\n", pAdapter->ate.TxCount);
		pAdapter->ate.Mode = ATE_TXFRAME;

		pAdapter->ate.TxDoneCount = 0;
		
		for (i = 0; (i < TX_RING_SIZE) && (i < pAdapter->ate.TxCount); i++)
		{
			pTxD = (PTXD_STRUC)pAdapter->TxRing[pAdapter->CurEncryptIndex].va_addr;
			pDest = (PUCHAR) pAdapter->TxRing[pAdapter->CurEncryptIndex].va_data_addr;

			// Prepare frame payload
			memcpy(pDest, &TempletFrame, LENGTH_802_11);
			for(j = LENGTH_802_11; j < pAdapter->ate.TxLength; j++)
				pDest[j] = 0xAA;
			memcpy(&pDest[4], &pAdapter->ate.Addr1, ETH_LENGTH_OF_ADDRESS);
			memcpy(&pDest[10], &pAdapter->ate.Addr2, ETH_LENGTH_OF_ADDRESS);
			memcpy(&pDest[16], &pAdapter->ate.Addr3, ETH_LENGTH_OF_ADDRESS);

			RTMPWriteTxDescriptor(pTxD, TRUE, CIPHER_NONE, FALSE, FALSE, FALSE,
				SHORT_RETRY, IFS_BACKOFF, pAdapter->ate.TxRate, 4,
				pAdapter->ate.TxLength, pAdapter->PortCfg.TxPreamble, 0);

			pAdapter->CurEncryptIndex++;
	        if (pAdapter->CurEncryptIndex >= TX_RING_SIZE)
	        {
	            pAdapter->CurEncryptIndex = 0;
	        }
		}
		pAdapter->ate.TxDoneCount += i;

		RTMP_IO_WRITE32(pAdapter, RXCSR0, 0xffffffff);
		RTMP_IO_WRITE32(pAdapter, SECCSR1, 0x1);
	}
	else if (!strcmp(arg, "RXFRAME")) 			// Rx Frames --------------------------------------
	{						
		DBGPRINT(RT_DEBUG_TRACE, "ATE: RXFRAME\n");
		pAdapter->ate.Mode = ATE_RXFRAME;
		pAdapter->ate.TxDoneCount = pAdapter->ate.TxCount;
		
		RTMP_IO_WRITE32(pAdapter, TXCSR0, 0x08);		// Abort Tx
		RTMP_IO_WRITE32(pAdapter, RXCSR0, 0x56);		// Start Rx
	}
	else
	{	
		DBGPRINT(RT_DEBUG_TRACE, "ATE:	Invalid arg!\n");
		return FALSE;
	}

	RTMP_IO_WRITE32(pAdapter, MACCSR1, MacData);
	RTMP_BBP_IO_WRITE32_BY_REG_ID(pAdapter, 63, BbpData);
	
	DBGPRINT(RT_DEBUG_TRACE, "<== Set_ATE_Proc\n");
	return TRUE;
}

/* 
    ==========================================================================
    Description:
        Set ATE ADDR1=DA for TxFrames    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_ATE_DA_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	char				*value;
	int					i;
	
	DBGPRINT(RT_DEBUG_TRACE, "==> Set_ATE_DA_Proc\n");
	DBGPRINT(RT_DEBUG_TRACE, "arg=%s\n", arg);
	
	if(strlen(arg) != 17)  //Mac address acceptable format 01:02:03:04:05:06 length 17
		return FALSE;

    for (i=0, value = strtok(arg,":"); value; value = strtok(NULL,":")) 
	{
		if((strlen(value) != 2) || (!isxdigit(*value)) || (!isxdigit(*(value+1))) ) 
			return FALSE;  //Invalid

		AtoH(value, &pAdapter->ate.Addr1[i++], 2);
	}

	if(i != 6)
		return FALSE;  //Invalid
		
	DBGPRINT(RT_DEBUG_TRACE, "DA=%2X:%2X:%2X:%2X:%2X:%2X\n", pAdapter->ate.Addr1[0], pAdapter->ate.Addr1[1], pAdapter->ate.Addr1[2], pAdapter->ate.Addr1[3], pAdapter->ate.Addr1[4], pAdapter->ate.Addr1[5]);
	DBGPRINT(RT_DEBUG_TRACE, "<== Set_ATE_DA_Proc\n");
	
	return TRUE;
}

/* 
    ==========================================================================
    Description:
        Set ATE ADDR2=SA for TxFrames    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_ATE_SA_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	char				*value;
	int					i;
	
	DBGPRINT(RT_DEBUG_TRACE, "==> Set_ATE_SA_Proc\n");
	DBGPRINT(RT_DEBUG_TRACE, "arg=%s\n", arg);
	
	if(strlen(arg) != 17)  //Mac address acceptable format 01:02:03:04:05:06 length 17
		return FALSE;

    for (i=0, value = strtok(arg,":"); value; value = strtok(NULL,":")) 
	{
		if((strlen(value) != 2) || (!isxdigit(*value)) || (!isxdigit(*(value+1))) ) 
			return FALSE;  //Invalid

		AtoH(value, &pAdapter->ate.Addr2[i++], 2);
	}

	if(i != 6)
		return FALSE;  //Invalid

	DBGPRINT(RT_DEBUG_TRACE, "DA=%2X:%2X:%2X:%2X:%2X:%2X\n", pAdapter->ate.Addr2[0], pAdapter->ate.Addr2[1], pAdapter->ate.Addr2[2], pAdapter->ate.Addr2[3], pAdapter->ate.Addr2[4], pAdapter->ate.Addr2[5]);
	DBGPRINT(RT_DEBUG_TRACE, "<== Set_ATE_SA_Proc\n");
	
	return TRUE;
}

/* 
    ==========================================================================
    Description:
        Set ATE ADDR3=BSSID for TxFrames    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_ATE_BSSID_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	char				*value;
	int					i;
	
	DBGPRINT(RT_DEBUG_TRACE, "==> Set_ATE_BSSID_Proc\n");
	DBGPRINT(RT_DEBUG_TRACE, "arg=%s\n", arg);
	
	if(strlen(arg) != 17)  //Mac address acceptable format 01:02:03:04:05:06 length 17
		return FALSE;

    for (i=0, value = strtok(arg,":"); value; value = strtok(NULL,":")) 
	{
		if((strlen(value) != 2) || (!isxdigit(*value)) || (!isxdigit(*(value+1))) ) 
			return FALSE;  //Invalid

		AtoH(value, &pAdapter->ate.Addr3[i++], 2);
	}

	if(i != 6)
		return FALSE;  //Invalid

	DBGPRINT(RT_DEBUG_TRACE, "DA=%2X:%2X:%2X:%2X:%2X:%2X\n", pAdapter->ate.Addr3[0], pAdapter->ate.Addr3[1], pAdapter->ate.Addr3[2], pAdapter->ate.Addr3[3], pAdapter->ate.Addr3[4], pAdapter->ate.Addr3[5]);
	DBGPRINT(RT_DEBUG_TRACE, "<== Set_ATE_BSSID_Proc\n");
	
	return TRUE;
}

/* 
    ==========================================================================
    Description:
        Set ATE Tx Power    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_ATE_TX_POWER_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	ULONG R3;
	
	DBGPRINT(RT_DEBUG_TRACE, "==> Set_ATE_TX_POWER_Proc\n");
	DBGPRINT(RT_DEBUG_TRACE, "arg=%s\n", arg);
	
	pAdapter->ate.TxPower = simple_strtol(arg, 0, 10);

	if(pAdapter->ate.TxPower >= 32)
	{
		pAdapter->ate.TxPower = pAdapter->PortCfg.ChannelTxPower[pAdapter->PortCfg.Channel - 1];;
		return FALSE;
	}

	R3 = pAdapter->ate.TxPower;
        R3 = R3 << 9; // shift TX power control to correct RF register bit position

	R3 |= pAdapter->PortCfg.LatchRfRegs.R3;
	RTMP_RF_IO_WRITE32(pAdapter, R3);

	DBGPRINT(RT_DEBUG_TRACE, "TxPower = %d\n", pAdapter->ate.TxPower);
	DBGPRINT(RT_DEBUG_TRACE, "<== Set_ATE_TX_POWER_Proc\n");
	
	return TRUE;
}

/* 
    ==========================================================================
    Description:
        Set ATE Tx Length    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_ATE_TX_LENGTH_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	DBGPRINT(RT_DEBUG_TRACE, "==> Set_ATE_TX_LENGTH_Proc\n");
	DBGPRINT(RT_DEBUG_TRACE, "arg=%s\n", arg);
	
	pAdapter->ate.TxLength = simple_strtol(arg, 0, 10);

	if((pAdapter->ate.TxLength < 24) || (pAdapter->ate.TxLength > 1500))
	{
		pAdapter->ate.TxLength = 1500;
		return FALSE;
	}

	DBGPRINT(RT_DEBUG_TRACE, "TxLength = %d\n", pAdapter->ate.TxLength);
	DBGPRINT(RT_DEBUG_TRACE, "<== Set_ATE_TX_LENGTH_Proc\n");
	
	return TRUE;
}

/* 
    ==========================================================================
    Description:
        Set ATE Tx Count    Return:
        TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_ATE_TX_COUNT_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	DBGPRINT(RT_DEBUG_TRACE, "==> Set_ATE_TX_COUNT_Proc\n");
	DBGPRINT(RT_DEBUG_TRACE, "arg=%s\n", arg);
	
	pAdapter->ate.TxCount = simple_strtol(arg, 0, 10);

	DBGPRINT(RT_DEBUG_TRACE, "TxCount = %d\n", pAdapter->ate.TxCount);
	DBGPRINT(RT_DEBUG_TRACE, "<== Set_ATE_TX_COUNT_Proc\n");
	
	return TRUE;
}

/* 
    ==========================================================================
    Description:
        Set ATE Tx Rate
        Return:
        	TRUE if all parameters are OK, FALSE otherwise
    ==========================================================================
*/
INT	Set_ATE_TX_RATE_Proc(
	IN	PRTMP_ADAPTER	pAdapter, 
	IN	PUCHAR			arg)
{
	DBGPRINT(RT_DEBUG_TRACE, "==> Set_ATE_TX_RATE_Proc\n");
	DBGPRINT(RT_DEBUG_TRACE, "arg=%s\n", arg);
	
	pAdapter->ate.TxRate = simple_strtol(arg, 0, 10);

	if(pAdapter->ate.TxRate > RATE_54)
	{
		pAdapter->ate.TxRate = RATE_11;
		return FALSE;
	}

	DBGPRINT(RT_DEBUG_TRACE, "TxRate = %d\n", pAdapter->ate.TxRate);
	DBGPRINT(RT_DEBUG_TRACE, "<== Set_ATE_TX_RATE_Proc\n");
	
	return TRUE;
}
#endif	//#ifdef RALINK_ATE

