#ifndef MD5_H
#define MD5_H

#define MD5_MAC_LEN         16
#define SHA_DIGEST_LEN      20

// MD5
struct MD5Context {
	UINT buf[4];
	UINT bits[2];
	UCHAR in[64];
};

typedef struct MD5Context MD5_CTX;

VOID MD5Init(struct MD5Context *context);
VOID MD5Update(struct MD5Context *context, unsigned char const *buf, unsigned len);
VOID MD5Final(UCHAR digest[16], struct MD5Context *context);
VOID MD5Transform(UINT buf[4], UINT const in[16]);
VOID md5_mac(UCHAR *key, size_t key_len, UCHAR *data, size_t data_len, UCHAR *mac);
VOID hmac_md5(UCHAR *key, 	size_t key_len, UCHAR *data, size_t data_len, UCHAR *mac);


// AES
typedef struct
{
    UINT    erk[64];     /* encryption round keys */
    UINT    drk[64];     /* decryption round keys */
    INT     nr;             /* number of rounds */
}aes_context;

INT  aes_set_key( aes_context *ctx, UCHAR *key, INT nbits );
VOID aes_encrypt( aes_context *ctx, UCHAR input[16], UCHAR output[16] );
VOID aes_decrypt( aes_context *ctx, UCHAR input[16], UCHAR output[16] );


// SHA
typedef struct {
    ULONG       H[5];
    ULONG       W[80];
    INT         lenW;
    ULONG       sizeHi,sizeLo;
} SHA_CTX;

VOID SHAInit(SHA_CTX *ctx);
//static VOID SHAHashBlock(SHA_CTX *ctx);
VOID SHAUpdate(SHA_CTX *ctx, unsigned char *dataIn, int len);
VOID SHAFinal(SHA_CTX *ctx, unsigned char hashout[20]);
VOID HMAC_SHA1(UCHAR *text, UINT text_len, UCHAR *key, UINT key_len, UCHAR *digest);
//static VOID F(CHAR *password, UCHAR *ssid, INT ssidlength, INT iterations, INT count, UCHAR *output);
INT PasswordHash(CHAR *password, UCHAR *ssid, INT ssidlength, UCHAR *output);

#endif // MD5_H
