/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

	Module Name:
	mlme.h

	Abstract:

	Revision History:
	Who			When			What
	--------	----------		----------------------------------------------
	Name		Date			Modification logs
*/

#ifndef __WPA_H__
#define __WPA_H__

#define     WPA_RETRY_EXEC_INTV     (1 * HZ)
#define     GUPDATE_EXEC_INTV     (10 * HZ)
//pentry flag
#define DISASSOC_4_WAY_TMOUT    0x01
#define DISASSOC_GRP_UDATE_TMOUT 0x02
#define DIS_REASON_RSNIE_DIFF               0x04

// Retry timer counter initial value
#define PAIR_HS_RETRY_TIMER_CTR      0
#define GRP_HS_RETRY_TIMER_CTR      20

//EAP Packet Type
#define EAPPacket		0
#define EAPOLStart		1
#define EAPOLLogoff		2
#define EAPOLKey		3
#define EAPOLASFAlert	4
#define EAPTtypeMax		5

#define LENGTH_8021X_HDR        4

// other EAP Code Request and Response are useful only in daemon.
#define EAP_CODE_SUCCESS  3
#define EAP_CODE_FAILURE 4


//EPA vERSION
#define EAPOL_VER 		1

#define DESC_TYPE_OTHER		1
#define DESC_TYPE_AES		2

#define RSN_KEY_DESC         0xfe

#define LEN_MSG1_2WAY       0x7f


#define MAX_LEN_OF_RSNIE    48
//0xdd,len,00:50:f2:01,ver(2 octets)
#define MIN_LEN_OF_RSNIE    8   
#define MAX_LEN_OF_EAP_HS            256

// group rekey interval
#define TIME_REKEY              0
#define PKT_REKEY               1
#define DISABLE_REKEY           2
#define MAX_REKEY			2

#define MAX_REKEY_INTER	0x3ffffff

typedef struct _RSNIE {
	UCHAR oui[4];
	USHORT version;
	UCHAR mcast[4];
	USHORT ucount;
	struct{
		UCHAR oui[4];
	}ucast[1];
} RSNIE, *PRSNIE;

typedef struct _RSNIE_AUTH {
	USHORT acount;
	struct{
		UCHAR oui[4];
	}auth[1];
} RSNIE_AUTH,*PRSNIE_AUTH;

typedef struct _EAP_HDR {
	UCHAR code;
	UCHAR identifier;
	UCHAR length[2]; /* including code and identifier */
	/* followed by length-2 octets of data */
} EAP_HDR, *PEAP_HDR;

typedef struct _KEY_DESCRIPTER {
	UCHAR		Type; //0
	UCHAR		Keyinfo[2];//1~2
	UCHAR		KeyLength[2];//3~4
	UCHAR		RCounter[LEN_KEY_DESC_REPLAY];//5~12
	UCHAR		Nonce[LEN_KEY_DESC_NONCE];//13~44
	UCHAR		IV[LEN_KEY_DESC_IV];//45~60
	UCHAR		RSC[LEN_KEY_DESC_RSC];//61~68
	UCHAR		ID[LEN_KEY_DESC_ID];//69~76
	UCHAR		MIC[LEN_KEY_DESC_MIC];//77~92
	UCHAR		DataLen[2];//93~94
	UCHAR		Data[MAX_LEN_OF_RSNIE];//95~End
} KEY_DESCRIPTER, *PKEY_DESCRIPTER;

typedef struct _EAPOL_PACKET {
	UCHAR    ProVer;
		UCHAR    ProType;
	UCHAR    Body_Len[2];
		KEY_DESCRIPTER      KeyDesc;
} EAPOL_PACKET, *PEAPOL_PACKET;

BOOLEAN WPAMsgTypeSubst(
	IN UCHAR	EAPType,
	OUT ULONG *MsgType) ;

VOID WpaStateMachineInit(
	IN	PRTMP_ADAPTER	pAd, 
	IN  STATE_MACHINE *S, 
	OUT STATE_MACHINE_FUNC Trans[]);

MAC_TABLE_ENTRY *PACInquiry(
	IN	PRTMP_ADAPTER	pAd, 
	IN MACADDR *pAddr, 
	OUT NDIS_802_11_PRIVACY_FILTER   *Privacy,
	OUT      WPA_STATE	   *WpaState);

BOOLEAN RTMPCheckWPAframe(
	IN PRTMP_ADAPTER pAdapter,
	IN PUCHAR pHeader,
	IN ULONG DataByteCount);

BOOLEAN RTMPCheckMcast(
	IN PRTMP_ADAPTER pAdapter,
	PEID_STRUCT  eid_ptr);

BOOLEAN RTMPCheckUcast(
	IN PRTMP_ADAPTER pAdapter,
	PEID_STRUCT  eid_ptr);

BOOLEAN RTMPCheckAUTH(
	IN PRTMP_ADAPTER pAdapter,
	PEID_STRUCT  eid_ptr);

VOID WPAStart4WayHS(
		IN	PRTMP_ADAPTER	pAdapter, 
		IN 	MAC_TABLE_ENTRY       *pEntry);

VOID WpaEAPPacketAction(
	IN PRTMP_ADAPTER pAd, 
	IN MLME_QUEUE_ELEM *Elem);

VOID WpaEAPOLStartAction(
	IN PRTMP_ADAPTER pAd, 
	IN MLME_QUEUE_ELEM *Elem);

VOID WpaEAPOLLogoffAction(
	IN PRTMP_ADAPTER pAd, 
	IN MLME_QUEUE_ELEM *Elem);

VOID WpaEAPOLKeyAction(
	IN PRTMP_ADAPTER pAd, 
	IN MLME_QUEUE_ELEM *Elem);

VOID HandleCounterMeasure(
		IN PRTMP_ADAPTER pAd, 
	IN MAC_TABLE_ENTRY	*pEntry);

VOID PeerPairMsg2Action(
	IN PRTMP_ADAPTER pAdapter, 
	IN MAC_TABLE_ENTRY	*pEntry,
	IN MLME_QUEUE_ELEM *Elem);

VOID CMTimerExec(
	IN	unsigned long data);

VOID WPARetryExec(
	IN	unsigned long data);

VOID PeerPairMsg4Action(
	IN PRTMP_ADAPTER pAdapter, 
	IN MAC_TABLE_ENTRY	*pEntry,
	IN MLME_QUEUE_ELEM *Elem);

VOID PeerGroupMsg2Action(
	IN PRTMP_ADAPTER pAdapter, 
	IN MAC_TABLE_ENTRY	*pEntry,
	IN VOID *Msg,
	IN UINT   MsgLen);

NDIS_STATUS	WPAHardTransmit(
	IN	PRTMP_ADAPTER	pAdapter,
	IN		MAC_TABLE_ENTRY	*pEntry);

VOID WpaEAPOLASFAlertAction(
	IN PRTMP_ADAPTER pAd, 
	IN MLME_QUEUE_ELEM *Elem);

VOID PairDisAssocAction(
	IN PRTMP_ADAPTER pAd, 
	IN     MAC_TABLE_ENTRY       *pEntry,
	IN USHORT		Reason);

VOID DisAssocAction(
	IN PRTMP_ADAPTER pAd, 
	IN     MAC_TABLE_ENTRY       *pEntry,
	IN USHORT SubType,
	IN USHORT		Reason);

VOID GREKEYPeriodicExec
(
	IN	unsigned long data);

VOID WPAMake8023Hdr(
	IN PRTMP_ADAPTER	pAd, 
	IN PCHAR pDAddr, 
	IN OUT PCHAR pHdr);


VOID HMAC_SHA1(
	IN UCHAR *text,
	IN UINT text_len,
	IN UCHAR *key,
	IN UINT key_len,
	IN UCHAR *digest);

VOID PRF(
	IN UCHAR	*Key,
	IN INT		key_len,
	IN UCHAR	*Prefix,
	IN INT		Prefix_len,
	IN UCHAR	*Data,
	IN INT		Data_len,
	OUT UCHAR	*Output,
	IN  INT		Output_len);

VOID CountPTK(
	IN		UCHAR	*PMK,
	IN		UCHAR	*ANonce,
	IN		UCHAR	*AA,
	IN		UCHAR	*SNonce,
	IN		UCHAR	*SA,
	OUT	UCHAR	*output,
	IN		UINT	len);

VOID CountGTK(
	IN		UCHAR	*PMK,
	IN		UCHAR	*GNonce,
	IN		UCHAR	*AA,
	OUT	UCHAR	*output,
	IN		UINT	len);

VOID	GetSmall(
	IN	PVOID	pSrc1,
	IN	PVOID	pSrc2,
	OUT	PUCHAR	out,
	IN	ULONG	Length);

VOID	GetLarge(
	IN	PVOID	pSrc1,
	IN	PVOID	pSrc2,
	OUT	PUCHAR	out,
	IN	ULONG	Length);

VOID GenRandom(
	IN PRTMP_ADAPTER pAd, 
	OUT	UCHAR		*random);

VOID AES_GTK_KEY_WRAP( 
	IN UCHAR *key,
	IN UCHAR *plaintext,
	OUT UCHAR *ciphertext);

VOID RTMPToWirelessSta(
	IN  PRTMP_ADAPTER   pAdapter,
	IN  PUCHAR          pFrame,
	IN  UINT            FrameLen);

VOID    WpaSend(
	IN  PRTMP_ADAPTER   pAdapter,
	IN  PUCHAR          pPacket,
	IN  ULONG           Len);

VOID	RTMPMakeRSNIE(
	IN  PRTMP_ADAPTER   pAdapter,
	IN  UINT            AuthMode,
	IN  UINT            WepStatus);
	
#endif

