/****************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 * (c) Copyright 2002, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ****************************************************************************
	 
	 Module Name:
	 sanity.c
	 
	 Abstract:
	 Handle association related requests either from WSTA or from local MLME
	 
	 Revision History:
	 Who         When          What
	 --------    ----------    ----------------------------------------------
	 John Chang  08-14-2003    created for 11g soft-AP

*/

#include "rt_config.h"

/* 
	==========================================================================
	Description:
		MLME message sanity check
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
 */
BOOLEAN PeerAssocReqSanity(
	IN PRTMP_ADAPTER pAd, 
	IN VOID *Msg, 
	IN ULONG MsgLen, 
	OUT MACADDR *pAddr2,
	OUT USHORT *pCapabilityInfo, 
	OUT USHORT *pListenInterval, 
	OUT UCHAR *pSsidLen,
	OUT char *Ssid,
	OUT UCHAR *pRatesLen,
	OUT UCHAR Rates[],
	OUT UCHAR *RSN,
	OUT UCHAR *pRSNLen) 
{
	CHAR         *Ptr;
	MACFRAME     *Fr = (MACFRAME *)Msg;
	PEID_STRUCT	 eid_ptr;
	UCHAR        Sanity=0;
	UCHAR       WPA[4]={0x00,0x50,0xf2,0x01}; //TKIP-OUI
	MAC_TABLE_ENTRY *pEntry = (MAC_TABLE_ENTRY*)NULL;

	DBGPRINT(DEBUG_TEMP, "PeerAssocReqSanity-->\n");
	// to prevent caller from using garbage output value
	*pRatesLen = 0;
	*pRSNLen = 0;
	
	COPY_MAC_ADDR(pAddr2, &Fr->Hdr.Addr2);
	Ptr = Fr->Octet;

	NdisMoveMemory(pCapabilityInfo, &Fr->Octet[0], 2);
	*pCapabilityInfo = RTMP_LE16_TO_CPU( *pCapabilityInfo );//tt_lin_big
	NdisMoveMemory(pListenInterval, &Fr->Octet[2], 2);
	*pListenInterval = RTMP_LE16_TO_CPU( *pListenInterval );//tt_lin_big

	eid_ptr = (PEID_STRUCT) &Fr->Octet[4];

	// get variable fields from payload and advance the pointer
	while (((UCHAR*)eid_ptr + eid_ptr->Len + 1) < ((UCHAR*)Fr + MsgLen))
	{
		switch(eid_ptr->Eid)
		{
			case IE_SSID:
				if(eid_ptr->Len <= MAX_LEN_OF_SSID)
				{
					Sanity |= 0x01;
					NdisMoveMemory(Ssid, eid_ptr->Octet, eid_ptr->Len);
					*pSsidLen = eid_ptr->Len;
				}
				else
				{
					DBGPRINT(RT_DEBUG_TRACE, "PeerAssocReqSanity - wrong IE_SSID\n");
					return FALSE;
				}
				break;
				
			case IE_SUPP_RATES:
				if ((eid_ptr->Len <= MAX_LEN_OF_SUPPORTED_RATES) && (eid_ptr->Len > 0))
				{
					Sanity |= 0x02;
					NdisMoveMemory(Rates, eid_ptr->Octet, eid_ptr->Len);
					*pRatesLen = eid_ptr->Len;
				}
				else
				{
					DBGPRINT(RT_DEBUG_TRACE, "PeerAssocReqSanity - wrong IE_SUPP_RATES\n");
					return FALSE;
				}
				break;
				
			case IE_EXT_SUPP_RATES:
				if (eid_ptr->Len + *pRatesLen <= MAX_LEN_OF_SUPPORTED_RATES)
				{
					NdisMoveMemory(&Rates[*pRatesLen], eid_ptr->Octet, eid_ptr->Len);
					*pRatesLen = (*pRatesLen) + eid_ptr->Len;
				}
				else
				{
					NdisMoveMemory(&Rates[*pRatesLen], eid_ptr->Octet, MAX_LEN_OF_SUPPORTED_RATES - (*pRatesLen));
					*pRatesLen = MAX_LEN_OF_SUPPORTED_RATES;
				}
				break;
				
			case IE_WPA_RSN_IE:
				if (pAd->PortCfg.AuthMode<Ndis802_11AuthModeWPA)
					break;
				
				// If this IE did not begins with 00:0x50:0xf2:0x01,  it would be proprietary.  So we ignore
				if (!RTMPEqualMemory(eid_ptr->Octet, WPA, 4))
					break;                          
				if (eid_ptr->Len <= MAX_LEN_OF_RSNIE && eid_ptr->Len > MIN_LEN_OF_RSNIE)
				{
					*pRSNLen=eid_ptr->Len;
					if (!RTMPCheckMcast(pAd, eid_ptr))
					{
						DBGPRINT(RT_DEBUG_TRACE, " RTMPCheckMcast  FAILED !!!!  \n");
						pEntry = MacTableLookup(pAd, pAddr2);
						if (pEntry)
							DisAssocAction( pAd, pEntry, SUBTYPE_DISASSOC, REASON_MCIPHER_NOT_VALID);
						return FALSE;
					}                        
					if (!RTMPCheckUcast(pAd, eid_ptr))
					{
						DBGPRINT(RT_DEBUG_TRACE, " RTMPCheckUcast  FAILED !!!!  \n");
						pEntry = MacTableLookup(pAd, pAddr2);
						if (pEntry)
							DisAssocAction( pAd, pEntry, SUBTYPE_DISASSOC, REASON_UCIPHER_NOT_VALID);
						return FALSE;
					}                        
					if (!RTMPCheckAUTH(pAd, eid_ptr))
					{
						DBGPRINT(RT_DEBUG_TRACE, " RTMPCheckAUTH Method   FAILED !!!!  \n");
						pEntry = MacTableLookup(pAd, pAddr2);
						if (pEntry)
							DisAssocAction( pAd, pEntry, SUBTYPE_DISASSOC, REASON_INVALID_IE);
						return FALSE;
					}
					NdisMoveMemory(RSN, eid_ptr->Octet, eid_ptr->Len);
					DBGPRINT(RT_DEBUG_INFO, "Receive IE_WPA_RSN_IE : %x %x %x %x %x %x %x %x \n",\
						eid_ptr->Octet[0],eid_ptr->Octet[1],eid_ptr->Octet[2],eid_ptr->Octet[3],eid_ptr->Octet[4],\
						eid_ptr->Octet[5],eid_ptr->Octet[6],eid_ptr->Octet[7]);
				}
				else
				{
					*pRSNLen=0;
					DBGPRINT(RT_DEBUG_TRACE, "PeerAssocReqSanity - missing IE_WPA_RSN_IE)\n");
					return FALSE;
					break;
				}               
				break;
			
			default:
				break;
		}//end of switch
		eid_ptr = (PEID_STRUCT)((UCHAR*)eid_ptr + 2 + eid_ptr->Len);        
	}//end of while

	if (Sanity != 0x03)    
	{
		DBGPRINT(RT_DEBUG_WARN, "PeerAssocReqSanity - missing mandatory field)\n");
		return FALSE;
	}
	else
	{
		return TRUE;
	}

}//end of PeerAssocReqSanity()

BOOLEAN PeerReassocReqSanity(
	IN	PRTMP_ADAPTER	pAd, 
	IN  VOID *Msg, /**/
	IN  ULONG MsgLen, 
	OUT MACADDR *pAddr2, 
	OUT USHORT *pCapabilityInfo, 
	OUT USHORT *pListenInterval, 
	OUT MACADDR *pApAddr,
	OUT UCHAR *pSsidLen,
	OUT char *Ssid,
	OUT UCHAR *pRatesLen,
	OUT UCHAR Rates[],
	OUT UCHAR *RSN,
	OUT UCHAR *pRSNLen) 
{
	CHAR         *Ptr;
	MACFRAME     *Fr = (MACFRAME *)Msg;
	PEID_STRUCT	 eid_ptr;
	UCHAR        Sanity=0;
	UCHAR       WPA[4]={0x00,0x50,0xf2,0x01};
	MAC_TABLE_ENTRY *pEntry = (MAC_TABLE_ENTRY*)NULL;
  
	DBGPRINT( DEBUG_TEMP, "PeerReassocReqSanity-->\n");

	// to prevent caller from using garbage output value
	*pSsidLen = 0;
	*pRatesLen = 0;
	*pRSNLen = 0;
	
	COPY_MAC_ADDR(pAddr2, &Fr->Hdr.Addr2);
	Ptr = Fr->Octet;

	NdisMoveMemory(pCapabilityInfo, &Fr->Octet[0], 2);
	*pCapabilityInfo = RTMP_LE16_TO_CPU(*pCapabilityInfo); //tt_lin_big
	NdisMoveMemory(pListenInterval, &Fr->Octet[2], 2);
	*pListenInterval = RTMP_LE16_TO_CPU(*pListenInterval);//tt_lin_big
	NdisMoveMemory(pApAddr, &Fr->Octet[4], 6);

	eid_ptr = (PEID_STRUCT) &Fr->Octet[10];

	// get variable fields from payload and advance the pointer
	while (((UCHAR*)eid_ptr + eid_ptr->Len + 1) < ((UCHAR*)Fr + MsgLen))
	{
		switch(eid_ptr->Eid)
		{
			case IE_SSID:
				if(eid_ptr->Len <= MAX_LEN_OF_SSID)
				{
					Sanity |= 0x01;
					NdisMoveMemory(Ssid, eid_ptr->Octet, eid_ptr->Len);
					*pSsidLen = eid_ptr->Len;
				}
				else
				{
					DBGPRINT(RT_DEBUG_TRACE, "PeerAssocReqSanity - wrong IE_SSID (len=%d)\n", eid_ptr->Len);
					return FALSE;
				}
				break;
				
			case IE_SUPP_RATES:
				if (eid_ptr->Len <= MAX_LEN_OF_SUPPORTED_RATES)
				{
					Sanity |= 0x02;
					NdisMoveMemory(Rates, eid_ptr->Octet, eid_ptr->Len);//i঳D
					*pRatesLen = eid_ptr->Len;
				}
				else
				{
					DBGPRINT(RT_DEBUG_TRACE, "PeerAssocReqSanity - wrong IE_SUPP_RATES (len=%d)\n", eid_ptr->Len);
					return FALSE;
				}
				break;
				
			case IE_EXT_SUPP_RATES:
				if (eid_ptr->Len + *pRatesLen <= MAX_LEN_OF_SUPPORTED_RATES)
				{
					NdisMoveMemory(&Rates[*pRatesLen], eid_ptr->Octet, eid_ptr->Len);
					*pRatesLen = (*pRatesLen) + eid_ptr->Len;
				}
				else
				{
					NdisMoveMemory(&Rates[*pRatesLen], eid_ptr->Octet, MAX_LEN_OF_SUPPORTED_RATES - (*pRatesLen));
					*pRatesLen = MAX_LEN_OF_SUPPORTED_RATES;
				}
				break;
				
		case IE_WPA_RSN_IE:
			
				if (pAd->PortCfg.AuthMode < Ndis802_11AuthModeWPA)
					break;
				
				// If this IE did not begins with 00:0x50:0xf2:0x01,  it would be proprietary.  So we ignore
				if (!RTMPEqualMemory(eid_ptr->Octet, WPA, 4))
					break;                          
				if (eid_ptr->Len <= MAX_LEN_OF_RSNIE  && eid_ptr->Len >MIN_LEN_OF_RSNIE)
				{
					*pRSNLen=eid_ptr->Len;
					if (!RTMPCheckMcast(pAd, eid_ptr))
					{
						DBGPRINT(RT_DEBUG_TRACE, " RTMPCheckMcast  FAILED !!!!  \n");
						pEntry = MacTableLookup(pAd, pAddr2);
						if (pEntry)
							DisAssocAction( pAd, pEntry, SUBTYPE_DISASSOC, REASON_MCIPHER_NOT_VALID);
						return FALSE;
					}                        
					if (!RTMPCheckUcast(pAd, eid_ptr))
					{
						DBGPRINT(RT_DEBUG_TRACE, " RTMPCheckUcast  FAILED !!!!  \n");
						pEntry = MacTableLookup(pAd, pAddr2);
						if (pEntry)
							DisAssocAction( pAd, pEntry, SUBTYPE_DISASSOC, REASON_UCIPHER_NOT_VALID);
						return FALSE;
					}          
					if (!RTMPCheckAUTH(pAd, eid_ptr))
					{
						DBGPRINT(RT_DEBUG_TRACE, " RTMPCheckAUTH Method   FAILED !!!!  \n");
						pEntry = MacTableLookup(pAd, pAddr2);
						if (pEntry)
							DisAssocAction( pAd, pEntry, SUBTYPE_DISASSOC, REASON_INVALID_IE);
						return FALSE;
					}

					NdisMoveMemory(RSN, eid_ptr->Octet, eid_ptr->Len);
					DBGPRINT(RT_DEBUG_TRACE, "Receive IE_WPA_RSN_IE : %x %x %x %x %x %x %x %x \n",\
						eid_ptr->Octet[0],eid_ptr->Octet[1],eid_ptr->Octet[2],eid_ptr->Octet[3],eid_ptr->Octet[4],\
						eid_ptr->Octet[5],eid_ptr->Octet[6],eid_ptr->Octet[7]);
				}
				else
				{
					*pRSNLen=0;
					DBGPRINT(RT_DEBUG_TRACE, "PeerAssocReqSanity - missing IE_WPA_RSN_IE)\n");
					return FALSE;
					break;
			   }                
			   break;
				
			default:
				break;
		}
		eid_ptr = (PEID_STRUCT)((UCHAR*)eid_ptr + 2 + eid_ptr->Len);        
	}

	if (Sanity != 0x03)    
	{
		DBGPRINT(RT_DEBUG_WARN, "PeerAssocReqSanity - missing mandatory field)\n");
		return FALSE;
	}
	else
	{
		return TRUE;
	}
	
}

/* 
	==========================================================================
	Description:
		MLME message sanity check
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
 */
BOOLEAN PeerDisassocReqSanity(
	IN PRTMP_ADAPTER pAd, 
	IN VOID *Msg, 
	IN ULONG MsgLen, 
	OUT MACADDR *Addr2, 
	OUT USHORT *Reason) 
{
	MACFRAME *Fr = (MACFRAME *)Msg;

	DBGPRINT(DEBUG_TEMP, "PeerDisassocReqSanity-->\n");
	COPY_MAC_ADDR(Addr2, &Fr->Hdr.Addr2);
	NdisMoveMemory(Reason, &Fr->Octet[0], 2);
	
	*Reason = RTMP_LE16_TO_CPU(*Reason); //tt_lin_big  (i঳D)
   
	return TRUE;
}

/* 
	==========================================================================
	Description:
		MLME message sanity check
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
 */
BOOLEAN PeerDeauthReqSanity(
	IN PRTMP_ADAPTER pAd, 
	IN VOID *Msg, 
	IN ULONG MsgLen, 
	OUT MACADDR *Addr2, 
	OUT USHORT *Reason) 
{
	MACFRAME *Fr = (MACFRAME *)Msg;

	DBGPRINT( DEBUG_TEMP, "PeerDeauthReqSanity-->\n");

	COPY_MAC_ADDR(Addr2, &Fr->Hdr.Addr2);
	NdisMoveMemory(Reason, &Fr->Octet[0], 2);
	
	*Reason = RTMP_LE16_TO_CPU(*Reason); //tt_lin_big
	
	return TRUE;
}

/* 
	==========================================================================
	Description:
		MLME message sanity check
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
 */
BOOLEAN PeerAuthSanity(
	IN PRTMP_ADAPTER pAd, 
	IN VOID *Msg, 
	IN ULONG MsgLen, 
	OUT MACADDR *Addr, 
	OUT USHORT *Alg, 
	OUT USHORT *Seq, 
	OUT USHORT *Status, 
	CHAR *ChlgText) 
{
	MACFRAME     *Fr = (MACFRAME *)Msg;

	COPY_MAC_ADDR(Addr,    &Fr->Hdr.Addr2);
	
	NdisMoveMemory(Alg,    &Fr->Octet[0], 2);
	*Alg = RTMP_LE16_TO_CPU(*Alg); //tt_lin_big
	
	NdisMoveMemory(Seq,    &Fr->Octet[2], 2);
	*Seq = RTMP_LE16_TO_CPU(*Seq); //tt_lin_big
	
	NdisMoveMemory(Status, &Fr->Octet[4], 2);
	*Status =RTMP_LE16_TO_CPU(*Status); //tt_lin_big

	if (*Alg == AUTH_MODE_OPEN) 
	{
		if (*Seq == 1 || *Seq == 2) 
		{
			return TRUE;
		} 
		else 
		{
			DBGPRINT(RT_DEBUG_TRACE, "PeerAuthSanity fail - wrong Seg# (=%d)\n", *Seq);
			return FALSE;
		}
	} 
	else if (*Alg == AUTH_MODE_KEY) 
	{
		if (*Seq == 1 || *Seq == 4) 
		{
			return TRUE;
		} 
		else if (*Seq == 2 || *Seq == 3) 
		{
			NdisMoveMemory(ChlgText, &Fr->Octet[8], CIPHER_TEXT_LEN);
			return TRUE;
		} 
		else 
		{
			DBGPRINT(RT_DEBUG_TRACE, "PeerAuthSanity fail - wrong Seg# (=%d)\n", *Seq);
			return FALSE;
		}
	} 
	else 
	{
		DBGPRINT(RT_DEBUG_TRACE, "PeerAuthSanity fail - wrong algorithm (=%d)\n", *Alg);
		return FALSE;
	}
}

/* 
	==========================================================================
	Description:
		MLME message sanity check
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
 */
BOOLEAN PeerProbeReqSanity(
	IN PRTMP_ADAPTER pAd, 
	IN VOID *Msg, 
	IN ULONG MsgLen, 
	OUT MACADDR *Addr2,
	OUT CHAR Ssid[], 
	OUT UCHAR *SsidLen) 
{
	MACFRAME *Fr = (MACFRAME *)Msg;

	// to prevent caller from using garbage output value
	*SsidLen = 0;

	COPY_MAC_ADDR(Addr2, &Fr->Hdr.Addr2);

	if (Fr->Octet[0] != IE_SSID || Fr->Octet[1] > MAX_LEN_OF_SSID) 
	{
		DBGPRINT(RT_DEBUG_TRACE, "PeerProbeReqSanity fail - wrong SSID IE\n");
		return FALSE;
	} 
	
	*SsidLen = Fr->Octet[1];
	NdisMoveMemory(Ssid, &Fr->Octet[2], *SsidLen);

	return TRUE;
}


/* 
	==========================================================================
	Description:
		MLME message sanity check
	Return:
		TRUE if all parameters are OK, FALSE otherwise
	==========================================================================
 */
BOOLEAN PeerBeaconAndProbeRspSanity(
	IN PRTMP_ADAPTER pAd, 
	IN VOID *Msg, 
	IN ULONG MsgLen, 
	OUT MACADDR *Addr2, 
	OUT MACADDR *Bssid, 
	OUT CHAR Ssid[], 
	OUT UCHAR *SsidLen, 
	OUT UCHAR *BssType, 
	OUT USHORT *BeaconPeriod, 
	OUT UCHAR *Channel, 
	OUT LARGE_INTEGER *Timestamp, 
	OUT USHORT *CapabilityInfo, 
	OUT UCHAR Rate[], 
	OUT UCHAR *RateLen,
	OUT BOOLEAN *ExtendedRateIeExist,
	OUT UCHAR *Erp)
{
	CHAR                *Ptr;
	MACFRAME            *pFr;
	MACFRAME			Fr; //tt_lin_big
	PEID_STRUCT         eid_ptr;
	UCHAR               SubType;
	UCHAR               Sanity;

	// to prevent caller from using garbage output value
	*RateLen = 0;
	*ExtendedRateIeExist = FALSE;
	*Erp = 0;
	
	// Add for 3 necessary EID field check
	Sanity = 0;
	
	pFr = (MACFRAME *)Msg;
	*(PUSHORT)&Fr = RTMP_LE16_TO_CPU( *(PUSHORT)pFr ); 
	
	// get subtype from header
	SubType = (UCHAR)Fr.Hdr.SubType; //s0

	// get Addr2 and BSSID from header
	COPY_MAC_ADDR(Addr2, &pFr->Hdr.Addr2);
	COPY_MAC_ADDR(Bssid, &pFr->Hdr.Addr3);
	
	Ptr = pFr->Octet;
	
	// get timestamp from payload and advance the pointer
	NdisMoveMemory(Timestamp, Ptr, TIMESTAMP_LEN); //
	//*Timestamp = RTMP_LE32_TO_CPU(*Timestamp); //(64-bits:big int)tt_lin_big
	Ptr += TIMESTAMP_LEN;

	// get beacon interval from payload and advance the pointer
	NdisMoveMemory(BeaconPeriod, Ptr, 2);
	*BeaconPeriod = RTMP_LE16_TO_CPU(*BeaconPeriod); //tt_lin_big
	Ptr += 2;

	// get capability info from payload and advance the pointer
	NdisMoveMemory(CapabilityInfo, Ptr, 2);
	*CapabilityInfo = RTMP_LE16_TO_CPU( *CapabilityInfo); //tt_lin_big
	Ptr += 2;
	
	if (CAP_IS_ESS_ON(*CapabilityInfo)) 
	{
		*BssType = BSS_INFRA;
	} 
	else 
	{
		*BssType = BSS_INDEP;
	}

	eid_ptr = (PEID_STRUCT) Ptr;

	// get variable fields from payload and advance the pointer
	while(((UCHAR*)eid_ptr + eid_ptr->Len + 1) < ((UCHAR*)pFr + MsgLen))
	{
		switch(eid_ptr->Eid)
		{
			case IE_SSID:
				if(eid_ptr->Len <= MAX_LEN_OF_SSID)
				{
					NdisMoveMemory(Ssid, eid_ptr->Octet, eid_ptr->Len);
					*SsidLen = eid_ptr->Len;
					Sanity |= 0x1;
				}
				else
				{
					DBGPRINT(RT_DEBUG_TRACE, "PeerBeaconAndProbeRspSanity - wrong IE_SSID (len=%d)\n",eid_ptr->Len);
					return FALSE;
				}
				break;

			case IE_SUPP_RATES:
				if(eid_ptr->Len <= MAX_LEN_OF_SUPPORTED_RATES)
				{
					NdisMoveMemory(Rate, eid_ptr->Octet, eid_ptr->Len);
					*RateLen = eid_ptr->Len;
					Sanity |= 0x2;
				}
				else
				{
					DBGPRINT(RT_DEBUG_TRACE, "PeerBeaconAndProbeRspSanity - wrong IE_SUPP_RATES (len=%d)\n",eid_ptr->Len);
					return FALSE;
				}
				break;

			case IE_DS_PARM:
				if(eid_ptr->Len == 1)
				{
					*Channel = *eid_ptr->Octet;                    
					Sanity |= 0x4;
				}
				else
				{
					DBGPRINT(RT_DEBUG_TRACE, "PeerBeaconAndProbeRspSanity - wrong IE_DS_PARM (len=%d)\n",eid_ptr->Len);
					return FALSE;
				}
				break;

			case IE_FH_PARM:
			case IE_CF_PARM:
			case IE_IBSS_PARM:
			case IE_TIM:
			case IE_WPA_RSN_IE: 
				break;

			case IE_EXT_SUPP_RATES:
				// concatenate all extended rates to Rates[] and RateLen
				*ExtendedRateIeExist = TRUE;
				if (eid_ptr->Len + *RateLen <= MAX_LEN_OF_SUPPORTED_RATES)
				{
					NdisMoveMemory(&Rate[*RateLen], eid_ptr->Octet, eid_ptr->Len);//i঳D
					*RateLen = (*RateLen) + eid_ptr->Len;
				}
				else
				{
					NdisMoveMemory(&Rate[*RateLen], eid_ptr->Octet, MAX_LEN_OF_SUPPORTED_RATES - (*RateLen));
					*RateLen = MAX_LEN_OF_SUPPORTED_RATES;
				}
				break;

			case IE_ERP:
				if (eid_ptr->Len == 1)
				{
					*Erp = (UCHAR)eid_ptr->Octet[0];
				}
				break;
				
			default:
				DBGPRINT(RT_DEBUG_INFO, "PeerBeaconAndProbeRspSanity - unrecognized EID = %d\n", eid_ptr->Eid);
				break;
		}
		
		eid_ptr = (PEID_STRUCT)((UCHAR*)eid_ptr + 2 + eid_ptr->Len);        
	}

	if (Sanity != 0x7)
	{
		DBGPRINT(RT_DEBUG_WARN, "PeerBeaconAndProbeRspSanity - missing mandatory field)\n");
		return FALSE;
	}
	else
	{
		return TRUE;
	}
}

