/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology	5th	Rd.
 * Science-based Industrial	Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002, Ralink Technology, Inc.
 *
 * All rights reserved.	Ralink's source	code is	an unpublished work	and	the
 * use of a	copyright notice does not imply	otherwise. This	source code
 * contains	confidential trade secret material of Ralink Tech. Any attemp
 * or participation	in deciphering,	decoding, reverse engineering or in	any
 * way altering	the	source code	is stricitly prohibited, unless	the	prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

	Module Name:
	rt2560.h

	Abstract:
	RT2560 ASIC	related	definition & structures

	Revision History:
	Who			When		  What
	--------	----------	  ----------------------------------------------

*/

#ifndef	__RT2560_H__
#define	__RT2560_H__


//
// Control/Status Registers	(CSR)
//
#define	CSR0		0x0000		// ASIC	revision number
#define	CSR1		0x0004		// System control register
#define	CSR2		0x0008		// System admin	status register	(invalid)
#define	CSR3		0x000C		// STA MAC address register	0
#define	CSR4		0x0010		// STA MAC address register	1
#define	CSR5		0x0014		// BSSID register 0
#define	CSR6		0x0018		// BSSID register 1
#define	CSR7		0x001C		// Interrupt source	register
#define	CSR8		0x0020		// Interrupt mask register
#define	CSR9		0x0024		// Maximum frame length	register
//#define	CSR10		0x0028		// WEP control register	(invalid)
#define	CSR11		0x002C		// Back-off	control	register
#define	CSR12		0x0030		// Synchronization configuration register 0
#define	CSR13		0x0034		// Synchronization configuration register 1
#define	CSR14		0x0038		// Synchronization control register
#define	CSR15		0x003C		// Synchronization status register
#define	CSR16		0x0040		// TSF timer register 0
#define	CSR17		0x0044		// TSF timer register 1
#define	CSR18		0x0048		// IFS timer register 0
#define	CSR19		0x004C		// IFS timer register 1
#define	CSR20		0x0050		// WakeUp register
#define	CSR21		0x0054		// EEPROM control register
#define	CSR22		0x0058		// CFP Control Register

// Security	coprocessor	registers
#define	SECCSR0		0x0028		// WEP control register
#define	SECCSR1		0x0158		// WEP control register
#define	SECCSR3		0x00fc

// Transmit	related	CSRs
#define	TXCSR0		0x0060		// TX cintrol register
#define	TXCSR1		0x0064		// TX configuration	register
#define	TXCSR2		0x0068		// TX descriptor configuratioon	register
#define	TXCSR3		0x006C		// TX Ring Base	address	register
#define	TXCSR4		0x0070		// Atim	Ring Base address register
#define	TXCSR5		0x0074		// Prio	Ring Base address register
#define	TXCSR6		0x0078		// Beacon base address
#define	TXCSR7		0x007C		// AutoResponder Control Register
#define	TXCSR8		0x0098		// CCK TX BBP registers
#define	TXCSR9		0x0094		// OFDM	TX BBP registers

// Receive related CSRs
#define	RXCSR0		0x0080		// RX control register
#define	RXCSR1		0x0084		// RX descriptorconfiguration register
#define	RXCSR2		0x0088		// RX Ring base	address	register
#define	RXCSR3		0x0090		// BBP ID register 0
//#define	RXCSR4		0x0094		// BBP ID register 1
//#define	ARCSR0		0x0098		// Auto	responder PLCP config register 1
#define	ARCSR1		0x009C		// Auto	responder PLCP config register 1

// PCI control CSRs
#define	PCICSR		0x008C		// PCI control register

//
// Alias to	all	ring base registers. Easier	to understand constant definition
// within codes.
//
#define	RX_RING_BASE_REG		(RXCSR2)
#define	TX_RING_BASE_REG		(TXCSR3)
#define	ATIM_RING_BASE_REG		(TXCSR4)
#define	PRIO_RING_BASE_REG		(TXCSR5)
#define	BEACON_BASE_REG			(TXCSR6)

// Statistic Register
#define	CNT0		0x00A0		// Dot11 FCS error count
#define	CNT1		0x00AC		// Dot11 PLCP error	count
#define	CNT2		0x00B0		// Dot11 long error	count
#define	CNT3		0x00B8		// Dot11 CCA false alarm count
#define	CNT4		0x00BC		// Dot11 Rx	FIFO overflow count
#define	CNT5		0x00C0		// Dot11 Tx	FIFO underrun count

// Baseband	Control	Register
#define	PWRCSR0		0x00C4
#define	PSCSR0		0x00C8
#define	PSCSR1		0x00CC
#define	PSCSR2		0x00D0
#define	PSCSR3		0x00D4
#define	PWRCSR1		0x00D8
#define	TIMECSR		0x00DC
#define	MACCSR0		0x00E0
#define	MACCSR1		0x00E4
#define	RALINKCSR	0x00E8		// Ralink Auto-reset register
#define	BCNCSR		0x00EC

// BBP/RF/IF Control Register
#define	BBPCSR		0x00F0
#define	RFCSR		0x00F4
#define	LEDCSR		0x00F8

// ASIC	pointer	information
#define	RXPTR		0x0100		// Current RX ring address
#define	TXPTR		0x0104		// Current Tx ring address
#define	PRIPTR		0x0108		// Current Priority	ring address
#define	ATIMPTR		0x010c		// Current ATIM	ring address

// some	others
#define	TXACKCSR0	0x0110		// TX ACK timeout
#define	ACKCNT0		0x0114		// TX ACK timeout count
#define	ACKCNT1		0x0118		// RX ACK timeout count

// GPIO	and	others
#define	GPIOCSR		0x0120		// GPIO	direction &	in/out
#define	FIFOCSR0	0x0128		// TX FIFO pointer
#define	FIFOCSR1	0x012C		// RX FIFO pointer
#define	BCNCSR1		0x0130		// Tx BEACON offset	time, unit:	1 usec
#define	MACCSR2		0x0134		// TX_PE to	RX_PE delay	time, unit:	1 PCI clock	cycle
#define	TESTCSR		0x0138		// TEST	mode selection register

#define	PLCP1MCSR	0x013c		// 1 Mbps ACK/CTS PLCP
#define	PLCP2MCSR	0x0140		// 2 Mbps ACK/CTS PLCP
#define	PLCP5MCSR	0x0144		// 5.5 Mbps	ACK/CTS	PLCP
#define	PLCP11MCSR	0x0148		// 11 Mbps ACK/CTS PLCP

#define	ARTCSR0		0x014c		// ACK/CTS payload consumed	time for 1/2/5.5/11	mbps
#define	ARTCSR1		0x0150		// OFDM	ACK/CTS	payload	consumed time for 6/9/12/18	mbps
#define	ARTCSR2		0x0154		// OFDM	ACK/CTS	payload	consumed time for 24/36/48/54 mbps
#define	SECCSR1		0x0158		// security	control	register
#define	BBPCSR1		0x015c		// BBP TX configuration

#define	DBANDCSR0	0x0160		// Dual	band configuration register	0
#define	DBANDCSR1	0x0164		// Dual	band configuration register	1
#define	BBPPCSR		0x0168		// BBP pin control register
#define	DBGSEL0		0x016c		// MAC special debug mode selection	register 0
#define	DBGSEL1		0x0170		// MAC special debug mode selection	register 1
#define	BISTCSR		0x0174		// BBP BIST	register

#define	MCAST0		0x0178		// multicast filter	register 0
#define	MCAST1		0x017c		// multicast filter	register 1

#define	UARTCSR0	0x0180		// UART1 TX	register
#define	UARTCSR1	0x0184		// UART1 RX	register
#define	UARTCSR3	0x0188		// UART1 frame control register
#define	UARTCSR4	0x018c		// UART1 buffer	control	register
#define	UART2CSR0	0x0190		// UART2 TX	register
#define	UART2CSR1	0x0194		// UART2 RX	register
#define	UART2CSR3	0x0198		// UART2 frame control register
#define	UART2CSR4	0x019c		// UART2 buffer	control	register

#define	TIMECSR2	0x00a8
#define	TIMECSR3	0x00b4

//
// Tx /	Rx / Prio /	Atim ring descriptor definition
//
#define	DESC_OWN_HOST		0
#define	DESC_OWN_NIC		1
#define	DESC_VALID_TRUE		1
#define	DESC_VALID_FALSE	0

//
// BBP & RF	definition
//
#define	BUSY		1
#define	IDLE		0

#define	BBP_Version					0x00
#define	BBP_Tx_Configure			2  // R2
#define	BBP_Rx_Configure			14 // R14

#define	PHY_TR_SWITCH_TIME			5  // usec

#define	RT2560_VER_B				2
#define	RT2560_VER_C				3
#define	RT2560_VER_D				4

//-------------------------------------------------------------------------
// EEPROM definition
//-------------------------------------------------------------------------
#define	EEDO		0x10
#define	EEDI		0x08
#define	EECS		0x04
#define	EESK		0x02
#define	EERL		0x01

#define	EEPROM_WRITE_OPCODE		0x05
#define	EEPROM_READ_OPCODE		0x06
#define	EEPROM_EWDS_OPCODE		0x10
#define	EEPROM_EWEN_OPCODE		0x13

#define	NUM_EEPROM_BBP_PARMS		19
#define	NUM_EEPROM_TX_PARMS			7
#define	EEPROM_BBP_BASE_OFFSET		0x20	// 0x16
#define	EEPROM_TX_PWR_OFFSET		0x46	// 0x3c
#define	EEPROM_VERSION_OFFSET		0x7e
#define	VALID_EEPROM_VERSION		1


// =================================================================================
// TX /	RX ring	descriptor format
// =================================================================================

//
// TX descriptor format, Tx	ring, Atim ring	& Priority Ring
//
typedef	struct	_TXD_STRUC {
	// Word	0
#ifdef	BIG_ENDIAN
	ULONG		CipherAlg:3;		// [29:31]
	ULONG		Rsv1:1;	//RTS:1;	// [28:28]
	ULONG		DataByteCnt:12;		// [16:27]
	ULONG		RetryMd:1;			// [15:15]
	ULONG		IFS:2;				// [13:14]	
	ULONG		CipherOwn:1;		// [12:12]	
	ULONG		Ofdm:1;			// [11:11]
	ULONG		Timestamp:1;		// [10:10]	
	ULONG		ACK:1;				// [09:09]
	ULONG		MoreFrag:1;			// [08:08] More	fragment following this	tx ring	
	ULONG		RetryCount:3;		// [05:07] Retry result
	ULONG		TxResult:3;			// [02:04] Filled by MAC ASIC
	ULONG		Valid:1;			// [01:01] Entry valid bit
	ULONG		Owner:1;			// [00:00] Descriptor owner	bit
#else
	ULONG		Owner:1;			// [00:00] Descriptor owner	bit	X
	ULONG		Valid:1;			// [01:01] Entry valid bit X
	ULONG		TxResult:3;			// [02:04] Filled by MAC ASIC
	ULONG		RetryCount:3;		// [05:07] Retry result	
	ULONG		MoreFrag:1;			// [08:08] More	fragment following this	tx ring	X
	ULONG		ACK:1;				// [09:09]X
	ULONG		Timestamp:1;		// [10:10]X	
	ULONG		Ofdm:1;			// [11:11] X
	ULONG		CipherOwn:1;		// [12:12] X
	ULONG		IFS:2;				// [13:14]X
	ULONG		RetryMd:1;			// [15:15]X
	ULONG		DataByteCnt:12;		// [16:27]X
	ULONG		Rsv1:1;	//RTS:1;	// [28:28]
	ULONG		CipherAlg:3;		// [29:31] X
#endif
	// Word	1
	ULONG		BufferAddressPa;   //init time setting (Data n memory

	// Word	2
#ifdef BIG_ENDIAN
	ULONG		Rsv2:16;		// [16:31]
	ULONG		CWmax:4;		// [12:15]
	ULONG		CWmin:4;		// [08:11]
	ULONG		Aifs:2;			// [06:07]
	ULONG		IvOffset:6;		// [00:05]
#else
	ULONG		IvOffset:6;		// [00:05]
	ULONG		Aifs:2;			// [06:07] x
	ULONG		CWmin:4;		// [08:11] X
	ULONG		CWmax:4;		// [12:15] x
	ULONG		Rsv2:16;		// [16:31] 
#endif

	// Word	3
#ifdef BIG_ENDIAN
	ULONG		PlcpLengthHigh:8;	// [24:31] BBP R3
	ULONG		PlcpLengthLow:8;	// [16:23] BBP R2
	ULONG		PlcpService:8;		// [08:15] BBP R1
	ULONG		PlcpSignal:8;		// [00:07] BBP R0
#else
	ULONG		PlcpSignal:8;		// [00:07] X
	ULONG		PlcpService:8;		// [08:15] x
	ULONG		PlcpLengthLow:8;	// [16:23] X
	ULONG		PlcpLengthHigh:8;	// [24:31] X
#endif
	// Word	4
	ULONG		Iv;

	// Word	5
	ULONG		Eiv;

	// Word	6-9
	UCHAR		Key[16];

	// Word	10 - 11	Reserved,	not	necessary to put into the structure.
#ifdef	BIG_ENDIAN
	ULONG		Rsv3:24;	// [08:31]
	ULONG		TxRate:7;	// [01:07]for software use to track	per-rate TX	result,	RATE_1,	...	X
	ULONG		RTS:1;		// [00:00]
#else
	ULONG		RTS:1;		// [00:00]
	ULONG		TxRate:7;	// [01:07]for software use to track	per-rate TX	result,	RATE_1,	...	
	ULONG		Rsv3:24;	// [08:31]	
#endif
}	TXD_STRUC, *PTXD_STRUC;

//
// Rx descriptor format, Rx	Ring
//
typedef	struct	_RXD_STRUC	{
	// Word	0
#ifdef BIG_ENDIAN
	ULONG		CipherAlg:3;		// [29:31]
	ULONG		Rsv1:1;	// Drop:1;	// [28:28] Drop	this frame after NULL cipher operation
	ULONG		DataByteCnt:12;		// [16:27]
	ULONG		IvOffset:6;			// [10:15]
	ULONG		IcvError:1;			// [09:09]
	ULONG		CipherOwner:1;		// [08:08]	
	ULONG		PhyErr:1;			// [07:07]
	ULONG		Ofdm:1;				// [06:06]
	ULONG		Crc:1;				// [05:05]
	ULONG		MyBss:1;			// [04:04]
	ULONG		Bcast:1;			// [03:03]
	ULONG		Mcast:1;			// [02:02]
	ULONG		U2M:1;				// [01:01]
	ULONG		Owner:1;			// [00:00]	
#else
	ULONG		Owner:1;			// [00:00]
	ULONG		U2M:1;				// [01:01]
	ULONG		Mcast:1;			// [02:02]
	ULONG		Bcast:1;			// [03:03]
	ULONG		MyBss:1;			// [04:04]
	ULONG		Crc:1;				// [05:05]
	ULONG		Ofdm:1;				// [06:06]
	ULONG		PhyErr:1;			// [07:07]
	ULONG		CipherOwner:1;		// [08:08]
	ULONG		IcvError:1;			// [09:09]
	ULONG		IvOffset:6;			// [10:15]
	ULONG		DataByteCnt:12;		// [16:27]
	ULONG		Rsv1:1;	// Drop:1;	// [28:28] Drop	this frame after NULL cipher operation
	ULONG		CipherAlg:3;		// [29:31]
#endif
	// Word	1
	ULONG		BufferAddressPa;

	// Word	2 -	3
	UCHAR		BBR0;
	UCHAR		BBR1;	// suppose to read back	RSSI
	UCHAR		TA[6];

	// Word	4
	ULONG		Iv;

	// Word	5
	ULONG		Eiv;
	
	// Word	6-9
	UCHAR		Key[16];
	
	// Word	10 - 11	Reserved,	not	necessary to put into the structure.
#ifdef	BIG_ENDIAN
	ULONG		Rsv2:31;	// [01:31]
	ULONG		Drop:1;		// [00:00]
#else
	ULONG		Drop:1;		// [00:00]
	ULONG		Rsv2:31;	// [01:31]
#endif

}	RXD_STRUC, *PRXD_STRUC;

// =================================================================================
// CSR Registers
// =================================================================================

//
// CSR1: System	control	register
//
typedef	union	_CSR1_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		Rsvd1:29;		// [03:29] 
		ULONG		HostReady:1;	// [02:02] Host	is ready after initialization, 1: ready
		ULONG		BbpReset:1;		// [01:01] Hardware	reset BBP
		ULONG		SoftReset:1;	// [00:00] Software	reset bit, 1: reset, 0:	normal
	#else
		ULONG		SoftReset:1;	// [00:00] Software	reset bit, 1: reset, 0:	normal
		ULONG		BbpReset:1;		// [01:01] Hardware	reset BBP
		ULONG		HostReady:1;	// [02:02] Host	is ready after initialization, 1: ready
		ULONG		Rsvd1:29;		// [03:29] 
	#endif
	}	field;
	ULONG			word;
}	CSR1_STRUC,	*PCSR1_STRUC;

//
// CSR3: STA MAC register 0
//
typedef	union	_CSR3_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		UCHAR		Byte3;		// [24:31] MAC address byte	3
		UCHAR		Byte2;		// [16:23] MAC address byte	2
		UCHAR		Byte1;		// [08:15] MAC address byte	1
		UCHAR		Byte0;		// [00:07] MAC address byte	0
	#else
		UCHAR		Byte0;		// [00:07] MAC address byte	0
		UCHAR		Byte1;		// [08:15] MAC address byte	1
		UCHAR		Byte2;		// [16:23] MAC address byte	2
		UCHAR		Byte3;		// [24:31] MAC address byte	3
	#endif
	}	field;
	ULONG			word;
}	CSR3_STRUC,	*PCSR3_STRUC;

//
// CSR4: STA MAC register 1
//
typedef	union	_CSR4_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		UCHAR		Rsvd1;		// [24:31]
		UCHAR		Rsvd0;		// [16:23]
		UCHAR		Byte5;		// [08:15] MAC address byte	5
		UCHAR		Byte4;		// [00:07] MAC address byte	4
	#else
		UCHAR		Byte4;		// [00:07] MAC address byte	4
		UCHAR		Byte5;		// [08:15] MAC address byte	5
		UCHAR		Rsvd0;		// [16:23]
		UCHAR		Rsvd1;		// [24:31]
	#endif
	}	field;
	ULONG			word;
}	CSR4_STRUC,	*PCSR4_STRUC;

//
// CSR5: BSSID register	0
//
typedef	union	_CSR5_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		UCHAR		Byte3;		// [24:31] BSSID byte 3
		UCHAR		Byte2;		// [16:23] BSSID byte 2
		UCHAR		Byte1;		// [08:15] BSSID byte 1
		UCHAR		Byte0;		// [00:07] BSSID byte 0
	#else
		UCHAR		Byte0;		// [00:07] BSSID byte 0
		UCHAR		Byte1;		// [08:15] BSSID byte 1
		UCHAR		Byte2;		// [16:23] BSSID byte 2
		UCHAR		Byte3;		// [24:31] BSSID byte 3
	#endif
	}	field;
	ULONG			word;
}	CSR5_STRUC,	*PCSR5_STRUC;

//
// CSR6: BSSID register	1
//
typedef	union	_CSR6_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		UCHAR		Rsvd1;		// [24:31]
		UCHAR		Rsvd0;		// [16:23]
		UCHAR		Byte5;		// [08:15] BSSID byte 5
		UCHAR		Byte4;		// [00:07] BSSID byte 4
	#else
		UCHAR		Byte4;		// [00:07] BSSID byte 4
		UCHAR		Byte5;		// [08:15] BSSID byte 5
		UCHAR		Rsvd0;		// [16:23]
		UCHAR		Rsvd1;		// [24:31]
	#endif
	}	field;
	ULONG			word;
}	CSR6_STRUC,	*PCSR6_STRUC;

//
// CSR7: Interrupt source register
// Write one to	clear corresponding	bit
//
typedef	union	_CSR7_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		Rsvd:12;				// [20:31]
		ULONG		Timecsr3Expired:1;		// [19:19] TIMECSR3	hardware timer expired (for	802.1H quiet period)
		ULONG		Uart2RxBufferError:1;	// [18:18] UART2 RX	buffer error
		ULONG		Uart2TxBufferError:1;	// [17:17] UART2 TX	buffer error
		ULONG		Uart2IdleThreshold:1;	// [16:16] UART2 IDLE over threshold
		ULONG		Uart2RxThreshold:1;		// [15:15] UART2 RX	reaches	threshold
		ULONG		Uart2TxThreshold:1;		// [14:14] UART2 TX	reaches	threshold
		ULONG		UartRxBufferError:1;	// [13:13] UART1 RX	buffer error
		ULONG		UartTxBufferError:1;	// [12:12] UART1 TX	buffer error
		ULONG		UartIdleThreshold:1;	// [11:11] UART1 IDLE over threshold
		ULONG		UartRxThreshold:1;		// [10:10] UART1 RX	reaches	threshold
		ULONG		UartTxThreshold:1;		// [09:09] UART1 TX	reaches	threshold
		ULONG		EncryptionDone:1;	// [08:08] Encryption done interrupt
		ULONG		DecryptionDone:1;	// [07:07] Decryption done interrupt
		ULONG		RxDone:1;			// [06:06] Receive done	interrupt
		ULONG		PrioRingTxDone:1;	// [05:05] Priority	ring transmit done interrupt
		ULONG		AtimRingTxDone:1;	// [04:04] Atim	ring transmit done interrupt
		ULONG		TxRingTxDone:1;		// [03:03] Tx ring transmit	done interrupt
		ULONG		TatimwExpire:1;		// [02:02] Timer of	atim window	expired	interrupt
		ULONG		TwakeExpire:1;		// [01:01] Wakeup timer	expired	interrupt
		ULONG		TbcnExpire:1;		// [00:00] Beacon timer	expired	interrupt
	#else
		ULONG		TbcnExpire:1;		// [00:00] Beacon timer	expired	interrupt
		ULONG		TwakeExpire:1;		// [01:01] Wakeup timer	expired	interrupt
		ULONG		TatimwExpire:1;		// [02:02] Timer of	atim window	expired	interrupt
		ULONG		TxRingTxDone:1;		// [03:03] Tx ring transmit	done interrupt
		ULONG		AtimRingTxDone:1;	// [04:04] Atim	ring transmit done interrupt
		ULONG		PrioRingTxDone:1;	// [05:05] Priority	ring transmit done interrupt
		ULONG		RxDone:1;			// [06:06] Receive done	interrupt
		ULONG		DecryptionDone:1;	// [07:07] Decryption done interrupt
		ULONG		EncryptionDone:1;	// [08:08] Encryption done interrupt
		ULONG		UartTxThreshold:1;		// [09:09] UART1 TX	reaches	threshold
		ULONG		UartRxThreshold:1;		// [10:10] UART1 RX	reaches	threshold
		ULONG		UartIdleThreshold:1;	// [11:11] UART1 IDLE over threshold
		ULONG		UartTxBufferError:1;	// [12:12] UART1 TX	buffer error
		ULONG		UartRxBufferError:1;	// [13:13] UART1 RX	buffer error
		ULONG		Uart2TxThreshold:1;		// [14:14] UART2 TX	reaches	threshold
		ULONG		Uart2RxThreshold:1;		// [15:15] UART2 RX	reaches	threshold
		ULONG		Uart2IdleThreshold:1;	// [16:16] UART2 IDLE over threshold
		ULONG		Uart2TxBufferError:1;	// [17:17] UART2 TX	buffer error
		ULONG		Uart2RxBufferError:1;	// [18:18] UART2 RX	buffer error
		ULONG		Timecsr3Expired:1;		// [19:19] TIMECSR3	hardware timer expired (for	802.1H quiet period)
		ULONG		Rsvd:12;				// [20:31]
	#endif
	}	field;
	ULONG			word;
}	CSR7_STRUC,	*PCSR7_STRUC, INTSRC_STRUC,	*PINTSRC_STRUC;

//
// CSR8: Interrupt Mask	register
// Write one to	mask off interrupt
//
typedef	union	_CSR8_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		Rsvd:12;				// [20:31]
		ULONG		Timecsr3Expired:1;		// [19:19] TIMECSR3	hardware timer expired (for	802.1H quiet period)
		ULONG		Uart2RxBufferError:1;	// [18:18] UART2 RX	buffer error
		ULONG		Uart2TxBufferError:1;	// [17:17] UART2 TX	buffer error	
		ULONG		Uart2IdleThreshold:1;	// [16:16] UART2 IDLE over threshold	
		ULONG		Uart2RxThreshold:1;		// [15:15] UART2 RX	reaches	threshold
		ULONG		Uart2TxThreshold:1;		// [14:14] UART2 TX	reaches	threshold
		ULONG		UartRxBufferError:1;	// [13:13] UART1 RX	buffer error
		ULONG		UartTxBufferError:1;	// [12:12] UART1 TX	buffer error
		ULONG		UartIdleThreshold:1;	// [11:11] UART1 IDLE over threshold
		ULONG		UartRxThreshold:1;		// [10:10] UART1 RX	reaches	threshold
		ULONG		UartTxThreshold:1;		// [09:09] UART1 TX	reaches	threshold
		ULONG		EncryptionDone:1;	// [08:08] Encryption done interrupt
		ULONG		DecryptionDone:1;	// [07:07] Decryption done interrupt
		ULONG		RxDone:1;			// [06:06] Receive done	interrupt mask
		ULONG		PrioRingTxDone:1;	// [05:05] Priority	ring transmit done interrupt mask
		ULONG		AtimRingTxDone:1;	// [04:04] Atim	ring transmit done interrupt mask
		ULONG		TxRingTxDone:1;		// [03:03] Tx ring transmit	done interrupt mask
		ULONG		TatimwExpire:1;		// [02:02] Timer of	atim window	expired	interrupt mask
		ULONG		TwakeExpire:1;		// [01:01] Wakeup timer	expired	interrupt mask
		ULONG		TbcnExpire:1;		// [00:00] Beacon timer	expired	interrupt mask
	#else
		ULONG		TbcnExpire:1;		// [00:00] Beacon timer	expired	interrupt mask
		ULONG		TwakeExpire:1;		// [01:01] Wakeup timer	expired	interrupt mask
		ULONG		TatimwExpire:1;		// [02:02] Timer of	atim window	expired	interrupt mask
		ULONG		TxRingTxDone:1;		// [03:03] Tx ring transmit	done interrupt mask
		ULONG		AtimRingTxDone:1;	// [04:04] Atim	ring transmit done interrupt mask
		ULONG		PrioRingTxDone:1;	// [05:05] Priority	ring transmit done interrupt mask
		ULONG		RxDone:1;			// [06:06] Receive done	interrupt mask
		ULONG		DecryptionDone:1;	// [07:07] Decryption done interrupt
		ULONG		EncryptionDone:1;	// [08:08] Encryption done interrupt
		ULONG		UartTxThreshold:1;		// [09:09] UART1 TX	reaches	threshold
		ULONG		UartRxThreshold:1;		// [10:10] UART1 RX	reaches	threshold
		ULONG		UartIdleThreshold:1;	// [11:11] UART1 IDLE over threshold
		ULONG		UartTxBufferError:1;	// [12:12] UART1 TX	buffer error
		ULONG		UartRxBufferError:1;	// [13:13] UART1 RX	buffer error
		ULONG		Uart2TxThreshold:1;		// [14:14] UART2 TX	reaches	threshold
		ULONG		Uart2RxThreshold:1;		// [15:15] UART2 RX	reaches	threshold
		ULONG		Uart2IdleThreshold:1;	// [16:16] UART2 IDLE over threshold
		ULONG		Uart2TxBufferError:1;	// [17:17] UART2 TX	buffer error
		ULONG		Uart2RxBufferError:1;	// [18:18] UART2 RX	buffer error
		ULONG		Timecsr3Expired:1;		// [19:19] TIMECSR3	hardware timer expired (for	802.1H quiet period)
		ULONG		Rsvd:12;				// [20:31]
	#endif
	}	field;
	ULONG			word;
}	CSR8_STRUC,	*PCSR8_STRUC, INTMSK_STRUC,	*PINTMSK_STRUC;

//
// CSR9: Maximum frame length register
//
typedef	union	_CSR9_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		Rsvd1:20;			// [12:31]	
		ULONG		MaxFrameUnit:5;		// [07:11] Maximum frame legth in 128B unit, default is	12 = 0xC.
		ULONG		Rsvd0:7;			// [00:06]
	#else
		ULONG		Rsvd0:7;			// [00:06]
		ULONG		MaxFrameUnit:5;		// [07:11] Maximum frame legth in 128B unit, default is	12 = 0xC.
		ULONG		Rsvd1:20;			// [12:31]	
	#endif
	}	field;
	ULONG			word;
}	CSR9_STRUC,	*PCSR9_STRUC;

//
// SECCSR0:	WEP	control	register
//
typedef	union	_SECCSR0_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		DescAddress:30;		// [02:31] Descriptor physical address of frame	in one-shot-mode.
		ULONG		OneShotMode:1;		// [01:01] 1: One shot only	mode, 0: ring mode
		ULONG		KickDecypt:1;		// [00:00] Kick	decryption engine, self-clear
	#else
		ULONG		KickDecypt:1;		// [00:00] Kick	decryption engine, self-clear
		ULONG		OneShotMode:1;		// [01:01] 1: One shot only	mode, 0: ring mode
		ULONG		DescAddress:30;		// [02:31] Descriptor physical address of frame	in one-shot-mode.
	#endif
	}	field;
	ULONG			word;
}	SECCSR0_STRUC, *PSECCSR0_STRUC;

//
// SECCSR1:	WEP	control	register
//
typedef	union	_SECCSR1_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		DescAddress:30;		// [02:31]Descriptor physical address of frame in one-shot-mode.
		ULONG		OneShotMode:1;		// [01:01] 1: One shot only	mode, 0: ring mode	
		ULONG		KickEncypt:1;		// [00:00] Kick	encryption engine, self-clear
	#else
		ULONG		KickEncypt:1;		// [00:00] Kick	encryption engine, self-clear
		ULONG		OneShotMode:1;		// [01:01] 1: One shot only	mode, 0: ring mode
		ULONG		DescAddress:30;		// [02:31]Descriptor physical address of frame in one-shot-mode.
	#endif
	}	field;
	ULONG			word;
}	SECCSR1_STRUC, *PSECCSR1_STRUC;

//
// CSR11: Back-Off control register
//
typedef	union	_CSR11_STRUC	{
	struct {
	#ifdef BIG_ENDIAN
		ULONG		ShortRetry:8;	// [24:31] Short retry count
		ULONG		LongRetry:8;	// [16:23] Long	retry count
		ULONG		Rsvd:2;			// [14:15]
		ULONG	 CWSelect:1;	 //	[13:13]	1: CWmin/CWmax select from register, 0:	select from	TxD
		ULONG		SlotTime:5;		// [08:12] Slot	time, default is 20us for 802.11B
		ULONG		CWMax:4;		// [04:07] Bit for Cwmax, default Cwmax	is 1023	(2^10 -	1).	
		ULONG		CWMin:4;		// [00:03] Bit for Cwmin. default Cwmin	is 31 (2^5 - 1).
	#else
		ULONG		CWMin:4;		// [00:03] Bit for Cwmin. default Cwmin	is 31 (2^5 - 1).
		ULONG		CWMax:4;		// [04:07] Bit for Cwmax, default Cwmax	is 1023	(2^10 -	1).
		ULONG		SlotTime:5;		// [08:12] Slot	time, default is 20us for 802.11B
		ULONG	 CWSelect:1;	 //	[13:13]	1: CWmin/CWmax select from register, 0:	select from	TxD
		ULONG		Rsvd:2;			// [14:15]
		ULONG		LongRetry:8;	// [16:23] Long	retry count
		ULONG		ShortRetry:8;	// [24:31] Short retry count
	#endif
	}	field;
	ULONG			word;
}	CSR11_STRUC, *PCSR11_STRUC;	

//
// CSR12: Synchronization configuration	register 0
// All uint	in 1/16	TU
//
typedef	union	_CSR12_STRUC	{
	struct	{
	#ifdef	BIG_ENDIAN
		ULONG		CfpMaxDuration:16;	// [16:31] Beacon interval,	default	is 100 TU
		ULONG		BeaconInterval:16;	// [00:15] CFP maximum duration, default is	100	TU
	#else
		ULONG		BeaconInterval:16;	// [00:15] CFP maximum duration, default is	100	TU
		ULONG		CfpMaxDuration:16;	// [16:31] Beacon interval,	default	is 100 TU
	#endif
	}	field;
	ULONG			word;
}	CSR12_STRUC, *PCSR12_STRUC;

//
// CSR13: Synchronization configuration	register 1
// All uint	in 1/16	TU
//
typedef	union	_CSR13_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		Rsvd:8;				// [24:31]
		ULONG		CfpPeriod:8;		// [16:23] CFP period, default is 0	TU
		ULONG		AtimwDuration:16;	// [00:15] ATIM	window duration, default is	10 TU
	#else
		ULONG		AtimwDuration:16;	// [00:15] ATIM	window duration, default is	10 TU
		ULONG		CfpPeriod:8;		// [16:23] CFP period, default is 0	TU
		ULONG		Rsvd:8;				// [24:31]
	#endif		
	}	field;
	ULONG			word;
}	CSR13_STRUC, *PCSR13_STRUC;

//
// CSR14: Synchronization control register
//
typedef	union	_CSR14_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		TbcnPreload:16;		// [15:31] Tbcn	preload	value
		ULONG		CfpCntPreload:8;	// [07:14] Cfp count preload value
		ULONG		Rsvd:1;				// [06:06]
		ULONG		BeaconGen:1;		// [05:05] Enable beacon generator
		ULONG		Tatimw:1;			// [04:04] Enable Tatimw & ATIM	window switching
		ULONG		Tcfp:1;				// [03:03] Enable Tcfp & CFP / CP switching
		ULONG		Tbcn:1;				// [02:02] Enable Tbcn with	reload value
		ULONG		TsfSync:2;			// [01:01] Enable TSF sync,	00:	disable, 01: infra mode, 10: ad-hoc	mode
		ULONG		TsfCount:1;			// [00:00] Enable TSF auto counting
	#else
		ULONG		TsfCount:1;			// [00:00] Enable TSF auto counting
		ULONG		TsfSync:2;			// [01:01] Enable TSF sync,	00:	disable, 01: infra mode, 10: ad-hoc	mode
		ULONG		Tbcn:1;				// [02:02] Enable Tbcn with	reload value
		ULONG		Tcfp:1;				// [03:03] Enable Tcfp & CFP / CP switching
		ULONG		Tatimw:1;			// [04:04] Enable Tatimw & ATIM	window switching
		ULONG		BeaconGen:1;		// [05:05] Enable beacon generator
		ULONG		Rsvd:1;				// [06:06]
		ULONG		CfpCntPreload:8;	// [07:14] Cfp count preload value
		ULONG		TbcnPreload:16;		// [15:31] Tbcn	preload	value
	#endif
	}	field;
	ULONG			word;
}	CSR14_STRUC, *PCSR14_STRUC;

//
// CSR15: Synchronization status register
//
typedef	union	_CSR15_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		Rsvd:29;		// [03:31]	
		ULONG		BeaconSent:1;	// [02:02] Beacon sent
		ULONG		Atimw:1;		// [01:01] Atim	window period
		ULONG		Cfp:1;			// [00:00] CFP period
	#else
		ULONG		Cfp:1;			// [00:00] CFP period
		ULONG		Atimw:1;		// [01:01] Atim	window period
		ULONG		BeaconSent:1;	// [02:02] Beacon sent
		ULONG		Rsvd:29;		// [03:31]	
	#endif
	}	field;
	ULONG			word;
}	CSR15_STRUC, *PCSR15_STRUC;

//
// CSR18: IFS Timer	register 0
//
typedef	union	_CSR18_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		Rsvd1:7;	// [25:31]
		ULONG		PIFS:9;		// [16:24] PIFS, default is	30 TU
		ULONG		Rsvd0:7;	// [09:15]
		ULONG		SIFS:9;		// [00:08] SIFS, default is	10 TU
	#else
		ULONG		SIFS:9;		// [00:08] SIFS, default is	10 TU
		ULONG		Rsvd0:7;	// [09:15]
		ULONG		PIFS:9;		// [16:24] PIFS, default is	30 TU
		ULONG		Rsvd1:7;	// [25:31]
	#endif
	}	field;
	ULONG			word;
}	CSR18_STRUC, *PCSR18_STRUC;

//
// CSR19: IFS Timer	register 1
//
typedef	union	_CSR19_STRUC	{
	struct	{ //tt_lin
	#ifdef BIG_ENDIAN
		ULONG		EIFS:16;	// [16:31] EIFS, default is	364	TU
		ULONG		DIFS:16;	// [00:15] DIFS, default is	50 TU
	#else
		ULONG		DIFS:16;	// [00:15] DIFS, default is	50 TU
		ULONG		EIFS:16;	// [16:31] EIFS, default is	364	TU
	#endif
	}	field;
	ULONG			word;
}	CSR19_STRUC, *PCSR19_STRUC;

//
// CSR20: Wakeup timer register
//
typedef	union	_CSR20_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		Rsvd:7;					// [25:31]
		ULONG		AutoWake:1;				// [24:24] Enable auto wakeup /	sleep mechanism
		ULONG		NumBcnBeforeWakeup:8;	// [16:23] Number of beacon	before wakeup
		ULONG		DelayAfterBcn:16;		// [00:15] Delay after Tbcn	expired	in units of	1/16 TU
	#else	
		ULONG		DelayAfterBcn:16;		// [00:15] Delay after Tbcn	expired	in units of	1/16 TU
		ULONG		NumBcnBeforeWakeup:8;	// [16:23] Number of beacon	before wakeup
		ULONG		AutoWake:1;				// [24:24] Enable auto wakeup /	sleep mechanism
		ULONG		Rsvd:7;					// [25:31]
	#endif
	}	field;
	ULONG			word;
}	CSR20_STRUC, *PCSR20_STRUC;

//
// CSR21: EEPROM control register
//
typedef	union	_CSR21_STRUC	{
	struct	{
	#ifndef	BIG_ENDIAN
		ULONG		Rsvd:26;		// [06:31]
		ULONG		Type:1;			// [05:05] 1: 93C46, 0:93C66
		ULONG		EepromDO:1;		// [04:04] 
		ULONG		EepromDI:1;		// [03:03] 
		ULONG		EepromCS:1;		// [02:02] 
		ULONG		EepromSK:1;		// [01:01] 
		ULONG		Reload:1;		// [00:00] Reload EEPROM content, write	one	to reload, self-cleared.
	#else
		ULONG		Reload:1;		// [00:00] Reload EEPROM content, write	one	to reload, self-cleared.
		ULONG		EepromSK:1;		// [01:01] 
		ULONG		EepromCS:1;		// [02:02] 
		ULONG		EepromDI:1;		// [03:03] 
		ULONG		EepromDO:1;		// [04:04] 
		ULONG		Type:1;			// [05:05] 1: 93C46, 0:93C66
		ULONG		Rsvd:26;		// [06:31]
	#endif
	}	field;
	ULONG			word;
}	CSR21_STRUC, *PCSR21_STRUC;

//
// CSR22: CFP control register
//
typedef	union	_CSR22_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		Rsvd:15;				// [17:31]
		ULONG		ReloadCfpDurRemain:1;	// [16:16] Reload CFP duration remain, write one to	reload,	self-cleared
		ULONG		CfpDurRemain:16;		// [00:15] CFP duration	remain,	in units of	TU
	#else
		ULONG		CfpDurRemain:16;		// [00:15] CFP duration	remain,	in units of	TU
		ULONG		ReloadCfpDurRemain:1;	// [16:16] Reload CFP duration remain, write one to	reload,	self-cleared
		ULONG		Rsvd:15;				// [17:31]
	#endif
	}	field;
	ULONG			word;
}	CSR22_STRUC, *PCSR22_STRUC;

// =================================================================================
// TX /	RX Registers
// =================================================================================

//
// TXCSR0 <0x0060> : TX	Control	Register 
//
typedef	union	_TXCSR0_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		Rsvd:28;		// [04:31]
		ULONG		Abort:1;		// [03:03] Abort all transmit related ring operation
		ULONG		KickPrio:1;		// [02:02] Kick	priority ring
		ULONG		KickAtim:1;		// [01:01] Kick	ATIM ring
		ULONG		KickTx:1;		// [00:00] Kick	Tx ring	
	#else
		ULONG		KickTx:1;		// [00:00] Kick	Tx ring	
		ULONG		KickAtim:1;		// [01:01] Kick	ATIM ring
		ULONG		KickPrio:1;		// [02:02] Kick	priority ring
		ULONG		Abort:1;		// [03:03] Abort all transmit related ring operation
		ULONG		Rsvd:28;		// [04:31]
	#endif
	}	field;	
	ULONG			word;
}	TXCSR0_STRUC, *PTXCSR0_STRUC;

//
// TXCSR1 <0x0064> : TX	Configuration Register
//
typedef	union	_TXCSR1_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		Reserved:7;			// [25:31]
		ULONG		AutoResponder:1;	// [24:24] enable auto responder which include ACK & CTS
		ULONG		TsFOffset:6;		// [18:23] Insert Tsf offset
		ULONG		AckConsumeTime:9;	// [09:17] ACK consume time, default = SIFS	+ ACKtime @	1Mbps
		ULONG		AckTimeOut:9;		// [00:08] Ack timeout,	default	= SIFS + 2*SLOT_ACKtime	@ 1Mbps
	#else
		ULONG		AckTimeOut:9;		// [00:08] Ack timeout,	default	= SIFS + 2*SLOT_ACKtime	@ 1Mbps
		ULONG		AckConsumeTime:9;	// [09:17] ACK consume time, default = SIFS	+ ACKtime @	1Mbps
		ULONG		TsFOffset:6;		// [18:23] Insert Tsf offset
		ULONG		AutoResponder:1;	// [24:24] enable auto responder which include ACK & CTS
		ULONG		Reserved:7;			// [25:31]
	#endif
	}	field;
	ULONG			word;
}	TXCSR1_STRUC, *PTXCSR1_STRUC;

//
// TXCSR2: Tx descriptor configuration register
//
typedef	union	_TXCSR2_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		NumPrioD:8;		// [24:31] Number of PriorityD in ring
		ULONG		NumAtimD:8;		// [06:23] Number of AtimD in ring
		ULONG		NumTxD:8;		// [08:15] Number of TxD in	ring
		ULONG		TxDSize:8;		// [00:07] Tx descriptor size, default is 48
	#else
		ULONG		TxDSize:8;		// [00:07] Tx descriptor size, default is 48
		ULONG		NumTxD:8;		// [08:15] Number of TxD in	ring
		ULONG		NumAtimD:8;		// [06:23] Number of AtimD in ring
		ULONG		NumPrioD:8;		// [24:31] Number of PriorityD in ring
	#endif
	}	field;
	ULONG			word;
}	TXCSR2_STRUC, *PTXCSR2_STRUC;

//
// TXCSR7: Auto	responder control register
//
typedef	union	_TXCSR7_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		Rsvd:31;			// [01:31]
		ULONG		ARPowerManage:1;	// [00:00] Auto	responder power	management bit
	#else
		ULONG		ARPowerManage:1;	// [00:00] Auto	responder power	management bit
		ULONG		Rsvd:31;			// [01:31]
	#endif	
	}	field;
	ULONG		word;
}	TXCSR7_STRUC, *PTXCSR7_STRUC;

//
// TXCSR8: CCK Tx BBP register
//
typedef	union	_TXCSR8_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		CckLenHigh:8;	// [24:31] BBP length high byte	address	for	CCK
		ULONG		CckLenLow:8;	// [16:23] BBP length low byte address for CCK
		ULONG		CckService:8;	// [08:15] BBP service field address for CCK
		ULONG		CckSignal:8;	// [00:07] BBP signal field	address	for	CCK
	#else
		ULONG		CckSignal:8;	// [00:07] BBP signal field	address	for	CCK
		ULONG		CckService:8;	// [08:15] BBP service field address for CCK
		ULONG		CckLenLow:8;	// [16:23] BBP length low byte address for CCK
		ULONG		CckLenHigh:8;	// [24:31] BBP length high byte	address	for	CCK
	#endif
	}	field;
	ULONG		word;
}	TXCSR8_STRUC, *PTXCSR8_STRUC;

//
// TXCSR9: OFDM	Tx BBP register
//
typedef	union	_TXCSR9_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		OfdmLenHigh:8;	// [24:31] BBP length high byte	address	for	OFDM
		ULONG		OfdmLenLow:8;	// [16:23] BBP length low byte address for OFDM
		ULONG		OfdmService:8;	// [08:15] BBP service field address for OFDM
		ULONG		OfdmRate:8;		// [00:07] BBP rate	field address for OFDM
	#else	
		ULONG		OfdmRate:8;		// [00:07] BBP rate	field address for OFDM
		ULONG		OfdmService:8;	// [08:15] BBP service field address for OFDM
		ULONG		OfdmLenLow:8;	// [16:23] BBP length low byte address for OFDM
		ULONG		OfdmLenHigh:8;	// [24:31] BBP length high byte	address	for	OFDM
	#endif
	}	field;
	ULONG		word;
}	TXCSR9_STRUC, *PTXCSR9_STRUC;

//
// RXCSR0 <0x0080> : RX	Control	Register
//
typedef	union	_RXCSR0_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		Reserved:20;		// [12:31]
		ULONG		EnableQos:1;   // [11:11] 1: accept	QOS	data frame format and parse	the	QOS	field
		ULONG		DropBcast:1;		// [10:10] Drop	broadcast frames
		ULONG		DropMcast:1;		// [09:09] Drop	multicast frames
		ULONG		PassPlcp:1;			// [08:08] Pass	all	receive	packet with	4 bytes	PLCP attached
		ULONG		PassCRC:1;			// [07:07] Pass	all	receive	packet to host with	CRC	attached
		ULONG		DropVersionErr:1;	// [06:06] Drop	version	error frame
		ULONG		DropToDs:1;			// [05:05] Drop	fram ToDs bit is true
		ULONG		DropNotToMe:1;		// [04:04] Drop	not	to me unicast frame
		ULONG		DropControl:1;		// [03:03] Drop	control	frame
		ULONG		DropPhysical:1;	// [02:02] Drop	physical error
		ULONG		DropCRC:1;			// [01:01] Drop	CRC	error
		ULONG		DisableRx:1;		// [00:00] Disable Rx engine
	#else
		ULONG		DisableRx:1;		// [00:00] Disable Rx engine
		ULONG		DropCRC:1;			// [01:01] Drop	CRC	error
		ULONG		DropPhysical:1;	// [02:02] Drop	physical error
		ULONG		DropControl:1;		// [03:03] Drop	control	frame
		ULONG		DropNotToMe:1;		// [04:04] Drop	not	to me unicast frame
		ULONG		DropToDs:1;			// [05:05] Drop	fram ToDs bit is true
		ULONG		DropVersionErr:1;	// [06:06] Drop	version	error frame
		ULONG		PassCRC:1;			// [07:07] Pass	all	receive	packet to host with	CRC	attached
		ULONG		PassPlcp:1;			// [08:08] Pass	all	receive	packet with	4 bytes	PLCP attached
		ULONG		DropMcast:1;		// [09:09] Drop	multicast frames
		ULONG		DropBcast:1;		// [10:10] Drop	broadcast frames
		ULONG		EnableQos:1;   // [11:11] 1: accept	QOS	data frame format and parse	the	QOS	field
		ULONG		Reserved:20;		// [12:31]
#endif
	}	field;
	ULONG			word;
}	RXCSR0_STRUC, *PRXCSR0_STRUC;

//
// RXCSR1: RX descriptor configuration register
//
typedef	union	_RXCSR1_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		Rsvd:16;		   // [16:31]
		ULONG		NumRxD:8;		// [08:15] Number of RxD in	ring.
		ULONG		RxDSize:8;		// [00:07] Rx descriptor size, default is 32B.
	#else
		ULONG		RxDSize:8;		// [00:07] Rx descriptor size, default is 32B.
		ULONG		NumRxD:8;		// [08:15] Number of RxD in	ring.
		ULONG		Rsvd:16;		   // [16:31]
	#endif
	}	field;
	ULONG			word;
}	RXCSR1_STRUC, *PRXCSR1_STRUC;

//
// RXCSR3: BBP ID register for Rx operation
//
typedef	union	_RXCSR3_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		ValidBbp3:1;		// [31:31] BBP register	3 ID is	valid or not
		ULONG		IdBbp3:7;			// [24:30] BBP register	3 ID
		ULONG		ValidBbp2:1;		// [23:23] BBP register	2 ID is	valid or not
		ULONG		IdBbp2:7;			// [16:22] BBP register	2 ID
		ULONG		ValidBbp1:1;		// [15:15] BBP register	1 ID is	valid or not
		ULONG		IdBbp1:7;			// [08:14] BBP register	1 ID
		ULONG		ValidBbp0:1;		// [07:07] BBP register	0 ID is	valid or not
		ULONG		IdBbp0:7;			// [00:06] BBP register	0 ID
	#else
		ULONG		IdBbp0:7;			// [00:06] BBP register	0 ID
		ULONG		ValidBbp0:1;		// [07:07] BBP register	0 ID is	valid or not
		ULONG		IdBbp1:7;			// [08:14] BBP register	1 ID
		ULONG		ValidBbp1:1;		// [15:15] BBP register	1 ID is	valid or not
		ULONG		IdBbp2:7;			// [16:22] BBP register	2 ID
		ULONG		ValidBbp2:1;		// [23:23] BBP register	2 ID is	valid or not
		ULONG		IdBbp3:7;			// [24:30] BBP register	3 ID
		ULONG		ValidBbp3:1;		// [31:31] BBP register	3 ID is	valid or not
	#endif		
	}	field;
	ULONG			word;
}	RXCSR3_STRUC, *PRXCSR3_STRUC;

// =================================================================================
// Miscellaneous Registers
// =================================================================================

//
// PCISR: PCI control register
//
typedef	union	_PCICSR_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		Rsvd:22;				// [10:31]
		ULONG		WriteInvalid:1;	// [09:09] Enable memory write & invalid
		ULONG		ReadMultiple:1;	// [08:08] Enable memory read multiple
		ULONG		EnableClk:1;		// [07:07] Enable CLK_RUN, PCI clock can't going down to non-operational
		ULONG		BurstLength:2;		// [05:06] PCI burst length
											//				01:	8DW, 10: 16DW, 11:32DW,	default	00:	4DW
		ULONG		TxThreshold:2;		// [03:04] Tx threshold	in DW to start PCI access
											//				01:	1DW, 10: 4DW, 11: store	& forward, default 00: 0DW
		ULONG		RxThreshold:2;		// [01:02] Rx threshold	in DW to start PCI access
											//				01:	8DW, 10: 4DW, 11: 32DW,	default	00:	16DW
		ULONG		BigEndian:1;		// [00:00] 1: big endian, 0: little	endian
	#else
		ULONG		BigEndian:1;		// [00:00] 1: big endian, 0: little	endian
		ULONG		RxThreshold:2;		// [01:02] Rx threshold	in DW to start PCI access
											//				01:	8DW, 10: 4DW, 11: 32DW,	default	00:	16DW
		ULONG		TxThreshold:2;		// [03:04] Tx threshold	in DW to start PCI access
											//				01:	1DW, 10: 4DW, 11: store	& forward, default 00: 0DW
		ULONG		BurstLength:2;		// [05:06] PCI burst length
											//				01:	8DW, 10: 16DW, 11:32DW,	default	00:	4DW
		ULONG		EnableClk:1;		// [07:07] Enable CLK_RUN, PCI clock can't going down to non-operational
		ULONG		ReadMultiple:1;	// [08:08] Enable memory read multiple
		ULONG		WriteInvalid:1;	// [09:09] Enable memory write & invalid
		ULONG		Rsvd:22;				// [10:31]		
	#endif
	}	field;
	ULONG			word;
}	PCICSR_STRUC, *PPCICSR_STRUC;

//
// PWRCSR0:	Power mode configuration register
// Driver did not control it for now.

//
// PSCSR0: Power saving	delay time register	0
// Driver did not control it for now.

//
// PSCSR1: Power saving	delay time register	1
// Driver did not control it for now.

//
// PSCSR2: Power saving	delay time register	2
// Driver did not control it for now.

//
// PSCSR3: Power saving	delay time register	3
// Driver did not control it for now.

//
// PWRCSR1:	Manual power control / status register
//
typedef	union	_PWRCSR1_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		Rsvd:22;			// [09:31]
		ULONG		PutToSleep:1;		// [08:08]
		ULONG		RfCurrState:2;		// [06:07]
		ULONG		BbpCurrState:2;		// [04:05]
		ULONG		RfDesireState:2;	// [02:03]
		ULONG		BbpDesireState:2;	// [01:02]
		ULONG		SetState:1;			// [00:00]
	#else
		ULONG		SetState:1;			// [00:00]
		ULONG		BbpDesireState:2;	// [01:02]
		ULONG		RfDesireState:2;	// [02:03]
		ULONG		BbpCurrState:2;		// [04:05]
		ULONG		RfCurrState:2;		// [06:07]
		ULONG		PutToSleep:1;		// [08:08]
		ULONG		Rsvd:22;			// [09:31]
	#endif
	}	field;
	ULONG			word;
}	PWRCSR1_STRUC, *PPWRCSR1_STRUC;

//
// TIMECSR:	Timer control register
//
typedef	union	_TIMECSR_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		Rsvd:13;		// [19:31] 
		ULONG		BeaconExpect:3;	// [16:18] Beacon expect window
		ULONG		Us64Cnt:8;		// [08:15] 64 us timer count in	units of 1 us timer
		ULONG		UsCnt:8;		// [00:07] 1 us	timer count	in units of	clock cycles
	#else
		ULONG		UsCnt:8;		// [00:07] 1 us	timer count	in units of	clock cycles
		ULONG		Us64Cnt:8;		// [08:15] 64 us timer count in	units of 1 us timer
		ULONG		BeaconExpect:3;	// [16:18] Beacon expect window
		ULONG		Rsvd:13;		// [19:31] 
	#endif
	}	field;
	ULONG			word;
}	TIMECSR_STRUC, *PTIMECSR_STRUC;

//
// MACCSR0:	MAC	configuration register 0
//

//
// MACCSR1:	MAC	configuration register 1
//
typedef	union	_MACCSR1_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		Rsvd:24;			// [08:31] 
		ULONG		IntersilIF:1;		// [07:07] Intersil	IF calibration pin
		ULONG		LoopBack:2;			// [05:06] Loopback	mode. 00: normal, 01: internal,	10:	external, 11:rsvd.
		ULONG		AutoRxBbp:1;		// [04:04] Auto	Rx logic access	BBP	control	register
		ULONG		AutoTxBbp:1;		// [03:03] Auto	Tx logic access	BBP	control	register
		ULONG		BbpRxResetMode:1;	// [02:02] Ralink BBP RX reset mode
		ULONG		OneShotRxMode:1;	// [01:01] Enable one-shot Rx mode for debugging
		ULONG		KickRx:1;			// [00:00] Kick	one-shot Rx	in one-shot	Rx mode
	#else
		ULONG		KickRx:1;			// [00:00] Kick	one-shot Rx	in one-shot	Rx mode
		ULONG		OneShotRxMode:1;	// [01:01] Enable one-shot Rx mode for debugging
		ULONG		BbpRxResetMode:1;	// [02:02] Ralink BBP RX reset mode
		ULONG		AutoTxBbp:1;		// [03:03] Auto	Tx logic access	BBP	control	register
		ULONG		AutoRxBbp:1;		// [04:04] Auto	Rx logic access	BBP	control	register
		ULONG		LoopBack:2;			// [05:06] Loopback	mode. 00: normal, 01: internal,	10:	external, 11:rsvd.
		ULONG		IntersilIF:1;		// [07:07] Intersil	IF calibration pin
		ULONG		Rsvd:24;			// [08:31] 
	#endif
	}	field;
	ULONG			word;
}	MACCSR1_STRUC, *PMACCSR1_STRUC;

//
// RALINKCSR: Ralink Rx	auto-reset BBCR
//
typedef	union	_RALINKCSR_STRUC	{
	struct	{ 
	#ifdef BIG_ENDIAN
		ULONG		ArBbpValid1:1;		// [31:31] Auto	reset BBP register 1 is	valid
		ULONG		ArBbpId1:7;			// [24:30] Auto	reset BBP register 1 Id	,  //8=>7 (tt_lin)
		ULONG		ArBbpData1:8;		// [16:23] Auto	reset BBP register 1 data
		ULONG		ArBbpValid0:1;		// [15:15] Auto	reset BBP register 0 is	valid
		ULONG		ArBbpId0:7;			// [08:14] Auto	reset BBP register 0 Id
		ULONG		ArBbpData0:8;		// [00:07] Auto	reset BBP register 0 data
	#else	
		ULONG		ArBbpData0:8;		// [00:07] Auto	reset BBP register 0 data
		ULONG		ArBbpId0:7;			// [08:14] Auto	reset BBP register 0 Id
		ULONG		ArBbpValid0:1;		// [15:15] Auto	reset BBP register 0 is	valid
		ULONG		ArBbpData1:8;		// [16:23] Auto	reset BBP register 1 data
		ULONG		ArBbpId1:7;			// [24:30] Auto	reset BBP register 1 Id	,  //8=>7 (tt_lin)
		ULONG		ArBbpValid1:1;		// [31:31] Auto	reset BBP register 1 is	valid
	#endif
	}	field;
	ULONG			word;
}	RALINKCSR_STRUC, *PRALINKCSR_STRUC;

//
// BCNCSR: Beacon interval control register
//
typedef	union	_BCNCSR_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		Rsvd:16;		// [16:31] 
		ULONG		Plus:1;			// [15:15] plus	or minus delta time	value
		ULONG		Mode:2;			// [13:14] please refer	to ASIC	specs.
		ULONG		NumBcn:8;		// [05:12] Delta time value	or number of beacon	according to mode
		ULONG		DeltaTime:4;	// [01:04] The delta time value
		ULONG		Change:1;		// [00:00] Write one to	change beacon interval
	#else
		ULONG		Change:1;		// [00:00] Write one to	change beacon interval
		ULONG		DeltaTime:4;	// [01:04] The delta time value
		ULONG		NumBcn:8;		// [05:12] Delta time value	or number of beacon	according to mode
		ULONG		Mode:2;			// [13:14] please refer	to ASIC	specs.
		ULONG		Plus:1;			// [15:15] plus	or minus delta time	value
		ULONG		Rsvd:16;		// [16:31] 
	#endif		
	}	field;
	ULONG			word;
}	BCNCSR_STRUC, *PBCNCSR_STRUC;

//
// BBPCSR: BBP serial control register
//
typedef	union	_BBPCSR_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		Rsvd:15;			// [17:31]
		ULONG		WriteControl:1;		// [16:16] 1: Write	BBP, 0:	Read BBP
		ULONG		Busy:1;				// [15:15] 1: ASIC is busy execute BBP programming.	
		ULONG		RegNum:7;			// [08:14] Selected	BBP	register
		ULONG		Value:8;			// [00:07] Register	value to program into BBP
	#else
		ULONG		Value:8;			// [00:07] Register	value to program into BBP
		ULONG		RegNum:7;			// [08:14] Selected	BBP	register
		ULONG		Busy:1;				// [15:15] 1: ASIC is busy execute BBP programming.	
		ULONG		WriteControl:1;		// [16:16] 1: Write	BBP, 0:	Read BBP
		ULONG		Rsvd:15;			// [17:31]
	#endif
	}	field;
	ULONG			word;
}	BBPCSR_STRUC, *PBBPCSR_STRUC;

//
// RFCSR: RF serial	control	register
//
typedef	union	_RFCSR_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		Busy:1;				// [31:31] 1: ASIC is busy execute RF programming.
		ULONG		PLL_LD:1;			// [30:30] RF PLL_LD status
		ULONG		IFSelect:1;			// [29:29] 1: select IF	to program,	0: select RF to	program
		ULONG		NumberOfBits:5;	// [24:28] Number of bits used in RFRegValue (I:20,	RFMD:22)
		ULONG		RFRegValue:24;		// [00:23] Register	value (include register	id)	serial out to RF/IF	chip.
	#else
		ULONG		RFRegValue:24;		// [00:23] Register	value (include register	id)	serial out to RF/IF	chip.
		ULONG		NumberOfBits:5;	// [24:28] Number of bits used in RFRegValue (I:20,	RFMD:22)
		ULONG		IFSelect:1;			// [29:29] 1: select IF	to program,	0: select RF to	program
		ULONG		PLL_LD:1;			// [30:30] RF PLL_LD status
		ULONG		Busy:1;				// [31:31] 1: ASIC is busy execute RF programming.
	#endif
	}	field;
	ULONG			word;
}	RFCSR_STRUC, *PRFCSR_STRUC;

//
// LEDCSR: LED control register
//
typedef	union	_LEDCSR_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		Rsvd:11;					// [20:31]
		ULONG		LedADefault:1;			// [19:19] LED A default value for "enable"	state. 0: LED ON, 1: LED OFF
		ULONG		LedBPolarity:1;		// [18:18] 0: active low, 1: active	high
		ULONG		LedAPolarity:1;		// [17:17] 0: active low, 1: active	high
		ULONG		LedB:1;					// [16:16] controlled by software, 1: ON, 0: OFF
		ULONG		LedA:1;					// [15:15] indicate	TX activity, 1:	enable,	0: disable
		ULONG		OffPeriod:8;			// [08:15] Off period, default 30ms
		ULONG		OnPeriod:8;				// [00:07] On period, default 70ms
	#else
		ULONG		OnPeriod:8;				// [00:07] On period, default 70ms
		ULONG		OffPeriod:8;			// [08:15] Off period, default 30ms
		ULONG		LedA:1;					// [15:15] indicate	TX activity, 1:	enable,	0: disable
		ULONG		LedB:1;					// [16:16] controlled by software, 1: ON, 0: OFF
		ULONG		LedAPolarity:1;		// [17:17] 0: active low, 1: active	high
		ULONG		LedBPolarity:1;		// [18:18] 0: active low, 1: active	high
		ULONG		LedADefault:1;			// [19:19] LED A default value for "enable"	state. 0: LED ON, 1: LED OFF
		ULONG		Rsvd:11;					// [20:31]
	#endif	
	}	field;
	ULONG			word;
}	LEDCSR_STRUC, *PLEDCSR_STRUC;

//
// GPIOCSR:	GPIO control register
//
typedef	union	_GPIOCSR_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		Rsvd:16;		// [16:31]	
		ULONG		Dir7:1;		// [15:15] 
		ULONG		Dir6:1;		// [14:14] 
		ULONG		Dir5:1;		// [13:13] 
		ULONG		Dir4:1;		// [12:12] 
		ULONG		Dir3:1;		// [11:11] 
		ULONG		Dir2:1;		// [10:10] 
		ULONG		Dir1:1;		// [09:09] 
		ULONG		Dir0:1;		// [08:08] 
		ULONG		Bit7:1;		// [07:07] 
		ULONG		Bit6:1;		// [06:06] 
		ULONG		Bit5:1;		// [05:05] 
		ULONG		Bit4:1;		// [04:04] 
		ULONG		Bit3:1;		// [03:03] 
		ULONG		Bit2:1;		// [02:02] 
		ULONG		Bit1:1;		// [01:01] 
		ULONG		Bit0:1;		// [00:00] 
	#else
		ULONG		Bit0:1;		// [00:00] 
		ULONG		Bit1:1;		// [01:01] 
		ULONG		Bit2:1;		// [02:02] 
		ULONG		Bit3:1;		// [03:03] 
		ULONG		Bit4:1;		// [04:04] 
		ULONG		Bit5:1;		// [05:05] 
		ULONG		Bit6:1;		// [06:06] 
		ULONG		Bit7:1;		// [07:07] 
		ULONG		Dir0:1;		// [08:08] 
		ULONG		Dir1:1;		// [09:09] 
		ULONG		Dir2:1;		// [10:10] 
		ULONG		Dir3:1;		// [11:11] 
		ULONG		Dir4:1;		// [12:12] 
		ULONG		Dir5:1;		// [13:13] 
		ULONG		Dir6:1;		// [14:14] 
		ULONG		Dir7:1;		// [15:15] 
		ULONG		Rsvd:16;		// [16:31]	
	#endif
	}	field;
	ULONG			word;
}	GPIOCSR_STRUC, *PGPIOCSR_STRUC;

//
// BCNCSR1:	Tx BEACON offset time control register
//
typedef	union	_BCNCSR1_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN 
		ULONG		Rsvd:12;			// [20:31]
		ULONG			BeaconCwMin:4;	// [16:19] 2^CwMin
		ULONG			Preload:16;		// [00:15] in units	of usec
	#else
		ULONG			Preload:16;		// [00:15] in units	of usec
		ULONG			BeaconCwMin:4;	// [16:19] 2^CwMin
		ULONG		Rsvd:12;			// [20:31]
	#endif
	}	field;
	ULONG			word;
}	BCNCSR1_STRUC, *PBCNCSR1_STRUC;

//
// MACCSR2:	TX_PE to RX_PE turn-around time	control	register
//
typedef	union	_MACCSR2_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		ULONG		Rsvd:24;	// [08:31]
		ULONG		Delay:8;	// [00:07] in units	of PCI clock cycle
	#else
		ULONG		Delay:8;	// [00:07] in units	of PCI clock cycle
		ULONG		Rsvd:24;	// [08:31]
	#endif
	}	field;
	ULONG			word;
}	MACCSR2_STRUC, *PMACCSR2_STRUC;

//
// EEPROM antenna select format
//
typedef	union	_EEPROM_ANTENNA_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		USHORT		RfType:5;				// [11:15] see E2PROM document for RF IC selection
		USHORT		HardwareRadioControl:1;	// [10:10] 1: Hardware controlled radio	enabled, Read GPIO0	required.
		USHORT		DynamicTxAgcControl:1;	// [09:09] 
		USHORT		LedMode:3;				// [06:08] 0-default mode, 1:TX/RX activity	mode, 2: Single	LED	(didn't	care about link), 3: reserved
		USHORT		RxDefaultAntenna:2;		// [04:05] default of antenna, 0: diversity, 1:antenna-A, 2:antenna-B reserved (default	= 0)
		USHORT		TxDefaultAntenna:2;		// [02:03] default of antenna, 0: diversity, 1:antenna-A, 2:antenna-B reserved (default	= 0)
		USHORT		NumOfAntenna:2;			// [00:01] Number of antenna
	#else
		USHORT		NumOfAntenna:2;			// [00:01] Number of antenna
		USHORT		TxDefaultAntenna:2;		// [02:03] default of antenna, 0: diversity, 1:antenna-A, 2:antenna-B reserved (default	= 0)
		USHORT		RxDefaultAntenna:2;		// [04:05] default of antenna, 0: diversity, 1:antenna-A, 2:antenna-B reserved (default	= 0)
		USHORT		LedMode:3;				// [06:08] 0-default mode, 1:TX/RX activity	mode, 2: Single	LED	(didn't	care about link), 3: reserved
		USHORT		DynamicTxAgcControl:1;	// [09:09] 
		USHORT		HardwareRadioControl:1;	// [10:10] 1: Hardware controlled radio	enabled, Read GPIO0	required.
		USHORT		RfType:5;				// [11:15] see E2PROM document for RF IC selection
	#endif
	}	field;
	USHORT			word;
}	EEPROM_ANTENNA_STRUC, *PEEPROM_ANTENNA_STRUC;

typedef	union	_EEPROM_NIC_CINFIG2_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		USHORT		Rsv:14;					// [02:15] must	be 0
		USHORT		DynamicBbpTuning:1;		// [01:01] !!! NOTE: 0 - enable, 1 - disable
		USHORT		CardbusAcceleration:1;	// [00:00] !!! NOTE: 0 - enable, 1 - disable
	#else
		USHORT		CardbusAcceleration:1;	// [00:00] !!! NOTE: 0 - enable, 1 - disable
		USHORT		DynamicBbpTuning:1;		// [01:01] !!! NOTE: 0 - enable, 1 - disable
		USHORT		Rsv:14;					// [02:15] must	be 0
	#endif
	}	field;
	USHORT			word;
}	EEPROM_NIC_CONFIG2_STRUC, *PEEPROM_NIC_CONFIG2_STRUC;

typedef	union	_EEPROM_TX_PWR_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		UCHAR	Byte1;				// [08:15] High	Byte
		UCHAR	Byte0;				// [00:07] Low Byte
	#else
		UCHAR	Byte0;				// [00:07] Low Byte
		UCHAR	Byte1;				// [08:15] High	Byte
	#endif
	}	field;
	USHORT	word;
}	EEPROM_TX_PWR_STRUC, *PEEPROM_TX_PWR_STRUC;

typedef	union	_EEPROM_VERSION_STRUC	{
	struct	{
	#ifdef BIG_ENDIAN
		UCHAR	Version;			// [08:15] High	Byte
		UCHAR	FaeReleaseNumber;	// [00:07] Low Byte
	#else
		UCHAR	FaeReleaseNumber;	// [00:07] Low Byte
		UCHAR	Version;			// [08:15] High	Byte
	#endif
	}	field;
	USHORT	word;
}	EEPROM_VERSION_STRUC, *PEEPROM_VERSION_STRUC;

#endif	// __RT2560_H__
