/*  $Header: /proj/software/pub/CVSROOT/uClinux/linux/drivers/net/wireless/intersil/islpci_hotplug.c,v 1.3 2003/03/21 20:12:29 mrustad Exp $
 *  
 *  Copyright (C) 2002 Intersil Americas Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <linux/config.h>
#include <linux/version.h>
//#ifdef MODULE
#ifdef MODVERSIONS
#include <linux/modversions.h>
#endif
#include <linux/module.h>
//#else
//#define MOD_INC_USE_COUNT
//#define MOD_DEC_USE_COUNT
//#endif

#include <linux/pci.h>
#include <linux/init.h>

#include "version_info.h"
#include "isl_gen.h"
#include "isl_38xx.h"
#include "islpci_hotplug.h"
#include "islpci_dev.h"


#ifdef INTERSIL_EVENTS
#include <bloboid.h>
#include "isl_mgt.h"
#include "islpci_mgt.h"
#endif

#ifdef	CONFIG_ISL3877
#include "isl3877fw.h"
#endif	/* CONFIG_ISL3877 */

#ifdef	CONFIG_ISL3890
#include "isl3890fw.h"
#endif	/* CONFIG_ISL3890 */

/******************************************************************************
        Global variable definition section
******************************************************************************/
MODULE_AUTHOR("W.Termorshuizen, R.Bastings");
MODULE_DESCRIPTION("Intersil 802.11 Wireless LAN adapter");
MODULE_LICENSE("GPL");


//extern struct net_device *root_islpci_device;
extern int pc_debug;

struct pci_device_id pci_id_table[] =
{
    {
        PCIVENDOR_INTERSIL, PCIDEVICE_ISL3877,
        PCI_ANY_ID, PCI_ANY_ID, 0, 0,
        // Driver data, we just put the name here
        (unsigned long) "Intersil PRISM Indigo Wireless LAN adapter"
    },
    {
        PCIVENDOR_INTERSIL, PCIDEVICE_ISL3890,
        PCI_ANY_ID, PCI_ANY_ID, 0, 0,
        // Driver data, we just put the name here
        (unsigned long) "Intersil PRISM Duette Wireless LAN adapter"
    },
    {
        0, 0, 0, 0, 0, 0, 0
    }
};

// register the device with the Hotplug facilities of the kernel
MODULE_DEVICE_TABLE( pci, pci_id_table );

struct pci_driver islpci_pci_drv_id =
{
    {},
    DRIVER_NAME,                // Driver name
    pci_id_table,               // id table
    islpci_probe_pci,           // probe function
    __devexit_p(islpci_remove_pci),          // remove function
    NULL,                       // save_state function
    NULL,                       // suspend function
    NULL,                       // resume function
    NULL,                       // enable_wake function
};


/******************************************************************************
    Module initialization functions
******************************************************************************/
int islpci_probe_pci(struct pci_dev *pci_device,
                     const struct pci_device_id *id)
{
    void *phymem;
    u16 irq;
    u8 bus, devfn, latency_tmr;
    struct net_device *nw_device;
    islpci_private *private_config;
    int rvalue, dev_id;
    int dma_mask = 0xffffffff;
#if defined(CONFIG_ISL3877) || defined(CONFIG_ISL3890)
    char *firmware;
    int size;
#else
    char firmware[256];
#endif	/* CONFIG_ISL3877 || CONFIG_ISL3890 */

#if VERBOSE > SHOW_ERROR_MESSAGES 
    DEBUG(SHOW_FUNCTION_CALLS, "islpci_probe_pci\n");
#endif

    // Enable the pci device
    if (pci_enable_device(pci_device))
    {
        DEBUG(SHOW_ERROR_MESSAGES, "%s: pci_enable_device() failed.\n",
            DRIVER_NAME );
        return -EIO;
    }
    // Figure out our resources
    irq = pci_device->irq;
    bus = pci_device->bus->number;
    devfn = pci_device->devfn;
    dev_id = pci_device->device;

	// check whether the latency timer is set correctly
    pcibios_read_config_byte(bus, devfn, PCI_LATENCY_TIMER, &latency_tmr);
#if VERBOSE > SHOW_ERROR_MESSAGES 
	DEBUG( SHOW_TRACING, "latency timer: %x\n", latency_tmr );
#endif
	if( latency_tmr < PCIDEVICE_LATENCY_TIMER_MIN )
	{
		// set the latency timer
		pcibios_write_config_byte(bus, devfn, PCI_LATENCY_TIMER, 
			PCIDEVICE_LATENCY_TIMER_VAL );
	}

    // determine what the supported DMA memory region is
    while( pci_set_dma_mask( pci_device, dma_mask ) != 0 )
    {
        // range not supported, shift the mask and check again
        if( dma_mask >>=  1, dma_mask == 0 )
        {
            // mask is zero, DMA memory not supported by PCI
            DEBUG(SHOW_ERROR_MESSAGES, "DMA Memory not supported\n" );
            return -EIO;
        }
    }

#if VERBOSE > SHOW_ERROR_MESSAGES 
    DEBUG(SHOW_TRACING, "DMA Memory support mask is 0x%x \n", dma_mask );
#endif

    // call for the physical address to address the PCI device
    phymem = (void *) pci_resource_start(pci_device, 0);

    // request the pci device for regions ???
    if (rvalue = pci_request_regions(pci_device, DRIVER_NAME ), rvalue)
    {
        DEBUG(SHOW_ERROR_MESSAGES, "pci_request_regions failure, rvalue %i\n",
            rvalue );
        return -EIO;
    }

    // enable PCI bus-mastering
    pci_set_master(pci_device);

    // Log the device resources information
#if VERBOSE > SHOW_ERROR_MESSAGES 
    DEBUG(SHOW_TRACING, "islpci device: phymem:0x%lx, irq:%d \n",
        (long) phymem, irq);
#endif

    // setup the network device interface and its structure
    if (nw_device = islpci_probe(NULL, pci_device, (long) phymem, (int) irq),
        nw_device == NULL)
    {
        // error configuring the driver as a network device
        DEBUG(SHOW_ERROR_MESSAGES, "ERROR: %s could not configure "
            "network device \n", DRIVER_NAME );
        return -EIO;
    }

#ifdef WDS_LINKS
    mgt_indication_handler ( DEV_NETWORK, nw_device->ifindex, DOT11_OID_WDSLINKADD, islpci_wdslink_add_hndl );
    mgt_indication_handler ( DEV_NETWORK, nw_device->ifindex, DOT11_OID_WDSLINKREMOVE, islpci_wdslink_del_hndl );
#endif

    // save the interrupt request line and use the remapped device base address
    // as the device identification both for uniqueness and parameter passing
    // to the interrupt handler
    private_config = nw_device->priv;
    private_config->pci_irq = irq;
    private_config->pci_dev_id = dev_id;
    private_config->device_id = private_config->remapped_device_base;
    private_config->pci_device = pci_device;
	spin_lock_init( &private_config->slock );

    // request for the interrupt before uploading the firmware
    if (rvalue = request_irq(irq, &islpci_interrupt, SA_INTERRUPT | SA_SHIRQ,
        DRIVER_NAME, private_config), rvalue != 0)
    {
        // error, could not hook the handler to the irq
        DEBUG(SHOW_ERROR_MESSAGES, "ERROR: %s could not install "
            "IRQ-handler \n", DRIVER_NAME );
        return -EIO;
    }

#if	defined(CONFIG_ISL3877) && defined(CONFIG_ISL3890)
#define	FIRMWARE	firmware, size
    if (dev_id == PCIDEVICE_ISL3890)
	firmware = isl3890fw, size = sizeof isl3890fw;
    else
	firmware = isl3877fw, size = sizeof isl3877fw;
#elif	defined(CONFIG_ISL3877)
#define	FIRMWARE	firmware, size
    firmware = isl3877fw, size = sizeof isl3877fw;
#elif	defined(CONFIG_ISL3890)
#define	FIRMWARE	firmware, size
    firmware = isl3890fw, size = sizeof isl3890fw;
#else
    // select the firmware file depending on the device id, take for default
    // the 3877 firmware file
#define	FIRMWARE	firmware
    if( dev_id == PCIDEVICE_ISL3890 )
    	strcpy( firmware, ISL3890_IMAGE_FILE );
    else
    	strcpy( firmware, ISL3877_IMAGE_FILE );

#if VERBOSE > SHOW_ERROR_MESSAGES 
    DEBUG(SHOW_TRACING, "Firmware file: %s \n", firmware );
#endif
#endif	/* CONFIG_ISL3877 || CONFIG_ISL3890 */
	
    if (isl38xx_upload_firmware( FIRMWARE, private_config->remapped_device_base,
        private_config->device_host_address ) == -1)
    {
        // error uploading the firmware
        DEBUG(SHOW_ERROR_MESSAGES, "ERROR: %s could not upload the "
            "firmware \n", DRIVER_NAME );
        return -EIO;
    }

    return 0;
}

void islpci_remove_pci( struct pci_dev *pci_device )
{
//    struct net_device **devp, **next;
    struct net_device *dev = pci_get_drvdata(pci_device);
    islpci_private *private_config = dev->priv;

#if VERBOSE > SHOW_ERROR_MESSAGES 
    DEBUG(SHOW_FUNCTION_CALLS, "islpci_remove_pci\n");
#endif

    if (dev == 0)
        BUG();

#if 0
    for (devp = &root_islpci_device; *devp; devp = next)
    {
        next = &((islpci_private *) (*devp)->priv)->next_module;
        private_config = (*devp)->priv;

        // free the interrupt request
        writel(0, private_config->remapped_device_base + ISL38XX_INT_EN_REG);
        free_irq(private_config->pci_irq, private_config);
    }
#else
    // free the interrupt request
    writel(0, private_config->remapped_device_base + ISL38XX_INT_EN_REG);
    free_irq(private_config->pci_irq, private_config);

    // unregister the network device
    unregister_netdev(dev);

    // free the PCI memory and unmap the remapped page
    pci_free_consistent(private_config->pci_device, ISL38XX_HOST_MEM_BLOCK,
            private_config->driver_mem_address,
            private_config->device_host_address);
    iounmap(private_config->remapped_device_base);
    pci_release_regions(private_config->pci_device);

    // free the separately allocated areas
    kfree(private_config);
    kfree(dev);
#endif	/* 0 */
}

static int init_module( void )
{
    DEBUG(SHOW_ANYTHING, "Loaded %s, version %s\n", DRIVER_NAME, VERSIONID );

#ifdef INTERSIL_EVENTS
    mgt_init();
#endif
    
    if (pci_register_driver(&islpci_pci_drv_id) <= 0)
    {
        DEBUG(SHOW_ERROR_MESSAGES, "%s: No devices found, driver not "
            "installed.\n", DRIVER_NAME);
        pci_unregister_driver(&islpci_pci_drv_id);
        return -ENODEV;
    }

#ifdef INTERSIL_EVENTS
    mgt_indication_handler ( DEV_NETWORK, 0, 0, islpci_mgt_indication );
#endif

    return 0;
}

#if 0
static void cleanup_module( void )
{
    struct net_device *next_dev;
    islpci_private *private_config;

#ifdef INTERSIL_EVENTS
    mgt_cleanup();
#endif
    
    pci_unregister_driver(&islpci_pci_drv_id);

    // No need to check MOD_IN_USE, as sys_delete_module() checks
    while (root_islpci_device)
    {
        private_config = (islpci_private *) root_islpci_device->priv;
        next_dev = private_config->next_module;

#if VERBOSE > SHOW_ERROR_MESSAGES 
        DEBUG(SHOW_TRACING, "Cleanup netdevice \n");
#endif
        // unregister the network device
        unregister_netdev(root_islpci_device);

        // free the PCI memory and unmap the remapped page
        pci_free_consistent(private_config->pci_device, ISL38XX_HOST_MEM_BLOCK,
            private_config->driver_mem_address,
            private_config->device_host_address);
        iounmap(private_config->remapped_device_base);
        pci_release_regions(private_config->pci_device);

        // free the separately allocated areas
        kfree(private_config);
        kfree(root_islpci_device);

        // change the root device pointer to the next device for clearing
        root_islpci_device = next_dev;
    }

    DEBUG(SHOW_ANYTHING, "Unloaded %s\n", DRIVER_NAME );
}
#endif	/* 0 */

static int __init	islpci_init(void)
{
#ifdef	MODULE
	printk(version);
#endif	/* MODULE */
	return init_module();
}

static void __exit	islpci_exit(void)
{
	pci_unregister_driver(&islpci_pci_drv_id);
}

module_init(islpci_init);
module_exit(islpci_exit);
