/*
 $Header: /proj/software/pub/CVSROOT/uClinux/linux/drivers/net/phy971.h,v 1.3 2003/01/07 17:36:24 rsewill Exp $
 */

/******************************************************************/
/* Copyright (c) 2002 BRECIS Communications                       */
/*                                                                */
/*     This program is free software; you can redistribute it     */
/*     and/or modify it under the terms of the GNU General        */
/*     Public License as published by the Free Software           */
/*     Foundation; either version 2 of the License, or (at your   */
/*     option) any later version.                                 */
/*                                                                */
/*     This program is distributed in the hope that it will be    */
/*     useful, but WITHOUT ANY WARRANTY; without even the implied */
/*     warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR    */
/*     PURPOSE.  See the GNU General Public License for more      */
/*     details.                                                   */
/*                                                                */
/*     You should have received a copy of the GNU General Public  */
/*     License along with this program; if not, write to the Free */
/*     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA     */
/*     02139, USA.                                                */
/*                                                                */
/* BRECIS COMMUNICATIONS DISCLAIMS ANY LIABILITY OF ANY KIND      */
/* FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS      */
/* SOFTWARE.                                                      */
/*                                                                */
/******************************************************************/

/* Definitions for the Intel 971 MAC PHY */

#ifndef __INTEL_PHY971aDEF__
#define __INTEL_PHY971aDEF__

/* PHY Register Addresses */  

#define PHY971_1000BASE_T_100BASE_T2_CONTROL	9
#define PHY971_1000BASE_T_100BASE_T2_STATUS		10
	/* Value 11 - 14 NOT USED */
#define PHY971_EXTENDED_STATUS					15
#define PHY971_PORT_CONFIG						16
#define PHY971_STATUS_REG_TWO					17
#define PHY971_INTERRUPT_ENABLE					18
#define PHY971_INTERRUPT_STATUS					19
#define PHY971_LED_CONFIG						20
	/* Value 21 - 29 NOT USED */
#define PHY971_TRANSMIT_CONTROL					30



/* Bit Defines for PHY971_STATUS_REG_TWO 	*/
/* ---------------------------------------- */
	/* not used										0x8000	*/
#define PHY971b_STATUS_REG_TWO_MODE_100				0x4000 
#define PHY971b_STATUS_REG_TWO_TX_STATUS			0x2000
#define PHY971b_STATUS_REG_TWO_RX_STATUS			0x1000
#define PHY971b_STATUS_REG_TWO_COLLISION_STATUS		0x0800
#define PHY971b_STATUS_REG_TWO_LINK					0x0400
#define PHY971b_STATUS_REG_TWO_DUPLEX_MODE			0x0200
#define PHY971b_STATUS_REG_TWO_AUTO_NEGOTIATION		0x0100
#define PHY971b_STATUS_REG_TWO_AUTO_NEGO_COMPELETE	0x0080
	/* not used										0x0040	*/
#define PHY971b_STATUS_REG_TWO_POLARITY				0x0020
#define PHY971b_STATUS_REG_TWO_PAUSE				0x0010
#define PHY971b_STATUS_REG_TWO_ERROR				0x0008
	/* not used										0x0004	*/
	/* not used										0x0002	*/
	/* not used										0x0001	*/



/* Bit Defines for PHY971_INTERRUPT_ENABLE 	*/
/* ---------------------------------------- */
#define PHY971_INTERRUPT_ENABLE_ANMSK				0x0080
#define PHY971_INTERRUPT_ENABLE_SPEEDMSK			0x0040
#define PHY971_INTERRUPT_ENABLE_DUPLEXMSK			0x0020
#define PHY971_INTERRUPT_ENABLE_LINKMSK				0x0010
	/* not used										0x0008	*/
	/* not used										0x0004	*/
#define PHY971_INTERRUPT_ENABLE_INTEN				0x0002
#define PHY971_INTERRUPT_ENABLE_TINT				0x0001




/* Bit Defines for PHY971_INTERRUPT_STATUS 	*/
/* ---------------------------------------- */
#define PHY971_INTERRUPT_STATUS_ANDONE				0x0080
#define PHY971_INTERRUPT_STATUS_SPEEDCHG			0x0040
#define PHY971_INTERRUPT_STATUS_DUPLEXCHG			0x0020
#define PHY971_INTERRUPT_STATUS_LINKCHG				0x0010
	/* not used										0x0008	*/
#define PHY971_INTERRUPT_STATUS_MDINT				0x0004
	/* not used										0x0002	*/
	/* not used										0x0001	*/

#endif

/* Definitions for the Intel 971 MAC PHY */

extern void MSPPHY971DisplayRegisters (U32 interface);
extern void MSPPHY971DuplexIntEnable(MSP_DEVICE *pDrvCtrl);
extern U32 MSPPHY971HandleInt(MSP_DEVICE *pDrvCtrl);

