/*
 $Header: /proj/software/pub/CVSROOT/uClinux/linux/drivers/net/phy8721.h,v 1.3 2003/01/07 17:36:24 rsewill Exp $
 */

/******************************************************************/
/* Copyright (c) 2002 BRECIS Communications                       */
/*                                                                */
/*     This program is free software; you can redistribute it     */
/*     and/or modify it under the terms of the GNU General        */
/*     Public License as published by the Free Software           */
/*     Foundation; either version 2 of the License, or (at your   */
/*     option) any later version.                                 */
/*                                                                */
/*     This program is distributed in the hope that it will be    */
/*     useful, but WITHOUT ANY WARRANTY; without even the implied */
/*     warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR    */
/*     PURPOSE.  See the GNU General Public License for more      */
/*     details.                                                   */
/*                                                                */
/*     You should have received a copy of the GNU General Public  */
/*     License along with this program; if not, write to the Free */
/*     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA     */
/*     02139, USA.                                                */
/*                                                                */
/* BRECIS COMMUNICATIONS DISCLAIMS ANY LIABILITY OF ANY KIND      */
/* FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS      */
/* SOFTWARE.                                                      */
/*                                                                */
/******************************************************************/

/* Definitions for the Kendin 8721 MAC PHY */

#ifndef __KENDIN_8721DEF__
#define __KENDIN_8721DEF__

/* PHY Register Addresses */  

	/* Value 9 - 21 NOT USED */
#define PHY8721_RXER_COUNTER					21
	/* Value 22 - 26 NOT USED */
#define PHY8721_INTERRUPT_CONTROL_STATUS		27
	/* Value 28 - 30 NOT USED */
#define PHY8721_100BASE_TX_PHY_CONTROLLER		31


/* Bit Defines for PHY8721_INTERRUPT_ENABLE (Register 0x1b -- 27)	*/
/* -------------------------------------------------------------- 	*/
	
#define PHY8721b_INTERRUPT_JABBER_ENABLE				0x8000
#define PHY8721b_INTERRUPT_RECEIVE_ERROR_ENABLE			0x4000
#define PHY8721b_INTERRUPT_PAGE_RECEIVE_ENABLE			0x2000
#define PHY8721b_INTERRUPT_PARALLEL_DETECT_FAULT_ENABLE	0x1000

#define PHY8721b_INTERRUPT_LINK_PARTNER_ACK_ENABLE		0x0800
#define PHY8721b_INTERRUPT_LINK_DOWN_ENABLE				0x0400
#define PHY8721b_INTERRUPT_REMOTE_FAULT_ENABLE			0x0200
#define PHY8721b_INTERRUPT_LINK_UP_ENABLE				0x0100

#define PHY8721b_INTERRUPT_JABBER						0x0080
#define PHY8721b_INTERRUPT_RECEIVE_ERROR				0x0040
#define PHY8721b_INTERRUPT_PAGE_RECEIVE					0x0020
#define PHY8721b_INTERRUPT_PARALLEL_DETECT_FAULT		0x0010

#define PHY8721b_INTERRUPT_LINK_PARTNER_ACK				0x0008
#define PHY8721b_INTERRUPT_LINK_DOWN					0x0004
#define PHY8721b_INTERRUPT_REMOTE_FAULT					0x0002
#define PHY8721b_INTERRUPT_LINK_UP						0x0001


/* Bit Defines for PHY8721_100BASE_TX_PHY_CONTROLLER (Register 0x1f -- 31)	*/
/* ----------------------------------------------------------------------- 	*/

	/* not used											0x8000	*/
	/* not used											0x4000	*/
#define PHY8721b_100BASE_TX_PHY_PAIRSWAP_DISABLE		0x2000
#define PHY8721b_100BASE_TX_PHY_ENERGY_DETECT			0x1000

#define PHY8721b_100BASE_TX_PHY_FORCE_LINK				0x0800
#define PHY8721b_100BASE_TX_PHY_POWER_SAVING			0x0400
#define PHY8721b_100BASE_TX_PHY_INTERRUPT_LEVEL			0x0200
#define PHY8721b_100BASE_TX_PHY_ENABLE_JABBER			0x0100

#define PHY8721b_100BASE_TX_PHY_AUTO_NEG_COMPLETE 		0x0080
#define PHY8721b_100BASE_TX_PHY_ENABLE_PAUSE	 		0x0040
#define PHY8721b_100BASE_TX_PHY_ISOLATE			 		0x0020

#define PHY8721b_100BASE_TX_PHY_OP_PHY_MII_ISOLATE		0x0007
#define PHY8721b_100BASE_TX_PHY_OP_100BASE_FULL_DUPLEX	0x0006
#define PHY8721b_100BASE_TX_PHY_OP_10BASE_FULL_DUPLEX	0x0005
#define PHY8721b_100BASE_TX_PHY_OP_DEFAULT				0x0003
#define PHY8721b_100BASE_TX_PHY_OP_100BASE_HALF_DUPLEX 	0x0002
#define PHY8721b_100BASE_TX_PHY_OP_10BASE_HALF_DUPLEX	0x0001
#define PHY8721b_100BASE_TX_PHY_OP_STILL_IN_AUTO_NEG	0x0000
#define PHY8721b_100BASE_TX_PHY_OPERATION_MODE_MASK		0x001C

#define PHY8721b_100BASE_TX_PHY_ENABLE_SQE_TEST 		0x0002
#define PHY8721b_100BASE_TX_PHY_DISABLE_DATA_SCRAMBLING	0x0001

#endif

/* Definitions for the Kendin 8721 MAC PHY */

extern void MSPPHY8721DisplayRegisters (U32 interface);
extern U32 MSPPHY8721HandleInt(MSP_DEVICE *pDrvCtrl);
