/*
 $Header: /proj/software/pub/CVSROOT/uClinux/linux/drivers/net/phy8721.c,v 1.5 2003/01/07 17:36:24 rsewill Exp $
 */

/******************************************************************/
/* Copyright (c) 2002 BRECIS Communications                       */
/*                                                                */
/*     This program is free software; you can redistribute it     */
/*     and/or modify it under the terms of the GNU General        */
/*     Public License as published by the Free Software           */
/*     Foundation; either version 2 of the License, or (at your   */
/*     option) any later version.                                 */
/*                                                                */
/*     This program is distributed in the hope that it will be    */
/*     useful, but WITHOUT ANY WARRANTY; without even the implied */
/*     warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR    */
/*     PURPOSE.  See the GNU General Public License for more      */
/*     details.                                                   */
/*                                                                */
/*     You should have received a copy of the GNU General Public  */
/*     License along with this program; if not, write to the Free */
/*     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA     */
/*     02139, USA.                                                */
/*                                                                */
/* BRECIS COMMUNICATIONS DISCLAIMS ANY LIABILITY OF ANY KIND      */
/* FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS      */
/* SOFTWARE.                                                      */
/*                                                                */
/******************************************************************/


#include "brecismspeth.h"
#include "phyethgeneric.h"
#include "phy8721.h"

/*************************************************************************
*
* MSPPHY8721DisplayRegisters - displays the register of the PHY 8721.
*
* RETURNS: OK, or ERROR
*  
**************************************************************************/
void MSPPHY8721DisplayRegisters(U32 interfaceNum)
{
	MSP_DEVICE	*pDrvCtrl; 

	if (interfaceNum >= MSP_ETH_MAX_UNITS)
	{
		printk (KERN_INFO "interface %d out of range\n", 
			(int) interfaceNum);
		return;
	}

	pDrvCtrl = gEthDrvCtrl[interfaceNum];

	printk(KERN_INFO "\n---------------------------------------------------\n");
	printk(KERN_INFO "Displaying PHY8721 Registers.\n");
	printPhyRegister(pDrvCtrl, PHY8721_RXER_COUNTER );
	printPhyRegister(pDrvCtrl, PHY8721_INTERRUPT_CONTROL_STATUS );
	printPhyRegister(pDrvCtrl, PHY8721_100BASE_TX_PHY_CONTROLLER );
}

/*************************************************************************
 *
 * MSPPHY8721HandleInt - Handles the interrupt from the PHY 8721.
 *
 *  
 **************************************************************************/
U32 MSPPHY8721HandleInt(MSP_DEVICE *pDrvCtrl)
{
	U32 data;

	/*
	 * Read the ISR of the PHY8721 to determine the cause of the interrupt.
	 */
	if (readPhyRegister(pDrvCtrl, PHY8721_INTERRUPT_CONTROL_STATUS, &data))
	{
		printk(KERN_INFO "MSPPHY8721HandleInt: PHY8721 BUSY\n");
		return MSP_MAC_PHY_ERROR ;
	}	

	if (data & PHY8721b_INTERRUPT_LINK_DOWN)
	{
		return MSP_MAC_PHY_NO_LINK ;
	}

	if (data & PHY8721b_INTERRUPT_LINK_UP)
	{
		return MSPPHYGGetSpeedAndDuplex(pDrvCtrl);
	}
	return MSP_SUCCESS;
}

