/*
$Header: /proj/software/pub/CVSROOT/uClinux/linux/drivers/net/brecismspeth.h,v 1.52 2003/03/18 19:57:02 rsewill Exp $
 */

/******************************************************************/
/* Copyright (c) 2002 BRECIS Communications                       */
/*                                                                */
/*     This program is free software; you can redistribute it     */
/*     and/or modify it under the terms of the GNU General        */
/*     Public License as published by the Free Software           */
/*     Foundation; either version 2 of the License, or (at your   */
/*     option) any later version.                                 */
/*                                                                */
/*     This program is distributed in the hope that it will be    */
/*     useful, but WITHOUT ANY WARRANTY; without even the implied */
/*     warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR    */
/*     PURPOSE.  See the GNU General Public License for more      */
/*     details.                                                   */
/*                                                                */
/*     You should have received a copy of the GNU General Public  */
/*     License along with this program; if not, write to the Free */
/*     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA     */
/*     02139, USA.                                                */
/*                                                                */
/* BRECIS COMMUNICATIONS DISCLAIMS ANY LIABILITY OF ANY KIND      */
/* FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS      */
/* SOFTWARE.                                                      */
/*                                                                */
/******************************************************************/

#ifndef __mspEthDefH__
#define __mspEthDefH__

/* #define MSP_TAKE_TX_INTERRUPTS */

#include <linux/skbuff.h>
#include <linux/netdevice.h>
#include <linux/init.h>
#include <linux/ioport.h>
#include <linux/if.h>
#include <asm/addrspace.h>
#include <linux/etherdevice.h>
#include <linux/delay.h>
#include <linux/ctype.h>
#include <linux/timer.h>
#include <linux/if_vlan.h>
#include <brecis/NanoDelay.h>

/****************
 * EXTERNS
 ****************/
extern int icache_size, dcache_size; /* Size in bytes */
extern int ic_lsize, dc_lsize;       /* LineSize in bytes */

/* Secondary cache (if present) parameters. */
extern unsigned int scache_size, sc_lsize;	/* Again, inb ytes */

/* this has to be after the above externs */
#include <asm/r4kcache.h>

#define RELOAD_CHECK_DELAY	1	/* reload check delay in seconds */
#define CARRIER_RELOAD_DELAY	2	/* reload if carrier off more than
					 * this many jiffies */

/****************
 * DEBUG MACROS
 ***************/
/* use 0 for production, 1 for verification, >2 for debug */
#ifndef NET_DEBUG
#define NET_DEBUG 5
#endif

/* #define DEBUGPRINTK */
#ifdef DEBUGPRINTK
#define PRINTK(x...)	printk(x)
#define	IDBG(x...)	pkinit(x)
#else
#define PRINTK(x...)	do { } while (0)
#define	IDBG(x...)	do { } while (0)
#endif

/****************
 * HARDWARE DEFINES
 ***************/
typedef char		INT8;
typedef long		INT32;
typedef unsigned char	UINT8;
typedef unsigned short	UINT16;
typedef unsigned long	UINT32;
typedef unsigned short	U16;
typedef unsigned long	U32;
typedef unsigned char	UCHAR;
typedef unsigned long	ULONG;
typedef unsigned int	UINT;
typedef unsigned char	BOOL;

/* #define ETHERNETUSESCRATCHRAM */

#ifdef ETHERNETUSESCRATCHRAM
#define MAXSCRATCHRAMPARTITIONS	10
#define SCRATCHRAMADDR		(0xb7f80000)
#define ETHERNETSCRATCHRAMLEN	0x4000
#endif

/*--------------------------------------------------------------------------+
| System/Device Identification Registers
+--------------------------------------------------------------------------*/
#define	SREG_BASE	0xBC000000	/* Base address to SLM Block       */

#define	SYS_RST_REG	(SREG_BASE + 0x010)  /* system Reset Status Register RO */
#define	RST_SET_REG	(SREG_BASE + 0x014)  /* System set Reset Register    WO */
#define	RST_CLR_REG	(SREG_BASE + 0x018)  /* System Clear Reset Register  WO */

#define MAC0_RST	0x40		/* Ethernet 0 Reset */
#define MAC1_RST	0x80		/* Ethernet 1 Reset */
#define MAC2_RST	0x400		/* Ethernet 2 Reset */

#define	PER_BASE			0xB8400000		
#define GPIO_CFG7_REG		((volatile unsigned int *)(PER_BASE + 0x198))
#define POLO_MAC2_ENABLE	(0x20000000)		

#define	MEM_CTL_BASE	0xB7F00000	/* Base address to memory contlr   */
#ifndef MEM_CNFG1_REG
#define MEM_CNFG1_REG	((volatile UINT32 *) (MEM_CTL_BASE + 0x00))	/* memory configuration reg */
#endif

/*
 * Error RC
 */
typedef int			RET_CODE;

#define	MSP_SUCCESS		0	// function call was successful
#define MSP_FAIL		-1	// general error code
#define MSP_MAC_ERROR_BASE	9000
#define MSP_MAC_MEM_ALLOC_ERROR	(MSP_MAC_ERROR_BASE + 2)
#define MSP_MAC_PHY_ERROR		(MSP_MAC_ERROR_BASE + 6)
#define MSP_MAC_PHY_NO_LINK		(MSP_MAC_ERROR_BASE + 12)

/* The number of low I/O ports used by the ethercard.????...MaTed---????? */

#define MY_TX_TIMEOUT  ((400*HZ)/1000)

/*--------------------------------------------------------------------------+
|  EThernet MAC0/1
+--------------------------------------------------------------------------*/
#define	MAC0_BASE	0xB8600000	/* Base address to MAC0 Controller */
#define	MAC1_BASE	0xB8700000	/* Base address to MAC1 Controller */
#define	MAC2_BASE	0xB8900000	/* Base address to MAC2 Controller */


/*--------------------------------------------------------------------------+
| Ethernet MAC-0 and MAC-1 Registers Addresses
+--------------------------------------------------------------------------*/

typedef volatile unsigned long MACREG;

typedef struct {
	MACREG	DMA_CTL;		/* DMA Control                     */
	MACREG	TXFRMPTR;		/* Transmit Frame Pointer          */
	MACREG	TXTHRSH;		/* Transmit Threshold              */
	MACREG	TXPOLLCTR;		/* Transmit Polling Counter        */

	MACREG	BLFRMPTR;		/* Buffer List Frame Pointer       */
	MACREG	RXFRAGSIZE;		/* Receive Fragment Size           */
	MACREG	INT_EN;			/* Interrupt Enable                */
	MACREG	FDA_BAS;		/* Free Descriptor Area Base       */

	MACREG	FDA_LIM;		/* Free Descriptor Area Limit      */
	MACREG	INT_SRC;		/* Interrupt Source                */
	MACREG	RM_BBR;			/* RMON Burst Base Register        */
	MACREG	RM_BCTL;		/* RMON Burst Control              */

	MACREG	PAUSECNT;		/* Pause Count                     */
	MACREG	REMPAUCNT;		/* Remote Pause Count              */
	MACREG	TXCONFRMSTAT;		/* Transmit Control Frame Status   */
	MACREG	unused1;

	MACREG MAC_CTL;			/* MAC Control                     */
	MACREG ARC_CTL;			/* ARC Control                     */
	MACREG TX_CTL;			/* Transmit Control                */
	MACREG TX_STAT;			/* Transmit Status                 */

	MACREG RX_CTL;			/* Receive Control                 */
	MACREG RX_STAT;			/* Receive Status                  */
	MACREG MD_DATA;			/* Station Management Data         */
	MACREG MD_CA;			/* Station Management Control&Addr */

	MACREG ARC_ADR;			/* ARC Address                     */
	MACREG ARC_DATA;		/* ARC Data                        */
	MACREG ARC_ENA;			/* ARC Enable                      */
	MACREG PROM_CTL;		/* PROM Control                    */

	MACREG PROM_DATA;		/* PROM data                       */
	MACREG unused2[2];
	MACREG MISS_CNT;		/* Missed Error Count              */

	MACREG CNTDATA;			/* Count Data Register             */
	MACREG CNTACC;			/* Count Access Register           */
	MACREG TXRMINTEN;		/* Transmit RMON Interrupt Enable  */
	MACREG RXRMINTEN;		/* Receive RMON Interrupt Enable   */

	MACREG TXRMINTSTAT;		/* Transmit RMON Interrupt Status  */
	MACREG RXRMINTSTAT;		/* Receive RMON Interrupt Status   */
	MACREG unused3[2];

	MACREG unused4[12];

	MACREG MAC_ID_REG;		/* Version #			   */
	MACREG MAC_BRCTRL_REG;		/* Bridge Control Register	   */

} MAC_BASE;

/*  Ethernet Mac Defines */

/*
 * DMA Control (DMA_Ctl) (0x00)
 */
/*  NOT USED                    0x00000001      */
/*  NOT USED                    0x00000002      */
/*  DmBurst                     bits 2 to 8     */
/*  NOT USED                    bits 9 to 11    */
#define DMA_CTL_PowrMgmnt       0x00001000  /* Enable dynamic power mgmt */
#define DMA_CTL_TestMode        0x00002000  /* Test Mode - Reserved bits */
#define DMA_CTL_TxBigE          0x00004000  /* Tx Big Endian */
#define DMA_CTL_RxBigE          0x00008000  /* Rx Big Endian */
#define DMA_CTL_TxWakeUp        0x00010000  /* Start Tx immedidately */
#define DMA_CTL_SWIntReq        0x00020000  /* When set cause interrupt */
#define DMA_CTL_IntMask         0x00040000  /* When set no interrupts */
#define DMA_CTL_M66EnStat       0x00080000  /* When set 66 MHz Bus else 33 */
#define DMA_CTL_RMTxInit        0x00100000  /* When set init Tx Rmon counters */
#define DMA_CTL_RMRxInit        0x00200000  /* When set init RX Rmon counters */
/*  RxAlign                     bits 22 to 23   */
#define DMA_CTL_RxAlignSkip0    (0x00<<22)  /* Do not skip any bytes on rx */
#define DMA_CTL_RxAlignSkip1    (0x01<<22)  /* Skip 1st byte on rx */
#define DMA_CTL_RxAlignSkip2    (0x02<<22)  /* Skip 2nd byte on rx */
#define DMA_CTL_RxAlignSkip3    (0x03<<22)  /* Skip 3rd byte on rx */
#define DMA_CTL_RMSwReg         0x01000000  /* Rmon switch ownership of Bank */
#define DMA_CTL_RMemBank        0x02000000  /* when set s/w can access bank 0 */

/*
 * Interrupt Enable Register INT_EN (0x18)
 * Since bit 6 of the Int_En register at 0x18 is reserved and even writing
 * to this reister causes randon interrupts, take caution when writing to this
 * register - always write 0 there. For this reason there are two
 * defintion for Enable and Disable and couldn't use the ~ of the Enable for
 * Disable,
 *
 *
 * EnLenErr is a bit that is NOT defined in the manual but was added
 * It indicates the reception of a frame whose protocol id field value
 * does not match a length.  This interrupt allows us the process IP
 * and other packets whose protocol id field is not treated as a length
 */

#define INT_EN_FDAExEn		0x00000001	/* Enable FDA Exhaust Interrupt */
#define INT_EN_BLExEn		0x00000002	/* Enable BL Exhaust Interrupt */
#define INT_EN_STargAbtEn	0x00000004	/* Enable Target Abort Interrupt */
#define INT_EN_RTargAbtEn	0x00000008	/* Enable Rx Target Abort Interrupt */
#define INT_EN_RMasAbtEn	0x00000010	/* Enable Rx Master Abort Interrupt */
#define INT_EN_SSysErrEn	0x00000020	/* Enable Master Abort Interrupt */
#define INT_EN_EarNotEn		0x00000080	/* Enable Early Notify Interrupt */
#define INT_EN_DParDEn		0x00000100	/* Enable Data Parity Detected */
#define INT_EN_DmParErrEn	0x00000200	/* Enable Parity Error during DMA */
#define INT_EN_TxCltCmpEn	0x00000400	/* Enable Int after Tx MAC Ctl pkt */
#define INT_EN_NRAbtEn		0x00000800	/* Enable non-recoverable abort */


#define RX_CTL_RxEn		0x00000001	/* Receive Enable */
#define RX_CTL_RxHalt		0x00000002	/* Receive Halt Enable */
#define RX_CTL_LongEn		0x00000004  /* Enable Rx of Packet(>1522 bytes) */
#define RX_CTL_ShortEn		0x00000008	/* Enable Rcv of frames < 64 bytes */
#define RX_CTL_StripCRC		0x00000010	/* Strip CRC */
#define RX_CTL_PassCtl		0x00000020	/* Pass MAC Control Packets to System */
#define RX_CTL_IgnoreCRC	0x00000040	/* Do the check CRC */
/*		NOT USED			0x00000080	*/
#define RX_CTL_EnAlign		0x00000100	/* Interrupt not mult 8 bits/bad crc */
#define RX_CTL_EnCRCErr		0x00000200	/* Enable CRC Error Interrupt */
#define RX_CTL_EnOver		0x00000400	/* interrupt on overflow */
#define RX_CTL_EnLongErr	0x00000800	/* interrupt on frame > 1518/1522 */
#define RX_CTL_EnLenErr		0x00001000	/* Interrupt on Length Error */
#define RX_CTL_EnRxPar		0x00002000	/* interrupt if parity error */
#define RX_CTL_EnGood		0x00004000	/* Interrupt on frame with no errors */


/*
 *	Interrupt Source Register (0x24).
 */
#define INTR_Tx		0x00000001	/* Tx Status written.*/
#define INTR_Rx		0x00000002	/* Rx Status written.*/
#define INTR_PCI	0x00000004	/* PCI */
#define INTR_IntFDAEx	0x00000008	/* FDA Exhausted. - RO   */

#define INTR_IntBLEx	0x00000010	/* Buffer List Full.- RO */
#define INTR_SW_INT	0x00000020	/* SW Interrupt */
#define INTR_EARLY_NOT  0x00000040	/* Early Notification */
#define INTR_DMAPARITY	0x00000080	/* DMA Parity */

#define INTR_EXCESSBD	0x00000100	/* Excessive BDs */
#define INTR_MACCTLTX	0x00000200	/* Mac Packet Complete */
#define INTR_IntNRAbt	0x00000400	/* Non-recoveravle Abort */
#define INTR_FDAEx	0x00000800	/* FDA exhausted during reception. */

#define INTR_BLEx	0x00001000	/* BL exhausted during reception.  */
#define INTR_DMAPARSTAT	0x00002000	/* DMA Parity Error.  */
#define INTR_NRAbt	0x00004000	/* Non-recoveravle Abort */
#define INTR_LINKSTATE	0x00008000	/* Link State Change */

#define INTR_EXCESSTXDF	0x00010000	/* Excessive Tx Deferrals */
#define INTR_RMON	0x00020000	/* RMON Rollover */
#define INTR_EXTEVENT	0x00040000	/* Exernal Event */

/*
 * Bit Definitioons for MAC_CTL		0x40
 */
#define MAC_CTL_HaltReq	0x00000001	/* Stop tx/rx after active frame */
#define MAC_CTL_HaltImm	0x00000002	/* stop tx/rx immediately */
#define MAC_CTL_Reset	0x00000004	/* Software Reset */
#define MAC_CTL_FullDup	0x00000008	/* set if MII_High for Full Duplex */
#define MAC_CTL_MacLoop	0x00000010	/* Mac loopback */
/*			Bits 5-6 are connection mode */
#define MAC_CTL_ConModeAuto	(0<<5)	/* Automatic Mode */
#define MAC_CTL_ConMode10	(1<<5)	/* Force 10 mbps endec */
#define MAC_CTL_ConModeMII	(2<<5)	/* Force MII rate determined by clock */
#define MAC_CTL_Loop10	0x00000080	/* if set assert loop10 external signal */
#define MAC_CTL_LnkChg	0x00000100	/* write to clear interrupt */
/* NOT USED				0x00000200	*/
#define MAC_CTL_MissRoll 0x00000400	/* Missed Error counter roll over */
/* NOT USED				0x00000800	*/
/* NOT USED				0x00001000	*/
#define MAC_CTL_EnMissRoll	0x00002000 /* interrupt when counter rolls over */
/* NOT USED				0x00004000	*/
#define MAC_CTL_Link10	0x00008000	/* Link Status -- Read Only */

/*
 * Bit Definitions for ARC_CTL      0x44
 */
#define ARC_StationAcc  0x00000001  /* Accept Unicast Pkt */
#define ARC_GroupAcc    0x00000002  /* Accept Multicast Group Pkts */
#define ARC_BroadAcc    0x00000004  /* Accept Broadcast Pkts */
#define ARC_NegARC      0x00000008  /* Negaive ARC == 1 (reject recog pkts */
#define ARC_CompEn      0x00000010  /* Enable Compare Mode */

/*
 * Definitions for TX_CTL Register (0x48)
 */
#define TX_CTL_TxEn		0x00000001	/* Transmit Enable */
#define TX_CTL_TxHalt	0x00000002	/* Halt after completing current Pkt */
#define TX_CTL_NoPad	0x00000004	/* do not generate pad bytes (pkt < 64) */
#define TX_CTL_NoCRC	0x00000008	/* Suppress sending CRC */
#define TX_CTL_FBack	0x00000010	/* Use Fast Back Off (testing only) */
#define TX_CTL_NoExDef	0x00000020	/* Suppress Checking Excess Defers */
#define TX_CTL_SdPause	0x00000040	/* Send Pause or other MAC Command */
#define TX_CTL_MII10	0x00000080	/* If MII_Conn is high - 10 mbps */
#define TX_CTL_EnUnder	0x00000100	/* Interrupt if MAC underrun */
#define TX_CTL_EnExDefer 0x00000200 /* interrupt excessive defers */
#define TX_CTL_EnLCarr	0x00000400	/* interrupt on lost carrier */
#define TX_CTL_EnExCol	0x00000800	/* interrupt on excessive collisions */
#define TX_CTL_EnLateColl 0x00001000 /* interrupt if collision after 512 bits */
#define TX_CTL_EnTxPar	0x00002000	/* Enable Transmit Parity */
#define TX_CTL_EnComp	0x00004000	/* Enable Transmit Interrupt  */


/*
 * Definitions for Transmit Status (Tx_Stat 0x4C) Register
 */
/********************************************
 *	Transmit Status (Tx_Stat 0x4C) Register
 *		Ethernet MAC... Page 4-33
 ********************************************/
#define TX_STAT_Comp	0x00004000	/* Transmit Status Register
					   - Indicates Pkt transmitted
					   OR discarded */
#define TX_COLL_CNT_MSK	0x0000000F		/* tx collision count */
#define TX_EX_COLL		0x00000010	/* excessive collisions */
#define TX_DEFER		0x00000020	/* Tx deferred */
#define	TX_PAUSED		0x00000040	/* Transmitter paused */
#define TX_INT			0x00000080	/* Set if tx of packets caused interrupt */
#define TX_UNDER		0x00000100	/* Mac tx FIFO became empty */
#define	TX_EXDEFER		0x00000200	/* Excessive deferral */
#define	TX_LOST_CARRIER	0X00000400		/* Lost carrier */
#define TX_TX10STAT		0X00000800	/* if last tx was in 10 MBs */
#define TX_LATE_COLL	0X00001000		/* Late Collision */
#define TX_PARITY		0x00002000	/* FIFO parity error */
#define TX_HALTED		0x00008000	/* transmission halted txEn or TxHalt */
#define TX_SQERR		0x00010000	/* signal quality error */
#define TX_MCAST		0x00020000	/* Sent MultiCast Packet */
#define TX_BCAST		0x00040000	/* Sent BroadCast Packet */
#define TX_VLAN			0x00080000	/* Sent VLAN tagged Packet */
#define TX_MACC			0x00100000	/* Sent a MAC control Packet */
#define TX_PAUSE		0x00200000	/* Sent a MAC Control PAUSE Packet */
#define TX_HNR			0x00400000	/* Sent Host Not Responding before this
						   Packet */
#define TX_STAT_ANYERROR	(TX_EX_COLL|TX_PAUSED|		\
				 TX_UNDER|TX_EXDEFER|			\
				 TX_LATE_COLL|TX_PARITY|TX_HALTED|	\
				 TX_SQERR)

/*
 *	Receive Status (Rx_Stat 0x54) Register. Ethernet MAC... Page 4-33
 */
#define RCVD_LEN_ERR	0x00000010	/* Error Pkt Received.*/
#define RCVD_CTL_FRM	0x00000020	/* Control Frame Received .*/
#define RCVD_INTRX  	0x00000040	/* Reception caused Interrupt. */
#define RCVD_Rx10Stat	0x00000080	/* == 1 Pkt Rec via 10 mbps	*/

#define RCVD_ALIGN_ERR	0x00000100	/* Error Pkt Received.*/
#define RCVD_CRC_ERR	0x00000200	/* Error Pkt Received.*/
#define RCVD_OVRFLW_ERR	0x00000400	/* Error Pkt Received.*/
#define RCVD_LONG_ERR	0x00000800	/* Error Pkt Received.*/

/*      NOT_USED		0x00001000	*/
#define RCVD_PAR_ERR	0x00002000	/* Error Pkt Received.*/
#define RCVD_GOOD_PKT	0x00004000	/* Good  Pkt Received with no error.*/
#define RCVD_RxHalted	0x00008000	/* Rx Halted */

/*      NOT_USED		0x00010000	*/
#define RCVD_RxMCast	0x00020000	/* Pkt Received.*/
#define RCVD_RxBCast	0x00040000	/* Pkt Received.*/
#define RCVD_RxVlan		0x00080000	/* Pkt Received.*/

#define RCVD_RxPause	0x00100000	/* Pkt Received.*/


/*
 *	MD_CA Register (0x5c)
 */
/*  Addr                     bits 0 to 4   */
/*  Phy Address              bits 5 to 9   */
#define MD_CA_PhyShift	(5)
#define MD_CA_Wr		0x0400	/* Set to Write - clear for read */
#define MD_CA_BUSY_BIT 	0x0800
#define MD_CA_PreSup	0x1000	/* Suppress Preamble sent to Phy */
#define MD_MAX_PHY	32	/* maximum number of PHY per MII */
#define MD_NO_PHY	254	/* No PHY exists - case for a switch */
#define MD_DYNAMIC_PHY	255	/* software indication dynamically find phy */

/*
 * MAC_BRCTRL_REG (0xd4)
 */
#define RMII_Reset	0x04	/* RMII Reset */
#define RMII_10MBIT	0x02	/* 1 if 10 Mbs, 0 if 100 Mbs */
#define TxDClockRising	0x01	/* 0 if TxD generated off falling edge,
				 * 1 if generated off rising edge of Tx-CLK */

#define MSP_TRACE(x, y)			printk(KERN_INFO y)

#if 0
#define MSP_ETH_DEBUG
#endif

#ifdef MSP_ETH_DEBUG
#define	PRINTF(x)			printk (KERN_INFO x)
#else
#define	PRINTF(x)
#endif

#define MSPEthExtent	0xe0		/* size of register space */

/** PORTING REQUIRED **/

#define MSP_MAKE_UNCACHED(x)	((unsigned long) x | 0xa0000000)

/** END OF PORTING **/


#define MSPEth_100MBS		100000000		/* bits per sec	*/
#define MSPEth_10MBS	 	 10000000		/* bits per sec	*/

#define MAX_PKT_SIZE		1532
#define MSP_END_PREPEND		224
#define MAX_ETH_BUFFER_SIZE	(MAX_PKT_SIZE + MSP_END_PREPEND)
#define MSP_END_BUFSIZE		(MAX_ETH_BUFFER_SIZE + 24)

#define MSP_ETH_MAX_UNITS	(9)

#define VLAN_TAG_PROTOCOL_TYPE	(0x8100)

#ifdef MSP_TAKE_TX_INTERRUPTS
#define ETH_TX_BD_COUNT		1	/* MUST NOT EXCEED 256 */
#else
#define ETH_TX_BD_COUNT_SPAD	40	/* MUST NOT EXCEED 256 */
#define ETH_TX_BD_COUNT		150	/* MUST NOT EXCEED 256 */
#endif

#define ETH_RX_BD_COUNT_SPAD	40	/* MUST NOT EXCEED 256 */
#define ETH_RX_BD_COUNT		150	/* MUST NOT EXCEED 256 */

#define ETH_RX_RCV_SHIFT	2	/* right shift to compute times
					 * through receive loop
					 */

#if (ETH_RX_BD_COUNT > 256)
#error "Code relies on rx bd count less than 256"
#endif

#define MAX_ARC_ENTRIES		21 /* Address Recognition Circuit;
				      supported by the hardware */
#define MAC_ADDR_LEN		6

/*
 * The hardware supports only upto 28 BDs.
 * CAUTION: DO NOT CHANGE THIS VALUE !!
 */
#define HARDWARE_MAX_BD		28	/* CAUTION: DO NOT CHANGE THIS VALUE !! */

/*
 * The packet is contiguous within the struct sk_buff.
 * We need only 1 BD per frame, but MAX_BD_PER_FRAME must be a multiple of 2.
 */
#define MAX_BD_PER_FRAME	2	/* For scatter gather mechanism, several buffers could make up a packet. Keep it as even number to make the FDBD at 16byte boundry */
#if (MAX_BD_PER_FRAME > HARDWARE_MAX_BD)
#error "HARDWARE_MAX_BD can't be greater than what hardware can support !!!"
#endif

#define BD_PER_TX_FRAME		1	/* Number of BDs in the Transmit Queue per frame. */


/*
 * Frame Descriptor, Buffer Descriptor related parameters.
 */
#define MAC_OWNS_FD		0x8000		/* Controller (MAC) owns the Frame Descriptor.*/
#define MAC_OWNS_BD		0x80		/* Controller (MAC) owns the Buffer Descriptor.*/

#define SW_OWNS_FD		0x0000		/* Software owns the Frame Descriptor.*/
#define SW_OWNS_BD		0x00		/* Software owns the Buffer Descriptor.*/

#define FDCTL_TX_INT		(1<<13)		/* interrupt on tx complete */
#define FDCTL_BD_COUNT_MASK	0x001F		/* Bit 0-4 of the FDCtl field of the FD represents # of BDs */

/*
 * Duplex Mode for MAC
 */
#define MAC_DPX_MODE_AUTO    0
#define MAC_DPX_MODE_HALF    1
#define MAC_DPX_MODE_FULL    2

#define  TX_COL_FRM0	0x00
#define  TX_COL_FRM1	0x01
#define  TX_COL_FRM2	0x02
#define  TX_COL_FRM3	0x03
#define  TX_COL_FRM4	0x04
#define  TX_COL_FRM5	0x05
#define  TX_COL_FRM6	0x06
#define  TX_COL_FRM7	0x07
#define  TX_COL_FRM8	0x08
#define  TX_COL_FRM9	0x09
#define  TX_COL_FRM10	0x0a
#define  TX_COL_FRM11	0x0b
#define  TX_COL_FRM12	0x0c
#define  TX_COL_FRM13	0x0d
#define  TX_COL_FRM14	0x0e
#define  TX_COL_FRM15	0x0f
#define  TX_COL_FRM16	0x10

#define  TX_DEFRD_TX	0x11
#define  TX_LATE_COL	0x12
#define  TX_FRMS_LST	0x13
#define  TX_CAR_ERR		0x14
#define  TX_EXCES_DEF	0x15
#define  TX_UNI_CAST	0x16
#define  TX_MUL_CAST	0x17
#define  TX_BRD_CAST	0x18
#define  TX_SQE_ERR		0x19
#define  TX_PAUSE_FRM	0x1A
#define  TX_MAC_CTL_FR	0x1B
#define  TX_VLAND_FRM	0x1C
#define  TX_OCTETS_OK	0x1D
#define  TX_OCT_OK_HI	0x1E

#define  RX_PKT_SIZE0	0x20
#define  RX_PKT_SIZE1	0x21
#define  RX_PKT_SIZE2	0x22
#define  RX_PKT_SIZE3	0x23
#define  RX_PKT_SIZE4	0x24
#define  RX_PKT_SIZE5	0x25
#define  RX_PKT_SIZE6	0x26
#define  RX_PKT_SIZE7	0x27
#define  RX_FCS_EROR	0x28
#define  RX_ALIG_EROR	0x29
#define  RX_FRAGMENTS	0x2A
#define  RX_JABBERS		0x2B
#define  RX_FRMS_LOST	0x2C
#define  RX_UCAST		0x2D
#define  RX_MCAST		0x2E
#define  RX_BCAST		0x2F

#define  RX_INRANG_ERR	0x30
#define  RX_OUTRANG_ERR	0x31
#define  RX_VLAN_FRM	0x32
#define  RX_PAUSE_MCTL	0x33
#define  RX_MAC_CTL		0x34
#define  RX_OCTETS		0x35
#define  RX_OCTETS_HI	0x36
#define  RX_OCTET_OTHER	0x37
#define  RX_OCT_OTH_HI	0x38

#define EADDR_LEN	6		/* ethernet address length	*/
#define MSP_ADDR_LEN	EADDR_LEN	/* ethernet address length	*/
#define EH_SIZE		14 		/* avoid structure padding issues */
#define END_BUFSIZ	(ETHERMTU + 14 + 6)
#define EL_MIN_FBUF	4 		/* Minsize of 1st buffer in chain */
#define N_MCAST				12
#define ETHERNET_CRC_SIZE	4


/* Enable Rx Interrupt for Good Packet and LenErr packet
 * EnLenErr is a bit that is NOT defined in the manual but was added
 * It indicates the reception of a frame whose protocol id field value
 * does not match a length.  This interrupt allows us the process IP
 * and other packets whose protocol id field is not treated as a length
 */
#define ENA_RX_INT	(RX_CTL_EnGood | RX_CTL_EnLenErr | RX_CTL_EnCRCErr)
#define RCVD_OK_PKT	(RCVD_GOOD_PKT | RCVD_LEN_ERR)

/*
 *  Interrupt Source Register (0x24).
 */
/* interrupt indicates that we need a reload of driver */
#define INTR_REQ_RELOAD (INTR_IntNRAbt | INTR_NRAbt)

/* used in the ISR, to check for any FDA, BL exhausted, etc. */
#define INTR_OTHER      ~(INTR_Rx | INTR_REQ_RELOAD | INTR_IntBLEx | \
				INTR_BLEx | INTR_IntFDAEx | INTR_FDAEx)

/* Define Ethernet PHY Types */
#define PHY_GENERIC				"PHY_GENERIC"
#define PHY_INTEL971a			"PHY_INTEL971a"
#define PHY_KENDIN_8721			"PHY_KENDIN_8721"
#define PHY_KENDINSWITCH		"PHY_KENDINSWITCH"
#define PHY_NONE				"PHY_NONE"


#endif /* mspEthDef.h*/

#ifndef __mspEthStructH__
#define __mspEthStructH__

/*
 * For the MAC Mode Type.
 */
typedef enum _eth_mode
{
	ETH_AUTO		=1,
	ETH_10Mbps_HALF		=2,
	ETH_10Mbps_FULL		=3,
	ETH_100Mbps_HALF	=4,
	ETH_100Mbps_FULL	=5
} ETH_MODE;



typedef enum
{
	PHYTYPE_GENERIC         = 1,
	PHYTYPE_INTEL971a       = 2,
	PHYTYPE_KENDINSWITCH    = 3,
	PHYTYPE_KENDIN_8721     = 4,
	PHYTYPE_NONE            = 5
} PHY_TYPE;

/*
 * The ARC Table could contain maximum of 20 MAC Addresses.
 */
typedef struct _SW_MSP_ARC_TABLE
{
	BOOL	inUseFlag;
	UCHAR	macAddr[6];
	U16		swEntryNumber;
} MSP_ARC_SW_TABLE;


/*
 * Frame Descriptors for Ethernet MAC
 */
typedef struct _FD
{
	volatile struct _FD	* FDNext;
	volatile UINT32		FDSystem;
	volatile UINT32		FDStat;
	volatile UINT16		FDCtl;
	volatile UINT16		FDLength;
} FD;


/*
 * Buffer Descriptor for Ethernet MAC
 */
typedef struct _BD
{
	volatile UINT8		* BuffData;
	volatile UINT8		BDCtl;
	volatile UINT8		BDStat;
	volatile UINT16		BuffLength;
} BD;

/*
 * Structure of FD and BDs to be used Tx and FDA of Rx.
 */
typedef struct _FDBD
{
	FD		FD;
	BD		BD[MAX_BD_PER_FRAME];
} FDBD;

/*
 * Structure of FD and BDs to be used Tx and FDA of Rx.
 */
typedef struct
{
	FD		FD;
	BD		BD;
} FDBDRX;


/*
 * Structure of FD and BDs to be used in the BL Area for the Rx.
 */
typedef struct _BL_FDBDS
{
	FD		FD;
	BD		BD[1];
} BLFDBD;

/*
 * Driver Control Structure
 */
typedef struct eth_drv_ctrl
{
	struct	net_device	*netdevice;

	UINT8		unit;		/* logical unit number		*/
	INT8		reloadflag;	/* non-zero if should reload	*/
	struct tq_struct    rx_bh ;	/* bottom half task		*/
	struct tq_struct    reload_tq;	/* task to reload interface	*/
	int		bh_recovery;	/* non-zero if doing recovery	*/
	MAC_BASE	*mac_base;	/* MAC Base Register 		*/

	/* Tx control lock.  This protects the transmit buffer ring
	 * state along with the "tx full" state of the driver.  This
	 * means all netif_queue flow control actions are protected
	 * by this lock as well.
	 */
	spinlock_t	lock;

	BLFDBD		*BLFrmPtr;
	FDBD		*FDAPtrCur;
	struct sk_buff	**rskbp;
	int		rxBdCount;	/* Number of BDs in BL.		*/

	FDBD		*TxFrmPtrCur;
	FDBD		*TxFrmPtrFreeBuf;

	struct net_device_stats	stats;		// keep statistics

	unsigned long	tx_packets;	/* tx packet last reloadcheck time */
	unsigned long	tx_errors;	/* tx errors last reloadccheck time */
	unsigned long	carrier_off;	/* time carrier off */
	struct PHY_BASE	*phy_base;	/* PHY Base Register 		*/
	U32		macPhyId;	/* Mac Phy Number SHIFTED 	*/
	U32		rst_base;	/* MAC Reset Base 		*/

	PHY_TYPE	phyType;	/* Model of the connected PHY 	*/
	int		phyAutoNegot;	/* non-zero if phy auto negot	*/
	int		phyWaiting;	/* delay for phy negotiation	*/

	ETH_MODE	ethMode;	/* Config setting from bootline */
	U32		enetType;	/* MII/RMII indication		*/
	U32		enetTxD;	/* TxD rising/falling/not avail */

	int		txBdCount;	/* Number of BDs in TXQ		*/
	U32		duplexMode;	/* Duplex Mode 			*/
	U32		speed;		/* link Speed 			*/

	UINT8		*BLFrmPtr_Orig;
	UINT8		*FDAPtr_Orig;
	FDBD		*FDAPtr;

	UINT8		*TxFrmPtr_Orig;
	FDBD		*TxFrmPtr;

} MSP_DEVICE;


#endif /* mspEthStruct.h */

#ifndef __mspEthProtoH__
#define __mspEthProtoH__

U32 MSPPHY971CheckCable(MSP_DEVICE *pDrvCtrl);

void MSPSetupPHY971(MSP_DEVICE *pDrvCtrl, U32 speed);

#define ReadMacRegister(pDrvCtrl,reg)		(pDrvCtrl->mac_base->reg)

#define WriteMacRegister(pDrvCtrl,reg,value) (pDrvCtrl->mac_base->reg=(value))

inline static void MSPEthEnableRx(MSP_DEVICE *pDrvCtrl)
{
	WriteMacRegister(pDrvCtrl, RX_CTL,
		((ReadMacRegister(pDrvCtrl, RX_CTL)) | RX_CTL_RxEn)); /* Enable Rx */
}

inline static void MSPEthDisableRx(MSP_DEVICE *pDrvCtrl)
{
	WriteMacRegister(pDrvCtrl, RX_CTL,
		((ReadMacRegister(pDrvCtrl, RX_CTL)) & ~RX_CTL_RxEn)); /* Stop Rx */
}


inline static void MSPEthFdaFullIntEnable(MSP_DEVICE *pDrvCtrl)
{
	WriteMacRegister(pDrvCtrl, INT_EN,
		((ReadMacRegister(pDrvCtrl, INT_EN)) | INT_EN_FDAExEn));
}

inline static void MSPEthFdaFullIntDisable(MSP_DEVICE *pDrvCtrl)
{
	WriteMacRegister(pDrvCtrl, INT_EN,
		(ReadMacRegister(pDrvCtrl, INT_EN)) & (~INT_EN_FDAExEn));
}


inline static void MSPEthBlFullIntEnable(MSP_DEVICE *pDrvCtrl)
{
	WriteMacRegister(pDrvCtrl, INT_EN,
		((ReadMacRegister(pDrvCtrl, INT_EN)) | INT_EN_BLExEn));
}

inline static void MSPEthBlFullIntDisable(MSP_DEVICE *pDrvCtrl)
{
	WriteMacRegister(pDrvCtrl, INT_EN,
		((ReadMacRegister(pDrvCtrl, INT_EN)) & (~INT_EN_BLExEn)));
}

inline static void MSPEthAckRxInt(MSP_DEVICE *pDrvCtrl)
{
	WriteMacRegister(pDrvCtrl, INT_SRC, INTR_Rx);
}

inline static void MSPEthRxIntDisable(MSP_DEVICE *pDrvCtrl)
{
	WriteMacRegister(pDrvCtrl, RX_CTL,
		((ReadMacRegister(pDrvCtrl, RX_CTL)) & (~ENA_RX_INT)));
}

inline static void MSPEthRxIntEnable(MSP_DEVICE *pDrvCtrl)
{
	WriteMacRegister(pDrvCtrl, RX_CTL,
		((ReadMacRegister(pDrvCtrl, RX_CTL))| ENA_RX_INT));
}

inline static void MSPEthAckTxInt(MSP_DEVICE *pDrvCtrl)
{
	WriteMacRegister(pDrvCtrl, INT_SRC, INTR_Tx);
}

inline static void MSPEthTxIntEnable(MSP_DEVICE *pDrvCtrl)
{
	WriteMacRegister(pDrvCtrl, TX_CTL,
		((ReadMacRegister(pDrvCtrl, TX_CTL))| TX_CTL_EnComp));
}

inline static void MSPEthTxIntDisable(MSP_DEVICE *pDrvCtrl)
{
	WriteMacRegister(pDrvCtrl, TX_CTL,
		((ReadMacRegister(pDrvCtrl, TX_CTL)) & (~TX_CTL_EnComp)));
}

inline static void MSPEthTxWakeUp(MSP_DEVICE *pDrvCtrl)
{
    WriteMacRegister(pDrvCtrl, DMA_CTL,
        ((ReadMacRegister(pDrvCtrl, DMA_CTL)) | DMA_CTL_TxWakeUp));
}

inline static void MSPEthAckFdaFullInt(MSP_DEVICE *pDrvCtrl)
{
	WriteMacRegister(pDrvCtrl, INT_SRC, INTR_FDAEx);
}

inline static void MSPEthAckBlFullInt(MSP_DEVICE *pDrvCtrl)
{
	WriteMacRegister(pDrvCtrl, INT_SRC, INTR_BLEx);
}

inline static void MSPEthAckNRAInt(MSP_DEVICE *pDrvCtrl)
{
	WriteMacRegister(pDrvCtrl, INT_SRC, ~INTR_PCI);
}


inline static void MSPEthAckEarlyNotInt(MSP_DEVICE *pDrvCtrl)
{
	WriteMacRegister(pDrvCtrl, INT_SRC, INTR_EARLY_NOT);
}

inline static void MSPEthEarlyNotIntDisable(MSP_DEVICE *pDrvCtrl)
{
	WriteMacRegister(pDrvCtrl, INT_EN,
		((ReadMacRegister(pDrvCtrl, INT_EN)) & ~(INT_EN_EarNotEn)));
}

inline static void MspEthEarlyNotIntEnable(MSP_DEVICE *pDrvCtrl)
{
	WriteMacRegister(pDrvCtrl, INT_EN,
		((ReadMacRegister(pDrvCtrl, INT_EN)) | INT_EN_EarNotEn));
}

/*************************************************************************
 *
 * Function Name:       MSPEthIntEnable
 *
 * Purpose:             To enable the interrupt of the specifed Ethernet.
 *
 *                      CAUTION: Int_Ena Register Bit 6: RESERVED
 *                      NOT TO BE USED !!
 *
 **************************************************************************/
inline static void MSPEthIntEnable(MSP_DEVICE *pDrvCtrl)
{
    spin_lock(&pDrvCtrl->lock);

    MSPEthRxIntEnable(pDrvCtrl);

    WriteMacRegister(pDrvCtrl, INT_EN,
        (   INT_EN_NRAbtEn   | INT_EN_DmParErrEn | INT_EN_DParDEn
        |   INT_EN_SSysErrEn | INT_EN_RMasAbtEn  | INT_EN_RTargAbtEn
        |   INT_EN_STargAbtEn| INT_EN_FDAExEn    | INT_EN_BLExEn) );

    spin_unlock(&pDrvCtrl->lock);
}

inline static void MSPEthAckOtherInt(MSP_DEVICE *pDrvCtrl, U32 interruptToAck)
{
	WriteMacRegister(pDrvCtrl, INT_SRC, interruptToAck);

}

inline static void MSPEthAckAllInt(MSP_DEVICE *pDrvCtrl)
{
	WriteMacRegister(pDrvCtrl, INT_SRC, ~INTR_PCI);
}


inline static U32 MSPEthReadIntSrcReg(MSP_DEVICE *pDrvCtrl)
{
	return(ReadMacRegister(pDrvCtrl, INT_SRC));
}

inline static void MSPEthEnableTxRx(MSP_DEVICE *pDrvCtrl)
{
    WriteMacRegister(pDrvCtrl, TX_CTL,
        ((ReadMacRegister(pDrvCtrl, TX_CTL)) | TX_CTL_TxEn)); /* Enable Tx */

    WriteMacRegister(pDrvCtrl, RX_CTL,
        ((ReadMacRegister(pDrvCtrl, RX_CTL)) | RX_CTL_RxEn)); /* Enable Rx */
}

inline static void MSPEthEnablePromiscMode(MSP_DEVICE *pDrvCtrl)
{
    /* setting to promiscuous mode*/
    WriteMacRegister(pDrvCtrl, ARC_CTL, ARC_NegARC);
}

inline static void MSPEthDisablePromiscMode(MSP_DEVICE *pDrvCtrl)
{

    /*
     *
     *  ARC_Ctl Register
     *  15       5  4     3     2    1     0
     *  +--------+-----+-----+-----+-----+----+
     *  | Rsvd   |Comp | NEG |BCST | Grp |Ucst|
     *  +--------+-----+-----+-----+-----+----+
     *      xx      1     0     1     0     0
     *
     *  - StationAcc (Any unicast): Disabled - 0
     *  - GroupAcc (Any multicast): Enabled - 1
     *  - BroadAcc (Broad Cast):    Enabled  - 1
     *  - NegARC (Negative ARC):    Disabled - 0 accept pkt ARC recognizes
     *  - CompEn (Compare Enable):  Enabled  - 1
     *
     */

    WriteMacRegister(pDrvCtrl, ARC_CTL,
		(ARC_CompEn|ARC_BroadAcc| ARC_GroupAcc));
}

inline static void MSPEthEnableRxHalt(MSP_DEVICE *pDrvCtrl)
{
    WriteMacRegister(pDrvCtrl, RX_CTL,
        ((ReadMacRegister(pDrvCtrl, RX_CTL)) | RX_CTL_RxHalt));
}

inline static void MSPEthDisableRxHalt(MSP_DEVICE *pDrvCtrl)
{
    WriteMacRegister(pDrvCtrl, RX_CTL,
        ((ReadMacRegister(pDrvCtrl, RX_CTL)) & ~RX_CTL_RxHalt));
}

inline static void MSPEthEnableTxHalt(MSP_DEVICE *pDrvCtrl)
{
    WriteMacRegister(pDrvCtrl, TX_CTL,
        ((ReadMacRegister(pDrvCtrl, TX_CTL)) | TX_CTL_TxHalt));
}

inline static void MSPEthDisableTxHalt(MSP_DEVICE *pDrvCtrl)
{
    WriteMacRegister(pDrvCtrl, TX_CTL,
        ((ReadMacRegister(pDrvCtrl, TX_CTL)) & ~TX_CTL_TxHalt));
}

inline static void MSPEthDisableTxRxHalt(MSP_DEVICE *pDrvCtrl)
{
    MSPEthDisableTxHalt(pDrvCtrl);
    MSPEthDisableRxHalt(pDrvCtrl);
}


inline static void MSPEthIntDisable(MSP_DEVICE *pDrvCtrl)
{
    spin_lock(&pDrvCtrl->lock);

        MSPEthRxIntDisable(pDrvCtrl);
        MSPEthTxIntDisable(pDrvCtrl);
        WriteMacRegister(pDrvCtrl, INT_EN, 0x00000000);

    spin_unlock(&pDrvCtrl->lock);
}

inline static void MSPEthReset(MSP_DEVICE *pDrvCtrl)
{
	int	i;

	*(volatile U32 *)(RST_SET_REG) = pDrvCtrl->rst_base;
	*(volatile U32 *)(RST_CLR_REG) = pDrvCtrl->rst_base;

        /* wait for chip to come out of reset */
        for (i = 0; i < 10; i++)
        {
                if ((*(volatile U32 *)(SYS_RST_REG) & pDrvCtrl->rst_base) == 0)
                        break;

                NanoDelay (100);
        }
}

inline static void MacSetUpTxFrmPtrRegister(MSP_DEVICE *pDrvCtrl, U32 Frame)
{
    WriteMacRegister(pDrvCtrl, TXFRMPTR, Frame);
}


/**********************************************************************
 * Function Name:   MSPEthTxPollCtrStop
 *
 *   Purpose:       Stops Transmit polling.
 *
 ***********************************************************************/
inline static void MSPEthTxPollCtrStop(MSP_DEVICE *pDrvCtrl)
{
    WriteMacRegister(pDrvCtrl, TXPOLLCTR, 0);
}



/**********************************************************************
 * Function Name:   MSPEthTxPollCtrStop
 *
 *   Purpose:       Start Transmit polling.
 *
 ***********************************************************************/
inline static void MSPEthTxPollCtrStart(MSP_DEVICE *pDrvCtrl)
{
    WriteMacRegister(pDrvCtrl, TXPOLLCTR, 0x00000080);
}


/*************************************************************************
 *
 * Function Name:		MSPEthEnableVLAN
 *
 * Purpose:				To enable the VLAN functionalities, so that MAC
 *						could handle packets as long as 1522 bytes(instead of 1518 bytes).
 *
 **************************************************************************/
inline static void MSPEthEnableVLAN(MSP_DEVICE *pDrvCtrl)
{
	WriteMacRegister(pDrvCtrl, RX_CTL,
		((ReadMacRegister(pDrvCtrl, RX_CTL)) | RX_CTL_LongEn) );
}


/************************************************************************
 *
 * Function Name:		MSPEthDisableVLAN
 *
 * Purpose:				To disable the VLAN functionalities of the MAC.
 *
 **************************************************************************/
inline static void MSPEthDisableVLAN(MSP_DEVICE *pDrvCtrl)
{
	WriteMacRegister(pDrvCtrl, RX_CTL,
		((ReadMacRegister(pDrvCtrl, RX_CTL)) & (~RX_CTL_LongEn)) );
}

/************************************************************************
 *
 * Function Name:		MSPEthMACIntDisable
 *
 * Purpose:				Disable Interrupt Signals
 *
 **************************************************************************/
inline static void MSPEthMACIntDisable(MSP_DEVICE *pDrvCtrl)
{
    WriteMacRegister(pDrvCtrl, DMA_CTL,
        ((ReadMacRegister(pDrvCtrl, DMA_CTL)) | DMA_CTL_IntMask));
}

/************************************************************************
 *
 * Function Name:		MSPEthMACIntEnable
 *
 * Purpose:				Enable Interrupt Signals
 *
 **************************************************************************/
inline static void MSPEthMACIntEnable(MSP_DEVICE *pDrvCtrl)
{
    WriteMacRegister(pDrvCtrl, DMA_CTL,
        ((ReadMacRegister(pDrvCtrl, DMA_CTL)) & (~DMA_CTL_IntMask)));
}

/************************************************************************
 *
 * Function Name:		MSPEthRMIIEnable10Mbit
 *
 * Purpose:				Enable 10 Mbit for RMII
 *
 **************************************************************************/
inline static void MSPEthRMIIEnable10Mbit(MSP_DEVICE *pDrvCtrl)
{
	WriteMacRegister(pDrvCtrl, MAC_BRCTRL_REG,
			 ((ReadMacRegister(pDrvCtrl, MAC_BRCTRL_REG)) |
			  (RMII_10MBIT)));
}

/************************************************************************
 *
 * Function Name:		MSPEthRMIIEnable100Mbit
 *
 * Purpose:				Enable 100 Mbit for RMII
 *
 **************************************************************************/
inline static void MSPEthRMIIEnable100Mbit(MSP_DEVICE *pDrvCtrl)
{
	WriteMacRegister(pDrvCtrl, MAC_BRCTRL_REG,
			 ((ReadMacRegister(pDrvCtrl, MAC_BRCTRL_REG)) &
			  (~RMII_10MBIT)));
}

/************************************************************************
 *
 * Function Name:		MSPEthRMIITxDRisingEdge
 *
 * Purpose:				Set TxD Rising Edge
 *
 **************************************************************************/
inline static void MSPEthRMIITxDRisingEdge(MSP_DEVICE *pDrvCtrl)
{
	WriteMacRegister(pDrvCtrl, MAC_BRCTRL_REG,
			 ((ReadMacRegister(pDrvCtrl, MAC_BRCTRL_REG)) |
			  (TxDClockRising)));
}

/************************************************************************
 *
 * Function Name:		MSPEthRMIITxDFallingEdge
 *
 * Purpose:				Set TxD Falling Edge
 *
 **************************************************************************/
inline static void MSPEthRMIITxDFallingEdge(MSP_DEVICE *pDrvCtrl)
{
	WriteMacRegister(pDrvCtrl, MAC_BRCTRL_REG,
			 ((ReadMacRegister(pDrvCtrl, MAC_BRCTRL_REG)) &
			  (~TxDClockRising)));
}

/************************************************************************
 * Function Name:	FlushCache
 *
 * Purpose:	Ensure no outstanding writes
 *		- we are using write through - just issue SYNC and read mem
 ***********************************************************************/
inline static void FlushCache(void)
{
  UINT32 volatile flushToSDRAM;
  __asm__ __volatile__("			\
                .set push;			\
                .set mips3;			\
                sync;				\
                .set pop;");
  // the next read or write operation guarentees the flush
  // I have to write the KSEG1 area to pass the buffer to the
  // MAC - I am assuming that this will force the cache flush.
  //  FIXME - check the assumption uncache r/w will complete SYNC
  flushToSDRAM = * (MEM_CNFG1_REG);
}

/************************************************************************
 * Function Name:	pref
 *
 * Purpose:	prefetch to data cache
 * 		- prefetch data to help improve performance
/ ***********************************************************************/
#define pref(base, offset)			\
	__asm__ __volatile__("			\
		.set push;			\
		.set mips32;			\
		pref 0, %1(%0);			\
		.set pop;"			\
		:				\
		: "r" (base),			\
		  "i" (offset));

/************************************************************************
 * Function Name:	InvalidateBuffer
 *
 * Purpose:	Invalidate buffer cache
 * 		- must start on 16 byte boundary
 * 		- must "own" to next higher 16 byte boundary from end of buffer
/ ***********************************************************************/
inline static void
InvalidateBuffer( void * bufaddr, unsigned int length)
{
	unsigned long end = (unsigned long)bufaddr + length ;
	bufaddr = (void *) ((unsigned int) bufaddr & ~(L1_CACHE_BYTES - 1));

	while ( ((unsigned long) bufaddr + 0x200) < end)
	{
		cache16_unroll32(bufaddr, Hit_Invalidate_D);
		bufaddr += 0x200;
	}

	while ( (unsigned long) bufaddr < end )
	{
		invalidate_dcache_line( (UINT32) bufaddr );
		bufaddr += L1_CACHE_BYTES;
	}
}

/********************************************************************
 * Prototypes for external routines
 ********************************************************************/
extern void enable_brecis_irq( int int_num);
extern void disable_brecis_irq( int int_num);
extern inline void invalidate_dcache_line( unsigned long addr);
extern int get_ethernet_addr( char * ethaddr_name, char *ethernet_addr);

extern MSP_DEVICE	*gEthDrvCtrl[MSP_ETH_MAX_UNITS];

#endif  /* mspEthProto.h*/

