/* #define	M4_811d0860 */

/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 1995 - 2000 by Ralf Baechle
 * Copyright (C) 2000 Silicon Graphics, Inc.
 *
 * TODO:  Implement the compatibility syscalls.
 *        Don't waste that much memory for empty entries in the syscall
 *        table.
 */
#undef CONF_PRINT_SYSCALLS
#undef CONF_DEBUG_IRIX

#include <linux/config.h>
#include <linux/compiler.h>
#include <linux/linkage.h>
#include <linux/mm.h>
#include <linux/smp.h>
#include <linux/smp_lock.h>
#include <linux/mman.h>
#include <linux/sched.h>
#include <linux/file.h>
#include <linux/slab.h>
#include <linux/utsname.h>
#include <linux/unistd.h>
#include <asm/branch.h>
#include <asm/offset.h>
#include <asm/ptrace.h>
#include <asm/signal.h>
/* #include <asm/stackframe.h> */
/* #include <asm/shmparam.h> */
#include <asm/uaccess.h>

/* Specific file was loaded, M4DEBUG set in binfmt_elf.c */
#ifdef DEBUGSYSCALLS
  #ifdef M4_DEBUG
    extern int M4DEBUG;         /* in linux/fs/binfmt_elf.c */
    #define DBG_SYSCALL(a...)      {if (M4DEBUG != 0) {printk(a);}}
  #else                                 /* !M4_DEBUG */
    #define DBG_SYSCALL(a...)      printk(a)
/*     #define DBG_SYSCALL(a...)      printk(".") */
  #endif
#else
  #define DBG_SYSCALL(a...)
#endif

extern asmlinkage void syscall_trace(void);
typedef asmlinkage int (*syscall_t)(void *a0,...);
extern asmlinkage int (*do_syscalls)(struct pt_regs *regs, syscall_t fun,
				     int narg);

asmlinkage int sys_pipe(struct pt_regs regs)
{
	int fd[2];
	int error, res;

	error = do_pipe(fd);
	if (error) {
		res = error;
		goto out;
	}
	regs.regs[3] = fd[1];
	res = fd[0];
out:
	return res;
}

#if 0
#define COLOUR_ALIGN(addr,pgoff)		\
	((((addr)+SHMLBA-1)&~(SHMLBA-1)) +	\
	 (((pgoff)<<PAGE_SHIFT) & (SHMLBA-1)))

unsigned long arch_get_unmapped_area(struct file *filp, unsigned long addr,
	unsigned long len, unsigned long pgoff, unsigned long flags)
{
	struct vm_area_struct * vmm;
	int do_color_align;

	if (flags & MAP_FIXED) {
		/*
		 * We do not accept a shared mapping if it would violate
		 * cache aliasing constraints.
		 */
		if ((flags & MAP_SHARED) && (addr & (SHMLBA - 1)))
			return -EINVAL;
		return addr;
	}

	if (len > TASK_SIZE)
		return -ENOMEM;
	do_color_align = 0;
	if (filp || (flags & MAP_SHARED))
		do_color_align = 1;
	if (addr) {
		if (do_color_align)
			addr = COLOUR_ALIGN(addr, pgoff);
		else
			addr = PAGE_ALIGN(addr);
		vmm = find_vma(current->mm, addr);
		if (TASK_SIZE - len >= addr &&
		    (!vmm || addr + len <= vmm->vm_start))
			return addr;
	}
	addr = TASK_UNMAPPED_BASE;
	if (do_color_align)
		addr = COLOUR_ALIGN(addr, pgoff);
	else
		addr = PAGE_ALIGN(addr);

	for (vmm = find_vma(current->mm, addr); ; vmm = vmm->vm_next) {
		/* At this point:  (!vmm || addr < vmm->vm_end). */
		if (TASK_SIZE - len < addr)
			return -ENOMEM;
		if (!vmm || addr + len <= vmm->vm_start)
			return addr;
		addr = vmm->vm_end;
		if (do_color_align)
			addr = COLOUR_ALIGN(addr, pgoff);
	}
}
#endif	/* 0 */

/* common code for old and new mmaps */
static inline long
do_mmap2(unsigned long addr, unsigned long len, unsigned long prot,
        unsigned long flags, unsigned long fd, unsigned long pgoff)
{
	int error = -EBADF;
	struct file * file = NULL;

	flags &= ~(MAP_EXECUTABLE | MAP_DENYWRITE);
	if (!(flags & MAP_ANONYMOUS)) {
		file = fget(fd);
		if (!file)
			goto out;
	}

	down_write(&current->mm->mmap_sem);
	error = do_mmap_pgoff(file, addr, len, prot, flags, pgoff);
	up_write(&current->mm->mmap_sem);

	if (file)
		fput(file);
out:
	return error;
}

asmlinkage unsigned long old_mmap(unsigned long addr, size_t len, int prot,
                                  int flags, int fd, off_t offset)
{
	int result;

#if 0
	result = -EINVAL;
	if (offset & ~PAGE_MASK)
		goto out;
#endif	/* 0 */

	result = do_mmap2(addr, len, prot, flags, fd, offset >> PAGE_SHIFT);

#if 0
out:
#endif	/* 0 */
	return result;
}

asmlinkage long
sys_mmap2(unsigned long addr, unsigned long len, unsigned long prot,
          unsigned long flags, unsigned long fd, unsigned long pgoff)
{
	return do_mmap2(addr, len, prot, flags, fd, pgoff);
}

save_static_function(sys_fork);
static_unused int _sys_fork(struct pt_regs regs)
{
	int res;

	res = do_fork(SIGCHLD, regs.regs[29], &regs, 0);
	return res;
}

/*
 * sys_vfork is required for uClinux as fork is heavily reliant on an MMU.
 * Faisal Akber
 */
save_static_function(sys_vfork);
static_unused int _sys_vfork(struct pt_regs regs)
{
  int res;
  res = do_fork(CLONE_VFORK | CLONE_VM | SIGCHLD, regs.regs[29], &regs, 0);
  return res;
}

save_static_function(sys_clone);
static_unused int _sys_clone(struct pt_regs regs)
{
	unsigned long clone_flags;
	unsigned long newsp;
	int res;

	clone_flags = regs.regs[4];
	newsp = regs.regs[5];
	if (!newsp)
		newsp = regs.regs[29];
	res = do_fork(clone_flags, newsp, &regs, 0);
	return res;
}

/*
 * sys_execve() executes a new program.
 */
asmlinkage int sys_execve(struct pt_regs regs)
{
	int error;
	char * filename;

	filename = getname((char *) (long)regs.regs[4]);
	error = PTR_ERR(filename);
	if (IS_ERR(filename))
		goto out;
	error = do_execve(filename, (char **) (long)regs.regs[5],
	                  (char **) (long)regs.regs[6], &regs);
	putname(filename);

out:
	return error;
}

/*
 * Compacrapability ...
 */
asmlinkage int sys_uname(struct old_utsname * name)
{
	if (name && !copy_to_user(name, &system_utsname, sizeof (*name)))
		return 0;
	return -EFAULT;
}

/*
 * Compacrapability ...
 */
asmlinkage int sys_olduname(struct oldold_utsname * name)
{
	int error;

	if (!name)
		return -EFAULT;
	if (!access_ok(VERIFY_WRITE,name,sizeof(struct oldold_utsname)))
		return -EFAULT;

	error = __copy_to_user(&name->sysname,&system_utsname.sysname,__OLD_UTS_LEN);
	error -= __put_user(0,name->sysname+__OLD_UTS_LEN);
	error -= __copy_to_user(&name->nodename,&system_utsname.nodename,__OLD_UTS_LEN);
	error -= __put_user(0,name->nodename+__OLD_UTS_LEN);
	error -= __copy_to_user(&name->release,&system_utsname.release,__OLD_UTS_LEN);
	error -= __put_user(0,name->release+__OLD_UTS_LEN);
	error -= __copy_to_user(&name->version,&system_utsname.version,__OLD_UTS_LEN);
	error -= __put_user(0,name->version+__OLD_UTS_LEN);
	error -= __copy_to_user(&name->machine,&system_utsname.machine,__OLD_UTS_LEN);
	error = __put_user(0,name->machine+__OLD_UTS_LEN);
	error = error ? -EFAULT : 0;

	return error;
}

/*
 * If we ever come here the user sp is bad.  Zap the process right away.
 * Due to the bad stack signaling wouldn't work.
 * XXX kernel locking???
 */
asmlinkage void bad_stack(void)
{
	do_exit(SIGSEGV);
}

/*
 * Build the string table for the builtin "poor man's strace".
 */
#ifdef CONF_PRINT_SYSCALLS
#define SYS(fun, narg) #fun,
static char *sfnames[] = {
#include "syscalls.h"
};
#endif

#ifndef BRECIS
#if defined(CONFIG_BINFMT_IRIX) && defined(CONF_DEBUG_IRIX)
#define SYS(fun, narg) #fun,
static char *irix_sys_names[] = {
#include "irix5sys.h"
};
#endif
#endif	/* !BRECIS */

/* ------------------------------------------------------------------------ */
#ifdef CHECKSTACK
extern unsigned int *kernelsp;

/*
 * Check stack.
 */
asmlinkage void xxx_stack_check(unsigned int *sp)
{
	int tmp = 0;

/* printk("pid %d: kernelsp=%p, sp=%p\n", current->pid, kernelsp, sp); */
/* 	if (current->pid == 0 || (current->pid > 1 && current->pid < 7)) { */	/* do not check idle task */
/* 		return; */
/* 	} */
/* align 13 in head.S is 8024. */
	if (((unsigned int)(sp) & 0x80000000) != 0) {	/* if a kernel address */
	  if (sp <= kernelsp && (unsigned int)sp > (unsigned int)(kernelsp) - 8024) {
	    return;			/* if on kernel stack, extra room */
	  }
	  printk("ERROR, pid %d: Kernel Stack overflow? (%s)\n", current->pid, (char *)current->mm->arg_start);
	  printk("\tShould be: %p < sp(%p) < %p -- continuing\n", kernelsp, sp, (char *)(kernelsp) - 8024);
	  return;
	}
	if ((current->mm->start_stack != 0) && (unsigned int)sp > current->mm->start_stack) {
		printk("pid=%d: sp (%lx) > start_stack(%lx)\n", current->pid, (unsigned long)sp, current->mm->start_stack);
		goto errorlist;
	}
	tmp = (int)sp - (int)current->mm->brk;
	if ((current->mm->brk == 0 && current->pid == 1) || tmp >= 128) {		/* 128 byte "buffer range" */
		return;
	}
  errorlist:
	printk("ERROR, pid %d: Stack overflow (%s)\n", current->pid, (char *)current->mm->arg_start);
	printk("\tsp=%p mm->brk=%p mm->start_stack=%p  tmp=%d\n", sp, (void *)current->mm->brk, (void *)current->mm->start_stack, tmp);
	bad_stack();
}
#endif	/* CHECKSTACK */

/* ------------------------------------------------------------------------ */
#ifdef CHECKLOWMEMORYZERO
/*
 * Check low memory zero..
 */
asmlinkage void xxx_low_memory_zero(int inout)
{
	int *ptr;

	for (ptr = 0; ptr < (int *)(CHECKLOWMEMORYZERO*4); ptr++) {
		if (*ptr != 0) {
			printk("ERROR, %d - pid %d (%s): address (%p)!=0 (0x%x)???\n", inout, current->pid, current->comm, ptr, *ptr);
			*ptr = 0;		/* zero it, print only once. */
		}
	}

#ifdef	M4_811d0860
	{
		static unsigned int last_M4_811d0860_value = 0;
		unsigned int value;
		unsigned int saved;

		value =  *(unsigned int *)(0x811d0860);
		if (last_M4_811d0860_value != value) {
			saved = last_M4_811d0860_value;
			last_M4_811d0860_value = value;
			printk("ERROR?, 811d0860 %d - pid %d (%s): address 0x811d0860 (0x%x) != old (0x%x)\n", inout, current->pid, current->comm, value, saved);
			if (last_M4_811d0860_value == 0x74bd) {
			  *(unsigned int *)(0x811d0860) = 0xdeadbeef;
			  while (1) {
			    printk(".");
			  }
			}
		}
	}
#endif
}
#endif	/* CHECKLOWMEMORYZERO */

/* ------------------------------------------------------------------------ */
#ifdef DEBUGSYSCALLS	/* debug all syscalls */
extern void sys_sigsuspend(void);
extern void sys_rt_sigsuspend(void);
extern void sys_sigaction(void);
extern void sys_sigaltstack(void);
extern void sys_sigreturn(void);
extern void sys_rt_sigreturn(void);
extern void sys_ptrace(void);
extern void sys_vm86(void);
extern void sys_ioperm(void);
extern void sys_iopl(void);
extern void sys_fork(void);
extern void sys_vfork(void);
extern void sys_clone(void);
extern void sys_sysmips(void);
extern void sys_cachectl(void);
extern void sys_pause(void);
extern void sys_ipc(void);
extern void sys_cacheflush(void);
extern void sys_nice(void);
extern void sys_sched_setscheduler(void);
extern void sys_sched_setparam(void);
extern void sys_sched_getscheduler(void);
extern void sys_sched_getparam(void);
extern void sys_sched_yield(void);
extern void sys_sched_get_priority_max(void);
extern void sys_sched_get_priority_min(void);
extern void sys_sched_rr_get_interval(void);
extern void sys_syslog(void);
extern void sys_create_module(void);
extern void sys_init_module(void);
extern void sys_delete_module(void);
extern void sys_query_module(void);
extern void sys_get_kernel_syms(void);
extern void sys_exit(void);
extern void sys_waitpid(void);
extern void sys_getitimer(void);
extern void sys_setitimer(void);
extern void sys_sysinfo(void);
extern void sys_time(void);
extern void sys_stime(void);
extern void sys_gettimeofday(void);
extern void sys_settimeofday(void);
extern void sys_adjtimex(void);
extern void sys_sysctl(void);
extern void sys_acct(void);
extern void sys_capget(void);
extern void sys_capset(void);
extern void sys_alarm(void);
extern void sys_getpid(void);
extern void sys_getppid(void);
extern void sys_getuid(void);
extern void sys_geteuid(void);
extern void sys_getgid(void);
extern void sys_getegid(void);
extern void sys_nanosleep(void);
extern void sys_rt_sigprocmask(void);
extern void sys_rt_sigpending(void);
extern void sys_rt_sigtimedwait(void);
extern void sys_kill(void);
extern void sys_rt_sigqueueinfo(void);
extern void sys_sigpending(void);
extern void sys_sigprocmask(void);
extern void sys_rt_sigaction(void);
extern void sys_sgetmask(void);
extern void sys_ssetmask(void);
extern void sys_ni_syscall(void);
extern void sys_setpriority(void);
extern void sys_getpriority(void);
extern void sys_reboot(void);
extern void sys_setregid(void);
extern void sys_setgid(void);
extern void sys_setreuid(void);
extern void sys_setuid(void);
extern void sys_setresuid(void);
extern void sys_getresuid(void);
extern void sys_setresgid(void);
extern void sys_getresgid(void);
extern void sys_setfsuid(void);
extern void sys_setfsgid(void);
extern void sys_times(void);
extern void sys_setpgid(void);
extern void sys_getpgid(void);
extern void sys_getpgrp(void);
extern void sys_getsid(void);
extern void sys_setsid(void);
extern void sys_getgroups(void);
extern void sys_setgroups(void);
extern void sys_newuname(void);
extern void sys_sethostname(void);
extern void sys_gethostname(void);
extern void sys_setdomainname(void);
extern void sys_getrlimit(void);
extern void sys_old_getrlimit(void);
extern void sys_setrlimit(void);
extern void sys_getrusage(void);
extern void sys_umask(void);
extern void sys_prctl(void);
extern void sys_sendfile(void);
extern void sys_msync(void);
extern void sys_madvise(void);
extern void sys_mincore(void);
extern void sys_mlock(void);
extern void sys_munlock(void);
extern void sys_mlockall(void);
extern void sys_munlockall(void);
extern void sys_brk(void);
extern void sys_munmap(void);
extern void sys_mprotect(void);
extern void sys_mremap(void);
extern void sys_statfs(void);
extern void sys_fstatfs(void);
extern void sys_truncate(void);
extern void sys_ftruncate(void);
extern void sys_truncate64(void);
extern void sys_ftruncate64(void);
extern void sys_utime(void);
extern void sys_utimes(void);
extern void sys_access(void);
extern void sys_chdir(void);
extern void sys_fchdir(void);
extern void sys_chroot(void);
extern void sys_fchmod(void);
extern void sys_chmod(void);
extern void sys_chown(void);
extern void sys_lchown(void);
extern void sys_fchown(void);
extern void sys_creat(void);
extern void sys_vhangup(void);
extern void sys_lseek(void);
extern void sys_llseek(void);
extern void sys_read(void);
extern void sys_write(void);
extern void sys_readv(void);
extern void sys_writev(void);
extern void sys_pread(void);
extern void sys_pwrite(void);
extern void sys_sync(void);
extern void sys_fsync(void);
extern void sys_fdatasync(void);
extern void sys_bdflush(void);
extern void sys_sysfs(void);
extern void sys_ustat(void);
extern void sys_umount(void);
extern void sys_oldumount(void);
extern void sys_mount(void);
extern void sys_pivot_root(void);
extern void sys_stat(void);
extern void sys_newstat(void);
extern void sys_lstat(void);
extern void sys_newlstat(void);
extern void sys_fstat(void);
extern void sys_newfstat(void);
extern void sys_readlink(void);
extern void sys_stat64(void);
extern void sys_lstat64(void);
extern void sys_fstat64(void);
extern void sys_uselib(void);
extern void sys_mknod(void);
extern void sys_mkdir(void);
extern void sys_rmdir(void);
extern void sys_unlink(void);
extern void sys_symlink(void);
extern void sys_link(void);
extern void sys_rename(void);
extern void sys_dup2(void);
extern void sys_dup(void);
extern void sys_fcntl(void);
extern void sys_fcntl64(void);
extern void sys_ioctl(void);
extern void sys_getdents(void);
extern void sys_getdents64(void);
extern void sys_select(void);
extern void sys_poll(void);
extern void sys_flock(void);
extern void sys_getcwd(void);
extern void sys_nfsservctl(void);
extern void sys_quotactl(void);
extern void sys_msgget(void);
extern void sys_msgsnd(void);
extern void sys_msgrcv(void);
extern void sys_msgctl(void);
extern void sys_shmget(void);
extern void sys_shmat(void);
extern void sys_shmdt(void);
extern void sys_shmctl(void);
extern void sys_socket(void);
extern void sys_socketpair(void);
extern void sys_bind(void);
extern void sys_listen(void);
extern void sys_accept(void);
extern void sys_connect(void);
extern void sys_getsockname(void);
extern void sys_getpeername(void);
extern void sys_sendto(void);
extern void sys_send(void);
extern void sys_recvfrom(void);
extern void sys_recv(void);
extern void sys_setsockopt(void);
extern void sys_getsockopt(void);
extern void sys_shutdown(void);
extern void sys_sendmsg(void);
extern void sys_recvmsg(void);
extern void sys_socketcall(void);
extern void sys_personality(void);
extern void sys_syscall(void);
extern void old_readdir(void);
extern void sys_gettid(void);
extern void sys_readahead(void);
extern void sys_setxattr(void);
extern void sys_lsetxattr(void);
extern void sys_fsetxattr(void);
extern void sys_getxattr(void);
extern void sys_lgetxattr(void);
extern void sys_fgetxattr(void);
extern void sys_listxattr(void);
extern void sys_llistxattr(void);
extern void sys_flistxattr(void);
extern void sys_removexattr(void);
extern void sys_lremovexattr(void);
extern void sys_fremovexattr(void);
extern void sys_tkill(void);
/* ------------------------------------------------------------------------ */
#undef SYS
#ifdef __STDC__
#define SYS(RoutineName,args)  { (void*)RoutineName, # RoutineName },
#else
#define SYS(RoutineName,args) { RoutineName, "RoutineName"},
#endif
static struct {
  void           *routine;
  char           *ascii;
}               routine_names[] = {
#include "syscalls.h"
  { 0, 0 }
};

/* ------------------------------------------------------------------------ */
/* Create a string name for a function address, else a hex string. */
static char     print_routine_buf[50];

char	*print_routine_name(unsigned routine)
{
  int             i = 0;

  for (i = 0; routine_names[i].ascii != NULL; i++)
    if (routine_names[i].routine == (void *) routine)
      return (routine_names[i].ascii);
  sprintf(print_routine_buf, "%x", routine);
  return (print_routine_buf);
}

/* ------------------------------------------------------------------------ */
/* move  a0,t2           # function */
/* lw    a1,PT_EPC(sp)   # from pc */
/* move  a2,ra           # current RA (most system calls are subroutines) */
/* jal   debug_syscall */

void debug_syscall(unsigned int f, unsigned int pc, unsigned int ra)
{
#if 0
  if (f == (unsigned int) sys_write) {
    return;			/* do not print out sys_write system calls. */
  }
#endif
  DBG_SYSCALL("debug_syscall: pid=%d calling %s (from %x, RA=%x)\n", current->pid, print_routine_name(f), pc, ra);
}

/* ------------------------------------------------------------------------ */
/* jal   debug_return */

void debug_return(void)
{
  DBG_SYSCALL("debug_return: pid=%d\n", current->pid);
}

/* ------------------------------------------------------------------------ */
#endif	/* DEBUGSYSCALLS */
