/* There are several different types of tests needed.				 */

/* For the first simple type, just do 2000 of the same instruction.		 */
/* 	DOIT()									 */

/* For the second set, CACHE and PREF, there are different formats needed.	 */
/*	DOIT()	used, multiple operations.					 */

/* For the third set, we have the stores and the loads.				 */
/*	These need several different tests for each.				 */
/* 				"store, store, store, store",	0 */
/* 				"store, store, store, load"	1 */
/* 				"store, store, load, store"	2 */
/* 				"store, store, load, load"	3 */
/* 				"store, load, store, store",	4 */
/* 				"store, load, store, load",	5 */
/* 				"store, load, load, store",	6 */
/* 				"store, load, load, load",	7 */
/* 				"load, store, store, store",	8 */
/* 				"load, store, store, load"	9 */
/* 				"load, store, load, store"	10 */
/* 				"load, store, load, load"	11 */
/* 				"load, load, store, store",	12 */
/* 				"load, load, store, load",	13 */
/* 				"load, load, load, store",	14 */
/* 				"load, load, load, load",	15 */
/*	a) 2000 to same address.						 */
/*	b) to 0(a0), 4(a0), 8(a0), 12(a0) (same cache line)		 	 */
/*	   or as appropriate for "b" and "h"					 */
/*	c) to 12(a0), 8(a0), 4(a0), 0(a0) (same cache line)		 	 */
/*	d) to 0(a0), 16(a0), 32(a0), 48(a0) (diff cache lines)			 */
/*	e) to 48(a0), 32(a0), 16(a0), 0(a0) (diff cache lines)		 	 */
/* 	g) to 0(a0), 4(a0), 8(a0), 32(a0) (together and separated cache lines)	 */
/* 	   to 0(a0), 4(a0), 8(a0), 36(a0) (together and separated cache lines)	 */
/* 	   to 0(a0), 4(a0), 8(a0), 40(a0) (together and separated cache lines)	 */
/* 	   to 0(a0), 4(a0), 8(a0), 48(a0) (together and separated cache lines)	 */

/* 	h) to 0(a0), 4(a0), 32(a0), 8(a0) (together and separated cache lines)	 */
/* 	   to 0(a0), 4(a0), 36(a0), 8(a0) (together and separated cache lines)	 */
/* 	   to 0(a0), 4(a0), 40(a0), 8(a0) (together and separated cache lines)	 */
/* 	   to 0(a0), 4(a0), 48(a0), 8(a0) (together and separated cache lines)	 */

/* 	i) to 0(a0), 32(a0), 4(a0), 8(a0) (together and separated cache lines)	 */
/*		... */
/* 	j) to 32(a0), 0(a0), 4(a0), 8(a0) (together and separated cache lines)	 */
/*		... */
/*	see what that does, see if other permutations necessary. */

/* For the fourth set, we have the branches.					 */
/*	a) direct jumps:	J, JR						 */
/*	b) subroutine calls:	JAL, JALR					 */
/*	c) branch offset:	BEQ, BGEZ, BGTZ, BLEZ, BNE			 */
/* 	   1) delay slot tests: a) in same cache line, b) not in same cache line */
/*	   2) 1, 2, 3, 4 for delay slot (expand above).				 */
/*	d) branch likely offset: BEQL, BGEZL, BGTZL, BLEZL, BNEL		 */
/*	   1) delay slot only executed if branch taken.				 */
/*	e) branch and link:	BGEZAL, BLTZAL					 */
/*	   1) subroutine call.							 */
/*	f) branch and link likely: BGEZALL, BLTZALL				 */
/*	   1) delay slot only executed if branch taken.				 */

/* ----------------------------------------------------------------------------- */
#define	ENTRY_CREATE(stuff...)	\
	stuff;			\
	.word	8f;		\
	.pushsection .data;	\
  8:	.asciiz #stuff;		\
	.popsection;

/* create four instructions the same (a cache line's worth) */
#define	DOIT(stuff...)	\
	ENTRY_CREATE(stuff); \
	ENTRY_CREATE(stuff); \
	ENTRY_CREATE(stuff); \
	ENTRY_CREATE(stuff);

#define	LDST(load,store,addr1,addr2,addr3,addr4)	\
  ENTRY_CREATE(store t5,addr1); ENTRY_CREATE(store t5,addr2); ENTRY_CREATE(store t5,addr3); ENTRY_CREATE(store t5,addr4); /* 0 */ \
  ENTRY_CREATE(store t5,addr1); ENTRY_CREATE(store t5,addr2); ENTRY_CREATE(store t5,addr3); ENTRY_CREATE(load t5,addr4); /* 1 */ \
  ENTRY_CREATE(store t5,addr1); ENTRY_CREATE(store t5,addr2); ENTRY_CREATE(load t5,addr3); ENTRY_CREATE(store t5,addr4); /* 2 */ \
  ENTRY_CREATE(store t5,addr1); ENTRY_CREATE(store t5,addr2); ENTRY_CREATE(load t5,addr3); ENTRY_CREATE(load t5,addr4); /* 3 */ \
  ENTRY_CREATE(store t5,addr1); ENTRY_CREATE(load t5,addr2); ENTRY_CREATE(store t5,addr3); ENTRY_CREATE(store t5,addr4); /* 4 */ \
  ENTRY_CREATE(store t5,addr1); ENTRY_CREATE(load t5,addr2); ENTRY_CREATE(store t5,addr3); ENTRY_CREATE(load t5,addr4); /* 5 */ \
  ENTRY_CREATE(store t5,addr1); ENTRY_CREATE(load t5,addr2); ENTRY_CREATE(load t5,addr3); ENTRY_CREATE(store t5,addr4); /* 6 */ \
  ENTRY_CREATE(store t5,addr1); ENTRY_CREATE(load t5,addr2); ENTRY_CREATE(load t5,addr3); ENTRY_CREATE(load t5,addr4); /* 7 */ \
  ENTRY_CREATE(load t5,addr1); ENTRY_CREATE(store t5,addr2); ENTRY_CREATE(store t5,addr3); ENTRY_CREATE(store t5,addr4); /* 8 */ \
  ENTRY_CREATE(load t5,addr1); ENTRY_CREATE(store t5,addr2); ENTRY_CREATE(store t5,addr3); ENTRY_CREATE(load t5,addr4); /* 9 */ \
  ENTRY_CREATE(load t5,addr1); ENTRY_CREATE(store t5,addr2); ENTRY_CREATE(load t5,addr3); ENTRY_CREATE(store t5,addr4); /* 10 */ \
  ENTRY_CREATE(load t5,addr1); ENTRY_CREATE(store t5,addr2); ENTRY_CREATE(load t5,addr3); ENTRY_CREATE(load t5,addr4); /* 11 */ \
  ENTRY_CREATE(load t5,addr1); ENTRY_CREATE(load t5,addr2); ENTRY_CREATE(store t5,addr3); ENTRY_CREATE(store t5,addr4); /* 12 */ \
  ENTRY_CREATE(load t5,addr1); ENTRY_CREATE(load t5,addr2); ENTRY_CREATE(store t5,addr3); ENTRY_CREATE(load t5,addr4); /* 13 */ \
  ENTRY_CREATE(load t5,addr1); ENTRY_CREATE(load t5,addr2); ENTRY_CREATE(load t5,addr3); ENTRY_CREATE(store t5,addr4); /* 14 */ \
  ENTRY_CREATE(load t5,addr1); ENTRY_CREATE(load t5,addr2); ENTRY_CREATE(load t5,addr3); ENTRY_CREATE(load t5,addr4); /* 15 */ 

/* ----------------------------------------------------------------------------- */
LEAF(test_stuff_instructions)
	.set mips32
	.set at
	.set noreorder
/* ----------------------------------------------------------------------------- */
/* Must always do NOP for timing differentials */
/* First simple type tests. */
    DOIT(nop)
#if 0
/* ADD     Integer Add                                   Rd = Rs + Rt */
    DOIT(add	t5, t5, t6)
/* ADDI    Integer Add Immediate                         Rt = Rs + Immed */
    DOIT(addi	t5, t5, 1)
/* ADDIU   Unsigned Integer Add Immediate                Rt = Rs +U Immed */
    DOIT(addiu	t5, t5, 1)
/* ADDU    Unsigned Integer Add                          Rd = Rs +U Rt */
    DOIT(addu	t5, t5, t6)
/* AND     Logical AND                                   Rd = Rs & Rt */
    DOIT(and	t5, t5, t6)
/* ANDI    Logical AND Immediate                         Rt = Rs & (016 || Immed) */
    DOIT(and	t5, t5, 1)
/* CLO     Count Leading Ones                            Rd = NumLeadingOnes(Rs) */
    DOIT(clo	t5, t6)
/* CLZ     Count Leading Zeroes                          Rd = NumLeadingZeroes(Rs) */
    DOIT(clz	t5, t6)
/* DIV     Divide                                        LO = (int)Rs / (int)Rt */
/*                                                       HI = (int)Rs % (int)Rt */
    DOIT(div	zero, t5, t6)
/* DIVU    Unsigned Divide                               LO = (uns)Rs / (uns)Rt */
/*                                                       HI = (uns)Rs % (uns)Rt */
    DOIT(divu	zero, t5, t6)
/* LUI     Load Upper Immediate                          Rt = immediate << 16 */
    DOIT(lui	t5, 4)
/* MADD    Multiply-Add                                  HI | LO += (int)Rs * (int)Rt */
    DOIT(madd	t5, t6)
/* MADDU   Multiply-Add Unsigned                         HI | LO += (uns)Rs * (uns)Rt */
    DOIT(maddu	t5, t6)
/* MFC0    Move From Coprocessor 0                       Rt = CPR[0, n, sel] = Rt */
    DOIT(mfc0	t5, $12)
/* MFHI    Move From HI                                  Rd = HI */
    DOIT(mfhi	t5)
/* MFLO    Move From LO                                  Rd = LO */
    DOIT(mflo	t5)
/* MOVN    Move Conditional on Not Zero                  if Rt  0 then */
/*                                                           Rd = Rs */
    DOIT(movn	t5, t6, t7)
/* MOVZ    Move Conditional on Zero                      if Rt = 0 then */
/*                                                           Rd = Rs */
    DOIT(movz	t5, t6, t7)
/* MSUB    Multiply-Subtract                             HI | LO -= (int)Rs * (int)Rt */
    DOIT(msub	t5, t6)
/* MSUBU   Multiply-Subtract Unsigned                    HI | LO -= (uns)Rs * (uns)Rt */
    DOIT(msubu	t5, t6)
/* MTC0    Move To Coprocessor 0                         CPR[0, n, SEL] = Rt */
    DOIT(mtc0	zero, $12)
/* MTHI    Move To HI                                    HI = Rs */
    DOIT(mthi	t5)
/* MTLO    Move To LO                                    LO = Rs */
    DOIT(mtlo	t5)
/* MUL     Multiply with register write                  HI | LO =Unpredictable */
/*                                                       Rd = ((int)Rs * (int)Rt)31..0 */
    DOIT(mul	t5, t6, t7)
/* MULT    Integer Multiply                              HI | LO = (int)Rs * (int)Rd */
    DOIT(mult	t5, t6)
/* MULTU   Unsigned Multiply                             HI | LO = (uns)Rs * (uns)Rd */
    DOIT(multu	t5, t6)
/* NOR     Logical NOR                                   Rd = ~(Rs | Rt) */
    DOIT(nor	t5, t6, t7)
/* OR      Logical OR                                    Rd = Rs | Rt */
    DOIT(or	t5, t6, t7)
/* ORI     Logical OR Immediate                          Rt = Rs | Immed */
    DOIT(ori	t5, t6, 1)
/* SLL     Shift Left Logical                            Rd = Rt << sa */
    DOIT(sll	t5, t5, 1)
/* SLLV    Shift Left Logical Variable                   Rd = Rt << Rs[4:0] */
    DOIT(sllv	t5, t5, t6)
/* SLT     Set on Less Than                              if (int)Rs < (int)Rt */
/*                                                         Rd = 1 */
/*                                                       else */
/*                                                         Rd = 0 */
    DOIT(slt	t5, t6, t7)
/* SLTI    Set on Less Than Immediate                    if (int)Rs < (int)Immed */
/*                                                         Rt = 1 */
/*                                                       else */
/*                                                         Rt = 0 */
    DOIT(slti	t5, t6, 1)
/* SLTIU   Set on Less Than Immediate Unsigned           if (uns)Rs < (uns)Immed */
/*                                                         Rt = 1 */
/*                                                       else */
/*                                                         Rt = 0 */
    DOIT(sltiu	t5, t6, 1)
/* SLTU    Set on Less Than Unsigned                     if (uns)Rs < (uns)Immed */
/*                                                         Rd = 1 */
/*                                                       else */
/*                                                         Rd = 0 */
    DOIT(sltu	t5, t6, 1)
/* SRA     Shift Right Arithmetic                        Rd = (int)Rt >> sa */
    DOIT(sra	t5, t6, 1)
/* SRAV    Shift Right Arithmetic Variable               Rd = (int)Rt >> Rs[4:0] */
    DOIT(srav	t5, t6, t7)
/* SRL     Shift Right Logical                           Rd = (uns)Rt >> sa */
    DOIT(srl	t5, t6, 1)
/* SRLV    Shift Right Logical Variable                  Rd = (uns)Rt >> Rs[4:0] */
    DOIT(srlv	t5, t6, t7)
/* SSNOP   Superscalar Inhibit No Operation              NOP */
    DOIT(ssnop)
/* SUB     Integer Subtract                              Rt = (int)Rs - (int)Rd */
    DOIT(sub	t5, t5, t6)
/* SUBU    Unsigned Subtract                             Rt = (uns)Rs - (uns)Rd */
    DOIT(subu	t5, t5, t6)
/* SYNC    Synchronize                                   See Software User's Manual */
    DOIT(sync)
/* XOR     Exclusive OR                                  Rd = Rs ^ Rt */
    DOIT(xor	t5, t6, t7)
/* XORI    Exclusive OR Immediate                        Rt = Rs ^ (uns)Immed */
    DOIT(xori	t5, t6, 1)
/*------------------------------------------------------------------------ */
/* These two are special test case. Note: ERET zeros LL. */
/* Don't worry about these, very seldom used. */
/* LL      Load Linked Word                               Rt = Mem[Rs+offset] */
/*                                                        LL = 1 */
/*                                                        LLAdr = Rs + offset */
    DOIT(ll	t5, 4(a0))
/* SC      Store Conditional Word                         if LL = 1 */
/*                                                          mem[Rs+offset] = Rt */
/*                                                        Rt = LL */
    DOIT(sc	t5, 4(a0))
/*------------------------------------------------------------------------ */
/* Second test */
/* CACHE   Cache Operation                                See Software User's Manual */
#define Index_Invalidate_I	0
#define Index_Invalidate_Inv_D	1
    DOIT(cache Index_Invalidate_I, 4(a0))
    DOIT(cache Index_Invalidate_Inv_D, 4(a0))
/* PREF    Prefetch                                       Load Specified Line into Cache */
    DOIT(pref 0, 4(a0))		/* read-only */
    DOIT(pref 1, 4(a0))		/* probably read/write */
    DOIT(pref 4, 4(a0))		/* load_streamed */
    DOIT(pref 5, 4(a0))		/* store_streamed */
    DOIT(pref 6, 4(a0))		/* load_retained */
    DOIT(pref 7, 4(a0))		/* store_retained */
#endif	/* 0 */
/*------------------------------------------------------------------------ */
#if 0
/* LB      Load Byte                                      Rt = (byte))Mem[Rs+offset] */
/* SB      Store Byte                                     (byte)Mem[Rs+offset] = Rt */
    LDST(lb, sb, 0(a0), 0(a0), 0(a0), 0(a0));					/* 0 */
    LDST(lb, sb, 1(a0), 1(a0), 1(a0), 1(a0));					/* 1 */
    LDST(lb, sb, 2(a0), 2(a0), 2(a0), 2(a0));					/* 2 */
    LDST(lb, sb, 3(a0), 3(a0), 3(a0), 3(a0));					/* 3 */
/* b, c */
    LDST(lb, sb, 0(a0), 1(a0), 2(a0), 3(a0));					/* 4 */
    LDST(lb, sb, 3(a0), 2(a0), 1(a0), 0(a0));					/* 5 */
    LDST(lb, sb, 0(a0), 2(a0), 4(a0), 6(a0));					/* 6 */
    LDST(lb, sb, 6(a0), 4(a0), 2(a0), 0(a0));					/* 7 */
    LDST(lb, sb, 1(a0), 3(a0), 5(a0), 7(a0));					/* 8 */
    LDST(lb, sb, 7(a0), 5(a0), 3(a0), 1(a0));					/* 9 */
    LDST(lb, sb, 0(a0), 2(a0), 1(a0), 3(a0));					/* 10 */
/* d, e */
    LDST(lb, sb, 0(a0), 16(a0), 32(a0), 48(a0));	/* 4 cache lines */	/* 11 */
    LDST(lb, sb, 48(a0), 32(a0), 16(a0), 0(a0));				/* 12 */
/* g */
    LDST(lb, sb, 0(a0), 4(a0), 8(a0), 32(a0));		/* 2 cache lines */	/* 13 */
    LDST(lb, sb, 0(a0), 4(a0), 8(a0), 36(a0));		/* 2 cache lines */	/* 14 */
    LDST(lb, sb, 0(a0), 4(a0), 8(a0), 40(a0));		/* 2 cache lines */	/* 15 */
    LDST(lb, sb, 0(a0), 4(a0), 8(a0), 48(a0));		/* 2 cache lines */	/* 16 */
    LDST(lb, sb, 32(a0), 8(a0), 4(a0), 0(a0));					/* 17 */
/* h */
    LDST(lb, sb, 0(a0), 4(a0), 32(a0), 8(a0));		/* 2 cache lines */	/* 18 */
    LDST(lb, sb, 0(a0), 4(a0), 36(a0), 8(a0));		/* 2 cache lines */	/* 19 */
    LDST(lb, sb, 0(a0), 4(a0), 40(a0), 8(a0));		/* 2 cache lines */	/* 20 */
    LDST(lb, sb, 0(a0), 4(a0), 48(a0), 8(a0));		/* 2 cache lines */	/* 21 */
    LDST(lb, sb, 8(a0), 32(a0), 4(a0), 0(a0));					/* 22 */
/* i */
    LDST(lb, sb, 0(a0), 32(a0), 4(a0), 8(a0));		/* 2 cache lines */	/* 23 */
    LDST(lb, sb, 0(a0), 36(a0), 4(a0), 8(a0));		/* 2 cache lines */	/* 24 */
    LDST(lb, sb, 0(a0), 40(a0), 4(a0), 8(a0));		/* 2 cache lines */	/* 25 */
    LDST(lb, sb, 0(a0), 48(a0), 4(a0), 8(a0));		/* 2 cache lines */	/* 26 */
    LDST(lb, sb, 8(a0), 4(a0), 48(a0), 0(a0));					/* 27 */
/* j */
    LDST(lb, sb, 32(a0), 0(a0), 4(a0), 8(a0));		/* 2 cache lines */	/* 28 */
    LDST(lb, sb, 36(a0), 0(a0), 4(a0), 8(a0));		/* 2 cache lines */	/* 29 */
    LDST(lb, sb, 40(a0), 0(a0), 4(a0), 8(a0));		/* 2 cache lines */	/* 30 */
    LDST(lb, sb, 48(a0), 0(a0), 4(a0), 8(a0));		/* 2 cache lines */	/* 31 */
    LDST(lb, sb, 8(a0), 4(a0), 0(a0), 48(a0));					/* 32 */
#endif	/* 0 */
/*------------------------------------------------------------------------ */
#if 0
/* LBU     Unsigned Load Byte                             Rt = (ubyte))Mem[Rs+offset] */
    LDST(lbu, sb, 0(a0), 0(a0), 0(a0), 0(a0));
    LDST(lbu, sb, 1(a0), 1(a0), 1(a0), 1(a0));
    LDST(lbu, sb, 2(a0), 2(a0), 2(a0), 2(a0));
    LDST(lbu, sb, 3(a0), 3(a0), 3(a0), 3(a0));
/* b, c */
    LDST(lbu, sb, 0(a0), 1(a0), 2(a0), 3(a0));
    LDST(lbu, sb, 3(a0), 2(a0), 1(a0), 0(a0));
    LDST(lbu, sb, 0(a0), 2(a0), 4(a0), 6(a0));
    LDST(lbu, sb, 6(a0), 4(a0), 2(a0), 0(a0));
    LDST(lbu, sb, 1(a0), 3(a0), 5(a0), 7(a0));
    LDST(lbu, sb, 7(a0), 5(a0), 3(a0), 1(a0));
    LDST(lbu, sb, 0(a0), 2(a0), 1(a0), 3(a0));
/* d, e */
    LDST(lbu, sb, 0(a0), 16(a0), 32(a0), 48(a0));	/* 4 cache lines */
    LDST(lbu, sb, 48(a0), 32(a0), 16(a0), 0(a0));
/* g */
    LDST(lbu, sb, 0(a0), 4(a0), 8(a0), 32(a0));		/* 2 cache lines */
    LDST(lbu, sb, 0(a0), 4(a0), 8(a0), 36(a0));		/* 2 cache lines */
    LDST(lbu, sb, 0(a0), 4(a0), 8(a0), 40(a0));		/* 2 cache lines */
    LDST(lbu, sb, 0(a0), 4(a0), 8(a0), 48(a0));		/* 2 cache lines */
    LDST(lbu, sb, 32(a0), 8(a0), 4(a0), 0(a0));
/* h */
    LDST(lbu, sb, 0(a0), 4(a0), 32(a0), 8(a0));		/* 2 cache lines */
    LDST(lbu, sb, 0(a0), 4(a0), 36(a0), 8(a0));		/* 2 cache lines */
    LDST(lbu, sb, 0(a0), 4(a0), 40(a0), 8(a0));		/* 2 cache lines */
    LDST(lbu, sb, 0(a0), 4(a0), 48(a0), 8(a0));		/* 2 cache lines */
    LDST(lbu, sb, 8(a0), 32(a0), 4(a0), 0(a0));
/* i */
    LDST(lbu, sb, 0(a0), 32(a0), 4(a0), 8(a0));		/* 2 cache lines */
    LDST(lbu, sb, 0(a0), 36(a0), 4(a0), 8(a0));		/* 2 cache lines */
    LDST(lbu, sb, 0(a0), 40(a0), 4(a0), 8(a0));		/* 2 cache lines */
    LDST(lbu, sb, 0(a0), 48(a0), 4(a0), 8(a0));		/* 2 cache lines */
    LDST(lbu, sb, 8(a0), 4(a0), 48(a0), 0(a0));
/* j */
    LDST(lbu, sb, 32(a0), 0(a0), 4(a0), 8(a0));		/* 2 cache lines */
    LDST(lbu, sb, 36(a0), 0(a0), 4(a0), 8(a0));		/* 2 cache lines */
    LDST(lbu, sb, 40(a0), 0(a0), 4(a0), 8(a0));		/* 2 cache lines */
    LDST(lbu, sb, 48(a0), 0(a0), 4(a0), 8(a0));		/* 2 cache lines */
    LDST(lbu, sb, 8(a0), 4(a0), 0(a0), 48(a0));
#endif	/* 0 */
/*------------------------------------------------------------------------ */
/* LH      Load Halfword                                  Rt = (half)Mem[Rs+offset] */
/* SH      Store Half                                     (half)Mem[Rs+offset] = Rt */
/* LHU     Unsigned Load Halfword                         Rt = (uhalf)Mem[Rs+offset] */
#if 0
/* #define lh lhu */
    LDST(lh, sh, 0(a0), 0(a0), 0(a0), 0(a0));					/* 0 */
    LDST(lh, sh, 2(a0), 2(a0), 2(a0), 2(a0));					/* 1 */
/* b, c */
    LDST(lh, sh, 0(a0), 2(a0), 4(a0), 6(a0));					/* 2 */
    LDST(lh, sh, 6(a0), 4(a0), 2(a0), 0(a0));					/* 3 */
    LDST(lh, sh, 0(a0), 4(a0), 8(a0), 12(a0));		/* 1 cache line */	/* 4 */
    LDST(lh, sh, 12(a0), 8(a0), 4(a0), 0(a0));					/* 5 */
    LDST(lh, sh, 0(a0), 4(a0), 8(a0), 12(a0));					/* 6 */
    LDST(lh, sh, 0(a0), 8(a0), 4(a0), 12(a0));					/* 7 */
/* d, e */
    LDST(lh, sh, 0(a0), 16(a0), 32(a0), 48(a0));	/* 4 cache lines */	/* 8 */
    LDST(lh, sh, 48(a0), 32(a0), 16(a0), 0(a0));				/* 9 */
/* g */
    LDST(lh, sh, 0(a0), 4(a0), 8(a0), 32(a0));		/* 2 cache lines */	/* 10 */
    LDST(lh, sh, 0(a0), 4(a0), 8(a0), 36(a0));		/* 2 cache lines */	/* 11 */
    LDST(lh, sh, 0(a0), 4(a0), 8(a0), 40(a0));		/* 2 cache lines */	/* 12 */
    LDST(lh, sh, 0(a0), 4(a0), 8(a0), 48(a0));		/* 2 cache lines */	/* 13 */
    LDST(lh, sh, 32(a0), 8(a0), 4(a0), 0(a0));					/* 14 */
/* h */
    LDST(lh, sh, 0(a0), 4(a0), 32(a0), 8(a0));		/* 2 cache lines */	/* 15 */
    LDST(lh, sh, 0(a0), 4(a0), 36(a0), 8(a0));		/* 2 cache lines */	/* 16 */
    LDST(lh, sh, 0(a0), 4(a0), 40(a0), 8(a0));		/* 2 cache lines */	/* 17 */
    LDST(lh, sh, 0(a0), 4(a0), 48(a0), 8(a0));		/* 2 cache lines */	/* 18 */
    LDST(lh, sh, 8(a0), 32(a0), 4(a0), 0(a0));					/* 19 */
/* i */
    LDST(lh, sh, 0(a0), 32(a0), 4(a0), 8(a0));		/* 2 cache lines */	/* 20 */
    LDST(lh, sh, 0(a0), 36(a0), 4(a0), 8(a0));		/* 2 cache lines */	/* 21 */
    LDST(lh, sh, 0(a0), 40(a0), 4(a0), 8(a0));		/* 2 cache lines */	/* 22 */
    LDST(lh, sh, 0(a0), 48(a0), 4(a0), 8(a0));		/* 2 cache lines */	/* 23 */
    LDST(lh, sh, 8(a0), 4(a0), 48(a0), 0(a0));					/* 24 */
/* j */
    LDST(lh, sh, 32(a0), 0(a0), 4(a0), 8(a0));		/* 2 cache lines */	/* 25 */
    LDST(lh, sh, 36(a0), 0(a0), 4(a0), 8(a0));		/* 2 cache lines */	/* 26 */
    LDST(lh, sh, 40(a0), 0(a0), 4(a0), 8(a0));		/* 2 cache lines */	/* 27 */
    LDST(lh, sh, 48(a0), 0(a0), 4(a0), 8(a0));		/* 2 cache lines */	/* 28 */
    LDST(lh, sh, 8(a0), 4(a0), 0(a0), 48(a0));					/* 29 */
#endif	/* 0 */
/*------------------------------------------------------------------------ */
#if 0
/* LW      Load Word                                      Rt = Mem[Rs+offset] */
    LDST(lw, sw, 0(a0), 0(a0), 0(a0), 0(a0));					/* 1 */
    LDST(lw, sw, 4(a0), 4(a0), 4(a0), 4(a0));					/* 2 */
#endif	/* 0 */

#if 0
/* b, c */
    LDST(lw, sw, 0(a0), 4(a0), 8(a0), 12(a0));		/* 1 cache line */	/* 3 */
    LDST(lw, sw, 0(a0), 8(a0), 12(a0), 4(a0));		/* 1 cache line */	/* 4 */
    LDST(lw, sw, 12(a0), 8(a0), 4(a0), 0(a0));		/* 1 cache line */	/* 5 */
    LDST(lw, sw, 12(a0), 4(a0), 8(a0), 0(a0));		/* 1 cache line */	/* 6 */
#endif	/* 0 */

#if 0
/* d, e */
    LDST(lw, sw, 0(a0), 16(a0), 32(a0), 48(a0));	/* 4 cache lines */	/* 7 */
    LDST(lw, sw, 48(a0), 32(a0), 16(a0), 0(a0));				/* 8 */
#endif	/* 0 */

#if 0
/* g */
    LDST(lw, sw, 0(a0), 4(a0), 8(a0), 32(a0));		/* 2 cache lines */	/* 9 */
#endif	/* 0 */

#if 0
    LDST(lw, sw, 0(a0), 4(a0), 8(a0), 36(a0));		/* 2 cache lines */	/* 10 */
    LDST(lw, sw, 0(a0), 4(a0), 8(a0), 40(a0));		/* 2 cache lines */	/* 11 */
    LDST(lw, sw, 0(a0), 4(a0), 8(a0), 48(a0));		/* 2 cache lines */	/* 12 */
    LDST(lw, sw, 32(a0), 8(a0), 4(a0), 0(a0));					/* 13 */
/* h */
    LDST(lw, sw, 0(a0), 4(a0), 32(a0), 8(a0));		/* 2 cache lines */	/* 14 */
    LDST(lw, sw, 0(a0), 4(a0), 36(a0), 8(a0));		/* 2 cache lines */	/* 15 */
    LDST(lw, sw, 0(a0), 4(a0), 40(a0), 8(a0));		/* 2 cache lines */	/* 16 */
    LDST(lw, sw, 0(a0), 4(a0), 48(a0), 8(a0));		/* 2 cache lines */	/* 17 */
    LDST(lw, sw, 8(a0), 32(a0), 4(a0), 0(a0));					/* 18 */
/* i */
    LDST(lw, sw, 0(a0), 32(a0), 4(a0), 8(a0));		/* 2 cache lines */	/* 19 */
    LDST(lw, sw, 0(a0), 36(a0), 4(a0), 8(a0));		/* 2 cache lines */	/* 20 */
    LDST(lw, sw, 0(a0), 40(a0), 4(a0), 8(a0));		/* 2 cache lines */	/* 21 */
    LDST(lw, sw, 0(a0), 48(a0), 4(a0), 8(a0));		/* 2 cache lines */	/* 22 */
    LDST(lw, sw, 8(a0), 4(a0), 48(a0), 0(a0));					/* 23 */
/* j */
    LDST(lw, sw, 32(a0), 0(a0), 4(a0), 8(a0));		/* 2 cache lines */	/* 24 */
    LDST(lw, sw, 36(a0), 0(a0), 4(a0), 8(a0));		/* 2 cache lines */	/* 25 */
    LDST(lw, sw, 40(a0), 0(a0), 4(a0), 8(a0));		/* 2 cache lines */	/* 26 */
    LDST(lw, sw, 48(a0), 0(a0), 4(a0), 8(a0));		/* 2 cache lines */	/* 27 */
    LDST(lw, sw, 8(a0), 4(a0), 0(a0), 48(a0));					/* 28 */
#endif	/* 0 */

#if 0
    ENTRY_CREATE(sw t5, 0(a0))
    ENTRY_CREATE(sw t5, 16(a0))
    ENTRY_CREATE(sw t5, 32(a0))
    ENTRY_CREATE(sw t5, 48(a0))

    ENTRY_CREATE(sw t5, 0(a0))
    ENTRY_CREATE(sw t5, 16(a0))
    ENTRY_CREATE(sw t5, 32(a0))
    ENTRY_CREATE(lw t6, 48(a0))

    ENTRY_CREATE(sw t5, 0(a0))
    ENTRY_CREATE(sw t5, 16(a0))
    ENTRY_CREATE(lw t7, 32(a0))
    ENTRY_CREATE(lw t6, 48(a0))

    ENTRY_CREATE(sw t5, 0(a0))
    ENTRY_CREATE(lw t8, 16(a0))
    ENTRY_CREATE(lw t7, 32(a0))
    ENTRY_CREATE(lw t6, 48(a0))

    ENTRY_CREATE(sw t5, 0(a0))
    ENTRY_CREATE(lw t8, 16(a0))
    ENTRY_CREATE(sw t7, 32(a0))
    ENTRY_CREATE(lw t6, 48(a0))

    ENTRY_CREATE(sw t5, 0(a0))
    ENTRY_CREATE(sw t6, 0(a0))
    ENTRY_CREATE(sw t7, 0(a0))
    ENTRY_CREATE(sw t8, 0(a0))

    ENTRY_CREATE(sw t5, 0(a0))
    ENTRY_CREATE(sw t5, 4(a0))
    ENTRY_CREATE(sw t5, 8(a0))
    ENTRY_CREATE(sw t5, 12(a0))

    ENTRY_CREATE(sw t5, 0(a0))
    ENTRY_CREATE(sw t6, 4(a0))
    ENTRY_CREATE(sw t7, 8(a0))
    ENTRY_CREATE(lw t8, 12(a0))

    ENTRY_CREATE(sb t5, 0(a0))
    ENTRY_CREATE(sb t6, 4(a0))
    ENTRY_CREATE(sb t7, 8(a0))
    ENTRY_CREATE(sb t8, 12(a0))

    ENTRY_CREATE(sb t5, 0(a0))
    ENTRY_CREATE(sb t6, 4(a0))
    ENTRY_CREATE(lb t7, 8(a0))
    ENTRY_CREATE(sb t8, 12(a0))

    ENTRY_CREATE(sw t5, 0(a0))
    ENTRY_CREATE(sw t6, 4(a0))
    ENTRY_CREATE(sw t7, 8(a0))
    ENTRY_CREATE(lw t8, 16(a0))

    ENTRY_CREATE(sw t5, 0(a0))
    ENTRY_CREATE(sw t6, 4(a0))
    ENTRY_CREATE(sw t7, 8(a0))
    ENTRY_CREATE(sw t8, 16(a0))

    ENTRY_CREATE(sw t5, 0(a0))
    ENTRY_CREATE(sw t5, 4(a0))
    ENTRY_CREATE(sw t5, 8(a0))
    ENTRY_CREATE(sw t5, 16(a0))

#endif	/* 0 */

#if 1
    ENTRY_CREATE(lw t5, 0x14c(t4))
    ENTRY_CREATE(lw t6, 0x14c(t4))
    ENTRY_CREATE(lw t7, 0x14c(t4))
    ENTRY_CREATE(lw t8, 0x14c(t4))
#endif	/* 0 */

/*------------------------------------------------------------------------ */
#if 0
/* LWL     Load Word Left                                 See Software User's Manual */
    DOIT(lwl	t5, 4(a0))
/* LWR     Load Word Right                                See Software User's Manual */
    DOIT(lwr	t5, 4(a0))
/*------------------------------------------------------------------------ */
/* SWL     Store Word Left                                See Software User's Manual */
    DOIT(swl	t5, 0(a0))
/* SWR     Store Word Right                               See Software User's Manual */
    DOIT(swr	t5, 0(a0))
#endif	/* 0 */
/*------------------------------------------------------------------------ */
	.global	test_stuff_instructions_end
test_stuff_instructions_end:
	nop
/*------------------------------------------------------------------------ */
/*------------------------------------------------------------------------ */
/* BEQ	   Branch On Equal                                if Rs == Rt */
/*                                                          PC += (int)offset */
    DOIT(beq	t5, t6, 1f)
/* BNE     Branch on Not Equal                            if Rs != Rt */
/*                                                          PC += (int)offset */
    DOIT(bne	t5, t6, 1f)
/* ------------------------------------------------------------------------ */
/* BEQL    Branch On Equal Likely                         if Rs == Rt */
/*                                                          PC += (int)offset */
/*                                                        else */
/*                                                          Ignore Next Instruction */
    DOIT(beql	t5, t6, 1f)
/* BNEL    Branch on Not Equal Likely                     if Rs != Rt */
/*                                                          PC += (int)offset */
/*                                                        else */
/*                                                          Ignore Next Instruction */
    DOIT(bnel	t5, t6, 1f)
/*------------------------------------------------------------------------ */
/* BGEZ    Branch on Greater Than or Equal To Zero        if !Rs[31] && Rs >= 0 */
/*                                                          PC += (int)offset */
    DOIT(bgez	t5, 1f)
/* BGTZ    Branch on Greater Than Zero                    if !Rs[31] && Rs > 0 */
/*                                                          PC += (int)offset */
    DOIT(bgtz	t5, 1f)
/* BLEZ    Branch on Less Than or Equal to Zero           if !Rs[31] && Rs <= 0 */
/*                                                          PC += (int)offset */
    DOIT(blez	t5, 1f)
/* BLTZ    Branch on Less Than Zero                       if !Rs[31] && Rs < 0 */
/*                                                          PC += (int)offset */
    DOIT(bltz	t5, 1f)
/* ------------------------------------------------------------------------ */
/* BGEZL   Branch on Greater Than or Equal To Zero Likely if !Rs[31] && Rs >= 0*/
/*                                                          PC += (int)offset */
/*                                                        else */
/*                                                          Ignore Next Instruction */
    DOIT(bgezl	t5, 1f)
/* BGTZL   Branch on Greater Than Zero Likely             if !Rs[31] && Rs > 0 */
/*                                                          PC += (int)offset */
/*                                                        else */
/*                                                          Ignore Next Instruction */
    DOIT(bgtzl	t5, 1f)
/* BLEZL   Branch on Less Than or Equal to Zero Likely    if !Rs[31] && Rs <= 0 */
/*                                                          PC += (int)offset */
/*                                                        else */
/*                                                          Ignore Next Instruction */
    DOIT(blezl	t5, 1f)
/* BLTZL   Branch on Less Than Zero Likely                if !Rs[31] && Rs < 0 */
/*                                                          PC += (int)offset */
/*                                                        else */
/*                                                          Ignore Next Instruction */
    DOIT(bltzl	t5, 1f)
/* ------------------------------------------------------------------------ */
/* BGEZAL  Branch on Greater Than or Equal To Zero And    GPR[31] = PC + 8 */
/*                    Link                                if !Rs[31] && Rs >= 0 */
/*                                                          PC += (int)offset */
    DOIT(bgezal	t5, 1f)
/* BLTZAL  Branch on Less Than Zero And Link              GPR[31] = PC + 8 */
/*                                                        if !Rs[31] && Rs < 0 */
/*                                                          PC += (int)offset */
    DOIT(bltzal	t5, 1f)
/* ------------------------------------------------------------------------ */
/* BGEZALL Branch on Greater Than or Equal To Zero And    GPR[31] = PC + 8 */
/*                    Link Likely                         if !Rs[31] && Rs >= 0*/
/*                                                          PC += (int)offset */
/*                                                        else */
/*                                                          Ignore Next Instruction */
    DOIT(bgezall	t5, 1f)
/* BLTZALL Branch on Less Than Zero And Link Likely       GPR[31] = PC + 8 */
/*                                                        if !Rs[31] && Rs < 0 */
/*                                                          PC += (int)offset */
/*                                                        else */
/*                                                          Ignore Next Instruction */
    DOIT(bltzall	t5, 1f)
/* ------------------------------------------------------------------------ */
/* J       Unconditional Jump                             PC = PC[31:28] || offset<<2 */
    DOIT(j	1f)
/* JR      Jump Register                                  PC = Rs */
    DOIT(jr	t7)
/* JAL     Jump and Link                                  GPR[31] = PC + 8 */
/*                                                        PC = PC[31:28] || offset<<2 */
    DOIT(jal	1f)
/* JALR    Jump and Link Register                         Rd = PC + 8 */
/*                                                        PC = Rs */
    DOIT(jalr	t8, t7)
    DOIT(jalr	ra, t7)					/* Normal use -- equals "jr" */
/* ------------------------------------------------------------------------ */
/* BREAK   Breakpoint                                     Break Exception */
/* COP0    Coprocessor 0 Operation                        See Software User's Manual */
/* DERET   Return from Debug Exception                    PC = DEPC */
/*                                                        Exit Debug Mode */
/* ERET    Return from Exception                          if SR[2] */
/*                                                          PC = ErrorEPC */
/*                                                        else { */
/*                                                          PC = EPC */
/*                                                          SR[1] = 0 */
/*							  } */
/*                                                        SR[2] = 0 */
/*                                                        LL = 0 */
/* SDBBP   Software Debug Break Point                     Trap to SW Debug Handler */
/* SYSCALL System Call                                    SystemCallException */
/* TEQ     Trap if Equal                                  if Rs == Rt */
/*                                                          TrapException */
/* TEQI    Trap if Equal Immediate                        if Rs == (int)Immed */
/*                                                          TrapException */
/* TGE     Trap if Greater Than or Equal                  if (int)Rs >= (int)Rt */
/*                                                          TrapException */
/* TGEI    Trap if Greater Than or Equal Immediate        if (int)Rs >= (int)Immed */
/*                                                          TrapException */
/* TGEIU   Trap if Greater Than or Equal Immediate        if (uns)Rs >= (uns)Immed */
/*                     Unsigned                             TrapException */
/* TGEU    Trap if Greater Than or Equal Unsigned         if (uns)Rs >= (uns)Rt */
/*                                                          TrapException */
/* TLT     Trap if Less Than                              if (int)Rs < (int)Rt */
/*                                                          TrapException */
/* TLTI    Trap if Less Than Immediate                    if (int)Rs < (int)Immed */
/*                                                          TrapException */
/* TLTIU   Trap if Less Than Immediate Unsigned           if (uns)Rs < (uns)Immed */
/*                                                          TrapException */
/* TLTU    Trap if Less Than Unsigned                     if (uns)Rs < (uns)Rt */
/*                                                          TrapException */
/* TNE     Trap if Not Equal                              if Rs != Rt */
/*                                                          TrapException */
/* TNEI    Trap if Not Equal Immediate                    if Rs != (int)Immed */
/*                                                          TrapException */
/* WAIT    Wait for Interrupts                            Stall until interrupt occurs */
 1:

END(test_stuff_instructions)
