/* $Id: msp5000_setup.c,v 1.11 2003/04/10 22:44:53 mrustad Exp $ */
/*
 * Carsten Langgaard, carstenl@mips.com
 * Copyright (C) 1999,2000 MIPS Technologies, Inc.  All rights reserved.
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * Brecis MSP5000 specific setup.
 */
#include <linux/ctype.h>
#include <linux/config.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <linux/mc146818rtc.h>
#include <linux/ioport.h>

#include <asm/cpu.h>
#include <asm/bootinfo.h>
#include <asm/irq.h>
#include <asm/brecis/BrecisSysRegs.h>
#include <asm/brecis/prom.h>
#include <asm/brecis/brecisint.h>
#include <brecis/NanoDelay.h>

#ifdef	CONFIG_BRECIS_FPGA
#define	DEFAULT_BAUD	"19200"
#else
#define	DEFAULT_BAUD	"57600"
#endif	/* CONFIG_BRECIS_FPGA */

#ifdef CONFIG_REMOTE_DEBUG
extern void rs_kgdb_hook(int);
extern void brecis_kgdb_hook(void);
extern void breakpoint(void);
int remote_debug = 0;
#endif

/*
 * The following macro calls prom_printf and puts the format string
 * into an init section so it can be reclaimed.
 */

#define ppfinit(f, x...) do { static char _f[] __initdata = f; \
	prom_printf(_f, ## x); } while (0)

extern struct rtc_ops brecis_rtc_ops;
extern unsigned long	cpu_clk_rate;

extern void brecis_reboot_setup(void);
extern int mips_reboot_setup(void);

void __init brecis_setup(void)
{
#ifdef CONFIG_REMOTE_DEBUG
	int rs_putDebugChar(char);
	char rs_getDebugChar(void);
	int brecis_putDebugChar(char);
	char brecis_getDebugChar(void);
	extern int (*putDebugChar)(char);
	extern char (*getDebugChar)(void);
#endif
	char *argptr;
#if defined(CONFIG_SERIAL_CONSOLE) || defined(CONFIG_REMOTE_DEBUG)
	static char	cons_str[] __initdata = "console";
#endif
	static char	nofpu_str[] __initdata = "nofpu";

	ioport_resource.end = 0xBC0FFFFF;

#ifdef CONFIG_SERIAL_CONSOLE
	argptr = prom_getcmdline();
	if ((argptr = strstr(argptr, cons_str)) == NULL) {
		static char	consopt_str[] __initdata =
			" console=ttyS0," DEFAULT_BAUD;
		argptr = prom_getcmdline();
		strcat(argptr, consopt_str);
	}
#endif  

	do {
		char	*s;
		char	*endp = 0;
		unsigned long	rate;
		static char	clk_str[] __initdata = "clkfreq";
		static char	clkhz_str[] __initdata = "clkfreqhz";

		s = prom_getenv(clkhz_str);
		if (s && *s && (rate = simple_strtoul(s, &endp, 10)) &&
			*endp == 0) {
			cpu_clk_rate = rate;
			ppfinit("Clock rate set to %d\n", rate);
			break;
		} else if (endp != 0) {
			ppfinit("Clock rate in Hz parse error: %s\n", s);
		}

		endp = 0;
		s = prom_getenv(clk_str);
		if (s && *s && (rate = simple_strtoul(s, &endp, 10)) &&
			*endp == 0) {
			rate *= 1000000;
			cpu_clk_rate = rate;
			ppfinit("Clock rate set to %d\n", rate);
			break;
		} else if (endp != 0) {
			ppfinit("Clock rate in MHz parse error: %s\n", s);
		}
		ppfinit("Clock rate defaulting to %uld\n", cpu_clk_rate);
	} while (0);

#ifdef	CONFIG_BRECIS_SCRATCHPAD
	if ( ! identify_spad() ) {
		ppfinit("Scratchpad not present, halting.\n");
		while (1)
			__asm__ ("wait");
	}
#endif	/* CONFIG_BRECIS_SCRATCHPAD */

	NanoInit(cpu_clk_rate);	/* Initialize NanoDelay */

#ifdef CONFIG_REMOTE_DEBUG
	argptr = prom_getcmdline();
	if ((argptr = strstr(argptr, "kgdb=")) != NULL) {
		int cputype;
		int index;
		int line;
		char *s;
		char buf[41];
		static char	cputyp_str[] __initdata = "cputype";
		static char	str_5000[] __initdata = "5000";
		static char	kgdb_str[] __initdata = "kgdb=";
		static char	scc0_str[] __initdata = "scc0";
		static char	scc1_str[] __initdata = "scc1";
		static char	sccs_str[] __initdata = "scc0, scc1";

		s = prom_getenv(cputyp_str);
		if (s == NULL)
			cputype = 4000;
		else if (strcmp(s, str_5000) == 0)
			cputype = 5000;
		else
			cputype = 4000;

		argptr += strlen(kgdb_str);

		for (index = 0; index < 40; index++)
		{
			if (! isalnum(argptr[index]))
				break;

			buf[index] = argptr[index];
		}

		buf[index] = '\0';
		
		if (strcmp(cons_str, buf) == 0)
			line = -1;
		else if (strcmp(scc0_str, buf) == 0)
			line = 0;
		else if (strcmp(scc1_str, buf) == 0 && cputype == 5000)
			line = 1;
		else
		{
			ppfinit("KGDB: Unknown serial line %s\n", buf);

			ppfinit("KGDB: Possible serial lines are console, %s\n",
				cputype == 5000 ? sccs_str : scc0_str);
			
			strcpy(buf, cons_str);
			line = -1;
			ppfinit("KGDB: Defaulting serial line to %s\n", buf);
		}

		if(line == -1) {
			brecis_kgdb_hook();
			putDebugChar = brecis_putDebugChar;
			getDebugChar = brecis_getDebugChar;
		} else {
			rs_kgdb_hook(line);
			putDebugChar = rs_putDebugChar;
			getDebugChar = rs_getDebugChar;
		}

		ppfinit("KGDB: Using serial line to %s for session, "
				"please connect your debugger\n", buf);

		remote_debug = 1;
		/* Breakpoints and stuff are in brecis_irq_setup() */
	}
#endif
	argptr = prom_getcmdline();

	if ((argptr = strstr(argptr, nofpu_str)) != NULL)
		mips_cpu.options &= ~MIPS_CPU_FPU;

	rtc_ops = &brecis_rtc_ops;

	mips_reboot_setup();
}
