/* $Id: printf.c,v 1.8 2002/12/30 21:53:02 m4 Exp $ */
/*
 * Carsten Langgaard, carstenl@mips.com
 * Copyright (C) 1999,2000 MIPS Technologies, Inc.  All rights reserved.
 *
 * ########################################################################
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ########################################################################
 *
 * Putting things on the screen/serial line using YAMONs facilities.
 *
 */
#include <linux/config.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/serialP.h>
#include <linux/serial_reg.h>
#include <asm/system.h>
#include <asm/io.h>
#include <asm/serial.h>

extern void a5000PrintChar(char);
extern int a5000GetChar(void);

static struct serial_state rs_table[] = {
	SERIAL_PORT_DFNS	/* Defined in serial.h */
};

/*
 * Hooks to fake "prom" console I/O before devices 
 * are fully initialized. 
 */
static struct async_struct prom_port_info = {0};

void __init setup_prom_printf(int tty_no)
{
	struct serial_state *ser = &rs_table[tty_no];

	prom_port_info.state = ser;
	prom_port_info.magic = SERIAL_MAGIC;
	prom_port_info.port = ser->port;
	prom_port_info.flags = ser->flags;
	prom_port_info.iomem_base = ser->iomem_base;
	prom_port_info.iomem_reg_shift = ser->iomem_reg_shift;
	prom_port_info.io_type = ser->io_type;

	/* No setup of UART - assume PMON left in sane state */
}

int putPromChar(char c)
{
	a5000PrintChar(c);
	return 1;
}

char getPromChar(void)
{
	return a5000GetChar();
}

static char buf[1024] __initdata = "";

void __init prom_printf(char *fmt, ...)
{
    va_list args;
    int l;
    char *p, *buf_end;
    long flags;
    void a5000PrintChar(char);

    /* Low level, brute force, not SMP safe... */
    save_and_cli(flags);
    va_start(args, fmt);
    l = vsnprintf(buf, sizeof(buf), fmt, args); /* hopefully i < sizeof(buf) */
    va_end(args);

    buf_end = buf + l;

    for (p = buf; p < buf_end; p++)
    {	/* Crude cr/nl handling is better than none */
	if (*p == '\n')
	    a5000PrintChar('\r');
	a5000PrintChar(*p);
    }
    restore_flags(flags);
}

