/* $Id: pci_fixup.c,v 1.7 2003/03/22 22:47:13 mrustad Exp $ */
/*
 * BRIEF MODULE DESCRIPTION
 *	Board specific pci fixups.
 *
 * Copyright 2001 MontaVista Software Inc.
 * Author: MontaVista Software, Inc.
 *         	ppopov@mvista.com or source@mvista.com
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <linux/config.h>

#ifdef CONFIG_PCI

#include <linux/types.h>
#include <linux/pci.h>
#include <linux/kernel.h>
#include <linux/init.h>

#include <brecis/mspPCI.h>
#include <asm/brecis/BrecisSysRegs.h>
#include <asm/byteorder.h>

#undef	DEBUG
#ifdef 	DEBUG
#define	DBG(x...)	printk(x)
#define	IDBG(x...)	pkinit(x)
#else
#define	DBG(x...)	do {} while (0)
#define	IDBG(x...)	do {} while (0)
#endif

void __init pcibios_fixup_resources(struct pci_dev *dev)
{
	/* will need to fixup IO resources */
}

void __init pcibios_fixup_ioresources(struct pci_dev *dev)
{
	int	i;

	for (i = 0; i < 6; ++i) {
		if (pci_resource_len(dev, i) == 0)
			continue;
		if (pci_resource_flags(dev, i) & IORESOURCE_IO) {
			pkinit("pcibios_fixup_ioresources: "
				"start=%08lX, end=%08lX\n",
				pci_resource_start(dev, i),
				pci_resource_end(dev, i));
			pci_resource_start(dev, i) |= 0xB9001000;
			pci_resource_end(dev, i) |= 0xB9001000;
		}
	}
}


static void fixup_intersil(struct pci_dev *dev)
{
	printk("PCI: Fixing retry count for Intersil\n");
	pci_write_config_byte(dev, 0x41, 0);	/* Infinite bus retries */
}


struct pci_fixup pcibios_fixups[] = {
	{ PCI_FIXUP_HEADER, PCI_VENDOR_ID_INTERSIL,
		PCI_DEVICE_ID_INTERSIL_ISL3877, fixup_intersil },
	{ PCI_FIXUP_HEADER, PCI_VENDOR_ID_INTERSIL,
		PCI_DEVICE_ID_INTERSIL_ISL3890, fixup_intersil },
	{ PCI_FIXUP_HEADER, PCI_ANY_ID, PCI_ANY_ID, pcibios_fixup_resources },
	{ PCI_FIXUP_FINAL, PCI_ANY_ID, PCI_ANY_ID, pcibios_fixup_ioresources },
	{ 0 }
};

void __init pcibios_fixup(void)
{
#if 0
	unsigned long pci_mem_start = (unsigned long) PCI_MEM_START;

	writel(0, PCI_BRIDGE_CONFIG); // set extend byte to 0
	writel(0, SDRAM_MBAR);        // set mbar to 0
	writel(0x2, SDRAM_CMD);       // enable memory accesses
	au_sync_delay(1);

	// set extend byte to mbar of ext slot
	writel(((pci_mem_start >> 24) & 0xff) |
	       (1 << 8 | 1 << 9 | 1 << 10 | 1 << 27), PCI_BRIDGE_CONFIG);
	IDBG("Set bridge config to %x\n", readl(PCI_BRIDGE_CONFIG));
#endif	/* 0 */
}


void __init pcibios_fixup_irqs(void)
{
	unsigned int slot, func;
	unsigned char pin;
	struct pci_dev *dev;

	pci_for_each_dev(dev) {
		if (dev->bus->number != 0)
		return;

		pci_read_config_byte(dev, PCI_INTERRUPT_PIN, &pin);
		slot = PCI_SLOT(dev->devfn);
		func = PCI_FUNC(dev->devfn);
		if (pin == 0) {
			pin = 1;
			pci_write_config_byte(dev, PCI_INTERRUPT_LINE,
				dev->irq);
		}
#ifdef	CONFIG_BRECIS_FPGA
		dev->irq = pin - 1;
#else
		dev->irq = slot >= 16 ? ((pin - 1) + slot - 16) & 3 : 0;
#endif	/* CONFIG_BRECIS_FPGA */
		IDBG("slot %d func %d irq %d\n", slot, func, dev->irq);
	}
}


/*
 * Let's fix up the latency timer and cache line size here.  Cache
 * line size = 16 bytes / sizeof dword (4) = 4.
 * Latency timer must be > 8.  32 is random but appears to work.
 */

void	pcibios_set_master(struct pci_dev *dev)
{
	u8	tmp1;

	pci_read_config_byte(dev, PCI_LATENCY_TIMER, &tmp1);
	if (tmp1 < 32) {
		tmp1 = 32;
	}
	printk("PCI: Setting latency timer of device %s to %d\n",
		dev->slot_name, tmp1);
	pci_write_config_byte(dev, PCI_LATENCY_TIMER, tmp1);
}


unsigned int pcibios_assign_all_busses(void)
{
	return 1;
}

#endif	/* CONFIG_PCI */
