/* Borrowed and modified from glibc.  All GPL stuff applies. */

#include <sys/regdef.h>
#include <asm/asm.h>

	.text
NESTED(_mcount, 32, ra)
	.set	noat
	.set	noreorder
/* ---------- */
	/* save and disable interrupts */
	mfc0	t1, $12			/* status register */
	ori	t3, t1, 0x1
	xori	t3, t3, 0x1		/* disabled */
	mtc0	t3, $12			/* update status register */
	sll	$0, $0, 1		# nop
	sll	$0, $0, 1		# nop
	sll	$0, $0, 1		# nop
/* ---------- */
	mfc0	t2, $9			/* 3rd argument to __mcount */
	lui     t3,0xbc00		/* 4th argument to __mcount */
	lw	t3,0x14c(t3)	/* bc000148 + 4 = lower of counter */
/* ---------- */
	subu	sp, sp, 24		/* already 8 subtracted before here */
	sw	AT, 0(sp)		/* save at */
	sw	ra, 4(sp)		/* save ra */
	sw	a0, 8(sp)		/* save a0 */
	sw	a1, 12(sp)		/* save a1 */
	sw	a2, 16(sp)		/* save a2 */
	sw	a3, 20(sp)		/* save a3 */
	sw	t1, 24(sp)		/* saved interrupts */
	move	a1, ra			/* 2nd argument to __mcount */
	move	a2, t2
	move	a3, t3
	jal	__mcount
	move	a0, AT			/* 1st argument to __mcount */
/* ---------- */
	lw	AT, 0(sp)		/* restore at */
	lw	ra, 4(sp)		/* restore ra */
	lw	a0, 8(sp)		/* restore a0 */
	lw	a1, 12(sp)		/* restore a1 */
	lw	a2, 16(sp)		/* restore a2 */
	lw	a3, 20(sp)		/* restore a3 */
	lw	t2, 24(sp)		/* restore interrupts */
	addu	sp, sp, 32	/* mips-gcc puts in subu of 8 before call */
/* ---------- */
	lui	t5,0xbc00
	la	t6, __last32time	/* update __last32time */
	la	t4, __last32perf	/* update __last32perf */
	lw	t5, 0x14c(t5)
	mfc0	t3, $9
	sw	t3, 0(t6)
	sw	t5, 0(t4)
/* ---------- */
	mtc0	t2, $12			/* update status register */
	j	ra
	move	ra, AT		/* restore ra for rest of calling routine */
/* ---------- */
	.set	reorder
	.set	at
END(_mcount)
/* ------------------------------------------------------------------------ */

NESTED(_snapshot_mcount, 8, ra)
	.set	noat
	.set	noreorder
	subu	sp, sp, 8
/* ---------- */
	mfc0	a1, $12			/* status register */
	ori	a3, a1, 0x1
	xori	a3, a3, 0x1		/* disabled */
	mtc0	a3, $12			/* update status register */
	sll	$0, $0, 1		# nop
	sll	$0, $0, 1		# nop
	sll	$0, $0, 1		# nop
/* ---------- */
	lui     a3,0xbc00		/* 4th argument to __mcount */
	lw	a3,0x14c(a3)	/* bc000148 + 4 = lower of counter */
	mfc0	a2, $9			/* 3rd argument to __mcount */
/* ---------- */
	sw	a1, 4(sp)		/* saved interrupts */
	sw	ra, 0(sp)		/* saved ra */
	la	a1, _snapshot_mcount	/* 2nd argument to __mcount */
	move	a0, ra			/* 1st argument to __mcount */
/* ---------- */
	jal	__mcount
	nop
/* ---------- */
	lw	AT, 4(sp)		/* saved interrupts */
	lw	ra, 0(sp)		/* restore ra */
	addu	sp, sp, 8
/* ---------- */
	la	a2, __last32time
	lui	a0,0xbc00	
	la	a1, __last32perf	/* update __last32perf */

	lw	t2, 0x14c(a0)
	mfc0	t1, $9
	sw	t1, 0(a2)		/* update __last32time */
	sw	t2, 0(a1)
/* ---------- */
	j	ra
	mtc0    AT, $12                 /* update status register */
	.set	reorder
	.set	at
END(_snapshot_mcount)
