# Set up you environment here

TARGET_ROOT = .
CROSS = mips-

ARCH= -D__mips__
#---------------
CC =     $(CROSS)gcc
AR =     $(CROSS)ar
# LD =     $(CROSS)ld
LD =     $(CROSS)gcc
NM =     $(CROSS)nm
RANLIB = $(CROSS)ranlib
CP = 	 cp -p
#---------------
CWD :=$(shell pwd)
TOPDIR = $(shell pwd)/../
TOPDIR = /opt/brecis/cdrom/uClinux
DESTBIN = ${CWD}/bin
DESTSBIN = ${CWD}/sbin
#---------------
# magic to find where the compiler is harboring crtbegin.o and crtend.o
COMPLIBDIR := $(shell dirname `$(CC) -print-libgcc-file-name`)
#---------------
LDFLAGS += -nostdlib
#---------------
ifeq ($(FLAT), y)
  CFLAGS += -D__linux__ -DEMBED -G0
  CFLAGS += -nostdinc
  CFLAGS += -idirafter ${TOPDIR}/uC-libc/include/
  CFLAGS += -idirafter ${TOPDIR}/uC-libc/include/linux
  CFLAGS += -mno-abicalls -fno-pic -mno-split-addresses
  CFLAGS += -Os -fno-schedule-insns2
# CFLAGS += -E
  LDFLAGS = -L$(CWD)/libns
  LDFLAGS += -Wl,-elf2flt
  LIBS += $(COMPLIBDIR)/crtbegin.o
  LIBS += ${TOPDIR}/uC-libc/sysdeps/machine/crt0.o
  LDADD += -lns
  LDADD += -lgcc
  LDADD += -lc
  LDADD += -lgcc
  # for safty's sake, this should be at the END of LDADD
  LDADD += $(COMPLIBDIR)/crtend.o
  ELF2FLTDIR = ${TOPDIR}/elf2flt/
  FLTFLAGS = -r -s 4096
else
  # Elf binaries:
  CFLAGS += -DBRECIS -DEMBED
  CFLAGS += -Os -fno-schedule-insns2
  CFLAGS += -DNO_ASM
  CFLAGS += -Dlinux -D__linux__ -D_uclinux_ ${ARCH}
  CFLAGS += -mips2 -mgp32 -mlong32
  CFLAGS += -D__MIPSEB__
  CFLAGS += -shared
  CFLAGS += -mabicalls
  CFLAGS += -G 0
  CFLAGS += -mgpopt
  CFLAGS += -mfp32
  CFLAGS += -mhard-float
  CFLAGS += -mno-half-pic
  CFLAGS += -fno-PIC
  CFLAGS += -fpic
  CFLAGS += -fno-builtin
  CFLAGS += -nostdinc
  CFLAGS += -idirafter ${TOPDIR}/uC-libc/include/
  CFLAGS += -idirafter ${TOPDIR}/uC-libc/include/linux
  CFLAGS += -D_ANSI_SOURCE
  # CFLAGS += -Werror
  #---------------
  LDFLAGS += -N -T ${TOPDIR}/brecis/M4.ld
  LDFLAGS += -shared -Wl,-shared,-Bdynamic
  LDFLAGS += -L$(CWD)/libns
  LDFLAGS += -Wl,--no-undefined
  LDFLAGS += -Wl,--warn-once
  LDFLAGS += -Wl,--warn-common
  LDFLAGS += -Wl,--warn-constructors
  LDFLAGS += -Wl,--warn-multiple-gp
  #---------------
  LIBS += ${TOPDIR}/uC-libc/crt0.o
  LDADD += -lns
LDADD += -lgcc
  LDADD += -lc
LDADD += -lgcc
endif
#---------------
LIBS += -nostdlib
LIBS += -L${TOPDIR}/uC-libc
#---------------
ifeq ($(DEBUG), y)
        CFLAGS += -g
        LDFLAGS += -g
endif

SUBDIRS =
SUBDIRS += libns agetty httpd init inetd ping telnetd mount pppd tty \
        levee fileutils shutils sysutils ifattach ipfwadm tftp tftpd ftp aftpd
SUBDIRS += sh
SUBDIRS += sash
SUBDIRS += route
SUBDIRS =
SUBDIRS += mpn
SUBDIRS += mpz
SUBDIRS += mpq
SUBDIRS += mpf

.EXPORT_ALL_VARIABLES:

all:
	for i in $(SUBDIRS) ; do ${MAKE} -C $$i || exit 1; done

install:
	-mkdir -p ${DESTBIN}
	-mkdir -p ${DESTSBIN}
	for i in $(SUBDIRS) ; do ${MAKE} -C $$i install || exit 1; done

clean:
	rm -f *.[oa] *~ core
	for i in $(SUBDIRS) ; do ${MAKE} -C $$i clean || exit 1; done
	rm -f ${DESTBIN}/*
	rm -f ${DESTSBIN}/*
