/* $Header: /proj/software/pub/CVSROOT/uClinux/brecis/vpm/vpm-udp.c,v 1.1 2003/03/24 22:18:48 awarner Exp $ */
/****************************************************************************
 *
 * Program(s) to test brecis telephony driver
 *  
 *****************************************************************************/

/******************************************************************/
/* Copyright (c) 2003 BRECIS Communications                       */
/*      This software is the property of BRECIS Communications    */
/*      and may not be copied or distributed in any form without  */
/*      a prior licensing arrangement.                            */
/*                                                                */
/* BRECIS COMMUNICATIONS DISCLAIMS ANY LIABILITY OF ANY KIND      */
/* FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS      */
/* SOFTWARE.                                                      */
/*                                                                */
/******************************************************************/

/*
 * lala-udp [-p <pkt size>] -[t|r] <port> <device>
 *
 * Uses vanilla UDP, not RTP.
 *
 */
#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <linux/telephony.h>
#include <errno.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

char	buffer[1024] ;

int	pkt_size = 320 ;

void
usage(void)
{
	fprintf(stderr,
		"Usage: lala-udp [-p <pkt size>] -[t|r] port  <device>\n") ;
}

/*
 * strtosin() -	Convert a string of the form [<host>:]<port> to
 * 		a sockaddr_in structure. If the host component
 * 		is missing, default to localhost.
 * 		Hardwire address family to AF_INET.
 *
 * 		Return 0 if conversion is OK, !0 otherwise
 * 		(including syntax errors and possible hostname
 * 		lookup failure)
 */
int
strtosin(char *arg, struct sockaddr_in *s)
{
	const char *hostp ;
	const char *portp ;
	char *p ;
	int  tmp ;
	struct hostent *hp ;

	/*
	 * This looks backwards, but it isn't.
	 * Is there a "<host>:" component ?
	 */
	hostp = strtok(arg, ":") ;
	if ((portp = strtok(NULL, NULL)) == NULL) {
		/*
		 * Nope.
		 */
		s->sin_addr.s_addr = INADDR_ANY ;
		portp = arg ;
	} else {
		if ((hp = gethostbyname(hostp)) == NULL) {
			return(h_errno) ;
		}

		/*
		 * Note: we ignore multiple addresses, since this
		 * is a test fixture.
		 */
		s->sin_addr = *((struct in_addr *) *hp->h_addr_list) ;
	}

	s->sin_family = AF_INET ;

	tmp = (int)strtol(portp, &p, 10) ;

	/*
	 * Check that strtol was able to do his job.
	 */
	if ((*portp == '\0') || (p == portp) || (*p != '\0')) {
		return(-1) ;
	}

	s->sin_port = htonl(tmp) ;

	return(0) ;
}

/*
 * reader() -	open a connection to the specified port, open the
 * 		phone device start the rx codec, read data from the
 * 		phone device and write it to the network.
 */
void
reader(const char *phone_dev, struct sockaddr_in *s_in)
{
	int phone_fd, s, n ;

	/*
	 * Open the phone device.
	 */
	if ((phone_fd = open(phone_dev, O_RDONLY)) < 0) {
		perror("reader open") ;
		exit(10) ;
	}

	if ((s = socket(PF_INET, SOCK_DGRAM, 0)) < 0) {
		perror("reader socket") ;
		close(phone_fd) ;
		exit(11) ;
	}

	if (connect(s, (struct sockaddr *)s_in, sizeof(*s_in)) != 0) {
		perror("reader connect") ;
		close(s) ;
		close(phone_fd) ;
		exit(12) ;
	}

	ioctl(phone_fd, PHONE_REC_START, NULL) ;

	while ((n = read(phone_fd, buffer, pkt_size)) > 0) {
		if (write(s, buffer, n) != n) {
			perror("reader write") ;
			close(s) ;
			close(phone_fd) ;
			exit(13) ;
		}
	}

	perror("reader read") ;
	close(s) ;
	close(phone_fd) ;
}

/*
 * writer() -	Open the phone device for writing, listen on the
 * 		specified port, accept an inbound connection, start
 * 		the tx codec, read data from the network and write
 * 		it to the device.
 */
void
writer(const char *phone_dev, struct sockaddr_in *s_in)
{
	int phone_fd, s, n ;

	/*
	 * Open the phone device.
	 */
	if ((phone_fd = open(phone_dev, O_WRONLY)) < 0) {
		perror("writer open") ;
		exit(20) ;
	}

	if ((s = socket(PF_INET, SOCK_DGRAM, 0)) < 0) {
		perror("writer socket") ;
		close(phone_fd) ;
		exit(21) ;
	}

	if (bind(s, (struct sockaddr *)s_in, sizeof(*s_in)) != 0) {
		perror("writer bind") ;
		close(s) ;
		close(phone_fd) ;
		exit(22) ;
	}

	ioctl(phone_fd, PHONE_PLAY_START, NULL) ;

	while ((n = recv(s, buffer, pkt_size, 0)) > 0) {
		if (write(phone_fd, buffer, n) != n) {
			perror("writer write") ;
			close(s) ;
			close(phone_fd) ;
			exit(25) ;
		}
	}

	perror("writer read") ;
	close(s) ;
	close(phone_fd) ;
}

int main(int argc,char *argv[])
{
	extern char *optarg ;
	extern int optind ;
	int c ;
	char *p ;
	char *phone_dev ;
	struct sockaddr_in s_in ;
	int tx = 0, rx = 0 ;

	while ((c = getopt(argc, argv, "p:t:r:")) >= 0) {
		switch(c) {
		    case 'p':
			pkt_size = (int)strtol(optarg, &p, 0) ;
			if ((*p != '\0') || (p == optarg)) {
				usage() ;
				exit(2) ;
			}
			break ;
		    case 't':
		    case 'r':
			if (strtosin(optarg, &s_in)) {
				usage() ;
				exit(2) ;
			}
			if (c == 't') {
				tx++ ;
			} else {
				rx++ ;
			}
			break ;
		    default:
			usage() ;
			exit(1) ;
		}
	}

	if ((phone_dev = argv[optind]) == NULL) {
		usage() ;
		exit(3) ;
	}

	if ((rx + tx) != 1) {
		usage() ;
		exit(4) ;
	}

	if (tx) {
		reader(phone_dev, &s_in) ;
	} else {
		writer(phone_dev, &s_in) ;
	}

	exit(0) ;
}
