/* $Header: /proj/software/pub/CVSROOT/uClinux/brecis/ve-api/vrm.c,v 1.2 2002/05/17 15:34:48 tld Exp $ */
/* ************************************************************************ *
 *
 * vrm.c
 *
 *                  Copyright 2002, Brecis Communications
 *
 * Originator: TL Donahue
 *
 *          [Generated by tld on Fri 17 May 2002 at 14:24:34 UTC]
 * ************************************************************************ */
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "mspvpmapi.h"

static void print_usage(void)
{
	fprintf(stderr, "usage: vrm <addr> [addr ...]\n");
	exit(255);
}
			
int main(int argc, char **argv)
{
	U32 rc;

	rc = MspVpmStartBlkDev();
	if (MSP_SUCCESS != rc)
	{
		fprintf(stderr, "MspVpmStartBlkDev() returned: %d [0x%08x]\n",
			rc, rc);
		return 1;
	}
	if (argc > 1)
	{
		int arg;

		for (arg = 1; arg < argc; arg++)
		{
			long temp=0;
			char *endptr;

			if (strlen(argv[arg]) == 0)
			{
				fprintf(stderr, "Specify starting ZSP address\n");
				/* skip if argument string is 0 length */
				print_usage();
				continue;
			}
			/* convert arg to address */
			temp = strtol(argv[arg], &endptr, 0);

			/* test for error */
			if (*endptr != '\0')
			{
				fprintf(stderr, "Invalid ZSP address \"%s\" [%02x]\n",
					argv[arg], *endptr);
				continue;
			}
			if (temp > 0xFFFF)
			{
				fprintf(stderr, "Invalid ZSP address: %s [0x%08lx]\n",
					argv[arg], temp);
				continue;
			}
			/* good address */
			{
				U16 ZSPAddr=(U16)temp;
				U16 mem_vals[8]; /* number sets read len */

				fprintf(stderr, "ZSP address: 0x%04x [%5d]\n",
					ZSPAddr, ZSPAddr);

				rc = MspVpmRdMem(ZSPAddr,
					sizeof(mem_vals)/sizeof(mem_vals[0]),
					mem_vals);

				if (MSP_SUCCESS != rc)
				{
					fprintf(stderr, "MspVpmRdMem() returned: %d [0x%08x]\n",
						rc, rc);
				}
				else
				{
					char bfr[1024]={0};
					char *bfrptr=bfr;
					int cnt;

					bfrptr += sprintf(bfrptr, "0x%04x:", ZSPAddr);
					for (cnt = 0;
					     cnt < sizeof(mem_vals)/sizeof(mem_vals[0]);
					     cnt++)
					{
						bfrptr += sprintf(bfrptr, " %04x", mem_vals[cnt]);
					}
					printf("%s\n", bfr);
				}
			}
		}
	}
	else
	{
		print_usage();
	}
	return 0;
}

/* **************************** End of vrm.c ****************************** */
