/* $Header: /proj/software/pub/CVSROOT/uClinux/brecis/ve-api/mem.c,v 1.1 2002/05/30 21:38:20 tld Exp $ */
/* ************************************************************************ *
 *
 * mem.c
 *
 *                  Copyright 2002, Brecis Communications
 *
 * Originator: TL Donahue
 *
 *          [Generated by tld on Fri 17 May 2002 at 14:24:34 UTC]
 * ************************************************************************ */
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

static void print_usage(void)
{
	fprintf(stderr, "usage: mem <addr> [addr ...]\n");
	exit(255);
}
			
int main(int argc, char **argv)
{
	if (argc > 1)
	{
		int arg;

		for (arg = 1; arg < argc; arg++)
		{
			unsigned long temp=0;
			char *endptr;

			if (strlen(argv[arg]) == 0)
			{
				fprintf(stderr, "Specify at least one address\n");
				/* skip if argument string is 0 length */
				print_usage();
				continue;
			}
			/* convert arg to address */
			temp = strtoul(argv[arg], &endptr, 0);

			/* test for error */
			if (*endptr != '\0')
			{
				fprintf(stderr, "Invalid address \"%s\" [%02x]\n",
					argv[arg], *endptr);
				continue;
			}
			/* good address */
			{
				unsigned int *address=(unsigned int *)temp;

//				printf("%p:\n", address);
				printf("%p: %08x  [%u]\n", address,
					*address, *address);
			}
		}
	}
	else
	{
		print_usage();
	}
	return 0;
}

/* **************************** End of mem.c ****************************** */
