# ============================================================================
# WAN Router Configuration File.
# ============================================================================
# Protocol:  Frame Relay 
#-----------------------------------------------------------------------------

#*****************************************
# Device Definition Section              *
#*****************************************
#
# The [devices] section defines physical WAN connections. Each
# statement in this section has the following format:
#
# Usage: {device} = {protocol}, Comment
#
#        {device} : WAN device name; First card in the system
#                   must be named "wanpipe1".
#
#        {protocol} : WAN protocol currently supported:
#                             WAN_X25   generic X.25 configuration
#                             WAN_PPP   generic PPP configuration
#                             WAN_FR    generic frame relay configuration
#                             WAN_CHDLC generic Cisco HDLC configuration
#              

[devices]
wanpipe1 = WAN_FR, Frame relay link  


#****************************************
# Network Interfaces Definitions        *
#****************************************
#
# The [interfaces] section defines logical channels and corresponding
# network interfaces created by the router. Each statement in this section
# has the following format:
#
#       {interface name} = {device}, {media_addr}, Comment
#
#       Where:  {interface name} : Interface name must be the same
#                                  as interface file name defined in
#                                  /usr/local/wanrouter/interface.
#
#               {device}         : Defined above in [devices] section
#
#               {media_addr}     : DLCI number.
#				   Frame Relay operates on number of 
#                                  different logical channels, thus set
#                                  this field to an appropriate DLCI number. 
#
# NOTE:  Frame Relay can operate on maximum 100 DLCI connections, 
#        thus, up to 100 interface names can be defined per one device  !!!
                                                               

[interfaces]
wp1_fr16 = wanpipe1, 16, WANPIPE , frame relay 
wp1_fr17 = wanpipe1, 17, WANPIPE , frame relay 

#********************************************
# Link configuration section                *
#********************************************
#
# Each statement of the configuration section has the following format:
#
#       parameter=value
#
# where:
#       parameter       symbolic name of the configuration parameter.
#       value           number or symbolic name representing value of the
#                       configuration parameter.
#
# NOTE: A link configuration section must be specified for each device
#       defined in [device] section. The name must also be the same as 
#       declared above in [devices]
#
# For s508 Card:
#       Set the IOPort and IRQ options and
#       comment out the S514CPU and PCISlot options.
# For S514 PCI Card:
#       Set the S514CPU and PCISlot options and
#       comment out the IOPort and IRQ options
#

#------------------------ WANPIPE 1 -------------------------------------

[wanpipe1]	

	# ----- Hardware configuration ---------------
#S514CPU         = A		# S514 PCI Card CPU: A or B      (s514 only)
#AUTO_PCISLOT    = YES		# Autodetect pci slot		 (s514 only)
#PCISlot         = 0		# PCI Slot num:                  (s514 only)
				#
IOPort		= 0x360		# I/O port base                  (s508 only)
IRQ		= 7		# interrupt request level        (s508 only)
				#
#Option2	= 7200		# S502/S503 CPU clock rate (kHz)
				#
Firmware	= /usr/local/wanrouter/firmware/fr514.sfm	# adapter firmware
				#
				# ----- Dual Port Memory Base Address --------
#Memaddr	= 0xD0000	# Commenting this out enables Auto Memory 
				# selection. Valid Memory addresses are:
				# 0xA0000,0xA2000...0xAE000 / 0xC0000,0xC2000...
				# 0xCE000 / 0xD0000,0xD2000...0xDE000 / 0xE0000,
				# 0xE2000...0xEE000
                                #
    	# ----- Physical interface configuration -----
Interface	= V35	        # physical interface type, RS232/V35
Clocking	= External	# Tx/Rx clock source, External/Internal
				#
				# * Jumpers must be set for internal or external
				#   clocking for: 
				#        s508 : RS232 SEC port 
				#        s514 : RS232 PRI and SEC port 
				#
				#
BaudRate	= 1540000  	# data transfer rate in bps, 1200..2048000
                                #
    				# ----- Media-specific configuration ---------
MTU		= 1500		# maximum data transfer unit, bytes
UDPPORT         = 9000	        # UDP Port, used by fpipemon debugger
                                #

    	#------ Frame Relay Specific: Polling Intervals, Number of DLCIs -------
Station 	= CPE 	        # Options: CPE/Node	
				# Client connecting to the network (CPE)
				# Switch within the network (Node) 
				#
NUMBER_OF_DLCI	= 2		# Relevant to Node operation ONLY: Number of 
				# DLCI interfaces set in [interfaces] section.
				#
Signalling	= ANSI          # Protocol signalling: ANSI, LMI, Q933 or NO 
				# WARNING: Set signalling to NO only if
				#          you know what you are doing !!  
				#
T391		= 10		# Link Integrity Verification Timer 
T392		= 16		# Polling Verification Timer
N391		= 2		# Full Status Polling Cycle Counter
N392		= 3		# Error Threshold Counter
N393		= 4		# Monitored Events Counter
TTL		= 0x03		# Time to live


#*************************************************************
# Logical channel (interface) configuration sections.        *
#*************************************************************
#
# Each statement of the configuration section has the following format:
#
#       parameter=value
#
# where:
#       parameter       symbolic name of the configuration parameter
#       value           number or symbolic name representing value of the
#                       configuration parameter.
#
# * Interface name must be the same as the interface file
#   name defined in /usr/local/wanrouter/interfaces !       
#
# * Recomended nameing convention: (wp#_fr#)
#                        where wp# represents wanpipe1,2,3 ...   
#                          ane fr# represents dlci number.
#
# * If CIR is enabled, BC and BE must also be enabled !!!
#          Also, CIR and BC must be the same value !!!

[wp1_fr16]
#CIR		= 128 
#BC		= 128 
#BE		= 0 
MULTICAST	= NO
INARP		= NO
INARPINTERVAL	= 0

[wp1_fr17]
#CIR		= 64 
#BC		= 64
#BE		= 0 
MULTICAST	= NO
INARP		= NO
INARPINTERVAL	= 0


#-------------- END OF WANPIPE CONFIGURATION --------------------------
