/*
 * Copyright (c) 2001
 *	Alex Feldman <al.feldman@sangoma.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Alex Feldman.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY Alex Feldman AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL Alex Feldman OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 *	$Id: sdla_te1.c,v 1.1 2002/01/25 20:09:48 mrustad Exp $
 */

/*
 ******************************************************************************
 * sdla_te1.c	WANPIPE(tm) Multiprotocol WAN Link Driver. 
 *				T1/E1 board configuration.
 *
 * Author: 	Alex Feldman  <al.feldman@sangoma.com>
 *
 * ============================================================================
 * Aprl 30, 2001	Alex Feldma	Initial version.
 ******************************************************************************
 */

/*
 ******************************************************************************
			   INCLUDE FILES
 ******************************************************************************
*/
#if (defined __FreeBSD__) || (defined __OpenBSD__)
# ifdef __FreeBSD__
#  include <stddef.h>
#  include <bitstring.h>
# else
#  include </usr/include/bitstring.h>
# endif
# include <sys/param.h>
# include <sys/systm.h>
# include <sys/syslog.h>
# include <sys/malloc.h>
# include <sys/errno.h>
# include <sys/sockio.h>
# include <sys/socket.h>
# include <sys/kernel.h>
# ifdef __OpenBSD__
#  include <sys/device.h>
#  include <sys/timeout.h>
#  include <machine/bus.h>
# endif
# include <net/wanpipe.h>	/* WANPIPE common user API definitions */
#elif (defined __WINDOWS__)
# include "wanpipe_include.h"
#else
# include <linux/version.h>	/**/
# include <linux/config.h>	/* OS configuration options */
# include <linux/stddef.h>	/* offsetof, etc. */
# include <linux/errno.h>	/* returns codes */
# include <linux/string.h>	/* inline memset, etc */
# include <linux/delay.h>	/* mdelay() */
# include <linux/kernel.h>	/* printk()m and other usefull stuff */
# include <linux/wanrouter.h>	/* WAN router definitions */
# include <linux/wanpipe.h>	/* WANPIPE common user API definitions */
#endif
/*
 ******************************************************************************
			  DEFINES AND MACROS
 ******************************************************************************
*/
#ifndef TRUE
# define TRUE	1
#endif
#ifndef FALSE
# define FALSE	0
#endif

#define FIRST_SAMPLE			0
#define LAST_SAMPLE			23
#define FIRST_UI			0
#define LAST_UI				4

#define MAX_BUSY_READ			0x05

#define WRITE_REG(reg, value)		card->wandev.write_front_end_reg(card, reg, (unsigned char)(value))
#define READ_REG(reg)			card->wandev.read_front_end_reg(card, reg)
#define WRITE_RPSC_REG(reg, value)	WriteRPSCReg(card, reg, value)
#define READ_RPSC_REG(reg)		ReadRPSCReg(card, reg)
#define WRITE_TPSC_REG(reg, value)	WriteTPSCReg(card, reg, value)
#define READ_TPSC_REG(reg)		ReadTPSCReg(card, reg)

#define IS_T1_ALARM(alarm)		(alarm & 			\
						(			\
						 BIT_RED_ALARM |	\
						 BIT_AIS_ALARM |	\
						 BIT_YEL_ALARM 		\
						 )) 

#define IS_E1_ALARM(alarm)		(alarm &	 		\
						(			\
						 BIT_RED_ALARM  |	\
						 BIT_AIS_ALARM  |	\
						 BIT_ALOS_ALARM 	\
						 ))

/* Macro for enabling/disabling debugging comments */
#undef SDLA_TE_DEBUG
#if (defined __FreeBSD__) || (defined __OpenBSD__)
# define PRINT(card, format, msg...)	log(LOG_INFO, format, ## msg)
# ifdef SDLA_TE_DEBUG
#  define DEBUG_PRINT(format, msg...)	log(LOG_INFO, format, ## msg)
# else
#  define DEBUG_PRINT(format, msg...)
# endif
#elif (defined __WINDOWS__)
# define PRINT		OutputLogString
# ifdef SDLA_TE_DEBUG
#  define DEBUG_PRINT	DbgPrint
# else
#  define DEBUG_PRINT
# endif
#else
# define PRINT(card, format, msg...)	printk(KERN_INFO format, ## msg)
# ifdef SDLA_TE_DEBUG
#  define DEBUG_PRINT(format, msg...)	printk(KERN_INFO format, ## msg)
# else
#  define DEBUG_PRINT(format, msg...)
# endif
#endif

/*
 ******************************************************************************
			STRUCTURES AND TYPEDEFS
 ******************************************************************************
*/
typedef unsigned char TX_WAVEFORM[LAST_SAMPLE-FIRST_SAMPLE+1][LAST_UI-FIRST_UI+1];
typedef struct RLPS_EQUALIZER_RAM_T {
	/*unsigned char address;*/
	unsigned char byte1;
	unsigned char byte2;
	unsigned char byte3;
	unsigned char byte4;
} RLPS_EQUALIZER_RAM;
/*
 ******************************************************************************
			   GLOBAL VARIABLES
 ******************************************************************************
*/


/* Transmit Waveform Values for T1 Long Haul (LBO 0db)
 * unsigned char t1_tx_waveform_lh_0db[LAST_SAMPLE-FIRST_SAMPLE+1][LAST_UI-FIRST_UI+1] = 
 */
TX_WAVEFORM t1_tx_waveform_lh_0db = 
{
	{ 0x00, 0x44, 0x00, 0x00, 0x00 },
	{ 0x0A, 0x44, 0x00, 0x00, 0x00 },
	{ 0x20, 0x43, 0x00, 0x00, 0x00 },
	{ 0x32, 0x43, 0x00, 0x00, 0x00 },
	{ 0x3E, 0x42, 0x00, 0x00, 0x00 },
	{ 0x3D, 0x42, 0x00, 0x00, 0x00 },
	{ 0x3C, 0x41, 0x00, 0x00, 0x00 },
	{ 0x3B, 0x41, 0x00, 0x00, 0x00 },
	{ 0x3A, 0x00, 0x00, 0x00, 0x00 },
	{ 0x39, 0x00, 0x00, 0x00, 0x00 },
	{ 0x39, 0x00, 0x00, 0x00, 0x00 },
	{ 0x38, 0x00, 0x00, 0x00, 0x00 },
	{ 0x37, 0x00, 0x00, 0x00, 0x00 },
	{ 0x36, 0x00, 0x00, 0x00, 0x00 },
	{ 0x34, 0x00, 0x00, 0x00, 0x00 },
	{ 0x29, 0x00, 0x00, 0x00, 0x00 },
	{ 0x4F, 0x00, 0x00, 0x00, 0x00 },
	{ 0x4C, 0x00, 0x00, 0x00, 0x00 },
	{ 0x4A, 0x00, 0x00, 0x00, 0x00 },
	{ 0x49, 0x00, 0x00, 0x00, 0x00 },
	{ 0x47, 0x00, 0x00, 0x00, 0x00 },
	{ 0x47, 0x00, 0x00, 0x00, 0x00 },
	{ 0x46, 0x00, 0x00, 0x00, 0x00 },
	{ 0x46, 0x00, 0x00, 0x00, 0x00 }
};

/* Transmit Waveform Values for T1 Long Haul (LBO 7.5 dB): 
 * unsigned char t1_tx_waveform_lh_75db[LAST_SAMPLE-FIRST_SAMPLE+1][LAST_UI-FIRST_UI+1] = 
 */
TX_WAVEFORM t1_tx_waveform_lh_75db = 
{
    { 0x00, 0x10, 0x00, 0x00, 0x00 },
    { 0x01, 0x0E, 0x00, 0x00, 0x00 },
    { 0x02, 0x0C, 0x00, 0x00, 0x00 },
    { 0x04, 0x0A, 0x00, 0x00, 0x00 },
    { 0x08, 0x08, 0x00, 0x00, 0x00 },
    { 0x0C, 0x06, 0x00, 0x00, 0x00 },
    { 0x10, 0x04, 0x00, 0x00, 0x00 },
    { 0x16, 0x02, 0x00, 0x00, 0x00 },
    { 0x1A, 0x01, 0x00, 0x00, 0x00 },
    { 0x1E, 0x00, 0x00, 0x00, 0x00 },
    { 0x22, 0x00, 0x00, 0x00, 0x00 },
    { 0x26, 0x00, 0x00, 0x00, 0x00 },
    { 0x2A, 0x00, 0x00, 0x00, 0x00 },
    { 0x2B, 0x00, 0x00, 0x00, 0x00 },
    { 0x2C, 0x00, 0x00, 0x00, 0x00 },
    { 0x2D, 0x00, 0x00, 0x00, 0x00 },
    { 0x2C, 0x00, 0x00, 0x00, 0x00 },
    { 0x28, 0x00, 0x00, 0x00, 0x00 },
    { 0x24, 0x00, 0x00, 0x00, 0x00 },
    { 0x20, 0x00, 0x00, 0x00, 0x00 },
    { 0x1C, 0x00, 0x00, 0x00, 0x00 },
    { 0x18, 0x00, 0x00, 0x00, 0x00 },
    { 0x14, 0x00, 0x00, 0x00, 0x00 },
    { 0x12, 0x00, 0x00, 0x00, 0x00 }
};


/* Transmit Waveform Values for T1 Long Haul (LBO 15 dB)
 * unsigned char t1_tx_waveform_lh_15db[LAST_SAMPLE-FIRST_SAMPLE+1][LAST_UI-FIRST_UI+1] = 
 */
TX_WAVEFORM t1_tx_waveform_lh_15db = 
{
    { 0x00, 0x2A, 0x09, 0x01, 0x00 },
    { 0x00, 0x28, 0x08, 0x01, 0x00 },
    { 0x00, 0x26, 0x08, 0x01, 0x00 },
    { 0x00, 0x24, 0x07, 0x01, 0x00 },
    { 0x01, 0x22, 0x07, 0x01, 0x00 },
    { 0x02, 0x20, 0x06, 0x01, 0x00 },
    { 0x04, 0x1E, 0x06, 0x01, 0x00 },
    { 0x07, 0x1C, 0x05, 0x00, 0x00 },
    { 0x0A, 0x1B, 0x05, 0x00, 0x00 },
    { 0x0D, 0x19, 0x05, 0x00, 0x00 },
    { 0x10, 0x18, 0x04, 0x00, 0x00 },
    { 0x14, 0x16, 0x04, 0x00, 0x00 },
    { 0x18, 0x15, 0x04, 0x00, 0x00 },
    { 0x1B, 0x13, 0x03, 0x00, 0x00 },
    { 0x1E, 0x12, 0x03, 0x00, 0x00 },
    { 0x21, 0x10, 0x03, 0x00, 0x00 },
    { 0x24, 0x0F, 0x03, 0x00, 0x00 },
    { 0x27, 0x0D, 0x03, 0x00, 0x00 },
    { 0x2A, 0x0D, 0x02, 0x00, 0x00 },
    { 0x2D, 0x0B, 0x02, 0x00, 0x00 },
    { 0x30, 0x0B, 0x02, 0x00, 0x00 },
    { 0x30, 0x0A, 0x02, 0x00, 0x00 },
    { 0x2E, 0x0A, 0x02, 0x00, 0x00 },
    { 0x2C, 0x09, 0x02, 0x00, 0x00 }
};


/* Transmit Waveform Values for T1 Long Haul (LBO 22.5 dB)
 * unsigned char t1_tx_waveform_lh_225db[LAST_SAMPLE-FIRST_SAMPLE+1][LAST_UI-FIRST_UI+1] = 
 */
TX_WAVEFORM t1_tx_waveform_lh_225db = 
{
    { 0x00, 0x1F, 0x16, 0x06, 0x01 },
    { 0x00, 0x20, 0x15, 0x05, 0x01 },
    { 0x00, 0x21, 0x15, 0x05, 0x01 },
    { 0x00, 0x22, 0x14, 0x05, 0x01 },
    { 0x00, 0x22, 0x13, 0x04, 0x00 },
    { 0x00, 0x23, 0x12, 0x04, 0x00 },
    { 0x01, 0x23, 0x12, 0x04, 0x00 },
    { 0x01, 0x24, 0x11, 0x03, 0x00 },
    { 0x01, 0x23, 0x10, 0x03, 0x00 },
    { 0x02, 0x23, 0x10, 0x03, 0x00 },
    { 0x03, 0x22, 0x0F, 0x03, 0x00 },
    { 0x05, 0x22, 0x0E, 0x03, 0x00 },
    { 0x07, 0x21, 0x0E, 0x02, 0x00 },
    { 0x09, 0x20, 0x0D, 0x02, 0x00 },
    { 0x0B, 0x1E, 0x0C, 0x02, 0x00 },
    { 0x0E, 0x1D, 0x0C, 0x02, 0x00 },
    { 0x10, 0x1B, 0x0B, 0x02, 0x00 },
    { 0x13, 0x1B, 0x0A, 0x02, 0x00 },
    { 0x15, 0x1A, 0x0A, 0x02, 0x00 },
    { 0x17, 0x19, 0x09, 0x01, 0x00 },
    { 0x19, 0x19, 0x08, 0x01, 0x00 },
    { 0x1B, 0x18, 0x08, 0x01, 0x00 },
    { 0x1D, 0x17, 0x07, 0x01, 0x00 },
    { 0x1E, 0x17, 0x06, 0x01, 0x00 }
};


/* Transmit Waveform Values for T1 Short Haul (0 - 110 ft.)
 * unsigned char t1_tx_waveform_sh_110ft[LAST_SAMPLE-FIRST_SAMPLE+1][LAST_UI-FIRST_UI+1] = 
 */
TX_WAVEFORM t1_tx_waveform_sh_110ft = 
{
    { 0x00, 0x45, 0x00, 0x00, 0x00 },
    { 0x0A, 0x44, 0x00, 0x00, 0x00 },
    { 0x20, 0x43, 0x00, 0x00, 0x00 },
    { 0x3F, 0x43, 0x00, 0x00, 0x00 },
    { 0x3F, 0x42, 0x00, 0x00, 0x00 },
    { 0x3F, 0x42, 0x00, 0x00, 0x00 },
    { 0x3C, 0x41, 0x00, 0x00, 0x00 },
    { 0x3B, 0x41, 0x00, 0x00, 0x00 },
    { 0x3A, 0x00, 0x00, 0x00, 0x00 },
    { 0x39, 0x00, 0x00, 0x00, 0x00 },
    { 0x39, 0x00, 0x00, 0x00, 0x00 },
    { 0x38, 0x00, 0x00, 0x00, 0x00 },
    { 0x37, 0x00, 0x00, 0x00, 0x00 },
    { 0x36, 0x00, 0x00, 0x00, 0x00 },
    { 0x34, 0x00, 0x00, 0x00, 0x00 },
    { 0x29, 0x00, 0x00, 0x00, 0x00 },
    { 0x59, 0x00, 0x00, 0x00, 0x00 },
    { 0x55, 0x00, 0x00, 0x00, 0x00 },
    { 0x50, 0x00, 0x00, 0x00, 0x00 },
    { 0x4D, 0x00, 0x00, 0x00, 0x00 },
    { 0x4A, 0x00, 0x00, 0x00, 0x00 },
    { 0x48, 0x00, 0x00, 0x00, 0x00 },
    { 0x46, 0x00, 0x00, 0x00, 0x00 },
    { 0x46, 0x00, 0x00, 0x00, 0x00 }
};


/* Transmit Waveform Values for T1 Short Haul (110 - 220 ft.)
 * unsigned char t1_tx_waveform_sh_220ft[LAST_SAMPLE-FIRST_SAMPLE+1][LAST_UI-FIRST_UI+1] = 
 */
TX_WAVEFORM t1_tx_waveform_sh_220ft = 
{
    { 0x00, 0x44, 0x00, 0x00, 0x00 },
    { 0x0A, 0x44, 0x00, 0x00, 0x00 },
    { 0x3F, 0x43, 0x00, 0x00, 0x00 },
    { 0x3F, 0x43, 0x00, 0x00, 0x00 },
    { 0x36, 0x42, 0x00, 0x00, 0x00 },
    { 0x34, 0x42, 0x00, 0x00, 0x00 },
    { 0x30, 0x41, 0x00, 0x00, 0x00 },
    { 0x2F, 0x41, 0x00, 0x00, 0x00 },
    { 0x2E, 0x00, 0x00, 0x00, 0x00 },
    { 0x2D, 0x00, 0x00, 0x00, 0x00 },
    { 0x2C, 0x00, 0x00, 0x00, 0x00 },
    { 0x2B, 0x00, 0x00, 0x00, 0x00 },
    { 0x2A, 0x00, 0x00, 0x00, 0x00 },
    { 0x28, 0x00, 0x00, 0x00, 0x00 },
    { 0x26, 0x00, 0x00, 0x00, 0x00 },
    { 0x4A, 0x00, 0x00, 0x00, 0x00 },
    { 0x68, 0x00, 0x00, 0x00, 0x00 },
    { 0x54, 0x00, 0x00, 0x00, 0x00 },
    { 0x4F, 0x00, 0x00, 0x00, 0x00 },
    { 0x4A, 0x00, 0x00, 0x00, 0x00 },
    { 0x49, 0x00, 0x00, 0x00, 0x00 },
    { 0x47, 0x00, 0x00, 0x00, 0x00 },
    { 0x47, 0x00, 0x00, 0x00, 0x00 },
    { 0x46, 0x00, 0x00, 0x00, 0x00 }
};


/* Transmit Waveform Values for T1 Short Haul (220 - 330 ft.)
 * unsigned char t1_tx_waveform_sh_330ft[LAST_SAMPLE-FIRST_SAMPLE+1][LAST_UI-FIRST_UI+1] = 
 */
TX_WAVEFORM t1_tx_waveform_sh_330ft = 
{
    { 0x00, 0x44, 0x00, 0x00, 0x00 },
    { 0x0A, 0x44, 0x00, 0x00, 0x00 },
    { 0x3F, 0x43, 0x00, 0x00, 0x00 },
    { 0x3A, 0x43, 0x00, 0x00, 0x00 },
    { 0x3A, 0x42, 0x00, 0x00, 0x00 },
    { 0x38, 0x42, 0x00, 0x00, 0x00 },
    { 0x30, 0x41, 0x00, 0x00, 0x00 },
    { 0x2F, 0x41, 0x00, 0x00, 0x00 },
    { 0x2E, 0x00, 0x00, 0x00, 0x00 },
    { 0x2D, 0x00, 0x00, 0x00, 0x00 },
    { 0x2C, 0x00, 0x00, 0x00, 0x00 },
    { 0x2B, 0x00, 0x00, 0x00, 0x00 },
    { 0x2A, 0x00, 0x00, 0x00, 0x00 },
    { 0x29, 0x00, 0x00, 0x00, 0x00 },
    { 0x23, 0x00, 0x00, 0x00, 0x00 },
    { 0x4A, 0x00, 0x00, 0x00, 0x00 },
    { 0x6C, 0x00, 0x00, 0x00, 0x00 },
    { 0x60, 0x00, 0x00, 0x00, 0x00 },
    { 0x4F, 0x00, 0x00, 0x00, 0x00 },
    { 0x4A, 0x00, 0x00, 0x00, 0x00 },
    { 0x49, 0x00, 0x00, 0x00, 0x00 },
    { 0x47, 0x00, 0x00, 0x00, 0x00 },
    { 0x47, 0x00, 0x00, 0x00, 0x00 },
    { 0x46, 0x00, 0x00, 0x00, 0x00 }
};


/* Transmit Waveform Values for T1 Short Haul (330 - 440 ft.)
 * unsigned char t1_tx_waveform_sh_440ft[LAST_SAMPLE-FIRST_SAMPLE+1][LAST_UI-FIRST_UI+1] = 
 */
TX_WAVEFORM t1_tx_waveform_sh_440ft = 
{
    { 0x00, 0x44, 0x00, 0x00, 0x00 },
    { 0x0A, 0x44, 0x00, 0x00, 0x00 },
    { 0x3F, 0x43, 0x00, 0x00, 0x00 },
    { 0x3F, 0x43, 0x00, 0x00, 0x00 },
    { 0x3F, 0x42, 0x00, 0x00, 0x00 },
    { 0x3F, 0x42, 0x00, 0x00, 0x00 },
    { 0x2F, 0x41, 0x00, 0x00, 0x00 },
    { 0x2E, 0x41, 0x00, 0x00, 0x00 },
    { 0x2D, 0x00, 0x00, 0x00, 0x00 },
    { 0x2C, 0x00, 0x00, 0x00, 0x00 },
    { 0x2B, 0x00, 0x00, 0x00, 0x00 },
    { 0x2A, 0x00, 0x00, 0x00, 0x00 },
    { 0x29, 0x00, 0x00, 0x00, 0x00 },
    { 0x28, 0x00, 0x00, 0x00, 0x00 },
    { 0x19, 0x00, 0x00, 0x00, 0x00 },
    { 0x4A, 0x00, 0x00, 0x00, 0x00 },
    { 0x7F, 0x00, 0x00, 0x00, 0x00 },
    { 0x60, 0x00, 0x00, 0x00, 0x00 },
    { 0x4F, 0x00, 0x00, 0x00, 0x00 },
    { 0x4A, 0x00, 0x00, 0x00, 0x00 },
    { 0x49, 0x00, 0x00, 0x00, 0x00 },
    { 0x47, 0x00, 0x00, 0x00, 0x00 },
    { 0x47, 0x00, 0x00, 0x00, 0x00 },
    { 0x46, 0x00, 0x00, 0x00, 0x00 }
};


/* Transmit Waveform Values for T1 Short Haul (440 - 550 ft.)
 * unsigned char t1_tx_waveform_sh_550ft[LAST_SAMPLE-FIRST_SAMPLE+1][LAST_UI-FIRST_UI+1] = 
 */
TX_WAVEFORM t1_tx_waveform_sh_550ft = 
{
    { 0x00, 0x44, 0x00, 0x00, 0x00 },
    { 0x0A, 0x44, 0x00, 0x00, 0x00 },
    { 0x3F, 0x43, 0x00, 0x00, 0x00 },
    { 0x3F, 0x43, 0x00, 0x00, 0x00 },
    { 0x3F, 0x42, 0x00, 0x00, 0x00 },
    { 0x3F, 0x42, 0x00, 0x00, 0x00 },
    { 0x30, 0x41, 0x00, 0x00, 0x00 },
    { 0x2B, 0x41, 0x00, 0x00, 0x00 },
    { 0x2A, 0x00, 0x00, 0x00, 0x00 },
    { 0x29, 0x00, 0x00, 0x00, 0x00 },
    { 0x28, 0x00, 0x00, 0x00, 0x00 },
    { 0x27, 0x00, 0x00, 0x00, 0x00 },
    { 0x26, 0x00, 0x00, 0x00, 0x00 },
    { 0x26, 0x00, 0x00, 0x00, 0x00 },
    { 0x24, 0x00, 0x00, 0x00, 0x00 },
    { 0x4A, 0x00, 0x00, 0x00, 0x00 },
    { 0x7F, 0x00, 0x00, 0x00, 0x00 },
    { 0x7F, 0x00, 0x00, 0x00, 0x00 },
    { 0x4F, 0x00, 0x00, 0x00, 0x00 },
    { 0x4A, 0x00, 0x00, 0x00, 0x00 },
    { 0x49, 0x00, 0x00, 0x00, 0x00 },
    { 0x47, 0x00, 0x00, 0x00, 0x00 },
    { 0x47, 0x00, 0x00, 0x00, 0x00 },
    { 0x46, 0x00, 0x00, 0x00, 0x00 }
};


/* Transmit Waveform Values for T1 Short Haul (550 - 660 ft.)
 * unsigned char t1_tx_waveform_sh_660ft[LAST_SAMPLE-FIRST_SAMPLE+1][LAST_UI-FIRST_UI+1] = 
 */
TX_WAVEFORM t1_tx_waveform_sh_660ft = 
{
    { 0x00, 0x44, 0x00, 0x00, 0x00 },
    { 0x0A, 0x44, 0x00, 0x00, 0x00 },
    { 0x3F, 0x43, 0x00, 0x00, 0x00 },
    { 0x3F, 0x43, 0x00, 0x00, 0x00 },
    { 0x3F, 0x42, 0x00, 0x00, 0x00 },
    { 0x3F, 0x42, 0x00, 0x00, 0x00 },
    { 0x3F, 0x41, 0x00, 0x00, 0x00 },
    { 0x30, 0x41, 0x00, 0x00, 0x00 },
    { 0x2A, 0x00, 0x00, 0x00, 0x00 },
    { 0x29, 0x00, 0x00, 0x00, 0x00 },
    { 0x28, 0x00, 0x00, 0x00, 0x00 },
    { 0x27, 0x00, 0x00, 0x00, 0x00 },
    { 0x26, 0x00, 0x00, 0x00, 0x00 },
    { 0x25, 0x00, 0x00, 0x00, 0x00 },
    { 0x24, 0x00, 0x00, 0x00, 0x00 },
    { 0x4A, 0x00, 0x00, 0x00, 0x00 },
    { 0x7F, 0x00, 0x00, 0x00, 0x00 },
    { 0x7F, 0x00, 0x00, 0x00, 0x00 },
    { 0x5F, 0x00, 0x00, 0x00, 0x00 },
    { 0x50, 0x00, 0x00, 0x00, 0x00 },
    { 0x49, 0x00, 0x00, 0x00, 0x00 },
    { 0x47, 0x00, 0x00, 0x00, 0x00 },
    { 0x47, 0x00, 0x00, 0x00, 0x00 },
    { 0x46, 0x00, 0x00, 0x00, 0x00 }
};


/* Transmit Waveform Values for E1 120 Ohm
 * unsigned char e1_tx_waveform_120[LAST_SAMPLE-FIRST_SAMPLE+1][LAST_UI-FIRST_UI+1] = 
 */
TX_WAVEFORM e1_tx_waveform_120 = 
{
    { 0x00, 0x00, 0x00, 0x00, 0x00 },
    { 0x00, 0x00, 0x00, 0x00, 0x00 },
    { 0x0A, 0x00, 0x00, 0x00, 0x00 },
    { 0x3F, 0x00, 0x00, 0x00, 0x00 },
    { 0x3F, 0x00, 0x00, 0x00, 0x00 },
    { 0x39, 0x00, 0x00, 0x00, 0x00 },
    { 0x38, 0x00, 0x00, 0x00, 0x00 },
    { 0x36, 0x00, 0x00, 0x00, 0x00 },
    { 0x36, 0x00, 0x00, 0x00, 0x00 },
    { 0x35, 0x00, 0x00, 0x00, 0x00 },
    { 0x35, 0x00, 0x00, 0x00, 0x00 },
    { 0x35, 0x00, 0x00, 0x00, 0x00 },
    { 0x35, 0x00, 0x00, 0x00, 0x00 },
    { 0x35, 0x00, 0x00, 0x00, 0x00 },
    { 0x35, 0x00, 0x00, 0x00, 0x00 },
    { 0x2D, 0x00, 0x00, 0x00, 0x00 },
    { 0x00, 0x00, 0x00, 0x00, 0x00 },
    { 0x00, 0x00, 0x00, 0x00, 0x00 },
    { 0x00, 0x00, 0x00, 0x00, 0x00 },
    { 0x00, 0x00, 0x00, 0x00, 0x00 },
    { 0x00, 0x00, 0x00, 0x00, 0x00 },
    { 0x00, 0x00, 0x00, 0x00, 0x00 },
    { 0x00, 0x00, 0x00, 0x00, 0x00 },
    { 0x00, 0x00, 0x00, 0x00, 0x00 }
};


/* Transmit Waveform Values for E1 75 Ohm
 * unsigned char e1_tx_waveform_75[LAST_SAMPLE-FIRST_SAMPLE+1][LAST_UI-FIRST_UI+1] = 
 */
TX_WAVEFORM e1_tx_waveform_75 = 
{
    { 0x00, 0x00, 0x00, 0x00, 0x00 },
    { 0x00, 0x00, 0x00, 0x00, 0x00 },
    { 0x0A, 0x00, 0x00, 0x00, 0x00 },
    { 0x28, 0x00, 0x00, 0x00, 0x00 },
    { 0x3A, 0x00, 0x00, 0x00, 0x00 },
    { 0x3A, 0x00, 0x00, 0x00, 0x00 },
    { 0x3A, 0x00, 0x00, 0x00, 0x00 },
    { 0x3A, 0x00, 0x00, 0x00, 0x00 },
    { 0x3A, 0x00, 0x00, 0x00, 0x00 },
    { 0x3A, 0x00, 0x00, 0x00, 0x00 },
    { 0x3A, 0x00, 0x00, 0x00, 0x00 },
    { 0x3A, 0x00, 0x00, 0x00, 0x00 },
    { 0x3A, 0x00, 0x00, 0x00, 0x00 },
    { 0x3A, 0x00, 0x00, 0x00, 0x00 },
    { 0x32, 0x00, 0x00, 0x00, 0x00 },
    { 0x14, 0x00, 0x00, 0x00, 0x00 },
    { 0x00, 0x00, 0x00, 0x00, 0x00 },
    { 0x00, 0x00, 0x00, 0x00, 0x00 },
    { 0x00, 0x00, 0x00, 0x00, 0x00 },
    { 0x00, 0x00, 0x00, 0x00, 0x00 },
    { 0x00, 0x00, 0x00, 0x00, 0x00 },
    { 0x00, 0x00, 0x00, 0x00, 0x00 },
    { 0x00, 0x00, 0x00, 0x00, 0x00 },
    { 0x00, 0x00, 0x00, 0x00, 0x00 }
};


RLPS_EQUALIZER_RAM t1_rlps_ram_table[] = 
{
    { 0x03, 0xFE, 0x18, 0x40 },
    { 0x03, 0xF6, 0x18, 0x40 },
    { 0x03, 0xEE, 0x18, 0x40 },
    { 0x03, 0xE6, 0x18, 0x40 },
    { 0x03, 0xDE, 0x18, 0x40 },
    { 0x03, 0xD6, 0x18, 0x40 },
    { 0x03, 0xD6, 0x18, 0x40 },
    { 0x03, 0xD6, 0x18, 0x40 },
    { 0x03, 0xCE, 0x18, 0x40 },
    { 0x03, 0xCE, 0x18, 0x40 },
    { 0x03, 0xCE, 0x18, 0x40 },
    { 0x03, 0xCE, 0x18, 0x40 },
    { 0x03, 0xC6, 0x18, 0x40 },
    { 0x03, 0xC6, 0x18, 0x40 },
    { 0x03, 0xC6, 0x18, 0x40 },
    { 0x0B, 0xBE, 0x18, 0x40 },
    { 0x0B, 0xBE, 0x18, 0x40 },
    { 0x0B, 0xBE, 0x18, 0x40 },
    { 0x0B, 0xBE, 0x18, 0x40 },
    { 0x0B, 0xB6, 0x18, 0x40 },
    { 0x0B, 0xB6, 0x18, 0x40 },
    { 0x0B, 0xB6, 0x18, 0x40 },
    { 0x0B, 0xB6, 0x18, 0x40 },
    { 0x13, 0xAE, 0x18, 0x38 },
    { 0x13, 0xAE, 0x18, 0x3C },
    { 0x13, 0xAE, 0x18, 0x40 },
    { 0x13, 0xAE, 0x18, 0x40 },
    { 0x13, 0xAE, 0x18, 0x40 },
    { 0x13, 0xAE, 0x18, 0x40 },
    { 0x1B, 0xB6, 0x18, 0xB8 },
    { 0x1B, 0xAE, 0x18, 0xB8 },
    { 0x1B, 0xAE, 0x18, 0xBC },
    { 0x1B, 0xAE, 0x18, 0xC0 },
    { 0x1B, 0xAE, 0x18, 0xC0 },
    { 0x23, 0xA6, 0x18, 0xC0 },
    { 0x23, 0xA6, 0x18, 0xC0 },
    { 0x23, 0xA6, 0x18, 0xC0 },
    { 0x23, 0xA6, 0x18, 0xC0 },
    { 0x23, 0xA6, 0x18, 0xC0 },
    { 0x23, 0x9E, 0x18, 0xC0 },
    { 0x23, 0x9E, 0x18, 0xC0 },
    { 0x23, 0x9E, 0x18, 0xC0 },
    { 0x23, 0x9E, 0x18, 0xC0 },
    { 0x23, 0x9E, 0x18, 0xC0 },
    { 0x2B, 0x96, 0x18, 0xC0 },
    { 0x2B, 0x96, 0x18, 0xC0 },
    { 0x2B, 0x96, 0x18, 0xC0 },
    { 0x33, 0x96, 0x19, 0x40 },
    { 0x37, 0x96, 0x19, 0x40 },
    { 0x37, 0x96, 0x19, 0x40 },
    { 0x37, 0x96, 0x19, 0x40 },
    { 0x3F, 0x9E, 0x19, 0xC0 },
    { 0x3F, 0x9E, 0x19, 0xC0 },
    { 0x3F, 0x9E, 0x19, 0xC0 },
    { 0x3F, 0xA6, 0x1A, 0x40 },
    { 0x3F, 0xA6, 0x1A, 0x40 },
    { 0x3F, 0xA6, 0x1A, 0x40 },
    { 0x3F, 0xA6, 0x1A, 0x40 },
    { 0x3F, 0x96, 0x19, 0xC0 },
    { 0x3F, 0x96, 0x19, 0xC0 },
    { 0x3F, 0x96, 0x19, 0xC0 },
    { 0x3F, 0x96, 0x19, 0xC0 },
    { 0x47, 0x9E, 0x1A, 0x40 },
    { 0x47, 0x9E, 0x1A, 0x40 },
    { 0x47, 0x9E, 0x1A, 0x40 },
    { 0x47, 0x96, 0x1A, 0x40 },
    { 0x47, 0x96, 0x1A, 0x40 },
    { 0x47, 0x96, 0x1A, 0x40 },
    { 0x47, 0x96, 0x1A, 0x40 },
    { 0x4F, 0x8E, 0x1A, 0x40 },
    { 0x4F, 0x8E, 0x1A, 0x40 },
    { 0x4F, 0x8E, 0x1A, 0x40 },
    { 0x4F, 0x8E, 0x1A, 0x40 },
    { 0x4F, 0x8E, 0x1A, 0x40 },
    { 0x57, 0x86, 0x1A, 0x40 },
    { 0x57, 0x86, 0x1A, 0x40 },
    { 0x57, 0x86, 0x1A, 0x40 },
    { 0x57, 0x86, 0x1A, 0x40 },
    { 0x57, 0x86, 0x1A, 0x40 },
    { 0x5F, 0x86, 0x1A, 0xC0 },
    { 0x5F, 0x86, 0x1A, 0xC0 },
    { 0x5F, 0x86, 0x1A, 0xC0 },
    { 0x5F, 0x86, 0x1A, 0xC0 },
    { 0x5F, 0x86, 0x1A, 0xC0 },
    { 0x5F, 0x86, 0x1A, 0xC0 },
    { 0x5F, 0x7E, 0x1A, 0xC0 },
    { 0x5F, 0x7E, 0x1A, 0xC0 },
    { 0x5F, 0x7E, 0x1A, 0xC0 },
    { 0x5F, 0x7E, 0x1A, 0xC0 },
    { 0x5F, 0x7E, 0x1A, 0xC0 },
    { 0x67, 0x7E, 0x2A, 0xC0 },
    { 0x67, 0x7E, 0x2A, 0xC0 },
    { 0x67, 0x7E, 0x2A, 0xC0 },
    { 0x67, 0x7E, 0x2A, 0xC0 },
    { 0x67, 0x76, 0x2A, 0xC0 },
    { 0x67, 0x76, 0x2A, 0xC0 },
    { 0x67, 0x76, 0x2A, 0xC0 },
    { 0x67, 0x76, 0x2A, 0xC0 },
    { 0x67, 0x76, 0x2A, 0xC0 },
    { 0x6F, 0x6E, 0x2A, 0xC0 },
    { 0x6F, 0x6E, 0x2A, 0xC0 },
    { 0x6F, 0x6E, 0x2A, 0xC0 },
    { 0x6F, 0x6E, 0x2A, 0xC0 },
    { 0x77, 0x6E, 0x3A, 0xC0 },
    { 0x77, 0x6E, 0x3A, 0xC0 },
    { 0x77, 0x6E, 0x3A, 0xC0 },
    { 0x77, 0x6E, 0x3A, 0xC0 },
    { 0x7F, 0x66, 0x3A, 0xC0 },
    { 0x7F, 0x66, 0x3A, 0xC0 },
    { 0x7F, 0x66, 0x4A, 0xC0 },
    { 0x7F, 0x66, 0x4A, 0xC0 },
    { 0x7F, 0x66, 0x4A, 0xC0 },
    { 0x7F, 0x66, 0x4A, 0xC0 },
    { 0x87, 0x66, 0x5A, 0xC0 },
    { 0x87, 0x66, 0x5A, 0xC0 },
    { 0x87, 0x66, 0x5A, 0xC0 },
    { 0x87, 0x66, 0x5A, 0xC0 },
    { 0x87, 0x66, 0x5A, 0xC0 },
    { 0x87, 0x5E, 0x5A, 0xC0 },
    { 0x87, 0x5E, 0x5A, 0xC0 },
    { 0x87, 0x5E, 0x5A, 0xC0 },
    { 0x87, 0x5E, 0x5A, 0xC0 },
    { 0x87, 0x5E, 0x5A, 0xC0 },
    { 0x8F, 0x5E, 0x6A, 0xC0 },
    { 0x8F, 0x5E, 0x6A, 0xC0 },
    { 0x8F, 0x5E, 0x6A, 0xC0 },
    { 0x8F, 0x5E, 0x6A, 0xC0 },
    { 0x97, 0x5E, 0x7A, 0xC0 },
    { 0x97, 0x5E, 0x7A, 0xC0 },
    { 0x97, 0x5E, 0x7A, 0xC0 },
    { 0x97, 0x5E, 0x7A, 0xC0 },
    { 0x9F, 0x5E, 0x8A, 0xC0 },
    { 0x9F, 0x5E, 0x8A, 0xC0 },
    { 0x9F, 0x5E, 0x8A, 0xC0 },
    { 0x9F, 0x5E, 0x8A, 0xC0 },
    { 0x9F, 0x5E, 0x8A, 0xC0 },
    { 0xA7, 0x56, 0x9A, 0xC0 },
    { 0xA7, 0x56, 0x9A, 0xC0 },
    { 0xA7, 0x56, 0x9A, 0xC0 },
    { 0xA7, 0x56, 0x9A, 0xC0 },
    { 0xA7, 0x56, 0xAA, 0xC0 },
    { 0xA7, 0x56, 0xAA, 0xC0 },
    { 0xA7, 0x56, 0xAA, 0xC0 },
    { 0xAF, 0x4E, 0xAA, 0xC0 },
    { 0xAF, 0x4E, 0xAA, 0xC0 },
    { 0xAF, 0x4E, 0xAA, 0xC0 },
    { 0xAF, 0x4E, 0xAA, 0xC0 },
    { 0xAF, 0x4E, 0xAA, 0xC0 },
    { 0xB7, 0x46, 0xAA, 0xC0 },
    { 0xB7, 0x46, 0xAA, 0xC0 },
    { 0xB7, 0x46, 0xAA, 0xC0 },
    { 0xB7, 0x46, 0xAA, 0xC0 },
    { 0xB7, 0x46, 0xAA, 0xC0 },
    { 0xB7, 0x46, 0xAA, 0xC0 },
    { 0xB7, 0x46, 0xAA, 0xC0 },
    { 0xB7, 0x46, 0xBA, 0xC0 },
    { 0xB7, 0x46, 0xBA, 0xC0 },
    { 0xB7, 0x46, 0xBA, 0xC0 },
    { 0xBF, 0x4E, 0xBB, 0x40 },
    { 0xBF, 0x4E, 0xBB, 0x40 },
    { 0xBF, 0x4E, 0xBB, 0x40 },
    { 0xBF, 0x4E, 0xBB, 0x40 },
    { 0xBF, 0x4E, 0xBB, 0x40 },
    { 0xBF, 0x4E, 0xBB, 0x40 },
    { 0xBF, 0x4E, 0xBB, 0x40 },
    { 0xBF, 0x4E, 0xBB, 0x40 },
    { 0xBF, 0x4E, 0xBB, 0x40 },
    { 0xBE, 0x46, 0xCB, 0x40 },
    { 0xBE, 0x46, 0xCB, 0x40 },
    { 0xBE, 0x46, 0xCB, 0x40 },
    { 0xBE, 0x46, 0xCB, 0x40 },
    { 0xBE, 0x46, 0xCB, 0x40 },
    { 0xBE, 0x46, 0xCB, 0x40 },
    { 0xBE, 0x46, 0xDB, 0x40 },
    { 0xBE, 0x46, 0xDB, 0x40 },
    { 0xBE, 0x46, 0xDB, 0x40 },
    { 0xC6, 0x3E, 0xCB, 0x40 },
    { 0xC6, 0x3E, 0xCB, 0x40 },
    { 0xC6, 0x3E, 0xDB, 0x40 },
    { 0xC6, 0x3E, 0xDB, 0x40 },
    { 0xC6, 0x3E, 0xDB, 0x40 },
    { 0xC6, 0x44, 0xDB, 0x40 },
    { 0xC6, 0x44, 0xDB, 0x40 },
    { 0xC6, 0x44, 0xDB, 0x40 },
    { 0xC6, 0x44, 0xDB, 0x40 },
    { 0xC6, 0x3C, 0xDB, 0x40 },
    { 0xC6, 0x3C, 0xDB, 0x40 },
    { 0xC6, 0x3C, 0xDB, 0x40 },
    { 0xC6, 0x3C, 0xDB, 0x40 },
    { 0xD6, 0x34, 0xDB, 0x40 },
    { 0xD6, 0x34, 0xDB, 0x40 },
    { 0xD6, 0x34, 0xDB, 0x40 },
    { 0xD6, 0x34, 0xDB, 0x40 },
    { 0xD6, 0x34, 0xDB, 0x40 },
    { 0xDE, 0x2C, 0xDB, 0x3C },
    { 0xDE, 0x2C, 0xDB, 0x3C },
    { 0xDE, 0x2C, 0xDB, 0x3C },
    { 0xE6, 0x2C, 0xDB, 0x40 },
    { 0xE6, 0x2C, 0xDB, 0x40 },
    { 0xE6, 0x2C, 0xDB, 0x40 },
    { 0xE6, 0x2C, 0xDB, 0x40 },
    { 0xE6, 0x2C, 0xDB, 0x40 },
    { 0xE6, 0x2C, 0xEB, 0x40 },
    { 0xE6, 0x2C, 0xEB, 0x40 },
    { 0xE6, 0x2C, 0xEB, 0x40 },
    { 0xEE, 0x2C, 0xFB, 0x40 },
    { 0xEE, 0x2C, 0xFB, 0x40 },
    { 0xEE, 0x2C, 0xFB, 0x40 },
    { 0xEE, 0x2D, 0x0B, 0x40 },
    { 0xEE, 0x2D, 0x0B, 0x40 },
    { 0xEE, 0x2D, 0x0B, 0x40 },
    { 0xEE, 0x2D, 0x0B, 0x40 },
    { 0xEE, 0x2D, 0x0B, 0x40 },
    { 0xF5, 0x25, 0x0B, 0x38 },
    { 0xF5, 0x25, 0x0B, 0x3C },
    { 0xF5, 0x25, 0x0B, 0x40 },
    { 0xF5, 0x25, 0x1B, 0x40 },
    { 0xF5, 0x25, 0x1B, 0x40 },
    { 0xF5, 0x25, 0x1B, 0x40 },
    { 0xF5, 0x25, 0x1B, 0x40 },
    { 0xF5, 0x25, 0x1B, 0x40 },
    { 0xFD, 0x25, 0x2B, 0x40 },
    { 0xFD, 0x25, 0x2B, 0x40 },
    { 0xFD, 0x25, 0x2B, 0x40 },
    { 0xFD, 0x25, 0x2B, 0x40 },
    { 0xFD, 0x25, 0x27, 0x40 },
    { 0xFD, 0x25, 0x27, 0x40 },
    { 0xFD, 0x25, 0x27, 0x40 },
    { 0xFD, 0x25, 0x23, 0x40 },
    { 0xFD, 0x25, 0x23, 0x40 },
    { 0xFD, 0x25, 0x23, 0x40 },
    { 0xFD, 0x25, 0x33, 0x40 },
    { 0xFD, 0x25, 0x33, 0x40 },
    { 0xFD, 0x25, 0x33, 0x40 },
    { 0xFD, 0x25, 0x33, 0x40 },
    { 0xFD, 0x25, 0x33, 0x40 },
    { 0xFD, 0x25, 0x33, 0x40 },
    { 0xFC, 0x25, 0x33, 0x40 },
    { 0xFC, 0x25, 0x33, 0x40 },
    { 0xFC, 0x25, 0x43, 0x40 },
    { 0xFC, 0x25, 0x43, 0x40 },
    { 0xFC, 0x25, 0x43, 0x40 },
    { 0xFC, 0x25, 0x43, 0x44 },
    { 0xFC, 0x25, 0x43, 0x48 },
    { 0xFC, 0x25, 0x43, 0x4C },
    { 0xFC, 0x25, 0x43, 0xBC },
    { 0xFC, 0x25, 0x43, 0xC0 },
    { 0xFC, 0x25, 0x43, 0xC0 },
    { 0xFC, 0x23, 0x43, 0xC0 },
    { 0xFC, 0x23, 0x43, 0xC0 },
    { 0xFC, 0x23, 0x43, 0xC0 },
    { 0xFC, 0x21, 0x43, 0xC0 },
    { 0xFC, 0x21, 0x43, 0xC0 },
    { 0xFC, 0x21, 0x53, 0xC0 },
    { 0xFC, 0x21, 0x53, 0xC0 },
    { 0xFC, 0x21, 0x53, 0xC0 }
};

RLPS_EQUALIZER_RAM e1_rlps_ram_table[] = 
{
    { 0x07, 0xDE, 0x18, 0x2C },
    { 0x07, 0xDE, 0x18, 0x2C },
    { 0x07, 0xD6, 0x18, 0x2C },
    { 0x07, 0xD6, 0x18, 0x2C },
    { 0x07, 0xD6, 0x18, 0x2C },
    { 0x07, 0xCE, 0x18, 0x2C },
    { 0x07, 0xCE, 0x18, 0x2C },
    { 0x07, 0xCE, 0x18, 0x2C },
    { 0x07, 0xC6, 0x18, 0x2C },
    { 0x07, 0xC6, 0x18, 0x2C },
    { 0x07, 0xC6, 0x18, 0x2C },
    { 0x07, 0xBE, 0x18, 0x2C },
    { 0x07, 0xBE, 0x18, 0x2C },
    { 0x07, 0xBE, 0x18, 0x2C },
    { 0x07, 0xBE, 0x18, 0x2C },
    { 0x07, 0xBE, 0x18, 0x2C },
    { 0x07, 0xB6, 0x18, 0x2C },
    { 0x07, 0xB6, 0x18, 0x2C },
    { 0x07, 0xB6, 0x18, 0x2C },
    { 0x07, 0xB6, 0x18, 0x2C },
    { 0x07, 0xB6, 0x18, 0x2C },
    { 0x07, 0xAE, 0x18, 0x2C },
    { 0x07, 0xAE, 0x18, 0x2C },
    { 0x07, 0xAE, 0x18, 0x2C },
    { 0x07, 0xAE, 0x18, 0x2C },
    { 0x07, 0xAE, 0x18, 0x2C },
    { 0x07, 0xB6, 0x18, 0xAC },
    { 0x07, 0xAE, 0x18, 0xAC },
    { 0x07, 0xAE, 0x18, 0xAC },
    { 0x07, 0xAE, 0x18, 0xAC },
    { 0x07, 0xAE, 0x18, 0xAC },
    { 0x07, 0xA6, 0x18, 0xAC },
    { 0x07, 0xA6, 0x18, 0xAC },
    { 0x07, 0xA6, 0x18, 0xAC },
    { 0x07, 0xA6, 0x18, 0xAC },
    { 0x07, 0x9E, 0x18, 0xAC },
    { 0x07, 0xA6, 0x19, 0x2C },
    { 0x07, 0xA6, 0x19, 0x2C },
    { 0x07, 0xA6, 0x19, 0x2C },
    { 0x0F, 0xA6, 0x19, 0x2C },
    { 0x0F, 0xA6, 0x19, 0x2C },
    { 0x0F, 0x9E, 0x19, 0x2C },
    { 0x0F, 0x9E, 0x19, 0x2C },
    { 0x0F, 0x9E, 0x19, 0x2C },
    { 0x17, 0x9E, 0x19, 0x2C },
    { 0x17, 0xA6, 0x19, 0xAC },
    { 0x17, 0x9E, 0x19, 0xAC },
    { 0x17, 0x9E, 0x19, 0xAC },
    { 0x17, 0x96, 0x19, 0xAC },
    { 0x1F, 0x96, 0x19, 0xAC },
    { 0x1F, 0x96, 0x19, 0xAC },
    { 0x1F, 0x8E, 0x19, 0xAC },
    { 0x1F, 0x8E, 0x19, 0xAC },
    { 0x1F, 0x8E, 0x19, 0xAC },
    { 0x27, 0x8E, 0x19, 0xAC },
    { 0x27, 0x8E, 0x1A, 0x2C },
    { 0x27, 0x8E, 0x1A, 0x2C },
    { 0x27, 0x8E, 0x1A, 0x2C },
    { 0x27, 0x8E, 0x1A, 0x2C },
    { 0x2F, 0x86, 0x1A, 0x2C },
    { 0x2F, 0x86, 0x1A, 0x2C },
    { 0x2F, 0x86, 0x1A, 0x2C },
    { 0x2F, 0x7E, 0x1A, 0x2C },
    { 0x2F, 0x7E, 0x1A, 0x2C },
    { 0x2F, 0x7E, 0x1A, 0x2C },
    { 0x37, 0x7E, 0x1A, 0x2C },
    { 0x37, 0x7E, 0x1A, 0xAC },
    { 0x37, 0x7E, 0x1A, 0xAC },
    { 0x37, 0x7E, 0x1A, 0xAC },
    { 0x37, 0x7E, 0x1A, 0xAC },
    { 0x3F, 0x7E, 0x2A, 0xAC },
    { 0x3F, 0x7E, 0x2A, 0xAC },
    { 0x3F, 0x76, 0x2A, 0xAC },
    { 0x3F, 0x86, 0x2B, 0x2C },
    { 0x3F, 0x7E, 0x2B, 0x2C },
    { 0x47, 0x7E, 0x2B, 0x2C },
    { 0x47, 0x7E, 0x2F, 0x2C },
    { 0x47, 0x7E, 0x2F, 0x2C },
    { 0x47, 0x7E, 0x2F, 0x2C },
    { 0x47, 0x76, 0x2F, 0x2C },
    { 0x4F, 0x76, 0x2F, 0x2C },
    { 0x4F, 0x76, 0x2F, 0x2C },
    { 0x4F, 0x6E, 0x2F, 0x2C },
    { 0x4F, 0x6E, 0x2F, 0x2C },
    { 0x4F, 0x6E, 0x2F, 0x2C },
    { 0x57, 0x6E, 0x2F, 0x2C },
    { 0x57, 0x6E, 0x2F, 0x2C },
    { 0x57, 0x6E, 0x3F, 0x2C },
    { 0x57, 0x6E, 0x3F, 0x2C },
    { 0x57, 0x6E, 0x3F, 0x2C },
    { 0x5F, 0x6E, 0x3F, 0x2C },
    { 0x5F, 0x6E, 0x4F, 0x2C },
    { 0x5F, 0x6E, 0x4F, 0x2C },
    { 0x5F, 0x6E, 0x4F, 0x2C },
    { 0x5F, 0x66, 0x4F, 0x2C },
    { 0x67, 0x66, 0x4F, 0x2C },
    { 0x67, 0x66, 0x4F, 0x2C },
    { 0x67, 0x5E, 0x4F, 0x2C },
    { 0x67, 0x5E, 0x4F, 0x2C },
    { 0x67, 0x66, 0x4F, 0x2C },
    { 0x67, 0x66, 0x4F, 0x2C },
    { 0x67, 0x66, 0x5F, 0x2C },
    { 0x6F, 0x6E, 0x5F, 0x2C },
    { 0x6F, 0x6E, 0x6F, 0x2C },
    { 0x6F, 0x6E, 0x6F, 0x2C },
    { 0x6F, 0x6E, 0x7F, 0x2C },
    { 0x6F, 0x6E, 0x7F, 0x2C },
    { 0x6F, 0x6E, 0x7F, 0x2C },
    { 0x77, 0x66, 0x7F, 0x2C },
    { 0x77, 0x66, 0x7F, 0x2C },
    { 0x77, 0x5E, 0x6F, 0x2C },
    { 0x77, 0x5E, 0x7F, 0x2C },
    { 0x77, 0x5E, 0x7F, 0x2C },
    { 0x7F, 0x5E, 0x7F, 0x2C },
    { 0x7F, 0x5E, 0x8F, 0x2C },
    { 0x7F, 0x5E, 0x8F, 0x2C },
    { 0x7F, 0x5E, 0x8F, 0x2C },
    { 0x87, 0x56, 0x8F, 0x2C },
    { 0x87, 0x56, 0x8F, 0x2C },
    { 0x87, 0x56, 0x8F, 0x2C },
    { 0x87, 0x4E, 0x8F, 0x2C },
    { 0x87, 0x4E, 0x8F, 0x2C },
    { 0x87, 0x4E, 0x8F, 0x2C },
    { 0x8F, 0x4E, 0x9F, 0x2C },
    { 0x8F, 0x4E, 0x9F, 0x2C },
    { 0x8F, 0x4E, 0xAF, 0x2C },
    { 0x8F, 0x4E, 0xAF, 0x2C },
    { 0x8F, 0x4E, 0xAF, 0x2C },
    { 0x97, 0x4E, 0xAF, 0x2C },
    { 0x97, 0x4E, 0xAF, 0x2C },
    { 0x97, 0x4E, 0xAB, 0x2C },
    { 0x97, 0x4E, 0xAB, 0x2C },
    { 0x97, 0x4E, 0xAB, 0x2C },
    { 0x9F, 0x4E, 0xAB, 0x2C },
    { 0x9F, 0x4E, 0xBB, 0x2C },
    { 0x9F, 0x4E, 0xBB, 0x2C },
    { 0x9F, 0x4E, 0xBB, 0x2C },
    { 0x9F, 0x4E, 0xCB, 0x2C },
    { 0xA7, 0x4E, 0xCB, 0x2C },
    { 0xA7, 0x4E, 0xCB, 0x2C },
    { 0xA7, 0x46, 0xCB, 0x2C },
    { 0xA7, 0x46, 0xCB, 0x2C },
    { 0xA7, 0x46, 0xCB, 0x2C },
    { 0xA7, 0x46, 0xDB, 0x2C },
    { 0xAF, 0x46, 0xDB, 0x2C },
    { 0xAF, 0x46, 0xEB, 0x2C },
    { 0xAF, 0x46, 0xEB, 0x2C },
    { 0xAF, 0x4E, 0xEB, 0x2C },
    { 0xAE, 0x4E, 0xEB, 0x2C },
    { 0xAE, 0x4E, 0xEB, 0x2C },
    { 0xB5, 0x46, 0xFB, 0x2C },
    { 0xB5, 0x54, 0xFB, 0x2C },
    { 0xB5, 0x4C, 0xFB, 0x2C },
    { 0xB5, 0x54, 0xFB, 0x2C },
    { 0xB5, 0x54, 0xFB, 0x2C },
    { 0xBD, 0x54, 0xFB, 0x2C },
    { 0xBD, 0x4C, 0xFB, 0x2C },
    { 0xBD, 0x4C, 0xFB, 0x2C },
    { 0xBD, 0x4C, 0xFB, 0x2C },
    { 0xBD, 0x44, 0xEB, 0x2C },
    { 0xC5, 0x44, 0xFB, 0x2C },
    { 0xC5, 0x44, 0xFB, 0x2C },
    { 0xC5, 0x44, 0xFB, 0x2C },
    { 0xC5, 0x45, 0x0B, 0x2C },
    { 0xC5, 0x45, 0x0B, 0x2C },
    { 0xC5, 0x45, 0x0B, 0x2C },
    { 0xCD, 0x45, 0x0B, 0x2C },
    { 0xCD, 0x45, 0x0B, 0x2C },
    { 0xCD, 0x3D, 0x0B, 0x2C },
    { 0xCD, 0x3D, 0x0B, 0x2C },
    { 0xCD, 0x3D, 0x0B, 0x2C },
    { 0xD5, 0x3D, 0x0B, 0x2C },
    { 0xD5, 0x3D, 0x0B, 0x2C },
    { 0xD5, 0x3D, 0x1B, 0x2C },
    { 0xD5, 0x3D, 0x1B, 0x2C },
    { 0xD5, 0x3D, 0x1B, 0x2C },
    { 0xDD, 0x3D, 0x1B, 0x2C },
    { 0xDD, 0x3D, 0x1B, 0x2C },
    { 0xDD, 0x35, 0x1B, 0x2C },
    { 0xDD, 0x35, 0x1B, 0x2C },
    { 0xDD, 0x35, 0x1B, 0x2C },
    { 0xE5, 0x35, 0x1B, 0x2C },
    { 0xE5, 0x35, 0x1B, 0x2C },
    { 0xE5, 0x2D, 0x1B, 0x2C },
    { 0xE5, 0x2D, 0x1B, 0x2C },
    { 0xE5, 0x2D, 0x3B, 0x2C },
    { 0xED, 0x2D, 0x4B, 0x2C },
    { 0xED, 0x2D, 0x1B, 0xA8 },
    { 0xED, 0x2D, 0x1B, 0xAC },
    { 0xED, 0x2D, 0x17, 0xAC },
    { 0xED, 0x2D, 0x17, 0xAC },
    { 0xED, 0x2D, 0x27, 0xAC },
    { 0xF5, 0x2D, 0x27, 0xAC },
    { 0xF5, 0x2D, 0x27, 0xAC },
    { 0xF5, 0x2D, 0x2B, 0xAC },
    { 0xF5, 0x2D, 0x2B, 0xAC },
    { 0xF5, 0x2D, 0x2B, 0xAC },
    { 0xFD, 0x2D, 0x2B, 0xAC },
    { 0xFD, 0x2B, 0x2B, 0xAC },
    { 0xFD, 0x2B, 0x2B, 0xAC },
    { 0xFD, 0x2B, 0x2B, 0xAC },
    { 0xFD, 0x2B, 0x2B, 0xAC },
    { 0xFD, 0x23, 0x2B, 0xAC },
    { 0xFD, 0x23, 0x2B, 0xAC },
    { 0xFD, 0x23, 0x2B, 0xAC },
    { 0xFD, 0x21, 0x2B, 0xAC },
    { 0xFD, 0x21, 0x2B, 0xAC },
    { 0xFD, 0x29, 0x2B, 0xAC },
    { 0xFD, 0x29, 0x2B, 0xAC },
    { 0xFD, 0x29, 0x27, 0xAC },
    { 0xFD, 0x29, 0x37, 0xAC },
    { 0xFD, 0x29, 0x23, 0xAC },
    { 0xFD, 0x29, 0x23, 0xAC },
    { 0xFD, 0x29, 0x23, 0xAC },
    { 0xFD, 0x29, 0x23, 0xAC },
    { 0xFD, 0x21, 0x23, 0xAC },
    { 0xFD, 0x21, 0x23, 0xAC },
    { 0xFD, 0x21, 0x23, 0xAC },
    { 0xFD, 0x21, 0x33, 0xAC },
    { 0xFD, 0x21, 0x33, 0xAC },
    { 0xFD, 0x21, 0x33, 0xAC },
    { 0xFD, 0x21, 0x43, 0xAC },
    { 0xFD, 0x21, 0x43, 0xAC },
    { 0xFD, 0x21, 0x43, 0xAC },
    { 0xFC, 0x21, 0x43, 0xAC },
    { 0xFC, 0x21, 0x43, 0xAC },
    { 0xFC, 0x19, 0x43, 0xAC },
    { 0xFC, 0x19, 0x43, 0xAC },
    { 0xFC, 0x19, 0x43, 0xAC },
    { 0xFC, 0x19, 0x43, 0xAC },
    { 0xFC, 0x19, 0x53, 0xAC },
    { 0xFC, 0x19, 0x53, 0xAC },
    { 0xFC, 0x19, 0x53, 0xAC },
    { 0xFC, 0x19, 0x53, 0xAC },
    { 0xFC, 0x19, 0x63, 0xAC },
    { 0xFC, 0x19, 0x63, 0xAC },
    { 0xFC, 0x19, 0x63, 0xAC },
    { 0xFC, 0x19, 0x73, 0xAC },
    { 0xFC, 0x19, 0x73, 0xAC },
    { 0xFC, 0x19, 0x73, 0xAC },
    { 0xFC, 0x19, 0x73, 0xAC },
    { 0xFC, 0x19, 0x73, 0xAC },
    { 0xFC, 0x19, 0x83, 0xAC },
    { 0xFC, 0x19, 0x83, 0xAC },
    { 0xFC, 0x19, 0x83, 0xAC },
    { 0xFC, 0x19, 0x83, 0xAC },
    { 0xFC, 0x19, 0x83, 0xAC },
    { 0xFC, 0x19, 0x93, 0xAC },
    { 0xFC, 0x19, 0x93, 0xAC },
    { 0xFC, 0x19, 0x93, 0xAC },
    { 0xFC, 0x19, 0xA3, 0xAC },
    { 0xFC, 0x19, 0xA3, 0xAC },
    { 0xFC, 0x19, 0xB3, 0xAC },
    { 0xFC, 0x19, 0xB3, 0xAC },
    { 0xFC, 0x19, 0xB3, 0xAC },
    { 0xFC, 0x19, 0xB3, 0xAC }
};

/*
 ******************************************************************************
			  FUNCTION PROTOTYPES
 ******************************************************************************
*/
static void ClearTemplate(sdla_t* card);
static unsigned char InitTemplate(sdla_t* card);
static void InitLineReceiver(sdla_t* card);

static int WriteTPSCReg(sdla_t* card, int reg, int value);
static unsigned char ReadTPSCReg(sdla_t* card, int reg);

static int WriteRPSCReg(sdla_t* card, int reg, int value);
static unsigned char ReadRPSCReg(sdla_t* card, int reg);

#if 0
static void sdla_channels(void*, unsigned long);
#endif
static void DisableAllChannels(sdla_t* card);
static void EnableAllChannels(sdla_t* card);
static int DisableChannel(sdla_t* card, int channel);
static int EnableChannel(sdla_t* card, int channel);

static void sdla_te_tx_intr(sdla_t*); 
static void sdla_te_rx_intr(sdla_t*); 
static void sdla_t1_rx_intr(sdla_t*); 
static void sdla_e1_rx_intr(sdla_t*); 

static void sdla_te_set_status(sdla_t*, unsigned long);
static void sdla_te_enable_timer(sdla_t*, unsigned long); 

#ifdef SDLA_TE_DEBUG
static void pmc_dump_register(sdla_t*);
#endif

/*
 ******************************************************************************
			  FUNCTION DEFINITIONS
 ******************************************************************************
*/
/*
 ******************************************************************************
 *						ClearTemplate()	
 *
 * Description: 
 * Arguments:   None.
 * Returns:     None.
 ******************************************************************************
 */
static void ClearTemplate(sdla_t* card)
{
	int i = 0, j = 0;
	unsigned int indirect_addr = 0x00;

	for(i = FIRST_UI; i <= LAST_UI; i++) {
		for(j = FIRST_SAMPLE; j <= LAST_SAMPLE; j++) {
			indirect_addr = (j << 3) | i;
			/* Set up the indirect address */
			WRITE_REG(REG_XLPG_WAVEFORM_ADDR, indirect_addr);
			WRITE_REG(REG_XLPG_WAVEFORM_DATA, 0x00);
		}
	}
}

/*
 ******************************************************************************
 *						InitTemplate()	
 *
 * Description:
 * Arguments:   None.
 * Returns:     None.
 ******************************************************************************
 */
static unsigned char InitTemplate(sdla_t* card)
{
	wan_device_t* wandev = &card->wandev;
	sdla_te_cfg_t* te_cfg = &wandev->te_cfg;
	int i = 0, j = 0;
	unsigned char indirect_addr = 0x00, xlpg_scale = 0x00;
	TX_WAVEFORM* tx_waveform = NULL;

	if (te_cfg->media == WANOPT_MEDIA_T1) {
		switch(te_cfg->lbo) {
		case WANOPT_T1_LBO_0_DB:
			tx_waveform = &t1_tx_waveform_lh_0db;
			xlpg_scale = 0x0C;
			break;
		case WANOPT_T1_LBO_75_DB:
			tx_waveform = &t1_tx_waveform_lh_75db;
			xlpg_scale = 0x07;
			break;
		case WANOPT_T1_LBO_15_DB:
			tx_waveform = &t1_tx_waveform_lh_15db;
			xlpg_scale = 0x03;
			break;
		case WANOPT_T1_LBO_225_DB:
			tx_waveform = &t1_tx_waveform_lh_225db;
			xlpg_scale = 0x02;
			break;
		case WANOPT_T1_0_110:
			tx_waveform = &t1_tx_waveform_sh_110ft;
			xlpg_scale = 0x0C;
			break;
		case WANOPT_T1_110_220:
			tx_waveform = &t1_tx_waveform_sh_220ft;
			xlpg_scale = 0x10;
			break;
		case WANOPT_T1_220_330:
			tx_waveform = &t1_tx_waveform_sh_330ft;
			xlpg_scale = 0x11;
			break;
		case WANOPT_T1_330_440:
			tx_waveform = &t1_tx_waveform_sh_440ft;
			xlpg_scale = 0x12;
			break;
		case WANOPT_T1_440_550:
			tx_waveform = &t1_tx_waveform_sh_550ft;
			xlpg_scale = 0x14;
			break;
		case WANOPT_T1_550_660:
			tx_waveform = &t1_tx_waveform_sh_660ft;
			xlpg_scale = 0x15;
			break;
		default:	
			return 0x0;
			break;
		}
	} else {
		tx_waveform = &e1_tx_waveform_120;
		xlpg_scale = 0x0C;
		/*xlpg_scale = 0x0B; */
	}

	for(i = FIRST_UI; i <= LAST_UI; i++) {
		for(j = FIRST_SAMPLE; j <= LAST_SAMPLE; j++) {
			indirect_addr = (j << 3) | i;
			/* Set up the indirect address */
			WRITE_REG(REG_XLPG_WAVEFORM_ADDR, indirect_addr);
			WRITE_REG(REG_XLPG_WAVEFORM_DATA, (*tx_waveform)[j][i]);
		}
	}
	return xlpg_scale;
}

/*
 ******************************************************************************
 *						InitLineReceiver()	
 *
 * Description:
 * Arguments:   is_e1 - TRUE for E1 connection, FALSE for T1 connection.
 * Returns:     None.
 ******************************************************************************
 */
static void InitLineReceiver(sdla_t* card)
{
	wan_device_t* wandev = &card->wandev;
	sdla_te_cfg_t* te_cfg = &wandev->te_cfg;
	int addr = 0x00;
	RLPS_EQUALIZER_RAM* rlps_ram_table = 
		(te_cfg->media == WANOPT_MEDIA_E1) ? e1_rlps_ram_table : t1_rlps_ram_table;
	
	for(addr = 0x00; addr <=0xFF; addr ++) {
		/* Write 1st value from conten column */
		WRITE_REG(REG_RLPS_IND_DATA_1, rlps_ram_table[addr].byte1);
		/* Write 2st value from conten column */
		WRITE_REG(REG_RLPS_IND_DATA_2, rlps_ram_table[addr].byte2);
		/* Write 3st value from conten column */
		WRITE_REG(REG_RLPS_IND_DATA_3, rlps_ram_table[addr].byte3);
		/* Write 4st value from conten column */
		WRITE_REG(REG_RLPS_IND_DATA_4, rlps_ram_table[addr].byte4);
		/* Configure a write into the RAM address */
		WRITE_REG(REG_RLPS_EQ_RWB, 0x00);
		/* Initiate write into the specified RAM address */
		WRITE_REG(REG_RLPS_EQ_ADDR, (unsigned char)addr);
	}
}

/*
 ******************************************************************************
 *						WriteTPSCReg()	
 *
 * Description: Write value to TPSC indirect register.
 * Arguments:   reg   - Offset in TPSC indirect space.
 *				value - New PMC register value.
 * Returns:		None
 ******************************************************************************
 */
static int WriteTPSCReg(sdla_t* card, int reg, int value)
{
	unsigned char temp = 0x00;
	int i = 0;

	for(i = 0; i < MAX_BUSY_READ; i++) {
		temp = (READ_REG(REG_TPSC_MICRO_ACCESS_STATUS) & BIT_BUSY);
		if ((temp & BIT_BUSY) == 0x0) 
			break;
	}
	if (temp & BIT_BUSY)
		return FALSE;

	WRITE_REG(REG_TPSC_CHANNEL_INDIRECT_DATA_BUFFER, (unsigned char)value);
	WRITE_REG(REG_TPSC_CHANNEL_INDIRECT_ADDRESS_CONTROL, (unsigned char)(reg & 0x7F));

	for(i = 0; i < MAX_BUSY_READ; i++) {
		temp = (READ_REG(REG_TPSC_MICRO_ACCESS_STATUS) & BIT_BUSY);
		if ((temp & BIT_BUSY) == 0x0) 
			return TRUE;
	}
	return FALSE;
}

/*
 ******************************************************************************
 *						ReadTPSCReg()	
 *
 * Description: Read value from TPSC indirect register.
 * Arguments:   reg   - Offset in TPSC indirect space.
 * Returns:		Returns register value.
 ******************************************************************************
 */
static unsigned char ReadTPSCReg(sdla_t* card, int reg)
{
	unsigned char tmp = 0x00;
	int i = 0;

	for(i = 0; i < MAX_BUSY_READ; i++) {
		tmp = (READ_REG(REG_TPSC_MICRO_ACCESS_STATUS) & BIT_BUSY);
		if ((tmp & BIT_BUSY) == 0x0) 
			break;
	}
	if (tmp & BIT_BUSY)
		return 0x00;

	WRITE_REG(REG_TPSC_CHANNEL_INDIRECT_ADDRESS_CONTROL, (unsigned char)(reg & 0x80));

	for(i = 0; i < MAX_BUSY_READ; i++) {
		tmp = (READ_REG(REG_TPSC_MICRO_ACCESS_STATUS) & BIT_BUSY);
		if ((tmp & BIT_BUSY) == 0x0) {
			return READ_REG(REG_TPSC_CHANNEL_INDIRECT_DATA_BUFFER);
		}
	}
	return 0x00;
}

/*
 ******************************************************************************
 *						WriteRPSCReg()	
 *
 * Description: Write value to RPSC indirect register.
 * Arguments:   reg   - Offset in RPSC indirect space.
 *				value - New PMC register value.
 * Returns:		None
 ******************************************************************************
 */
static int WriteRPSCReg(sdla_t* card, int reg, int value)
{
	unsigned char temp = 0x00;
	int i = 0;

	for(i = 0; i < MAX_BUSY_READ; i++) {
		temp = (READ_REG(REG_RPSC_MICRO_ACCESS_STATUS) & BIT_BUSY);
		if ((temp & BIT_BUSY) == 0x0) 
			break;
	}
	if (temp & BIT_BUSY)
		return FALSE;

	WRITE_REG(REG_RPSC_CHANNEL_INDIRECT_DATA_BUFFER, (unsigned char)value);
	WRITE_REG(REG_RPSC_CHANNEL_INDIRECT_ADDRESS_CONTROL, (unsigned char)(reg & 0x7F));

	for(i = 0; i < MAX_BUSY_READ; i++) {
		temp = (READ_REG(REG_RPSC_MICRO_ACCESS_STATUS) & BIT_BUSY);
		if ((temp & BIT_BUSY) == 0x0) 
			return TRUE;
	}
	return FALSE;
}

/*
 ******************************************************************************
 *						ReadRPSCReg()	
 *
 * Description: Read value from RPSC indirect register.
 * Arguments:   reg   - Offset in RPSC indirect space.
 * Returns:		Returns register value.
 ******************************************************************************
 */
static unsigned char ReadRPSCReg(sdla_t* card, int reg)
{
	unsigned char tmp = 0x00;
	int i = 0;

	for(i = 0; i < MAX_BUSY_READ; i++) {
		tmp = (READ_REG(REG_RPSC_MICRO_ACCESS_STATUS) & BIT_BUSY);
		if ((tmp & BIT_BUSY) == 0x0) 
			break;
	}
	if (tmp & BIT_BUSY)
		return 0x00;

	WRITE_REG(REG_RPSC_CHANNEL_INDIRECT_ADDRESS_CONTROL, (unsigned char)(reg & 0x80));

	for(i = 0; i < MAX_BUSY_READ; i++) {
		tmp = (READ_REG(REG_RPSC_MICRO_ACCESS_STATUS) & BIT_BUSY);
		if ((tmp & BIT_BUSY) == 0x0) {
			return READ_REG(REG_RPSC_CHANNEL_INDIRECT_DATA_BUFFER);
		}
	}
	return 0x00;
}

/*
 ******************************************************************************
 *			DisableAllChannels()	
 *
 * Description:
 * Arguments:
 * Returns:
 ******************************************************************************
 */
static void DisableAllChannels(sdla_t* card)
{
	wan_device_t* wandev = &card->wandev;
	sdla_te_cfg_t* te_cfg = &wandev->te_cfg;
	int i = 0;

	if (te_cfg->media == WANOPT_MEDIA_E1) {
		for(i = 0; i <= NUM_OF_E1_CHANNELS - 1; i++)
			DisableChannel(card, i);
	} else {
		for(i = 1; i <= NUM_OF_T1_CHANNELS; i++)
			DisableChannel(card, i);
	}
}

/*
 ******************************************************************************
 *			EnableAllChannels()	
 *
 * Description:
 * Arguments:
 * Returns:
 ******************************************************************************
 */
static void EnableAllChannels(sdla_t* card)
{
	wan_device_t* wandev = &card->wandev;
	sdla_te_cfg_t* te_cfg = &wandev->te_cfg;
	int i = 0;

	if (te_cfg->media == WANOPT_MEDIA_E1) {
		DisableChannel(card, 0);
		for(i = 1; i <= NUM_OF_E1_CHANNELS - 1; i++)
			EnableChannel(card, i);
	} else {
		for(i = 1; i <= NUM_OF_T1_CHANNELS; i++)
			EnableChannel(card, i);
	}
}

/*
 ******************************************************************************
 *						EnableChannel()	
 *
 * Description:
 * Arguments:
 * Returns:
 ******************************************************************************
 */
static int EnableChannel(sdla_t* card, int channel)	
{
	wan_device_t* wandev = &card->wandev;
	sdla_te_cfg_t* te_cfg = &wandev->te_cfg;

	/* Set IND bit to 1 in RPSC to enable indirect access to RPSC register*/
	WRITE_REG(REG_RPSC_CFG, BIT_RPSC_IND); 

	/* Set DTRPC bit to 0 in RPSC */
	WRITE_RPSC_REG(REG_DATA_CTRL_BYTE + channel,
		((READ_RPSC_REG(REG_DATA_CTRL_BYTE + channel) & MASK_DATA_CTRL_BYTE) & ~BIT_RPSC_DTRKC));

	/* Set PCCE bit to 1 in RPSC to enable modifing the RPSC register */
	WRITE_REG(REG_RPSC_CFG, 
		((READ_REG(REG_RPSC_CFG) & MASK_RPSC_CFG) | BIT_RPSC_PCCE));

	/* Set IND bit to 1 in TPSC to enable indirect access to TPSC register */
	WRITE_REG(REG_TPSC_CFG, BIT_TPSC_IND); 

	if (te_cfg->lcode == WANOPT_LC_AMI) {
		/* ZCs=1 AMI*/
		WRITE_TPSC_REG(REG_DATA_CTRL_BYTE + channel, 
			(((READ_TPSC_REG(REG_DATA_CTRL_BYTE + channel) & MASK_DATA_CTRL_BYTE) & ~BIT_TPSC_IDLE_DS0) | BIT_TPSC_ZCS1));
	} else {
		WRITE_TPSC_REG(REG_DATA_CTRL_BYTE + channel, 
			((READ_TPSC_REG(REG_DATA_CTRL_BYTE + channel) & MASK_DATA_CTRL_BYTE) & ~(BIT_TPSC_IDLE_DS0 | BIT_TPSC_ZCS1 | BIT_TPSC_ZCS0)));
	}

	if (te_cfg->media == WANOPT_MEDIA_E1) {
		/* Set SUBS=DS[0]=DS[1]=0x0 - no change to PCM timeslot data */
		WRITE_TPSC_REG(REG_E1_CTRL_BYTE + channel, 
			(READ_TPSC_REG(REG_E1_CTRL_BYTE + channel) & ~(BIT_TPSC_SUBS | BIT_TPSC_DS0 | BIT_TPSC_DS1)));
	} else {
		WRITE_TPSC_REG(REG_SIGNALING_BYTE + channel, 0x00);
	}

	/* Erase contents of IDLE code byte */
	WRITE_TPSC_REG(REG_IDLE_CODE_BYTE + channel, 0x00);

	/* Set PCCE bit to 1 in TPSC to enable modifing the TPSC register */
	WRITE_REG(REG_TPSC_CFG, 
		((READ_REG(REG_TPSC_CFG) & MASK_TPSC_CFG) | BIT_TPSC_PCCE));

	return 0;
}

/*
 ******************************************************************************
 *				DisableChannel()	
 *
 * Description:
 * Arguments:
 * Returns:
 ******************************************************************************
 */
static int DisableChannel(sdla_t* card, int channel)
{
	wan_device_t* wandev = &card->wandev;
	sdla_te_cfg_t* te_cfg = &wandev->te_cfg;

	/* Set IND bit to 1 in RPSC to enable indirect access to RPSC register */
	WRITE_REG(REG_RPSC_CFG, BIT_RPSC_IND); 

	/* Set DTRPC bit to 1 in RPSC to hold low for the duration of the channel */
	/*WRITE_RPSC_REG(REG_DATA_CTRL_BYTE + channel, 
	 *	((READ_RPSC_REG(REG_DATA_CTRL_BYTE + channel) & MASK_DATA_CTRL_BYTE) | BIT_RPSC_DTRKC));
 	 */
	WRITE_RPSC_REG(REG_DATA_CTRL_BYTE + channel, BIT_RPSC_DTRKC); 

	/* Set PCCE bit to 1 in RPSC to enable modifing the RPSC register */
	WRITE_REG(REG_RPSC_CFG,  
		((READ_REG(REG_RPSC_CFG) & MASK_RPSC_CFG)| BIT_RPSC_PCCE));

	/* Set IND bit to 1 in TPSC to enable indirect access to TPSC register */
	WRITE_REG(REG_TPSC_CFG, BIT_TPSC_IND); 

	/* Set IDLE_DS0 to 1 for an IDLE code byte will insert and 
	 * BTCLK will suppressed 
	 */
	WRITE_TPSC_REG(REG_DATA_CTRL_BYTE + channel, 
		((READ_TPSC_REG(REG_DATA_CTRL_BYTE + channel) & MASK_DATA_CTRL_BYTE) | BIT_TPSC_IDLE_DS0));
	if (te_cfg->media == WANOPT_MEDIA_E1) {
		/* Set SUBS=1, DS0=0 - data substitution on - IDLE code replaces BTPCM timeslot data */
		WRITE_TPSC_REG(REG_E1_CTRL_BYTE + channel,
			((READ_TPSC_REG(REG_E1_CTRL_BYTE + channel) & ~BIT_TPSC_DS0) | BIT_TPSC_SUBS));
	} else {
		WRITE_TPSC_REG(REG_SIGNALING_BYTE + channel, 0x00);
	}
	/* Erase contents of IDLE code byte */
	WRITE_TPSC_REG(REG_IDLE_CODE_BYTE + channel, 0x00);

	/* Set PCCE bit to 1 in TPSC to enable modifing the TPSC register */
	WRITE_REG(REG_TPSC_CFG, 
		((READ_REG(REG_TPSC_CFG) & MASK_TPSC_CFG) | BIT_TPSC_PCCE));

	return 0;
}

/*
 ******************************************************************************
 *						sdla_te_config()	
 *
 * Description: Configure Sangoma TE1 board
 * Arguments:	
 * Returns:		TRUE - TE1 configred successfully, otherwise FALSE.
 ******************************************************************************
 */
short sdla_te_config(void* card_id)
{
	sdla_t* card = (sdla_t*)card_id;
	wan_device_t* wandev = &card->wandev;
	sdla_te_cfg_t* te_cfg = &wandev->te_cfg;
	unsigned char value = 0x00, xlpg_scale = 0x00;
	int channel_range = (IS_T1(card->wandev)) ? NUM_OF_T1_CHANNELS : NUM_OF_E1_CHANNELS;
	int i = 0;

	FE_ASSERT1(wandev->write_front_end_reg == NULL);
	FE_ASSERT1(wandev->read_front_end_reg == NULL);
        PRINT(card, "%s: Setting %s configuration!\n",
             	card->devname, IS_T1(card->wandev) ? "T1" : "E1");
	if (te_cfg->media == WANOPT_MEDIA_T1) {
        	DEBUG_PRINT("%s: Line decoding %s\n", 
			card->devname, (te_cfg->lcode == WANOPT_LC_AMI) ? "AMI" : "B8ZS");
        	DEBUG_PRINT("%s: Frame type %s\n", 
			card->devname, (te_cfg->frame == WANOPT_FR_ESF) ? "ESF" : "D4");
		switch(te_cfg->lbo) {
		case WANOPT_T1_LBO_0_DB:  
        		DEBUG_PRINT("%s: LBO 0 dB\n", card->devname);
			break;
		case WANOPT_T1_LBO_75_DB:
        		DEBUG_PRINT("%s: LBO 7.5 dB\n", card->devname);
			break;
		case WANOPT_T1_LBO_15_DB: 
        		DEBUG_PRINT("%s: LBO 15 dB\n", card->devname);
			break;
 		case WANOPT_T1_LBO_225_DB:
        		DEBUG_PRINT("%s: LBO 22.5 dB\n", card->devname);
			break;
		case WANOPT_T1_0_110:    
        		DEBUG_PRINT("%s: LBO 0-110 ft.\n", card->devname);
			break;
 		case WANOPT_T1_110_220:   
        		DEBUG_PRINT("%s: LBO 110-220 ft.\n", card->devname);
			break;
 		case WANOPT_T1_220_330:   
        		DEBUG_PRINT("%s: LBO 220-330 ft.\n", card->devname);
			break;
 		case WANOPT_T1_330_440:   
        		DEBUG_PRINT("%s: LBO 330-440 ft.\n", card->devname);
			break;
 		case WANOPT_T1_440_550:   
        		DEBUG_PRINT("%s: LBO 440-550 ft.\n", card->devname);
			break;
 		case WANOPT_T1_550_660:  
        		DEBUG_PRINT("%s: LBO 550-660 ft.\n", card->devname);
			break;
		}
	} else {
        	DEBUG_PRINT("%s: Line decoding %s\n", 
			card->devname, (te_cfg->lcode == WANOPT_LC_AMI) ? "AMI" : "HDB3");
        	DEBUG_PRINT("%s: Frame type %s\n", 
			card->devname, (te_cfg->frame == WANOPT_FR_CRC4) ? "CRC4" : "non-CRC4");
	}
       	DEBUG_PRINT("%s: Clock mode %s\n", 
		card->devname, (te_cfg->te_clock == WANOPT_NORMAL_CLK) ? "Normal" : "Master");

	/* 1. Initiate software reset of the COMET */
	/* Set RESET=1 to place COMET into RESET */
	WRITE_REG(REG_RESET, BIT_RESET);

	/* Set RESET=0, disable software reset. COMET in default mode. */
	WRITE_REG(REG_RESET, 0x0/*~BIT_RESET*/);  

	/* 2.Setup the XLPG(Transmit pulse template) to clear the pulse template */
	ClearTemplate(card);
	xlpg_scale = InitTemplate(card);

	/* Program PMC for T1/E1 mode (Reg 0x00) */
	if (te_cfg->media == WANOPT_MEDIA_E1)
		WRITE_REG(REG_GLOBAL_CFG, BIT_GLOBAL_PIO_OE | BIT_GLOBAL_E1); 

	/* Set SCALE[4-0] value in XLPG Line driver Configuration (Reg. 0xF0) */
	WRITE_REG(REG_XLPG_LINE_CFG, xlpg_scale);

	/* Set system clock and XCLK (Reg 0xD6) */
	if (te_cfg->media == WANOPT_MEDIA_T1)
		WRITE_REG(REG_CSU_CFG, BIT_CSU_MODE0); 
		/*WRITE_REG(REG_CSU_CFG, BIT_CSU_MODE2 | BIT_CSU_MODE1 | BIT_CSU_MODE0); */
	else
		WRITE_REG(REG_CSU_CFG, 0x00);

	/* Set Line decoding (Reg. 0x10) */
	if (te_cfg->lcode == WANOPT_LC_AMI)
		WRITE_REG(REG_CDRC_CFG, BIT_CDRC_CFG_AMI); 
	else
		WRITE_REG(REG_CDRC_CFG, 0x00); 

	/* Program the RX-ELST/TX-ELST for the appropriate mode (Reg 0x1C, 0x20)*/
	if (te_cfg->media == WANOPT_MEDIA_E1) {
		WRITE_REG(REG_RX_ELST_CFG, BIT_RX_ELST_IR | BIT_RX_ELST_OR);
		WRITE_REG(REG_TX_ELST_CFG, BIT_TX_ELST_IR | BIT_RX_ELST_OR); 
	} else {
		WRITE_REG(REG_RX_ELST_CFG, 0x00); 
		WRITE_REG(REG_TX_ELST_CFG, 0x00);
	}

	value = 0x00;
	if (te_cfg->media == WANOPT_MEDIA_E1) {
		/* Program the trasmitter framing and line decoding (Reg. 0x80) */
		if (te_cfg->lcode == WANOPT_LC_AMI)
			value |= BIT_E1_TRAN_AMI;
		if (te_cfg->frame == WANOPT_FR_CRC4)
			value |= BIT_E1_TRAN_GENCRC;
		/* E1 TRAN Configuration (Reg 0x80) */
		WRITE_REG(REG_E1_TRAN_CFG, value);
		/* Configure the receive framer (Reg 0x90) */
		value = 0x00;
		if (te_cfg->frame == WANOPT_FR_CRC4)
			value |= (BIT_E1_FRMR_CRCEN | BIT_E1_FRMR_CASDIS | BIT_E1_FRMR_REFCRCEN);
		else	
			value |= BIT_E1_FRMR_CASDIS;
		WRITE_REG(REG_E1_FRMR_CFG, value);
		
	} else {
		/* Set framing format & line decoding for transmitter (Reg 0x54) */
		if (te_cfg->lcode == WANOPT_LC_B8ZS){
			value |= BIT_T1_XBAS_B8ZS;
		}else{
			value |= BIT_T1_XBAS_ZCS0;
		}
		if (te_cfg->frame == WANOPT_FR_ESF)
			value |= BIT_T1_XBAS_ESF;
		WRITE_REG(REG_T1_XBAS_CFG, value);

		/* Program framing format for receiving (Reg. 0x48) */
		value = 0x00;
		if (te_cfg->frame == WANOPT_FR_ESF)
			value = BIT_T1_FRMR_ESF | BIT_T1_FRMR_ESFFA;
		WRITE_REG(REG_T1_FRMR_CFG, value);

		/* Program the transmitter framing format and line deconding (Reg. 0x60) */
		value = 0x00;
		if (te_cfg->frame == WANOPT_FR_ESF)
			value = BIT_T1_ALMI_CFG_ESF;
		WRITE_REG(REG_T1_ALMI_CFG, value);
	}

	/* Configure the SIGX configuration register */
	if (te_cfg->media == WANOPT_MEDIA_E1){
		WRITE_REG(REG_SIGX_CFG, 0x00);
	}else{
		value = READ_REG(REG_SIGX_CFG);
		if (te_cfg->frame == WANOPT_FR_ESF)
			value |= BIT_SIGX_ESF;
		WRITE_REG(REG_SIGX_CFG, value);
	}
	/* Program the BTIF for the frame pulse mode */
	value = 0x00;
	if (te_cfg->media == WANOPT_MEDIA_E1)
		value |= BIT_BTIF_RATE0;
	if (te_cfg->lcode == WANOPT_LC_AMI)
		value |= BIT_BTIF_NXDS0_0;
	else 
		value |= BIT_BTIF_NXDS0_1;
	WRITE_REG(REG_BTIF_CFG, value);
	/* Set the type of frame pulse on the backplane */
	WRITE_REG(REG_BTIF_FR_PULSE_CFG, 0x00); 

	/* Program the BRIF for the frame pulse mode */
	value = 0x00;
	if (te_cfg->media == WANOPT_MEDIA_E1)
		value |= BIT_BRIF_RATE0;
	if (te_cfg->lcode == WANOPT_LC_AMI)
		value |= BIT_BRIF_NXDS0_0;
	else 
		value |= BIT_BRIF_NXDS0_1;
	WRITE_REG(REG_BRIF_CFG, value);
	/* Set the type of frame pulse on the backplane */
	WRITE_REG(REG_BRIF_FR_PULSE_CFG, 0x00); 
	/* Program the data integraty checking on the BRIF */
	WRITE_REG(REG_BRIF_DATA_CFG, BIT_BRIF_DATA_TRI_0);

	/* Set TJAT FIFO output clock signal (Reg 0x06) */
	if (te_cfg->te_clock == WANOPT_NORMAL_CLK)
		WRITE_REG(REG_TX_TIMING_OPT, BIT_TX_PLLREF1 | BIT_TX_TXELSTBYP);
	else
		WRITE_REG(REG_TX_TIMING_OPT, BIT_TX_PLLREF1 | BIT_TX_PLLREF0 | BIT_TX_TXELSTBYP);

	/* Set long or short and enable the equalizer (Reg 0xF8) */
	WRITE_REG(REG_RLPS_CFG_STATUS, BIT_RLPS_CFG_STATUS_RESERVED);
	/* Select ALOS Detection and Clearance Thresholds (Reg 0xF9) */
	WRITE_REG(REG_RLPS_ALOS_DET_CLR_THR, 0x00);
	/* Select ALOS Detection period to set the ALOS alarm (Reg 0xFA) */
	WRITE_REG(REG_RLPS_ALOS_DET_PER, REG_RLPS_ALOS_DET_PER_0);
	/* Select ALOS Clearance period to clear the ALOS alarm (Reg 0xFB) */
	WRITE_REG(REG_RLPS_ALOS_CLR_PER, BIT_RLPS_ALOS_CLR_PER_0);
	/* Program to 0x00 to initiate a microprocessor access to RAM (Reg 0xFC) */
	WRITE_REG(REG_RLPS_EQ_ADDR, 0x00);
	/* Write the value 0x80 to this register to select a write to the RAM (Reg 0xFD) */
	WRITE_REG(REG_RLPS_EQ_RWB, BIT_RLPS_EQ_RWB);
	/* Program this register to 0x00 to reset the pointer to the RAM (Reg 0xFE) */
	WRITE_REG(REG_RLPS_EQ_STATUS, 0x00);
	/* Configure the Recive line Equalizer (Reg 0xFF) */
	WRITE_REG(REG_RLPS_EQ_CFG, 
		BIT_RLPS_EQ_RESERVED | BIT_RLPS_EQ_FREQ_1 | BIT_RLPS_EQ_FREQ_0);

	/* Configure the TJAT FIFO (Reg 0x1B) */
	WRITE_REG(REG_TJAT_CFG, BIT_TJAT_CENT);

	/* Configure the RJAT FIFO (Reg 0x17) */
	WRITE_REG(REG_RJAT_CFG, BIT_RJAT_CENT);
	/* Program Receive Options (Reg 0x02) */
	WRITE_REG(REG_RECEIVE_OPT, 0x00);

	/* Configure XLPG Analog Test Positive control (Reg 0xF4) */
	WRITE_REG(REG_XLPG_TPC, BIT_XLPG_TPC_0);
	/* Configure XLPG Analog Test Negative control (Reg 0xF5) */
	WRITE_REG(REG_XLPG_TNC, BIT_XLPG_TNC_0);

	/* Program the RLPS Equalizer Voltage (Reg 0xDC) */
	if (te_cfg->media == WANOPT_MEDIA_E1)
		WRITE_REG(REG_EQ_VREF, 0x34);
	else
		WRITE_REG(REG_EQ_VREF, 0x2C);
	WRITE_REG(REG_RLPS_FUSE_CTRL_STAT, 0x00);

	InitLineReceiver(card);

	for(i=0x20; i <= 0x7f; i++) {
		WRITE_TPSC_REG(i, 0x00);
	}
	for(i=0x20; i <= 0x7f; i++) {
		WRITE_RPSC_REG(i, 0x00);
	}

	DisableAllChannels(card);
	if (te_cfg->active_ch == 0xFFFFFFFFl){
		DEBUG_PRINT("%s: All channels enabled\n", card->devname);
		EnableAllChannels(card);
	}else{
		if (te_cfg->media == WANOPT_MEDIA_E1) {
			DisableChannel(card, 0);
		}
 		for(i = 1; i <= channel_range; i++) {
			if (te_cfg->active_ch & (1 << i))
				EnableChannel(card, i);
		}
	}

	/* Initialize and start T1/E1 timer */
	card->wandev.te_timer_cmd = TE_SET_INTR;
#if defined(__FreeBSD__) || defined(__WINDOWS__)
	bit_clear(&card->wandev.te_critical, TE_TIMER_KILL);
#elif defined (__OpenBSD__)
	bit_clear(&card->wandev.te_critical, TE_TIMER_KILL);
	/* Initialize software timer for T1/E1 */
	timeout_set(&card->wandev.te_timer, sdla_te_timer, card);
#else	/* Linux */
	clear_bit(TE_TIMER_KILL,(void*)&card->wandev.te_critical);
	/* Initialize software timer for T1/E1 */
	init_timer(&wandev->te_timer);
#endif
	sdla_te_enable_timer(card, INTR_TE1_TIMER);

	return 0;
}

/*
 ******************************************************************************
 *			sdla_te_set_intr()	
 *
 * Description: Enable T1/E1 interrupts.
 * Arguments:
 * Returns:
 ******************************************************************************
 */
static void sdla_te_set_intr(sdla_t* card)
{
	wan_device_t* wandev = &card->wandev;

	/* Enable LOS interrupt */
	WRITE_REG(REG_CDRC_INT_EN, BIT_CDRC_INT_EN_LOSE);
	/* Enable ALOS interrupt */
	WRITE_REG(REG_RLPS_CFG_STATUS, 
		BIT_RLPS_CFG_STATUS_ALOSE|BIT_RLPS_CFG_STATUS_RESERVED); 
	if (IS_T1(card->wandev)){
		/* Enable RBOC interrupt */
		WRITE_REG(REG_T1_RBOC_ENABLE, 
				BIT_T1_RBOC_ENABLE_IDLE | 
				BIT_T1_RBOC_ENABLE_BOCE);
		/* Enable interrupt on RED, AIS, YEL alarms */
		WRITE_REG(REG_T1_ALMI_INT_EN, 
				BIT_T1_ALMI_INT_EN_REDE | 
				BIT_T1_ALMI_INT_EN_AISE |
				BIT_T1_ALMI_INT_EN_YELE);
		/* Enable interrupt on OOF alarm */
		/*WRITE_REG(REG_T1_FRMR_INT_EN, BIT_T1_FRMR_INT_EN_INFRE);*/
	}else{
		/* Enable interrupt on RED, AIS alarms */
		WRITE_REG(REG_E1_FRMR_M_A_INT_EN, 
				BIT_E1_FRMR_M_A_INT_EN_REDE | 
				BIT_E1_FRMR_M_A_INT_EN_AISE);
		/* Enable OOF Interrupt */
		/*WRITE_REG(REG_E1_FRMR_FRM_STAT_INT_EN,BIT_E1_FRMR_FRM_STAT_INT_EN_OOFE);*/
	}

	/* Initialize T1/E1 timer */
#if defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__WINDOWS__)
	bit_clear(&card->wandev.te_critical, TE_TIMER_KILL);
#else	/* Linux */
	clear_bit(TE_TIMER_KILL,(void*)&card->wandev.te_critical);
#endif
	if (IS_E1(card->wandev)){
		/* Start E1 timer */
		wandev->te_timer_cmd = TE_LINKDOWN_TIMER;
		sdla_te_enable_timer(card, POLLING_TE1_TIMER);
	}
	return;
}

/*
 ******************************************************************************
 *			sdla_te_unconfig()	
 *
 * Description: T1/E1 unconfig.
 * Arguments:
 * Returns:
 ******************************************************************************
 */
void sdla_te_unconfig(void* card_id)
{
	sdla_t* card = (sdla_t*)card_id;

#if defined(__FreeBSD__) 
	bit_set(&card->wandev.te_critical, TE_TIMER_KILL);
	untimeout(sdla_te_timer, card, card->wandev.te_timer);
#elif defined (__OpenBSD__)
	bit_set(&card->wandev.te_critical, TE_TIMER_KILL);
	timeout_del(&card->wandev.te_timer);
#elif defined (__WINDOWS__)
	BOOLEAN status;
	bit_set(&card->wandev.te_critical, TE_TIMER_KILL);
	NdisMCancelTimer(&card->wandev.te_timer, &status);
#else	/* Linux */
	set_bit(TE_TIMER_KILL,(void*)&card->wandev.te_critical);
	del_timer(&card->wandev.te_timer);
#endif
	return;
}

/*
 ******************************************************************************
 *			sdla_te_set_status()	
 *
 * Description: Set T1/E1 status. Enable OOF and LCV interrupt (if status 
 * 		changed to disconnected.
 * Arguments:
 * Returns:
 ******************************************************************************
 */
static void sdla_te_set_status(sdla_t* card, unsigned long alarms)
{
	if (IS_T1(card->wandev)){
		if (IS_T1_ALARM(alarms)){
			if (card->wandev.front_end_status != FE_DISCONNECTED){
				PRINT(card, "%s: T1 disconnected!\n", card->devname);
				card->wandev.front_end_status = FE_DISCONNECTED;
			}
		}else{
			if (card->wandev.front_end_status != FE_CONNECTED){
				PRINT(card, "%s: T1 connected!\n", card->devname);
				card->wandev.front_end_status = FE_CONNECTED;
			}
		}
	}else{
		if (IS_E1_ALARM(alarms)){
#if defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__WINDOWS__)
			if (!bit_test(&card->wandev.te_critical, TE_TIMER_RUNNING)){
#else	/* Linux */
			if (!test_bit(TE_TIMER_RUNNING,(void*)&card->wandev.te_critical)){
#endif
				card->wandev.te_timer_cmd = TE_LINKDOWN_TIMER;
				sdla_te_enable_timer(card, POLLING_TE1_TIMER);
			}
			if (card->wandev.front_end_status != FE_DISCONNECTED){
				PRINT(card, "%s: E1 disconnected!\n", card->devname);
				card->wandev.front_end_status = FE_DISCONNECTED;
			}
		}else{
			if (card->wandev.front_end_status != FE_CONNECTED){
				PRINT(card, "%s: E1 connected!\n", card->devname);
				card->wandev.front_end_status = FE_CONNECTED;
			}
		}
	}

	if (card->wandev.front_end_status == FE_CONNECTED){
		WRITE_REG(REG_CDRC_INT_EN, 
			(READ_REG(REG_CDRC_INT_EN) | BIT_CDRC_INT_EN_LOSE));
	}else{
		WRITE_REG(REG_CDRC_INT_EN, 
			(READ_REG(REG_CDRC_INT_EN) & ~BIT_CDRC_INT_EN_LOSE));
	}

	return;
}

/*
 ******************************************************************************
 *			sdla_channels()	
 *
 * Description: Enable/Disable T1/E1 channels.
 * Arguments:
 * Returns:
 ******************************************************************************
 */
#if 0
static void sdla_channels(void* card_id, unsigned long active_ch)
{
	sdla_t* card = (sdla_t*)card_id;
	wan_device_t* wandev = &card->wandev;
	sdla_te_cfg_t* te_cfg = &wandev->te_cfg;
	int channel_range = IS_T1(card->wandev) ? NUM_OF_T1_CHANNELS : NUM_OF_E1_CHANNELS;
	int i = 0;

	for(i = 1; i <= channel_range; i++) {
		if ((active_ch & (1 << (i - 1))) != 
		    (te_cfg->active_ch & (1 << (i - 1)))) {
			if (active_ch & (1 << (i - 1))) {
				/* Enable channel `i` */	
			 	EnableChannel(card, i);	
			} else { 
				/* Disable channel `i` */	
				DisableChannel(card, i);
			} 
		}
	}
	return;
}
#endif
/*
 ******************************************************************************
 *						ReadAlarmStatus()	
 *
 * Description: Read Alram Status for T1/E1 modes.
 * Arguments:
 * Returns:		bit 0 - ALOS	(E1/T1)
 *			bit 1 - LOS	(E1/T1)
 *			bit 2 - ALTLOS	(E1/T1)
 *			bit 3 - OOF	(E1/T1)
 *			bit 4 - RED	(E1/T1)
 *			bit 5 - AIS	(E1/T1)
 *			bit 6 - OOSMF	(E1)
 *			bit 7 - OOCMF	(E1)
 *			bit 8 - OOOF	(E1)
 *			bit 9 - RAI	(E1)
 *			bit A - YEL	(T1)
 ******************************************************************************
 */
unsigned long sdla_te_alarm(void* card_id, int manual_update)
{
	sdla_t* card = (sdla_t*)card_id;
	wan_device_t* wandev = &card->wandev;
	sdla_te_cfg_t* te_cfg = &wandev->te_cfg;
	unsigned long status = 0x00;

	FE_ASSERT1(wandev->write_front_end_reg == NULL);
	FE_ASSERT1(wandev->read_front_end_reg == NULL);
	/* Check common alarm for E1 and T1 configuration
	 * 1. ALOS alarm 
	 * Reg 0xFA 
	 * Reg 0xF8 (ALOSI = 1)
	 */
	if (READ_REG(REG_RLPS_ALOS_DET_PER) &&
	    (READ_REG(REG_RLPS_CFG_STATUS) & BIT_RLPS_CFG_STATUS_ALOSV))
		status |= BIT_ALOS_ALARM;

	/* 2. LOS alarm 
	 * Reg 0x10
	 * Reg 0xF8 (ALOSI = 1)
	 */
	if ((READ_REG(REG_CDRC_CFG) & (BIT_CDRC_CFG_LOS0 | BIT_CDRC_CFG_LOS1)) &&
		(READ_REG(REG_CDRC_INT_STATUS) & BIT_CDRC_INT_STATUS_LOSV))
		status |= BIT_LOS_ALARM;

	/* 3. ALTLOS alarm ??????????????????
	 * Reg 0x13
	 */
	if (READ_REG(REG_ALTLOS_STATUS) & BIT_ALTLOS_STATUS_ALTLOS)
		status |= BIT_ALTLOS_ALARM;

	/* Check specific E1 and T1 alarms */
	if (te_cfg->media == WANOPT_MEDIA_E1) {
		/* 4. OOF alarm */
		if (READ_REG(REG_E1_FRMR_FR_STATUS) & BIT_E1_FRMR_FR_STATUS_OOFV)
			status |= BIT_OOF_ALARM;
		/* 5. OOSMF alarm */
		if (READ_REG(REG_E1_FRMR_FR_STATUS) & BIT_E1_FRMR_FR_STATUS_OOSMFV)
			status |= BIT_OOSMF_ALARM;
		/* 6. OOCMF alarm */
		if (READ_REG(REG_E1_FRMR_FR_STATUS) & BIT_E1_FRMR_FR_STATUS_OOCMFV)
			status |= BIT_OOCMF_ALARM;
		/* 7. OOOF alarm */
		if (READ_REG(REG_E1_FRMR_FR_STATUS) & BIT_E1_FRMR_FR_STATUS_OOOFV)
			status |= BIT_OOOF_ALARM;
		/* 8. RAI alarm */
		if (READ_REG(REG_E1_FRMR_MAINT_STATUS) & BIT_E1_FRMR_MAINT_STATUS_RAIV)
			status |= BIT_RAI_ALARM;
		/* 9. RED alarm
		 * Reg 0x97 (REDD)
		 */
		if (READ_REG(REG_E1_FRMR_MAINT_STATUS) & BIT_E1_FRMR_MAINT_STATUS_RED)
			status |= BIT_RED_ALARM;
		/* 10. AIS alarm
		 * Reg 0x91 (AISC)
		 * Reg 0x97 (AIS)
		 */
		if ((READ_REG(REG_E1_FRMR_MAINT_OPT) & BIT_E1_FRMR_MAINT_OPT_AISC) &&
			(READ_REG(REG_E1_FRMR_MAINT_STATUS) & BIT_E1_FRMR_MAINT_STATUS_AIS))
			status |= BIT_AIS_ALARM;
	} else {
		/* 4. OOF alarm
		 * Reg 0x4A (INFR=0 T1 mode)
		 */
		if (READ_REG(REG_T1_FRMR_INT_STATUS) & ~BIT_T1_FRMR_INT_STATUS_INFR)
			status |= BIT_OOF_ALARM;
		/* 5. AIS alarm
		 * Reg 0x62 (AIS)
		 * Reg 0x63 (AISD)
		 */
		if ((READ_REG(REG_T1_ALMI_INT_STATUS) & BIT_T1_ALMI_INT_STATUS_AIS) &&
			(READ_REG(REG_T1_ALMI_DET_STATUS) & BIT_T1_ALMI_DET_STATUS_AISD))
			status |= BIT_AIS_ALARM;
		/* 6. RED alarm
		 * Reg 0x63 (REDD)	
		 */
		if (READ_REG(REG_T1_ALMI_DET_STATUS) & BIT_T1_ALMI_DET_STATUS_REDD)
			status |= BIT_RED_ALARM;
		/* 7. YEL alarm
		 * Reg 0x62 (YEL)
		 * Reg 0x63 (YELD)
		 */
		if ((READ_REG(REG_T1_ALMI_INT_STATUS) & BIT_T1_ALMI_INT_STATUS_YEL) &&  
			(READ_REG(REG_T1_ALMI_DET_STATUS) & BIT_T1_ALMI_DET_STATUS_YELD))
			status |= BIT_YEL_ALARM;
	}
	if (manual_update){
		sdla_te_set_status(card, status);
	}
	return status;
}

/*
 ******************************************************************************
 *				sdla_te_pmon()	
 *
 * Description: Read PMC performance monitoring counters
 * Arguments:
 * Returns:
 ******************************************************************************
 */
void sdla_te_pmon(void* card_id)
{
	sdla_t* card = (sdla_t*)card_id;
	wan_device_t* wandev = &card->wandev;
	pmc_pmon_t* pmon = &wandev->te_pmon;

	FE_ASSERT(wandev->write_front_end_reg == NULL);
	FE_ASSERT(wandev->read_front_end_reg == NULL);
	/* Update PMON counters */
	WRITE_REG(REG_PMON_BIT_ERROR, 0x00);
	/* Framing bit for E1/T1 */
	pmon->frm_bit_error += READ_REG(REG_PMON_BIT_ERROR) & BITS_PMON_BIT_ERROR;

	/* OOF Error for T1 or Far End Block Error for E1 */
	pmon->oof_errors += 
		((READ_REG(REG_PMON_OOF_FEB_MSB_ERROR) & BITS_PMON_OOF_FEB_MSB_ERROR) << 8) | 
		READ_REG(REG_PMON_OOF_FEB_LSB_ERROR);

	/* Bit Error for T1 or CRC Error for E1 */
	pmon->bit_errors += 
		((READ_REG(REG_PMON_BIT_CRC_MSB_ERROR) & BITS_PMON_BIT_CRC_MSB_ERROR) << 8) | 
		READ_REG(REG_PMON_BIT_CRC_LSB_ERROR);

	/* LCV Error for E1/T1 */
	pmon->lcv += 
		((READ_REG(REG_PMON_LCV_MSB_COUNT) & BITS_PMON_LCV_MSB_COUNT) << 8) | 
		 READ_REG(REG_PMON_LCV_LSB_COUNT);
	return;
}

/*
 ******************************************************************************
 *				sdla_flush_te1_pmon()	
 *
 * Description: Flush PMC performance monitoring counters
 * Arguments:
 * Returns:
 ******************************************************************************
 */
void sdla_flush_te1_pmon(void* card_id)
{
	sdla_t* card = (sdla_t*)card_id;
	wan_device_t* wandev = &card->wandev;
	pmc_pmon_t* pmon = &wandev->te_pmon;

	pmon->pmon1 = 0;
	pmon->pmon2 = 0;
	pmon->pmon3 = 0;
	pmon->pmon4 = 0;

	return;
}

/*
 ******************************************************************************
 *				SetLoopBackChannel()	
 *
 * Description:
 * Arguments:
 * Returns:
 ******************************************************************************
 */
static int SetLoopBackChannel(sdla_t* card, int channel, unsigned char mode)
{
	/* Set IND bit to 1 in TPSC to enable indirect access to TPSC register */
	WRITE_REG(REG_TPSC_CFG, BIT_TPSC_IND); 

	/* Set LOOP to 1 for an IDLE code byte (the transmit data is overwritten 
	 * with the corresponding channel data from the receive line.
	 */
	if (mode == LINELB_ACTIVATE_CODE){
		WRITE_TPSC_REG(REG_DATA_CTRL_BYTE + channel, 
			((READ_TPSC_REG(REG_DATA_CTRL_BYTE + channel) & MASK_DATA_CTRL_BYTE) | 
			 BIT_TPSC_LOOP));
	}else{
		WRITE_TPSC_REG(REG_DATA_CTRL_BYTE + channel, 
			((READ_TPSC_REG(REG_DATA_CTRL_BYTE + channel) & MASK_DATA_CTRL_BYTE) &
			 ~BIT_TPSC_LOOP));
	}

	/* Set PCCE bit to 1 in TPSC to enable modifing the TPSC register */
	WRITE_REG(REG_TPSC_CFG, 
		((READ_REG(REG_TPSC_CFG) & MASK_TPSC_CFG) | BIT_TPSC_PCCE));

	return TRUE;
}

/*
 ******************************************************************************
 *				sdla_te_intr()	
 *
 * Description: Check interrupt type.
 * Arguments: 	card 		- pointer to device structure.
 * 		write_register 	- write register function.
 * 		read_register	- read register function.
 * Returns:	None.
 ******************************************************************************
 */
void sdla_te_intr(void* arg) 
{
	sdla_t* card = (sdla_t*)arg;

	FE_ASSERT(card->wandev.write_front_end_reg == NULL);
	FE_ASSERT(card->wandev.read_front_end_reg == NULL);
	sdla_te_tx_intr(card);
	sdla_te_rx_intr(card);
	sdla_te_set_status(card, card->wandev.te_alarm);
}

/*
 ******************************************************************************
 *				sdla_te_tx_intr()	
 *
 * Description: Read tx interrupt.
 * Arguments: 	card		- pointer to device structure.
 * 		write_register	- write register function.
 * 		read_register	- read register function.
 * Returns: None.
 ******************************************************************************
 */
static void sdla_te_tx_intr(sdla_t* card)
{
	unsigned char intr_src1 = 0x00, intr_src2 = 0x00, intr_src3 = 0x00;

	intr_src1 = READ_REG(REG_INT_SRC_1);
	intr_src2 = READ_REG(REG_INT_SRC_2);
	intr_src3 = READ_REG(REG_INT_SRC_3);
	if (intr_src1 == 0 && intr_src2 == 0 && intr_src3 == 0){
		DEBUG_PRINT(card, "%s: Unknown %s interrupt!\n", 
				card->devname, IS_T1(card->wandev) ? "T1" : "E1");
	}
	if (!(intr_src1 & BITS_TX_INT_SRC_1 || 
	      intr_src2 & BITS_TX_INT_SRC_2 ||  
     	      intr_src3 & BITS_TX_INT_SRC_3)){
		return;
	}

#if 0
	if (intr_src1 & BIT_INT_SRC_1_TJAT){
	}
	if (intr_src1 & BIT_INT_SRC_1_APRM){
	}
	if (intr_src2 & BIT_INT_SRC_2_TX_ELST){
	}
	if (intr_src2 & BIT_INT_SRC_2_TDPR_1){
	}
	if (intr_src2 & BIT_INT_SRC_2_TDPR_2){
	}
	if (intr_src2 & BIT_INT_SRC_2_TDPR_3){
	}
	if (intr_src3 & BIT_INT_SRC_3_TRAN){
	}
	if (intr_src3 & BIT_INT_SRC_3_XPDE){
	}
	if (intr_src3 & BIT_INT_SRC_3_BTIF){
	}
#endif
	return;
}


/*
 ******************************************************************************
 *				sdla_te_rx_intr()	
 *
 * Description: Read rx interrupt.
 * Arguments: 	card		- pointer to device structure.
 * 		write_register	- write register function.
 * 		read_register	- read register function.
 * Returns: None.
 ******************************************************************************
 */
static void sdla_te_rx_intr(sdla_t* card) 
{
	if (card->wandev.te_cfg.media == WANOPT_MEDIA_T1){
		sdla_t1_rx_intr(card);
	}else{
		sdla_e1_rx_intr(card);
	}
	return;
}

/*
 ******************************************************************************
 *				sdla_t1_rx_intr()	
 *
 * Description: Read tx interrupt.
 * Arguments: 	card		- pointer to device structure.
 * 		write_register	- write register function.
 * 		read_register	- read register function.
 * Returns: None.
 ******************************************************************************
 */
static void sdla_t1_rx_intr(sdla_t* card) 
{
	wan_device_t* wandev = &card->wandev;
	unsigned char intr_src1 = 0x00, intr_src2 = 0x00, intr_src3 = 0x00;
	unsigned char status = 0x00;

	intr_src1 = READ_REG(REG_INT_SRC_1);
	intr_src2 = READ_REG(REG_INT_SRC_2);
	intr_src3 = READ_REG(REG_INT_SRC_3);
	if (!(intr_src1 & BITS_RX_INT_SRC_1 || 
	      intr_src2 & BITS_RX_INT_SRC_2 ||  
     	      intr_src3 & BITS_RX_INT_SRC_3)){
		return;
	}

	/* 3. PDVD */
	if (intr_src3 & BIT_INT_SRC_3_PDVD){
		status = READ_REG(REG_PDVD_INT_EN_STATUS);
		if ((status & BIT_PDVD_INT_EN_STATUS_PDVE) && 
		    (status & BIT_PDVD_INT_EN_STATUS_PDVI)){
			if (status & BIT_PDVD_INT_EN_STATUS_PDV){
				PRINT(card, "%s: T1 pulse density violation detected!\n", 
						card->devname);
			}
		}
		if ((status & BIT_PDVD_INT_EN_STATUS_Z16DE) && 
		    (status & BIT_PDVD_INT_EN_STATUS_Z16DI)){
			PRINT(card, "%s: T1 16 consecutive zeros detected!\n", 
						card->devname);
		}
	}

	/* 6. ALMI */
	if (intr_src3 & BIT_INT_SRC_3_ALMI){
		status = READ_REG(REG_T1_ALMI_INT_STATUS);
		if (status & 
			(BIT_T1_ALMI_INT_STATUS_YELI | 
			 BIT_T1_ALMI_INT_STATUS_REDI | 
			 BIT_T1_ALMI_INT_STATUS_AISI)){
			if (status & (BIT_T1_ALMI_INT_STATUS_YEL | 
				      BIT_T1_ALMI_INT_STATUS_RED | 
				      BIT_T1_ALMI_INT_STATUS_AIS)){

				/* Update T1/E1 alarm status */
				if (!(card->wandev.te_alarm & BIT_YEL_ALARM) && 
				    (status & BIT_T1_ALMI_INT_STATUS_YEL)){
					PRINT(card, "%s: T1 YELLOW alarm is ON\n", 
							card->devname);
					card->wandev.te_alarm |= BIT_YEL_ALARM;
				}
				if (!(card->wandev.te_alarm & BIT_RED_ALARM) && 
				    (status & BIT_T1_ALMI_INT_STATUS_RED)){
					PRINT(card, "%s: T1 RED alarm is ON\n", 
							card->devname);
					card->wandev.te_alarm |= BIT_RED_ALARM;
				}
				if (!(card->wandev.te_alarm & BIT_AIS_ALARM) && 
				    (status & BIT_T1_ALMI_INT_STATUS_AIS)){
					PRINT(card, "%s: T1 Alarm Indication Signal is ON\n", 
							card->devname);
					card->wandev.te_alarm |= BIT_AIS_ALARM;
				}
			}else{
				/* Update T1/E1 alarm status */
				if ((card->wandev.te_alarm & BIT_YEL_ALARM) && 
				    !(status & BIT_T1_ALMI_INT_STATUS_YEL)){
					PRINT(card, "%s: T1 YELLOW alarm is OFF\n", 
							card->devname);
					card->wandev.te_alarm &= ~BIT_YEL_ALARM;
				}
				if ((card->wandev.te_alarm & BIT_RED_ALARM) && 
				    !(status & BIT_T1_ALMI_INT_STATUS_RED)){
					PRINT(card, "%s: T1 RED alarm is OFF\n", 
							card->devname);
					card->wandev.te_alarm &= ~BIT_RED_ALARM;
				}
				if ((card->wandev.te_alarm & BIT_AIS_ALARM) && 
				    !(status & BIT_T1_ALMI_INT_STATUS_AIS)){
					PRINT(card, "%s: T1 Alarm Indication Signal is OFF\n", 
							card->devname);
					card->wandev.te_alarm &= ~BIT_AIS_ALARM;
				}
			}
		}
	} 

	/* 8. RBOC */
	if (intr_src3 & BIT_INT_SRC_3_RBOC){
		status = READ_REG(REG_T1_RBOC_CODE_STATUS);
		if (status & BIT_T1_RBOC_CODE_STATUS_BOCI){
			unsigned long 	time;
#if defined(__FreeBSD__) || defined(__OpenBSD__)
			struct timeval 	tv;
			microtime(&tv);
			time = tv.tv_usec/1000;
#elif defined(__WINDOWS__)
			LARGE_INTEGER	tv;
			NdisGetCurrentSystemTime(&tv);
			time = (unsigned long)(tv.QuadPart/10000);
#else	/* Linux */
			struct timeval 	tv;
			do_gettimeofday(&tv);
			time = tv.tv_usec/1000;
#endif
			status &= MASK_T1_RBOC_CODE_STATUS;
			switch(status){
			case LINELB_ACTIVATE_CODE:
			case LINELB_DEACTIVATE_CODE:
#if defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__WINDOWS__)
				if (bit_test(&wandev->te_critical, LINELB_WAITING) &&
				    bit_test(&wandev->te_critical, LINELB_CODE_BIT)){
				    	bit_clear(&wandev->te_critical, LINELB_CODE_BIT);
#else	/* Linux */
				if (test_bit(LINELB_WAITING,(void*)&wandev->te_critical) &&
				    test_bit(LINELB_CODE_BIT,(void*)&wandev->te_critical)){
				    	clear_bit(LINELB_CODE_BIT,(void*)&wandev->te_critical);
#endif
					break;
				}
				
				DEBUG_PRINT("%s: T1 loopback %s code received.\n", 
						card->devname,
						(status == LINELB_ACTIVATE_CODE) ?
							"activation" : "deactivation");
				wandev->te_lb_cmd = status;				
				wandev->te_lb_time = time;				
				break;

			case LINELB_DS1LINE_ALL:
#if defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__WINDOWS__)
				if (bit_test(&wandev->te_critical, LINELB_WAITING) &&
				    bit_test(&wandev->te_critical, LINELB_CHANNEL_BIT)){
				    	bit_clear(&wandev->te_critical, LINELB_CHANNEL_BIT);
				    	bit_clear(&wandev->te_critical, LINELB_WAITING);
#else	/* Linux */
				if (test_bit(LINELB_WAITING,(void*)&wandev->te_critical) &&
				    test_bit(LINELB_CHANNEL_BIT,(void*)&wandev->te_critical)){
				    	clear_bit(LINELB_CHANNEL_BIT,(void*)&wandev->te_critical);
				    	clear_bit(LINELB_WAITING,(void*)&wandev->te_critical);
#endif
					break;
				}
				if (!wandev->te_lb_cmd)
					break; 
				if ((time - wandev->te_lb_time) < LINELB_TE1_TIMER){
					DEBUG_PRINT("%s: T1 loopback %s mode cancelled!\n",
							card->devname,
							(wandev->te_lb_cmd == LINELB_ACTIVATE_CODE) ? 
								"activatation" : 
								"deactivation");
				}else{
					if (wandev->te_lb_cmd == LINELB_ACTIVATE_CODE){
						PRINT(card, "%s: T1 loopback mode activated.\n", 
							card->devname); 
						WRITE_REG(REG_MASTER_DIAG, 
							READ_REG(REG_MASTER_DIAG) | 
							BIT_MASTER_DIAG_LINELB);
					}else{
						PRINT(card, "%s: T1 loopback mode deactivated.\n", 
							card->devname);
						WRITE_REG(REG_MASTER_DIAG, 
							READ_REG(REG_MASTER_DIAG) & 
							~BIT_MASTER_DIAG_LINELB);
					}
				}
				wandev->te_lb_cmd = 0x00;				
				wandev->te_lb_time = 0x00;				
				break;
		
			case LINELB_DS3LINE:
				break;

			case LINELB_DS1LINE_1:
			case LINELB_DS1LINE_2:
			case LINELB_DS1LINE_3:	
			case LINELB_DS1LINE_4:
			case LINELB_DS1LINE_5:	
			case LINELB_DS1LINE_6:	
			case LINELB_DS1LINE_7:	
			case LINELB_DS1LINE_8:	
			case LINELB_DS1LINE_9:
			case LINELB_DS1LINE_10:
			case LINELB_DS1LINE_11:
			case LINELB_DS1LINE_12:
			case LINELB_DS1LINE_13:
			case LINELB_DS1LINE_14:
			case LINELB_DS1LINE_15:
			case LINELB_DS1LINE_16:
			case LINELB_DS1LINE_17:
			case LINELB_DS1LINE_18:
			case LINELB_DS1LINE_19:
			case LINELB_DS1LINE_20:
			case LINELB_DS1LINE_21:
			case LINELB_DS1LINE_22:	
			case LINELB_DS1LINE_23:	
			case LINELB_DS1LINE_24:	
			case LINELB_DS1LINE_25:
			case LINELB_DS1LINE_26:	
			case LINELB_DS1LINE_27:
			case LINELB_DS1LINE_28:
				if (!wandev->te_lb_cmd)
					break;
				if ((time - wandev->te_lb_time) < LINELB_TE1_TIMER){
					DEBUG_PRINT("%s: T1 loopback %s mode cancelled!\n",
							card->devname,
							(wandev->te_lb_cmd == LINELB_ACTIVATE_CODE) ? 
								"activatation" : 
								"deactivation");
				}else{
					int channel = status & LINELB_DS1LINE_MASK; 
					PRINT(card, "%s: T1 loopback mode %s on channel %i.\n", 
						card->devname,
						(wandev->te_lb_cmd == LINELB_ACTIVATE_CODE) ? "activated" : "deactivated",
						channel);
					SetLoopBackChannel(card, channel, wandev->te_lb_cmd);
				}
				wandev->te_lb_cmd = 0x00;				
				wandev->te_lb_time = 0x00;				
				break;

			default:
				DEBUG_PRINT("%s: Unknown signal (0x%02x).\n", 
						card->devname, status);
				break;
			}
		}
	}

	/* 7. FRMR */
	if (intr_src1 & BIT_INT_SRC_1_FRMR){
		status = READ_REG(REG_T1_FRMR_INT_STATUS);
		if ((READ_REG(REG_T1_FRMR_INT_EN) & BIT_T1_FRMR_INT_EN_INFRE) &&
		    (status & BIT_T1_FRMR_INT_STATUS_INFRI)){
			if (status & BIT_T1_FRMR_INT_STATUS_INFR){
				if (!(card->wandev.te_alarm & BIT_OOF_ALARM)){
					PRINT(card, "%s: T1 Out of Frame alarm is ON!\n",
						card->devname);
					card->wandev.te_alarm |= BIT_OOF_ALARM; 
				}
			}else{
				if (card->wandev.te_alarm & BIT_OOF_ALARM){
					PRINT(card, "%s: T1 Out of Frame alarm is OFF!\n",
						card->devname);
					card->wandev.te_alarm &= ~BIT_OOF_ALARM; 
				}
			}
		}
	}

	/* 1. RLPS */
	if (intr_src3 & BIT_INT_SRC_3_RLPS){
		status = READ_REG(REG_RLPS_CFG_STATUS);
		if ((status & BIT_RLPS_CFG_STATUS_ALOSE) && (status & BIT_RLPS_CFG_STATUS_ALOSI)){
			if (status & BIT_RLPS_CFG_STATUS_ALOSV){
				if (!(card->wandev.te_alarm & BIT_ALOS_ALARM)){
					PRINT(card, "%s: T1 ALOS alarm is ON\n", 
						card->devname);
					card->wandev.te_alarm |= BIT_ALOS_ALARM;
				}
			}else{
				if (card->wandev.te_alarm & BIT_ALOS_ALARM){
					PRINT(card, "%s: T1 ALOS alarm is OFF\n", 
						card->devname);
					card->wandev.te_alarm &= ~BIT_ALOS_ALARM;
				}
			}
		}
	}

	/* 2. CDRC */
	if (intr_src1 & BIT_INT_SRC_1_CDRC){
		status = READ_REG(REG_CDRC_INT_STATUS);
		if ((READ_REG(REG_CDRC_INT_EN) & BIT_CDRC_INT_EN_LOSE) && 
		    (status & BIT_CDRC_INT_STATUS_LOSI)){
			if (status & BIT_CDRC_INT_STATUS_LOSV){
				if (!(card->wandev.te_alarm & BIT_LOS_ALARM)){
					PRINT(card, "%s: T1 LOS alarm is ON\n", 
							card->devname);
					card->wandev.te_alarm |= BIT_LOS_ALARM;
				}
			}else{
				if (card->wandev.te_alarm & BIT_LOS_ALARM){
					PRINT(card, "%s: T1 LOS alarm is OFF\n", 
							card->devname);
					card->wandev.te_alarm &= ~BIT_LOS_ALARM;
				}
			}
		}
		if ((READ_REG(REG_CDRC_INT_EN) & BIT_CDRC_INT_EN_LCVE) && 
		    (status & BIT_CDRC_INT_STATUS_LCVI)){
			PRINT(card, "%s: T1 line code violation!\n", 
					card->devname);
		}
		if ((READ_REG(REG_CDRC_INT_EN) & BIT_CDRC_INT_EN_LCSDE) && 
		    (status & BIT_CDRC_INT_STATUS_LCSDI)){
			PRINT(card, "%s: T1 line code signature detected!\n", 
					card->devname);
		}
		if ((READ_REG(REG_CDRC_INT_EN) & BIT_CDRC_INT_EN_ZNDE) && 
		    (status & BIT_CDRC_INT_STATUS_ZNDI)){
			PRINT(card, "%s: T1 consecutive zeros detected!\n", 
					card->devname);
		}
		status = READ_REG(REG_ALTLOS_STATUS);
		if ((status & BIT_ALTLOS_STATUS_ALTLOSI) && (status & BIT_ALTLOS_STATUS_ALTLOSE)){
			if (status & BIT_ALTLOS_STATUS_ALTLOS){
				if (!(card->wandev.te_alarm & BIT_ALTLOS_ALARM)){
					PRINT(card, "%s: T1 Alternate Loss of Signal alarm is ON\n",
							card->devname);
					card->wandev.te_alarm |= BIT_ALTLOS_ALARM;
				}
			}else{
				if (card->wandev.te_alarm & BIT_ALTLOS_ALARM){
					PRINT(card, "%s: T1 Alternate Loss of Signal alarm is OFF\n",
							card->devname);
					card->wandev.te_alarm &= ~BIT_ALTLOS_ALARM;
				}
			}
		}
	}

	/* 14. PMON */
	if (intr_src1 & BIT_INT_SRC_1_PMON){
		status = READ_REG(REG_PMON_INT_EN_STATUS);
		if (status & BIT_PMON_INT_EN_STATUS_XFER){
			DEBUG_PRINT("%s: T1 Updating PMON counters...\n",
					card->devname);
			sdla_te_pmon(card);
		}
	}
#if 0
	/* 4. RJAT */
	if (intr_src1 & BIT_INT_SRC_1_RJAT){
	}
	/* 5. IBCD */
	if (intr_src3 & BIT_INT_SRC_3_IBCD){
	}
	/* 9. SIGX */
	if (intr_src1 & BIT_INT_SRC_1_SIGX){
	}
	/* 10. RX-ELST */
	if (intr_src2 & BIT_INT_SRC_2_RX_ELST){
	}	
	/* 11. RDLC-1 */
	if (intr_src2 & BIT_INT_SRC_2_RDLC_1){
	}
	/* 12. RDLC-2 */
	if (intr_src2 & BIT_INT_SRC_2_RDLC_2){
	}
	/* 13. RDLC-3 */
	if (intr_src2 & BIT_INT_SRC_2_RDLC_3){
	}
#endif

	return;
}


/*
 ******************************************************************************
 *				sdla_e1_rx_intr()	
 *
 * Description: Read tx interrupt.
 * Arguments: 	card		- pointer to device structure.
 * 		write_register	- write register function.
 * 		read_register	- read register function.
 * Returns: None.
 ******************************************************************************
 */
static void sdla_e1_rx_intr(sdla_t* card) 
{
	unsigned char intr_src1 = 0x00, intr_src2 = 0x00, intr_src3 = 0x00;
	unsigned char int_status = 0x00, status = 0x00;

	intr_src1 = READ_REG(REG_INT_SRC_1);
	intr_src2 = READ_REG(REG_INT_SRC_2);
	intr_src3 = READ_REG(REG_INT_SRC_3);
	if (!(intr_src1 & BITS_RX_INT_SRC_1 || 
	      intr_src2 & BITS_RX_INT_SRC_2 ||  
     	      intr_src3 & BITS_RX_INT_SRC_3))
		return;
	
	/* 4. FRMR */
	if (intr_src1 & BIT_INT_SRC_1_FRMR){
		/* Register 0x94h E1 FRMR */
		int_status = READ_REG(REG_E1_FRMR_FRM_STAT_INT_IND);
		/* Register 0x96h E1 FRMR Status */
		status = READ_REG(REG_E1_FRMR_FR_STATUS);
		if ((READ_REG(REG_E1_FRMR_FRM_STAT_INT_EN) & BIT_E1_FRMR_FRM_STAT_INT_EN_OOFE) && 
		    (int_status & BIT_E1_FRMR_FRM_STAT_INT_IND_OOFI)){
			if (status & BIT_E1_FRMR_FR_STATUS_OOFV){
				if (!(card->wandev.te_alarm & BIT_OOF_ALARM)){
					PRINT(card, "%s: E1 Out of Frame alarm is ON\n",
							card->devname);
					card->wandev.te_alarm |= BIT_OOF_ALARM; 
				}
			}else{
				if (card->wandev.te_alarm & BIT_OOF_ALARM){
					PRINT(card, "%s: E1 Out of Frame alarm is OFF\n",
							card->devname);
					card->wandev.te_alarm &= ~BIT_OOF_ALARM; 
				}
			}
		}

		if ((READ_REG(REG_E1_FRMR_FRM_STAT_INT_EN) & BIT_E1_FRMR_FRM_STAT_INT_EN_OOSMFE) && 
		    (int_status & BIT_E1_FRMR_FRM_STAT_INT_IND_OOSMFI)){
			if (status & BIT_E1_FRMR_FR_STATUS_OOSMFV){
				PRINT(card, "%s: E1 Loss of Signaling multiframe alarm is ON\n",
					card->devname);
				card->wandev.te_alarm |= BIT_OOSMF_ALARM; 
			}else{
				PRINT(card, "%s: E1 Loss of Signaling multiframe alarm is OFF\n",
					card->devname);
				card->wandev.te_alarm &= ~BIT_OOSMF_ALARM; 
			}
		}

		if ((READ_REG(REG_E1_FRMR_FRM_STAT_INT_EN) & BIT_E1_FRMR_FRM_STAT_INT_EN_OOCMFE) && 
		    (int_status & BIT_E1_FRMR_FRM_STAT_INT_IND_OOCMFI)){
			if (status & BIT_E1_FRMR_FR_STATUS_OOCMFV){
				PRINT(card, "%s: E1 Loss of CRC multiframe alarm is ON\n",
					card->devname);
				card->wandev.te_alarm |= BIT_OOCMF_ALARM; 
			}else{
				PRINT(card, "%s: E1 Loss of CRC multiframe alarm is OFF\n",
					card->devname);
				card->wandev.te_alarm &= ~BIT_OOCMF_ALARM; 
			}
		}

		/* Register 0x9Fh E1 FRMR */
		status = READ_REG(REG_E1_FRMR_P_A_INT_STAT);
		if ((READ_REG(REG_E1_FRMR_P_A_INT_EN) & BIT_E1_FRMR_P_A_INT_EN_OOOFE) && 
		    (status & BIT_E1_FRMR_P_A_INT_STAT_OOOFI)){
			if (READ_REG(REG_E1_FRMR_FR_STATUS) & BIT_E1_FRMR_FR_STATUS_OOOFV){
				PRINT(card, "%s: E1 out of offline frame alarm is ON\n",
					card->devname);
				card->wandev.te_alarm |= BIT_OOOF_ALARM; 
			}else{
				PRINT(card, "%s: E1 out of offline frame alarm is OFF\n",
					card->devname);
				card->wandev.te_alarm &= ~BIT_OOOF_ALARM; 
			}
		}

		/* Register 0x95h E1 FRMR */
		int_status = READ_REG(REG_E1_FRMR_M_A_INT_IND);
		if (int_status & (BIT_E1_FRMR_M_A_INT_IND_REDI | BIT_E1_FRMR_M_A_INT_IND_AISI)){
			status = READ_REG(REG_E1_FRMR_MAINT_STATUS);
			if ((READ_REG(REG_E1_FRMR_M_A_INT_EN) & BIT_E1_FRMR_M_A_INT_EN_REDE) &&
			    (int_status & BIT_E1_FRMR_M_A_INT_IND_REDI)){
				if (status & BIT_E1_FRMR_MAINT_STATUS_RED){
					PRINT(card, "%s: E1 RED alarm is ON\n", card->devname);
					card->wandev.te_alarm |= BIT_RED_ALARM;
				}else{
					PRINT(card, "%s: E1 RED alarm is OFF\n", card->devname);
					card->wandev.te_alarm &= ~BIT_RED_ALARM;
				}
			}
			if ((READ_REG(REG_E1_FRMR_M_A_INT_EN) & BIT_E1_FRMR_M_A_INT_EN_AISE) &&
			    (int_status & BIT_E1_FRMR_M_A_INT_IND_AISI)){
				if (status & BIT_E1_FRMR_MAINT_STATUS_AIS){
					PRINT(card, "%s: E1 AIS alarm is ON\n", card->devname);
					card->wandev.te_alarm |= BIT_AIS_ALARM;
				}else{
					PRINT(card, "%s: E1 AIS alarm is OFF\n", card->devname);
					card->wandev.te_alarm &= ~BIT_AIS_ALARM;
				}
			}
			if ((READ_REG(REG_E1_FRMR_M_A_INT_EN) & BIT_E1_FRMR_M_A_INT_EN_RAIE) &&
			    (int_status & BIT_E1_FRMR_M_A_INT_IND_RAII)){
				if (status & BIT_E1_FRMR_MAINT_STATUS_RAIV){
					PRINT(card, "%s: E1 RAI alarm is ON\n", card->devname);
					card->wandev.te_alarm |= BIT_RAI_ALARM;
				}else{
					PRINT(card, "%s: E1 RAI alarm is OFF\n", card->devname);
					card->wandev.te_alarm &= ~BIT_RAI_ALARM;
				}
			}
		}
	}

	/* 1. RLPS */
	if (intr_src3 & BIT_INT_SRC_3_RLPS){
		status = READ_REG(REG_RLPS_CFG_STATUS);
		if ((status & BIT_RLPS_CFG_STATUS_ALOSE) &&
		    (status & BIT_RLPS_CFG_STATUS_ALOSI)){
			if (status & BIT_RLPS_CFG_STATUS_ALOSV){
				if (!(card->wandev.te_alarm & BIT_ALOS_ALARM)){
					PRINT(card, "%s: E1 ALOS alarm is ON\n", 
						card->devname);
					card->wandev.te_alarm |= BIT_ALOS_ALARM;
				}
			}else{
				if (card->wandev.te_alarm & BIT_ALOS_ALARM){
					PRINT(card, "%s: E1 ALOS alarm is OFF\n", 
						card->devname);
					card->wandev.te_alarm &= ~BIT_ALOS_ALARM;
				}
			}
		}
	}

	/* 2. CDRC */
	if (intr_src1 & BIT_INT_SRC_1_CDRC){
		status = READ_REG(REG_CDRC_INT_STATUS);
		if ((READ_REG(REG_CDRC_INT_EN) & BIT_CDRC_INT_EN_LOSE) && 
		    (status & BIT_CDRC_INT_STATUS_LOSI)){
			if (status & BIT_CDRC_INT_STATUS_LOSV){
				if (!(card->wandev.te_alarm & BIT_LOS_ALARM)){
					PRINT(card, "%s: E1 LOS alarm is ON\n", card->devname);
					card->wandev.te_alarm |= BIT_LOS_ALARM;
				}
			}else{
				if (card->wandev.te_alarm & BIT_LOS_ALARM){
					PRINT(card, "%s: E1 LOS alarm is OFF\n", card->devname);
					card->wandev.te_alarm &= ~BIT_LOS_ALARM;
				}
			}
		}
		if ((READ_REG(REG_CDRC_INT_EN) & BIT_CDRC_INT_EN_LCVE) && 
		    (status & BIT_CDRC_INT_STATUS_LCVI)){
			PRINT(card, "%s: E1 line code violation!\n", card->devname);
		}
		if ((READ_REG(REG_CDRC_INT_EN) & BIT_CDRC_INT_EN_LCSDE) && 
		    (status & BIT_CDRC_INT_STATUS_LCSDI)){
			PRINT(card, "%s: E1 line code signature detected!\n", card->devname);
		}
		if ((READ_REG(REG_CDRC_INT_EN) & BIT_CDRC_INT_EN_ZNDE) && 
		    (status & BIT_CDRC_INT_STATUS_ZNDI)){
			PRINT(card, "%s: E1 consecutive zeros detected!\n", card->devname);
		}
		status = READ_REG(REG_ALTLOS_STATUS);
		if ((status & BIT_ALTLOS_STATUS_ALTLOSI) && (status & BIT_ALTLOS_STATUS_ALTLOSE)){
			if (status & BIT_ALTLOS_STATUS_ALTLOS){
				if (!(card->wandev.te_alarm & BIT_ALTLOS_ALARM)){
					PRINT(card, "%s: E1 Alternate Loss of Signal alarm is ON\n",
							card->devname);
					card->wandev.te_alarm |= BIT_ALTLOS_ALARM;
				}
			}else{
				if (card->wandev.te_alarm & BIT_ALTLOS_ALARM){
					PRINT(card, "%s: E1 Alternate Loss of Signal alarm is OFF\n",
							card->devname);
					card->wandev.te_alarm &= ~BIT_ALTLOS_ALARM;
				}
			}
		}
	}
	/* 11. PMON */
	if (intr_src1 & BIT_INT_SRC_1_PMON){
		status = READ_REG(REG_PMON_INT_EN_STATUS);
		if (status & BIT_PMON_INT_EN_STATUS_XFER){
			sdla_te_pmon(card);
		}
	}
#if 0
	/* 3. RJAT */
	if (intr_src1 & BIT_INT_SRC_1_RJAT){
	}
	/* 5. SIGX */
	if (intr_src1 & BIT_INT_SRC_1_SIGX){
	}
	/* 6. RX-ELST */
	if (intr_src2 & BIT_INT_SRC_2_RX_ELST){
	}
	/* 7. PRGD */
	if (intr_src1 & BIT_INT_SRC_1_PRGD){
	}
	/* 8. RDLC-1 */
	if (intr_src2 & BIT_INT_SRC_2_RDLC_1){
	}
	/* 9. RDLC-2 */
	if (intr_src2 & BIT_INT_SRC_2_RDLC_2){
	}
	/* 10. RDLC-3 */
	if (intr_src2 & BIT_INT_SRC_2_RDLC_3){
	}
#endif
	if (!(READ_REG(REG_RLPS_CFG_STATUS) & BIT_RLPS_CFG_STATUS_ALOSV)){
		card->wandev.te_alarm &= ~BIT_ALOS_ALARM;
	}
	return;
}

/*
 ******************************************************************************
 *				sdla_te_linelb()	
 *
 * Description:
 * Arguments:
 * Returns:
 ******************************************************************************
 */
int sdla_te_linelb(void* arg, int mode) 
{
	sdla_t*	card = (sdla_t*)arg;

	FE_ASSERT1(card->wandev.write_front_end_reg == NULL);
	FE_ASSERT1(card->wandev.read_front_end_reg == NULL);
	if (mode == ACTIVATE_LOOPBACK){
		PRINT(card, "%s: %s Line Loopback mode activated.\n",
			card->devname,
			(IS_T1(card->wandev) ? "T1" : "E1"));
		WRITE_REG(REG_MASTER_DIAG, 
			READ_REG(REG_MASTER_DIAG) | BIT_MASTER_DIAG_LINELB);
	}else{
		PRINT(card, "%s: %s Line Loopback mode deactivated.\n",
			card->devname,
			(IS_T1(card->wandev) ? "T1" : "E1"));
		WRITE_REG(REG_MASTER_DIAG, 
			READ_REG(REG_MASTER_DIAG) & ~BIT_MASTER_DIAG_LINELB);
	}
	return 0;
}

/*
 ******************************************************************************
 *				sdla_te_paylb()	
 *
 * Description:
 * Arguments:
 * Returns:
 ******************************************************************************
 */
int sdla_te_paylb(void* arg, int mode) 
{
	sdla_t*	card = (sdla_t*)arg;

	FE_ASSERT1(card->wandev.write_front_end_reg == NULL);
	FE_ASSERT1(card->wandev.read_front_end_reg == NULL);
	if (mode == ACTIVATE_LOOPBACK){
		PRINT(card, "%s: %s Payload Loopback mode activated.\n",
			card->devname,
			(IS_T1(card->wandev) ? "T1" : "E1"));
		WRITE_REG(REG_MASTER_DIAG, 
			READ_REG(REG_MASTER_DIAG) | BIT_MASTER_DIAG_PAYLB);
	}else{
		PRINT(card, "%s: %s Payload Loopback mode deactivated.\n",
			card->devname,
			(IS_T1(card->wandev) ? "T1" : "E1"));
		WRITE_REG(REG_MASTER_DIAG, 
			READ_REG(REG_MASTER_DIAG) & ~BIT_MASTER_DIAG_PAYLB);
	}
	return 0;
}

/*
 ******************************************************************************
 *				sdla_te_ddlb()	
 *
 * Description:
 * Arguments:
 * Returns:
 ******************************************************************************
 */
int sdla_te_ddlb(void* arg, int mode) 
{
	sdla_t*	card = (sdla_t*)arg;

	FE_ASSERT1(card->wandev.write_front_end_reg == NULL);
	FE_ASSERT1(card->wandev.read_front_end_reg == NULL);
	if (mode == ACTIVATE_LOOPBACK){
		PRINT(card, "%s: %s Diagnostic Digital Loopback mode activated.\n",
			card->devname,
			(IS_T1(card->wandev) ? "T1" : "E1"));
		WRITE_REG(REG_MASTER_DIAG, 
			READ_REG(REG_MASTER_DIAG) | BIT_MASTER_DIAG_DDLB);
	}else{
		PRINT(card, "%s: %s Diagnostic Digital Loopback mode deactivated.\n",
			card->devname,
			(IS_T1(card->wandev) ? "T1" : "E1"));
		WRITE_REG(REG_MASTER_DIAG, 
			READ_REG(REG_MASTER_DIAG) & ~BIT_MASTER_DIAG_DDLB);
	}
	return 0;
}

/*
 ******************************************************************************
 *				sdla_te_timer()	
 *
 * Description:
 * Arguments:
 * Returns:
 ******************************************************************************
 */
#if defined(__FreeBSD__) || defined(__OpenBSD__)
void sdla_te_timer(void* card_id)
#elif defined(__WINDOWS__)
void sdla_te_timer(void* arg1, void* card_id, void* arg2, void* arg3)
#else
void sdla_te_timer(unsigned long card_id)
#endif
{
	sdla_t *card = (sdla_t*)card_id;
	wan_device_t* wandev = &card->wandev;

#if defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__WINDOWS__)
	if (bit_test(&wandev->te_critical, TE_TIMER_KILL)){
		bit_clear(&wandev->te_critical, TE_TIMER_RUNNING);
		return;
	}
#else	/* Linux */
	if (test_bit(TE_TIMER_KILL,(void*)&wandev->te_critical)){
		clear_bit(TE_TIMER_RUNNING,(void*)&wandev->te_critical);
		return;
	}
#endif
	FE_ASSERT(wandev->te_enable_timer == NULL);
	/* Enable hardware interrupt for TE1 */
	wandev->te_enable_timer(card);

	return;
}

/*
 ******************************************************************************
 *				sdla_te_enable_timer()	
 *
 * Description: Enable software timer interrupt in delay ms.
 * Arguments:
 * Returns:
 ******************************************************************************
 */
static void sdla_te_enable_timer(sdla_t* card, unsigned long delay)
{
	wan_device_t* 	wandev = &card->wandev;

	FE_ASSERT(card == NULL);
#if defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__WINDOWS__)
	if (bit_test(&wandev->te_critical, TE_TIMER_KILL)){
		bit_clear(&wandev->te_critical, TE_TIMER_RUNNING);
		return;
	}
	bit_set(&wandev->te_critical, TE_TIMER_RUNNING);
#else	/* Linux */
	if (test_bit(TE_TIMER_KILL,(void*)&wandev->te_critical)){
		clear_bit(TE_TIMER_RUNNING,(void*)&wandev->te_critical);
		return;
	}
	set_bit(TE_TIMER_RUNNING,(void*)&wandev->te_critical);
#endif
#if defined(__FreeBSD__)
	card->wandev.te_timer = 
			timeout(sdla_te_timer, card, delay * hz / 1000); 
#elif defined (__OpenBSD__)
	if (!timeout_initialized(&card->wandev.te_timer)){
		return;
	}
	timeout_add(&card->wandev.te_timer, delay * hz / 1000);
#elif defined (__WINDOWS__)
	NdisMSetTimer(&wandev->te_timer, delay);
#else	/* Linux */
	wandev->te_timer.data     	= (unsigned long)card;
	wandev->te_timer.function 	= &sdla_te_timer;
	wandev->te_timer.expires  	= jiffies + delay * HZ / 1000;
	add_timer(&wandev->te_timer);
#endif
	return;	
}

/*
 ******************************************************************************
 *				sdla_te_polling()	
 *
 * Description:
 * Arguments:
 * Returns:
 ******************************************************************************
 */
void sdla_te_polling(void* card_id)
{
	sdla_t*		card = (sdla_t*)card_id;
	wan_device_t* 	wandev = &card->wandev;

	FE_ASSERT(wandev->write_front_end_reg == NULL);
	FE_ASSERT(wandev->read_front_end_reg == NULL);
	switch(card->wandev.te_timer_cmd){
	case TE_LINELB_TIMER:
		if (IS_T1(card->wandev)){
			/* Sending T1 activation/deactivation loopback signal */
			if (wandev->te_lb_tx_cnt > 10){
				WRITE_REG(REG_T1_XBOC_CODE, 
					(wandev->te_lb_tx_cmd == ACTIVATE_LOOPBACK) ? 
						LINELB_ACTIVATE_CODE : LINELB_DEACTIVATE_CODE);
			}else{
				WRITE_REG(REG_T1_XBOC_CODE, LINELB_DS1LINE_ALL);  
			}	
			if (--wandev->te_lb_tx_cnt){
				sdla_te_enable_timer(card, LINELB_TE1_TIMER);
			}else{
				DEBUG_PRINT("%s: T1 loopback %s signal sent.\n",
						card->devname,	
						(wandev->te_lb_tx_cmd == ACTIVATE_LOOPBACK) ? 
							"activation" : "deactivation");
				wandev->te_lb_tx_cmd = 0x00;
#if defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__WINDOWS__)
				bit_clear(&wandev->te_critical, TE_TIMER_RUNNING);
#else	/* Linux */
				clear_bit(TE_TIMER_RUNNING,(void*)&wandev->te_critical);
#endif
			}
		}
		break;

	case TE_SET_INTR:
		sdla_te_set_intr(card);
		break;

	case TE_LINKDOWN_TIMER:
		if (!IS_E1(card->wandev))
			break;
		if ((READ_REG(REG_RLPS_ALOS_DET_PER) && 
		     (READ_REG(REG_RLPS_CFG_STATUS) & BIT_RLPS_CFG_STATUS_ALOSV)) ||
		    (IS_T1(card->wandev) && 
		     (READ_REG(REG_E1_FRMR_FR_STATUS) & BIT_E1_FRMR_FR_STATUS_OOFV)) ||
		    (!IS_T1(card->wandev) &&
		     (READ_REG(REG_T1_FRMR_INT_STATUS) & ~BIT_T1_FRMR_INT_STATUS_INFR))){
			sdla_te_enable_timer(card, POLLING_TE1_TIMER);
		}else{
			sdla_te_alarm(card, 1);
#if defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__WINDOWS__)
			bit_clear(&wandev->te_critical, TE_TIMER_RUNNING);
#else	/* Linux */
			clear_bit(TE_TIMER_RUNNING,(void*)&wandev->te_critical);
#endif
		}
		break;
	}
	return;
}

/*
 ******************************************************************************
 *				sdla_te_lb()	
 *
 * Description:
 * Arguments:
 * Returns:
 ******************************************************************************
 */
int sdla_te_lb(void* arg, unsigned char mode) 
{
	sdla_t*	card = (sdla_t*)arg;
	wan_device_t* wandev = &card->wandev;

	FE_ASSERT1(wandev->write_front_end_reg == NULL);
	FE_ASSERT1(wandev->read_front_end_reg == NULL);

	if (!IS_T1(card->wandev)){
		return 1;
	}
	if (card->wandev.front_end_status != FE_CONNECTED){
		return 1;
	}
#if defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__WINDOWS__)
	if (bit_test(&wandev->te_critical, TE_TIMER_RUNNING)) return 1;
#else	/* Linux */
	if (test_bit(TE_TIMER_RUNNING,(void*)&wandev->te_critical)) return 1;
#endif
#if defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__WINDOWS__)
	if (bit_test(&wandev->te_critical, LINELB_WAITING)){ 
#else	/* Linux */
	if (test_bit(LINELB_WAITING,(void*)&wandev->te_critical)){
#endif
		DEBUG_PRINT("%s: Still waiting for far end to send loopback signal back!\n",
				card->devname);				
	}
	DEBUG_PRINT("%s: Sending %s loopback %s signal...\n",
			card->devname, 
			(IS_T1(card->wandev) ? "T1" : "E1"),
			(mode == ACTIVATE_LOOPBACK) ? 
				"activation" : "deactivation");
	wandev->te_lb_tx_cmd		= mode;
	wandev->te_lb_tx_cnt		= LINELB_CODE_CNT + LINELB_CHANNEL_CNT;
	card->wandev.te_timer_cmd	= TE_LINELB_TIMER;
#if defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__WINDOWS__)
	bit_set(&wandev->te_critical, LINELB_WAITING);
	bit_set(&wandev->te_critical, LINELB_CODE_BIT);
	bit_set(&wandev->te_critical, LINELB_CHANNEL_BIT);
#else	/* Linux */
	set_bit(LINELB_WAITING,(void*)&wandev->te_critical);
	set_bit(LINELB_CODE_BIT,(void*)&wandev->te_critical);
	set_bit(LINELB_CHANNEL_BIT,(void*)&wandev->te_critical);
#endif
	sdla_te_enable_timer(card, LINELB_TE1_TIMER);

	return 0;
}

/*
 ******************************************************************************
 *				pmc_dump_register()	
 *
 * Description:
 * Arguments:
 * Returns:
 ******************************************************************************
 */
#ifdef SDLA_TE_DEBUG
static void pmc_dump_register(sdla_t* card) 
{
	unsigned short reg_no = 0x00;
	for(reg_no = 0x0; reg_no < 0xFF; reg_no++){
		DEBUG_PRINT("Reg. %02x = %02x\n", reg_no, READ_REG(reg_no));
	}
}
#endif

/*
 ******************************************************************************
 *						ClearTemplate()	
 *
 * Description:
 * Arguments:
 * Returns:
 ******************************************************************************
 */
/************************** End of files *************************************/
