/*****************************************************************************
* wanproc.h	Definitions for the WAN PROC fs.
*
* Author: 	Alex Feldman <al.feldman@sangoma.com>
*
* Copyright:	(c) 1995-2000 Sangoma Technologies Inc.
*
*		This program is free software; you can redistribute it and/or
*		modify it under the terms of the GNU General Public License
*		as published by the Free Software Foundation; either version
*		2 of the License, or (at your option) any later version.
* ============================================================================
* Aug 20, 2001  Alex Feldman	Initial version.
*/

#ifndef __WANPROC_H
# define __WANPROC_H

#ifdef __KERNEL__

/*
 * ******************************************************************
 *
 *
 * ******************************************************************
 */
#define PROC_BUF_CONT	0
#define PROC_BUF_EXIT	1
#define PROC_ADD_DECL(stop_cnt)			static int stop_cnt = 0;
#define PROC_ADD_INIT(offs,stop_cnt)		if (offs == 0) stop_cnt = 0;
#define PROC_ADD_LINE(cnt,x)			{if (proc_add_line x == PROC_BUF_EXIT)	\
							return cnt;}
#define PROC_ADD_RET(cnt,offs,stop_cnt)		stop_cnt = offs + cnt;		\
						return cnt;

static inline int
proc_add_line(char* buf, int* cnt, int len, int offs, int* stop_cnt, int* size, char* frm, ...)
{
	char 	tmp[400];
	int 	ret = PROC_BUF_CONT;
	va_list	arg;
	
	va_start(arg, frm);
	if (*cnt && *stop_cnt){
		return PROC_BUF_EXIT;
	}
	*size = vsprintf(tmp, frm, arg);
	if (*stop_cnt){
		if (*stop_cnt < *size){
			printk(KERN_INFO "!!! Error in writting in proc buffer !!!\n");
			*stop_cnt = *size;
		}
		*stop_cnt -= *size;
	}else{
		if (*size < len - *cnt){
			vsprintf(&buf[*cnt], frm, arg);
			*cnt += *size;
			//*cnt += vsprintf(&buf[*cnt], frm, arg);
		}else{
			*stop_cnt = offs + *cnt;
			ret = PROC_BUF_EXIT;
		}
	}
	va_end(arg);
	return ret;
}

/*
 * ******************************************************************
 */

#define STATE_DECODE(state)					\
		((state == WAN_UNCONFIGURED) ? "Unconfigured" :	\
		 (state == WAN_DISCONNECTED) ? "Disconnected" : \
	         (state == WAN_CONNECTING) ? "Connecting" : 	\
		 (state == WAN_CONNECTED) ? "Connected": 	\
		 (state == WAN_LIMIT) ? "Limit": 		\
		 (state == WAN_DUALPORT) ? "DualPort": 		\
		 (state == WAN_DISCONNECTING) ? "Disconnecting": \
		 (state == WAN_FT1_READY) ? "FT1 Ready": "Invalid")

#define CFG_DECODE(value)	(value) ? "YES" : "NO"

#define CLK_DECODE(clocking)	(clocking) ? "INT" : "EXT"

#define INT_DECODE(interface)					\
		(interface == WANOPT_RS232) ? "RS232" : "V35"


#define SIGNALLING_DECODE(sig)					\
		(sig == WANOPT_FR_ANSI) ? "ANSI" :	\
		(sig == WANOPT_FR_Q933) ? "Q333" :	\
		(sig == WANOPT_FR_LMI) ? "LMI" : "NO"
		
#define COMPORT_DECODE(port)	(port == WANOPT_PRI) ? "PRI" : "SEC"

#define IP_MODE_DECODE(ip_mode)					\
		(ip_mode == WANOPT_PPP_STATIC) ? "STATIC" :	\
		(ip_mode == WANOPT_PPP_PEER) ? "PEER" : "HOST"

/*
 ********************************************************************
 *				X.25
 */
#define X25_STATION_DECODE(station)				\
		(station == WANOPT_DTE) ? "DTE" : 		\
		(station == WANOPT_DCE) ? "DCE" : "DXE"
		
/*
 * SNMP X.25 defines
 */
#define SNMP_X25_DTE		1
#define SNMP_X25_DCE		2
#define SNMP_X25_DXE		3

#define SNMP_X25_MODULO8	1
#define SNMP_X25_MODULO128	2

#define SNMP_X25_INCOMING	1
#define SNMP_X25_OUTGOING	2
#define SNMP_X25_PVC		3

// x25CallParmAcceptReverseCharging
#define SNMP_X25_ARC_DEFAULT		1
#define SNMP_X25_ARC_ACCEPT		2
#define SNMP_X25_ARC_REFUSE		3
#define SNMP_X25_ARC_NEVERACCEPT	4

// x25CallParmProposeReverseCharging
#define SNMP_X25_PRC_DEFAULT		1
#define SNMP_X25_PRC_REVERSE		2
#define SNMP_X25_PRC_LOCAL		3

// x25CallParmFastSelecet
#define SNMP_X25_FS_DEFAULT		1
#define SNMP_X25_FS_NOTSPECIFIED	2
#define SNMP_X25_FS_FASTSELECT		3
#define SNMP_X25_FS_RESTRICTEDFASTRESP	4
#define SNMP_X25_FS_NOFASTSELECT	5
#define SNMP_X25_FS_NORESTRICTEDFASTSEL	6

// x25CallParmInThruPutClassSize
// x25CallParmOutThruPutClassSize
#define SNMP_X25_THRUCLASS_TCRES1	1
#define SNMP_X25_THRUCLASS_TCRES2	2
#define SNMP_X25_THRUCLASS_TC75		3
#define SNMP_X25_THRUCLASS_TC150	4
#define SNMP_X25_THRUCLASS_TC300	5
#define SNMP_X25_THRUCLASS_TC600	6
#define SNMP_X25_THRUCLASS_TC1200	7
#define SNMP_X25_THRUCLASS_TC2400	8
#define SNMP_X25_THRUCLASS_TC4800	9
#define SNMP_X25_THRUCLASS_TC9600	10
#define SNMP_X25_THRUCLASS_TC19200	11
#define SNMP_X25_THRUCLASS_TC48000	12
#define SNMP_X25_THRUCLASS_TC64000	13
#define SNMP_X25_THRUCLASS_TCRES14	14
#define SNMP_X25_THRUCLASS_TCRES15	15
#define SNMP_X25_THRUCLASS_TCRES16	16
#define SNMP_X25_THRUCLASS_TCNONE	17
#define SNMP_X25_THRUCLASS_TCDEF	18

// x25CallParmChargingInfo
#define SNMP_X25_CHARGINGINFO_DEF		1
#define SNMP_X25_CHARGINGINFO_NOFACL		2
#define SNMP_X25_CHARGINGINFO_NOCHRGINFO	3
#define SNMP_X25_CHARGINGINFO_CHARGINFO		4

// x25CallParmExptData
#define SNMP_X25_EXPTDATA_DEFULT	1
#define SNMP_X25_EXPTDATA_NOEXPTDATA	2
#define SNMP_X25_EXPTDATA_EXPTDATA	3


/*
 ********************************************************************
 *			Frame Relay
 */
#define FR_STATION_DECODE(station)				\
		(station == WANOPT_CPE) ? "CPE" : "Node"
		
/*
 * SNMP defines
 */
#define SNMP_FR_UNICAST		1
#define SNMP_FR_ONEWAY		2
#define SNMP_FR_TWOWAY		3
#define SNMP_FR_NWAY		4

#define SNMP_FR_STATIC		1
#define SNMP_FR_DYNAMIC		2

#define SNMP_FR_INVALID		1
#define SNMP_FR_ACTIVE		2
#define SNMP_FR_INACTIVE	3

#define SNMP_FR_NOLMICONF	1
#define SNMP_FR_LMIREV		2
#define SNMP_FR_ANSIT1617D	3
#define SNMP_FR_ANSIT1617B	4
#define SNMP_FR_ITUT933A	5
#define SNMP_FR_ANSIT1617D1994	6

#define SNMP_FR_Q921_ADDR	1
#define SNMP_FR_Q922MARCH90	2
#define SNMP_FR_Q922NOV90	3
#define SNMP_FR_Q922		4

#define SNMP_FR_2BYTE_ADDR	2
#define SNMP_FR_3BYTE_ADDR	3
#define SNMP_FR_4BYTE_ADDR	4

#define SNMP_FR_NONBROADCAST	1
#define SNMP_FR_BROADCAST	2

#define SNMP_FR_RUNNING		1
#define SNMP_FR_FAULT		2
#define SNMP_FR_INITIALIZING	3

#define SNMP_FR_ENABLED		1
#define SNMP_FR_DISABLED	2

#define SNMP_FR_UNKNOWNERR	1
#define SNMP_FR_RECEIVESHORT	2
#define SNMP_FR_RECEIVELONG	3
#define SNMP_FR_ILLEGALADDR	4
#define SNMP_FR_UNKNOWNADDR	5
#define SNMP_FR_DLCMIPROTOERR	6
#define SNMP_FR_DLCMIUNKNOWNERR	7
#define SNMP_FR_DLCMISEQERR	8
#define SNMP_FR_DLCMIUNKNOWNRPT	9
#define SNMP_FR_NOERRSINCERESET	10

#define SNMP_FR_ERRDATA_LEN	1600

#define SNMP_FR_SET_ERR(chan, type, data, len)	{struct timeval tv;	\
				do_gettimeofday(&tv);			\
				chan->err_type = type;			\
				memcpy(chan->err_data, data, len);	\
				chan->err_time = tv.tv_sec;		\
				chan->err_faults++;}




#endif	// __KERNEL__

#endif 	// __WANPROC_H
