/*
 *************************************************************************************
 *                                                                                   *
 * FRNT_END.H - the 'C' header file for the Sangoma S508/S514 adapter front-end API. *
 *                                                                                   *
 *************************************************************************************
*/
#ifndef _SDLA_FRONT_END_H_
#define _SDLA_FRONT_END_H_

#ifndef __WINDOWS__
# ifndef	PACKED
# define	PACKED __attribute__((packed))
# endif	/* PACKED */
#else
# undef PACKED
# define PACKED
#endif


/* front-end configuration and access interface commands */
#define READ_FRONT_END_REGISTER		0x90 /* read from front-end register */
#define WRITE_FRONT_END_REGISTER	0x91 /* write to front-end register */
#define READ_FRONT_END_STATISTICS	0x92 /* read the front-end statistics */
#define FLUSH_FRONT_END_STATISTICS	0x93 /* flush the front-end statistics */


/* adapter configuration interface commands */
#define SET_ADAPTER_CONFIGURATION	0xA0 /* set adapter configuration */
#define READ_ADAPTER_CONFIGURATION	0xA1 /* read adapter configuration */

/* return codes from interface commands */
#define LGTH_ADAPTER_CFG_DATA_INVALID	0x91 /* the length of the passed configuration data is invalid */
#define ADPTR_OPERATING_FREQ_INVALID	0x92 /* an invalid adapter operating frequency was selected */
#define COMMAND_INVALID_FOR_ADAPTER	0x9F	/* the command is invalid for the adapter type */



/* ----------------------------------------------------------------------------
 *                       Macros
 * --------------------------------------------------------------------------*/
#define FE_ASSERT(val)	if (val) return;
#define FE_ASSERT1(val)	if (val) return 1;


/* ----------------------------------------------------------------------------
 *                       Constants for front-end access
 * --------------------------------------------------------------------------*/

/* the structure used for the READ_FRONT_END_REGISTER/WRITE_FRONT_END_REGISTER command */
typedef struct {
	unsigned short register_number PACKED; /* the register number to be read from or written to */
	unsigned char register_value PACKED;	/* the register value read/written */
} FRONT_END_REG_STRUCT;

typedef struct {
	unsigned char opp_flag PACKED;	/* opp flag */
	
	union {
		struct {
			unsigned char RR8_56k PACKED;						/* register #8 value - 56K CSU/DSU */
			unsigned char RR9_56k PACKED;						/* register #9 value - 56K CSU/DSU */
			unsigned char RRA_56k PACKED;						/* register #A value - 56K CSU/DSU */	
			unsigned char RRB_56k PACKED;						/* register #B value - 56K CSU/DSU */
			unsigned char RRC_56k PACKED;						/* register #C value - 56K CSU/DSU */
		} stat_56k;
	} FE_U;

} FRONT_END_STATUS_STRUCT;


/* -----------------------------------------------------------------------------
 *            Constants for the READ_FRONT_END_STATISTICS command
 * ---------------------------------------------------------------------------*/

/* the front-end statistics structure */
typedef struct {
	unsigned long FE_interrupt_count PACKED;   /* the number of front-end interrupts generated */
	unsigned long FE_app_timeout_count PACKED; /* the number of front-end interrupt application timeouts */
} FE_STATISTICS_STRUCT;



/* --------------------------------------------------------------------------------
 * Constants for the SET_ADAPTER_CONFIGURATION/READ_ADAPTER_CONFIGURATION commands
 * -------------------------------------------------------------------------------*/

/* the adapter configuration structure */
typedef struct {
	unsigned short adapter_type PACKED;	/* type of adapter */
	unsigned short adapter_config PACKED;	/* miscellaneous adapter configuration options */
	unsigned long operating_frequency PACKED;	/* adapter operating frequency */
} ADAPTER_CONFIGURATION_STRUCT;



typedef unsigned char (WRITE_FRONT_END_REG_T)(void*, unsigned short, unsigned char);
typedef unsigned char (READ_FRONT_END_REG_T)(void*, unsigned short);


/* settings for the 'adapter_type' */
#define S5141_ADPTR_1_CPU_SERIAL	0x0011	/* S5141, single CPU, serial */
#define S5142_ADPTR_2_CPU_SERIAL	0x0012	/* S5142, dual CPU, serial */
#define S5143_ADPTR_1_CPU_FT1		0x0013	/* S5143, single CPU, FT1 */
#define S5144_ADPTR_1_CPU_T1E1		0x0014	/* S5144, single CPU, T1/E1 */
#define S5145_ADPTR_1_CPU_56K		0x0015	/* S5145, single CPU, 56K */

#endif
