#!/bin/sh

function interface_menu () {

	local rc
	local num="$1"
	local name
	local choice
	local menu_options
	local menu_size


	# Initialize common variables
        # Operation mode is WANPIPE by default
        # Protocol Status is unconfigured by default
        # IP Stataus is unconfigured by default
	
	AUTO_INTR_CFG=${AUTO_INTR_CFG:-NO}

	if [ $AUTO_INTR_CFG = YES ]; then
		if [ -z "${OP_MODE[$num]}" ]; then
		OP_MODE[$num]="API"
		fi
	else
		if [ -z "${OP_MODE[$num]}" ]; then
		OP_MODE[$num]="WANPIPE"
		fi
	fi
	
	if [ -z "${PROT_STATUS[$num]}" ]; then
		PROT_STATUS[$num]="Unconfigured"
	fi

	if [ -z "${IP_STATUS[$num]}" ]; then
		IP_STATUS[$num]="Unconfigured"
	fi


	# For each protocol createa special menu
	case $PROTOCOL in

	WAN_FR) 	
		name="wp"$DEVICE_NUM"_fr"${DLCI_NUM[$num]}	
		if [ -z ${DLCI_NUM[$num]} ]; then
	menu_options="'get_dlci'           'DLCI Number  --------> ${DLCI_NUM[$num]}' 2> menu.tmp.$$"
	menu_size=1
		else
	menu_options="'get_dlci'           'DLCI Number  -------------> ${DLCI_NUM[$num]}' \
		      'get_interface_name' 'Interface Name -----------> ${IF_NAME[$num]}' \
		      'get_operation_mode' 'Operation Mode -----------> ${OP_MODE[$num]}' \
		      'prot_inter_setup'   'DLCI Protocol Setup ------> ${PROT_STATUS[$num]}' \\"
			echo "$menu_options" > dev_options.$$

		if [ ${OP_MODE[$num]} = WANPIPE ] || \
			[ ${OP_MODE[$num]} = BRIDGE_NODE ]; then	
	
	menu_options="'ip_setup'           'DLCI IP Address Setup ----> ${IP_STATUS[$num]}' \\"
				echo "$menu_options" >> dev_options.$$
			fi

			menu_options="2> menu.tmp.$$" 
			echo "$menu_options" >> dev_options.$$

			menu_options=`cat dev_options.$$`
			rm -f dev_options.$$
			menu_size=5
		fi
			;;
	WAN_CHDLC)
	 	name="wp"$DEVICE_NUM"_chdlc"
		if [ -z ${IF_NAME[$num]} ]; then
			IF_NAME[$num]=$name	
		fi
	menu_options="'get_interface_name' 'Interface Name -----------> ${IF_NAME[$num]}' \
		      'get_operation_mode' 'Operation Mode -----------> ${OP_MODE[$num]}' \
		      'prot_inter_setup'   'CHDLC Protocol Setup -----> ${PROT_STATUS[$num]}' \\"
		echo "$menu_options" > dev_options.$$	

		if [ ${OP_MODE[$num]} = WANPIPE ]; then	
		menu_options="'ip_setup'           'IP Address Setup ---------> ${IP_STATUS[$num]}' \\"
			echo "$menu_options" >> dev_options.$$
		fi

		menu_options="2> menu.tmp.$$" 
		echo "$menu_options" >> dev_options.$$

		menu_options=`cat dev_options.$$`
		rm -f dev_options.$$
		menu_size=4
			;;
	WAN_BITSTRM)

		name="wp"$DEVICE_NUM"_bstrm"
		if [ -z ${IF_NAME[$num]} ]; then
			IF_NAME[$num]=$name	
		fi
		OP_MODE[$num]=API;
		
	menu_options="'get_interface_name' 'Interface Name -----------> ${IF_NAME[$num]}' \
		      'get_operation_mode' 'Operation Mode -----------> ${OP_MODE[$num]}' \\"
		echo "$menu_options" > dev_options.$$	

		menu_options="2> menu.tmp.$$" 
		echo "$menu_options" >> dev_options.$$

		menu_options=`cat dev_options.$$`
		rm -f dev_options.$$
		menu_size=3
			;;

	WAN_BSC)

		name="wp"$DEVICE_NUM"_bsc"
		if [ -z ${IF_NAME[$num]} ]; then
			IF_NAME[$num]=$name	
		fi
		OP_MODE[$num]=API;
		
		menu_options="'get_interface_name' 'Interface Name -----------> ${IF_NAME[$num]}' \\"
		echo "$menu_options" > dev_options.$$	

		menu_options="2> menu.tmp.$$" 
		echo "$menu_options" >> dev_options.$$

		menu_options=`cat dev_options.$$`
		rm -f dev_options.$$
		menu_size=3
		;;


	WAN_MULTPPP)
		name="wp"$DEVICE_NUM"_mppp"
		if [ -z ${IF_NAME[$num]} ]; then
			IF_NAME[$num]=$name	
		fi
		if [ -z ${MPPP_PROT[$num]} ]; then
			MPPP_PROT[$num]="MP_PPP"
		fi
		if [ -z ${MPPP_MODEM_IGNORE[$num]} ]; then
			MPPP_MODEM_IGNORE[$num]="YES"
		fi
		
	menu_options="'get_interface_name' 'Interface Name -----------> ${IF_NAME[$num]}' \
		      'get_operation_mode' 'Operation Mode -----------> ${OP_MODE[$num]}' \
		      'get_ppp_chdlc_mode' 'Protocol  ----------------> ${MPPP_PROT[$num]}' \
		      'get_modem_ignore'   'Ignore Modem Status ------> ${MPPP_MODEM_IGNORE[$num]}' \\"

		echo "$menu_options" > dev_options.$$	

		if [ ${OP_MODE[$num]} = WANPIPE ]; then	
	menu_options="'ip_setup'           'IP Address Setup ---------> ${IP_STATUS[$num]}' \\"
			echo "$menu_options" >> dev_options.$$
		fi

		menu_options="2> menu.tmp.$$" 
		echo "$menu_options" >> dev_options.$$

		menu_options=`cat dev_options.$$`
		rm -f dev_options.$$
		menu_size=5
		;;

	WAN_PPP)
	 	name="wp"$DEVICE_NUM"_ppp"
		if [ -z ${IF_NAME[$num]} ]; then
			IF_NAME[$num]=$name	
		fi
	menu_options="'get_interface_name' 'Interface Name -----------> ${IF_NAME[$num]}' \
		      'get_operation_mode' 'Operation Mode -----------> ${OP_MODE[$num]}' \
		      'prot_inter_setup'   'PPP Protocol Setup -------> ${PROT_STATUS[$num]}' \
		      'ip_setup'           'IP Address Setup ---------> ${IP_STATUS[$num]}' 2> menu.tmp.$$"
		menu_size=4
			;;

	WAN_X25)
		CH_TYPE[$num]=${CH_TYPE[$num]:-SVC}

		#If X25API is to be used as LAPB HDLC only than,
       	 	#only interface allowed is PVC.
		if [ ! -z "$LAPB_HDLC_ONLY" ]; then
			if [ $LAPB_HDLC_ONLY = YES ]; then
				CH_TYPE[$num]="PVC"
			fi
		else
			LAPB_HDLC_ONLY="NO"	
		fi

		name="wp"$DEVICE_NUM"_svc"$num
		if [ -z ${IF_NAME[$num]} ]; then
			IF_NAME[$num]=$name	
		fi

	menu_options="'get_interface_name' 'Interface Name -----------> ${IF_NAME[$num]}' \
		      'get_operation_mode' 'Operation Mode -----------> ${OP_MODE[$num]}' \
		      'get_channel_type'   'Channel Type -------------> ${CH_TYPE[$num]}' \\"


		echo "$menu_options" > dev_options.$$

		if [ ${OP_MODE[$num]} = WANPIPE ]; then
			if [ ${CH_TYPE[$num]} = PVC ]; then
				X25_ADDR[$num]=${X25_ADDR[$num]:-1}	
		menu_options="'get_x25_address'    'LCN Number  --------------> ${X25_ADDR[$num]}' \\"
			echo "$menu_options" >> dev_options.$$	
			else
		menu_options="'again' 	        'Place Call Addr' \
			      'get_x25_address' '   Destination (-d) Addr -> ${X25_ADDR[$num]}' \
			      'get_src_addr'   	'   Source      (-s) Addr -> ${SRC_ADDR[$num]}' \
			      'again' 	        'Accept Call Addr' \
		    'get_accept_dest_addr'  	'   Accept Dest (-d) Addr -> ${X25_ACC_DST_ADDR[$num]}' \
		    'get_accept_src_addr'       '   Accept Src  (-s) Addr -> ${X25_ACC_SRC_ADDR[$num]}' \
		    'get_accept_usr_data'	'   Accept User (-u) Data -> ${X25_ACC_USR_DATA[$num]}' \\"
			echo "$menu_options" >> dev_options.$$	
			fi
		fi
		

		if [ ${OP_MODE[$num]} = WANPIPE -a ${CH_TYPE[$num]} = SVC ]; then
	menu_options="'prot_inter_setup'   'X25 Protocol Setup -------> ${PROT_STATUS[$num]}' \\"
			echo "$menu_options" >> dev_options.$$	
		else
			PROT_STATUS[$num]="Setup Done"
			IDLE_TIMEOUT[$num]=90
			HOLD_TIMEOUT[$num]=10
		fi
	
		
		if [ ${OP_MODE[$num]} = WANPIPE ]; then	
	menu_options="'ip_setup'           'IP Address Setup ---------> ${IP_STATUS[$num]}' \\"
			echo "$menu_options" >> dev_options.$$
		fi

	menu_options="2> menu.tmp.$$" 
	echo "$menu_options" >> dev_options.$$

	menu_options=`cat dev_options.$$`
	rm -f dev_options.$$

		menu_size=8;
			;;
	esac


	#Now that the menu is created, set the menu instructions
        #and print the menu to the screen. Once the menu is 
        #printed wait for user input.

	menu_instr="	Please specify interface parameters below.	\
									"

	menu_name "INTERFACE $num DEFINITION" "$menu_options" "$menu_size" "$menu_instr" "$BACK"
	rc=$?

	choice=`cat menu.tmp.$$`
	rm -f menu.tmp.$$


	#We received user input, now take appropriate action
	case $rc in
		0)	case $choice in
			get_interface_name)
				get_string "Please specify a Network Interface Name" "$name"
				IF_NAME[$num]=$($GET_RC)
				name=${IF_NAME[$num]}
				;;
			get_dlci)
				get_integer "Please specify a DLCI number" "16" "16" "16000" "interface_menu_help get_dlci"

				DLCI_NUM[$num]=$($GET_RC)
				IF_NAME[$num]="wp"$DEVICE_NUM"_fr"${DLCI_NUM[$num]}
				name=${IF_NAME[$num]}
				;;
			get_x25_address)
				if [ ${CH_TYPE[$num]} = PVC ]; then
				get_integer "Please specify a PVC LCN number." "1" "1" "4096" "interface_menu_help get_x25_address"
				else
				get_string "Please specify the SVC destination/called (-d) address to be used in placing outgoing calls. (Leave blank to disable outgoing calls)." ""
				fi
				X25_ADDR[$num]=$($GET_RC)
				;;
			
			get_src_addr)
				get_string "Please specify the SVC source/calling (-s) address to be used in placing outgoing calls. If blank: not used." ""
				SRC_ADDR[$num]=$($GET_RC)
				;;

			get_accept_dest_addr)
				get_string "Please specify the incoming, SVC, destination/called (-d) address matching pattern. (eg: * accept all)." ""
				X25_ACC_DST_ADDR[$num]=$($GET_RC)
				;;

			get_accept_src_addr)
				get_string "Please specify the incoming, SVC, source/calling (-s) address matching pattern. (eg: * accept all)." ""
				X25_ACC_SRC_ADDR[$num]=$($GET_RC)
				;;

			get_accept_usr_data)
				get_string "Please specify the incoming, SVC, user data (-u) matching pattern. (eg: * accept all)." ""
				X25_ACC_USR_DATA[$num]=$($GET_RC)
				;;

			again)
				;;

			*)
				$choice "$num"    #Choice is a command 
				;;
			esac
			return 0 
			;;

		1) 	
			#EXIT to previous screen
			return 1
			;;

		2)	
			#HELP
			choice=${choice%\"*\"}
			choice=${choice// /}
			interface_menu_help $choice
			return 0
			;;
		*)	
			#EXIT to previous screen
			return 1
	esac

}

#============================================================
# get_device_setup
#
# 	General Hardware Setup
#	All [wanpipe#] variables configued in the area
#	
#============================================================
function gen_device_setup () {

	local rc
	local choice
	local menu_options
	local menu_options0
	local menu_options1
	local menu_options2
	local menu_opt_prot
	local frim_name
	local menu_size

	if [ -z "$DEVICE_TYPE" ]; then
		DEVICE_TYPE=S514
	fi
	# TE1 Set default value 
	if [ -z "$DEVICE_TE1_TYPE" ]; then
		DEVICE_TE1_TYPE=NO
	fi
	if [ -z "$DEVICE_56K_TYPE" ]; then
		DEVICE_56K_TYPE=NO
	fi

	AUTO_PCI_CFG=${AUTO_PCI_CFG:-YES}
	IGNORE_FRONT_END=${IGNORE_FRONT_END:-NO}

	#Setup protocol specific menues
	if [ $DEVICE_TE1_TYPE = NO ]; then
		if [ $DEVICE_56K_TYPE = NO ]; then
		menu_options0="'probe_wanpipe_hw'      'Probe Hardware' \
			       'get_device_type'       'Adapter Type ---> $DEVICE_TYPE' \\"
		else
		menu_options0="'probe_wanpipe_hw'      'Probe Hardware' \
		               'get_device_type'       'Adapter Type ---> S514 56K' \\"
		fi
	else
		menu_options0="'probe_wanpipe_hw'      'Probe Hardware' \
			       'get_device_type'       'Adapter Type ---> S514 T1/E1' \\"
	fi

	if [ $DEVICE_TYPE = S514 ]; then
		if [ $AUTO_PCI_CFG = NO ]; then
		menu_options1="'get_s514_cpu'  'S514CPU --------> $S514CPU' \
			       'get_s514_auto' 'AUTO_PCISLOT ---> $AUTO_PCI_CFG' \
			       'get_s514_slot' 'PCISLOT --------> $PCISLOT' \
			       'get_s514_bus'  'PCIBUS ---------> $PCIBUS' \\"
		else
		menu_options1="'get_s514_cpu'  'S514CPU --------> $S514CPU' \
			       'get_s514_auto' 'AUTO_PCISLOT ---> $AUTO_PCI_CFG' \\"
		fi
	else
		menu_options1="'get_s508_io'   'IOPORT ---------> $IOPORT' \
			       'get_s508_irq'  'IRQ ------------> $IRQ' \\"
	fi


	if  [ $PROTOCOL = WAN_TTYPPP -a $TTY_MODE = Async ]; then
	
	menu_options2="'get_firmware'  'Firmware Module-> $FIRMWARE' \
		       'get_memory'    'Memory Addr ----> $MEMORY' \
		       'get_interface' 'Interface ------> $INTERFACE' \
		       'get_mtu'       'MTU  -----------> $MTU' \
		       'get_udpport'   'UDP Port -------> $UDPPORT' \
		       'get_ttl'       'Time to live ---> $TTL' \\"

	elif [ $DEVICE_56K_TYPE = YES ] || [ $DEVICE_TE1_TYPE = YES ]; then
	
	INTERFACE="V35"
	CLOCKING="External"
	BAUDRATE="15400000"

	menu_options2="'get_firmware'  'Firmware Module-> $FIRMWARE' \
		       'get_memory'    'Memory Addr ----> $MEMORY' \
		       'get_mtu'       'MTU  -----------> $MTU' \
		       'get_udpport'   'UDP Port -------> $UDPPORT' \
		       'get_ttl'       'Time to live ---> $TTL' \
		       'get_ignore_fe' 'Ignore Front End> $IGNORE_FRONT_END' \\"
	
	elif [ $CLOCKING = "External" ]; then

	BAUDRATE="15400000"
	menu_options2="'get_firmware'  'Firmware Module-> $FIRMWARE' \
		       'get_memory'    'Memory Addr ----> $MEMORY' \
		       'get_interface' 'Interface ------> $INTERFACE' \
		       'get_clocking'  'Clocking -------> $CLOCKING' \
		       'get_mtu'       'MTU  -----------> $MTU' \
		       'get_udpport'   'UDP Port -------> $UDPPORT' \
		       'get_ttl'       'Time to live ---> $TTL' \
		       'get_ignore_fe' 'Ignore Front End> $IGNORE_FRONT_END' \\"

	else

	menu_options2="'get_firmware'  'Firmware Module-> $FIRMWARE' \
		       'get_memory'    'Memory Addr ----> $MEMORY' \
		       'get_interface' 'Interface ------> $INTERFACE' \
		       'get_clocking'  'Clocking -------> $CLOCKING' \
		       'get_baudrate'  'Baud Rate ------> $BAUDRATE' \
		       'get_mtu'       'MTU  -----------> $MTU' \
		       'get_udpport'   'UDP Port -------> $UDPPORT' \
		       'get_ttl'       'Time to live ---> $TTL' \
		       'get_ignore_fe' 'Ignore Front End> $IGNORE_FRONT_END' \\"
	fi

	case $PROTOCOL in

	WAN_FR)
	menu_opt_prot="'get_station'   'Station --------> $STATION' \
		       'get_signal'    'Signalling -----> $SIGNAL' \
		       'get_T391'      'T391 -----------> $T391' \
		       'get_T392'      'T392 -----------> $T392' \
		       'get_N391'      'N391 -----------> $N391' \
		       'get_N392'      'N392 -----------> $N392' \
		       'get_N393'      'N393 -----------> $N393' \
		       'get_fs_issue'   'Fast Connect ---> $FR_ISSUE_FS' \\"

		echo "$menu_options0" > dev_options.$$
		echo "$menu_options1" >> dev_options.$$
		echo "$menu_options2" >> dev_options.$$
		echo "$menu_opt_prot" >> dev_options.$$
		menu_size=13
		firm_name=fr514.sfm
		;;

	WAN_CHDLC)
	
		CONNECTION=${CONNECTION:-Permanent};
		LINECODING=${LINECODING:-NRZ};
		LINEIDLE=${LINEIDLE:-Flag};

		menu_opt_prot="'get_commport'  'Comm Port ------> $COMMPORT' \\";
		menu_opt_prot1="'get_connection' 'Connection -----> $CONNECTION' \
		                'get_linecode'  'Line Coding ----> $LINECODING' \
				'get_lineidle'  'Line Idle ------> $LINEIDLE' \\"

		echo "$menu_options0" > dev_options.$$
		echo "$menu_options1" >> dev_options.$$
		echo "$menu_opt_prot" >> dev_options.$$

		if [ $DEVICE_TYPE = S514 ]; then
			menu_opt_prot="'get_rec_only' 'Receive Only ---> $REC_ONLY' \\"
			echo "$menu_opt_prot" >> dev_options.$$
		fi	
		echo "$menu_options2" >> dev_options.$$
		echo "$menu_opt_prot1" >> dev_options.$$
		menu_size=13
		firm_name=cdual514.sfm
		;;

	WAN_BITSTRM)
		COMMPORT=${COMMPORT:-PRI}
	
		menu_opt_prot="'get_commport'  'Comm Port ------> $COMMPORT' \\"
	
		SYNC_OPTIONS=${SYNC_OPTIONS:-0x0001}
		RX_SYNC_CHAR=${RX_SYNC_CHAR:-0x7E}
		MSYNC_TX_TIMER=${MSYNC_TX_TIMER:-0x7E}
		MAX_TX_BLOCK=${MAX_TX_BLOCK:-4096}
		RX_COMP_LEN=${RX_COMP_LEN:-4096}
		RX_COMP_TIMER=${RX_COMP_TIMER:-1500}
	
		menu_opt_prot1="'get_sync_opt'     'Sync Options --------> $SYNC_OPTIONS' \
			       'get_rx_sync_ch'    'Rx sync char --------> $RX_SYNC_CHAR' \
			       'get_msync_fill_ch' 'Monosync fill char --> $MSYNC_TX_TIMER' \
			       'get_max_tx_block'  'Max tx block len ----> $MAX_TX_BLOCK' \
			       'get_rx_comp_length' 'Rx complete len -----> $RX_COMP_LEN' \
			       'get_rx_comp_timer' 'Rx complete timer ---> $RX_COMP_TIMER' \\"
		
		echo "$menu_options0" > dev_options.$$
		echo "$menu_options1" >> dev_options.$$
		echo "$menu_opt_prot" >> dev_options.$$
		echo "$menu_options2" >> dev_options.$$
		echo "$menu_opt_prot1" >> dev_options.$$


		menu_size=13
		firm_name=bitstrm.sfm
		;;

	WAN_BSC)
		COMMPORT=${COMMPORT:-PRI}
	
		echo "$menu_options0" > dev_options.$$
		echo "$menu_options1" >> dev_options.$$
		echo "$menu_options2" >> dev_options.$$

		menu_size=12
		firm_name=bscmp514.sfm
		;;

	WAN_MULTPPP)
		menu_opt_prot="'get_commport'  'Comm Port ------> $COMMPORT' \\"
		echo "$menu_options0" > dev_options.$$
		echo "$menu_options1" >> dev_options.$$
		echo "$menu_opt_prot" >> dev_options.$$
		echo "$menu_options2" >> dev_options.$$
		
		menu_size=13
		firm_name=cdual514.sfm
		;;
	WAN_EDU_KIT)
		echo "$menu_options0" > dev_options.$$
		echo "$menu_options1" >> dev_options.$$
		echo "'get_firmware'  'Firmware Module-> $FIRMWARE' \\" >> dev_options.$$
		menu_size=8
		firm_name=edu_kit.sfm
		;;

	WAN_TTYPPP)
		if [ $TTY_MODE = Async ]; then
		menu_opt_prot="'get_tty_minor' 'TTY Port/Minor -> $TTY_MINOR' \
			       'get_tty_mode'  'TTY Mode -------> $TTY_MODE' \\" 
			       
		else
		menu_opt_prot="'get_commport'  'Comm Port ------> $COMMPORT' \
		               'get_tty_minor' 'TTY Port/Minor -> $TTY_MINOR' \
			       'get_tty_mode'  'TTY Mode -------> $TTY_MODE' \\" 
		fi
		echo "$menu_options0" > dev_options.$$
		echo "$menu_options1" >> dev_options.$$
		echo "$menu_opt_prot" >> dev_options.$$
		echo "$menu_options2" >> dev_options.$$
		
		menu_size=14
		firm_name=cdual514.sfm
		;;
	
	WAN_PPP)
	menu_opt_prot="'get_ipmode'    'IP Mode --------> $IPMODE' \\"
		echo "$menu_options0" > dev_options.$$
		echo "$menu_options1" >> dev_options.$$
		echo "$menu_options2" >> dev_options.$$
		echo "$menu_opt_prot" >> dev_options.$$
		menu_size=12
		firm_name=ppp514.sfm
		;;
		
	WAN_X25)
	menu_opt_prot="'get_hdlc_station' 'Station --------> $STATION' \
		       'get_low_pvc'   	  'Lowest PVC -----> $LOW_PVC' \
		       'get_high_pvc'     'Highest PVC ----> $HIGH_PVC' \
		       'get_low_svc'      'Lowest SVC -----> $LOW_SVC' \
		       'get_high_svc'     'Highest SVC-----> $HIGH_SVC' \
		       'get_hdlc_win'     'HDLC Window ----> $HDLC_WIN' \
		       'get_packet_win'   'Packet Window --> $PACKET_WIN' \
		       'get_ccitt'        'CCITT Compat. --> $CCITT' \
		       'get_hdlc_only'    'LAPB HDLC Only -> $LAPB_HDLC_ONLY' \
		       'get_logging'      'Call Logging ---> $CALL_LOGGING' \
		       'get_oob_modem'	  'OOB Modem Msg --> $OOB_ON_MODEM' \
		       'get_T1'      	  'T1 -------------> $X25_T1' \
		       'get_T2'      	  'T2 -------------> $X25_T2' \
		       'get_T4'      	  'T4 -------------> $X25_T4' \
		       'get_N2'      	  'N2 -------------> $X25_N2' \
		       'get_T10_T20'   	  'T10_T20 --------> $X25_T10_T20' \
		       'get_T11_T21'   	  'T11_T21 --------> $X25_T11_T21' \
		       'get_T12_T22'   	  'T12_T22 --------> $X25_T12_T22' \
                       'get_T13_T23'   	  'T13_T23 --------> $X25_T13_T23' \
		       'get_T16_T26'   	  'T16_T26 --------> $X25_T16_T26' \
		       'get_T16_T26'   	  'T16_T26 --------> $X25_T16_T26' \
		       'get_T28'   	  'T28 ------------> $X25_T28' \
		       'get_R10_R20'   	  'R10_R20 --------> $X25_R10_R20' \
		       'get_R12_R22'   	  'R12_R22 --------> $X25_R12_R22' \
		       'get_R13_R23'   	  'R13_R23 --------> $X25_R13_R23' \\"		
		echo "$menu_options0" > dev_options.$$
		echo "$menu_options1" >> dev_options.$$
		echo "$menu_options2" >> dev_options.$$
		echo "$menu_opt_prot" >> dev_options.$$
		menu_size=13
		firm_name=x25_514.sfm
		;;
	*) 
		echo "ERROR, Protocol not specified"
		return 1
		;;
	esac

	echo " 2> menu.tmp.$$" >> dev_options.$$


	#The menues are completed, now print the menu to the user and 
        #wait for result

	menu_options=`cat dev_options.$$` 
	rm -f dev_options.$$

	menu_instr="	Physical Link: wanpipe$DEVICE_NUM Configuration  \
					"

	menu_name "WANPIPE$DEVICE_NUM HARDWARE CONFIGURATION" "$menu_options" "$menu_size" "$menu_instr" "$BACK" 20 50 
	rc=$?
	
	choice=`cat menu.tmp.$$`
	rm -f menu.tmp.$$

	#We got the result, take appropriate action 
	case $rc in
		0)	case $choice in
				get_s514_auto)
					warning "AUTO_PCI_CFG"
					if [ $? -eq 0 ]; then
						AUTO_PCI_CFG=YES
					else
						AUTO_PCI_CFG=NO
					fi
					;;
				get_s514_slot) 
					get_integer "Please specify a PCI Slot Number (default 0)" "0" "0" "100" "device_setup_help get_s514_slot" 
					PCISLOT=$($GET_RC)      #Choice is a command 
					;;
				get_s514_bus) 
					get_integer "Please specify a PCI Bus Number (default 0)" "0" "0" "100" "device_setup_help get_s514_bus" 
					PCIBUS=$($GET_RC)      #Choice is a command 
					;;
				get_udpport)
					get_integer "Please specify a UDP Port (default 9000, 0 to disable)" "9000" "0" "9999" "device_setup_help get_udpport"
					UDPPORT=$($GET_RC)
					;;
				get_T391)
					get_integer "Please specify the T391 timer (default 10)" "10" "5" "30" "device_setup_help get_T391"
					T391=$($GET_RC)
					;;
				get_T392)
					get_integer "Please specify the T392 timer (default 16)" "16" "5" "30" "device_setup_help get_T392"
					T392=$($GET_RC)
					;;
				get_N391)
					get_integer "Please specify the N391 timer (default 2)" "6" "1" "255" "device_setup_help get_N391"
					N391=$($GET_RC)
					;;	
				get_N392)
					get_integer "Please specify the N392 timer (default 3)" "3" "1" "10" "device_setup_help get_N392"
					N392=$($GET_RC)
					;;
				get_N393)
					get_integer "Please specify the N393 timer (default 4)" "4" "1" "10" "device_setup_help get_N393"
					N393=$($GET_RC)
					;;
				get_ttl)
					get_integer "Please specify the TTL value (default 255)" "255" "1" "255" "device_setup_help get_ttl"
					TTL=$($GET_RC)
					;;
			        get_s508_irq)
					get_integer "Please specify an IRQ number" "7" "1" "15" "device_setup_help get_s508_irq"
					IRQ=$($GET_RC)
					;;
				get_T1)
					get_integer "Please specify the HDLC T1 Timer value" "3" "1" "30" "device_setup_help get_T1"
					X25_T1=$($GET_RC)
					;;
				get_T2)
					if [ $X25_T1 -gt 0 ]; then
						t2_max=$((X25_T1-1))
					else
						t2_max=0
					fi
					get_integer "Please specify the HDLC T2 Timer value. (Must be lower than T1=$X25_T1)." "0" "0" "$t2_max" "device_setup_help get_T2"
					X25_T2=$($GET_RC)
					;;
				get_T4)
					get_integer "Please specify the HDLC T4 Timer value" "240" "0" "240" "device_setup_help get_T4"
					X25_T4=$($GET_RC)
					;;
				
				get_N2)
					get_integer "Please specify the HDLC N2 Timer value" "10" "1" "30" "device_setup_help get_N2"
					X25_N2=$($GET_RC)
					;;

				get_T10_T20)
					get_integer "Please specify the HDLC T10_T20 Timer value" "30" "1" "255" "device_setup_help get_T10_T20"
					X25_T10_T20=$($GET_RC)
					;;
				get_T11_T21)
					get_integer "Please specify the HDLC T11_T21 Timer value" "30" "1" "255" "device_setup_help get_T11_T21"
					X25_T11_T21=$($GET_RC)
					;;
				get_T12_T22)
					get_integer "Please specify the HDLC T12_T22 Timer value" "30" "1" "255" "device_setup_help get_T12_T22"
					X25_T12_T22=$($GET_RC)
					;;
				get_T13_T23)
					get_integer "Please specify the HDLC T13_T23 Timer value" "30" "1" "255" "device_setup_help get_T13_T23"
					X25_T13_T23=$($GET_RC)
					;;
				get_T16_T26)
					get_integer "Please specify the HDLC T16_T26 Timer value" "30" "1" "255" "device_setup_help get_T16_T26"
					X25_T16_T26=$($GET_RC)
					;;
				get_T28)
					get_integer "Please specify the HDLC T28 Timer value" "30" "1" "255" "device_setup_help get_T28"
					X25_T28=$($GET_RC)
					;;
				get_R10_R20)
					get_integer "Please specify the HDLC R10_R20 Timer value" "30" "0" "250" "device_setup_help get_R10_R20"
					X25_R10_20=$($GET_RC)
					;;
				get_R12_R22)
					get_integer "Please specify the HDLC R12_R22 Timer value" "30" "0" "250" "device_setup_help get_R12_R22"
					X25_R12_22=$($GET_RC)
					;;
				get_R13_R23)
					get_integer "Please specify the HDLC R13_R23 Timer value" "30" "0" "250" "device_setup_help get_R13_R23"
					X25_R13_23=$($GET_RC)
					;;
				
				get_tty_minor)
					get_integer "Please specify the TTY Port/Minor number: /dev/ttyWPX where X={0,1,2,3}" "0" "0" "3" "device_setup_help get_tty_minor"
					TTY_MINOR=$($GET_RC)
					;;
				
				get_firmware)
					while true
					do
						get_string "Specify the location of the Firmware (.sfm) module: Absolute Path" "$PROD_HOME/firmware" 
						FIRMWARE=$($GET_RC)
						if [ -d "$FIRMWARE" ]; then
							break
						else
							error "FIRMWARE"
						fi
					done
					;;
				get_baudrate)
					if [ $DEVICE_TYPE = S514 ]; then
					get_integer "Please specify the Baud Rate in bps" "1544000" "64" "4096000" "device_setup_help get_baudrate"

					else
					get_integer "Please specify the Baud Rate in bps" "1544000" "64" "2048000" "device_setup_help get_baudrate" 
					fi
					BAUDRATE=$($GET_RC)
					;;
				get_mtu)
					if [ $PROTOCOL = WAN_X25 ]; then
						dflt_mtu=1024;
					else
						dflt_mtu=1500;
					fi
					get_integer "Please specify Maximu Packet Size (MTU)" "$dflt_mtu" "128" "4098" "device_setup_help get_mtu"
					MTU=$($GET_RC)
					;;
				get_low_pvc)
					get_integer "Please specify Lowest PVC Channel" "0" "0" "100000" "device_setup_help get_low_pvc"
					LOW_PVC=$($GET_RC)
					;;
				get_high_pvc)
					get_integer "Please specify Highest PVC Channel" "0" "0" "100000" "device_setup_help get_high_pvc"
					HIGH_PVC=$($GET_RC)
					;;
				get_low_svc)
					get_integer "Please specify Lowest SVC Channel" "0" "0" "100000" "device_setup_help get_low_svc"
					LOW_SVC=$($GET_RC)
					;;
				get_high_svc)
					get_integer "Please specify Highest SVC Channel" "0" "0" "100000" "device_setup_help get_high_svc"
					HIGH_SVC=$($GET_RC)
					;;
				get_hdlc_win) 
					get_integer "Please specify HDLD Window Size" "7" "1" "7" "device_setup_help get_hdlc_win"
					HDLC_WIN=$($GET_RC)
					;;
				get_packet_win)
					get_integer "Please specify Packet Window Size" "7" "1" "7" "device_setup_help get_packet_win"
					PACKET_WIN=$($GET_RC)				
					;;
				get_sync_opt)
					get_string "Please specify bitstrm Sync options" "$SYNC_OPTIONS" 
					SYNC_OPTIONS=$($GET_RC)
					;;

 				get_rx_sync_ch)
					get_string "Please specify bitstrm Rx sync char" "$RX_SYNC_CHAR"
					RX_SYNC_CHAR=$($GET_RC)
					;;
					
			       get_msync_fill_ch)
			       		get_string "Please specify bitstrm Monosync fill char" "$MSYNC_TX_TIMER"
					MSYNC_TX_TIMER=$($GET_RC)
					;;
					
			       get_max_tx_block)
			       		get_string "Please specify bitstrm Max tx block len" "$MAX_TX_BLOCK" 
					MAX_TX_BLOCK=$($GET_RC)
					;;
					
			       get_rx_comp_length)
			       		get_string "Please specify bitstrm Rx complete len" "$RX_COMP_LEN" 
 					RX_COMP_LEN=$($GET_RC)
					;;
					
			       get_rx_comp_timer)
			       		get_string "Please specify bitstrm Rx complete timer" "$RX_COMP_TIMER" 
					RX_COMP_TIMER=$($GET_RC)
					;;

				*)	$choice     #Choice is a command 
					;;
			esac
			return 0
			;;
		2)	choice=${choice%\"*\"}
			choice=${choice// /}
			device_setup_help $choice
			return 0	
			;;
		*)  	return 1	
			;;
	esac
}

#============================================================
# TE1
# get_device_te_setup
#
# 	General T1/E1 Hardware Setup
#	
#============================================================
function gen_device_te_setup () {

	local menu_opt_te1
	local menu_size

	if [ $MEDIA = T1 ]; then
	menu_opt_te1=" 'get_media_type' 'MEDIA ----------> $MEDIA' \
		       'get_lcode_type' 'Line decoding --> $LCODE' \
		       'get_frame_type' 'Framing --------> $FRAME' \
		       'get_te_clock'   'TE clock mode --> $TE_CLOCK' \
		       'get_active_chan' 'Act. channels --> $ACTIVE_CH' \
		       'get_lbo_type'   'LBO ------------> $LBO' \\"
	menu_size=6
	else
	menu_opt_te1=" 'get_media_type' 'MEDIA ----------> $MEDIA' \
		       'get_lcode_type' 'Line decoding --> $LCODE' \
		       'get_frame_type' 'Framing --------> $FRAME' \
		       'get_te_clock'   'TE clock mode --> $TE_CLOCK' \
		       'get_active_chan' 'Act. channels --> $ACTIVE_CH' \\"
	menu_size=5
	fi

	echo "$menu_opt_te1" >> dev_options.$$
	echo " 2> menu.tmp.$$" >> dev_options.$$


	#The menues are completed, now print the menu to the user and 
        #wait for result

	menu_options=`cat dev_options.$$` 
	rm -f dev_options.$$

	menu_instr=""

	menu_name "WANPIPE$DEVICE_NUM T1/E1 HARDWARE CONFIGURATION" "$menu_options" "$menu_size" "$menu_instr" "$BACK" 20 50 
	rc=$?
	
	choice=`cat menu.tmp.$$`
	rm -f menu.tmp.$$


	#We got the result, take appropriate action 
	case $rc in
		0)	$choice #Choice is a command
			return 0
			;;
		2)	choice=${choice%\"*\"}
			choice=${choice// /}
			device_setup_help $choice
			return 0	
			;;
		*)  	return 1	
			;;
	esac
}



function ip_setup_menu () {
	
	local ret
	local rc
	local menu_options
	local num="$1"

	if [ -z "${NMSK_IP[$num]}" ]; then

		#The BRIDGE NODE netmask cannot be 255.255.255.255
		#because the routing table will not be updated
		#on startup.  Reason: no PointoPoint address.
		if [ ${OP_MODE[$num]} = "BRIDGE_NODE" ]; then
			NMSK_IP[$num]="255.255.255.0"
		else
			NMSK_IP[$num]="255.255.255.255"
		fi
	fi
	if [ -z "${DEFAULT_IP[$num]}" ]; then
		DEFAULT_IP[$num]=NO
		NETWRK_IP[$num]=" "
	fi

	DYNAMIC_INTR[$num]=${DYNAMIC_INTR[$num]:-NO}

	if [ ${OP_MODE[$num]} = BRIDGE_NODE ]; then

		if [ ${DEFAULT_IP[$num]} = NO ]; then
	menu_options="'get_local_ip' 'Local IP Addr. ------------> ${L_IP[$num]}' \
		      'get_netmask'  'Net Mask IP Addr. ---------> ${NMSK_IP[$num]}' \
		      'get_default'  'Default Gateway -----------> ${DEFAULT_IP[$num]}' 2> menu.tmp.$$"
		else
	menu_options="'get_local_ip' 'Local IP Addr. ------------> ${L_IP[$num]}' \
		      'get_netmask'  'Net Mask IP Addr. ---------> ${NMSK_IP[$num]}' \
		      'get_default'  'Default Gateway -----------> ${DEFAULT_IP[$num]}'\
		      'get_gate_ip'  '        Gateway IP --------> ${GATE_IP[$num]}' 2> menu.tmp.$$"
		fi

	else
		if [ ${DEFAULT_IP[$num]} = NO ]; then
	menu_options="'get_local_ip' 'Local IP Addr. ------------> ${L_IP[$num]}' \
		      'get_rmt_ip'   'Point-to-Point IP Addr.----> ${R_IP[$num]}' \
		      'get_netmask'  'Net Mask IP Addr. ---------> ${NMSK_IP[$num]}' \
		      'get_dyn_intr' 'Dynamic Interface Config --> ${DYNAMIC_INTR[$num]}'\
		      'get_default'  'Default Gateway -----------> ${DEFAULT_IP[$num]}' 2> menu.tmp.$$"
		else
	menu_options="'get_local_ip' 'Local IP Addr. ------------> ${L_IP[$num]}' \
		      'get_rmt_ip'   'Point-to-Point IP Addr.----> ${R_IP[$num]}' \
		      'get_netmask'  'Net Mask IP Addr. ---------> ${NMSK_IP[$num]}' \
		      'get_dyn_intr' 'Dynamic Interface Config --> ${DYNAMIC_INTR[$num]}'\
		      'get_default'  'Default Gateway -----------> ${DEFAULT_IP[$num]}' \
		      'get_gate_ip'  '        Gateway IP --------> ${GATE_IP[$num]}' 2> menu.tmp.$$"
		fi

	fi
	
	menu_instr="	Interface specify IP addresses supplied by your ISP \
				"
  	menu_name "${IF_NAME[$num]}: IP CONFIGURATION" "$menu_options" 6 "$menu_instr" "$BACK" 20 50 
	rc=$?
	
	choice=`cat menu.tmp.$$`
	rm -f menu.tmp.$$

	case $rc in

		0) 
			case $choice in
			get_local_ip)
				get_string "Please specify the Local IP Address" "${L_IP[$num]}" "IP_ADDR" 
				L_IP[$num]=$($GET_RC)
				;;
			get_rmt_ip)
				get_string "Please specify the Point-to-Point IP Address" "${R_IP[$num]}" "IP_ADDR"
				R_IP[$num]=$($GET_RC)
				;;
			get_netmask)
				get_string "Please specify the Net Mask Addr" "${NMSK_IP[$num]}" "IP_ADDR"
				NMSK_IP[$num]=$($GET_RC)
				;;
			get_bcast)
				get_string "Please specify the Broadcast IP Address" "${BCAST_IP[$num]}" "IP_ADDR"
				BCAST_IP[$num]=$($GET_RC)
				;;
			#This is not begin used should be removed
			get_network)
				get_string "Please specify the Network IP Address" "${NETWRK_IP[$num]}" "IP_ADDR"
				NETWRK_IP[$num]=$($GET_RC)
				;;
			#This is not being used should be removed
			get_gateway)
				get_string "Please specify the Gateway IP Address" "${GATE_IP[$num]}" "IP_ADDR"
				GATE_IP[$num]=$($GET_RC)
				;;
			get_default)
				warning get_default
				if [ $? -eq 0 ]; then
					DEFAULT_IP[$num]=YES
					GATE_IP[$num]=${R_IP[$num]}
				else
					DEFAULT_IP[$num]=NO
					GATE_IP[$num]=" "
				fi
				;;
			get_gate_ip)
				get_string "Please specify the Gateway IP Address" "${G_IP[$num]}" "GATE_ADDR" 
				GATE_IP[$num]=$($GET_RC)
				;;
			get_dyn_intr)
				warning get_dyn_intr
				if [ $? -eq 0 ]; then
					DYNAMIC_INTR[$num]=YES
				else
					DYNAMIC_INTR[$num]=NO
				fi
				;;

			esac
			return 0
			;;
		2)	choice=${choice%\"*\"}
			choice=${choice// /}
			ip_setup_help $choice	
			return 0 
			;;
		*) return 1
			;;

	esac

}

function get_operation_mode () {

	local ret
	local menu_options
	local num="$1"


	if [ $PROTOCOL = WAN_PPP ]; then
		menu_options="'WANPIPE' 'WANPIPE' 2> menu.tmp.$$" 
	elif [ $PROTOCOL = WAN_FR ]; then
		menu_options="'WANPIPE' 'WANPIPE' \
			      'API' 'API' \
			      'BRIDGE' 'BRIDGE' \
			      'BRIDGE_NODE' 'BRIDGED NODE' 2> menu.tmp.$$"
	elif [ $PROTOCOL = WAN_BITSTRM ]; then
		menu_options="'API' 'API' 2> menu.tmp.$$"

	else
		menu_options="'WANPIPE' 'WANPIPE' \
			      'API' 'API' 2> menu.tmp.$$"
	fi

	AUTO_INTR_CFG=${AUTO_INTR_CFG:-NO}
	
	if [ $AUTO_INTR_CFG = YES ]; then
		if [ $PROTOCOL = WAN_FR ]; then
		menu_options="'API' 'API' \
			      'BRIDGE' 'BRIDGE' 2> menu.tmp.$$"
		else	
		menu_options="'API' 'API' 2> menu.tmp.$$"
		fi
	fi

	menu_instr="Please select Wanpipe Operation Mode \
					"
	menu_name "OPERATION MODE CONFIGURATION" "$menu_options" 4 "$menu_instr" "$BACK"
	retval=$?

	input=`cat menu.tmp.$$`
	rm -f menu.tmp.$$

	case $retval in
	  	0)	OP_MODE[$num]=$input
			return 0 
			;;
	  	1) 	return 1
			;;
		2)	interface_menu_help "get_operation_mode"
			get_operation_mode $1
			;;
	  	255) 	return 1
			;;
	esac       
}


function device_init () {

	#Common
	IOPORT=${IOPORT:-0x360}
	IRQ=${IRQ:-7}
	S514CPU=${S514CPU:-A}
	PCISLOT=${PCISLOT:-0}
	PCIBUS=${PCIBUS:-0}
	INTERFACE=${INTERFACE:-V35}
       	CLOCKING=${CLOCKING:-External}
	FIRMWARE=${FIRMWARE:-$PROD_HOME/firmware}
	MEMORY=${MEMORY:-Auto}
     	BAUDRATE=${BAUDRATE:-1540000}
	FR_ISSUE_FS=${FR_ISSUE_FS:-YES}
	
	CONNECTION=${CONNECTION:-Permanent}
	LINECODING=${LINECODING:-NRZ}
	LINEIDLE=${LINEIDLE:-Flag}


	if [ $PROTOCOL = WAN_X25 ]; then
		MTU=${MTU:-1024}
	else
		MTU=${MTU:-1500}
	fi
	UDPPORT=${UDPPORT:-9000}

	#PPP Specific
	IPMODE=${IPMODE:-STATIC}

	#Chdlc Specific
	COMMPORT=${COMMPORT:-PRI}
	REC_ONLY=${REC_ONLY:-NO}
	TTY_MINOR=${TTY_MINOR:-0}
	TTY_MODE=${TTY_MODE:-Sync}

	#Frame Relay Specific
	if [ $PROTOCOL = WAN_FR ]; then
		STATION=${STATION:-CPE}
	else
		STATION=${STATION:-DTE}
	fi
	SIGNAL=${SIGNAL:-ANSI}
	T391=${T391:-10}
	T392=${T392:-16}
	N391=${N391:-6}
	N392=${N392:-3}
	N393=${N393:-4}
	TTL=${TTL:-255} 

	#X25 Specific
	if [ $PROTOCOL = WAN_X25 ]; then
		LOW_PVC=${LOW_PVC:-0}
		HIGH_PVC=${HIGH_PVC:-0}
		LOW_SVC=${LOW_SVC:-0}
		HIGH_SVC=${HIGH_SVC:-0}
		HDLC_WIN=${HDLC_WIN:-7}
		PACKET_WIN=${PACKET_WIN:-7}
		CCITT=${CCITT:-1988}
		LAPB_HDLC_ONLY=${LAPB_HDLC_ONLY:-NO}
		CALL_LOGGING=${CALL_LOGGING:-YES}
		OOB_ON_MODEM=${OOB_ON_MODEM:-NO}
		X25_T1=${X25_T1:-3}
		X25_T2=${X25_T2:-0}
		X25_T4=${X25_T4:-240}
		X25_N2=${X25_N2:-10}
		X25_T10_T20=${X25_T10_T20:-30}
		X25_T11_T21=${X25_T11_T21:-30}
		X25_T12_T22=${X25_T12_T22:-30}
		X25_T13_T23=${X25_T13_T23:-30}
		X25_T16_T26=${X25_T16_T26:-30}
		X25_T16_T26=${X25_T16_T26:-30}
		X25_T28=${X25_T28:-30}
		X25_R10_R20=${X25_R10_R20:-5}
		X25_R12_R22=${X25_R12_R22:-5}
		X25_R13_R23=${X25_R13_R23:-5}
	fi
}

# TE1 Initialize T1/E1 hardware parameters
function device_te_init() {

	DEVICE_TE1_TYPE=${DEVICE_TE1_TYPE:-NO}
	MEDIA=${MEDIA:-T1}
	LCODE=${LCODE:-B8ZS}
	FRAME=${FRAME:-ESF}
	ACTIVE_CH=${ACTIVE_CH:-ALL}
	LBO=${LBO:-0DB}
	TE_CLOCK=${TE_CLOCK:-NORMAL}
}

function get_multicast () {

	local menu_options
	local rc
	local choice
	local num="$1"

	menu_options="'NO'  'Disable Multicast (default)' \
		      'YES' 'Enable Multicast' 2> menu.tmp.$$"


	menu_instr="Enable or Disable Multicast Option \
						"

	menu_name "${IF_NAME[$num]}: MULTICAST CONFIGURATION" "$menu_options" 2 "$menu_instr" "$BACK"
	rc=$?

	choice=`cat menu.tmp.$$`
	rm -f menu.tmp.$$

	case $rc in
		0) 	MULTICAST[$num]=$choice     #Choice is a command 
			return 0
			;;
		2)	interface_setup_help "get_multicast"
			get_multicast "$1"
			;;
		*) 	return 1
			;;
	esac

}




function get_s514_cpu () {
 
	local menu_options
	local rc
	local choice

	menu_options="'A' 'CPU A' \
		      'B' 'CPU B' 2> menu.tmp.$$"


	menu_instr="Please select S514 PCI, CPU Number \
						"

	menu_name "S514 CPU CONFIGURATION" "$menu_options" 2 "$menu_instr" "$BACK"
	rc=$?

	choice=`cat menu.tmp.$$`
	rm -f menu.tmp.$$

	case $rc in
		0) 	S514CPU=$choice     #Choice is a command 
			return 0
			;;
		2)	device_setup_help "get_s514_cpu"
			get_s514_cpu
			;;
		*) 	return 1
			;;
	esac
}


function get_tty_mode () {
 
	local menu_options
	local rc
	local choice

	menu_options="'Sync'  'Sync Leased Line' \
		      'Async' 'Async Serial Line' 2> menu.tmp.$$"


	menu_instr="Please select the Wanpipe TTY operation mode \
						"

	menu_name "WANPIPE TTY CONFIGURATION" "$menu_options" 2 "$menu_instr" "$BACK"
	rc=$?

	choice=`cat menu.tmp.$$`
	rm -f menu.tmp.$$

	case $rc in
		0) 	TTY_MODE=$choice     #Choice is a command 
			if [ $TTY_MODE = Async ]; then
				INTERFACE="RS232";
			fi
			return 0
			;;
		2)	device_setup_help "get_tty_mode"
			get_tty_mode
			;;
		*) 	return 1
			;;
	esac
}


function get_s508_io () {
 
	local menu_options
	local rc
	local choice

	menu_options="'0x360' '0x360-0x363 Io Range (default)' \
		      '0x390' '0x390-0x393 Io Range' \
		      '0x380' '0x380-0x383 Io Range' \
		      '0x350' '0x350-0x352 Io Range' \
		      '0x300' '0x300-0x393 Io Range' \
		      '0x280' '0x280-0x283 Io Range' \
		      '0x270' '0x270-0x273 Io Range' \
		      '0x250' '0x250-0x253 Io Range' 2> menu.tmp.$$"

	menu_instr="Please select S508, IO Range. Refer to hardware manual \
								"
	menu_name "S508 IO PORT CONFIGURATION" "$menu_options" 7 "$menu_instr" "$BACK"
	rc=$?

	choice=`cat menu.tmp.$$`
	rm -f menu.tmp.$$

	case $rc in
		0) 	IOPORT=$choice     #Choice is a command 
			return 0
			;;
		2)  	device_setup_help "get_s508_io"
			get_s508_io
			;;
		*) 	return 1
			;;
	esac
}

	
function get_interface () {
 
	local menu_options
	local rc
	local choice


	if [ -z "$COMMPORT" ]; then
		COMMPORT=PRI
	fi

	if [ $DEVICE_TYPE = S508 -a  $COMMPORT = SEC ];
	then
		menu_options="'RS232' 'RS232 Interface' 2> menu.tmp.$$"
	else
		menu_options="'V35' 'V35 Interface' \
		      	      'RS232' 'RS232 Interface' 2> menu.tmp.$$"

	fi

	menu_instr="Please select $DEVICE_TYPE, Interface Type \
						"

	menu_name "WAN INTERFACE CONFIGURATION" "$menu_options" 2 "$menu_instr" "$BACK"
	rc=$?

	choice=`cat menu.tmp.$$`
	rm -f menu.tmp.$$

	case $rc in
		0) 	INTERFACE=$choice     #Choice is a command 
			return 0
			;;
		2) 	device_setup_help "get_interface"
			get_interface
			;;
		*) 	return 1
			;;
	esac
}


function get_ignore_fe () {
 
	local menu_options
	local rc
	local choice


	menu_instr="Please Enable or Disable Front End Status \
						"

	menu_options="'NO'  'FRONT END should/will affect link state' \
	      	      'YES' 'Ignore FRONT END: will NOT affect link state' 2> menu.tmp.$$"

	menu_name "FRONT END STATUS CONFIGURATION" "$menu_options" 2 "$menu_instr" "$BACK"
	rc=$?

	choice=`cat menu.tmp.$$`
	rm -f menu.tmp.$$

	case $rc in
		0) 	IGNORE_FRONT_END=$choice     #Choice is a command 
			return 0
			;;
		2)	device_setup_help "get_ignore_fe"
			get_ignore_fe
			;;
		*) 	return 1
			;;
	esac
}



function get_clocking () {
 
	local menu_options
	local rc
	local choice


	if [ $DEVICE_TE1_TYPE = "YES" ] || [ $DEVICE_56K_TYPE = "YES" ]; then
		menu_options="'External' 'External Clocking' 2> menu.tmp.$$"
	else
		menu_options="'External' 'External Clocking' \
	      	      'Internal' 'Internal Clocking' 2> menu.tmp.$$"
	fi
	menu_instr="Please specify a Clocking Source \
						"

	menu_name "WANPIPE$DEVICE_NUM CLOCKING CONFIGURATION" "$menu_options" 2 "$menu_instr" "$BACK"
	rc=$?

	choice=`cat menu.tmp.$$`
	rm -f menu.tmp.$$

	case $rc in
		0) 	CLOCKING=$choice     #Choice is a command 
			return 0
			;;
		2)	device_setup_help "get_clocking"
			get_clocking
			;;
		*) 	return 1
			;;
	esac
}

function get_memory () {
 
	local menu_options
	local rc
	local choice


	menu_options="'Auto' 	   'Auto Detect Memory (Default)' \
                      'get_string' 'Custom Setup' 2> menu.tmp.$$"


	menu_instr="Please specify the wanpipe$DEVICE_NUM physical Memory Address. 					\
				"

	menu_name "WANPIPE MEM-ADDR CONFIGURATION" "$menu_options" 2 "$menu_instr" "$BACK"
	rc=$?

	choice=`cat menu.tmp.$$`
	rm -f menu.tmp.$$

	case $rc in
		0) 	if [ $choice = get_string ]; then
				$choice "Please specify Memory Address in Hex" "0xEE000" 
				MEMORY=$($GET_RC)
			else
				MEMORY=$choice     #Choice is a command 
			fi
			return 0
			;;
		2)	device_setup_help "get_memory"
			get_memory
			;;
		*) 	return 1
			;;
	esac
}

function get_device_type () {

	local choice
	local rc

	local probe=${1:-NO}

	

	# TE1 Add new device type
	if [ $probe = "PROBE" ]; then
		menu_options="'S514' 'S514 PCI (V35/FT1) Card' \
			      'S514-te1' 'S514 T1/E1 PCI Card' \
			      'S514-56k' 'S514 56K PCI Card' 2> menu.tmp.$$"
	else
		menu_options="'S514' 'S514 PCI (V35/FT1) Card' \
			      'S514-te1' 'S514 T1/E1 PCI Card' \
			      'S514-56k' 'S514 56K PCI Card' \
			      'S508' 'S508 ISA Card' 2> menu.tmp.$$"
	fi

	menu_instr="Please specify Sangoma Card Type. Refer to User Manual \
									"
	menu_name "SANGOMA CARD TYPE" "$menu_options" 4 "$menu_instr" "$BACK"
	rc=$?

	choice=`cat menu.tmp.$$`
	rm -f menu.tmp.$$

	case $rc in
		0) 	DEVICE_TYPE=$choice     #Choice is a command 
			# TE1 For T1/E1 board, set DEVICE_TYPE to S514 and
			#     set DEVICE_TE1_TYPE to YES
			DEVICE_TE1_TYPE=NO
			DEVICE_56K_TYPE=NO
			if [ $DEVICE_TYPE = S514-te1 ]; then
				DEVICE_TYPE=S514
				DEVICE_TE1_TYPE=YES
			elif [ $DEVICE_TYPE = S514-56k ]; then
				DEVICE_TYPE=S514
				DEVICE_56K_TYPE=YES
			fi
			;;
		2)	device_setup_help "get_device_type" 
			get_device_type
			;;
		*) 	return 1
			;;
	esac
}

# TE1 Select media connection for T1/E1 board.
function get_media_type () {

	local choice
	local rc

	menu_options="'T1' 'T1 connection' \
		      'E1' 'E1 connection' 2> menu.tmp.$$"

	menu_instr="Please specify connection type. Refer to User Manual \
									"
	menu_name "CONNECTION TYPE" "$menu_options" 2 "$menu_instr" "$BACK"
	rc=$?

	choice=`cat menu.tmp.$$`
	rm -f menu.tmp.$$

	case $rc in
		0) 	if [ $MEDIA != $choice ]; then
				MEDIA=$choice     #Choice is a command 
				if [ $MEDIA = T1 ]; then 
					LCODE="B8ZS"
					FRAME="ESF"
				else
					LCODE="HDB3"
					FRAME="NCRC4"
				fi
			fi		
			;;
		2)	device_setup_help "get_media_type" 
			get_media_type
			;;
		*) 	return 1
			;;
	esac
}

# TE1 Select line decoding for T1/E1 board.
function get_lcode_type () {

	local choice
	local rc

	if [ $MEDIA = T1 ]; then
		menu_options="'AMI'  'AMI line decoding' \
		      	      'B8ZS' 'B8ZS line decoding' 2> menu.tmp.$$"
	else
		menu_options="'AMI'  'AMI line decoding' \
			      'HDB3' 'HDB3 line decoding' 2> menu.tmp.$$"
	fi

	menu_instr="Please specify line decoding. Refer to User Manual \
									"
	menu_name "LINE DECODING" "$menu_options" 2 "$menu_instr" "$BACK"
	rc=$?

	choice=`cat menu.tmp.$$`
	rm -f menu.tmp.$$

	case $rc in
		0) 	LCODE=$choice     #Choice is a command 
			;;
		2)	device_setup_help "get_lcode_type" 
			get_lcode_type
			;;
		*) 	return 1
			;;
	esac
}

# TE1 Select frame type for T1/E1 board.
function get_frame_type () {

	local choice
	local rc

	if [ $MEDIA = T1 ]; then
		menu_options="'D4'   'D4 framing format' \
			      'ESF'  'ESF framing format' 2> menu.tmp.$$"
	else
		menu_options="'NCRC4' 'non-CRC4 framing format' \
			      'CRC4'  'CRC4 framing format' 2> menu.tmp.$$"
	fi

	menu_instr="Please specify frame mode. Refer to User Manual \
									"
	menu_name "FRAMING FORMAT" "$menu_options" 2 "$menu_instr" "$BACK"
	rc=$?

	choice=`cat menu.tmp.$$`
	rm -f menu.tmp.$$

	case $rc in
		0) 	FRAME=$choice     #Choice is a command 
			;;
		2)	device_setup_help "get_frame_type" 
			get_frame_type
			;;
		*) 	return 1
			;;
	esac
}

# TE1 Select clock mode for T1/E1 mode.
function get_te_clock () {

	local choice
	local rc

	menu_options="'NORMAL' 'Normal (default)' \
		      'MASTER' 'Master' 2> menu.tmp.$$"

	menu_instr="Please specify T1/E1 clock mode. Refer to User Manual \
									"
	menu_name "T1/E1 CLOCK MODE" "$menu_options" 2 "$menu_instr" "$BACK"
	rc=$?

	choice=`cat menu.tmp.$$`
	rm -f menu.tmp.$$

	case $rc in
		0) 	TE_CLOCK=$choice     #Choice is a command 
			;;
		2)	device_setup_help "get_te_clock" 
			get_te_clock
			;;
		*) 	return 1
			;;
	esac
}

function get_active_chan () {

	local choice
	local rc

	get_string "Please specify the active channels" "$ACTIVE_CH" "get_act_chan"
	rc=$?

	case $rc in
		0) 	ACTIVE_CH=$($GET_RC)     #Choice is a command 
			;;
		1)	device_setup_help "get_active_chan" 
			get_active_chan
			;;
		*) 	return 1
			;;
	esac
}

# TE1 Select LBO type for T1/E1 board (only T1 connection).
function get_lbo_type () {

	local choice
	local rc

	menu_options="'0dB'       'CSU: 0dB' 		\
		      '7.5dB'     'CSU: 7.5dB' 		\
		      '15dB'      'CSU: 15dB' 		\
		      '22.5dB'    'CSU: 22.5dB'		\
		      '0-110ft'   'DSX: 0-110ft'	\
		      '110-220ft' 'DSX: 110-220ft' 	\
		      '220-330ft' 'DSX: 220-330ft' 	\
		      '330-440ft' 'DSX: 330-440ft' 	\
		      '440-550ft' 'DSX: 440-550ft' 	\
		      '550-660ft' 'DSX: 550-660ft' 2> menu.tmp.$$"

	menu_instr="Please specify line build out type. Refer to User Manual \
									"
	menu_name "LINE BUILD OUT" "$menu_options" 10 "$menu_instr" "$BACK"
	rc=$?

	choice=`cat menu.tmp.$$`
	rm -f menu.tmp.$$

	case $rc in
		0) 	LBO=$choice     #Choice is a command 
			;;
		2)	device_setup_help "get_lbo_type" 
			get_lbo_type
			;;
		*) 	return 1
			;;
	esac
}

function get_encoding () {

	local choice
	local rc
	local num=$1

	menu_options="'NO'   'RAW-Pure IP interface type' \
		      'YES'  'True interface encoding typy' 2> menu.tmp.$$"

	menu_instr="Please specify the WANPIPE interface type setting \
									"

	menu_name "WANPIPE INTERFACE TYPE OPTION" "$menu_options" 2 "$menu_instr" "$BACK"
	rc=$?

	choice=`cat menu.tmp.$$`
	rm -f menu.tmp.$$

	case $rc in
		0) 	TRUE_ENCODING[$num]=$choice     #Choice is a command 
			;;
		2)	interface_setup_help "get_encoding" 
			get_encoding $num
			;;
		*) 	return 1
			;;
	esac
}


function probe_wanpipe_hw ()
{
	local devices

	eval "modprobe wanpipe > /dev/null 2> /dev/null"

	if [ ! -e "/proc/net/wanrouter/hwprobe" ]; then
		error "NO_DEV_IN_PROBE"	
		return;
	fi

	devices=`cat /proc/net/wanrouter/hwprobe | cut -d'.' -f2 | grep :`

	if [ -z "$devices" ]; then
		error "NO_DEV_IN_PROBE"	
		return;
	fi

	devices=${devices// /}	
	devices=${devices//:/ }

	echo "$devices" > tmp.$$
	
	while read dev 
	do
		if [ $PROTOCOL = "WAN_FR" ]  || \
		   [ $PROTOCOL = "WAN_PPP" ] || \
		   [ $PROTOCOL = "WAN_BSC" ] || \
		   [ $PROTOCOL = "WAN_X25" ]; then
			
			unset val
			val=`echo $dev | grep SEC`
			if [ ! -z "$val" ]; then
				continue
			fi
		fi
		echo "'$dev'   '$dev' \\" >> dev_probe.$$ 
	done < tmp.$$

	rm -f tmp.$$

	echo " 2> menu.tmp.$$" >> dev_probe.$$

	menu_options=`cat dev_probe.$$`
	rm -f dev_probe.$$
	
	menu_instr="Please select a WANPIPE device \
											"
	menu_name "WANPIPE HARDWARE PROBE INFO" "$menu_options" 8 "$menu_instr" "$BACK" 20 55
	rc=$?

	choice=`cat menu.tmp.$$`
	rm -f menu.tmp.$$

	case $rc in
		0) 	DEVICE_TYPE=${choice%%-*}
			if [ "$DEVICE_TYPE" = "S514" ]; then
				TYPE=`echo $choice | cut -d' ' -f1 | cut -d'-' -f2`
				case $TYPE in
					4)
						DEVICE_TYPE=S514
						DEVICE_TE1_TYPE=YES
						DEVICE_56K_TYPE=NO
						;;
					5)
						DEVICE_TYPE=S514
						DEVICE_TE1_TYPE=NO
						DEVICE_56K_TYPE=YES
						;;
					*)
						DEVICE_TYPE=S514
						DEVICE_TE1_TYPE=NO
						DEVICE_56K_TYPE=NO
						;;
				esac
				
				S514CPU=`echo $choice | cut -d'=' -f5 | cut -d' ' -f1` 
				PCISLOT=`echo $choice | cut -d'=' -f2 | cut -d' ' -f1`
				PCIBUS=`echo $choice | cut -d'=' -f3 | cut -d' ' -f1`
				COMMPORT=`echo $choice | cut -d'=' -f6 | cut -d' ' -f1`
				AUTO_PCI_CFG="NO"
			else
				IOPORT=`echo $choice | cut -d'=' -f2 | cut -d' ' -f1`
				COMMPORT=`echo $choice | cut -d'=' -f3 | cut -d' ' -f1`
			fi
			;;
		2)	device_setup_help "probe_wanpipe_hw" 
			probe_wanpipe_hw
			;;
		*)	return 1
			;;
	esac
		
	return 0;
}




function check_config () {

	local num

	if [ -z "$DEVICE_NUM" ]; then
		error "DEVICE_NUM" 
		return 1
	fi
	
	#Sync TTY PPP has no network interface
	if [ $PROTOCOL = WAN_TTYPPP ] || [ $PROTOCOL = WAN_EDU_KIT ]; then
		return 0
	fi
	
	if [ -z "$NUM_OF_INTER" ]; then
		error "NUM_OF_INTER" 
		return 1
	fi

	if [ $NUM_OF_INTER -eq 0 ]; then
		error "NUM_OF_INTER" 
		return 1
	fi

	if [ -z "$DEVICE_TYPE" ]; then
		error "DEVICE_TYPE" 
		return 1
	fi

	num=0
	while [ $num -ne $NUM_OF_INTER ];
	do
		num=$((num+1))
		if [ -z "${IF_NAME[$num]}" ]; then
			error "IF_NAME" $num
			return 1
		fi

		if [ -z "${DLCI_NUM[$num]}" -a $PROTOCOL = WAN_FR ]; then
			error "DLCI_NUM" $num
			return 1
		fi

		#if [ -z "${X25_ADDR[$num]}" -a $PROTOCOL = WAN_X25 ]; then
		#	error "X25_ADDR" $num
		#	return 1
		#fi
	done

	num=0
	while [ $num -ne $NUM_OF_INTER ];
	do
		num=$((num+1))
		if [ -z "${INTR_STATUS[$num]}" ]; then
			error "INTR_STATUS" $num
			return 1
		fi

		if [ $PROTOCOL = WAN_X25 ]; then
			if [ "${PROT_STATUS[$num]}" = Unconfigured -a  ${CH_TYPE[$num]} = SVC ];
			then
				error "PROT_STATUS" $num
				return 1
			fi
		fi

		if [ "${OP_MODE[$num]}" = "BRIDGE_NODE" ] || [ "${OP_MODE[$num]}" = "BRIDGE" ];
		then
			if  [ $MTU -lt 1520 ]; then
				error "MTU_BRIDGE"
				return 1
			fi
		fi

	done

	num=0
	while [ $num -ne $NUM_OF_INTER ];
	do

		num=$((num+1))

		if [ ${OP_MODE[$num]} = API ] || [ ${OP_MODE[$num]} = BRIDGE ]; then
			continue
		fi

		if [ -z "${IP_STATUS[$num]}" ]; then
			error "IP_STATUS" $num
			return 1
		fi
		if [ -z "${L_IP[$num]}" ]; then
			error "L_IP" $num
			return 1
		fi

		if [ -z "${R_IP[$num]}" ] && [ "${OP_MODE[$num]}" != "BRIDGE_NODE" ]; then
			error "R_IP" $num
			return 1
		fi
		if [ -z "${NMSK_IP[$num]}" ]; then
			error "NMSK_IP" $num
			return 1
		fi

		if [ "${OP_MODE[$num]}" = "BRIDGE_NODE" ] && \
			[ ${NMSK_IP[$num]} = "255.255.255.255" ]; then
			error "NMSK_BRIDGE_IP" $num
			return 1
		fi
	done

	# Check for the X25 Channel, Network intreface
	# matching.  Number of channels must be equal
	# to number of interfaces defined.
	if [ $PROTOCOL = WAN_X25 ]; then

		max_channels=0;
	
		if [ $HIGH_SVC -ne 0 ]; then

			if [ $LOW_SVC -eq 0 ]; then
				error "X25_LOW_SVC_ZERO" 
				return 1;
			fi
		
			max_channels=$((HIGH_SVC-LOW_SVC+1));
		fi

		if [ $HIGH_PVC -ne 0 ]; then

			if [ $LOW_PVC -eq 0 ]; then
				error "X25_LOW_PVC_ZERO"
				return 1;
			fi

			max_channels=$((HIGH_PVC-LOW_PVC + 1 + max_channels))
		
		fi

		if [ $max_channels -ne $NUM_OF_INTER ]; then
			error "X25_CHANNEL_NUM_MISMATCH" 
			return 1
		fi
	fi

}

function parse_config_file () {

	local pvc_tst
	local devname
	IFS="="
	ifnum=0
	num=0

	while read name value ;
	do

		name=${name// /}

		#Convert to upper case
		name=`echo $name | tr a-z A-Z`

		value=${value%%#*}
		value=${value// /}

	#--------- Interface Definition --------------------

		if [ ! -z $DEVICE_NUM ]; then
			devname="wanpipe"$DEVICE_NUM
			case $value in
			
			*$devname*)

				  ifnum=$((ifnum+1))

				  #Conver to lower case
				  name=`echo $name | tr A-Z a-z`

				  IF_NAME[$ifnum]=$name
				  #echo "If_name $ifnum = ${IF_NAME[$ifnum]}"

				  if [ $PROTOCOL = WAN_FR ]; then
					DLCI_NUM[$ifnum]=`echo $value | cut -f2 -d ','`
				  elif [ $PROTOCOL = WAN_X25 ]; then
					X25_ADDR[$ifnum]=`echo $value | cut -f2 -d ','`
					pvc_tst=${X25_ADDR[$ifnum]}
					pvc_tst=${pvc_tst%@*}
					pvc_tst=${pvc_tst// /}
					if [ -z $pvc_tst ]; then
						CH_TYPE[$ifnum]=SVC
						X25_ADDR[$ifnum]=${X25_ADDR[$ifnum]/@/}
					else
						CH_TYPE[$ifnum]=PVC
						X25_ADDR[$ifnum]=$pvc_tst
					fi
				  fi

				  OP_MODE[$ifnum]=`echo $value | cut -f3 -d ','`
				  if [ ${OP_MODE[$ifnum]} = API ]; then
					INTR_STATUS[$ifnum]=setup;
				  fi
				  NUM_OF_INTER=$ifnum
				  ;; 
			esac
		fi
	
	#-----------  Rest of the configuration file --------------------------
	
		case $name in 

		WANPIPE*) DEVICE_NUM=${name##WANPIPE}
			  PROTOCOL=`echo $value | cut -f1 -d ','`
			  case $PROTOCOL in
                          WAN_FR)
                                backtitle="WANPIPE Configuration Utility: Frame Relay Setup"
				firm_name="fr514.sfm"
                                ;;
                          WAN_CHDLC)
                                backtitle="WANPIPE Configuration Utility: CHDLC Setup"
				firm_name="cdual514.sfm"
                                ;;
                          WAN_PPP)
                                backtitle="WANPIPE Configuration Utility: PPP Setup"
				firm_name="ppp514.sfm"
                                ;;
			  WAN_X25)
				backtitle="WANPIPE Configuration Utility: X25 Setup"
				firm_name="x25_514.sfm"
				;;
			  WAN_MULTPPP)
			  	backtitle="WANPIPE Configuration Utility: Sync PPP Setup"
				firm_name="cdual514.sfm"
				;;
			  WAN_TTYPPP)
			  	backtitle="WANPIPE Configuration Utility: Sync/Async TTY PPP Setup"
				firm_name="cdual514.sfm"
				;;
			  WAN_BITSTRM)
			  	backtitle="WANPIPE Configuration Utility: Bit Stream Setup"
				firm_name="bitstrm.sfm"
				;;
			  WAN_EDU_KIT) 
				backtitle="WANPIPE Configuration Utility: Educational Kit Setup"
				firm_name="edu_kit.sfm"
			  	;;
			  WAN_BSC)
			  	backtitle="WANPIPE Configuration Utility: BiSync Setup"
				firm_name="bscmp514.sfm"
			  	;;
			  *)
				echo "Error in parsing $PROD_CONF/wanpipe$DEVICE_NUM.conf"
				echo "Illegal protocol : $PROTOCOL"
				cleanup
				exit 1
				;;
                          esac
	
			  #echo "DEVICE_NUM=$DEVICE_NUM"
			  #echo "Protocol = $PROTOCOL"
			  ;;
			  
	#-----------Hardware Setup ---------------------
		S514CPU*) S514CPU=$value
			  DEVICE_TYPE="S514"
			  #echo "S514CPU=$S514CPU" 
			  ;;
		AUTO_PCISLOT*)
			  AUTO_PCI_CFG=$value
			  ;;
		PCISLOT*) PCISLOT=$value
			  #echo "PCISLOT=$PCISLOT" 
			  ;;
		PCIBUS*)
			  PCIBUS=$value
			  ;;
		IOPORT*)  IOPORT=$value
			  DEVICE_TYPE="S508"
			  #echo "IOPORT=$IOPORT"
			  ;;
		IRQ*)	  IRQ=$value
			  #echo "IRQ=$IRQ"
			  ;;
		# TE1
		MEDIA*)   
			  if [ $value = 56K ]; then
			  	DEVICE_56K_TYPE=YES
			  else
			  	MEDIA=$value
			  	DEVICE_TE1_TYPE=YES
			  fi
			  #echo "MEDIA=$MEDIA" 
			  ;;
		LCODE*)   LCODE=$value
			  #echo "LCODE=$LCODE" 
			  ;;
		FRAME*)   FRAME=$value
			  #echo "FRAME=$FRAME" 
			  ;;
		TE_CLOCK*) TE_CLOCK=$value
			  #echo "TE_CLOCK=$TE_CLOCK" 
			  ;;
		ACTIVE_CH*) ACTIVE_CH=$value
			  #echo "ACTIVE_CH=$ACTIVE_CH" 
			  ;;
		LBO*)     LBO=$value
			  #echo "LBO=$LBO" 
			  ;;
		
		TTY_MINOR*)
			  TTY_MINOR=$value	
	                  ;;
		TTY_MODE*)TTY_MODE=$value
			  ;;
		
		TTY*)   if [ $value = YES ]; then
			PROTOCOL=WAN_TTYPPP
			backtitle="WANPIPE Configuration Utility: Sync/Async TTY PPP Setup"
			firm_name="cdual514.sfm"
			fi
			;;
		
		FIRMWARE*) FIRMWARE=${value%/*}
			  #echo "FIRMWARE=$FIRMWARE" 
			  ;;
		MEMADDR*) MEMORY=${value%/*}
			  #echo "MEMORY=$MEMORY"
			  ;;
		INTERFACE*)INTERFACE=$value
			  #echo "INTERFACE=$INTERFACE" 
			  ;;
		NUMBER_OF_DLCI*)
			  NUMBER_OF_DLCI=$value
			  #echo "NUMBER_OF_DLCI=$NUMBER_OF_DLCI"
			  ;;
		CLOCKING*) CLOCKING=$value
			  #echo "CLOCKING=$CLOCKING" 
			  ;;
		BAUDRATE*) BAUDRATE=$value
			  #echo "BAUDRATE=$BAUDRATE" 
			  ;;
		MTU*)	  MTU=$value
			  #echo "MTU=$MTU" 
			  ;;
		UDPPORT*) UDPPORT=$value
			  #echo "UDPPORT=$UDPPORT" 
			  ;;
		STATION*) STATION=$value
			  #echo "STATION=$STATION" 
			  ;;
		SIGNALLING*) SIGNAL=$value
			    #echo "SIGNAL=$SIGNAL" 
			  ;;
		T391*)	  T391=$value
			  #echo "T391=$T391" 
			  ;;
		T392*)	  T392=$value
			  #echo "T392=$T392" 
			  ;;
		N391*)	  N391=$value
			  #echo "N391=$N391" 
			  ;;
		N392*)	  N392=$value
			  #echo "N392=$N392"
			  ;;
		N393*) 	  N393=$value
			  #echo "N393=$N393" 
			  ;;
		TTL*)	  TTL=$value
			  #echo "TTL=$TTL" 
			  ;;
		IGNORE_FRONT_END*)
			  IGNORE_FRONT_END=$value
			  ;;
		IP_MODE*) IPMODE=$value
			  #echo "IPMODE=$IPMODE"
			  ;;
		COMMPORT*) COMMPORT=$value
			  #echo "COMMPORT=$COMMPORT"
			  ;;
		RECEIVE_ONLY*) REC_ONLY=$value
			  ;;	
		LOWESTPVC*) LOW_PVC=$value
			  #echo "LOWESTPVC=$LOW_PVC"
			  ;;
		HIGHESTPVC*) HIGH_PVC=$value
			  #echo "HIGHESTPVC=$HIGH_PVC"
			  ;;
		LOWESTSVC*) LOW_SVC=$value
			  #echo "LOWESTSVC=$LOW_SVC"
			  ;;
		HIGHESTSVC*) HIGH_SVC=$value
			  #echo "HIGHESTSVC=$HIGH_SVC"
			  ;;
		HDLCWINDOW*) HDLC_WIN=$value
			  #echo "HDLCWINDOW=$HDLC_WIN"
			  ;;
		PACKETWINDOW*) PACKET_WIN=$value 	
			  #echo "PACKETWINDOW=$PACKET_WIN"
			  ;;
		CCITTCOMPAT*) CCITT=$value
			  #echo "CCITTCOMPAT=$CCITT"
			  ;;
		LAPB_HDLC_ONLY*) LAPB_HDLC_ONLY=$value
			  #echo "LAPB_HDLC_ONLY=$LAPB_HDLC_ONLY"
			  ;;
		CALL_SETUP_LOG*) CALL_LOGGING=$value
			  #echo "CALL_SETUP_LOG=$CALL_LOGGING"
			  ;;
		OOB_ON_MODEM*)  OOB_ON_MODEM=$value
			  ;;
		T10_T20*)	X25_T10_T20=$value
			;;
		T11_T21*)	X25_T11_T21=$value
			;;
		T12_T22*)	X25_T12_T22=$value
			;;
		T13_T23*)	X25_T13_T23=$value
			;;
		T16_T26*)	X25_T16_T26=$value
			;;
		T16_T26*)	X25_T16_T26=$value
			;;
		T28*)	X25_T28=$value
			;;
		T1*)	X25_T1=$value
			;;
		T2*)	X25_T2=$value
			;;
		T4*)	X25_T4=$value
			;;
		N2*)	X25_N2=$value
			;;
		R10_R20*)	X25_R10_R20=$value
			;;
		R12_R22*)	X25_R12_R22=$value
			;;
		R13_R23*)	X25_R13_R23=$value
			;;

		SYNC_OPTIONS*)	SYNC_OPTIONS=$value
			;;
		RX_SYNC_CHAR*)
				RX_SYNC_CHAR=$value
			;;
		MONOSYNC_TX_TIME_FILL_CHAR*)
				MSYNC_TX_TIMER=$value
			;;
		MAX_LENGTH_TX_DATA_BLOCK*)
				MAX_TX_BLOCK=$value
			;;
		RX_COMPLETE_LENGTH*)
				RX_COMP_LEN=$value
			;;
		RX_COMPLETE_TIMER*)
				RX_COMP_TIMER=$value
			;;
		FR_ISSUE_FS*)
				FR_ISSUE_FS=$value
			;;

		CONNECTION*)
			CONNECTION=$value;
			;;
		
		LINECODING*)
			LINECODING=$value;
			;;
		
		LINEIDLE*)
			LINEIDLE=$value;
			;;
			
		\[DEVICES\]*)
			;;
		\[INTERFACES\]*)
			;;
		\[WANPIPE*\]*)
			;;
			
	#--------- Interface Setup ---------------------
		\[*\]*) 
			num=$((num+1))
			INTR_STATUS[$num]=setup
			PROT_STATUS[$num]="Setup Done"
			;;

		MULTICAST*) 
			MULTICAST[$num]=$value
			#echo "MULTICAST $num =${MULTICAST[$num]}"
			  ;;
		INARPINTERVAL*) 
			INARP_INT[$num]=$value
			#echo "INARPINTERVAL $num =${INARP_INT[$num]}"
			  ;;
		INARP_RX*)
			INARP_RX[$num]=$value
			;;
		INARP*)   
			INARP[$num]=$value
			#echo "INARP $num =${INARP[$num]}"
			  ;;
		CIR*)  	CIR[$num]=$value
			#echo "CIR $num =${CIR[$num]}"
			  ;;
		BC*)	BC[$num]=$value
			#echo "BC $num =${BC[$num]}"
			  ;;
		BE*)	BE[$num]=$value	
			#echo "BE $num =${BE[$num]}"
			  ;;
		IGNORE_DCD*) 
			DCD[$num]=$value
			MPPP_MODEM_IGNORE[$num]=$value
			#echo "DCD $num =${DCD[$num]}"
			  ;;
		IGNORE_CTS*) 
			CTS[$num]=$value
			MPPP_MODEM_IGNORE[$num]=$value
			#echo "CTS $num =${CTS[$num]}"
			  ;;
		IGNORE_KEEP*)
			KEEP[$num]=$value	
			#echo "KEEP $num =${KEEP[$num]}"
			  ;;
		HDLC_STREAMING*) 
			STREAM[$num]=$value
			#echo "STREAM $num =${STREAM[$num]}"
			  ;;
		KEEPALIVE_TX_TIMER*)
			TXTIME[$num]=$value
			#echo "TXTIME $num =${TXTIME[$num]}"
			  ;;
		KEEPALIVE_RX_TIMER*)
			RXTIME[$num]=$value
			#echo "RXTIME $num =${RXTIME[$num]}"
			  ;;
		KEEPALIVE_ERR_MARGIN*)
			ERR[$num]=$value
			#echo "ERR $num =${ERR[$num]}"
			  ;;
		SLARP_TIMER*)
			SLARP[$num]=$value
			if [ ${SLARP[$num]} -eq 0 ]; then
				CHDLC_IPMODE[$num]=NO;
			else
				CHDLC_IPMODE[$num]=YES;
			fi
			#echo "SLARP $num =${SLARP[$num]}"
			  ;;
		PAP*)
			PAP[$num]=$value
			#echo "PAP $num =${PAP[$num]}"
			  ;;
		CHAP*)	
			CHAP[$num]=$value
			#echo "CHAP $num =${CHAP[$num]}"
			  ;;
		IPX*)
			IPX[$num]=$value
			#echo "IPX $num =${IPX[$num]}"
			  ;;
		NETWORK*)
			NETWORK[$num]=$value
			#echo "NETWORK $num =${NETWORK[$num]}"
			  ;;
		USERID*)
			USERID[$num]=$value
			#echo "USERID $num =${USERID[$num]}"
			  ;;
		PASSWD*)
			PASSWD[$num]=$value
			#echo "PASSWD $num =${PASSWD[$num]}"
			  ;;
		SYSNAME*)
			SYSNAME[$num]=$value
			#echo "SYSNAME $num =${SYSNAME[$num]}"
			  ;;
		IDLETIMEOUT*)
			IDLE_TIMEOUT[$num]=$value
			#echo "IDLETIMEOUT $num =${IDLE_TIMEOUT[$num]}"
			  ;;
		HOLDTIMEOUT*)
			HOLD_TIMEOUT[$num]=$value
			#echo "HOLDTIMEOUT $num =${HOLD_TIMEOUT[$num]}"
			;;
		DYN_INTR_CFG*)
			DYNAMIC_INTR[$num]=$value
			;;
		TRUE_ENCODING_TYPE*)
			TRUE_ENCODING[$num]=$value
			;;
		X25_SRC_ADDR*)
			SRC_ADDR[$num]=$value
			#echo "X25_SRC_ADDR $num =${SRC_ADDR[$num]}"
			;;
		X25_ACCEPT_DST_ADDR*)
			X25_ACC_DST_ADDR[$num]=$value
			#echo "ACCEPT_CALLS_FROM $num =${X25_ACCEPT_CALLS_FROM[$num]}"
			;;
		X25_ACCEPT_SRC_ADDR*)
			X25_ACC_SRC_ADDR[$num]=$value
			#echo "ACCEPT_CALLS_FROM $num =${X25_ACCEPT_CALLS_FROM[$num]}"
			;;
		X25_ACCEPT_USR_DATA*)
			X25_ACC_USR_DATA[$num]=$value
			#echo "ACCEPT_CALLS_FROM $num =${X25_ACCEPT_CALLS_FROM[$num]}"
			;;

		MPPP_PROT*)
			MPPP_PROT[$num]=$value
			;;

		*) 	#echo -e "\n\nNot found *$name*"
			;;
		esac

	done < $PROD_CONF/wanpipe$DEVICE_NUM.conf 

	#------ IP Configuration ------------

	#echo "Num or interface is $NUM_OF_INTER"

	if [ $PROTOCOL = WAN_TTYPPP ] || [ $PROTOCOL = WAN_EDU_KIT ]; then
		IFS=" "
		return
	fi

	if [ $LINUX_DISTR = debian ]; then
		IFS=" "
	fi

	num=0
	while [ $num -ne $NUM_OF_INTER ]; 
	do 
		num=$((num+1))

		if [ ! -f "$INTERFACE_DIR/$NEW_IF${IF_NAME[$num]}" ];
		then 
			if [ ${OP_MODE[$num]} = WANPIPE ] || \
			   [ ${OP_MODE[$num]} = BRIDGE_NODE ]; then
				
				echo "File not found $INTERFACE_DIR/$NEW_IF${IF_NAME[$num]}"  
			fi
			continue
		fi

		IP_STATUS[$num]="Setup Done"		

		while read name value; 
		do

	 	#Conver to upper case
	  	name=`echo $name | tr a-z A-Z`

		case $name in

		*IPADDR*) 
			L_IP[$num]=$value
			#echo "L_IP=${L_IP[$num]}"
			  ;;
		*ADDRESS*)
			L_IP[$num]=$value
			#echo "L_IP=${L_IP[$num]}"
			  ;;
		*NETMASK*)
			NMSK_IP[$num]=$value
			#echo "NMSK_IP=${NMSK_IP[$num]}"
			  ;;
		*POINTOPOINT*)
			R_IP[$num]=$value
			#echo "R_IP=${R_IP[$num]}"
			  ;;
		*BROADCAST*)
			BCAST_IP[$num]=$value
			#echo "BCAST_IP=${BCAST_IP[$num]}"
			  ;;
		*GATEWAY*)
			GATE_IP[$num]=$value
			if [ ! -z ${GATE_IP[$num]} ]; then
				DEFAULT_IP[$num]=YES
			fi
			#echo "GATE_IP=${GATE_IP[$num]}"
			  ;;
		esac

		done < $INTERFACE_DIR/$NEW_IF${IF_NAME[$num]}
	done

	IFS=" "

}

function save_configuration () {

	local date=`date`
	local prot
	
	WAN_CONFIG=$PROD_CONF/wanpipe$DEVICE_NUM.conf

	cat <<EOM > $WAN_CONFIG

#================================================
# WANPIPE$DEVICE_NUM Configuration File
#================================================
#
# Date: $date
#
# Note: This file was generated automatically
#       by /usr/local/wanrouter/wancfg program.
#
#       If you want to edit this file, it is
#       recommended that you use wancfg program
#       to do so.
#================================================
# Sangoma Technologies Inc.
#================================================

EOM

	# -------------- [device] Area --------------------
	
	if [ $PROTOCOL = WAN_TTYPPP ]; then
		prot=WAN_CHDLC
	else	
		prot=$PROTOCOL
	fi

	echo "[devices]" >> $WAN_CONFIG
	echo "wanpipe$DEVICE_NUM = $prot, Comment" 	>> $WAN_CONFIG

	# -------------- [interface] Area -----------------

	if [ $PROTOCOL != WAN_TTYPPP ] && [ $PROTOCOL != WAN_EDU_KIT ]; then

		echo -e "\n[interfaces]" 			>> $WAN_CONFIG
		if_num=0
		while [ $if_num -ne $NUM_OF_INTER ]; 
		do 
			if_num=$((if_num+1))

			if [ $PROTOCOL = WAN_X25 ]; then
				if [ ${CH_TYPE[$if_num]} = PVC ]; then
					DLCI_NUM[$if_num]="${X25_ADDR[$if_num]}"
				else
					DLCI_NUM[$if_num]="@${X25_ADDR[$if_num]}"
				fi
			fi

			echo "${IF_NAME[$if_num]} = wanpipe$DEVICE_NUM, ${DLCI_NUM[$if_num]}, ${OP_MODE[$if_num]}, Comment"				  >> $WAN_CONFIG 	
		done
	fi

	# -------------- [wanpipe#] Area -------------------

	echo -e "\n[wanpipe$DEVICE_NUM]" 		>> $WAN_CONFIG
	if [ "$DEVICE_TYPE" = S514 ]; then
		echo "S514CPU 	= $S514CPU" 		>> $WAN_CONFIG
		echo "AUTO_PCISLOT	= $AUTO_PCI_CFG"    >> $WAN_CONFIG
		echo "PCISLOT 	= $PCISLOT" 		>> $WAN_CONFIG
		PCIBUS=${PCIBUS:-0}
		echo "PCIBUS		= $PCIBUS"	>> $WAN_CONFIG
	else
		echo "IOPORT 		= $IOPORT" 	>> $WAN_CONFIG
		echo "IRQ 		= $IRQ" 	>> $WAN_CONFIG
	fi

	# TE1 Output T1/E1 hardware configuration.
	if [ "$DEVICE_TE1_TYPE" = YES ]; then
		echo "MEDIA 		= $MEDIA" 	>> $WAN_CONFIG
		echo "LCODE 		= $LCODE" 	>> $WAN_CONFIG
		echo "FRAME 		= $FRAME" 	>> $WAN_CONFIG
		echo "TE_CLOCK 	= $TE_CLOCK" 		>> $WAN_CONFIG
		echo "ACTIVE_CH	= $ACTIVE_CH" 		>> $WAN_CONFIG
		if [ "$MEDIA" = T1 ]; then
			echo "LBO 		= $LBO" >> $WAN_CONFIG
		fi
	fi
	
	if [ "$DEVICE_56K_TYPE" = YES ]; then
		echo "MEDIA 		= 56K" 	>> $WAN_CONFIG
	fi

	echo "Firmware	= $FIRMWARE/$firm_name" 	>>$WAN_CONFIG

	
	if [ $PROTOCOL = WAN_EDU_KIT ]; then
		return
	fi

	
	if [ -z "$MEMORY" ]; then
		MEMORY=Auto
	fi
	if [ "$MEMORY" != Auto ]; then 
		echo "MemAddr		= $MEMORY" 	>> $WAN_CONFIG
	fi
	if [ $PROTOCOL = WAN_CHDLC ]; then
		echo "CommPort	= $COMMPORT" 		>> $WAN_CONFIG
		echo "Receive_Only	= $REC_ONLY"	>> $WAN_CONFIG
		CONNECTION=${CONNECTION:-Permanent}
		LINECODING=${LINECODING:-NRZ}
		LINEIDLE=${LINEIDLE:-Flag}
		echo "Connection	= $CONNECTION"  >> $WAN_CONFIG
		echo "LineCoding	= $LINECODING" >> $WAN_CONFIG
		echo "LineIdle	= $LINEIDLE"	>> $WAN_CONFIG
	fi
	if [ $PROTOCOL = WAN_MULTPPP ]; then
		echo "CommPort	= $COMMPORT" 		>> $WAN_CONFIG
	fi
	if [ $PROTOCOL = WAN_BITSTRM ]; then
		echo "CommPort	= $COMMPORT" 		>> $WAN_CONFIG
	fi
	if [ $PROTOCOL = WAN_TTYPPP ]; then
		if [ $TTY_MODE = Async ]; then
			echo "CommPort	= SEC" 		>> $WAN_CONFIG
		else
			echo "CommPort	= $COMMPORT" 		>> $WAN_CONFIG
		fi
		echo "TTY		= YES"		>> $WAN_CONFIG
		echo "TTY_Minor 	= $TTY_MINOR"	>> $WAN_CONFIG
		echo "TTY_Mode	= $TTY_MODE"	>> $WAN_CONFIG
	fi

	echo "Interface 	= $INTERFACE" 		>> $WAN_CONFIG

	if [ $PROTOCOL != WAN_TTYPPP ] || [ "$TTY_MODE" = Sync ]; then
		echo "Clocking 	= $CLOCKING" 			>> $WAN_CONFIG
		echo "BaudRate 	= $BAUDRATE" 			>> $WAN_CONFIG
	fi
	
	echo "MTU 		= $MTU" 		>> $WAN_CONFIG
	echo "UDPPORT 	= $UDPPORT" 			>> $WAN_CONFIG
	if [ $PROTOCOL = WAN_FR ]; then
		echo "NUMBER_OF_DLCI 	= $NUM_OF_INTER" >> $WAN_CONFIG
		echo "Station 	= $STATION" 		>> $WAN_CONFIG
		echo "Signalling 	= $SIGNAL" 	>> $WAN_CONFIG
		echo "T391 		= $T391" 	>> $WAN_CONFIG
		echo "T392 		= $T392" 	>> $WAN_CONFIG
		echo "N391 		= $N391" 	>> $WAN_CONFIG
		echo "N392 		= $N392" 	>> $WAN_CONFIG
		echo "N393 		= $N393" 	>> $WAN_CONFIG
		FR_ISSUE_FS=${FR_ISSUE_FS:-YES}
		echo "FR_ISSUE_FS	= $FR_ISSUE_FS" >> $WAN_CONFIG
	fi
	if [ $PROTOCOL = WAN_PPP ]; then
		echo "IP_MODE		= $IPMODE" 	>> $WAN_CONFIG
	fi
	if [ $PROTOCOL = WAN_X25 ]; then
		echo "Station		= $STATION" 		>> $WAN_CONFIG	
		echo "LowestPVC	= $LOW_PVC"		>> $WAN_CONFIG
		echo "HighestPVC 	= $HIGH_PVC"		>> $WAN_CONFIG
		echo "LowestSVC 	= $LOW_SVC"		>> $WAN_CONFIG
		echo "HighestSVC	= $HIGH_SVC"		>> $WAN_CONFIG
		echo "HdlcWindow	= $HDLC_WIN"		>> $WAN_CONFIG
		echo "PacketWindow	= $PACKET_WIN"		>> $WAN_CONFIG
		echo "CCITTCompat	= $CCITT"		>> $WAN_CONFIG
		echo "X25Config	= 0x0090"		>> $WAN_CONFIG
		echo "LAPB_HDLC_ONLY	= $LAPB_HDLC_ONLY"	>> $WAN_CONFIG
		echo "CALL_SETUP_LOG 	= $CALL_LOGGING"	>> $WAN_CONFIG
		echo "OOB_ON_MODEM	= $OOB_ON_MODEM"	>> $WAN_CONFIG
		echo "T1		= $X25_T1"		>> $WAN_CONFIG
		echo "T2		= $X25_T2"		>> $WAN_CONFIG
		echo "T4		= $X25_T4"		>> $WAN_CONFIG
		echo "N2		= $X25_N2"		>> $WAN_CONFIG
		echo "T10_T20		= $X25_T10_T20"		>> $WAN_CONFIG
		echo "T11_T21		= $X25_T11_T21"		>> $WAN_CONFIG
		echo "T12_T22	 	= $X25_T12_T22"		>> $WAN_CONFIG
		echo "T13_T23		= $X25_T13_T23"		>> $WAN_CONFIG
		echo "T16_T26		= $X25_T16_T26"		>> $WAN_CONFIG
		echo "T16_T26		= $X25_T16_T26"		>> $WAN_CONFIG
		echo "T28		= $X25_T28"		>> $WAN_CONFIG
		echo "R10_R20		= $X25_R10_R20"		>> $WAN_CONFIG
		echo "R12_R22		= $X25_R12_R22"		>> $WAN_CONFIG
		echo "R13_R23		= $X25_R13_R23"		>> $WAN_CONFIG
	fi

	if [ $PROTOCOL = WAN_BITSTRM ]; then
	
		echo 	>> $WAN_CONFIG
		echo "sync_options 		 = $SYNC_OPTIONS"	>> $WAN_CONFIG
		echo "rx_sync_char 		 = $RX_SYNC_CHAR" 	>> $WAN_CONFIG
		echo "monosync_tx_time_fill_char = $MSYNC_TX_TIMER" 	>> $WAN_CONFIG
		echo "max_length_tx_data_block = $MAX_TX_BLOCK" 	>> $WAN_CONFIG
		echo "rx_complete_length 	 = $RX_COMP_LEN" 	>> $WAN_CONFIG
		echo "rx_complete_timer 	 = $RX_COMP_TIMER" 	>> $WAN_CONFIG
		echo 	>> $WAN_CONFIG
	fi


	echo "TTL 		= $TTL" 		>> $WAN_CONFIG

	IGNORE_FRONT_END=${IGNORE_FRONT_END:-NO}
	echo "IGNORE_FRONT_END  = $IGNORE_FRONT_END" 	>> $WAN_CONFIG

	if [ $PROTOCOL = WAN_TTYPPP ]; then
		return
	fi

	if [ $PROTOCOL = WAN_BITSTRM ]; then
		return
	fi


	#--------- [wp#_<protocol>] area ----------------------------
			
	if_num=0
	while [ $if_num -ne $NUM_OF_INTER ];
	do
		if_num=$((if_num+1))

		case  $PROTOCOL in

		WAN_FR)
			echo >> $WAN_CONFIG
			echo "[${IF_NAME[$if_num]}]" >> $WAN_CONFIG
			if [ -z "${CIR[$if_num]}" ]; then
				CIR[$if_num]=NO
			fi
			if [ ${CIR[$if_num]} != NO ]; then
				echo "CIR 		= ${CIR[$if_num]}" >> $WAN_CONFIG
				echo "BC  		= ${BC[$if_num]}" >> $WAN_CONFIG
				echo "BE  		= ${BE[$if_num]}" >> $WAN_CONFIG
			fi
			echo "MULTICAST 	= ${MULTICAST[$if_num]}" >> $WAN_CONFIG
			echo "INARP 		= ${INARP[$if_num]}" >> $WAN_CONFIG
			echo "INARPINTERVAL 	= ${INARP_INT[$if_num]}" >> $WAN_CONFIG
			
			INARP_RX[$if_num]=${INARP_RX[$if_num]:-NO}
			
			echo "INARP_RX	= ${INARP_RX[$if_num]}" >> $WAN_CONFIG
			echo "IPX		= ${IPX[$if_num]}" >> $WAN_CONFIG
			if [ ${IPX[$if_num]} = YES ]; then
				echo "NETWORK		= ${NETWORK[$if_num]}"  >> $WAN_CONFIG
			fi
			echo "TRUE_ENCODING_TYPE	= ${TRUE_ENCODING[$if_num]}" >> $WAN_CONFIG
			;;
		WAN_PPP)
			echo >> $WAN_CONFIG
			echo "[${IF_NAME[$if_num]}]" 		>> $WAN_CONFIG	
			echo "MULTICAST 	= ${MULTICAST[$if_num]}">> $WAN_CONFIG
			echo "PAP       	= ${PAP[$if_num]}" 	>> $WAN_CONFIG
			echo "CHAP		= ${CHAP[$if_num]}" 	>> $WAN_CONFIG
			echo "IPX		= ${IPX[$if_num]}" 	>> $WAN_CONFIG
			if [ ${IPX[$if_num]} = YES ]; then
				echo "NETWORK		= ${NETWORK[$if_num]}"  >> $WAN_CONFIG
			fi

			if [ ${PAP[$if_num]} = YES -o ${CHAP[$if_num]} = YES ]; then
				echo "USERID 	= ${USERID[$if_num]}" 	>> $WAN_CONFIG
				echo "PASSWD   	= ${PASSWD[$if_num]}" 	>> $WAN_CONFIG
				echo "SYSNAME  	= ${SYSNAME[$if_num]}" 	>> $WAN_CONFIG
			fi
			;;
		WAN_CHDLC)
			echo >> $WAN_CONFIG
			echo "[${IF_NAME[$if_num]}]" 			>> $WAN_CONFIG	
			echo "MULTICAST		= ${MULTICAST[$if_num]}">> $WAN_CONFIG
			echo "IGNORE_DCD		= ${DCD[$if_num]}" 	>> $WAN_CONFIG
			echo "IGNORE_CTS		= ${CTS[$if_num]}" 	>> $WAN_CONFIG
			echo "IGNORE_KEEPALIVE	= ${KEEP[$if_num]}" 	>> $WAN_CONFIG
			echo "HDLC_STREAMING		= ${STREAM[$if_num]}" 	>> $WAN_CONFIG
			echo "KEEPALIVE_TX_TIMER	= ${TXTIME[$if_num]}" 	>> $WAN_CONFIG
			echo "KEEPALIVE_RX_TIMER	= ${RXTIME[$if_num]}" 	>> $WAN_CONFIG
			echo "KEEPALIVE_ERR_MARGIN	= ${ERR[$if_num]}"	>> $WAN_CONFIG
			echo "SLARP_TIMER		= ${SLARP[$if_num]}"	>> $WAN_CONFIG
			echo "TRUE_ENCODING_TYPE	= ${TRUE_ENCODING[$if_num]}" >> $WAN_CONFIG
			;;
		WAN_MULTPPP)
			echo >> $WAN_CONFIG
			echo "[${IF_NAME[$if_num]}]" 			>> $WAN_CONFIG	
			echo "HDLC_STREAMING	= YES" 	>> $WAN_CONFIG
			
			MPPP_PROT[$if_num]=${MPPP_PROT[$if_num]:-MP_PPP}
			MPPP_MODEM_IGNORE[$if_num]=${MPPP_MODEM_IGNORE[$if_num]:-YES}
			
			echo "MPPP_PROT	= ${MPPP_PROT[$if_num]}" >>$WAN_CONFIG
			echo "IGNORE_DCD	= ${MPPP_MODEM_IGNORE[$if_num]}" >>$WAN_CONFIG 
			
			echo "IGNORE_CTS	= ${MPPP_MODEM_IGNORE[$if_num]}" >>$WAN_CONFIG
			;;

		WAN_X25)
			echo >> $WAN_CONFIG
			echo "[${IF_NAME[$if_num]}]" 		>> $WAN_CONFIG	
			if [ ${OP_MODE[$if_num]} = WANPIPE ] && [ ${CH_TYPE[$if_num]} = SVC ]; then
				echo "IdleTimeout 	= ${IDLE_TIMEOUT[$if_num]}" >> $WAN_CONFIG
				echo "HoldTimeout 	= ${HOLD_TIMEOUT[$if_num]}" >> $WAN_CONFIG

				if [ ! -z ${SRC_ADDR[$if_num]} ]; then
				echo "X25_SRC_ADDR      = ${SRC_ADDR[$if_num]}" >> $WAN_CONFIG
				else
				echo "#X25_SRC_ADDR      =" >> $WAN_CONFIG
				fi
		
				if [ ! -z "${X25_ACC_DST_ADDR[$if_num]}" ]; then
				echo "X25_ACCEPT_DST_ADDR = ${X25_ACC_DST_ADDR[$if_num]}" >> $WAN_CONFIG
				else
				echo "#X25_ACCEPT_DST_ADDR =" >> $WAN_CONFIG
				fi
				
				if [ ! -z "${X25_ACC_SRC_ADDR[$if_num]}" ]; then
				echo "X25_ACCEPT_SRC_ADDR = ${X25_ACC_SRC_ADDR[$if_num]}" >> $WAN_CONFIG
				else
				echo "#X25_ACCEPT_SRC_ADDR =" >> $WAN_CONFIG
				fi
				
				if [ ! -z "${X25_ACC_USR_DATA[$if_num]}" ]; then
				echo "X25_ACCEPT_USR_DATA = ${X25_ACC_USR_DATA[$if_num]}" >> $WAN_CONFIG
				else
				echo "#X25_ACCEPT_USR_DATA =" >> $WAN_CONFIG
				fi
			fi
			;;
		*)
			;;
		esac


		DYNAMIC_INTR[$if_num]=${DYNAMIC_INTR[$if_num]:-NO}
		DEFAULT_IP[$if_num]=${DEFAULT_IP[$if_num]:-NO}

		if [ ${OP_MODE[$if_num]} = WANPIPE -a $PROTOCOL != WAN_X25 ]; then 
			echo "DYN_INTR_CFG	= ${DYNAMIC_INTR[$if_num]}"  >> $WAN_CONFIG	
		fi

		if [ ${DEFAULT_IP[$if_num]} = YES -a $PROTOCOL != WAN_X25 ]; then
			echo "GATEWAY		= YES"		    >> $WAN_CONFIG
		fi
	
	done		

	if_num=0
	while [ $if_num -ne $NUM_OF_INTER ];
	do
		if_num=$((if_num+1))

		if [ ${OP_MODE[$if_num]} = API ] || [ ${OP_MODE[$if_num]} = BRIDGE ]; then
			continue
		fi	

		if [ ${OP_MODE[$if_num]} = "BRIDGE_NODE" ]; then
			R_IP[$if_num]=" "
		fi

		date=`date`
	
		if [ $LINUX_DISTR = debian ]; then
	
			cat <<EOM > $INTERFACE_DIR/"$NEW_IF"${IF_NAME[$if_num]}
# Wanrouter interface configuration file
# name:	${IF_NAME[$if_num]}
# date:	$date
#
iface ${IF_NAME[$if_num]} inet static
	address ${L_IP[$if_num]}
	netmask ${NMSK_IP[$if_num]}
	pointopoint ${R_IP[$if_num]}
EOM

			if [ ${DEFAULT_IP[$if_num]} = YES ]; then
				cat <<EOM >> $INTERFACE_DIR/"$NEW_IF"${IF_NAME[$if_num]}
	gateway ${GATE_IP[$if_num]}
EOM
			fi

		else
		
		cat <<EOM > $INTERFACE_DIR/"$NEW_IF"${IF_NAME[$if_num]}
# Wanrouter interface configuration file
# name:	${IF_NAME[$if_num]}
# date:	$date
#
DEVICE=${IF_NAME[$if_num]}
IPADDR=${L_IP[$if_num]}
NETMASK=${NMSK_IP[$if_num]}
POINTOPOINT=${R_IP[$if_num]}
ONBOOT=yes
EOM
		
			if [ ${DEFAULT_IP[$if_num]} = YES ]; then
				cat <<EOM >> $INTERFACE_DIR/"$NEW_IF"${IF_NAME[$if_num]}
GATEWAY=${GATE_IP[$if_num]}
EOM
			fi

		
		fi
	done
}


auto_intr_config ()
{
	local num
	local name

	while true
	do
		interface_menu 1
		rc=$?
		if [ $rc -eq 1 ]; then
			break;
		fi
	done

	PROT_STATUS[1]="Setup Done"
	INTR_STATUS[1]="setup"

	case $PROTOCOL in
	WAN_FR)
		name="wp"$DEVICE_NUM"_fr"
		;;
	WAN_X25)
		if [ ${CH_TYPE[1]} = SVC ]; then
			name="wp"$DEVICE_NUM"_svc"
		else
			name="wp"$DEVICE_NUM"_pvc"
		fi
		;;
	esac

	num=1;
	while [ $num -ne $NUM_OF_INTER ];
	do
		num=$((num+1))
	
		OP_MODE[$num]=${OP_MODE[1]}
		PROT_STATUS[$num]=${PROT_STATUS[1]}
		IP_STATUS[$num]=${IP_STATUS[1]}
		INTR_STATUS[$num]=${INTR_STATUS[1]}
			
		case $PROTOCOL in

		WAN_FR)	
			DLCI_NUM[$num]=$((DLCI_NUM[1]+$num-1))	
			name="wp"$DEVICE_NUM"_fr"${DLCI_NUM[$num]}
			IF_NAME[$num]=$name
			CIR[$num]=${CIR[1]}
			BC[$num]=${BC[1]}
			BE[$num]=${BE[1]}
			MULTICAST[$num]=${MULTICAST[1]}	
			INARP[$num]=${INARP[1]}
			INARP_INT[$num]=${INARP_INT[1]}
			INARP_RX[$num]=${INAR_RX[1]}
			;;
	
		WAN_X25)
			IF_NAME[$num]=$name$num
			IDLE_TIMEOUT[$num]=${IDLE_TIMEOUT[1]}
			HOLD_TIMEOUT[$num]=${HOLD_TIMEOUT[1]}
			SRC_ADDR[$num]=${SRC_ADDR[1]}
			X25_ACCEPT_CALLS_FROM[$num]=${X25_ACCEPT_CALLS_FROM[1]}
			if [ ${CH_TYPE[1]} = PVC ]; then
				X25_ADDR[$num]=$((X25_ADDR[1]+$num-1))
			else
				X25_ADDR[$num]=${X25_ADDR[1]}
			fi
			CH_TYPE[$num]=${CH_TYPE[1]}
			;;
		esac	
		
	done 
}

