/*****************************************************************************
* debug.c	X25API: Debugging Application
*
* Author(s):	Gideon Hack & Nenad Corbic <ncorbic@sangoma.com>
*
* Copyright:	(c) 1995-2000 Sangoma Technologies Inc.
*
*		This program is free software; you can redistribute it and/or
*		modify it under the terms of the GNU General Public License
*		as published by the Free Software Foundation; either version
*		2 of the License, or (at your option) any later version.
* ============================================================================
*/

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/socket.h>
//#include <linux/socket.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <time.h>
#include <netinet/in.h>
#include <linux/if_wanpipe.h>
#include <string.h>
#include <errno.h>
#include <linux/wanpipe.h>
#include <linux/sdla_x25.h>
#include <linux/if_ether.h>

#define FALSE	0
#define TRUE	1

#define MIN_FRM_LGTH	100	
#define MAX_FRM_LGTH  	1400
#define NO_FRMS_TO_TX   10	

#define MAX_X25_ADDR_SIZE	16
#define MAX_X25_DATA_SIZE 	129
#define MAX_X25_FACL_SIZE	110

unsigned char Tx_data[MIN_FRM_LGTH + sizeof(x25api_hdr_t)];

unsigned char Rx_data[1000];

/* Prototypes */
int MakeConnection(void);
void send_socket( void);
void setup_signal_handlers (void);
void quit (int);

int 			sock, sock1;
fd_set 			writeset,readset,oobset;
struct wan_sockaddr_ll 	sa;
pid_t			pid_number;
int	quit_now=0;
int 	packet_ack=0;
sigset_t set0, set31;
x25api_t 	api_cmd;

char * state_decode [] ={ "WANSOCK_UNCONFIGURED", 
		          "WANSOCK_DISCONNECTED", 
		          "WANSOCK_CONNECTING",
		          "WANSOCK_CONNECTED",
		          "WANSOCK_LIMIT",
		          "WANSOCK_DUALPORT",
		          "WANSOCK_DISCONNECTING",
		          "WANSOCK_BINDED",
		          "WANSOCK_BIND_LISTEN",
		          "WANSOCK_LISTEN" };						  	

/***************************************************************
 * Main:
 *
 *    o Make a socket connection to the driver.
 *
 **************************************************************/   

int main(int argc, char* argv[])
{
	int proceed;
	
	proceed = MakeConnection();
	return 0;
};


/***************************************************
* MakeConnection
*
*   o Create a Socket
*   o List all x25api sockets 
*/         

int MakeConnection (void) 
{
	int err = 0, i;
	wan_debug_t dbg;

	memset(&dbg,0,sizeof(wan_debug_t));

	errno = 0;
   	sock = socket( AF_WANPIPE, SOCK_RAW, 0);
   	if( sock < 0 ) {
      		perror("Socket");
      		return( FALSE );
   	} 
 
	if ((err=ioctl(sock,SIOC_WANPIPE_DEBUG,&dbg)) < 0){
		printf ("Debug ioctl call failed\n");
	}

	i=0;
	for (;;){
		if (!dbg.debug[i].free)
			break;
		
		printf("Socket %i :\n",i);
		printf("\tState: %s\n",state_decode[dbg.debug[i].sk_state]);

		printf("\tReceive Buff usage: %i\n",dbg.debug[i].rmem);
		printf("\tWrite Buff usage: %i\n",dbg.debug[i].wmem);
		printf("\tNumber of socks: %i\n",dbg.debug[i].sk_count);
		printf("\tSock bound to driver: %s\n",
				dbg.debug[i].bound ? "YES" : "NO");
	
		if (dbg.debug[i].bound){

			printf("\t\tBound interface name:  %s\n",
					dbg.debug[i].name);
			printf("\t\tDriver state: %s\n",
					state_decode[dbg.debug[i].d_state]);

			printf("\t\tChannel type: %s\n",
					dbg.debug[i].svc ? "SVC":"PVC");

			printf("\t\tBound to lcn: %i\n",dbg.debug[i].lcn);
			printf("\t\tMbox exists: %s\n",
					dbg.debug[i].mbox ? "YES":"NO");
			printf("\t\tCommand Busy: %i\n",dbg.debug[i].cmd_busy);
			printf("\t\tCommand Exec: %x\n",dbg.debug[i].command);
			printf("\t\tReceive block: %s\n",
					dbg.debug[i].rblock ? "YES":"NO");
			printf("\t\tPoll Count: %i\n",
					dbg.debug[i].poll_cnt);
		}
		i++;
	}

	if (i == 0)
		printf("\nNo Active Sockets\n\n");

	return( TRUE );
}

